<?php
//---------------------------------------------------------------------------------------
// ibProArcade v2.7.6+ by MrZeropage (for vBulletin 3.x and 4.x)
// the professional arcade modification for vBulletin
//
// vBulletin-version developed by MrZeropage (starting with v2.5.3+ in december 2005)
// vBulletin-AdminCP for ibProArcade Copyright by MrZeropage
//
// Original ibProArcade v2.5.1  Chris Kelly 2004 www.ibproarcade.com                  
// Creator and Lead Developer: Chris Kelly                                        
// Co-Devoloper: Elijah Gallatin                                                    
//---------------------------------------------------------------------------------------
// Contributers                                                   
//  tubesock, stlmike, stangger5, MarkFL, Dave
//  and maaaaany others supporting this project, thanks so much guys!
//----------------------------------------------------------------------------------------
// Thanks to everybody who helped during development or the extensive test-phase
// English support -> http://www.vbulletin.org/forum/forumdisplay.php?f=170 
//
// Make sure not to use any converted Game that has no permission from its author !  
//----------------------------------------------------------------------------------------

// #################################################################################
// ### some global switches - only change if you are told to for support-reasons ###
// #################################################################################

$DEBUGMODE	  = 0;		// 0 = off / 1 = enable the debugmode / 2 = verbose debugging (support only!)
$NATIVEMODE	  = 0;		// set this to 1 to disable all Hooks/PlugIns within ibProArcade
$LOGIPS		  = 1;		// set this to 0 to disable logging of IP-addresses

$AVATARRESIZE 	  = 0;		// set this to 0 to disable resizing of avatars or problems with getimagesize()
$FIXSTYLE	  = 0;		// set this to 1 if you get empty pages (tournament-creation ect.)
$FIXIE		  = 1;		// current workaround to fix problems with IE7
$CONNECTFIX	  = 0;          // if you experience "connection refused" with mysqli-database, set this to 1

// ##########################################
// ### !! DO NOT CHANGE ANYTHING BELOW !! ###
// ##########################################

// #################### Add v3arcade Game Support ########################
if (isset($_POST['sessdo']))
{
	if($_POST['sessdo'] == "sessionstart")
	{
	        $gamerand = rand(1,10);
	        $gametime = mktime();
		$lastid   = $_POST['gamename'];
	        echo "&connStatus=1&initbar=$gamerand&gametime=$gametime&lastid=$lastid&result=OK";
	        exit;
	}

	if($_POST['sessdo'] == "permrequest")
	{
	        $microone = microtime();
	        setcookie("v3score", $_POST['score']);
	        echo "&validate=1&microone=$microone&result=OK";
	        exit;
	}
}

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// ################## Page-Refresher while playing #######################
if ($_GET['do'] == "holdsession")
{
	include ("./holdsession.php");
	exit;
}

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('NO_REGISTER_GLOBALS', 1);
define('THIS_SCRIPT', 'arcade');
define('ROOT_PATH' , "./" );
define('CAT_IMGS' , "./arcade/cat_imgs/" );
define('MODULE_PATH' , "./arcade/modules/" );
define('FUNCTIONS_PATH', "./arcade/functions/");
define('PATH', (($getcwd = getcwd()) ? $getcwd : '.'));

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array();

// get special data templates from the datastore
$specialtemplates = array();

// pre-cache templates used by specific actions
$actiontemplates = array();

// pre-cache templates used by all actions
$globaltemplates = array('ARCADE');

// ######################### REQUIRE BACK-END ############################ 
include_once "./global.php";

setcookie('ibPAcookiecheck', "yesss");

$vbversion = substr($vboptions[templateversion],0,3);
if ($vbversion != "3.0")
{
	// make some legacy-variables compatible to vBulletin 3.5.x
	$vboptions[forumhome]	= $vbulletin->options[forumhome];
	$vboptions[bburl]	= $vbulletin->options[bburl];

	if ($NATIVEMODE==0)
	{
		($hook = vBulletinHook::fetch_hook('ibproarcade_global_start')) ? eval($hook) : false;
	}
}

class info {

        var $member     = array();
        var $input      = array();
        var $session_id = "";
        var $base_url   = "";
        var $vars       = "";
        var $skin_id    = "0";     
        var $skin_rid   = "";      
        var $lang_id    = "en";
        var $skin       = "";
        var $lang       = "";
        var $server_load = 0;
        var $version    = "v1.3 Final";
        var $lastclick  = "";
        var $location   = "";
        var $debug_html = "";
        var $perm_id    = "";
        var $forum_read = array();
        var $topic_cache = "";
        var $session_type = "";

        public function __construct()
        { 
          global $sess, $std, $DB, $INFO, $vboptions, $vbulletin, $session; 

          $this->vars = &$INFO; 
          $this->vars['board_name'] = $vboptions['bbtitle']; 
        } 

        function info()
        { 
          self::__construct(); 
        } 
}

include ROOT_PATH . "includes/config.php";

require FUNCTIONS_PATH . "functions.php";

$std   = new FUNC;
$print = new display();
$sess  = new session();

$skin_universal = $std->load_template('skin_global');

// connection to database
if ($config['Database']['dbtype'] == 'mysql') 
{ 
  $sql_driver = FUNCTIONS_PATH . "dbclass.php"; 
} 
else 
{ 
  $sql_driver = FUNCTIONS_PATH . "dbclass_mysqli.php"; 
} 

if ($CONNECTFIX==1)
{
  // this fixes the problem with connection to localhost:3306 on mysqli-database-driver
  $config['MasterServer']['port'] = "";
  $port                           = "";
}

require $sql_driver; 
$DB = new db_driver;  

// automatic vB-Version-Detection by MrZeroage
$vbversion = substr($vboptions[templateversion],0,3);
if ($vbversion == "3.0")
{
	// DB-Access for vBulletin 3.0.x
	$DB->obj['sql_database']     = $dbname;
	$DB->obj['sql_user']         = $dbusername;
	$DB->obj['sql_pass']         = $dbpassword;
	$DB->obj['sql_host']         = $servername;
	$DB->obj['sql_port']         = $port;
	$DB->obj['sql_tbl_prefix']   = $tableprefix;
	$DB->connect();
	// End DB Connectivity
	unset($dbname, $dbusername, $dbpassword, $servername);
}
else
{
	// DB-Access for vBulletin 3.5.x
	$DB->obj['sql_database']     = $config['Database']['dbname'];
	$DB->obj['sql_user']         = $config['MasterServer']['username'];
	$DB->obj['sql_pass']         = $config['MasterServer']['password'];
	$DB->obj['sql_host']         = $config['MasterServer']['servername'];
	$DB->obj['sql_port']         = $config['MasterServer']['port'];
	$DB->obj['sql_tbl_prefix']   = $config['Database']['tableprefix'];
	$DB->connect();
	// End DB Connectivity
	unset($config['Database']['dbname'], $config['MasterServer']['username'], $config['MasterServer']['password'], $config['Database']['tableprefix']);
}

//--------------------------------
// Wrap it all up in a nice easy to
// transport super class
//--------------------------------

$ibforums = new info();

//--------------------------------
//  Set up our vars
//--------------------------------

$ibforums->input = $std->parse_incoming();

if ($vbversion == "3.0")
{ $forumpath = $vboptions[bburl]; $sess = $session['sessionurl']; }
else
{ $forumpath = $vbulletin->options[bburl]; $sess = $vbulletin->session->vars['sessionurl']; }

// fix for lousy configurated vBulletin options as this eats some time in support...
if (strpos($forumpath,"index.php")===false)
{
	// seems to be correct
}
else
{
	$forumpath = str_replace("/index.php", "", $forumpath);
}

$ibforums->vars['base_url'] = $forumpath . "/" . "arcade.php?".$sess."&amp;";
$ibforums->base_url = $forumpath . "/" . "arcade.php?".$sess."&amp;";

foreach($_POST as $key => $value) {
        $ibforums->input[$key] = $value;
}
foreach($_GET as $key => $value) {
        $ibforums->input[$key] = $value;
}

$ibforums->input['keepsess'] = 0;	// for PNflashgames to keep their session

// handle calls from v3arcade links
if (($ibforums->input['categoryid']!="") && (intval($ibforums->input['categoryid'])>0))
{
	$ibforums->input['cat'] = $ibforums->input['categoryid'];
}
$ibforums->input['cat'] = intval($ibforums->input['cat']);

// define possible Guest-Player-ID
$guestplayerid=0;
$DB->query("SELECT arcade_access, p_require FROM ibf_groups WHERE g_id = 1");
$guestperm = $DB->fetch_row();
if ($guestperm['arcade_access']==4)
{
	if (intval($guestperm['p_require'] > 0))
	{ $guestplayerid = $guestperm['p_require']; }
}

// DEBUG-Mode v1.1 by MrZeropage
$DEBUGPAGE = "";
if ($ibforums->input['debug']=="yes")
{
	if ($DEBUGMODE!=0)
	{
		$DEBUGPAGE .= "<table>";
		$DEBUGPAGE .= "<tr colspan='3'><td><b><u>DEBUG-Information</u></b></td></tr>";
		$DEBUGPAGE .= "<tr><td>vboptions[forumhome]</td><td>&nbsp;&nbsp;</td><td>".$vboptions[forumhome]."</td></tr>";
		$DEBUGPAGE .= "<tr><td>vboptions[bburl]</td><td>&nbsp;&nbsp;</td><td>".$vboptions[bburl]."</td></tr>";
        $DEBUGPAGE .= "<tr><td>SQL-driver</td><td>&nbsp;&nbsp;</td><td>".$config['Database']['dbtype']."</td></tr>";
		$DEBUGPAGE .= "<tr><td>TABLE_PREFIX</td><td>&nbsp;&nbsp;</td><td>".TABLE_PREFIX."</td></tr>";
        $DEBUGPAGE .= "<tr><td>Serverpath</td><td>&nbsp;&nbsp;</td><td>".$_SERVER['DOCUMENT_ROOT']."</td></tr>";
        $DEBUGPAGE .= "<tr><td>Forumpath</td><td>&nbsp;&nbsp;</td><td>".getcwd()."</td></tr>";
		if ($vboptions[templateversion]!="")
		{
			$DEBUGPAGE .= "<tr><td>vboptions[templateversion]</td><td>&nbsp;&nbsp;</td><td>".$vboptions[templateversion]."</td></tr>";
		}
		else
		{
			$DEBUGPAGE .= "<tr><td>vbulletin->options[templateversion]</td><td>&nbsp;&nbsp;</td><td>".$vbulletin->options[templateversion]."</td></tr>";
		}
        $DEBUGPAGE .= "<tr><td>PHP-Version</td><td>&nbsp;&nbsp;</td><td>".phpversion()."</td></tr>";
	}
}

if ($vbversion == "3.0")
{
	// vBulletin 3.0.x
	if(isset($bbuserinfo['userid']) && !empty($bbuserinfo['userid']))
	{
        	$ibforums->member['id'] = $bbuserinfo['userid'];
	} 
	else
	{
        	$ibforums->member['id'] = $guestplayerid;
	}
}
else
{
	// vBulletin 3.5.x
	if(isset($vbulletin->userinfo['userid']) && !empty($vbulletin->userinfo['userid']))
	{
		$ibforums->member['id'] = $vbulletin->userinfo['userid'];
	} 
	else
	{
		$ibforums->member['id'] = $guestplayerid;
	}
}

if($_POST['sessdo'] == "burn")
{
	$gamename = ibp_cleansql($_POST['id']);
	$cheat=0;

	$getgameidquery = $DB->query("SELECT gid FROM ibf_games_list WHERE gname='".$gamename."'");
	$getgameid = $DB->fetch_row($getgameidquery);
	$gameid = $getgameid['gid'];

	if ($guestplayerid != $ibforums->member['id'])
	{
		// this is not a guest playing
		$userquery = $DB->query("SELECT * FROM ibf_user WHERE userid=".$ibforums->member['id']);
		$userinfo = $DB->fetch_row($userquery);

		if ($userinfo['arcade_session']=="")
		{
			$ERRORLEVEL = ($DEBUGMODE == 0) ? "" : "Error #020 - no session";
			$std->Error( array( LEVEL => 1, MSG => 'cheater', EXTRA => $ERRORLEVEL) );
		}

		// check if there is a stored session for that gameid
		$DB->query("SELECT * FROM ibf_games_session WHERE sessid='".$userinfo['arcade_session']."' LIMIT 1");
		$vs = $DB->fetch_row();
		if ( ($vs['gameid'] != $_COOKIE['gidstarted']) || ($gameid != $vs['gameid']) )
		{
			// cheat! so eliminate the result *g*
			$cheat++;
			$VERBOSE = ($DEBUGMODE == 2) ? " -> vs_gid=".$vs['gameid']." | cookie_gid=".$_COOKIE['gidstarted']." | gameid=".$gameid : "";
			$ERRORLEVEL = ($DEBUGMODE == 0) ? "" : "Error #001";
			$ERRORLEVEL = $ERRORLEVEL . $VERBOSE;
			$std->Error( array( LEVEL => 1, MSG => 'cheater', EXTRA => $ERRORLEVEL) );
		}
	}
	else
	{
		// this is a guest!
		$userinfo['arcade_session'] = intval($_COOKIE['guestsession']);
	}

	$_POST['gname'] = $gamename;
    $_POST['gscore'] = ibp_cleansql($_COOKIE['v3score']);

    $ibforums->input['do'] = "newscore";
}

class Arcade
{
    var $output         = "";
    var $html           = "";
    var $page_title     = "";
    var $nav            = array();
    var $parser         = "";
    var $arcade         = array();
    var $version        = "2.7.6+";
    var $updatecheck	= "http://premiumcode.de/_script/ibproarcade_versioncheck.php"; // do not change this !!
    var $BFL 		    = false;

    public function __construct()
    {
      global $ibforums, $DB, $std, $print, $DEBUGPAGE, $DEBUGMODE, $vbulletin, $vboptions;

      require MODULE_PATH."mod_arcade.php";
      $this->arcade = new mod_arcade;
      $this->arcade->authorize();

      if (($vbversion != "3.0") && ($NATIVEMODE==0))
      {
        ($hook = vBulletinHook::fetch_hook('ibproarcade_settings')) ? eval($hook) : false;
      }

	  // load the language set in AdminCP (by MrZeropage)
	  $ibforums->langid = $this->arcade->settings['arcade_language'];
	  $langfile="lang_Arcade_".$ibforums->langid;
	  $ibforums->lang = $std->load_words($ibforums->lang, $langfile, $ibforums->lang_id );

      if( $this->arcade->settings['skin'] == 0 )
      {
        $this->html = $std->load_template('skin_Arcade');
      }
      else
      {
        $this->html = $std->load_template('skin_v3Arcade');
      }

	// hand some main setting to LANG to reach functions.php
	$ibforums->lang['htmltitle'] = ($this->arcade->settings['htmltitle']) ? $this->arcade->settings['htmltitle'] : "%FORUMNAME% - %IBPRO% - %ACTION%";

    $this->arcade->top_links($this->html);
    $this->output .= $this->arcade->extra_links;

	if ($ibforums->input['debug']=="yes")
	{
		if ($DEBUGMODE!=0)
		{
			$DEBUGPAGE .= "<tr><td>ibProArcade</td><td>&nbsp;&nbsp;</td><td>".$this->version."</td></tr>";
			$DEBUGPAGE .= "<tr><td>score_type</td><td>&nbsp;&nbsp;</td><td>".$this->arcade->settings['score_type']."</td></tr>";
			$DEBUGPAGE .= "<tr><td>use_cats</td><td>&nbsp;&nbsp;</td><td>".$this->arcade->settings['use_cats']."</td></tr>";
			$DEBUGPAGE .= "<tr><td>def_cat</td><td>&nbsp;&nbsp;</td><td>".$this->arcade->settings['def_cat']."</td></tr>";
			$DEBUGPAGE .= "<tr><td>cats_per_tr</td><td>&nbsp;&nbsp;</td><td>".$this->arcade->settings['cats_per_tr']."</td></tr>";
			$DEBUGPAGE .= "<tr><td>crown_type</td><td>&nbsp;&nbsp;</td><td>".$this->arcade->settings['crown_type']."</td></tr>";
			$DEBUGPAGE .= "<tr><td>show_crowns</td><td>&nbsp;&nbsp;</td><td>".$this->arcade->settings['show_crowns']."</td></tr>";
			$DEBUGPAGE .= "<tr><td>show_t_won</td><td>&nbsp;&nbsp;</td><td>".$this->arcade->settings['show_t_won']."</td></tr>";
			$DEBUGPAGE .= "<tr><td>notification</td><td>&nbsp;&nbsp;</td><td>".$this->arcade->settings['notification']."</td></tr>";
			$DEBUGPAGE .= "<tr><td>auto_prune</td><td>&nbsp;&nbsp;</td><td>".$this->arcade->settings['auto_prune']."</td></tr>";
		}
		$DEBUGPAGE .= "</table>";
		$this->output .= $DEBUGPAGE."<br />";
	}

        if( isset($ibforums->input['module']) && $ibforums->input['module'] != "arcade" )
        {
            return;
        }
        else
        {
            switch( $ibforums->input['do'] )
            {
                case 'rate':
                    $this->rate();
                    break;
                case 'play':
                    $this->arcade->play_game_authorize();
                    $this->play_game();
                    break;
                case 'playfull':
                    $this->arcade->play_game_authorize();
                    $this->playfull();
                    break;
                case 'newscore':
                    $this->post_score();
                    break;
                case 'stats':
                    $this->show_stats();
                    break;
                case 'viewtournaments':
                    $this->view_tournaments();
                    break;
                case 'playtourney':
                    $this->play_tourney();
                    break;
                case 'viewtourney':
                    $this->view_tourney($ibforums->input['tid']);
                    break;
				case 'createtourney':
					$this->create_tourney();
					break;
				case 'registertourney':
					$this->register_tourney($ibforums->input['tid']);
					break;
				case 'docreatetourney':
					$this->do_create_tourney();
					break;
				case 'disqualtourney':
					$this->disqual_tournoi($ibforums->input['tid'], $ibforums->input['rung'], $ibforums->input['faceoff'], $ibforums->input['mid']);
					break;
				case 'corigetourney':
					$this->corige_tournoi($ibforums->input['tid'], $ibforums->input['rung'], $ibforums->input['faceoff']);
					break;
				case 'viewtourneyend':
					$this->view_tourney_end();
					break;
   				case 'pnFStoreScore':
                    $this->pnFlashGames_StoreScore();
                    break;
   				case 'pnFSaveGame':
                    $this->pnFlashGames_SaveGame();
                    break;
   				case 'pnFLoadGame':
                    $this->pnFlashGames_LoadGame();
                    break;
				case 'verifyscore':
					$this->verify_score();
					break;
				case 'savescore':
					$this->save_score();
					break;
                default:
                    $this->show_games();
                    break;
            }

            $action = (isset($ibforums->input['do'])) ? $ibforums->input['do'] : 'glist';
            $show_users = unserialize($this->arcade->settings['show_active']);
            if( $show_users[$action] != 0 )
            {
                    $this->arcade->get_active($this->html);
                    $this->output .= $this->arcade->active;
            }

            if (!$BFL)
            {
              $this->output .= "<div align='center' style='font-size: 8pt;'>ibProArcade v".$this->version."<br />vBulletin-Version &copy; 2005-".date('Y')." by MrZeropage (<a href='http://premiumcode.de/produkte/ibproarcade/";
              if ($this->arcade->settings[arcade_language] != "de") { $this->output .= "en/"; }
              $this->output .= "' target='_blank' title='premiumcode.de'>premiumcode.de</a>)<br /> 
              HTML5 Game Mod by <a href='https://next-level-arcade.com' target='_blank' title='stangger5'>stangger5</a></div><br />";
            }
            else
            {
              $this->output .= "<!-- ibProArcade v".$this->version." (C) MrZeropage http://premiumcode.de -->";
            }

            $print->add_output($this->output);
            $print->do_output( array( 'TITLE' => $this->page_title, 'JS' => 0, NAV => $this->nav ) );
        }

    }

    function Arcade() 
    { 
        self::__construct(); 
    }

        //------------------------------------------
        // View_Tourney
        //
        // This will show a specific tournament
        //
        //------------------------------------------
        function view_tourney($tid)
        {
			global $ibforums, $DB, $std;
			include("arcade/modules/arcade_tournament.php");
        }

        //-----------------------------------
        // View_Tournaments
        //
        // This will show a listing of all
        //  currently active Tournaments
        //
        //-----------------------------------

        function view_tournaments()
        {
			global $ibforums, $DB, $std, $vbulletin, $vboptions, $NATIVEMODE;
			include("arcade/modules/arcade_tournaments.php");
		}

        function define_ladder($rung, $playerinfo, $tdclass)
        {
			global $ibforums;
			include("arcade/modules/arcade_tournaments_ladder.php");
			return $ladderhtml;
        }

        //------------------------------------------
        // Show_Games
        //
        // This shows the list of games available
        //
        //------------------------------------------

        function show_games()
        {
			global $ibforums, $DB, $std, $vbulletin, $vboptions, $NATIVEMODE;
			include("arcade/modules/arcade_showgames.php");
        }

        //------------------------------------------
        // Play_Game
        //
        // This brings up the game to play
        //
        //------------------------------------------

         function play_game()
         {
			global $ibforums, $DB, $std, $vboptions, $vbulletin, $DEBUGMODE, $NATIVEMODE;
			include("arcade/modules/arcade_playgame.php");
         }

        //------------------------------------------
        // Play_Game In Popup Window v1.0
        //
        // This will allow users to play game in new window
        //
        //------------------------------------------

         function playfull()
         	{
				global $ibforums, $DB, $std, $vboptions, $vbulletin, $DEBUGMODE, $NATIVEMODE;
				include("arcade/modules/arcade_playgame_full.php");
			}

        //------------------------------------------
        // Play_Tourney
        //
        // This brings up the game to play
        //
        //------------------------------------------

         function play_tourney()
         {
			global $ibforums, $DB, $std, $vboptions, $vbulletin, $guestplayerid, $NATIVEMODE;
			include("arcade/modules/arcade_playtournament.php");
         }

        //----------------------------------------
        // Show_Stats
        //
        // This shows the leaderboard
        //
        //----------------------------------------

        function show_stats()
        {
			global $ibforums, $DB, $std, $vbulletin, $vboptions;
			include("arcade/modules/arcade_stats.php");
        }


	// #######################################
	// new function for secure games (v32/v33)
	// #######################################

	function verify_score()
	{
		global $DB, $DEBUGMODE;

		list($usec, $sec) = explode(" ", microtime());
		$gametime = ((float)$usec + (float)$sec);
        
		$randomchar = rand(1, 10);
		$randomchar2 = rand(1, 5);

		if ($this->arcade->user['arcade_access'] > 2)
		{
			// this is a guest
			$userinfo['arcade_session'] = intval($_COOKIE['guestsession']);
		}
		else
		{
			$userquery = $DB->query("SELECT * FROM ibf_user WHERE userid=".$this->arcade->user['id']);
			$userinfo = $DB->fetch_row($userquery);
		}

		if ($userinfo['arcade_session']=="")
		{
			$ERRORLEVEL = ($DEBUGMODE == 0) ? "" : "Error #021 - no session";
			$std->Error( array( LEVEL => 1, MSG => 'cheater', EXTRA => $ERRORLEVEL) );
		}

		$DB->query("SELECT sessd FROM ibf_games_session WHERE sessid='".$userinfo['arcade_session']."'");
 		$s = $DB->fetch_row();

		if( !$DB->get_num_rows() )
		{
			die();
		}

		if( $s['sessd'] != 1 )
        	{
			$DB->query("UPDATE ibf_games_session SET randchar1 = '".$randomchar."' , randchar2 = '".$randomchar2."' , start = '".$gametime."' , sessd = 1 WHERE sessid = '".$userinfo['arcade_session']."'");
			//sleep(1); 	// Do not unedit this unless your instructed to !
			// Do not edit this line!
			echo "&randchar=$randomchar&randchar2=$randomchar2&savescore=1&blah=OK";
			exit();
		}
	}

	function save_score()
	{
		// ### for new, secured ibPro-Games

		global $DB, $ibforums, $std, $DEBUGMODE, $FIXIE, $vboptions, $vbulletin, $NATIVEMODE;

		$tgame = 0;
		$player_ip = $ibforums->input['IP_ADDRESS'];
		$player_score = isset($ibforums->input['gscore']) ? $ibforums->input['gscore'] : 0;
		$gidencoded = isset($ibforums->input['arcadegid']) ? $ibforums->input['arcadegid'] : 0;
		$genscore = $ibforums->input['enscore'];
		$swfgname = $ibforums->input['gname'];
		$player_score_encode = $player_score;

		// ### protection for external scripts faking incoming gamedata
		// ### by MrZeropage

		// look who sends the POST-data...
		$referer = "";

		if ($_SERVER['REFERER']!="") { $referer = strtolower($_SERVER['REFERER']); }
		if ($_SERVER['HTTP_REFERER']!="") { $referer = strtolower($_SERVER['HTTP_REFERER']); }
		if ($HTTP_SERVER_VARS['REFERER']!="") { $referer = strtolower($HTTP_SERVER_VARS['REFERER']); }

		// avoid external scripts calling this function
		if ((strpos($referer,"arcade.php") > 0) && (strpos($referer,$vboptions[bburl]) > 0))
		{
			// maybe there is some cheater trying to inject a score ?! *boooooh*
			$VERBOSE = ($DEBUGMODE == 2) ? " -> referrercheck | referer=".$referer : "";
			$ERRORLEVEL = ($DEBUGMODE == 0) ? "" : "Error #002";
			$ERRORLEVEL = $ERRORLEVEL . $VERBOSE;
			$std->Error( array( LEVEL => 1, MSG => 'cheater', EXTRA => $ERRORLEVEL) );
		}

		// ###

		if ($this->arcade->user['arcade_access'] == 3)
		{
			// This is a Guest that won't record any score
			$player_score = 0;
			$good_score = 1;
		}

		if ($this->arcade->user['arcade_access'] > 2)
		{
			// this is a guest
			$userinfo['arcade_session']	= intval($_COOKIE['guestsession']);
			$userinfo['arcade_sess_start'] 	= $_COOKIE['gpstarted'];
			$userinfo['arcade_gtype']	= 0;	// guests never play tourneys!
			$userinfo['arcade_sess_gid'] = intval($_COOKIE['gidstarted']);
			$player_name = $this->arcade->user['name'];
		}
		else
		{
			$userquery = $DB->query("SELECT * FROM ibf_user WHERE userid=".$this->arcade->user['id']);
			$userinfo = $DB->fetch_row($userquery);
			$player_name = $userinfo['username'];
		}

		$DB->query("SELECT * FROM ibf_games_list WHERE gid=".$userinfo['arcade_sess_gid']);
		$g = $DB->fetch_row();

		// Kiss Cookies good bye!
		if( !isset($userinfo['arcade_gtype']) || $userinfo['arcade_gtype'] == '0' )
		{
			$tgame = 0;
			$tid = 0;
		}
		else
		{
			$tgame = 1;
			$tid = $userinfo['arcade_gtype'];
		}
      
		if ($userinfo['arcade_session']=="")
		{
			$ERRORLEVEL = ($DEBUGMODE == 0) ? "" : "Error #022 - no session";
			$std->Error( array( LEVEL => 1, MSG => 'cheater', EXTRA => $ERRORLEVEL) );
		}

		$DB->query("SELECT * FROM ibf_games_session WHERE sessid='".$userinfo['arcade_session']."' LIMIT 1");
 		$vs = $DB->fetch_row();
		$gid = $vs['gameid'];

		$vbversion = substr($vboptions[templateversion],0,3);
		if (($vbversion != "3.0") && ($NATIVEMODE==0))
		{
			($hook = vBulletinHook::fetch_hook('ibproarcade_savescore_readsessiondata')) ? eval($hook) : false;
		}

		if ((($vs['sessd']!=1) && ($vs['sessid']>0)) && ($FIXIE==1))
		{
			// this score has NOT run through the verify() function!
			// actual issue using IE7 and doing more than one play per game

			// make it valid anyway ;)
			list($usec, $sec) = explode(" ", microtime());
			$gametime = ((float)$usec + (float)$sec);
			$randomchar = rand(1, 10);
			$randomchar2 = rand(1, 5);

			$vs['sessd'] = 1;
			$vs['start'] = $gametime;
			$vs['randchar1'] = $randomchar;
			$vs['randchar2'] = $randomchar2;
			$genscore = $player_score * $vs['randchar1'] ^ $vs['randchar2'];
		}

		// for the new games...
		if ( ( file_exists(ROOT_PATH.'arcade/gamedata/'.$g['gname'].'/v32game.txt' ) ) || ( file_exists(ROOT_PATH.'arcade/gamedata/'.$g['gname'].'/v3game.txt' ) ) )
		{
			$encoded_gid = $vs['gameid'] * $vs['randgid'] ^ $vs['randgid2'];

			if ($gidencoded == 0)
			{
				$gidencoded = $g['gid'] * $vs['randgid'] ^ $vs['randgid2'];
			}
		}

		$decodescore = $player_score * $vs['randchar1'] ^ $vs['randchar2'];

		list($usec, $sec) = explode(" ", microtime());
		$time_end = ((float)$usec + (float)$sec);
		$timecheck = round($time_end - $vs['start'], 4);

		$DB->query("DELETE FROM ibf_games_session WHERE sessid=".$userinfo['arcade_session']);

		if ( ($vs['sessd'] != 1) || (!$vs['start']) || (!$vs['sessid']) )
		{
			$ERRORLEVEL = ($DEBUGMODE == 0) ? "" : "Error #003";
			$BROWSERDATA = ($_SERVER['HTTP_USER_AGENT'] != "") ? $_SERVER['HTTP_USER_AGENT'] : $HTTP_SERVER_VARS['HTTP_USER_AGENT'];
			$VERBOSE = ($DEBUGMODE == 2) ? " -> sessd=".$vs['sessd']." | start=".$vs['start']." | sessid=".$vs['sessid']."<br />userid=".$this->arcade->user['id']." | ui[arcade_session]=".$userinfo['arcade_session']." | ui[arcade_sess_gid]=".$userinfo['arcade_sess_gid']."<br />FIXIE = ".$FIXIE."<br /><br />".$BROWSERDATA : "";
			$ERRORLEVEL = $ERRORLEVEL . $VERBOSE;
			$std->Error( array( LEVEL => 1, MSG => 'cheater', EXTRA => $ERRORLEVEL) );
		}

		if ($gid != $userinfo['arcade_sess_gid'])
		{
			// avoid cross-scoring... finally! *gg*
			$ERRORLEVEL = ($DEBUGMODE == 0) ? "" : "Error #004";
			$VERBOSE  = ($DEBUGMODE == 2) ? " -> gid=".$gid." | ui[arcade_sess_gid]=".$userinfo['arcade_sess_gid'] : "";
			$ERRORLEVEL = $ERRORLEVEL . $VERBOSE;
			$std->Error( array( LEVEL => 1, MSG => 'cheater', EXTRA => $ERRORLEVEL) );
		}

		$readtimeoutquery = $DB->query("SELECT scoretimeout FROM ibf_games_settings");
		$readtimeout = $DB->fetch_row($readtimeoutquery);
		$SCORETIMEOUT = $readtimeout['scoretimeout'];

		if( !$timecheck || $timecheck > $SCORETIMEOUT )
		{
			$ERRORLEVEL = ($DEBUGMODE == 0) ? "Transmission Timeout (".$timecheck." sec)" : "Error #005";
			$VERBOSE  = ($DEBUGMODE == 2) ? " -> timecheck=".$timecheck : "";
			$ERRORLEVEL = $ERRORLEVEL . $VERBOSE;
			$std->Error( array( LEVEL => 1, MSG => 'cheater', EXTRA => $ERRORLEVEL) );
		}

		if( $genscore != $decodescore )
		{
			$ERRORLEVEL = ($DEBUGMODE == 0) ? "" : "Error #006";
			$VERBOSE  = ($DEBUGMODE == 2) ? " -> genscore=".$genscore." | decodescore=".$decodescore." | score=".$player_score : "";
			$ERRORLEVEL = $ERRORLEVEL . $VERBOSE;
			$std->Error( array( LEVEL => 1, MSG => 'cheater', EXTRA => $ERRORLEVEL) );
		}

		if ( file_exists(ROOT_PATH.'arcade/gamedata/'.$g['gname'].'/v32game.txt' )  )
		{
			if( ($gidencoded != $encoded_gid) || ($swfgname != $g['gname']) )
			{
				$ERRORLEVEL = ($DEBUGMODE == 0) ? "" : "Error #007";
				$VERBOSE  = ($DEBUGMODE == 2) ? " -> gidenc=".$gidencoded." | enc_gid=".$encoded_gid." | swfgn=".$swfgname." | g[gname]=".$g['gname'] : "";
				$ERRORLEVEL = $ERRORLEVEL . $VERBOSE;
				$std->Error( array( LEVEL => 1, MSG => 'cheater', EXTRA => $ERRORLEVEL) );
			}
		}

		//Get's the timespent
		$timespent = 0;
		if( $userinfo['arcade_sess_start'] )
		{
			$timespent = time() - $userinfo['arcade_sess_start'];	
		}
        
		if( $timespent )
		{
			$DB->query("UPDATE ibf_games_list SET gtime=gtime+'".$timespent."', gtotalscore=gtotalscore+'".$player_score."' WHERE gid='".$gid."' LIMIT 1");
			$DB->query("UPDATE ibf_members SET games_played=games_played+1, time_played=time_played+'".$timespent."' WHERE id=".$ibforums->member['id']);
		}

		// users sessiondata is no longer needed, so kick it to avoid any re-usage
       		$DB->query("UPDATE ibf_members SET arcade_sess_gid='0', arcade_sess_start='0', arcade_gtype=0, arcade_session='0' WHERE id=".$this->arcade->user['id']);

		$this->storescore($this->arcade->user['id'],$player_score,$timespent,$gid,$tgame,$tid,0);
	}


	function post_score()
	{
		// ### for old, unsecured ibPro-Games
		// ### for v3arcade-Games
		// ### for pnFlashGames-Games

		global $ibforums, $DB, $std, $vboptions, $vbulletin, $DEBUGMODE, $NATIVEMODE;
		$tgame = 0;

		$player_ip = $ibforums->input['IP_ADDRESS'];
		$member_id = $this->arcade->user['id'];
		$player_name = $this->arcade->user['name'];
		$player_score = floatval($_POST['gscore']);
		$game_name = ibp_cleansql($_POST['gname']);
		$score = $ibforums->input['gscore'];
		$keepsess = $ibforums->input['keepsess'];

		// ### protection for external scripts faking incoming gamedata
		// ### by MrZeropage

		// look who sends the POST-data...
		$referer = "";
		if ($_SERVER['REFERER']!="") { $referer = strtolower($_SERVER['REFERER']); }
		if ($_SERVER['HTTP_REFERER']!="") { $referer = strtolower($_SERVER['HTTP_REFERER']); }
		if ($HTTP_SERVER_VARS['REFERER']!="") { $referer = strtolower($HTTP_SERVER_VARS['REFERER']); }

		// avoid external scripts calling this function
		if ((strpos($referer,"arcade.php") > 0) && (strpos($referer,$vboptions[bburl]) > 0))
		{
			// maybe there is some cheater trying to inject a score ?! *boooooh*
			$ERRORLEVEL = ($DEBUGMODE == 0) ? "" : "Error #008";
			$VERBOSE  = ($DEBUGMODE == 2) ? " -> REF = ".$referer : "";
			$ERRORLEVEL = $ERRORLEVEL . $VERBOSE;
			$std->Error( array( LEVEL => 1, MSG => 'cheater', EXTRA => $ERRORLEVEL) );
		}

		// ###

		if ($this->arcade->user['arcade_access'] == 3)
		{
			// This is a Guest that won't record any score
			$player_score = 0;
			$good_score = 1;
		}

		if ($this->arcade->user['arcade_access'] > 2)
		{
			// GUEST
			$userinfo['arcade_session']	= $_COOKIE['guestsession'];
			$userinfo['arcade_sess_start'] 	= $_COOKIE['gpstarted'];
			$userinfo['arcade_gtype']	= 0;	// guests never play tourneys!
		}
		else
		{
			$userquery = $DB->query("SELECT * FROM ibf_user WHERE userid=".$this->arcade->user['id']);
			$userinfo = $DB->fetch_row($userquery);
		}

		$getgameidquery = $DB->query("SELECT gid FROM ibf_games_list WHERE gname='".$game_name."'");
		$getgameid = $DB->fetch_row($getgameidquery);

		$timespent = 0;
		if( $userinfo['arcade_sess_start'] )
		{
			$timespent = time() - $userinfo['arcade_sess_start'];	
		}

		if(strstr($score, ":") !== false)
		{
			$timestamp = strtotime($score);
			$formatedTime = strftime("%H:%M:%S", $timestamp);
			$hours = substr($formatedTime, 0, 2);
			$minutes = substr($formatedTime, 3, 2);
			$seconds = substr($formatedTime, 6, 2);
			$numSeconds = (($hours * 60) * 60) + ($minutes * 60) + $seconds;

			$score = $numSeconds;
			$ibforums->input['gscore'] = $score;
		}

		// Kiss Cookies good bye!
		if( !isset($userinfo['arcade_gtype']) || $userinfo['arcade_gtype'] == '0' )
		{
			$tgame = 0;
			$tid = 0;
		}
		else
		{
			$tgame = 1;
			$tid = $userinfo['arcade_gtype'];
		}

		$DB->query("SELECT gid, highscore_type, game_type FROM ibf_games_list WHERE gname='".$game_name."' LIMIT 1");
		$g = $DB->fetch_row();

		if ($g['game_type']==1)
		{
			// this is a secure game which should not use POST_SCORE !!
			$ERRORLEVEL = ($DEBUGMODE == 0) ? "" : "Error #009";
			$std->Error( array( LEVEL => 1, MSG => 'cheater', EXTRA => $ERRORLEVEL) );
		}

		if ($userinfo['arcade_session']=="")
		{
			$ERRORLEVEL = ($DEBUGMODE == 0) ? "" : "Error #023 - no session";
			$std->Error( array( LEVEL => 1, MSG => 'cheater', EXTRA => $ERRORLEVEL) );
		}

		$DB->query("SELECT * FROM ibf_games_session WHERE sessid='".$userinfo['arcade_session']."' LIMIT 1");
 		$vs = $DB->fetch_row();
		$gid = $vs['gameid'];

		$vbversion = substr($vboptions[templateversion],0,3);
		if (($vbversion != "3.0") && ($NATIVEMODE==0))
		{
			($hook = vBulletinHook::fetch_hook('ibproarcade_postscore_readsessiondata')) ? eval($hook) : false;
		}

		if ($keepsess != 1)
		{
			// remove session as all data is read from it... and this is NO PNfg
			$DB->query("DELETE FROM ibf_games_session WHERE sessid=".$userinfo['arcade_session']);
		}

		if ( (!$vs['sessid']) )
		{
			$ERRORLEVEL = ($DEBUGMODE == 0) ? "" : "Error #010";
			$std->Error( array( LEVEL => 1, MSG => 'cheater', EXTRA => $ERRORLEVEL) );
		}

		// #########################################
		// final fix for cross-scoring by MrZeropage
		// #########################################

		// first we check if GameID stored in userinfo is the same of submitting Game
		if ($this->arcade->user['arcade_access'] < 3)	// make sure this is NOT a guest
		{
			// compare userinfo and sessiondata
			if ( ($gid != $userinfo['arcade_sess_gid']) || ($gid != $g['gid']) || ($userinfo['userid'] != $vs['mid']) || ($vs['gname'] != $game_name) )
			{
				$ERRORLEVEL = ($DEBUGMODE == 0) ? "" : "Error #011";
				$VERBOSE  = ($DEBUGMODE == 2) ? " -> gid=".$gid."|ui[a_sess_gid]=".$userinfo['arcade_sess_gid']."|g[gid]=".$g['gid']."|vs[mid]=".$vs['mid']."|vs[gname]=".$vs['gname']."|gamename=".$game_name : "";
				$ERRORLEVEL = $ERRORLEVEL . $VERBOSE;
				$std->Error( array( LEVEL => 1, MSG => 'cheater', EXTRA => $ERRORLEVEL) );
			}

			// compare incoming gameid with the one stored in sessiondata
			if ($getgameid['gid'] != $gid)
			{
				$ERRORLEVEL = ($DEBUGMODE == 0) ? "" : "Error #012";
				$VERBOSE  = ($DEBUGMODE == 2) ? " -> gid=".$gid."|getgameid=".$getgameid['gid'] : "";
				$ERRORLEVEL = $ERRORLEVEL . $VERBOSE;
				$std->Error( array( LEVEL => 1, MSG => 'cheater', EXTRA => $ERRORLEVEL) );
			}

		}
		else
		{
			// this is a guest...
			if ($vs['mname'] != $_COOKIE['guesthash'])
			{
				$ERRORLEVEL = ($DEBUGMODE == 0) ? "" : "Error #013";
				$VERBOSE  = ($DEBUGMODE == 2) ? " -> vs[mname]=".$vs['mname']."|guesthash=".$_COOKIE['guesthash'] : "";
				$ERRORLEVEL = $ERRORLEVEL . $VERBOSE;
				$std->Error( array( LEVEL => 1, MSG => 'cheater', EXTRA => $ERRORLEVEL) );
			}

			// cleanup cookiestuff from guest
			$_COOKIE['guesthash'] = "";
			$_COOKIE['guestsession'] = "";
		}

		if ($keepsess != 1)
		{
			// users sessiondata is no longer needed, so kick it to avoid any re-usage
	       		$DB->query("UPDATE ibf_members SET arcade_sess_gid='0', arcade_sess_start='0', arcade_gtype=0, arcade_session='0' WHERE id=".$this->arcade->user['id']);
		}

		// #########################################

		if ($timespent < 86400)
		{
			$DB->query("UPDATE ibf_games_list SET gtime=gtime+'".$timespent."', gtotalscore=gtotalscore+'".$player_score."' WHERE gid='".$gid."' LIMIT 1");
			if ( ($ibforums->member['id'] > 0) && ($this->arcade->user['arcade_access']==2 || $this->arcade->user['arcade_access']==4) )
			{
				$DB->query("UPDATE ibf_members SET games_played=games_played+1, time_played=time_played+'".$timespent."' WHERE id=".$ibforums->member['id']);
			}
		}

		$this->storescore($this->arcade->user['id'],$player_score,$timespent,$gid,$tgame,$tid,$keepsess);
	}


	function storescore($userid,$player_score,$timespent,$gid,$tgame,$tid,$keepsess)
	{
		global $DB, $std, $vbulletin, $vboptions, $ibforums, $LOGIPS, $NATIVEMODE;
		include("arcade/modules/arcade_storescore.php");
	}


    function rate()
    {
        global $ibforums, $DB, $print;
        include("arcade/modules/arcade_rate.php");
    }

	function facteur($jour , $mois , $annee)
	{
		global $ibforums, $DB, $std, $GROUP;

	    $b=365*$annee;
	    $c=31*($mois-1);
	    if (($mois==1) || ($mois==2)){
	        $d= 0;
	        $e = intval(($annee -1)/4);
	        $h = intval(0.75*(intval(($annee-1)/100)+1));
	    }
	    else {
	        $d= intval(0.4*$mois+2.3);
	        $e = intval($annee/4);
	        $h = intval(0.75*(intval($annee/100)+1));
	    }
	    $result = $jour + $b+ $c - $d +$e -$h;
	    return $result;
	}

    function diff_dates($time)
    {
        $diff = time() - $time;
        $daysDiff = floor($diff/60/60/24);

        return $daysDiff;
    }

	// Function to view the terminated tourneys

	function view_tourney_end() {
		global $ibforums, $DB, $std, $GROUP;

		$std->time_options['ARCADE'] = $ibforums->lang['timeformat4'];

		$this->output = $this->html->finished_tournament_listing($tourneyinfo);

		$DB->query("SELECT t.numplayers,t.datestarted,t.tid,g.gtitle,t.champion, t.url_discut FROM ibf_tournaments as t, ibf_games_list as g WHERE t.champion <> '' AND t.gid = g.gid ORDER BY datestarted DESC");
		while($row = $DB->fetch_row()) {
			$row['link'] = "<a href='".$ibforums->vars['base_url']."do=viewtourney&amp;tid=".$row['tid']."'>".$ibforums->lang['see_this_tourney']."</a>";
			$row['datestarted'] = $std->get_date($row['datestarted'],'ARCADE');
			$this->output .= $this->html->tournament_row($row);
		}

		$this->output .= $this->html->stop("&nbsp;", "&nbsp;");
 		$this->page_title = $ibforums->vars['board_name']." -> ".$ibforums->lang['page_title']." -> ".$ibforums->lang['tournament_view'];
 		$this->nav        = array( "<a href='".$ibforums->vars['base_url']."'>{$ibforums->lang['page_title']}</a>", $ibforums->lang['tournament_view'] );
 	}

	function create_tourney()
    {
		global $ibforums, $DB, $std, $GROUP, $vbulletin, $vboptions, $guestplayerid, $NATIVEMODE;
        include("arcade/modules/arcade_createtournament.php");
	}

	function do_create_tourney() {

 		global $ibforums, $DB, $std, $GROUP, $bbuserinfo, $print, $vboptions, $vbulletin, $NATIVEMODE;

		 // We aren't a guest... are we?
		 if( $ibforums->member['id'] == "" || $ibforums->member['id'] == "0") {
		     $std->Error( array( 'LEVEL' => 1, 'MSG' => 'no_guests') );
	 	}

		$vbversion = substr($vboptions[templateversion],0,3);
		if (($vbversion != "3.0") && ($NATIVEMODE==0))
		{
			($hook = vBulletinHook::fetch_hook('ibproarcade_do_create_tourney_start')) ? eval($hook) : false;
		}

		$nbjoueurs = $ibforums->input['nbjoueurs'];
		$nbtries = $ibforums->input['nbtries'];
		$game = intval($ibforums->input['the_game']);
		$costs = intval($ibforums->input['tourney_costs']);

		$DB->query("SELECT gtitle from ibf_games_list WHERE gid='".$game."' LIMIT 1");
		$GAME = $DB->fetch_row();
		$gtitle = $GAME['gtitle'];

       	$db_string = $DB->compile_db_insert_string( array ( 'gid'	    	=> $game,
           													'numplayers'	=> $nbjoueurs,
                                                            'datestarted' 	=> time(),
	                                                        'demare'   		=>  0,
   								'creat'		   => $this->arcade->user['name'],
   	                                                        'plibre'		=> $nbjoueurs - 1,
   	                                                        'nbtries'		=> $nbtries,
								'cost'		=> $costs,
								'champion'	=> '',
								'url_discut'	=> '',
                                                            ) );

	   	$DB->query("INSERT INTO ibf_tournaments
	        									 (" .$db_string['FIELD_NAMES']. ") VALUES
	                    						 (". $db_string['FIELD_VALUES'] .")");

	   	$tid = $DB->get_insert_id();
	   	$nbjoueurs = $nbjoueurs + 1;
	   	$rung = ceil($nbjoueurs / 3);
	   	$cpt = 1;

	   	while($cpt < $nbjoueurs)
	   	{
	   		$faceoff = ceil($cpt/2);
       		$db_string = $DB->compile_db_insert_string( array ( 'mid'			=> 	0,
	        													'tid'			=> 	$tid,
	                                                            'rung'			=>  $rung,
	                                                           	'rungscore' 	=>  0,
	                                                           	'faceoff'		=> 	$faceoff,
	                                                            'timeplayed'	=> 	time(),
	                                                            'timesplayed'   =>  0,
									'notified'	=> 0,
	                                                            ) );
         	$DB->query("INSERT INTO ibf_tournament_players
	        							   (" .$db_string['FIELD_NAMES']. ") VALUES
	                    				   (". $db_string['FIELD_VALUES'] .")");

	        $cpt = $cpt + 1;
	   	}

	   	// Insertion du membre crateur du tournoi dans ce tournoi (au hasard)

	   	$nbjoueurs = $nbjoueurs - 1;
		$hasard = rand(1,$nbjoueurs);
		$faceoff = ceil($hasard/2);
		$DB->query("UPDATE ibf_tournament_players SET mid='".$ibforums->member['id']."' WHERE rung='".$rung."' AND tid='".$tid."' AND faceoff='".$faceoff."' LIMIT 1");

		// Cration statut pour ce tournoi (0 = Ok, actif)

                $db_string = $DB->compile_db_insert_string( array ( 'tid'	=> $tid,
                                                                    'mid'	=> $ibforums->member['id'],
                                                                    'statut'	=> 0,	) ) ;

		$DB->query("INSERT INTO ibf_tournament_players_statut (" .$db_string['FIELD_NAMES']. ") VALUES (". $db_string['FIELD_VALUES'] .")");

		// Cration statut bidon pour mid = 0

                $db_string = $DB->compile_db_insert_string( array ( 'tid'	=> $tid,
                                                               	    'mid'	=> 0,
                                                                     'statut'	=> 0, ) );

		$DB->query("INSERT INTO ibf_tournament_players_statut (" .$db_string['FIELD_NAMES']. ") VALUES (". $db_string['FIELD_VALUES'] .")");

		if ($FIXSTYLE == 1)
		{
			echo " "; // some forums need this...
		}

		if (($vbversion != "3.0") && ($NATIVEMODE==0))
		{
			($hook = vBulletinHook::fetch_hook('ibproarcade_do_create_tourney_end')) ? eval($hook) : false;
		}

 		$print->redirect_screen($ibforums->lang['tournament_created'], $ibforums->vars['base_url']."do=viewtourney&amp;tid=".$tid);
	}

	function register_tourney($tid) {

		global $ibforums, $DB, $std, $GROUP, $print, $vboptions, $vbulletin, $guestplayerid, $NATIVEMODE;

		 // We aren't a guest... are we?
		 if( $ibforums->member['id'] == "" || $ibforums->member['id'] == "0" || $guestplayerid==$ibforums->member['id']) {
		     $std->Error( array( 'LEVEL' => 1, 'MSG' => 'no_guests') );
	 	}

		// check if player is allowed to play the Arcade through all primary and secondary usergroups
		$playok = 0;
		$DB->query("SELECT g.arcade_access, m.usergroupid, m.membergroupids FROM ibf_members AS m LEFT JOIN ibf_groups AS g ON (m.mgroup=g.g_id) WHERE m.id=".$ibforums->member['id']);
	        $userdata = $DB->fetch_row();
		$groups = array();
		$groups[] = $userdata['usergroupid'];
		if ($userdata['membergroupids'] != "")
		{
			$groups = array_merge($groups,explode(',',$userdata['membergroupids']));
		}
		$groupstring = implode(',',$groups);

		$DB->query("SELECT arcade_access FROM ibf_groups WHERE g_id IN (".$groupstring.")");
		while ($check = $DB->fetch_row())
		{
			if ($check['arcade_access'] > 1)
			{
				$playok = 1;
			}
		}
		unset($groups);
		unset($check);

		if ($playok == 0)
		{
		     $std->Error( array( 'LEVEL' => 1, 'MSG' => 'err_noplay') );
		}

		$tid = intval($tid);
	 	// Ce membre n'est-il pas dj inscrit  ce tournoi ?
	 	$DB->query("SELECT mid FROM ibf_tournament_players WHERE tid='".$tid."' AND mid='".$ibforums->member['id']."'");
	 	if($DB->fetch_row())
	 	{
	 		$std->Error( array( 'LEVEL' => 1, 'MSG' => 'player_already') );
	 	}
		/*
        	if($ibforums->member['posts'] < $GROUP['p_require'])
        	{
			$std->Error( array( 'LEVEL' => 1, 'MSG' => 't_p_requires') );
		}
		*/

		$DB->query("SELECT creat, gid, demare, numplayers, cost FROM ibf_tournaments WHERE tid = '".$tid."' LIMIT 1");
		$row = $DB->fetch_row();

		if($row['demare'] == 1)
        	{
			$std->Error( array( 'LEVEL' => 1, 'MSG' => 't_deja_dem') );
		}

		$vbversion = substr($vboptions[templateversion],0,3);
		if (($vbversion != "3.0") && ($NATIVEMODE==0))
		{
			($hook = vBulletinHook::fetch_hook('ibproarcade_register_tourney_start')) ? eval($hook) : false;
		}

		$DB->query("SELECT gtitle from ibf_games_list WHERE gid='".$row['gid']."' LIMIT 1");
		$GAME = $DB->fetch_row();
		$gtitle = $GAME['gtitle'];

		$nbjoueurs = $row['numplayers'];
		$rung = ceil($nbjoueurs / 3);
		$gid = $row['gid'];
		$creat = $row['creat'];

		$ctr = 0;
		$liste = "";

		$DB->query("SELECT * FROM ibf_tournament_players WHERE tid='".$tid."' ORDER BY faceoff ASC");
		while($row = $DB->fetch_row())
		{
			if($ctr==0)
			{
				$ctr = 1;
			} else {
				$ctr = 0;
			}

			$num = ($row['faceoff']*2) - $ctr;

			if($row['mid'] == 0)            // Place libre
			{
				$liste .= $num;
			}
		}

		$hasard = rand(1,strlen($liste)) - 1;
		$num = $liste{$hasard};                  // On a une place ok :)

		$faceoff = ceil($num/2);
		$datestarted = time();
		$DB->query("UPDATE ibf_tournament_players SET mid='".$ibforums->member['id']."', notified=0 WHERE rung='".$rung."' AND tid='".$tid."' AND mid='0' AND faceoff='".$faceoff."' LIMIT 1");

		// Cration statut pour ce tournoi (0 = Ok, actif)
		$DB->query("INSERT INTO ibf_tournament_players_statut VALUES ('".$tid."', '".$ibforums->member['id']."', '0')");

		if(strlen($liste) == 1)   // Le tournoi est donc plein aprs cette inscription ;)
		{
			$DB->query("UPDATE ibf_tournament_players SET timeplayed='".$datestarted."' WHERE tid='".$tid."'");
			$DB->query("UPDATE ibf_tournaments SET datestarted='".$datestarted."',demare = '1', plibre='0' WHERE tid='".$tid."'");

			if ($this->arcade->settings['msgsys_tstart']==1)
			{
				// send notification-message to all participants that the tourney starts right now
				$DB->query("SELECT gtitle from ibf_games_list WHERE gid='".$gid."' LIMIT 1");
				$title = $DB->fetch_row();
				$gamename = $title['gtitle'];

				$sendername 	= "Arcade System Message";

				global $vbulletin, $vboptions;

				$vbversion = substr($vboptions[templateversion],0,3);	// Version 3.0 oder 3.5
				if ($vbversion == "3.0")
				{
					$forumlink = $vboptions['bburl']."/";
				}
				else
				{
					$forumlink = $vbulletin->options['bburl']."/";
				}
	
				$callusers = $DB->query("SELECT mid FROM ibf_tournament_players WHERE tid='".$tid."'");
				while($row = $DB->fetch_row($callusers))
				{
					$recipient = $row['mid'];

					// does the recipient want to receive any Notifications from the Arcade ?
					$DB->query("SELECT arcade_pmactive, email, username FROM ibf_user WHERE userid=".$recipient);
					$recip = $DB->fetch_row();
					$recipientname = $recip['username'];
	
					$title = $gamename . " " . $ibforums->lang['pm_tourney_full'];
					$mailtitle = $gamename . " " . $ibforums->lang['pm_tourney_full'];

					$message = $this->arcade->settings['msgsys_tstart_text'];
					$mailmessage = $this->arcade->settings['msgsys_tstart_text'];

					$message = preg_replace('/%NAME%/',$recipientname,$message);
					$message = preg_replace('/%GAME%/',$gamename,$message);
					$message = preg_replace("#%LINK\|(.*?)%#","[url='".$forumlink."arcade.php?do=viewtourney&tid=".$tid."']$1[/url]",$message);

					$mailmessage = preg_replace('/%NAME%/',$recipientname,$mailmessage);
					$mailmessage = preg_replace('/%GAME%/',$gamename,$mailmessage);
					$mailmessage = preg_replace("#%LINK\|(.*?)%#","<a href='".$forumlink."arcade.php?do=viewtourney&tid=".$tid."'>$1</a>",$mailmessage);

					$mailmessage = strip_bbcode($mailmessage, true);
					$mailmessage = preg_replace('/<\/?[a-z][a-z0-9]*[^<>]*>/i', '', $mailmessage);

					if ($guestplayerid == $recipient)
					{ $recip['arcade_pmactive']=0; }
	
					if ($recip['arcade_pmactive'] == 1)
					{
						// Notification via PM
						if (($this->arcade->settings['notification']=="pm") || ($this->arcade->settings['notification']=="pm+mail"))
						{
							$DB->query("INSERT INTO ibf_pmtext (fromuserid, fromusername, title, message, touserarray, iconid, dateline, showsignature, allowsmilie) VALUES ('".$recipient."', '".$sendername."', '".$title."', '" . addslashes($message) . "',  '" . addslashes(serialize(array($recipient))) . "', 0, " . TIMENOW . ", 0, 0)");
							$pmid = $DB->get_insert_id();
							$DB->query("UPDATE ibf_user SET pmtotal=pmtotal+1, pmunread=pmunread+1 WHERE userid=$recipient");
							$DB->query("INSERT INTO ibf_pm (pmtextid, userid, folderid, messageread) VALUES ('$pmid', '$recipient', '0', '0')");
						}
	
						// Notification via eMail
						if (($this->arcade->settings['notification']=="mail") || ($this->arcade->settings['notification']=="pm+mail"))
						{
							vbmail($recip['email'],$mailtitle,$mailmessage);
						}
					}
				}
			}
		}
	
		$DB->query("UPDATE ibf_tournaments SET plibre=plibre-1 WHERE tid='".$tid."'");

		if ($FIXSTYLE == 1)
		{
			echo " "; // some forums need this...
		}

 		$print->redirect_screen($ibforums->lang['tourney_reg_ok'], $ibforums->vars['base_url']."do=viewtourney&amp;tid=".$tid);

	 }

	function corige_tournoi($tid, $rung, $faceoff)
	{
		global $ibforums, $DB, $std, $GROUP, $print;

		$tid = intval($tid);
		$rung = intval($rung);
		$faceoff = intval($faceoff);

		$DB->query("SELECT * FROM ibf_tournaments WHERE tid='$tid'");
		$infot = $DB->fetch_row();

		$DB->query("SELECT * from ibf_games_list WHERE gid='".$infot['gid']."' LIMIT 1");
		$infog = $DB->fetch_row();

		$cpt=0;
		// Recherche des infos sur les 2 joueurs
		$DB->query("SELECT * FROM ibf_tournament_players WHERE tid='$tid' AND rung='$rung' AND faceoff='$faceoff'");
		while($row = $DB->fetch_row())
		{
			$infoj[$cpt] = $row;
			$cpt++;
		}

		$nbtries = $infot['nbtries'];

		if($infoj[0]['timesplayed'] < $nbtries || $infoj[1]['timesplayed'] < $nbtries) {
			echo $ibforums->lang['advance_players'];
			$this->view_tourney($tid);
			return;
		}

		if($faceoff == 1 || $faceoff == 2) {
			$nextfaceoff=1;
		} else {
			$nextfaceoff=2;
		}

		// Cas o un champion doit tre couronn

		if($rung == 1) {

			if ( (($infoj[0]['rungscore'] >= $infoj[1]['rungscore']) && $infog['highscore_type'] == "high") || (($infoj[0]['rungscore'] <= $infoj[1]['rungscore']) && $infog['highscore_type'] == "low" && $infoj[0]['rungscore'] > 0) )
			{
				$winner = $infoj[0]['mid'];
			} else {
				$winner = $infoj[1]['mid'];
			}

			$DB->query("SELECT name,id FROM ibf_members WHERE id='".$winner."' LIMIT 1");
			$name = $DB->fetch_row();
			$DB->query("UPDATE ibf_tournaments SET champion='".ibp_cleansql($name['name'])."' WHERE tid='$tid' LIMIT 1");

			// Mise  jour du statut de tous les participants (Statut = 3 => Tournoi termin)
			$DB->query("UPDATE ibf_tournament_players_statut  SET statut='3' WHERE tid='".$tid."'");

			$print->redirect_screen($ibforums->lang['operation_ok'], $ibforums->vars['base_url']."do=viewtourney&amp;tid=".$tid);
			return;

		}

		// Le tournoi n'est pas termin, on fait juste avancer

		$loser = "";
		if ((($infoj[0]['rungscore'] >= $infoj[1]['rungscore']) && $infog['highscore_type'] == "high") || (($infoj[0]['rungscore'] <= $infoj[1]['rungscore']) && $infog['highscore_type'] == "low" && $infoj[0]['rungscore'] > 0))
		{
                    	$db_string = $DB->compile_db_insert_string( array ( 'mid'  			=> $infoj[0]['mid'],
                                                               		'tid'     		=> $tid,
                                                               		'rung'    		=> ($rung-1),
	                                                                'rungscore'		=> 0,
                                                               		'faceoff'    	=> $nextfaceoff,
                                                                    	'timeplayed'	=> time(),
                                                                        'timesplayed'	=> 0,	
									'notified'	=> 0,) );
                    	$DB->query("INSERT INTO ibf_tournament_players (" .$db_string['FIELD_NAMES']. ") VALUES (". $db_string['FIELD_VALUES'] .")");
			$loser = $infoj[1]['mid'];
		} else {
                    	$db_string = $DB->compile_db_insert_string( array ( 'mid'  			=> $infoj[1]['mid'],
                                                               		'tid'     		=> $tid,
                                                               		'rung'    		=> ($rung-1),
	                                                                'rungscore'		=> 0,
                                                               		'faceoff'    	=> $nextfaceoff,
                                                                    	'timeplayed'	=> time(),
                                                                        'timesplayed'	=> 0,
									'notified'	=> 0,	) );
                    	$DB->query("INSERT INTO ibf_tournament_players (" .$db_string['FIELD_NAMES']. ") VALUES (". $db_string['FIELD_VALUES'] .")");
			$loser = $infoj[0]['mid'];
		}

		// Mise  jour du statut du perdant
		$DB->query("UPDATE ibf_tournament_players_statut SET statut='1' WHERE tid='".$tid."' AND mid='".$loser."'");

		// update last playtime for both (new) opponents
		$DB->query("UPDATE ibf_tournament_players SET timeplayed=".time().", notified=0 WHERE tid=".$tid." AND rung=".($rung-1)." AND faceoff=".$nextfaceoff);

		$print->redirect_screen($ibforums->lang['operation_ok'], $ibforums->vars['base_url']."do=viewtourney&amp;tid=".$tid);
	}

	function disqual_tournoi($tid, $rung, $faceoff, $mid)
	{
		global $ibforums, $DB, $std, $GROUP, $print;

		$tid = intval($tid);
		$rung = intval($rung);
		$faceoff = intval($faceoff);
		$mid = intval($mid);

		// check permission to run this
        	$DB->query("SELECT m.is_arcade_mod AS is_mod, g.g_access_cp AS is_admin FROM ibf_members AS m LEFT JOIN ibf_groups AS g ON (m.mgroup = g.g_id) WHERE id=".$ibforums->member['id']." LIMIT 0, 1");
        	$userinfo = $DB->fetch_row();

		if ($userinfo['is_mod'] || $userinfo['is_admin'])
		{

		$DB->query("SELECT * FROM ibf_tournaments WHERE tid='$tid'");
		$infot = $DB->fetch_row();

		$cpt=0;
		// Recherche des infos sur les 2 joueurs
		$DB->query("SELECT * FROM ibf_tournament_players WHERE tid='$tid' AND rung='$rung' AND faceoff='$faceoff'");
		while($row = $DB->fetch_row())
		{
			$infoj[$cpt] = $row;
			$cpt++;
		}

		$nbtries = $infot['nbtries'];

		if($faceoff == 1 || $faceoff == 2) {
			$nextfaceoff=1;
		} else {
			$nextfaceoff=2;
		}

		// Cas o un champion doit tre couronn

		if($rung == 1) {
			if($mid == $infoj[0]['mid']) {
				$winner = $infoj[1]['mid'];
			} else {
				$winner = $infoj[0]['mid'];
			}

			$DB->query("SELECT gname, gtitle from ibf_games_list WHERE gid='".$infot['gid']."' LIMIT 1");
			$row = $DB->fetch_row();
			$gname = $row['gname'];
			$gtitle = $row['gtitle'];

			$DB->query("SELECT name,id FROM ibf_members WHERE id='".$winner."' LIMIT 1");
			$name = $DB->fetch_row();
			$DB->query("UPDATE ibf_tournaments SET champion='".ibp_cleansql($name['name'])."' WHERE tid='$tid' LIMIT 1");

			// Mise  jour du statut de tous les participants (Statut = 3 => Tournoi termin)
			$DB->query("UPDATE ibf_tournament_players_statut SET statut='3' WHERE tid='".$tid."' AND mid=".$winner);
			$DB->query("UPDATE ibf_tournament_players_statut SET statut='2' WHERE tid='".$tid."' AND mid=".$mid);
			$DB->query("UPDATE ibf_tournament_players SET timesplayed='$nbtries' WHERE tid='$tid' AND faceoff='$faceoff' AND rung='$rung'");

			$print->redirect_screen($ibforums->lang['operation_ok'], $ibforums->vars['base_url']."do=viewtourney&amp;tid=".$tid);
			return;

		}

		// Le tournoi n'est pas termin, on fait juste avancer

		$loser = "";
		if($mid == $infoj[0]['mid']) {
                    	$db_string = $DB->compile_db_insert_string( array ( 'mid'  			=> $infoj[1]['mid'],
                                                               		'tid'     		=> $tid,
                                                               		'rung'    		=> ($rung-1),
	                                                                'rungscore'		=> 0,
                                                               		'faceoff'    	=> $nextfaceoff,
                                                                    	'timeplayed'	=> time(),
                                                                        'timesplayed'	=> 0,	
									'notified'	=> 0,) );
                    	$DB->query("INSERT INTO ibf_tournament_players (" .$db_string['FIELD_NAMES']. ") VALUES (". $db_string['FIELD_VALUES'] .")");
			$loser = $infoj[0]['mid'];

			// check if there is an opponent (to set back his timer)
			$check=$DB->query("SELECT mid FROM ibf_tournament_players WHERE tid=".$tid." AND faceoff=".$nextfaceoff." AND rung=".($rung-1)." AND mid<>".$infoj[1]['mid']);
			if ($row = $DB->fetch_row($check))
			{
				$DB->query("UPDATE ibf_tournament_players SET timeplayed='".time()."', notified=0 WHERE tid=".$tid." AND faceoff=".$nextfaceoff." AND rung=".($rung-1)." AND mid=".$row['mid']);
			}

		} else {
                    	$db_string = $DB->compile_db_insert_string( array ( 'mid'  			=> $infoj[0]['mid'],
                                                               		'tid'     		=> $tid,
                                                               		'rung'    		=> ($rung-1),
	                                                                'rungscore'		=> 0,
                                                               		'faceoff'    	=> $nextfaceoff,
                                                                    	'timeplayed'	=> time(),
                                                                        'timesplayed'	=> 0,	
									'notified'	=> 0,) );
                    	$DB->query("INSERT INTO ibf_tournament_players (" .$db_string['FIELD_NAMES']. ") VALUES (". $db_string['FIELD_VALUES'] .")");
			$loser = $infoj[1]['mid'];

			// check if there is an opponent (to set back his timer)
			$check=$DB->query("SELECT mid FROM ibf_tournament_players WHERE tid=".$tid." AND faceoff=".$nextfaceoff." AND rung=".($rung-1)." AND mid<>".$infoj[0]['mid']);
			if ($row = $DB->fetch_row($check))
			{
				$DB->query("UPDATE ibf_tournament_players SET timeplayed='".time()."', notified=0 WHERE tid=".$tid." AND faceoff=".$nextfaceoff." AND rung=".($rung-1)." AND mid=".$row['mid']);
			}
		}

		// Mise  jour du statut du perdant
		$DB->query("UPDATE ibf_tournament_players_statut SET statut='2' WHERE tid='".$tid."' AND mid='".$loser."'");
		$DB->query("UPDATE ibf_tournament_players SET timesplayed='$nbtries' WHERE tid='$tid' AND faceoff='$faceoff' AND rung='$rung'");

		}

		$print->redirect_screen($ibforums->lang['operation_ok'], $ibforums->vars['base_url']."do=viewtourney&amp;tid=".$tid);
	}

}

$main = new Arcade;

if( isset($ibforums->input['module']) )
{
    $file = MODULE_PATH."mod_".$ibforums->input['module'].".php";
    if( file_exists($file) )
    {
        require $file;
    }
    else
    {
        $main->show_games();
        $print->add_output($main->output);
        $print->do_output( array( 'TITLE' => $main->page_title, 'JS' => 0, NAV => $main->nav ) );
    }
}

function recursive_str_ireplace($replacethis,$withthis,$inthis)
{
	while (1==1)
	{
		$inthis = str_ireplace($replacethis,$withthis,$inthis);
		if(stristr($inthis, $replacethis) === FALSE)
		{
			RETURN $inthis;
		}
	}
	RETURN $inthis;
}

function ibp_cleansql($value) 
{ 
  // using vBulletin to clean the data
  global $vbulletin;
  return $vbulletin->db->escape_string($value);
}

function ibp_cleanhtml($value)
{
	if ($value != strip_tags($value))
	{
		// seems to be HTML in the text...
		$search = array('@<script[^>]*?>.*?</script>@si',	// Strip out javascript
				'@<style[^>]*?>.*?</style>@siU',	// Strip style tags properly
				'@<[\/\!]*?[^<>]*?>@si',		// Strip out HTML tags
				'@<![\s\S]*?--[ \t\n\r]*>@'		// Strip multi-line comments including CDATA
				);
		$value = preg_replace($search, '', $value);
		$value = strip_tags($value);
	}
	return $value;
}

    function clean_key($key) {

    	if ($key == "")
    	{
    		return "";
    	}
    	$key = preg_replace( "/\.\./"           , ""  , $key );
    	$key = preg_replace( "/\_\_(.+?)\_\_/"  , ""  , $key );
    	$key = preg_replace( "/^([\w\.\-\_]+)$/", "$1", $key );
    	return $key;
    }

    function clean_value($val)
    {
    	if ($val == "")
    	{
    		return "";
    	}

    	$val = str_replace( "&#032;", " ", $val );

    	if ( $ibforums->vars['strip_space_chr'] )
    	{
    		$val = str_replace( chr(0xCA), "", $val );  //Remove sneaky spaces
    	}

    	$val = str_replace( "&"            , "&amp;"         , $val );
    	$val = str_replace( "<!--"         , "&#60;&#33;--"  , $val );
    	$val = str_replace( "-->"          , "--&#62;"       , $val );
    	$val = preg_replace( "/<script/i"  , "&#60;script"   , $val );
    	$val = str_replace( ">"            , "&gt;"          , $val );
    	$val = str_replace( "<"            , "&lt;"          , $val );
//    	$val = str_replace( "\""           , "&quot;"        , $val );
    	$val = preg_replace( "/\n/"        , "<br />"        , $val ); // Convert literal newlines
    	$val = preg_replace( "/\\\$/"      , "&#036;"        , $val );
    	$val = preg_replace( "/\r/"        , ""              , $val ); // Remove literal carriage returns
    	$val = str_replace( "!"            , "&#33;"         , $val );
    	$val = str_replace( "'"            , "&#39;"         , $val ); // IMPORTANT: It helps to increase sql query safety.

    	// Ensure unicode chars are OK
	$val = preg_replace("/&amp;#([0-9]+);/s", "&#\\1;", $val );

	// Strip slashes if not already done so.
	$val = stripslashes($val);

    	// Swop user inputted backslashes
    	$val = preg_replace( "/\\\(?!&amp;#|\?#)/", "&#092;", $val );

	$val = ibp_cleansql($val);

    	return $val;
    }

?>
