<?php

		// ##############################################################
		// common handling of scores coming from any game (by MrZeropage)
		// ##############################################################

		$gid = intval($gid);
		$tid = intval($tid);
		$userid = intval($userid);
		$keepsess = intval($keepsess);
		$player_score = floatval($player_score);
		$timespent = ibp_cleansql($timespent);
		$server = strtolower($_SERVER['HTTP_REFERER']);
		$referer = strpos($server,"arcade.php");

		// for guests playing and calling games directly (without arcade.php) we have to re-check cookies
		if (($_COOKIE['ibPAcookiecheck'] != "yesss") && ($_COOKIE['guesthash']) > 0)
		{
			$VERBOSE = ($DEBUGMODE == 2) ? " cookie #003 -> ghash=".$_COOKIE['guesthash']." | ibPAcheck=".$_COOKIE['ibPAcookiecheck']." | referer=".$_SERVER['HTTP_REFERER'] : "";
			$std->Error( array( LEVEL => 1, MSG => 'cat_pass_notice', EXTRA => $VERBOSE) );
		}

		$gamequery = $DB->query("SELECT highscore_type FROM ibf_games_list WHERE gid='".$gid."' LIMIT 1");
		$g = $DB->fetch_row($gamequery);
        	$ordering = ($g['highscore_type'] == "high") ? "DESC" : "ASC";

		$player_name = $this->arcade->user['name'];
		$member_id = $userid;
		$player_ip = ($LOGIPS == 0) ? "" : $ibforums->input['IP_ADDRESS'];

		// get this user's best result in that game
        	$scorequery = $DB->query("SELECT score, timespent FROM ibf_games_scores WHERE gid=".$gid." AND mid=".$this->arcade->user['id']." ORDER BY score ".$ordering." LIMIT 0, 1");
        	if( $DB->get_num_rows($scorequery) )
        	{
                	$userscore = $DB->fetch_row($scorequery);
            		$score = $userscore['score'];
			$usertime = $userscore['timespent'];
			$name_found = 1;
        	}
        	else
        	{
                	$score = 0;
			$usertime = 0;
			$name_found = 0;
        	}

		if($tgame == 0)
        	{
			$std->time_options['LROW'] = "G:i";

			$max_scores_shown = $this->arcade->settings['scores_amount'];

			$DB->query("SELECT g.gid, g.gname, g.gtitle, g.gwords, g.gcat, g.highscore_type, g.decpoints, g.cost, g.jackpot, g.jackpot_type, g.g_rating, g.g_raters, c.*, x.opentag AS prefix, x.closetag AS suffix 
						FROM ibf_games_list AS g
						LEFT JOIN ibf_games_champs AS c ON (g.gid = c.champ_gid)
                		LEFT JOIN ibf_members AS m ON (m.userid=c.champ_mid)
                		LEFT JOIN ibf_groups AS x ON (x.g_id=m.usergroupid)
						WHERE g.gid=".$gid);
			if( $DB->get_num_rows() )
                	{
                       		$ginfo = $DB->fetch_row();
				$ginfo['champ_score'] = $this->arcade->do_arcade_format($ginfo['champ_score'],$ginfo['decpoints']);
				if( !empty($ginfo['champ_mid']) )
                        	{
					$ginfo['champ_name'] = $ginfo['prefix'].$ginfo['champ_name'].$ginfo['suffix'];
					$DB->query("SELECT avatar,avatar_size AS size FROM ibf_members WHERE id=".$ginfo['champ_mid']);
					$avatar = $DB->fetch_row();
                                        $ginfo['avatarcode'] = $std->get_avatar($avatar , 1 , $avatar['size']);
                        	}
                	}
                	else
                	{
                        	$DB->query("SELECT * FROM ibf_games_list WHERE gid=".$gid);
                    		$ginfo = $DB->fetch_row();
                	}

			$ginfo['avatarcode'] = (empty($ginfo['avatarcode'])) ? "<img src='./arcade/images/noavatar.gif' alt='' />" : $ginfo['avatarcode'];

			$DB->query("SELECT champ_score AS score, champ_time AS time, champ_name AS name, champ_mid AS mid, champ_gtitle FROM ibf_games_champs WHERE champ_gid=".$gid);
			if( $DB->get_num_rows() )
			{
                    		$champ = $DB->fetch_row();

//xxxxx
				if (($player_score<>0) && ((($player_score > $champ['score'] && $ginfo['highscore_type'] == "high") || ($player_score < $champ['score'] && $ginfo['highscore_type'] == "low")) || (($player_score == $champ['score']) && (($timespent < $champ['time']) || ($champ['time']==0) ))))
				{
					$vbversion = substr($vboptions[templateversion],0,3);
					if (($vbversion != "3.0") && ($NATIVEMODE==0))
					{
						($hook = vBulletinHook::fetch_hook('ibproarcade_new_champ')) ? eval($hook) : false;
					}

                        		$db_string = $DB->compile_db_update_string( array ( 'champ_gid'     => $gid,
                                       	                                         'champ_gtitle'  => $ginfo['gtitle'],
                                               	                                 'champ_mid'     => $this->arcade->user['id'],
                                                       	                         'champ_name'    => $this->arcade->user['name'],
                                                               	                 'champ_date'    => time(),
										'champ_score'        => $player_score,
										'champ_time'	=> $timespent ) );

					// update Avatarinfo for HTML-Output
					$DB->query("SELECT avatar,avatar_size AS size FROM ibf_members WHERE id=".$this->arcade->user['id']);
					$avatar = $DB->fetch_row();
                                        $ginfo['avatarcode'] = $std->get_avatar($avatar , 1 , $avatar['size']);
					$ginfo['avatarcode'] = (empty($ginfo['avatarcode'])) ? "<img src='./arcade/images/noavatar.gif' alt='' />" : $ginfo['avatarcode'];

					if ($player_score != 0)
					{
						// PM-Notification on new highscore by MrZeropage :-)
						$senderid = $this->arcade->user['id'];
						$sendername = $this->arcade->user['name'];
						$recipient = $champ['mid'];

						$vbversion = substr($vboptions[templateversion],0,3);	// Version 3.0 oder 3.5
						if ($vbversion == "3.0")
						{
							$forumlink = $vboptions['bburl']."/";
						}
						else
						{
							$forumlink = $vbulletin->options['bburl']."/";
						}
					
						$title = $ibforums->lang['pmnote_title'];
						$mailtitle = $ibforums->lang['mailnote_title'];

						$message = $this->arcade->settings['msgsys_hscore_text'];
						$mailmessage = $this->arcade->settings['msgsys_hscore_text'];

						$message = preg_replace('/%NAME%/',$champ['name'],$message);
						$message = preg_replace('/%GAME%/',$ginfo['gtitle'],$message);
						$message = preg_replace('/%CHAMP%/',$this->arcade->user['name'],$message);
						$message = preg_replace("#%LINKGAME\|(.*?)%#","[url='".$forumlink."arcade.php?do=play&gameid=".$gid."']$1[/url]",$message);
						$message = preg_replace("#%LINKHIGH\|(.*?)%#","[url='".$forumlink."arcade.php?do=stats&gameid=".$gid."']$1[/url]",$message);

						$mailmessage = preg_replace('/%NAME%/',$champ['name'],$mailmessage);
						$mailmessage = preg_replace('/%GAME%/',$ginfo['gtitle'],$mailmessage);
						$mailmessage = preg_replace('/%CHAMP%/',$this->arcade->user['name'],$mailmessage);
						$mailmessage = preg_replace("#%LINKGAME\|(.*?)%#","<a href='".$forumlink."arcade.php?do=play&gameid=".$gid."'>$1</a>",$mailmessage);
						$mailmessage = preg_replace("#%LINKHIGH\|(.*?)%#","<a href='".$forumlink."arcade.php?do=stats&gameid=".$gid."'>$1</a>",$mailmessage);

						$mailmessage = strip_bbcode($mailmessage, true);
						$mailmessage = preg_replace('/<\/?[a-z][a-z0-9]*[^<>]*>/i', '', $mailmessage);

						if ( ($senderid != $recipient) && ($this->arcade->settings['msgsys_hscore']==1) )
						{
							// does the recipient want to receive any Notifications from the Arcade ?
							$DB->query("SELECT arcade_pmactive, email FROM ibf_user WHERE userid=$recipient");
							$recip = $DB->fetch_row();
	
							// check for possible Guest-Player
							if ($guestplayerid == $recipient)
							{ $recip['arcade_pmactive']=0; }	

							if (($recip['arcade_pmactive'] == 1) && ($this->arcade->settings['msgsys_hscore']==1))
							{
								// Notification via PM
								if (($this->arcade->settings['notification']=="pm") || ($this->arcade->settings['notification']=="pm+mail"))
								{
									$DB->query("INSERT INTO ibf_pmtext (fromuserid, fromusername, title, message, touserarray, iconid, dateline, showsignature, allowsmilie) VALUES ('".$senderid."', '".addslashes($sendername)."', '".addslashes($title)."', '" . addslashes($message) . "',  '" . addslashes(serialize(array($recipient))) . "', 0, " . TIMENOW . ", 0, 0)");
									$pmid = $DB->get_insert_id();
									$DB->query("UPDATE ibf_user SET pmtotal=pmtotal+1, pmunread=pmunread+1 WHERE userid=$recipient");
									$DB->query("INSERT INTO ibf_pm (pmtextid, userid, folderid, messageread) VALUES ('$pmid', '$recipient', '0', '0')");
								}
	
								// Notification via eMail
								if (($this->arcade->settings['notification']=="mail") || ($this->arcade->settings['notification']=="pm+mail"))
								{
									vbmail($recip['email'],$mailtitle,$mailmessage);
								}
							}
						}

						// finally update Highscore-Table
						if ( ($this->arcade->user['id'] != 0) && ($player_score <> 0) )
						{
        	                                	$DB->query("UPDATE ibf_games_champs SET ".$db_string." WHERE champ_gid=".$gid);
							$ginfo['champ_mid'] = $this->arcade->user['id'];
							$ginfo['champ_name'] = $this->arcade->user['name'];
							$ginfo['champ_score'] = $player_score;
						}
					}
				}
			}
			else
			{
				$db_string = $DB->compile_db_insert_string( array ( 'champ_gid'     => $gid,
                                	                                         'champ_gtitle'  => $ginfo['gtitle'],
                                        	                                 'champ_mid'     => $this->arcade->user['id'],
                                                	                         'champ_name'    => $this->arcade->user['name'],
                                                        	                 'champ_date'    => time(),
                                                                	    	 'champ_score'        => $player_score,
										'champ_time'	=> $timespent        ) );

        			if ($player_score <> 0)     // no champ with no result ...
        			{
                    			$DB->query("INSERT INTO ibf_games_champs (" .$db_string['FIELD_NAMES']. ") VALUES (". $db_string['FIELD_VALUES'] .")");
						$ginfo['champ_mid'] = $this->arcade->user['id'];
						$ginfo['champ_name'] = $this->arcade->user['name'];
						$ginfo['champ_score'] = $player_score;
        			}
            	}

			// best result of all time?   by MrZeropage
			if ($player_score <> 0)
			{
				$DB->query("SELECT gid, bestmid, bestscore, besttime, highscore_type FROM ibf_games_list WHERE gid=".$gid);
				if ($DB->get_num_rows())
				{
					// check if existing best result ever is lower
					$best = $DB->fetch_row();
					if (($best['bestscore'] < $player_score && $best['highscore_type'] == "high") || ($best['bestscore'] > $player_score && $best['highscore_type'] == "low") || (intval($best['bestscore'])==0) || ($best['bestscore']=="") || (($best['bestscore'] == $player_score) && (($best['besttime']==0) || ($best['besttime'] > $timespent))))
					{
						$userid=$this->arcade->user['id'];
						$DB->query("UPDATE ibf_games_list SET bestmid=".$userid.", bestscore=".$player_score.", besttime='".$timespent."' WHERE gid=$gid");
					}
				}
			}
			// end of b.r.o.a.t.

			if ( isset($player_score) && is_numeric($player_score) && isset($player_name) )
			{
				//Has this name played already?
				$gtime = time();

				$highsid = array();
				$highsid['s_id'] = 0;

				if( $this->arcade->settings['score_type'] == 'top' || empty($this->arcade->settings['score_type']) )
				{
					if ( $name_found == 1 )
					{
						// if name already exists, and score is good enough, update it
						if ( (($player_score > $score) && $ginfo['highscore_type'] == "high") || (($player_score < $score && $ginfo['highscore_type'] == "low") && $score != 0) || (($player_score == $score) && ($timespent < $usertime)) )
						{
							$db_string = $DB->compile_db_update_string( array ( 'score'             => $player_score,
                                                                                                 'datescored'          => $gtime,
												'ip' => $player_ip,
												'timespent' => $timespent  ) );
							$DB->query("UPDATE ibf_games_scores SET ".$db_string." WHERE mid=".$member_id." AND gid=".$gid);

							$good_score=1;
							$DB->query("SELECT s_id FROM ibf_games_scores WHERE score=".$player_score." AND datescored=".$gtime." AND gid=".$gid." AND mid=".$member_id." ORDER BY s_id DESC LIMIT 0, 1");
							$highsid = $DB->fetch_row();
						}
					}
					else
					{
						$good_score = 1;

						//Insert new name, score and ip
						if ($good_score==1)
						{
							$db_string = $DB->compile_db_insert_string( array ( 'mid'                          => $member_id,
        	                                                                                         'gid'                     => $gid,
                	                                                                                 'name'                    => $player_name,
                        			                                                         'score'                        => $player_score,
                                                 	                                                 'ip'                    => $player_ip,
                                                                                                        'timespent'                => $timespent,
                                                         		                                   'datescored'        => $gtime,
													'comment'	=> ''        ) );
							$DB->query("INSERT INTO ibf_games_scores
                                                          (" .$db_string['FIELD_NAMES']. ") VALUES
                                                   (". $db_string['FIELD_VALUES'] .")");
						//$getsid = $DB->get_insert_id();
						//$highsid['s_id']=$getsid;
						$DB->query("SELECT s_id FROM ibf_games_scores WHERE score=".$player_score." AND datescored=".$gtime." AND gid=".$gid." AND mid=".$member_id." ORDER BY s_id DESC LIMIT 0, 1");
						$highsid = $DB->fetch_row();
						}
					}
				}
				else
				{
                       		$good_score = 1;
                    		$db_string = $DB->compile_db_insert_string( array ( 'mid'                          => $member_id,
                                                                                 'gid'                     => $gid,
                                                                                 'name'                    => $player_name,
                                                                        'score'                        => $player_score,
                                                                                 'ip'                    => $player_ip,
                                                                                                                                                'timespent'                => $timespent,
                                                                            'datescored'        => $gtime,
										'comment'	=> ''        ) );
                    		$DB->query("INSERT INTO ibf_games_scores
                                                          (" .$db_string['FIELD_NAMES']. ") VALUES
                                                   (". $db_string['FIELD_VALUES'] .")");
					//$highsid = $DB->get_insert_id();
					//$highsid['s_id']=$getsid;
					$DB->query("SELECT s_id FROM ibf_games_scores ORDER BY s_id DESC LIMIT 0, 1");
					$highsid = $DB->fetch_row();
				}
			}

		if ($keepsess != 1)
		{
			// favorites-link
			$temp = unserialize($this->arcade->user['favs']);

                	if( !is_array($temp) )
                	{
                	 	$temp = array();
		        }

		        $favs = $temp;

		        $favtitle = $ibforums->lang['add_to_faves'];
		        $favtitle = preg_replace("/<% GAMENAME %>/i" , $game['gtitle'] , $favtitle);
		        $star = "";

		        if( in_array($ginfo['gid'] , $favs) )
		        {
		            //$star = "<img src='./arcade/images/favs.gif' title='".$ibforums->lang['favorite']."' alt='".$ibforums->lang['favorite']."' />&nbsp;";
		            $favtitle = $ibforums->lang['remove_from_faves'];
		            $favtitle = preg_replace("/<% GAMENAME %>/i" , $ginfo['gtitle'] , $favtitle);
		        }

		        if( $this->arcade->user['arcade_access'] == 2 && $this->arcade->user['id'] )
		        {
		                $ginfo['fave'] = "<a href='".$ibforums->base_url."act=Arcade&amp;module=favorites&amp;gameid=".$ginfo['gid']."' title='".$favtitle."'>$favtitle</a>";
		        }

			// make the link fit everything ;)
			$ginfo['backlink'] = $ibforums->lang['arcade_home'];
			if ($this->arcade->settings['use_cats'])
			{
				$ginfo['backlink'] = $ibforums->lang['showothersincat'];
			}

			$this->arcade->make_links($ginfo['gid'] , $ginfo['gtitle']);
                        $this->output .= $this->html->leaderstart($ginfo, $this->arcade->links);

           		$yscore[1] = $player_name;
			$yscore[2] = $this->arcade->do_arcade_format($player_score,$ginfo['decpoints']);
			$yscore[3] = $std->get_date($gtime,'LROW');
			$yscore[4] = $gid;
			$yscore[5] = $good_score;
			$yscore[6] = $this->arcade->thatdate($timespent);

			$ordering = ($ginfo['highscore_type'] == "high") ? "DESC" : "ASC";

			// set all League-Scores for this Game to default, as they get recalculated next
			$leaguearray = explode("," , $this->arcade->settings['league_scores'] );
			$DB->query("UPDATE ibf_games_league SET points='".$leaguearray[10]."', position='0' WHERE gid=".$gid);

			// calculate which scores should show up on page
			$s_query = $DB->query("SELECT COUNT(*) AS counter FROM ibf_games_scores WHERE gid=".$gid);
			$s_all = $DB->fetch_row($s_query);
			$s_all = $s_all['counter'];
			$s_limit = $this->arcade->settings['scores_amount'];

			$lookctr = 1; $s_pos = 0;
			$lookupquery = $DB->query("SELECT s_id, mid, name, score FROM ibf_games_scores WHERE gid=".$gid." ORDER BY score ".$ordering.",timespent ASC");
			while ($lookup = $DB->fetch_row($lookupquery))
			{
				if ((($highsid['s_id']!=0) && ($lookup['s_id']==$highsid['s_id'])) || (($highsid['s_id']=="0") && ($lookup['name']==$player_name)))
				{
					$s_pos = $lookctr;
				}
				$lookctr++;
			}

			if (($s_pos/$s_limit)==(floor($s_pos/$s_limit)))
			{
				$startpage = (floor($s_pos / $s_limit) * $s_limit)-$s_limit;
			}
			else
			{
				$startpage = floor($s_pos / $s_limit) * $s_limit;
			}

			$endpage = $startpage + $s_limit + 1;

			$startpage = $startpage;

			if ($endpage > $s_all)
			{
				$endpage = $s_all;
			}
			if ($startpage < 0)
			{
				$startpage = 0;
			}
			if ($endpage <= $startpage)
			{
				$endpage = $startpage + 1;
			}

			// setup LIMIT which should be at least 11 to make sure all Top10 get leaguepoints
			if ($endpage < 11)
			{
				$limitquery = "LIMIT 11";
			}
			else
			{
				$limitquery = "LIMIT ".$endpage; 
			}

			$this_query = $DB->query("SELECT s.*, g.opentag AS prefix, g.closetag AS suffix
										FROM ibf_games_scores AS s
			                			LEFT JOIN ibf_members AS m ON (m.userid=s.mid)
            			    			LEFT JOIN ibf_groups AS g ON (g.g_id=m.usergroupid)
										WHERE s.gid=".$gid."
										ORDER BY s.score ".$ordering.",s.timespent ASC ".$limitquery);

			$ctr=1;
			$rowcol = "alt2";
			while($lboard = $DB->fetch_row($this_query))
			{
				// parse the comment
				$vbversion = substr($vboptions[templateversion],0,3);	// Version 3.0 oder 3.5
				if ($vbversion == "3.0")
				{
					require_once('./includes/functions_bbcodeparse.php');		
					$parsed_comment = parse_bbcode($lboard['comment']);
				}
				else
				{
					require_once('./includes/class_bbcode.php');
					$bbcode_parser = new vB_BbCodeParser($vbulletin, fetch_tag_list());
					$parsed_comment = $bbcode_parser->parse($lboard['comment'],0,1);
				}
				$lboard['comment'] = $parsed_comment;

				if ($ibforums->lang[timeformat1]=="de")
				{
	                	        $std->time_options['LROW'] = "{$ibforums->lang['timeformat2']} \u\m {$ibforums->lang['timeformat3']}";
				}
				else
				{
		                        $std->time_options['LROW'] = "{$ibforums->lang['timeformat2']} {$ibforums->lang['timeformat3']}";
				}

				$formatteddate = $std->get_date($lboard['datescored'],'LROW');

				$usercell = "<a href='{$ibforums->base_url}act=Arcade&amp;module=report&amp;user={$lboard[mid]}'>";
				$usercell .= $lboard[prefix].$lboard[name].$lboard[suffix]."</a>";
				$datecell = $formatteddate;
				$scorecell = $this->arcade->do_arcade_format($lboard['score'],$ginfo['decpoints']);
				if ($lboard['timespent'] == 0)
                        	{
					$lboard['timespent'] = $ibforums->lang['n_a'];
				}
				else
				{
					$lboard['timespent'] = $this->arcade->thatdate($lboard['timespent']);
				}

				if($this->arcade->settings['skin'] != 0)
				{
					if($rowcol == "alt1")
					{
						$rowcol = "alt2";
					}
					else
					{
						$rowcol = "alt1";
					}
				}

				// only display scorelines that match the page needed
				if (($ctr > $startpage) && ($ctr < ($endpage+1)))
				{
					if ($ctr != $s_pos)
					{
						$this->output .= $this->html->leaderrow($lboard,$ctr,$usercell,$datecell,$scorecell,$rowcol);
					}
					else
					{
						if ($this->arcade->user['arcade_access']==3) { $yscore[5]=0; }
						if (($ctr==1 && $s_pos==1) && ($yscore[5]==1)) { $usercell = "<img src='./arcade/images/trophy.gif' alt=''>&nbsp;".$usercell."&nbsp;<img src='./arcade/images/trophy.gif' alt=''>"; }
						$commentcell=$lboard['comment'];
						if($yscore[5]==1)
						{
							$commentcell = "<form action=\"".$ibforums->base_url."act=Arcade&amp;do=stats&amp;gameid=".$yscore[4]."&amp;st=".$startpage."\" method=\"POST\">\n";
							$commentcell .= "<input type=\"text\" name=\"comment\" size=\"50\">&nbsp;&nbsp;\n";
							$commentcell .= "<input type=\"submit\" name=\"submitbtn\" value=\"".$ibforums->lang['save_comment']."\">\n";
							if( $this->arcade->settings['score_type'] == 'all' )
							{
								$commentcell .= "<input type=\"hidden\" name=\"s_id\" value=\"{$highsid[s_id]}\">";
							}
							$commentcell .= "</form>";
						}
						$data['comment'] = $commentcell;
						$data['timespent'] = $yscore[6];

						$vbversion = substr($vboptions[templateversion],0,3);
						if (($vbversion != "3.0") && ($NATIVEMODE==0))
						{
							($hook = vBulletinHook::fetch_hook('ibproarcade_play_game_finished')) ? eval($hook) : false;
						}

						$this->output .= $this->html->leaderrow($data,"<b>".$ctr."</b>","<b>".$usercell."</b>",$datecell,$scorecell,"alt1");
					}
				}

				switch($ctr)
				{
                                case 1: $points = $leaguearray[0];
                                break;
                                case 2: $points = $leaguearray[1];
                                break;
                                case 3: $points = $leaguearray[2];
                                break;
                                case 4: $points = $leaguearray[3];
                                break;
                                case 5: $points = $leaguearray[4];
                                break;
                                case 6: $points = $leaguearray[5];
                                break;
                                case 7: $points = $leaguearray[6];
                                break;
                                case 8: $points = $leaguearray[7];
                                break;
                                case 9: $points = $leaguearray[8];
                                break;
                                case 10: $points = $leaguearray[9];
                                break;
                                default: $points = $leaguearray[10];
				}

				// ***** LEAGUE finally fixed by MrZeropage :) *****
				if (($ctr < 11) && ($points != $leaguearray[10]))
				{
					// check if that player already has an entry for that game
					$DB->query("SELECT gid, mid, lid FROM ibf_games_league WHERE gid=".$gid." AND mid=".$lboard['mid']." AND position=0");					
					if ($DB->get_num_rows())
					{
						// already in league, so just update the entry
						$onerow = $DB->fetch_row();
		
		                               	$db_string = $DB->compile_db_update_string( array (
									'mid'   => $lboard['mid'],
									'gid'   => $gid,
									'position'      => $ctr,
									'points'        => $points,
									'cat'                => $ginfo['gcat']
									) );
						$DB->query("UPDATE ibf_games_league SET ".$db_string." WHERE gid=".$gid." AND mid=".$lboard['mid']." AND lid=".$onerow['lid']);
					}
					else
					{	
							// new entry in league
		                               	$db_string = $DB->compile_db_insert_string( array (
									'mid'   => $lboard['mid'],
									'gid'   => $gid,
									'position'      => $ctr,
									'points'        => $points,
									'cat'                => $ginfo['gcat']
									) );
						$DB->query("INSERT INTO ibf_games_league (" .$db_string['FIELD_NAMES']. ") VALUES (". $db_string['FIELD_VALUES'] .")");
					}
				}

				// ***** end of League *****

				$ctr++;
			}

			$this->output .= $this->html->stop($this->arcade->links['pages']);

			if ($yscore[5]!=1)     // show information if score is not stored because of main settings 
			{
				if ($this->arcade->user['arcade_access']==3)
				{
					$this->output .= "<div align='center'><font color='red'>".$ibforums->lang['not_recorded_guest']."</font></div><br />";
				}
				else
				{
					$this->output .= "<div align='center'><font color='red'>".$ibforums->lang['not_recorded']."</font></div><br />";
				}
			}

			$this->output .= "<div align='center'><a href='".$ibforums->base_url."act=Arcade&amp;do=play&amp;gameid=".$gid."'>".$ibforums->lang['play_again']."</a></div><br />";

			$rating = "";
			$rating = $ibforums->lang['rating'];
			$raters = unserialize($ginfo['g_raters']);

			if (isset($raters[$this->arcade->user['id']]) || $this->arcade->user['id']==0)
			{
				// no output for rating (guestplayer or already rated this game)
			}
			else
			{
				if( empty($ginfo['g_raters']) )
				{
					$rating .= $ibforums->lang['no_votes'];
				}
				else
				{
					$amount = count($raters).$ibforums->lang['rates'];
					for( $a = 1 ; $a <= $ginfo['g_rating'] ; $a++ )
					{
						$rating .= "<img src='./arcade/images/star1.gif' title='".$amount."' alt='".$amount."' />";
					}
					$leftover = (5-$ginfo['g_rating']);
					for( $a = 1 ; $a <= $leftover ; $a++ )
					{
						$rating .= "<img src='./arcade/images/star2.gif' title='".$amount."' alt='".$amount."' />";
					}
				}

				$this->output .= "<div align='center'>".$rating."<br />";
				$this->output .= "<a href=\"#\" onclick=\"window.open('{$ibforums->base_url}act=Arcade&amp;do=rate&amp;gid={$gid}&amp;scored=1','comment_edit','height=150,width=400'); return false;\">{$ibforums->lang['rate_game']}</a></div><br /><br />";
			}

			$this->page_title = $ibforums->vars['board_name']." -> ".$ibforums->lang['page_title']." -> ".$ibforums->lang['hscores_title'];
			$this->nav        = array( "<a href='".$ibforums->base_url."act=Arcade&amp;cat=".$ginfo['gcat']."'>{$ibforums->lang['page_title']}</a>", "{$ibforums->lang['hscores_title']}" );

	}
	else
	{
		// PNfg! This means we have to update the league now...
		$leaguearray = explode("," , $this->arcade->settings['league_scores'] );
		$DB->query("UPDATE ibf_games_league SET points='".$leaguearray[10]."', position='0' WHERE gid=".$gid);

		$game_query = $DB->query("SELECT * FROM ibf_games_list WHERE gid=".$gid);
		$ginfo = $DB->fetch_row($game_query);
		$ordering = ($ginfo['highscore_type'] == "high") ? "DESC" : "ASC";

		$ctr = 1;
		$this_query = $DB->query("SELECT mid FROM ibf_games_scores WHERE gid='".$gid."' ORDER BY score ".$ordering.", timespent ASC LIMIT 0,10");
		if ($DB->get_num_rows($this_query))
		{
			while($lboard = $DB->fetch_row($this_query))
			{
				switch($ctr)
				{
					case 1: $points = $leaguearray[0];
					break;
					case 2: $points = $leaguearray[1];
					break;
					case 3: $points = $leaguearray[2];
					break;
					case 4: $points = $leaguearray[3];
					break;
					case 5: $points = $leaguearray[4];
					break;
					case 6: $points = $leaguearray[5];
					break;
					case 7: $points = $leaguearray[6];
					break;
					case 8: $points = $leaguearray[7];
					break;
					case 9: $points = $leaguearray[8];
					break;
					case 10: $points = $leaguearray[9];
					break;
					default: $points = $leaguearray[10];
				}

				if ($points > 0)
				{
					extract($ginfo);
					$mid = $this->arcade->user['id'];

					// check if that player already has an entry for that game
					$DB->query("SELECT gid, mid, lid FROM ibf_games_league WHERE gid=".$gid." AND mid=".$mid." AND position=0");					
					if ($DB->get_num_rows())
					{
						// already in league, so just update the entry
						$onerow = $DB->fetch_row();
		
		                               	$db_string = $DB->compile_db_update_string( array (
									'mid'   => $mid,
									'gid'   => $gid,
									'position'      => $ctr,
									'points'        => $points,
									'cat'                => $ginfo['gcat']
									) );
						$DB->query("UPDATE ibf_games_league SET ".$db_string." WHERE gid=".$gid." AND mid=".$mid." AND lid=".$onerow['lid']);
					}
					else
					{	
						// new entry in league
		                               	$db_string = $DB->compile_db_insert_string( array (
									'mid'   => $mid,
									'gid'   => $gid,
									'position'      => $ctr,
									'points'        => $points,
									'cat'                => $ginfo['gcat']
									) );
						$DB->query("INSERT INTO ibf_games_league (" .$db_string['FIELD_NAMES']. ") VALUES (". $db_string['FIELD_VALUES'] .")");
					}
				}
				$ctr++;
			}
		}		
	}

		}
		elseif($tgame==1)
		{
			$tid = intval($_COOKIE['tidstarted']);

			$tquery = $DB->query("SELECT nbtries,cost,numplayers,gid FROM ibf_tournaments WHERE tid = '".$tid."' LIMIT 1");
			$row = $DB->fetch_row($tquery);
			$nbtries = $row['nbtries'];
			$jackpot = $row['cost'] * $row['numplayers'];

			// get Game-Settings
			$gamequery = $DB->query("SELECT gid, bestmid, bestscore, besttime, highscore_type, gtitle FROM ibf_games_list WHERE gid=".$row['gid']);
			$gameinfo=$DB->fetch_row($gamequery);
			$scoretype=$gameinfo['highscore_type'];

			// best result of all time?   by MrZeropage
			if ($player_score <> 0)
			{
				// check if existing best result ever is lower
				if ( (($gameinfo['bestscore'] < $player_score) && $scoretype == "high") || (($gameinfo['bestscore'] > $player_score) && $scoretype == "low") || (empty($gameinfo['bestscore'])) || ( ($gameinfo['bestscore'] == $player_score) && (($gameinfo['besttime']==0) || ($gameinfo['besttime'] > $timespent))))
				{
					$userid=$this->arcade->user['id'];
					$DB->query("UPDATE ibf_games_list SET bestmid=".$userid.", bestscore='".$player_score."', besttime='".$timespent."' WHERE gid=".$gid);
				}
			}

                        // Check to see if this faceoff in this rung has been played.
                        $tourneyquery = $DB->query("SELECT rung,rungscore,timeplayed,faceoff,timesplayed FROM ibf_tournament_players WHERE mid=".$this->arcade->user['id']." AND tid=".$tid." ORDER BY rung DESC");

                        $ctr = 0;
                        while($row = $DB->fetch_row($tourneyquery))
			{
                      		if($row['timesplayed'] <= $nbtries)
				{
                           		$ctr++;
                                }
                                $savearray[0] = $row['rung'];
                                $savearray[1] = $row['rungscore'];
                                $savearray[2] = $row['timeplayed'];
                                $savearray[3] = $row['faceoff'];
                                $savearray[4] = $this->arcade->user['id'];
                                $savearray[5] = $tid;
                                $savearray[6] = $row['timesplayed'];
                        }

                        if($ctr > 0)
			{
				$thisscore = $player_score;
				if ( (($thisscore > $savearray[1]) && $scoretype == "high") || (($thisscore > 0 && $savearray[1]==0) && $scoretype == "low") || (($thisscore < $savearray[1]) && $scoretype == "low") && ($thisscore != 0) )
				{
	                                // Save new game score in that spot
	                                $DB->query("UPDATE ibf_tournament_players SET rungscore=".$player_score.", timeplayed='".time()."', notified=0 WHERE mid=".$this->arcade->user['id']." AND tid=".$tid." AND rung=".$savearray[0]);
	                        	$savearray[1] = $thisscore;
	                	}
				else
				{
	                                $DB->query("UPDATE ibf_tournament_players SET timeplayed='".time()."', notified=0 WHERE mid=".$this->arcade->user['id']." AND tid=".$tid." AND rung=".$savearray[0]);
				}
	      		}
			else
			{
	  			$this->view_tourney($tid);
	       			return;
	   		}

		// see if the opponent has played yet
		$DB->query("SELECT * FROM ibf_tournament_players WHERE tid=".$tid." AND rung=".$savearray[0]." AND faceoff='".$savearray[3]."' AND mid <> '".$savearray[4]."' LIMIT 0, 1");
		$opponentinfo = $DB->fetch_row();

		$advancetourney=0;
		if($opponentinfo['timesplayed'] < $nbtries || $savearray[6] < $nbtries)
		{
			// check if the result could be clear before all Games are played

			// opponent is finished ?
			if ($opponentinfo['timesplayed']==$nbtries)
			{
				if (($savearray[1] > $opponentinfo['rungscore'] && $scoretype == "high") || ($savearray[1] < $opponentinfo['rungscore'] && $savearray[1]>0 && $scoretype == "low"))
				{
					// just beaten your opponent, so advance to next round :)
					$advancetourney=1;
					$savearray[6]=$nbtries;
				}
			}

			// player himself is finished ?
			if ($savearray[6]==$nbtries)
			{
				if (($savearray[1] < $opponentinfo['rungscore'] && $scoretype == "high") || ($savearray[1] > $opponentinfo['rungscore'] && $opponentinfo['rungscore']>0 && $scoretype == "low"))
				{
					// player did not reach opponent, so advance to next round :)
					$advancetourney=1;
					$opponentinfo['timesplayed']=$nbtries;
				}
			}

		} 
		else
		{
			$advancetourney=1;
		}

		if ($advancetourney==1)
		{
			if($savearray[3] == 1 || $savearray[3] == 2)
			{
				$nextfaceoff=1;
			} 
			else
			{
				$nextfaceoff=2;
			}

			if (($savearray[0] == 1) && ($opponentinfo['rungscore'] != $savearray[1]))
			{
				if (($opponentinfo['rungscore'] >= $savearray[1] && $scoretype == "high") || ($opponentinfo['rungscore'] < $savearray[1] && $opponentinfo['rungscore']>0 && $scoretype == "low"))
				{
					$winner = $opponentinfo['mid'];
					$loser	= $savearray[4];

				} 
				else 	
				{
					$winner = $savearray[4];
					$loser	= $opponentinfo['mid'];
				}

				$DB->query("SELECT name,id FROM ibf_members WHERE id='".$winner."' LIMIT 1");
				$name = $DB->fetch_row();
				$DB->query("UPDATE ibf_tournaments SET champion='".ibp_cleansql($name['name'])."' WHERE tid=".$tid);

				$DB->query("UPDATE ibf_tournament_players_statut SET statut='1' WHERE tid='".$tid."' AND mid='".$loser."'");
				$DB->query("UPDATE ibf_tournament_players_statut SET statut='3' WHERE tid='".$tid."' AND mid='".$winner."'");

				// Notification to winner by MrZeropage :-)
				if ($this->arcade->settings['msgsys_twin']==1)
				{
					$senderid = $this->arcade->user['id'];
					$sendername = $this->arcade->user['name'];
					$recipient = $winner;
	
					$vbversion = substr($vboptions[templateversion],0,3);	// Version 3.0 oder 3.5
					if ($vbversion == "3.0")
					{
						$forumlink = $vboptions['bburl']."/";
					}
					else
					{
						$forumlink = $vbulletin->options['bburl']."/";
					}
					
					$title = $ibforums->lang['pmnote_winner'];
					$mailtitle = $ibforums->lang['pmnote_winner'];
	
					$message = $this->arcade->settings['msgsys_twin_text'];
					$mailmessage = $this->arcade->settings['msgsys_twin_text'];
	
					$message = preg_replace('/%NAME%/',$name['name'],$message);
					$message = preg_replace('/%GAME%/',$gameinfo['gtitle'],$message);
					$message = preg_replace("#%LINK\|(.*?)%#","[url='".$forumlink."arcade.php?do=viewtourney&tid=".$tid."']$1[/url]",$message);
	
					$mailmessage = preg_replace('/%NAME%/',$name['name'],$mailmessage);
					$mailmessage = preg_replace('/%GAME%/',$gameinfo['gtitle'],$mailmessage);
					$mailmessage = preg_replace("#%LINK\|(.*?)%#","<a href='".$forumlink."arcade.php?do=viewtourney&tid=".$gid."'>$1</a>",$mailmessage);
	
					$mailmessage = strip_bbcode($mailmessage, true);
					$mailmessage = preg_replace('/<\/?[a-z][a-z0-9]*[^<>]*>/i', '', $mailmessage);

					// does the recipient want to receive any Notifications from the Arcade ?
					$DB->query("SELECT arcade_pmactive, email FROM ibf_user WHERE userid=$recipient");
					$recip = $DB->fetch_row();
	
					// check for possible Guest-Player
					if ($guestplayerid == $recipient)
					{ $recip['arcade_pmactive']=0; }	

					if ($recip['arcade_pmactive'] == 1)
					{
							// Notification via PM
						if (($this->arcade->settings['notification']=="pm") || ($this->arcade->settings['notification']=="pm+mail"))
						{
							$DB->query("INSERT INTO ibf_pmtext (fromuserid, fromusername, title, message, touserarray, iconid, dateline, showsignature, allowsmilie) VALUES ('".$senderid."', '".addslashes($sendername)."', '".addslashes($title)."', '" . addslashes($message) . "',  '" . addslashes(serialize(array($recipient))) . "', 0, " . TIMENOW . ", 0, 0)");
							$pmid = $DB->get_insert_id();
							$DB->query("UPDATE ibf_user SET pmtotal=pmtotal+1, pmunread=pmunread+1 WHERE userid=$recipient");
							$DB->query("INSERT INTO ibf_pm (pmtextid, userid, folderid, messageread) VALUES ('$pmid', '$recipient', '0', '0')");
						}

						// Notification via eMail
						if (($this->arcade->settings['notification']=="mail") || ($this->arcade->settings['notification']=="pm+mail"))
						{
							vbmail($recip['email'],$mailtitle,$mailmessage);
						}
					}
				}
	
				$vbversion = substr($vboptions[templateversion],0,3);
				if (($vbversion != "3.0") && ($NATIVEMODE==0))
				{
					($hook = vBulletinHook::fetch_hook('ibproarcade_tourney_won')) ? eval($hook) : false;
				}

				$this->view_tourney($tid);
				return;
			}

			$timenow = time();

			if ($opponentinfo['rungscore'] == $savearray[1])
			{
				// both opponents finally have same result, so give both one more try
				$DB->query("UPDATE ibf_tournament_players SET timesplayed=timesplayed-1, timeplayed='".$timenow."', notified=0 WHERE tid='".$tid."' AND mid='".$opponentinfo['mid']."' AND rung='".$opponentinfo['rung']."'");
				$DB->query("UPDATE ibf_tournament_players SET timesplayed=timesplayed-1, timeplayed='".$timenow."', notified=0 WHERE tid='".$tid."' AND mid='".$savearray['4']."' AND rung='".$savearray[0]."'");
			}
			else
			{
				if (($opponentinfo['rungscore'] > $savearray[1] && $scoretype == "high") || ($opponentinfo['rungscore'] < $savearray[1] && $scoretype == "low"))
				{
					// opponent has won
					$db_string = $DB->compile_db_insert_string( array ( 	'mid'		=> $opponentinfo['mid'],
	                                                                                 	'tid'		=> $tid,
	                                                                                 	'rung'		=> ($opponentinfo['rung']-1),
	                                                                        		'rungscore'	=> 0,
        	                                                                         	'faceoff'	=> $nextfaceoff,
	                                                                            		'timeplayed'	=> $timenow,
	                                                                        		'timesplayed'	=> 0,
												'notified'	=> 0,        ) );
	
	                    		$DB->query("INSERT INTO ibf_tournament_players (" .$db_string['FIELD_NAMES']. ") VALUES (". $db_string['FIELD_VALUES'] .")");
					$DB->query("UPDATE ibf_tournament_players_statut SET statut='1' WHERE tid='".$tid."' AND mid='".$savearray[4]."'");

					// check if there is an opponent (to set back his timer)
					$check=$DB->query("SELECT mid FROM ibf_tournament_players WHERE tid=".$tid." AND faceoff=".$nextfaceoff." AND rung=".($opponentinfo['rung']-1)." AND mid<>".$opponentinfo['mid']);
					if ($row = $DB->fetch_row($check))
					{
						$DB->query("UPDATE ibf_tournament_players SET timeplayed='".$timenow."', notified=0 WHERE tid=".$tid." AND faceoff=".$nextfaceoff." AND rung=".($opponentinfo['rung']-1)." AND mid=".$row['mid']);
					}

					// fill up tries in old rung
					$DB->query("UPDATE ibf_tournament_players SET timesplayed=".$nbtries.", notified=1 WHERE tid=".$tid." AND rung=".$opponentinfo['rung']." AND mid=".$opponentinfo['mid']);

					// set data for notifications
					$winnerid = $opponentinfo['mid'];
					$loserid = $this->arcade->user['id'];
	              		} 
				else 
				{
					// player has won
					$db_string = $DB->compile_db_insert_string( array ( 	'mid'		=> $savearray[4],
	                                                                                 	'tid'		=> $savearray[5],
	                                                                                 	'rung'		=> ($savearray[0]-1),
	                                                                        		'rungscore'	=> 0,
	                                                                                 	'faceoff'	=> $nextfaceoff,
	                                                                            		'timeplayed'	=> $timenow,
	                                                                        		'timesplayed'	=> 0,
												'notified'	=> 0,        ) );
	
					$DB->query("INSERT INTO ibf_tournament_players (" .$db_string['FIELD_NAMES']. ") VALUES (". $db_string['FIELD_VALUES'] .")");
					$DB->query("UPDATE ibf_tournament_players_statut SET statut='1' WHERE tid='".$tid."' AND mid='".$opponentinfo['mid']."'");

					// check if there is an opponent (to set back his timer)
					$check=$DB->query("SELECT mid FROM ibf_tournament_players WHERE tid=".$savearray[5]." AND faceoff=".$nextfaceoff." AND rung=".($savearray[0]-1)." AND mid<>".$savearray[4]);
					if ($row = $DB->fetch_row($check))
					{
						$DB->query("UPDATE ibf_tournament_players SET timeplayed='".$timenow."', notified=0 WHERE tid=".$savearray[5]." AND faceoff=".$nextfaceoff." AND rung=".($savearray[0]-1)." AND mid=".$row['mid']);
					}

					// fill up tries in old rung
					$DB->query("UPDATE ibf_tournament_players SET timesplayed=".$nbtries.", notified=1 WHERE tid=".$savearray[5]." AND rung=".$savearray[0]." AND mid=".$savearray[4]);

					// set data for notifications
					$loserid = $opponentinfo['mid'];
					$winnerid = $this->arcade->user['id'];
					$tid = $savearray[5];
				}

				// Notifications by MrZeropage
				$senderid = $this->arcade->user['id'];
				$sendername = $this->arcade->user['name'];

				if ($senderid == $winnerid)
				{
					$winnername = $sendername;
					$getnamequery=$DB->query("SELECT username FROM ibf_user WHERE userid=".$loserid);
					$getname = $DB->fetch_row($getnamequery);
					$losername = $getname['username'];
				}
				else
				{
					$losername = $sendername;
					$getnamequery=$DB->query("SELECT username FROM ibf_user WHERE userid=".$winnerid);
					$getname = $DB->fetch_row($getnamequery);
					$winnername = $getname['username'];
				}

				$vbversion = substr($vboptions[templateversion],0,3);	// Version 3.0 oder 3.5
				if ($vbversion == "3.0")
				{
					$forumlink = $vboptions['bburl']."/";
				}
				else
				{
					$forumlink = $vbulletin->options['bburl']."/";
				}
					
				$title = $ibforums->lang['pmnote_elim'];
				$mailtitle = $ibforums->lang['pmnote_elim'];

				$message = $this->arcade->settings['msgsys_telim_text'];
				$mailmessage = $this->arcade->settings['msgsys_telim_text'];

				$message = preg_replace('/%NAME%/',$losername,$message);
				$message = preg_replace('/%OTHER%/',$winnername,$message);
				$message = preg_replace('/%GAME%/',$gameinfo['gtitle'],$message);
				$message = preg_replace("#%LINK\|(.*?)%#","[url='".$forumlink."arcade.php?do=viewtourney&tid=".$tid."']$1[/url]",$message);

				$mailmessage = preg_replace('/%NAME%/',$losername,$mailmessage);
				$mailmessage = preg_replace('/%OTHER%/',$winnername,$mailmessage);
				$mailmessage = preg_replace('/%GAME%/',$gameinfo['gtitle'],$mailmessage);
				$mailmessage = preg_replace("#%LINK\|(.*?)%#","<a href='".$forumlink."arcade.php?do=viewtourney&tid=".$tid."'>$1</a>",$mailmessage);

				$mailmessage = strip_bbcode($mailmessage, true);
				$mailmessage = preg_replace('/<\/?[a-z][a-z0-9]*[^<>]*>/i', '', $mailmessage);

				$recipient = $loserid;

				// does the recipient want to receive any Notifications from the Arcade ?
				$DB->query("SELECT arcade_pmactive, email FROM ibf_user WHERE userid=$recipient");
				$recip = $DB->fetch_row();
	
				// check for possible Guest-Player
				if ($guestplayerid == $recipient)
				{ $recip['arcade_pmactive']=0; }	

				if (($recip['arcade_pmactive'] == 1) && ($this->arcade->settings['msgsys_telim']==1))
				{
					// Notification via PM
					if (($this->arcade->settings['notification']=="pm") || ($this->arcade->settings['notification']=="pm+mail"))
					{
						$DB->query("INSERT INTO ibf_pmtext (fromuserid, fromusername, title, message, touserarray, iconid, dateline, showsignature, allowsmilie) VALUES ('".$senderid."', '".addslashes($sendername)."', '".addslashes($title)."', '" . addslashes($message) . "',  '" . addslashes(serialize(array($recipient))) . "', 0, " . TIMENOW . ", 0, 0)");
						$pmid = $DB->get_insert_id();
						$DB->query("UPDATE ibf_user SET pmtotal=pmtotal+1, pmunread=pmunread+1 WHERE userid=$recipient");
						$DB->query("INSERT INTO ibf_pm (pmtextid, userid, folderid, messageread) VALUES ('$pmid', '$recipient', '0', '0')");
					}

					// Notification via eMail
					if (($this->arcade->settings['notification']=="mail") || ($this->arcade->settings['notification']=="pm+mail"))
					{
						vbmail($recip['email'],$mailtitle,$mailmessage);
					}
				}

				// and now to the winner of the match...
				$title = $ibforums->lang['pmnote_adv'];
				$mailtitle = $ibforums->lang['pmnote_adv'];

				$message = $this->arcade->settings['msgsys_tadvance_text'];
				$mailmessage = $this->arcade->settings['msgsys_tadvance_text'];

				$message = preg_replace('/%NAME%/',$winnername,$message);
				$message = preg_replace('/%OTHER%/',$losername,$message);
				$message = preg_replace('/%GAME%/',$gameinfo['gtitle'],$message);
				$message = preg_replace("#%LINK\|(.*?)%#","[url='".$forumlink."arcade.php?do=viewtourney&tid=".$tid."']$1[/url]",$message);

				$mailmessage = preg_replace('/%NAME%/',$winnername,$mailmessage);
				$mailmessage = preg_replace('/%OTHER%/',$losername,$mailmessage);
				$mailmessage = preg_replace('/%GAME%/',$gameinfo['gtitle'],$mailmessage);
				$mailmessage = preg_replace("#%LINK\|(.*?)%#","<a href='".$forumlink."arcade.php?do=viewtourney&tid=".$tid."'>$1</a>",$mailmessage);

				$mailmessage = strip_bbcode($mailmessage, true);
				$mailmessage = preg_replace('/<\/?[a-z][a-z0-9]*[^<>]*>/i', '', $mailmessage);

				$recipient = $winnerid;

				// does the recipient want to receive any Notifications from the Arcade ?
				$DB->query("SELECT arcade_pmactive, email FROM ibf_user WHERE userid=$recipient");
				$recip = $DB->fetch_row();
	
				// check for possible Guest-Player
				if ($guestplayerid == $recipient)
				{ $recip['arcade_pmactive']=0; }	

				if (($recip['arcade_pmactive'] == 1) && ($this->arcade->settings['msgsys_tadvance']==1))
				{
					// Notification via PM
					if (($this->arcade->settings['notification']=="pm") || ($this->arcade->settings['notification']=="pm+mail"))
					{
						$DB->query("INSERT INTO ibf_pmtext (fromuserid, fromusername, title, message, touserarray, iconid, dateline, showsignature, allowsmilie) VALUES ('".$senderid."', '".addslashes($sendername)."', '".addslashes($title)."', '" . addslashes($message) . "',  '" . addslashes(serialize(array($recipient))) . "', 0, " . TIMENOW . ", 0, 0)");
						$pmid = $DB->get_insert_id();
						$DB->query("UPDATE ibf_user SET pmtotal=pmtotal+1, pmunread=pmunread+1 WHERE userid=$recipient");
						$DB->query("INSERT INTO ibf_pm (pmtextid, userid, folderid, messageread) VALUES ('$pmid', '$recipient', '0', '0')");
					}

					// Notification via eMail
					if (($this->arcade->settings['notification']=="mail") || ($this->arcade->settings['notification']=="pm+mail"))
					{
						vbmail($recip['email'],$mailtitle,$mailmessage);
					}
				}
			}

			if ($keepsess == 1)
			{
				// tournament-game, so change gametype to normal game after first result
				$DB->query("UPDATE ibf_members SET arcade_gtype='0' WHERE id=".$this->arcade->user['id']);
			}
			else
			{
				$this->view_tourney($tid);
			}
		}
		else
		{
			if ($keepsess == 1)
			{
				// tournament-game, so change gametype to normal game after first result
				$DB->query("UPDATE ibf_members SET arcade_gtype='0' WHERE id=".$this->arcade->user['id']);
			}
			else
			{
				$this->view_tourney($tid);
			}
		}
	}

?>
