<?php
/*======================================================================*\
|| #################################################################### ||
|| # Copyright  BananaLive Scripts. All Rights Reserved. ############# ||
|| #################################################################### ||
\*======================================================================*/

error_reporting(E_ALL & ~E_NOTICE);
define('THIS_SCRIPT', 'competitions');
if ($_REQUEST['do'] && in_array($_REQUEST['do'], array('addannouncement', 'editannouncement', 'editrules', 'addtab', 'edittab', 'addhelp', 'newhelp')))
{
define('GET_EDIT_TEMPLATES', true);
}
$phrasegroups = array('posting', 'postbit', 'user', 'timezone', 'global', 'pm', 'reputationlevel', 'search');
$specialtemplates = array(
	'bbcodecache',
	'smiliecache',
	'tll_catcache',
);
$globaltemplates = array(
	'tmnt_shell'
);
$actiontemplates = array(
	'addannouncement' => array(
		'tmnt_newannouncement'
	),
	'editannouncement' => array(
		'tmnt_editann'
	),
	'editrules' => array(
		'tmnt_editrules'
	),
	'announcements' => array(
		'tmnt_noannouncements',
		'tmnt_listann',
		'tmnt_listann_top',
		'tmnt_listann_bot'
	),
	'playerstats' => array(
		'tmnt_playerstats'
	),
	'rules' => array(
		'tmnt_displayrules'
	),
	'help' => array(
		'tmnt_help'
	),
	'feed' => array(
		'tmnt_feed'
	),
	'addtab' => array(
		'tmnt_addtab'
	),
	'edittab' => array(
		'tmnt_addtab'
	),
	'viewannouncement' => array(
		'tmnt_displayannouncement'
	),
	'editcategory' => array(
		'tmnt_editcat'
	),
	'addcategory' => array(
		'tmnt_newcategory'
	),
	'addhelp' => array(
		'tmnt_newhelp'
	),
	'newhelp' => array(
		'tmnt_newhelp'
	),
	'categories' => array(
		'tmnt_listcat',
		'tmnt_nocategories',
		'tmnt_listcat_con'
	),
	'latest' => array(
		'tmnt_noannouncements',
		'tmnt_listann',
		'tmnt_index_tbit',
		'tmnt_notmnts',
		'tmnt_index_lbit',
		'tmnt_ladder_noladders',
		'tmnt_index'
	),
	'editbanners' => array(
		'tmnt_editbanners'
	),
	'landing' => array(
		'tmnt_carousel',
		'tmnt_cat',
		'tmnt_fp_warlights',
		'tmnt_fpblock_anns',
		'tmnt_fpblock_threads',
		'tmnt_ladder_list_rm',
		'tmnt_ladder_list_rm_alt',
		'tmnt_landing_grid',
		'tmnt_fp_bigt',
		'tmnt_fpblock_credits',
		'tmnt_fpblock_tllk',
		'tmnt_fpblock_tllk2',
		'tmnt_index_kbit',
		'tmnt_index_tbit',
		'tmnt_index_lbit',
		'tmnt_fpblock_comments',
		'tmnt_hof',
		'tmnt_random_torp',
		'tmnt_fpblock_ynextm',
		'tmnt_fpblock_anns_alt',
	),
	'none' => array(
		'tmnt_index_tbit',
		'tmnt_notmnts',
		'tmnt_nokings',
		'tmnt_index_kbit',
		'tmnt_index_lbit',
		'tmnt_ladder_noladders',
		'tmnt_fp_warlights',
		'tmnt_ladder_list_rm',
		'tmnt_hof',
		'tmnt_fpblock_credits',
		'tmnt_fpblock_anns',
		'tmnt_fpblock_comments',
		'tmnt_fpblock_twins',
		'tmnt_index_c',
		'tmnt_random_torp',
		'tmnt_cat',
		'tmnt_fpblock_comments',
		'tmnt_hof',
		'tmnt_random_torp',
		'tmnt_fpblock_ynextm',
		'tmnt_fpblock_anns_alt',
		'tmnt_carousel',
		'tmnt_fp_bigt',
		'tmnt_fpblock_tllk',
		'tmnt_fpblock_tllk2',
		'tmnt_ladder_list_rm_alt',
		'tmnt_landing_grid',
		'tmnt_fpblock_image_slider'
	)
);

require_once('./global.php');
require_once(DIR . '/includes/functions.php');
require_once(DIR . '/includes/functions_tal.php');

$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'' => construct_phrase('Error')
	));
	$navbar = render_navbar_template($navbits);
	
// #############################################################################

if ($_REQUEST['do'] == 'killann')
{
	if (!$tmntp['canedittmnt'])
	{
		print_no_permission();
	}
    $id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	if (!$id)
	{
		$errormessage = $vbphrase[error_invalid_announcement];
        eval(standard_error($errormessage));
	}
    $vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "tmnt_announcements WHERE id=$id");
	$vbulletin->url = "competitions.php?do=announcements";
	eval(print_standard_redirect('redirect_killann'));
}

// #############################################################################

if ($_REQUEST['do'] == 'autocashout')
{
require_once(DIR . '/includes/functions_tll_prem.php');	
	tll_auto_cashout($vbulletin->userinfo['userid']);
	eval(standard_error('Done auto cash out'));
}

// #############################################################################

if ($_REQUEST['do'] == 'killcategory')
{
	if (!$tmntp['canedittmnt'])
	{
		print_no_permission();
	}
    $catid = $vbulletin->input->clean_gpc('g', 'catid', TYPE_UINT);
	if (!$catid)
	{
		$errormessage = $vbphrase[error_invalid_category];
        eval(standard_error($errormessage));
	}
    $vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "tmnt_categories WHERE catid = '$catid' ");
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladders SET catid = 0 WHERE catid = '$catid' ");
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_tmnts SET catid = 0 WHERE catid = '$catid' ");
	build_tll_catcache();
	$vbulletin->url = "competitions.php?do=categories";
	eval(print_standard_redirect('redirect_killcategory'));
}

// #############################################################################

if ($_POST['do'] == 'insertannouncement')
{
	if (!$tmntp['canedittmnt'])
	{
		print_no_permission();
	}
	$userid = $vbulletin->input->clean_gpc('p', 'userid', TYPE_UINT);
		if (!$userid) {
			$userid = $thisuserid;
		}
	$title = $vbulletin->input->clean_gpc('p', 'title', TYPE_STR);
		if (!$title) {
			$errormessage = $vbphrase[error_invalid_title];
			eval(standard_error($errormessage));
		}
	$vbulletin->input->clean_array_gpc('p', array(
		'message'      => TYPE_STR,
		'icon'      => TYPE_NOHTML,
		'wysiwyg'			 => TYPE_BOOL,
	));
	if ($vbulletin->GPC['wysiwyg'] && $vbulletin->options['simpleversion'] < 414)
	{
		require_once(DIR . '/includes/functions_wysiwyg.php');
		$description = convert_wysiwyg_html_to_bbcode($vbulletin->GPC['message'], 1);
	}
	else if ($vbulletin->GPC['wysiwyg'])
	{
		require_once(DIR . '/includes/class_wysiwygparser.php');
		$html_parser = new vB_WysiwygHtmlParser($vbulletin);
		$description = $html_parser->parse_wysiwyg_html_to_bbcode($vbulletin->GPC['message']);
	}
	else
	{
		$description = $vbulletin->GPC['message'];
	}
		if (!$description) 
		{
			$errormessage = $vbphrase[error_invalid_message];
			eval(standard_error($errormessage));
		}
	$ip = $_SERVER['REMOTE_ADDR'];
	$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "tmnt_announcements
		(title, announcement, userid, time, ip, icon)
		VALUES ('".$vbulletin->db->escape_string($title)."', '".$vbulletin->db->escape_string($description)."', '".$vbulletin->db->escape_string($userid)."', ".TIMENOW.", '".$vbulletin->db->escape_string($ip)."', '".$vbulletin->db->escape_string($vbulletin->GPC['icon'])."')
		");
	$id = $vbulletin->db->insert_id();
	$vbulletin->url = "competitions.php?do=viewannouncement&id=".$id;	
	eval(print_standard_redirect('redirect_inserteann'));
}

// #############################################################################

if ($_REQUEST['do'] == 'addannouncement')
{
	if (!$tmntp['canedittmnt']) {
		print_no_permission();
	}
	require_once(DIR . '/includes/functions_editor.php');
	if  ($vbulletin->options['simpleversion'] < 414)
	{
		$editorid = construct_edit_toolbar('', 0, 'nonforum', iif($vbulletin->options['privallowsmilies'], 1, 0));
	}
	else
	{
		$editorid = construct_edit_toolbar('');
	}
	$templater = vB_Template::create('tmnt_newannouncement');
	$templater->register('editorid', $editorid);
	$templater->register('messagearea', $messagearea);
	$templater->register('id', $id);
	$templater->register('tmntp', $tmntp);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'' => construct_phrase($vbphrase['tmnt_newannouncement'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_POST['do'] == 'updateannouncement')
{
	$id = $vbulletin->input->clean_gpc('p', 'id', TYPE_UINT);
	if (!$id)
	{
		$errormessage = $vbphrase[error_invalid_announcement];
		eval(standard_error($errormessage));
	}
	if (!$tmntp['canedittmnt'])
	{
		print_no_permission();
	}
    $userid = $vbulletin->userinfo['userid'];
	$title = $vbulletin->input->clean_gpc('p', 'title', TYPE_STR);
	if (!$title) 
	{
		$errormessage = $vbphrase[error_invalid_title];
		eval(standard_error($errormessage));
	}
	$vbulletin->input->clean_array_gpc('p', array(
		'message'      => TYPE_STR,
		'icon'      => TYPE_NOHTML,
		'wysiwyg'			 => TYPE_BOOL,
	));
	if ($vbulletin->GPC['wysiwyg'] && $vbulletin->options['simpleversion'] < 414)
	{
		require_once(DIR . '/includes/functions_wysiwyg.php');
		$description = convert_wysiwyg_html_to_bbcode($vbulletin->GPC['message'], 1);
	}
	else if ($vbulletin->GPC['wysiwyg'])
	{
		require_once(DIR . '/includes/class_wysiwygparser.php');
		$html_parser = new vB_WysiwygHtmlParser($vbulletin);
		$description = $html_parser->parse_wysiwyg_html_to_bbcode($vbulletin->GPC['message']);
	}
	else
	{
		$description = $vbulletin->GPC['message'];
	}
	if (!$description) 
	{
		$errormessage = $vbphrase[error_invalid_message];
		eval(standard_error($errormessage));
	}
	$ip = $_SERVER['REMOTE_ADDR'];
	$show['edit'] = false;
	if (($permissions['genericoptions'] & $vbulletin->bf_ugp['genericoptions']['showeditedby']))
	{
		$show['edit'] = true;
	}
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "tmnt_announcements 
			SET title = '".$vbulletin->db->escape_string($title)."', 
			announcement = '".$vbulletin->db->escape_string($description)."'
			" . ($show['edit'] ? ", le_userid = '".$userid."', le_time =".TIMENOW."" : "") . ",
			le_ip = '".$vbulletin->db->escape_string($ip)."',
			icon = '".$vbulletin->db->escape_string($vbulletin->GPC['icon'])."'
		WHERE id='$id' ");
	$vbulletin->url = "competitions.php?do=viewannouncement&id=".$id;	
	eval(print_standard_redirect('redirect_updateann'));
}

// #############################################################################

if ($_POST['do'] == 'updaterules')
{
	if (!$tmntp['canedittmnt']) {
		print_no_permission();
	}
    $userid = $vbulletin->input->clean_gpc('p', 'userid', TYPE_UINT);
		if (!$userid) {
			$userid = $thisuserid;
		}
	$vbulletin->input->clean_array_gpc('p', array(
		'message'      => TYPE_STR,
		'wysiwyg'			 => TYPE_BOOL,
	));
	if ($vbulletin->GPC['wysiwyg'] && $vbulletin->options['simpleversion'] < 414) 
	{
		require_once(DIR . '/includes/functions_wysiwyg.php');
		$description = convert_wysiwyg_html_to_bbcode($vbulletin->GPC['message'], 1);
	}
	else if ($vbulletin->GPC['wysiwyg'])
	{
		require_once(DIR . '/includes/class_wysiwygparser.php');
		$html_parser = new vB_WysiwygHtmlParser($vbulletin);
		$description = $html_parser->parse_wysiwyg_html_to_bbcode($vbulletin->GPC['message']);
	}
	else 
	{
		$description = $vbulletin->GPC['message'];
	}
	$show['edit'] = false;
	if (($permissions['genericoptions'] & $vbulletin->bf_ugp['genericoptions']['showeditedby']))
	{
		$show['edit'] = true;
	}
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_rules SET rules = '".$vbulletin->db->escape_string($description)."'". ($show['edit'] ? ", le_userid = $userid, le_time =".TIMENOW."" : "") . " WHERE id=1 ");
	$vbulletin->url = "competitions.php?do=rules";	
	eval(print_standard_redirect('redirect_updaterules'));
}

// #############################################################################

if ($_REQUEST['do'] == 'editannouncement')
{
    if (!$tmntp['canedittmnt']) {
		print_no_permission();
	}
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	if (!$id) {
		$errormessage = $vbphrase[error_invalid_announcement];
        eval(standard_error($errormessage));
	}
	$ann = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_announcements WHERE id=$id");
	$title       = $ann['title'];
	$description = $ann['announcement'];
	require_once(DIR . '/includes/functions_editor.php');
	if ($vbulletin->options['simpleversion'] < 414)
	{
		$editorid = construct_edit_toolbar($description, 0, 'nonforum', iif($vbulletin->options['privallowsmilies'], 1, 0));
	}
	else
	{
		$editorid = construct_edit_toolbar($description);
	}
	$templater = vB_Template::create('tmnt_editann');
		$templater->register('editorid', $editorid);
		$templater->register('messagearea', $messagearea);
		$templater->register('ann', $ann);
		$templater->register('title', $title);
		$templater->register('description', $description);
		$templater->register('id', $id);
		$templater->register('tmntp', $tmntp);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'competitions.php?do=announcements' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['announcements'],
		'competitions.php?do=viewannouncement&amp;id=' . $id . $vbulletin->session->vars['sessionurl_q'] => $title,
		'' => construct_phrase($vbphrase[tmnt_editann])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'editrules')
{
    if (!$tmntp['canedittmnt']) {
		print_no_permission();
	}
	$query_rules = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_rules WHERE id=1");
	$rules = $query_rules['rules'];
	require_once(DIR . '/includes/functions_editor.php');
	if ($vbulletin->options['simpleversion'] < 414)
	{
		$editorid = construct_edit_toolbar($rules, 0, 'nonforum', iif($vbulletin->options['privallowsmilies'], 1, 0));
	}
	else
	{
		$editorid = construct_edit_toolbar($rules);
	}
	$templater = vB_Template::create('tmnt_editrules');
		$templater->register('rules', $rules);
		$templater->register('editorid', $editorid);
		$templater->register('messagearea', $messagearea);
		$templater->register('tmntp', $tmntp);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'competitions.php?do=rules' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['tmnt_rules'],
		'' => construct_phrase($vbphrase[tmnt_editrules])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_POST['do'] == 'inserttab')
{
	if (!$tmntp['canedittmnt'] OR !file_exists(DIR . '/includes/functions_tll_tabs.php'))
	{
		print_no_permission();
	}
	$vbulletin->input->clean_array_gpc('p', array(
		'message' => TYPE_STR,
		'wysiwyg' => TYPE_BOOL,
		'title' => TYPE_NOHTML,
		'displayorder' => TYPE_UINT,
		'kid' => TYPE_UINT,
		'lid' => TYPE_UINT,
		'tid' => TYPE_UINT,
	));
	if (!$vbulletin->GPC['title'])
	{
		$errormessage = $vbphrase[error_invalid_title];
		eval(standard_error($errormessage));
	}
	if ($vbulletin->GPC['wysiwyg'] && $vbulletin->options['simpleversion'] < 414)
	{
		require_once(DIR . '/includes/functions_wysiwyg.php');
		$html = convert_wysiwyg_html_to_bbcode($vbulletin->GPC['message'], 1);
	}
	else if ($vbulletin->GPC['wysiwyg'])
	{
		require_once(DIR . '/includes/class_wysiwygparser.php');
		$html_parser = new vB_WysiwygHtmlParser($vbulletin);
		$html = $html_parser->parse_wysiwyg_html_to_bbcode($vbulletin->GPC['message']);
	}
	else
	{
		$html = $vbulletin->GPC['message'];
	}
	if (!$html)
	{
		$errormessage = $vbphrase[error_invalid_description];
		eval(standard_error($errormessage));
	}
	$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "tmnt_tabs
		(title, html, displayorder, tid, kid, lid)
		VALUES (
			'".$vbulletin->db->escape_string($vbulletin->GPC['title'])."', 
			'".$vbulletin->db->escape_string($html)."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['displayorder'])."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['tid'])."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['kid'])."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['lid'])."'
		)
	");
	if ($vbulletin->GPC['tid'])
	{
		$vbulletin->url = "tournaments.php?do=view&id=".$vbulletin->GPC['tid'];	
	}
	if ($vbulletin->GPC['kid'])
	{
		$vbulletin->url = "kings.php?do=view&id=".$vbulletin->GPC['kid'];	
	}
	if ($vbulletin->GPC['lid'])
	{
		$vbulletin->url = "ladders.php?do=view&id=".$vbulletin->GPC['lid'];	
	}
	eval(print_standard_redirect('redirect_inserttab'));
}

// #############################################################################

if ($_POST['do'] == 'updatetab')
{
	if (!$tmntp['canedittmnt'] OR !file_exists(DIR . '/includes/functions_tll_tabs.php'))
	{
		print_no_permission();
	}
	$vbulletin->input->clean_array_gpc('p', array(
		'message' => TYPE_STR,
		'wysiwyg' => TYPE_BOOL,
		'title' => TYPE_NOHTML,
		'displayorder' => TYPE_UINT,
		'id' => TYPE_UINT,
		'kid' => TYPE_UINT,
		'lid' => TYPE_UINT,
		'tid' => TYPE_UINT,
	));
	if (!$vbulletin->GPC['title'])
	{
		$errormessage = $vbphrase[error_invalid_title];
		eval(standard_error($errormessage));
	}
	if ($vbulletin->GPC['wysiwyg'] && $vbulletin->options['simpleversion'] < 414)
	{
		require_once(DIR . '/includes/functions_wysiwyg.php');
		$html = convert_wysiwyg_html_to_bbcode($vbulletin->GPC['message'], 1);
	}
	else if ($vbulletin->GPC['wysiwyg'])
	{
		require_once(DIR . '/includes/class_wysiwygparser.php');
		$html_parser = new vB_WysiwygHtmlParser($vbulletin);
		$html = $html_parser->parse_wysiwyg_html_to_bbcode($vbulletin->GPC['message']);
	}
	else
	{
		$html = $vbulletin->GPC['message'];
	}
	if (!$html)
	{
		$errormessage = $vbphrase[error_invalid_description];
		eval(standard_error($errormessage));
	}
	
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "tmnt_tabs
		SET `title` = '".$vbulletin->db->escape_string($vbulletin->GPC['title'])."',
			`html` = '".$vbulletin->db->escape_string($html)."',
			`displayorder` = '".$vbulletin->db->escape_string($vbulletin->GPC['displayorder'])."',
			`tid` = '".$vbulletin->db->escape_string($vbulletin->GPC['tid'])."',
			`kid` = '".$vbulletin->db->escape_string($vbulletin->GPC['kid'])."',
			`lid` = '".$vbulletin->db->escape_string($vbulletin->GPC['lid'])."'
		WHERE id = '".$vbulletin->GPC['id']."'
	");
	if ($vbulletin->GPC['tid'])
	{
		$vbulletin->url = "tournaments.php?do=view&id=".$vbulletin->GPC['tid'];	
	}
	if ($vbulletin->GPC['kid'])
	{
		$vbulletin->url = "kings.php?do=view&id=".$vbulletin->GPC['kid'];	
	}
	if ($vbulletin->GPC['lid'])
	{
		$vbulletin->url = "ladders.php?do=view&id=".$vbulletin->GPC['lid'];	
	}
	eval(print_standard_redirect('redirect_inserttab'));
}

// #############################################################################

if ($_REQUEST['do'] == 'deletetab')
{
	if (!$tmntp['canedittmnt'] OR !file_exists(DIR . '/includes/functions_tll_tabs.php'))
	{
		print_no_permission();
	}
	$tid = $vbulletin->input->clean_gpc('g', 'tid', TYPE_UINT);
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	$tab = $vbulletin->db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_tabs 
		WHERE id = '$id'
	");
	if ($tab['tid'])
	{
		$url = "tournaments.php?do=view&id=".$tab['tid'];	
	}
	if ($tab['kid'])
	{
		$url = "kings.php?do=view&id=".$tab['kid'];	
	}
	if ($tab['lid'])
	{
		$url = "ladders.php?do=view&id=".$tab['lid'];	
	}
	if (!$_REQUEST['confirm'])
	{
		$errormessage = "Are you sure you want to delete this tab?<br /><br />This cannot be undone!<br><br><a href=\"competitions.php?do=deletetab&amp;id=".$id."&amp;confirm=1\" class=\"button\">Yes</a> <a href=\"".$url."\" class=\"button\">No</a>";
		eval(standard_error($errormessage));
	}
	$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "tmnt_tabs WHERE id='$id' ");
	$vbulletin->url = $url;
	eval(print_standard_redirect('redirect_deletetab'));
}


// #############################################################################

if ($_REQUEST['do'] == 'deletehelp')
{
	if (!$tmntp['canadminhelp'])
	{
		print_no_permission();
	}
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	if (!$_REQUEST['confirm'])
	{
		$errormessage = "Are you sure you want to delete this FAQ?<br /><br />This cannot be undone!<br><br><a href=\"competitions.php?do=deletehelp&amp;id=".$id."&amp;confirm=1\" class=\"button\">Yes</a> <a href=\"competitions.php?do=help&amp;id=".$id."\" class=\"button\">No</a>";
		eval(standard_error($errormessage));
	}
	$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "tmnt_help WHERE id='$id' ");
	$vbulletin->url = 'competitions.php?do=help';
	eval(print_standard_redirect('redirect_deletehelp'));
}

// #############################################################################

if ($_REQUEST['do'] == 'edittab')
{
	if (!$tmntp['canedittmnt'] OR !file_exists(DIR . '/includes/functions_tll_tabs.php'))
	{
		print_no_permission();
	}
	$tid = $vbulletin->input->clean_gpc('g', 'tid', TYPE_UINT);
	$lid = $vbulletin->input->clean_gpc('g', 'lid', TYPE_UINT);
	$kid = $vbulletin->input->clean_gpc('g', 'kid', TYPE_UINT);
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	$tab = $vbulletin->db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_tabs 
		WHERE id = '$id'
	");
	$tid = $tab['tid'];
	$lid = $tab['lid'];
	$kid = $tab['kid'];
	$tmnt = $vbulletin->db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_tmnts 
		WHERE id = '$tid'
	");
	$ladder = $vbulletin->db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_ladders 
		WHERE id = '$lid'
	");
	require_once(DIR . '/includes/functions_editor.php');
	if ($vbulletin->options['simpleversion'] < 414)
	{
		$editorid = construct_edit_toolbar($tab['html'], 0, 'nonforum', iif($vbulletin->options['privallowsmilies'], 1, 0));
	}
	else
	{
		$editorid = construct_edit_toolbar($tab['html']);
	}
	$templater = vB_Template::create('tmnt_addtab');
		$templater->register('tmntp', $tmntp);
		$templater->register('tab', $tab);
		$templater->register('tid', $tid);
		$templater->register('lid', $lid);
		$templater->register('kid', $kid);
		$templater->register('id', $id);
		$templater->register('messagearea', $messagearea);
		$templater->register('editorid', $editorid);
	$tlhtml .= $templater->render();
	$navbits = array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname
	);
	if ($tmnt)
	{
		$navbits['tournaments.php'] = $vbphrase['tmnts'];
		$navbits["tournaments.php?do=view&id=$tid"] = $tmnt['title'];
	}
	if ($ladder)
	{
		$navbits['ladders.php'] = $vbphrase['ladders'];
		$navbits["ladders.php?do=view&id=$lid"] = $ladder['title'];
	}
	$navbits[] = construct_phrase($vbphrase['tmnt_edittab']);
	$navbits = construct_navbits($navbits);
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('headinclude', $headinclude);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('tlhtml', $tlhtml);
		$templater->register('modname', $modname);
		$templater->register('header', $header);
		$templater->register('footer', $footer);
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'addtab')
{
	if (!$tmntp['canedittmnt'] OR !file_exists(DIR . '/includes/functions_tll_tabs.php'))
	{
		print_no_permission();
	}
	$tid = $vbulletin->input->clean_gpc('g', 'tid', TYPE_UINT);
	$lid = $vbulletin->input->clean_gpc('g', 'lid', TYPE_UINT);
	$kid = $vbulletin->input->clean_gpc('g', 'kid', TYPE_UINT);
	$tmnt = $vbulletin->db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_tmnts 
		WHERE id = '$tid'
	");
	$ladder = $vbulletin->db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_ladders 
		WHERE id = '$lid'
	");
	$king = $vbulletin->db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_kings 
		WHERE id = '$kid'
	");
	require_once(DIR . '/includes/functions_editor.php');
	if ($vbulletin->options['simpleversion'] < 414)
	{
		$editorid = construct_edit_toolbar($message, 0, 'nonforum', iif($vbulletin->options['privallowsmilies'], 1, 0));
	}
	else
	{
		$editorid = construct_edit_toolbar($message);
	}
	$templater = vB_Template::create('tmnt_addtab');
		$templater->register('tmntp', $tmntp);
		$templater->register('tab', $tab);
		$templater->register('tid', $tid);
		$templater->register('lid', $lid);
		$templater->register('messagearea', $messagearea);
		$templater->register('editorid', $editorid);
	$tlhtml .= $templater->render();
	$navbits = array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname
	);
	if ($tmnt)
	{
		$navbits['tournaments.php'] = $vbphrase['tmnts'];
		$navbits["tournaments.php?do=view&id=$tid"] = $tmnt['title'];
	}
	if ($ladder)
	{
		$navbits['ladders.php'] = $vbphrase['ladders'];
		$navbits["ladders.php?do=view&id=$lid"] = $ladder['title'];
	}
	$navbits[] = construct_phrase($vbphrase['tmnt_addtab']);
	$navbits = construct_navbits($navbits);
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('headinclude', $headinclude);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('tlhtml', $tlhtml);
		$templater->register('modname', $modname);
		$templater->register('header', $header);
		$templater->register('footer', $footer);
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'announcements') 
{
	$templater = vB_Template::create('tmnt_listann_top');
	$tlhtml .= $templater->render();
	$anns = $vbulletin->db->query_read("
		SELECT ann.*, user.username, user.usertitle
		FROM " . TABLE_PREFIX . "tmnt_announcements AS ann
		LEFT JOIN " . TABLE_PREFIX . "user AS user
			ON ann.userid = user.userid
		ORDER BY ann.id DESC
	");
	$user_lastvisit = $vbulletin->userinfo['lastvisit'];
	$rowcount = 0;
	while($ann = $vbulletin->db->fetch_array($anns))
	{
		$new = false;
		if ($ann['time'] >= $user_lastvisit) {
			$new = true;
		}
		$ann['date']      = vbdate($vbulletin->options['dateformat'], $ann['time'], 1);
		$ann['time']      = vbdate($vbulletin->options['timeformat'], $ann['time']);
		$templater = vB_Template::create('tmnt_listann');
		$templater->register('ann', $ann);
		$templater->register('new', $new);
		$templater->register('tmntp', $tmntp);
		$tlhtml .= $templater->render();
		$rowcount++;
	}
	if ($rowcount == 0) {
		$templater = vB_Template::create('tmnt_noannouncements');
		$tlhtml .= $templater->render();
	}
	$templater = vB_Template::create('tmnt_listann_bot');
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'' => construct_phrase($vbphrase['announcements'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'rebuildcaches')
{
	build_tll_catcache();
	$errormessage = $vbphrase['tmnt_rebuildcaches'];
	eval(standard_error($errormessage));
}

// #############################################################################

if ($_REQUEST['do'] == 'playerstats')
{	
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	$u = $vbulletin->input->clean_gpc('g', 'u', TYPE_UINT);
	$userid = $vbulletin->input->clean_gpc('g', 'userid', TYPE_UINT);
	if (!$id AND $u) {
		$id = $u;
	} elseif (!$id AND $userid) {
		$id = $userid;
	} if (!$id) {
		$errormessage = $vbphrase[error_no_userid];
		eval(standard_error($errormessage));
	}
	$counttmnt = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_players WHERE userid='$id'");
	$counttmnt = $counttmnt['countrows'];  
	$countwins = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_players WHERE userid=$id AND winner='1'");
	$countwins = $countwins['countrows'];
	$userdetail = $vbulletin->db->query_first("SELECT usergroupid, username, usertitle FROM " . TABLE_PREFIX . "user WHERE userid=$id");
		$username  = $userdetail['username'];
		$usertitle = $userdetail['usertitle'];
		$usergroup = $userdetail['usergroupid'];
	if (!$username)
	{
		$errormessage = $vbphrase[error_no_userid];
		eval(standard_error($errormessage));
	}
	$templater = vB_Template::create('tmnt_playerstats');
		$templater->register('username', $username);
		$templater->register('usertitle', $usertitle);
		$templater->register('usergroup', $usergroup);
		$templater->register('counttmnt', $counttmnt);
		$templater->register('countwins', $countwins);
		$templater->register('userdetail', $userdetail);
		$templater->register('id', $id);
		$templater->register('userid', $userid);
		$templater->register('tmntp', $tmntp);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'' => construct_phrase($vbphrase['tmnt_xs_stats'], $username)
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'rules')
{
	require_once(DIR . '/includes/class_bbcode.php');
	$query_rules = $vbulletin->db->query_first("
		SELECT rules.*, user.username AS le_username
		FROM " . TABLE_PREFIX . "tmnt_rules AS rules
		LEFT JOIN " . TABLE_PREFIX . "user AS user
			ON rules.le_userid = user.userid
	");
	$rules       = $query_rules['rules'];
	$le_userid   = $query_rules['le_userid'];
	$le_username = $query_rules['le_username'];
	$le_time     = vbdate($vbulletin->options['dateformat'],$query_rules['le_time'], 1).$vbphrase['tmnt_at'].vbdate($vbulletin->options['timeformat'],$query_rules['le_time']);
	$bbcode_parser = new vB_BbCodeParser($vbulletin, fetch_tag_list(), true); 
	$rules = $bbcode_parser->do_parse($rules,false,true,true,true,true,false);
	$templater = vB_Template::create('tmnt_displayrules');
		$templater->register('rules', $rules);
		$templater->register('tmntp', $tmntp);
		$templater->register('le_userid', $le_userid);
		$templater->register('le_username', $le_username);
		$templater->register('le_time', $le_time);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'' => construct_phrase($vbphrase['tmnt_rules'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################


if ($_POST['do'] == 'importhelp')
{
	if (!$tmntp['canadminhelp'])
	{
		print_no_permission();
	}
	require_once(DIR . '/includes/adminfunctions.php');
	$vbulletin->input->clean_array_gpc('f', array(
		'formfile' => TYPE_FILE
	));
	if (file_exists($vbulletin->GPC['formfile']['tmp_name']))
	{
		$xml = file_read($vbulletin->GPC['formfile']['tmp_name']);
	}
	else
	{
		$errormessage = $vbphrase[no_file_to_import];
       	eval(standard_error($errormessage));
	}
	$refs = array();
	$fs = $vbulletin->db->query_read("SELECT ref FROM " . TABLE_PREFIX . "tmnt_help");
	while ($f = $vbulletin->db->fetch_array($fs))
	{
		$refs[] = $f['ref'];
	}
	require_once(DIR . '/includes/class_xml.php');
	$xmlobj = new vB_XML_Parser($xml);
	if ($xmlobj->error_no == 1)
	{
		$errormessage = $vbphrase[form_error_no_xml_path];
       	eval(standard_error($errormessage));
	}
	if(!$arr = $xmlobj->parse())
	{
		$errormessage = "XML Error " . $xmlobj->error_string() . " at line " . $xmlobj->error_line();
       	eval(standard_error($errormessage));
	}
	//print_r($arr);
	if (is_array($arr['faqs']['faq']))
	{
		$faqs = $arr['faqs']['faq'];
		if (!isset($faqs[0]))
		{
			$faqs = array($faqs);
		}
	}
	elseif (is_array($arr['faq']))
	{
		$faqs = $arr['faq'];
		if (!isset($faqs[0]))
		{
			$faqs = array($faqs);
		}
	}
	$repeated = $successful = array();
	if (is_array($faqs))
	{
		foreach ($faqs AS $faq)
		{
			if (in_array($faq['ref'], $refs))
			{
				$repeated[] = '<span title="Ref: '.$faq['ref'].'">'.$faq['title']."</span>";
			}
			else
			{
				$vbulletin->db->query_write("
					INSERT INTO " . TABLE_PREFIX . "tmnt_help
						(dateline, ref, title, helptext, category, usergroups)
					VALUES
						('" . TIMENOW . "',
						'" . $vbulletin->db->escape_string($faq['ref']) . "',
						'" . $vbulletin->db->escape_string($faq['title']) . "',
						'" . $vbulletin->db->escape_string($faq['helptext']) . "',
						'" . $vbulletin->db->escape_string($faq['category']) . "',
						'" . $vbulletin->db->escape_string($faq['usergroups']) . "'
						)
				");
				$successful[] = '<span title="Ref: '.$faq['ref'].'">'.$faq['title']."</span>";
			}
		}
	}
	$errormessage = 'The following FAQs were successfully imported: <ul>';
	foreach($successful AS $a)
	{
		$errormessage .= "<li>$a</li>";
	}
	$errormessage .= '</ul> The following FAQs were skipped, as we detected they may be duplicated: <ul>';
	foreach($repeated AS $a)
	{
		$errormessage .= "<li>$a</li>";
	}
	$errormessage .= '</ul> <br> <a href="competitions.php?do=help">Return to FAQs list</a>';
	eval(standard_error($errormessage));
}

// #############################################################################

if ($_REQUEST['do'] == 'exporthelp')
{
	if (!$tmntp['canadminhelp'])
	{
		print_no_permission();
	}
	require_once(DIR . '/includes/class_xml.php');
	$xml = new vB_XML_Builder($vbulletin);
	$xml->add_group('faqs');
	$fs = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "tmnt_help");
	while ($f = $vbulletin->db->fetch_array($fs))
	{
		$xml->add_group('faq', array(
			'id' => $f['id'],
			'ref' => $f['ref'],
			'dateline'  => $f['dateline'],
			'dateline_edited' => $f['dateline_edited'],
		));
				$xml->add_tag('helptext', $f['helptext']);
				$xml->add_tag('category', $f['category']);
				$xml->add_tag('title', $f['title']);
				$xml->add_tag('usergroups', $f['usergroups']);
		$xml->close_group();
	}
	
	$xml->close_group();
	
	$doc = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\r\n\r\n" . $xml->output();
	
	unset($xml);

	require_once(DIR . '/includes/functions_file.php');
	file_download($doc, "export-tll_faqs-" . date('d_m_Y') . '.xml', 'text/xml');
	
	exit;
}

// #############################################################################

if ($_REQUEST['do'] == 'help')
{
	require_once(DIR . '/includes/class_bbcode.php');
	if (!in_array($_REQUEST['sh'], array(1,2,3)))
	{
		$sh = 1;
	}
	else
	{
		$sh = $vbulletin->input->clean_gpc('g', 'sh', TYPE_UINT);
	}
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	if ($id)
	{
		$thishelp = $vbulletin->db->query_first("
			SELECT h.*, u.username
			FROM " . TABLE_PREFIX . "tmnt_help AS h
			LEFT JOIN " . TABLE_PREFIX . "user AS u
				ON h.userid = u.userid
			WHERE h.id = '$id'
		");
		$bbcode_parser = new vB_BbCodeParser($vbulletin, fetch_tag_list(), true); 
		$thishelp['helptext'] = $bbcode_parser->do_parse($thishelp['helptext'],false,true,true,true,true,false);
		$thishelp['helptext'] = str_replace('{bburl}', substr($vbulletin->options['bburl'], 7), $thishelp['helptext']);
		$thishelp['helptext'] = preg_replace("/{youtube=[.*]}/", '<iframe title="YouTube video player" width="384" height="241" src="http://www.youtube.com/embed/\1" frameborder="0"></iframe>', $thishelp['helptext']);
	}
	else
	{
		$s = 1;
		$harray = array();
		$hq = $vbulletin->db->query_read("
			SELECT h.*, u.username
			FROM " . TABLE_PREFIX . "tmnt_help AS h
			LEFT JOIN " . TABLE_PREFIX . "user AS u
				ON h.userid = u.userid
			ORDER BY h.category ASC,
				h.title ASC
		");
		while($h = $vbulletin->db->fetch_array($hq))
		{
			if ($h['id'] == $vbulletin->GPC['id'])
			{
				$thishelp = $h;
			}
			if ($last_cat != '' && $last_cat != $h['category'])
			{
				$s++;
				$h['newcat'] = true;
			}
			elseif (!$last_cat)
			{
				$h['newcat'] = true;
			}
			else
			{
				$h['newcat'] = false;
			}
			$harray[] = $h;
			$last_cat = $h['category'];
		}
	}
	$templater = vB_Template::create('tmnt_help');
		$templater->register('tmntp', $tmntp);
		$templater->register('sh', $sh);
		$templater->register('show', $show);
		$templater->register('harray', $harray);
		$templater->register('thishelp', $thishelp);
	$tlhtml = $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'' => construct_phrase($vbphrase['tmnt_help'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}


// #############################################################################

if ($_REQUEST['do'] == 'viewannouncement')
{	
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	if (!$id)
	{
		$errormessage = $vbphrase[error_invalid_announcement];
        eval(standard_error($errormessage));
	}
	require_once(DIR . '/includes/class_bbcode.php');
	$ann = $vbulletin->db->query_first("
		SELECT ann.*, user.username, user.usertitle
		FROM " . TABLE_PREFIX . "tmnt_announcements AS ann
		LEFT JOIN " . TABLE_PREFIX . "user AS user
			ON user.userid = ann.userid
		WHERE ann.id = $id
	");
	if (!$ann)
	{
		$errormessage = $vbphrase[error_invalid_announcement];
        eval(standard_error($errormessage));
	}
	$title       = $ann['title'];
	$userid      = $ann['userid'];
	$username    = $ann['username'];
	$usertitle   = $ann['usertitle'];
	$ip          = $ann['ip'];
	$time        = vbdate($vbulletin->options['dateformat'],$ann['time'], 1)." ".vbdate($vbulletin->options['timeformat'],$ann['time']);
	if ($ann['le_userid'] != 0)
	{
		$le_ip       = $ann['le_ip'];
		$le_userid   = $ann['le_userid'];
		$le_userinfo = fetch_userinfo($le_userid);
		$le_username = $le_userinfo[username];
		$le_time     = vbdate($vbulletin->options['dateformat'],$ann['le_time'], 1).$vbphrase['tmnt_at'].vbdate($vbulletin->options['timeformat'],$ann['le_time']);
	}
	$bbcode_parser = new vB_BbCodeParser($vbulletin, fetch_tag_list(), true); 
	$announcement = $bbcode_parser->do_parse($ann['announcement'],false,true,true,true,true,false);
	$templater = vB_Template::create('tmnt_displayannouncement');
	$templater->register('le_ip', $le_ip);
	$templater->register('le_userid', $le_userid);
	$templater->register('le_userinfo', $le_userinfo);
	$templater->register('le_username', $le_username);
	$templater->register('le_time', $le_time);
	$templater->register('ip', $ip);
	$templater->register('id', $id);
	$templater->register('userid', $userid);
	$templater->register('userinfo', $userinfo);
	$templater->register('username', $username);
	$templater->register('time', $time);
	$templater->register('tmntp', $tmntp);
	$templater->register('round', $round);
	$templater->register('announcement', $announcement);
	$templater->register('ann', $ann);
	$templater->register('title', $title);
	$templater->register('ann', $ann);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'competitions.php?do=announcements' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['announcements'],
		'' => construct_phrase($title)
	));
	$navbar = render_navbar_template($navbits);
	/*$templater = vB_Template::create('memberinfo_css');
	$memberinfo_css = $templater->render();*/
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}


// #############################################################################

if ($_POST['do'] == 'updatecategory')
{
	if (!$tmntp['canedittmnt'])
	{
		print_no_permission();
	}
	$catid = $vbulletin->input->clean_gpc('p', 'catid', TYPE_UINT);
		if (!$catid)
		{
			$errormessage = $vbphrase[error_invalid_category];
        	eval(standard_error($errormessage));
		}
	$title = $vbulletin->input->clean_gpc('p', 'title', TYPE_NOHTML);
		if (!$title)
		{
			$errormessage = $vbphrase[error_invalid_title];
			eval(standard_error($errormessage));
		}
	$description = $vbulletin->input->clean_gpc('p', 'description', TYPE_NOHTML);
	$banner = $vbulletin->input->clean_gpc('p', 'banner', TYPE_NOHTML);
	$displayorder = $vbulletin->input->clean_gpc('p', 'displayorder', TYPE_UINT);
	$tol = implode(',',$vbulletin->input->clean_gpc('p', 'tol', TYPE_ARRAY_NOHTML));
	$parentid = $vbulletin->input->clean_gpc('p', 'parentid', TYPE_UINT);
	$icon = $vbulletin->input->clean_gpc('p', 'icon', TYPE_NOHTML);
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "tmnt_categories
		SET
			title = '".$vbulletin->db->escape_string($title)."',
			description = '".$vbulletin->db->escape_string($description)."',
			displayorder = '".$vbulletin->db->escape_string($displayorder)."',
			tol = '".$vbulletin->db->escape_string($tol)."',
			parentid = '".$vbulletin->db->escape_string($parentid)."',
			icon = '".$vbulletin->db->escape_string($icon)."',
			banner = '".$vbulletin->db->escape_string($banner)."'
		WHERE catid = '$catid'
	");
	if ($tol == 1)
	{
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladders SET catid = 0 WHERE catid = '$catid' ");
	}
	elseif ($tol == 2)
	{
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_tmnts SET catid = 0 WHERE catid = '$catid' ");
	}
	build_tll_catcache();
	$vbulletin->url = "competitions.php?do=categories";	
	eval(print_standard_redirect('redirect_updatecat'));
}

// #############################################################################

if ($_REQUEST['do'] == 'editcategory')
{
    if (!$tmntp['canedittmnt'])
	{
		print_no_permission();
	}
	$catid = $vbulletin->input->clean_gpc('g', 'catid', TYPE_UINT);
	if (!$catid)
	{
		$errormessage = $vbphrase[error_invalid_category];
        eval(standard_error($errormessage));
	}
	$cats = array();
	$cat = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_categories WHERE catid='$catid'");
	if (!$cat)
	{
		$errormessage = $vbphrase[error_invalid_category];
        eval(standard_error($errormessage));
	}
	$categories = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "tmnt_categories WHERE parentid = 0 AND catid != '$catid'");
	while($category = $vbulletin->db->fetch_array($categories))
	{
		if ($category['catid'] == $cat['parentid'])
		{
			$category['selected'] = ' selected="selected"';
		}
		$cats[] = $category;
	}
	$tol = $cat['tol'];
	$selected = array();
	switch ($cat['tol'])
	{
		case 1:
			$cat['tol'] = array('tmnts');
			break;
		case 2:
			$cat['tol'] = array('ladders','leagues');
			break;
		case 3:
			$cat['tol'] = array('tmnts','ladders','leagues','kings');
			break;
		default:
			$cat['tol'] = explode(',', $cat['tol']);
			break;
	}
	foreach ($cat['tol'] AS $aa => $bb)
	{
		$selected['tol_'.$bb] = 'checked="checked"';
	}
	$templater = vB_Template::create('tmnt_editcat');
		$templater->register('tmntp', $tmntp);
		$templater->register('tol', $tol);
		$templater->register('cat', $cat);
		$templater->register('cats', $cats);
		$templater->register('catid', $catid);
		$templater->register('selected', $selected);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'competitions.php?do=categories' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['tmnt_categories'],
		'' => construct_phrase($vbphrase[tmnt_editcategory])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_POST['do'] == 'inserthelp')
{
	if (!$tmntp['canadminhelp'])
	{
		print_no_permission();
	}
	$vbulletin->input->clean_array_gpc('p', array(
		'title' => TYPE_NOHTML,
		'message' => TYPE_STR,
		'wysiwyg' => TYPE_BOOL,
		'category' => TYPE_NOHTML,
	));
	if (!$vbulletin->GPC['title'] OR trim(strlen($vbulletin->GPC['title'])) < 3)
	{
		$errormessage = $vbphrase[error_invalid_title];
		eval(standard_error($errormessage));
	}
	if ($vbulletin->GPC['wysiwyg'] && $vbulletin->options['simpleversion'] < 414)
	{
		require_once(DIR . '/includes/functions_wysiwyg.php');
		$helptext = convert_wysiwyg_html_to_bbcode($vbulletin->GPC['message'], 1);
	}
	else if ($vbulletin->GPC['wysiwyg'])
	{
		require_once(DIR . '/includes/class_wysiwygparser.php');
		$html_parser = new vB_WysiwygHtmlParser($vbulletin);
		$helptext = $html_parser->parse_wysiwyg_html_to_bbcode($vbulletin->GPC['message']);
	}
	else
	{
		$helptext = $vbulletin->GPC['message'];
	}
	if (trim(strlen($helptext)) < 3)
	{
		$errormessage = 'Requires some text...';
		eval(standard_error($errormessage));
	}
	$ref = tll_random_str(40);
	$vbulletin->db->query_write("
		INSERT INTO " . TABLE_PREFIX . "tmnt_help
			(title, helptext, category, dateline, userid, ref)
		VALUES (
			'".$vbulletin->db->escape_string($vbulletin->GPC['title'])."',
			'".$vbulletin->db->escape_string($helptext)."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['category'])."',
			'".TIMENOW."',
			'".$vbulletin->userinfo['userid']."',
			'".$vbulletin->db->escape_string($ref)."'
		)
	");
	$helpid = $vbulletin->db->insert_id();
	$vbulletin->url = "competitions.php?do=help";	
	eval(print_standard_redirect('redirect_inserthelp'));
}

// #############################################################################

if ($_POST['do'] == 'updatehelp')
{
	if (!$tmntp['canadminhelp'])
	{
		print_no_permission();
	}
	$vbulletin->input->clean_array_gpc('p', array(
		'title' => TYPE_NOHTML,
		'id' => TYPE_NOHTML,
		'message' => TYPE_STR,
		'wysiwyg' => TYPE_BOOL,
		'category' => TYPE_NOHTML,
	));
	$id = $vbulletin->GPC['id'];
	if (!$vbulletin->GPC['title'] OR trim(strlen($vbulletin->GPC['title'])) < 3)
	{
		$errormessage = $vbphrase[error_invalid_title];
		eval(standard_error($errormessage));
	}
	if ($vbulletin->GPC['wysiwyg'] && $vbulletin->options['simpleversion'] < 414)
	{
		require_once(DIR . '/includes/functions_wysiwyg.php');
		$helptext = convert_wysiwyg_html_to_bbcode($vbulletin->GPC['message'], 1);
	}
	else if ($vbulletin->GPC['wysiwyg'])
	{
		require_once(DIR . '/includes/class_wysiwygparser.php');
		$html_parser = new vB_WysiwygHtmlParser($vbulletin);
		$helptext = $html_parser->parse_wysiwyg_html_to_bbcode($vbulletin->GPC['message']);
	}
	else
	{
		$helptext = $vbulletin->GPC['message'];
	}
	if (trim(strlen($helptext)) < 3)
	{
		$errormessage = 'Requires some text...';
		eval(standard_error($errormessage));
	}
	$ref = tll_random_str(40);
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "tmnt_help
		SET title = '".$vbulletin->db->escape_string($vbulletin->GPC['title'])."',
			helptext = '".$vbulletin->db->escape_string($helptext)."',
			category = '".$vbulletin->db->escape_string($vbulletin->GPC['category'])."',
			dateline_edited = '".TIMENOW."'
		WHERE id = '$id'
	");
	$vbulletin->url = "competitions.php?do=help&id=".$id;	
	eval(print_standard_redirect('redirect_updatehelp'));
}

// #############################################################################

if ($_POST['do'] == 'insertcategory')
{
	if (!$tmntp['canedittmnt'])
	{
		print_no_permission();
	}
	$title = $vbulletin->input->clean_gpc('p', 'title', TYPE_NOHTML);
	if (!$title)
	{
		$errormessage = $vbphrase['error_invalid_title'];
		eval(standard_error($errormessage));
	}
	$description = $vbulletin->input->clean_gpc('p', 'description', TYPE_NOHTML);
	$banner = $vbulletin->input->clean_gpc('p', 'banner', TYPE_NOHTML);
	$displayorder = $vbulletin->input->clean_gpc('p', 'displayorder', TYPE_UINT);
	$tol = implode(',',$vbulletin->input->clean_gpc('p', 'tol', TYPE_ARRAY_NOHTML));
	$parentid = $vbulletin->input->clean_gpc('p', 'parentid', TYPE_UINT);
	$icon = $vbulletin->input->clean_gpc('p', 'icon', TYPE_NOHTML);
	$vbulletin->db->query_write("
		INSERT INTO " . TABLE_PREFIX . "tmnt_categories
			(title, description, displayorder, tol, parentid, icon, banner)
		VALUES (
			'".$vbulletin->db->escape_string($title)."',
			'".$vbulletin->db->escape_string($description)."',
			'".$vbulletin->db->escape_string($displayorder)."',
			'".$vbulletin->db->escape_string($tol)."',
			'".$vbulletin->db->escape_string($parentid)."',
			'".$vbulletin->db->escape_string($icon)."',
			'".$vbulletin->db->escape_string($banner)."'
		)
	");
	$catid = $vbulletin->db->insert_id();
	build_tll_catcache();
	$vbulletin->url = "competitions.php?do=categories";	
	eval(print_standard_redirect('redirect_insertcat'));
}

// #############################################################################

if (in_array($_REQUEST['do'], array('newhelp', 'addhelp')))
{
	if (!$tmntp['canadminhelp'])
	{
		print_no_permission();
	}
	require_once(DIR . '/includes/functions_editor.php');
	if  ($vbulletin->options['simpleversion'] < 414)
	{
		$editorid = construct_edit_toolbar('', 0, 'nonforum', iif($vbulletin->options['privallowsmilies'], 1, 0));
	}
	else
	{
		$editorid = construct_edit_toolbar('');
	}
	$cat_opts = '';
	$templater = vB_Template::create('tmnt_newhelp');
		$templater->register('tmntp', $tmntp);
		$templater->register('editorid', $editorid);
		$templater->register('messagearea', $messagearea);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'competitions.php?do=help' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase[tmnt_help],
		'' => construct_phrase($vbphrase['tmnt_newhelp'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'edithelp')
{
	if (!$tmntp['canadminhelp'])
	{
		print_no_permission();
	}
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	$thishelp = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_help WHERE id='$id'");
	if (!$id)
	{
		$errormessage = $vbphrase[error_invalid_help];
        eval(standard_error($errormessage));
	}
	require_once(DIR . '/includes/functions_editor.php');
	if  ($vbulletin->options['simpleversion'] < 414)
	{
		$editorid = construct_edit_toolbar($thishelp['helptext'], 0, 'nonforum', iif($vbulletin->options['privallowsmilies'], 1, 0));
	}
	else
	{
		$editorid = construct_edit_toolbar($thishelp['helptext']);
	}
	$cat_opts = '';
	$templater = vB_Template::create('tmnt_newhelp');
		$templater->register('tmntp', $tmntp);
		$templater->register('editorid', $editorid);
		$templater->register('messagearea', $messagearea);
		$templater->register('thishelp', $thishelp);
		$templater->register('edit', 1);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'competitions.php?do=help' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase[tmnt_help],
		'' => $thishelp['title']
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'addcategory')
{
	if (!$tmntp['canedittmnt'])
	{
		print_no_permission();
	}
	$cats = array();
	$categories = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "tmnt_categories WHERE parentid = 0");
	$countrows = 0;
	while($category = $vbulletin->db->fetch_array($categories))
	{
		$cats[] = $category;
		$countrows++;
	}
	$displayorder = $countrows * 10 + 10;
	$templater = vB_Template::create('tmnt_newcategory');
	$templater->register('tmntp', $tmntp);
	$templater->register('cats', $cats);
	$templater->register('displayorder', $displayorder);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'competitions.php?do=categories' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase[tmnt_categories],
		'' => construct_phrase($vbphrase['tmnt_newcategory'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'categories') 
{
	$rowcount = 0;
	$marray = array();
	$narray = array();
	if ($vbulletin->tll_catcache)
	{
		foreach ($vbulletin->tll_catcache AS $cindex => $cat)
		{
			$cat['toltext'] = '';
			if (in_array('tmnts', $cat['tol']))
			{
				$cat['toltext'] .= $vbphrase['tmnts'];
			}
			if (in_array('ladders', $cat['tol']))
			{
				$cat['toltext'] .= ($cat['toltext'] ? ", " : "") . $vbphrase['ladders'];
			}
			if (in_array('leagues', $cat['tol']) && !$vbulletin->options['tmnt_disable_leagues'])
			{
				$cat['toltext'] .= ($cat['toltext'] ? ", " : "") . $vbphrase['ladder_leagues'];
			}
			if (in_array('kings', $cat['tol']) && $vbulletin->options['tmnt_kings_enabled'])
			{
				$cat['toltext'] .= ($cat['toltext'] ? ", " : "") . $vbphrase['tmnt_kings'];
			}
			$templater = vB_Template::create('tmnt_listcat');
				$templater->register('cat', $cat);
			if ($cat['parentid'])
			{
				$marray["$cat[parentid]"] .= $templater->render();
			}
			else
			{
				$cats .= $templater->render();
				$cats .= $marray["$cat[catid]"];
			}
			$rowcount++;
		}
	}
	if ($rowcount == 0)
	{
		$templater = vB_Template::create('tmnt_nocategories');
		$nocats .= $templater->render();
	}
	$templater = vB_Template::create('tmnt_listcat_con');
		$templater->register('nocats', $nocats);
		$templater->register('rowcount', $rowcount);
		$templater->register('cats', $cats);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'' => construct_phrase($vbphrase['tmnt_categories'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'latest')
{
	$noanns = $vbulletin->options['tmnt_fp_anns'];
	$anns = $vbulletin->db->query_read("
		SELECT ann.userid, ann.id, ann.time, ann.title, user.username
		FROM " . TABLE_PREFIX . "tmnt_announcements AS ann
		LEFT JOIN " . TABLE_PREFIX . "user AS user
			ON ann.userid = user.userid
		ORDER BY ann.id DESC
		LIMIT 0, $noanns
	");
	$user_lastvisit = $vbulletin->userinfo['lastvisit'];
	$rowcount = 0;
	while($ann = $vbulletin->db->fetch_array($anns))
	{
		//$ann[userinfo]  = fetch_userinfo($ann['userid']);
		//$ann[username]  = $ann[userinfo][username];
		$new = false;
		if ($ann['time'] >= $user_lastvisit)
		{
			$new = true;
		}
		$ann['date'] = vbdate($vbulletin->options['dateformat'],$ann['time'], 1);
		$ann['time'] = vbdate($vbulletin->options['timeformat'],$ann['time']);
		$templater = vB_Template::create('tmnt_listann');
			$templater->register('ann', $ann);
		$announcements .= $templater->render();
		$rowcount ++;
	}
	if ($rowcount == 0)
	{
		$templater = vB_Template::create('tmnt_noannouncements');
		$announcements .= $templater->render();
	}
	if ($tmntp['canviewtmnt'])
	{
		$notmnts = $vbulletin->options['tmnt_fp_tmnts'];
		$rowcount = 0;
		$tmnts = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "tmnt_tmnts ORDER BY id DESC LIMIT 0, $notmnts");
		while($tmnt = $vbulletin->db->fetch_array($tmnts))
		{
			$tmnt['players'] = $tmnt['noplayers'] - $tmnt['freeslots'];
	        $description = preg_replace('/\[(.*?)\]/is', '', $tmnt['description']);
			$descriptionlength = strlen($description);
			if ($descriptionlength > $vbulletin->options['tmnt_desclength'])
			{
				$description = substr($description, 0, $vbulletin->options['tmnt_desclength']);
				$description = $description . '...';
			}
			if ($tmnt['status'] == '1')
			{
				$tmnt['status'] = $vbphrase['tmnt_waiting'];
			} elseif ($tmnt['status'] == '2')
			{
				$tmnt['status'] = $vbphrase['tmnt_inprogress'];
			} elseif ($tmnt['status'] == '3')
			{
				$tmnt['status'] = $vbphrase['tmnt_finished'];
			}
			if ($tmnt['pot'] == '0')
			{
				$tmnt['pot'] = "";
			} elseif ($tmnt['pot'] == '1')
			{
				$tmnt['pot'] = $vbphrase['tmnt_team'];
			}
			if ($tmnt['type'] == 'LMS')
			{
				$tmnt['type'] = $vbphrase['tmnt_lms'];
			}
			elseif ($tmnt['type'] == '1v1')
			{
				$tmnt['type'] = $vbphrase['tmnt_1v1'];
			}
			elseif ($tmnt['type'] == 'de')
			{
				$tmnt['type'] = $vbphrase['tmnt_de'];
			}
			if ($tmnt['status'] == '1')
			{
				$tmnt['status'] = $vbphrase['tmnt_waiting'];
			} 
			elseif ($tmnt['status'] == '2')
			{
				$tmnt['status'] = $vbphrase['tmnt_inprogress'];
			} 
			elseif ($tmnt['status'] == '3')
			{
				$tmnt['status'] = $vbphrase['tmnt_finished'];
			}
			$rowcount++;
			$tmnt['url'] = tll_seo('tmnt', $tmnt['id'], $tmnt['title']);
			$templater = vB_Template::create('tmnt_index_tbit');
				$templater->register('tmnt', $tmnt);
			$latesttmnts .= $templater->render();
		}
		if ($rowcount == 0)
		{
			$templater = vB_Template::create('tmnt_notmnts');
			$latesttmnts .= $templater->render();
		}
	}
	if ($tmntp['canviewladder'])
	{
		$noladders = $vbulletin->options['tmnt_fp_ladders'];
		$rowcount = 0;
		$ladders = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders ORDER BY id DESC LIMIT 0, $noladders");
		while($ladder = $vbulletin->db->fetch_array($ladders))
		{
	        $description = preg_replace('/\[(.*?)\]/is', '', $ladder['description']);
			$descriptionlength = strlen($description);
			if ($descriptionlength > $vbulletin->options['tmnt_desclength'])
			{
				$description = substr($description, 0, $vbulletin->options['tmnt_desclength']);
				$description = $description . '...';
			}
			$ladder['url'] = tll_seo('ladder', $ladder['id'], $ladder['title'],1);
			$templater = vB_Template::create('tmnt_index_lbit');
				$templater->register('description', $description);
				$templater->register('ladder', $ladder);
			$latestladders .= $templater->render();
			$rowcount ++;
		}
		if ($rowcount == 0)
		{
			$templater = vB_Template::create('tmnt_ladder_noladders');
			$latestladders .= $templater->render();
		}
	}
	$templater = vB_Template::create('tmnt_index');
		$templater->register('latesttmnts', $latesttmnts);
		$templater->register('announcements', $announcements);
		$templater->register('latestladders', $latestladders);
		$templater->register('tmntp', $tmntp);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'' => $modname,
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('headinclude', $headinclude);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('tlhtml', $tlhtml);
		$templater->register('modname', $modname);
		$templater->register('header', $header);
		$templater->register('footer', $footer);
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_POST['do'] == 'updatebanners')
{
	if (!$tmntp['canedittmnt'])
	{
		print_no_permission();
	}
	$vbulletin->input->clean_array_gpc('p', array(
		'title' => TYPE_ARRAY_NOHTML,
		'desc' => TYPE_ARRAY_NOHTML,
		'image' => TYPE_ARRAY_NOHTML,
		'url' => TYPE_ARRAY_NOHTML,
		'delete' => TYPE_ARRAY_BOOL,
		'id' => TYPE_ARRAY_UINT,
	));
	$tmnt_car_array = array();
	$query_banners = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "tmnt_banners");
	while ($banner = $vbulletin->db->fetch_array($query_banners))
	{
		$bannerid = $banner['id'];
		$tmnt_car_array["$bannerid"] = $banner;
	}
	//print_r($vbulletin->GPC);
	foreach ($vbulletin->GPC['id'] AS $xh => $id)
	{
		$check = $tmnt_car_array["$id"];
		if (!$check)
		{
			continue;
		}
		if ($vbulletin->GPC['delete']["$id"] == 1)
		{//delete
			$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "tmnt_banners WHERE id=$id");
		}
		elseif (
			$check['title'] != $vbulletin->GPC['title']["$xh"] OR
			$check['desc'] != $vbulletin->GPC['desc']["$xh"] OR
			$check['imageurl'] != $vbulletin->GPC['image']["$xh"] OR
			$check['linkurl'] != $vbulletin->GPC['url']["$xh"] 
		)
		{//update changes
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_banners
				SET
					title = '".$vbulletin->db->escape_string($vbulletin->GPC['title']["$xh"])."',
					" . TABLE_PREFIX . "tmnt_banners.desc = '".$vbulletin->db->escape_string($vbulletin->GPC['desc']["$xh"])."', 
					imageurl = '".$vbulletin->db->escape_string($vbulletin->GPC['image']["$xh"])."', 
					linkurl = '".$vbulletin->db->escape_string($vbulletin->GPC['url']["$xh"])."'
				WHERE id='$id' 
			");
		}
	}
	$vbulletin->url = "competitions.php?do=editbanners";	
	eval(print_standard_redirect('redirect_tmntbanner'));
}

// #############################################################################

if ($_POST['do'] == 'insertbanner')
{
	if (!$tmntp['canedittmnt'])
	{
		print_no_permission();
	}
	$vbulletin->input->clean_array_gpc('p', array(
		'title'      => TYPE_NOHTML,
		'desc'      => TYPE_NOHTML,
		'image'      => TYPE_NOHTML,
		'url'      => TYPE_NOHTML,
	));
	if (!$vbulletin->GPC['image'])
	{
		$errormessage = $vbphrase['error_no_image_url'];
        eval(standard_error($errormessage));
	}
	$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "tmnt_banners
		(title, " . TABLE_PREFIX . "tmnt_banners.desc, linkurl, imageurl, userid, dateline )
		VALUES ('".$vbulletin->db->escape_string($vbulletin->GPC['title'])."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['desc'])."', 
			'".$vbulletin->db->escape_string($vbulletin->GPC['url'])."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['image'])."',
			'".$vbulletin->userinfo['userid']."', 
			".TIMENOW."
		)
	");
	$vbulletin->url = "competitions.php?do=editbanners";	
	eval(print_standard_redirect('redirect_tmntbanner'));
}

// #############################################################################

if ($_REQUEST['do'] == 'editbanners')
{
	if (!$tmntp['canedittmnt'])
	{
		print_no_permission();
	}
	$tmnt_car_array = array();
	$query_banners = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "tmnt_banners");
	while ($banner = $vbulletin->db->fetch_array($query_banners))
	{
		$tmnt_car_array[] = $banner;
	}
	$templater = vB_Template::create('tmnt_editbanners');
		$templater->register('tmntp', $tmntp);
		$templater->register('array', $tmnt_car_array);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' => $modname,
		'' => $vbphrase['tmnt_banners'],
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('headinclude', $headinclude);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('tlhtml', $tlhtml);
		$templater->register('modname', $modname);
		$templater->register('header', $header);
		$templater->register('footer', $footer);
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'calendar' && $vbulletin->options['tmnt_premium'])
{
	$vbulletin->input->clean_array_gpc('g', array(
		'day' => TYPE_UINT,
		'month' => TYPE_UINT,
		'year' => TYPE_UINT,
	));
	
	//$week = date('W');
	if (in_array($vbulletin->GPC['year'], array(2012,2013,2014,2015,2016)))
	{
		$year = $vbulletin->GPC['year'];
	}
	else
	{
		$year = date('Y');
	}
	if (in_array($vbulletin->GPC['month'], array(1,2,3,4,5,6,7,8,9,10,11,12)))
	{
		$monthn = $vbulletin->GPC['month'];
		$month = date('F', strtotime("$monthn/15/$year"));
	}
	else
	{
		$month = date('F');
		$monthn = date('n'); // 1 to 12
	}
	if ($vbulletin->GPC['day'] >= 1 && $vbulletin->GPC['day'] <= 31)
	{
		$date = $vbulletin->GPC['day'];
	}
	else
	{
		$date = date('j'); // 1 to 31
		$day = date('l'); // Mon to Sun
	}
	//print_r("#$day $week $month $year#");
	//print_r(date('#j l W F Y#', strtotime("1 $month $year")));
	$space = date('N',strtotime("1 $month $year"));
	$tlhtml .= '<table class="blockbody formcontrols" style="display: table; margin: 0 auto; text-align: center;'.($_REQUEST['embed'] ? 'width:100%;' : '').'">';
	
	$tlhtml .= '<tr style="display: table-row;"><td colspan="7" class="blocksubhead" style="display: table-cell; text-align: center;">'.$month.' '.$year.'</td></tr>';
	$tlhtml .= '<tr style="display: table-row;"><td class="blocksubhead" style="display: table-cell;">M</td><td class="blocksubhead" style="display: table-cell;">T</td><td class="blocksubhead" style="display: table-cell;">W</td><td class="blocksubhead" style="display: table-cell;">T</td><td class="blocksubhead" style="display: table-cell;">F</td><td class="blocksubhead" style="display: table-cell;">S</td><td class="blocksubhead" style="display: table-cell;">S</td></tr>';
	$tlhtml .= '<tr>';
	$a = 1;
	for ($i = 1; $i < $space; $i++)
	{
		$tlhtml .= '<td class="blockrow" style="display: table-cell;">&nbsp;</td>';
		$a++;
	}
	$curr_day_css = 'font-weight: bold; background: #FFF286;';
	for ($i = 1; $i <= cal_days_in_month(CAL_GREGORIAN,$monthn,$year); $i++)
	{
		if ($a==1 && $i != 1)
		{
			$tlhtml .= '<tr style="display: table-row;">';
		}
		$tlhtml .= '<td class="blockrow" style="display: table-cell; '.((date('j') == $i && $year == date('Y') && $monthn == date('n')) ? $curr_day_css : "").'"><a href="competitions.php?do=events&amp;day='.$i.'&amp;month='.$monthn.'&amp;year='.$year.'" target="_parent" onclick="openWindow(this.href+\'&embed=1&from_win=\'+window.document.name, 300, 300); return false;">'.$i.'</a></td>';
		if ($a==7)
		{
			$tlhtml .= '</tr>';
			$a = 1;
		}
		else
		{
			$a++;
		}
	}
	if ($a != 1)
	{
		for ($i = $a; $i <= 7; $i++)
		{
			$tlhtml .= '<td class="blockrow" style="display: table-cell;">&nbsp;</td>';
			$a++;
		}
	}
	$prev_monthn = $monthn - 1;
	$next_monthn = $monthn + 1;
	$prev_year = $next_year = $year;
	if ($prev_monthn == 0)
	{
		$prev_monthn = 12;
		$prev_year--;
	}
	elseif ($next_monthn == 13)
	{
		$next_monthn = 1;
		$next_year++;
	}
	$next_month = date('F', strtotime("$next_monthn/15/$next_year"));
	$prev_month = date('F', strtotime("$prev_monthn/15/$prev_year"));
	$tlhtml .= '<tr style="display: table-row;"><td colspan="7" class="blocksubhead" style="display: table-cell; text-align: center;"><a href="competitions.php?do=calendar'.($_REQUEST['embed'] ? '&amp;embed=1' : '').'&amp;month='.$next_monthn.'&amp;year='.$next_year.'" style="float: right;">'.$next_month.' &gt;</a><a href="competitions.php?do=calendar'.($_REQUEST['embed'] ? '&amp;embed=1' : '').'&amp;month='.$prev_monthn.'&amp;year='.$prev_year.'" style="float: left;">&lt; ' . $prev_month . '</a></td></tr>';
	$tlhtml .= '</table>';
	$navbits = array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname
	);
	$navbar = render_navbar_template(construct_navbits($navbits));
	if ($_REQUEST['embed'])
	{
		$navbar = $footer = $header = '';
		$vbulletin->options['tmnt_navtop'] = $vboptions['tmnt_navtop'] = $vboptions['tmnt_navleft'] = $show['scrolling_announcements'] = $vboptions['tmnt_active'] = 0;
		$vbulletin->options['tmnt_disablecopyright'] = 1;
		$vboptions['tmnt_navleftbanner']='';
		$tmntp = 0;
		$vbulletin->options['tmnt_navleft'] = 0; 
		$vboptions['tmnt_navleft'] = 0;
		$vbulletin->templatecache['tmnt_shell'] = str_replace(array('<body', '</body>'),array('<body style="margin:0; '.(number_format($vbulletin->options['tmnt_fp_sb_width'])<=225?'font-size:60%;':'').' min-width:0px; background: #FFF; height: 275px;"','</BODY>'),$vbulletin->templatecache['tmnt_shell']);
	}
	$templater = vB_Template::create('tmnt_shell');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('headinclude', $headinclude);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('tlhtml', $tlhtml);
		$templater->register('modname', $modname);
		$templater->register('header', $header);
		$templater->register('footer', $footer);
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'events' && $vbulletin->options['tmnt_premium'])
{
	$vbulletin->input->clean_array_gpc('g', array(
		'day' => TYPE_UINT,
		'month' => TYPE_UINT,
		'year' => TYPE_UINT,
		'from_win' => TYPE_NOHTML,
	));
	$win = $vbulletin->GPC['from_win'];
	if ($win == 'undefined')
	{
		$win = '';
	}
	//$week = date('W');
	if (in_array($vbulletin->GPC['year'], array(2012,2013,2014,2015,2016)))
	{
		$year = $vbulletin->GPC['year'];
	}
	else
	{
		$year = date('Y');
	}
	if (in_array($vbulletin->GPC['month'], array(1,2,3,4,5,6,7,8,9,10,11,12)))
	{
		$monthn = $vbulletin->GPC['month'];
		$month = date('F', strtotime("$monthn/15/$year"));
	}
	else
	{
		$month = date('F');
		$monthn = date('n'); // 1 to 12
	}
	if ($vbulletin->GPC['day'] >= 1 && $vbulletin->GPC['day'] <= 31)
	{
		$date = $vbulletin->GPC['day'];
	}
	else
	{
		$date = date('j'); // 1 to 31
		$day = date('l'); // Mon to Sun
	}
	
	//print_r(vbdate('d M Y H:s',TIMENOW));
	//print_r($vbulletin->userinfo);
	$todaystart = gmmktime(0, 0, 0, $monthn, $date, $year);
	if ($vbulletin->userinfo['dstonoff'])
	{
		$todaystart -= 60 * 60;
	}
	if ($vbulletin->userinfo['timezoneoffset'] != 0)
	{
		$todaystart -= $vbulletin->userinfo['timezoneoffset'] * 60 * 60;
	}
	$todayend = $todaystart + 86400;
	//print_r(vbdate('d M Y H:s',$todaystart));
	$tlhtml .= '<h2 class="blockhead">'."$date  $month $year".'</h2>';
	$tlhtml .= '<div class="blockbody formcontrols">';
	$tlhtml .= '<div class="blocksubhead">Ladder/League Matches</div>';
	$matches = $vbulletin->db->query_read("
		SELECT games.*, IF(games.pot = 1, teama.teamname, usera.username) AS username_u, IF(games.pot = 1, teamb.teamname, userb.username) AS username_u2, l.title AS laddertitle
		FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
		LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS l
			ON (l.id = games.lid)
		LEFT JOIN " . TABLE_PREFIX . "user AS usera
			ON (games.u = usera.userid AND games.pot = 0)
		LEFT JOIN " . TABLE_PREFIX . "user AS userb
			ON (games.u2 = userb.userid AND games.pot = 0)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS teama
			ON (games.u = teama.teamid AND games.pot != 0)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS teamb
			ON (games.u2 = teamb.teamid AND games.pot != 0)
		WHERE games.dateline >= $todaystart
			AND games.dateline <= $todayend
			AND games.accepted = 1
		ORDER BY games.dateline ASC
		LIMIT 0, 15
	");
	while($m = $vbulletin->db->fetch_array($matches))
	{
		//print_r($m['id']);
		$m['lurl'] = tll_seo('ladder', $m['lid'], $m['laddertitle'], 1);
		$tlhtml .= '<div class="blockrow">'.vbdate($vbulletin->options['timeformat'],$m['dateline'])." <a href=\"ladder_match.php?do=viewmatch&amp;mid=$m[id]\" target=\"".($win ? $win : '_blank')."\">$m[username_u] " . (!$m['finished'] ? $vbphrase[tmnt_vs] : "$m[score_u] - $m[score_u2]") . " $m[username_u2]</a> (<a href=\"$m[lurl]\" target=\"_blank\">".$m['laddertitle']."</a>)</div>";
		$m_count++;
	}
	if (!$m_count)
	{
		$tlhtml .= '<div class="blockrow">No matches on this day.</div>';
	}
	$tlhtml .= '<div class="blocksubhead">Tournaments</div>';
	$ts = $vbulletin->db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_tmnts AS t
		WHERE t.date >= $todaystart
			AND t.date <= $todayend
	");
	while($t = $vbulletin->db->fetch_array($ts))
	{
		$t['url'] = tll_seo('tmnt', $t['id'], $t['title'], 1);
		$tlhtml .= '<div class="blockrow">'.vbdate($vbulletin->options['timeformat'],$t['date']). ' <a href="'.$t['url'].'" target="_blank">' .$t['title'].'</a></div>';
		$t_count++;
	}
	if (!$t_count)
	{
		$tlhtml .= '<div class="blockrow">No tournaments on this day.</div>';
	}
	$tlhtml .= '<div class="blocksubhead">Open Ladders/Leagues</div>';
	$ls = $vbulletin->db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_ladders AS l
		WHERE l.dateline_from <= $todayend
			AND l.dateline_to >= $todaystart
	");
	while($l = $vbulletin->db->fetch_array($ls))
	{
		$l['url'] = tll_seo(($l['league']?'league':'ladder'), $l['id'], $l['title'], 1);
		$tlhtml .= '<div class="blockrow">'.vbdate($vbulletin->options['dateformat'],$l['dateline_from']). ' - '.vbdate($vbulletin->options['dateformat'],$l['dateline_to']). ' <a href="'.$l['url'].'" target="_blank">' .$l['title'].'</a></div>';
		$t_count++;
	}
	if (!$t_count)
	{
		$tlhtml .= '<div class="blockrow">No tournaments on this day.</div>';
	}
	$tlhtml .= '</div>';
	
	$navbits = array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname
	);
	$navbar = render_navbar_template(construct_navbits($navbits));
	if ($_REQUEST['embed'])
	{
		$navbar = $footer = $header = '';
		$vbulletin->options['tmnt_navtop'] = $vboptions['tmnt_navtop'] = $vboptions['tmnt_navleft'] = $show['scrolling_announcements'] = $vboptions['tmnt_active'] = 0;
		$vbulletin->options['tmnt_disablecopyright'] = 1;
		$vboptions['tmnt_navleftbanner']='';
		$tmntp = 0;
		$vbulletin->options['tmnt_navleft'] = 0; 
		$vboptions['tmnt_navleft'] = 0;
		$vbulletin->templatecache['tmnt_shell'] = str_replace(array('<body', '</body>'),array('<body style="margin: 5px; min-width:0px;"','</BODY>'),$vbulletin->templatecache['tmnt_shell']);
	}
	$templater = vB_Template::create('tmnt_shell');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('headinclude', $headinclude);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('tlhtml', $tlhtml);
		$templater->register('modname', $modname);
		$templater->register('header', $header);
		$templater->register('footer', $footer);
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'viewteam')
{
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	$vbulletin->url = "teams.php?do=viewteam&id=".$vbulletin->GPC['id'];	
	eval(print_standard_redirect('redirect_team'));
}

// #############################################################################

if ($_REQUEST['do']=='feed')
{
	$hide = explode(',',$vbulletin->input->clean_gpc('g', 'hide', TYPE_NOHTML));
	$array = array();//date => event
	$array2 = array();// => title,description,link,date
	if (!in_array('tmntjoin', $hide))
	{
		/*TOURNAMENTS JOINED*/
		$query = $vbulletin->db->query_read("
			SELECT p.*, t.title, p.time AS dateline
			FROM " . TABLE_PREFIX . "tmnt_players AS p
			LEFT JOIN " . TABLE_PREFIX . "tmnt_tmnts AS t
				ON (p.tid = t.id)
			WHERE p.userid > 0
			ORDER BY p.time DESC
			LIMIT 0,25
		");
		while($row = $vbulletin->db->fetch_array($query))
		{
			$dateline = $row['dateline'];
			$url = 	tll_seo('tmnt', $row['tid'], $row['title']);
			$phrase = "$row[username] joined tournament: <a href=\"tournaments.php$url\">$row[title]</a>";
			$array[$dateline][] = array($phrase);
			$array2[] = array(
				'title' => 'Tournament: '. $row['title'],
				'description' => $phrase,
				'link' => $vbulletin->options['bburl'].'/tournaments.php'.$url,
				'date' => $dateline
			);
		}
	}
	if (!in_array('tmntwon', $hide))
	{
		/*TOURNAMENTS WON*/
		$query = $vbulletin->db->query_read("
			SELECT p.*, t.title, t.date AS dateline, t.comments
			FROM " . TABLE_PREFIX . "tmnt_players AS p
			LEFT JOIN " . TABLE_PREFIX . "tmnt_tmnts AS t
				ON (p.tid = t.id)
			WHERE p.winner = 1
				AND t.status = 3
			ORDER BY t.date DESC
			LIMIT 0,25
		");
		while($row = $vbulletin->db->fetch_array($query))
		{
			$dateline = $row['dateline'];
			$url = 	tll_seo('tmnt', $row['tid'], $row['title']);
			$phrase = "$row[username] won tournament: <a href=\"tournaments.php$url\">$row[title]</a>";
			$array[$dateline][] = array($phrase, $row['comments']);
			$array2[] = array(
				'title' => 'Tournament: '. $row['title'],
				'description' => $phrase,
				'link' => $vbulletin->options['bburl'].'/tournaments.php'.$url,
				'date' => $dateline,
				'comments' => $row['comments']
			);
		}
	}
	if (!in_array('ldrjoin', $hide))
	{
		/*LADDERS/LEAGUES JOINED*/
		$query = $vbulletin->db->query_read("
			SELECT p.*, l.title, l.league, p.time AS dateline
			FROM " . TABLE_PREFIX . "tmnt_ladder_players AS p
			LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS l
				ON (p.lid = l.id)
			ORDER BY p.time DESC
			LIMIT 0,25
		");
		while($row = $vbulletin->db->fetch_array($query))
		{
			$dateline = $row['dateline'];
			$url = 	tll_seo('ladder', $row['lid'], $row['title']);
			if ($row['league'] > 0)
			{
				$phrase = "$row[username] joined league: <a href=\"ladders.php$url\">$row[title]</a>";
			}
			else
			{
				$phrase = "$row[username] joined ladder: <a href=\"ladders.php$url\">$row[title]</a>";
			}
			$array[$dateline][] = array($phrase);
			$array2[] = array(
				'title' => 'Ladder: '.$row['title'],
				'description' => $phrase,
				'link' => $vbulletin->options['bburl'].'/ladders.php'.$url,
				'date' => $dateline
			);
		}
	}
	if (!in_array('ldrug', $hide))
	{
		/*LATEST UPCOMING LADDER GAMES*/
		$query = $vbulletin->db->query_read("
			SELECT g.*, l.title, l.league, g.time AS dateline, IF(g.pot = 1, teama.teamname, usera.username) AS username_u, IF(g.pot = 1, teamb.teamname, userb.username) AS username_u2
			FROM " . TABLE_PREFIX . "tmnt_ladder_games AS g
			LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS l
				ON (g.lid = l.id)
			LEFT JOIN " . TABLE_PREFIX . "user AS usera
				ON (g.u = usera.userid)
			LEFT JOIN " . TABLE_PREFIX . "user AS userb
				ON (g.u2 = userb.userid)
			LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS teama
				ON (g.u = teama.teamid)
			LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS teamb
				ON (g.u2 = teamb.teamid)
			WHERE accepted = 1 AND finished = 0
			ORDER BY g.time DESC
			LIMIT 0,25
		");
		while($row = $vbulletin->db->fetch_array($query))
		{
			$dateline = $row['dateline'];
			$url = 	tll_seo('ladder', $row['lid'], $row['title']);
			$phrase = "<a href=\"ladders.php$url\">$row[title]</a>: $row[username_u] ".$vbphrase['ladder_vs']." $row[username_u2]";
			$array[$dateline][] = array($phrase, $row['comments']);
			$array2[] = array(
				'title' => 'Ladder: '.$row['title'],
				'description' => $phrase,
				'link' => $vbulletin->options['bburl'].'/ladders.php'.$url,
				'date' => $dateline,
				'comments' => $row['comments']
			);
		}
	}
	if (!in_array('ldrrm', $hide))
	{
		/*LATEST LADDER GAME RESULTS*/ 
		$query = $vbulletin->db->query_read("
			SELECT g.*, l.title, l.league, g.dateline_finished AS dateline, IF(g.pot = 1, teama.teamname, usera.username) AS username_u, IF(g.pot = 1, teamb.teamname, userb.username) AS username_u2
			FROM " . TABLE_PREFIX . "tmnt_ladder_games AS g
			LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS l
				ON (g.lid = l.id)
			LEFT JOIN " . TABLE_PREFIX . "user AS usera
				ON (g.u = usera.userid)
			LEFT JOIN " . TABLE_PREFIX . "user AS userb
				ON (g.u2 = userb.userid)
			LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS teama
				ON (g.u = teama.teamid)
			LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS teamb
				ON (g.u2 = teamb.teamid)
			WHERE accepted = 1 AND finished = 1
			ORDER BY g.dateline_finished DESC
			LIMIT 0,25
		");
		while($row = $vbulletin->db->fetch_array($query))
		{
			$dateline = $row['dateline'];
			$url = 	tll_seo('ladder', $row['lid'], $row['title']);
			$phrase = "<a href=\"ladders.php$url\">$row[title]</a>: $row[username_u] <b>$row[score_u] - $row[score_u2]</b> $row[username_u2]";
			$array[$dateline][] = array($phrase);
			$array2[] = array(
				'title' => 'Ladder: '.$row['title'],
				'description' => $phrase,
				'link' => $vbulletin->options['bburl'].'/ladders.php'.$url,
				'date' => $dateline
			);
		}
	}
	if (!in_array('tmntres', $hide))
	{
		/*LATEST TOURNAMENT RESULTS*/
		$query = $vbulletin->db->query_read("
			SELECT g.*, g.dateline, IF(t.pot = 1, teama.teamname, usera.username) AS username_u, IF(t.pot = 1, teamb.teamname, userb.username) AS username_u2, t.title
			FROM " . TABLE_PREFIX . "tmnt_result AS g
			LEFT JOIN " . TABLE_PREFIX . "tmnt_tmnts AS t
				ON (g.tid = t.id)
			LEFT JOIN " . TABLE_PREFIX . "user AS usera
				ON (g.userid = usera.userid)
			LEFT JOIN " . TABLE_PREFIX . "user AS userb
				ON (g.opp_userid = userb.userid)
			LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS teama
				ON (g.userid = teama.teamid)
			LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS teamb
				ON (g.opp_userid = teamb.teamid)
			WHERE confirm_u = 1 AND confirm_u2 = 1
			ORDER BY g.dateline DESC
			LIMIT 0,25
		");
		while($row = $vbulletin->db->fetch_array($query))
		{
			$dateline = $row['dateline'];
			$url = 	tll_seo('tmnt', $row['tid'], $row['title']);
			$phrase = "<a href=\"tournaments.php$url\">$row[title]</a> ".construct_phrase($vbphrase['tmnt_round_x'], $row['round']).": $row[username_u] <b>$row[score_u] - $row[score_u2]</b> $row[username_u2]";
			$array[$dateline][] = array($phrase);
			$array2[] = array(
				'title' => 'Tournament: '. $row['title'],
				'description' => $phrase,
				'link' => $vbulletin->options['bburl'].'/tournaments.php'.$url,
				'date' => $dateline
			);
		}
	}
	if (!in_array('leagwon', $hide))
	{
		/*LEAGUES WON*/
		$query = $vbulletin->db->query_read("
			SELECT p.*, p.latime AS dateline, l.title
			FROM " . TABLE_PREFIX . "tmnt_ladder_players AS p
			LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS l
				ON (p.lid = l.id)
			WHERE p.winner = 1
			ORDER BY p.latime DESC
			LIMIT 0,25
		");
		while($row = $vbulletin->db->fetch_array($query))
		{
			$dateline = $row['dateline'];
			$url = 	tll_seo('ladder', $row['lid'], $row['title']);
			$phrase = "<a href=\"ladders.php$url\">$row[title]</a>: $row[username] won league after knockout stage";
			$array[$dateline][] = array($phrase);
			$array2[] = array(
				'title' => 'League: '.$row['title'],
				'description' => $phrase,
				'link' => $vbulletin->options['bburl'].'/ladders.php'.$url,
				'date' => $dateline
			);
		}
	}
	if (!in_array('teamnew', $hide))
	{
		/*NEW TEAMS*/
		$query = $vbulletin->db->query_read("
			SELECT t.*, t.time AS dateline, teamname AS title, u.username
			FROM " . TABLE_PREFIX . "tmnt_teams AS t
			LEFT JOIN " . TABLE_PREFIX . "user AS u
				ON (t.userid = u.userid)
			ORDER BY t.time DESC
			LIMIT 0,25
		");
		while($row = $vbulletin->db->fetch_array($query))
		{
			$dateline = $row['dateline'];
			$url = 	tll_seo('team', $row['teamid'], $row['title']);
			$phrase = "$row[username] created team: <a href=\"teams.php$url\">$row[title]</a>";
			$array[$dateline][] = array($phrase);
			$array2[] = array(
				'title' => 'Team: '.$row['title'],
				'description' => $phrase,
				'link' => $vbulletin->options['bburl'].'/teams.php'.$url,
				'date' => $dateline
			);
		}
	}
	if (!in_array('teamjoin', $hide))
	{
		/*NEW TEAM PLAYERS*/
		$query = $vbulletin->db->query_read("
			SELECT m.*, m.time AS dateline, t.teamname AS title, u.username
			FROM " . TABLE_PREFIX . "tmnt_members AS m
			LEFT JOIN " . TABLE_PREFIX . "user AS u
				ON (m.userid = u.userid)
			LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS t
				ON (m.teamid = t.teamid)
			WHERE accepted = 1
			ORDER BY m.time DESC
			LIMIT 0,25
		");
		while($row = $vbulletin->db->fetch_array($query))
		{
			$dateline = $row['dateline'];
			$url = 	tll_seo('team', $row['teamid'], $row['title']);
			$phrase = "$row[username] joined team: <a href=\"teams.php$url\">$row[title]</a>";
			$array[$dateline][] = array($phrase);
			$array2[] = array(
				'title' => 'Team: '.$row['title'],
				'description' => $phrase,
				'link' => $vbulletin->options['bburl'].'/teams.php'.$url,
				'date' => $dateline
			);
		}
	}
	krsort($array);
	$array = array_slice($array, 0, 50, true);
	//print_r($array);
	if ($_REQUEST['rss'])
	{
		    header("Content-Type: application/rss+xml; charset=UTF-8");

			$rssfeed = '<?xml version="1.0" encoding="UTF-8"?>'."\r\n";
			$rssfeed .= '<rss version="2.0">'."\r\n";
			$rssfeed .= ' <channel>'."\r\n";
			$rssfeed .= '  <title>'.$vbphrase['tmnt_feed'] . ' - ' .$vbulletin->options['bbtitle'].'</title>'."\r\n";
			$rssfeed .= '  <link>'.$vbulletin->options['bburl'].'/competitions.php</link>'."\r\n";
			$rssfeed .= '  <description>'.$vbphrase['tmnt_feed'] . '</description>'."\r\n";
			$rssfeed .= '  <language>en-us</language>'."\r\n";
			$rssfeed .= '  <copyright>Copyright (C) 2012 '.$vbulletin->options['bburl'].'</copyright>'."\r\n";

			foreach($array2 AS $row)
			{
				$rssfeed .= '  <item>'."\r\n";
				$rssfeed .= '   <title>' . $row['title'] . '</title>'."\r\n";
				$rssfeed .= '   <description>' . strip_tags($row['description']) . '</description>'."\r\n";
				$rssfeed .= '   <link>' . str_replace('&','&amp;',$row['link']) . '</link>'."\r\n";
				$rssfeed .= '   <pubDate>' . date("D, d M Y H:i:s O", $row['date']) . '</pubDate>'."\r\n";
				$rssfeed .= '  </item>'."\r\n";
			}
		 
			$rssfeed .= ' </channel>'."\r\n";
			$rssfeed .= '</rss>';
		 
			print_r($rssfeed);
			exit;
	}
	$templater = vB_Template::create('tmnt_feed');
		$templater->register('tmntp', $tmntp);
		$templater->register('array', $array);
	$tlhtml = $templater->render();
	$navbits = array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'' => construct_phrase($vbphrase['tmnt_feed'])
	);
	$navbar = render_navbar_template(construct_navbits($navbits));
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_POST['do']=='update_modules')
{
	if ($vbulletin->userinfo['usergroupid']!=6)
	{
		print_no_permission();
	}
	$vbulletin->input->clean_array_gpc('p', array(
		'setting' => TYPE_ARRAY_NOHTML,
		'additional' => TYPE_ARRAY_NOHTML,
		'options' => TYPE_ARRAY_NOHTML,
		'displayorder' => TYPE_ARRAY_INT,
	));
	/*$additional['tmnt_fp_remat_loc'] = $vbulletin->GPC['setting']['tmnt_fp_remat_loc'];
	$additional['tmnt_fp_upmat_loc'] = $vbulletin->GPC['setting']['tmnt_fp_upmat_loc'];
	$additional['tmnt_fp_cats_loc'] = $vbulletin->GPC['setting']['tmnt_fp_cats_loc'];
	$additional['tmnt_fp_bigt_loc'] = $vbulletin->GPC['setting']['tmnt_fp_bigt_loc'];*/
	$settings = $vbulletin->GPC['setting'];
	/*$vbulletin->GPC['setting'] = array_diff(
		$vbulletin->GPC['setting'],
		array(
			'tmnt_fp_upmat_loc' => $vbulletin->GPC['setting']['tmnt_fp_upmat_loc'],
			'tmnt_fp_remat_loc' => $vbulletin->GPC['setting']['tmnt_fp_remat_loc'],
			'tmnt_fp_cats_loc' => $vbulletin->GPC['setting']['tmnt_fp_cats_loc'],
			'tmnt_fp_bigt_loc' => $vbulletin->GPC['setting']['tmnt_fp_bigt_loc']
		)
	);*/
	$settings['tmnt_fp_code'] = serialize(array(
		'displayorder' => $vbulletin->GPC['displayorder'],
		'options' => $vbulletin->GPC['options'],
		'additional' => $vbulletin->GPC['additional'],
	));
	require_once(DIR . '/includes/adminfunctions.php');
	require_once(DIR . '/includes/adminfunctions_options.php');
	//save_settings($settings[setting_name] = new_value)
	save_settings($settings);
	//	print_r();
	
	$vbulletin->url = "competitions.php?do=modules";
	eval(print_standard_redirect('Redirecting...'));
}

// #############################################################################

if ($_REQUEST['do']=='modules')
{
	if ($vbulletin->userinfo['usergroupid']!=6)
	{
		print_no_permission();
	}
	require_once('./includes/functions_tll_modules.php');
	/*tmnt_list ladder_list cats*/
	$mp = array();
	foreach ($m_array AS $m)
	{
		$ao = '';
		$l = 'tmnt_fp_'.$m.'_loc';
		$o = $vbulletin->options["$l"];
		switch ($o)
		{
			case 'br':
			case 'tr':
				$o = 'right';
				break;
			case '':
				$o = '0';
				break;
		}
		switch ($m)
		{
			case 'twins':
				$ph = 'Tournaments Latest Winners';
				break;
			case 'random':
				$ph = 'Random Ladder Player';
				break;
			case 'mat':
				$ph = 'Recent & Upcoming Matches';
				break;
			case 'com':
				$ph = 'Tournament & Match Comments';
				break;
			case 'warl':
				$ph = 'Live Match Finder';
				break;
			case 'html':
				$ph = 'Custom HTML Block';
				$options['htmlblock'] = unhtmlspecialchars($options['htmlblock']);
				$ao = '<br />HTML:<br /><textarea name="options[htmlblock]" tabindex="1" style="width:100%;" rows="3">'.$vbulletin->input->clean($options['htmlblock'], TYPE_NOHTML).'</textarea>';
				break;
			case 'html2':
				$ph = 'Custom HTML Block 2';
				$options['htmlblock2'] = unhtmlspecialchars($options['htmlblock2']);
				$ao = '<br />HTML:<br /><textarea name="options[htmlblock2]" tabindex="1" style="width:100%;" rows="3">'.$vbulletin->input->clean($options['htmlblock2'], TYPE_NOHTML).'</textarea>';
				break;
			case 'is':
				$ph = 'Image Slider';
				$ao = '<br />Title: <input type="text" class="textbox" name="options[is_title]" value="'.$options['is_title'].'" size="20" tabindex="1" />';
				$ao .= '<br />Options:<br /><textarea name="options[is_content]" tabindex="1" style="width:100%;" rows="3">'.$options['is_content'].'</textarea>';
				break;
				break;
			case 'credits':
				$ph = 'Credits';
				$ao .= '<br />Header Class: <select name="options[credits_head]" tabindex="1" onchange="this.form.submit();"><option>blockhead</option><option>blocksubhead</option></select>';
				$ao = str_replace('<option>'.$options['credits_head'].'</option>', '<option selected="selected">'.$options['credits_head'].'</option>', $ao);
				break;
			case 'anns':
				$ph = 'Latest Annoucements';
				$ao = '<br />Annoucements to display: <input type="number" class="textbox numeric" name="setting[tmnt_fp_anns]" id="it_setting[tmnt_fp_anns]_1" value="'.$vbulletin->options['tmnt_fp_anns'].'" size="40" tabindex="1" style="width: 50px;" />';
				$ao .= '<br />Header Class: <select name="options[anns_head]" tabindex="1" onchange="this.form.submit();"><option>blockhead</option><option>blocksubhead</option></select>';
				$ao = str_replace('<option>'.$options['anns_head'].'</option>', '<option selected="selected">'.$options['anns_head'].'</option>', $ao);
				$ao .= '<br />Alt Display: <input type="checkbox" name="options[anns_alt]" value="1" '.($options['anns_alt']?' checked="checked"':'').' tabindex="1" onchange="this.form.submit();" />';
				$ao .= '<br />Icon Size: <input type="number" class="textbox numeric" name="options[ann_icon_size]" value="'.($options['ann_icon_size']?$options['ann_icon_size']:"25").'" size="40" tabindex="1" style="width: 50px;" />px';
				break;
			case 'cal':
				$ph = 'Calendar';
				break;
			case 'bigt':
				$ph = 'Big Threads Block';
				$ao .= '<br />Large Forum Feed: <input type="number" class="textbox numeric" name="options[bigt_1]" value="'.$options['bigt_1'].'" size="40" tabindex="1" style="width: 50px;" />';
				$ao .= '<br />Small Forum Feed: <input type="number" class="textbox numeric" name="options[bigt_2]" value="'.$options['bigt_2'].'" size="40" tabindex="1" style="width: 50px;" />';
				$ao .= '<br />Small Forum Feed 2: <input type="number" class="textbox numeric" name="options[bigt_3]" value="'.$options['bigt_3'].'" size="40" tabindex="1" style="width: 50px;" />';
				break;
			case 'bigp':
				$ph = 'Big Posts Block';
				$ao .= '<br />Large Forum Feed: <input type="number" class="textbox numeric" name="options[bigp_1]" value="'.$options['bigp_1'].'" size="40" tabindex="1" style="width: 50px;" />';
				$ao .= '<br />Small Forum Feed: <input type="number" class="textbox numeric" name="options[bigp_2]" value="'.$options['bigp_2'].'" size="40" tabindex="1" style="width: 50px;" />';
				$ao .= '<br />Small Forum Feed 2: <input type="number" class="textbox numeric" name="options[bigp_3]" value="'.$options['bigp_3'].'" size="40" tabindex="1" style="width: 50px;" />';
				break;
			case 'hof':
				$ph = 'Tournament Hall of Fame';
				break;
			case 'cats':
				$ph = 'Categories';
				$ao = '<br />Simple View: <input type="checkbox" name="options[simple_cats]" value="1" '.($options['simple_cats']?' checked="checked"':'').' size="20" tabindex="1" onchange="this.form.submit();" />';
				$ao .= '<br />Header Class: <select name="options[cats_head]" tabindex="1" onchange="this.form.submit();"><option>blockhead</option><option>blocksubhead</option></select>';
				$ao = str_replace('<option>'.$options['cats_head'].'</option>', '<option selected="selected">'.$options['cats_head'].'</option>', $ao);
				break;
			case 'upmat':
				$ph = 'Upcoming Matches';
				$ao = '<br />Number to display: <input type="number" class="textbox numeric" name="options[upmat_x]" value="'.$options['upmat_x'].'" size="40" tabindex="1" style="width: 50px;" />';
				$ao .= '<br />Alternative Style: <input type="checkbox" name="options[upmat_alt]" value="1" '.($options['upmat_alt']?' checked="checked"':'').' tabindex="1" onchange="this.form.submit();" />';
				$ao .= '<br />Win CSS BG Colour: #<input type="text" class="textbox" name="options[win_bg_css]" value="'.$options['win_bg_css'].'" size="10" tabindex="1" /> e.g. #BCE954 ';
				$ao .= '<br />Loss CSS BG Colour: #<input type="text" class="textbox" name="options[loss_bg_css]" value="'.$options['loss_bg_css'].'" size="10" tabindex="1" /> e.g. #C80000 ';
				$ao .= '<br />Hide Ladder Title: <input type="checkbox" name="options[upmat_hideltitle]" value="1" '.($options['upmat_hideltitle']?' checked="checked"':'').' tabindex="1" onchange="this.form.submit();" />';
				$ao .= '<br />Hide Ladder Icon: <input type="checkbox" name="options[upmat_hidelicon]" value="1" '.($options['upmat_hidelicon']?' checked="checked"':'').' tabindex="1" onchange="this.form.submit();" />';
				break;
			case 'remat':
				$ph = 'Recent Matches';
				$ao = '<br />Number to display: <input type="number" class="textbox numeric" name="options[remat_x]" value="'.$options['remat_x'].'" size="40" tabindex="1" style="width: 50px;" />';
				$ao .= '<br />Alternative Style: <input type="checkbox" name="options[remat_alt]" value="1" '.($options['remat_alt']?' checked="checked"':'').' tabindex="1" onchange="this.form.submit();" />';
				$ao .= '<br />Hide Ladder Title: <input type="checkbox" name="options[remat_hideltitle]" value="1" '.($options['remat_hideltitle']?' checked="checked"':'').' tabindex="1" onchange="this.form.submit();" />';
				$ao .= '<br />Hide Ladder Icon: <input type="checkbox" name="options[remat_hidelicon]" value="1" '.($options['remat_hidelicon']?' checked="checked"':'').' tabindex="1" onchange="this.form.submit();" />';
				break;
				break;
			case 'threads':
				$ph = 'Latest Threads';
				$ao = '<br />Forum IDs: <input type="text" class="textbox" name="options[forumids]" value="'.$options['forumids'].'" size="20" tabindex="1" />';
				$ao .= '<br />No to display: <input type="number" class="textbox" name="options[x_threads]" value="'.$options['x_threads'].'" tabindex="1" style="width: 50px;" />';
				$ao .= '<br />Header Class: <select name="options[threads_head]" tabindex="1" onchange="this.form.submit();"><option>blockhead</option><option>blocksubhead</option></select>';
				$ao = str_replace('<option>'.$options['threads_head'].'</option>', '<option selected="selected">'.$options['threads_head'].'</option>', $ao);
				break;
			case 'tllk':
				$ph = 'Latest Tournaments, Ladders &amp; Leagues';
				break;
			case 'tllk2':
				$ph = 'Latest Tournaments, Ladders &amp; Leagues - Style 2';
				break;
			case 'tcomx':
				$ph = 'Tournament Comments';
				$ao = '<br />Tournament IDs: <input type="text" class="textbox" name="options[tmntids]" value="'.$options['tmntids'].'" size="20" tabindex="1" />';
				break;
			case 'ynextm':
				$ph = 'Your Matches';
			default:
				$ph = $m;
				break;
		}
		$mp[$o][] = array($l,$ph,$ao,number_format($do["$l"]));
	}
	foreach ($mp AS $maa => $ma)
	{
		$ma = subval_sort($ma,3); 
		foreach ($ma AS $ig => $md)
		{
			$md_sel = 'Location: <select name="additional['.$md['0'].']" id="sel_setting['.$md['0'].']_14" tabindex="1" class="bginput" onchange="this.form.submit();"><option value="0" selected="selected">Hidden</option><option value="sidebar">Sidebar</option><option value="right">Right</option><option value="left">Left</option><option value="main">Main</option><option value="bottom">Bottom</option></select>';
			$md_sel = str_replace('value="'.$maa.'"','value="'.$maa.'" selected="selected"',$md_sel);
			$md_sel .= '<br /> Display order: <input name="displayorder['.$md[0].']" type="number" value="'.number_format($do["$md[0]"]).'" class="textbox numeric" style="width: 50px;" />';
			$mp_data["$maa"] .= '<li style="padding: 5px; border:1px dotted #000; margin-top: 2px;"><b><i>'.$md[1].'</i></b><br />'.$md_sel.$md[2].'</li>';
		}
	}
	$tlhtml .= '<form method="post" action="competitions.php?do=modules"><input type="hidden" name="do" value="update_modules"><div id="above_content" style="margin: 10px; float: right;"><input type="submit" class="newcontent_textcontrol tooltipleft" value="'.$vbphrase['save_changes'].'" /></div><div style="clear: both;">';
	$css = ' border: 1px #000 dotted; padding: 10px;';
	
	/** CAROUSEL **/
		$fp_carousel = '<div id="ctrl_setting[tmnt_fp_carousel]" class="smallfont" style="white-space:nowrap; float: right;"><label for="rb_1_setting[tmnt_fp_carousel]_20"><input type="radio" name="setting[tmnt_fp_carousel]" id="rb_1_setting[tmnt_fp_carousel]_20" value="1" tabindex="1" onchange="this.form.submit();" /> Enable</label> <label for="rb_0_setting[tmnt_fp_carousel]_20"><input type="radio" name="setting[tmnt_fp_carousel]" id="rb_0_setting[tmnt_fp_carousel]_20" value="0" tabindex="1" onchange="this.form.submit();" /> Disable</label></div>';
		$fp_carousel = str_replace('value="'.$vbulletin->options['tmnt_fp_carousel'].'"', 'value="'.$vbulletin->options['tmnt_fp_carousel'].'" checked="checked"', $fp_carousel);
	$tlhtml .= '<div style="margin: 10px; '. $css . (!$vbulletin->options['tmnt_fp_carousel'] ? 'opacity: 0.75;' : '') . '">'.$fp_carousel.'<b>Carousel</b> <p style="padding-top: 5px;"><a href="competitions.php?do=editbanners">Edit front page banners</a></p></div>';
	/** SIDEBAR **/
		$tmnt_fp_sb_width = $vbulletin->options['tmnt_fp_sb_width'];
		if (!$vbulletin->options['tmnt_fp_sidebar'])
		{
			$vbulletin->options['tmnt_fp_sb_width'] = "75px";
			$h1 = true;
			$fps = 'opacity:0.75;';
		}
		$sd_pos = ($vbulletin->options['tmnt_fp_sidebar']?$vbulletin->options['tmnt_fp_sidebar']:'right');
		$fp_sidebar = '<select name="setting[tmnt_fp_sidebar]" id="sel_setting[tmnt_fp_sidebar]_5" tabindex="1" style="margin: -5px -5px 0 0; float: right;" onchange="this.form.submit();"> <option value="0">Hidden</option> <option value="left">Left</option> <option value="right">Right</option> </select>';
		$fp_sidebar = str_replace('value="'.$vbulletin->options['tmnt_fp_sidebar'].'"', 'value="'.$vbulletin->options['tmnt_fp_sidebar'].'" selected="selected"', $fp_sidebar);
		$fp_sidebar .= '<br /><br />Sidebar Width: <input type="text" class="textbox bginput" name="setting[tmnt_fp_sb_width]" id="it_setting[tmnt_fp_sb_width]_6" value="'.$tmnt_fp_sb_width.'" size="40" tabindex="1" style="width: 75px;" />';
	$tlhtml .= '<div style="margin: 10px; float: '.$sd_pos.';'. $css . $fps.' width: '.$vbulletin->options['tmnt_fp_sb_width'].'"><b>Sidebar</b>'.$fp_sidebar.'<ul style="padding-top:10px;clear:both;'.($h1?'display:none;':'').'">'.$mp_data['sidebar'].'</ul></div>';
	
	$tlcontent .= '<div style="margin: 10px; '. $css . '"><b>Main</b>'.$mp_main.'<ul style="padding-top:10px;">'.$mp_data['main'].'</ul></div>';
	$tlcontent .= '<div style="margin: 0px; padding: 0px; width:49.5%; float: right;"><div style="margin: 10px 5px 10px 10px; '. $css . '"><b>Right</b><ul style="padding-top:10px;">'.$mp_data['right'].'</ul></div></div>';
	$tlcontent .= '<div style="margin: 0px; padding: 0px; width:49.5%; float: left;"><div style="margin: 10px 5px 10px 10px; '. $css . '"><b>Left</b>'.'<ul style="padding-top:10px;">'.$mp_data['left'].'</ul></div></div>';
	
	$tlhtml .= '<div style="margin-'.$sd_pos.': '.number_format($vbulletin->options['tmnt_fp_sb_width']+40).'px; padding-top: 5px;">'.$tlcontent.'</div>';
	$tlhtml .= '<div style="clear: both; margin: 10px; padding: 10px; border: 1px dotted #000;"><b>Bottom</b><ul style="padding-top:10px;">'.$mp_data['bottom'].'</ul></div>';
	$tlhtml .= '<div style="border: #000 dashed 1px;clear: both; margin: 10px; padding: 10px;"><b>Un-used modules</b><ul style="padding-top:10px;">'.$mp_data['0'].'</ul></div>';
	$tlhtml .= '</div></form>';
	$navbits = array(
		'competitions.php' => $modname,
		'competitions.php?do=modules' => 'Front Page Modules'		
	);
	$navbar = render_navbar_template(construct_navbits($navbits));
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if (!IS_MOBILE_STYLE && !$_REQUEST['do'] && file_exists('includes/functions_tll_modules.php') && end(explode('/',$vbulletin->input->clean($_SERVER['REQUEST_URI'], TYPE_NOHTML))) == 'competitions.php')
{
	$_REQUEST['do'] = 'landing';
}

// #############################################################################

if ($_REQUEST['do'] == 'landing')
{
	require_once('./includes/functions_tll_modules.php');
	$c = $vbulletin->input->clean_gpc('g', 'c', TYPE_UINT);
	$cinfo = $vbulletin->tll_catcache["$c"];
	$categorytitle = $cinfo['title'];
	$parentcategorytitle = $cinfo['parenttitle'];
	$parentcategoryid = $cinfo['parentid'];
	if($c == -1)
	{
		$c = 0;
	}
	if ($cinfo['parsed_banner'])
	{
		$cinfo['banner'] = $cinfo['parsed_banner'];
	}
	elseif ($cinfo['banner'])
	{
		require_once(DIR . '/includes/class_bbcode.php');
		$bbcode_parser = new vB_BbCodeParser($vbulletin, fetch_tag_list(), true); 
		$cinfo['banner'] = $bbcode_parser->do_parse($cinfo['banner']);
	}
	if (!$c)
	{
		$cinfo['tol'] = array('tmnts','ladders','leagues','kings');
	}
	require_once('./includes/functions_tll_modules.php');
	$mp = array();
	foreach ($m_array AS $m)
	{
		$ao = '';
		$l = 'tmnt_fp_'.$m.'_loc';
		$o = $vbulletin->options["$l"];
		switch ($o)
		{
			case 'br':
			case 'tr':
				$o = 'right';
				break;
		}
		$mp[$o][] = array($l,$ph,$ao,number_format($do["$l"]));
	}
	foreach ($mp AS $maa => &$ma)
	{
		$ma = subval_sort($ma,3);
	}
	//print_r($mp);
	$modules = tll_prepare_modules();
	/*CAROUSEL*/
	if ($vbulletin->options['tmnt_fp_carousel'] && !$c)
	{
		$tmnt_car_array = array();
		$query_banners = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "tmnt_banners");
		while ($banner = $vbulletin->db->fetch_array($query_banners))
		{
			$tmnt_car_array[] = $banner;
		}
		$templater = vB_Template::create('tmnt_carousel');
			$templater->register('cat', $cat);
			$templater->register('tmntp', $tmntp);
			$templater->register('tmnt_car_array', $tmnt_car_array);
			$templater->register('c', $c);
		$locations['carousel'] .= $templater->render();
	}
	/*SIDEBAR*/
	if ($mp['sidebar'])
	{
		foreach ($mp['sidebar'] AS $m)
		{
			$q = substr($m['0'],8,-4);
			$locations['sidebar'] .= $modules["$q"];
		}
	}
	/*LEFT*/
	if ($mp['left'])
	{
		foreach ($mp['left'] AS $m)
		{
			$q = substr($m['0'],8,-4);
			$locations['left'] .= $modules["$q"];
		}
	}
	/*RIGHT*/
	if ($mp['right'])
	{
		foreach ($mp['right'] AS $m)
		{
			$q = substr($m['0'],8,-4);
			$locations['right'] .= $modules["$q"];
		}
	}
	/*BOTTOM*/
	if ($mp['bottom'])
	{
		foreach ($mp['bottom'] AS $m)
		{
			$q = substr($m['0'],8,-4);
			$locations['bottom'] .= $modules["$q"];
		}
	}
	/*MAIN*/
	if ($mp['main'])
	{
		foreach ($mp['main'] AS $m)
		{
			$q = substr($m['0'],8,-4);
			$locations['main'] .= $modules["$q"];
		}
	}
	$grid_right = number_format($vbulletin->options['tmnt_fp_sb_width'])+40;
	$templater = vB_Template::create('tmnt_landing_grid');
		$templater->register('cat', $cat);
		$templater->register('tmntp', $tmntp);
		$templater->register('rawfilter', $rawfilter);
		$templater->register('c', $c);
		$templater->register('filename', $filename);
		$templater->register('locations', $locations);
		$templater->register('grid_right', $grid_right);
	$tlhtml .= $templater->render();

	$navbits = array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname
	);
	$navbar = render_navbar_template(construct_navbits($navbits));
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if (empty($_REQUEST['do']))
{
	$c = $vbulletin->input->clean_gpc('g', 'c', TYPE_UINT);
	if (!$c && $vbulletin->options['tmnt_premium'] && $vbulletin->options['tmnt_seo'] && isset($_SERVER['REQUEST_URI']))
	{
		$thisurl = explode('/',$vbulletin->input->clean($_SERVER['REQUEST_URI'], TYPE_NOHTML));
		$thisurl = end($thisurl);
		if ($thisurl && substr($thisurl, 0, 17)=='competitions.php?')
		{
			$c = $vbulletin->input->clean(substr($thisurl,17), TYPE_UINT);
		}
	}
	$cinfo = $vbulletin->tll_catcache["$c"];
	$categorytitle = $cinfo['title'];
	$parentcategorytitle = $cinfo['parenttitle'];
	$parentcategoryid = $cinfo['parentid'];
	if($c == -1)
	{
		$c = 0;
	}
	if ($cinfo['parsed_banner'])
	{
		$cinfo['banner'] = $cinfo['parsed_banner'];
	}
	elseif ($cinfo['banner'])
	{
		require_once(DIR . '/includes/class_bbcode.php');
		$bbcode_parser = new vB_BbCodeParser($vbulletin, fetch_tag_list(), true); 
		$cinfo['banner'] = $bbcode_parser->do_parse($cinfo['banner']);
	}
	if (!$c)
	{
		$cinfo['tol'] = array('tmnts','ladders','leagues','kings');
	}
	$filename = 'competitions';
	if ($vbulletin->tll_catcache)
	{
		foreach ($vbulletin->tll_catcache AS $cindex => $cat)
		{
			if ($c && $cat['parentid'] != $c)
			{
				continue;
			}
			$templater = vB_Template::create('tmnt_cat');
				$templater->register('cat', $cat);
				$templater->register('tmntp', $tmntp);
				$templater->register('rawfilter', $rawfilter);
				$templater->register('c', $c);
				$templater->register('filename', $filename);
			if (!$c && $cat['parentid'])
			{
				$carray["$cat[parentid]"] .= $templater->render();
			}
			else
			{
				$templater->register('subcs', $carray["$cat[catid]"]);
				$categories .= $templater->render();
			}
		}
	}
	$hide = array(
		'created' => true
	);
	if ($vbulletin->options['tmnt_fp_cal_loc'] && $vbulletin->options['tmnt_premium'])
	{
		$template_hook['tmnt_fp_'.$vbulletin->options['tmnt_fp_cal_loc']] .= '<iframe src="competitions.php?do=calendar&amp;embed=1" style="width: 100%; height: 275px; margin-bottom: 15px; overflow-y: hidden; border: none;"></iframe>';
	}
	if ($tmntp['canviewtmnt'] && in_array('tmnts', $cinfo['tol']))
	{
		$rowcount = 0;
		$tmnts = $vbulletin->db->query_read("
			SELECT tmnts.*
			FROM " . TABLE_PREFIX . "tmnt_tmnts AS tmnts
			WHERE tmnts.catid = '$c'
			ORDER BY tmnts.id DESC
			LIMIT 0, 6
		");
		while($tmnt = $vbulletin->db->fetch_array($tmnts))
		{
			if ($rowcount > 4)
			{
				$show['moretmnts'] = true;
				break;
			}
			$tmnt['players'] = $tmnt['noplayers'] - $tmnt['freeslots'];
	        $description = preg_replace('/\[(.*?)\]/is', '', $tmnt['description']);
			$descriptionlength = strlen($description);
			if ($descriptionlength > $vbulletin->options['tmnt_desclength'])
			{
				$description = substr($description, 0, $vbulletin->options['tmnt_desclength']);
				$description = $description . '...';
			}
			if ($tmnt['pot'])
			{
				$tmnt['pot'] = $vbphrase['tmnt_team'];
			}
			else
			{
				$tmnt['pot'] = '';
			}
			$tmnt = switch_tmnt_type($tmnt);
			$tmnt = switch_tmnt_status($tmnt);
			$rowcount++;
			$tmnt['url'] = tll_seo('tmnt', $tmnt['id'], $tmnt['title']);
			$templater = vB_Template::create('tmnt_index_tbit');
				$templater->register('tmnt', $tmnt);
				$templater->register('hide', $hide);
				$templater->register('description', $description);
			$latesttmnts .= $templater->render();
		}
		if ($rowcount == 0)
		{
			$templater = vB_Template::create('tmnt_notmnts');
			$latesttmnts .= $templater->render();
		}
		else if ($vbulletin->options['tmnt_fp_nv'])
		{
			//get latest tmnt winners
			if ($vbulletin->options['tmnt_fp_twins_loc'])
			{
				$parray = array();
				$players = $vbulletin->db->query_read("
					SELECT p.*, t.title AS ttitle
					FROM " . TABLE_PREFIX . "tmnt_players AS p
					LEFT JOIN " . TABLE_PREFIX . "tmnt_tmnts AS t
						ON (t.id = p.tid)
					WHERE p.winner = 1
					ORDER BY p.id DESC
					LIMIT 0, 5
				");
				while($player = $vbulletin->db->fetch_array($players))
				{
					$player['tmnturl'] = tll_seo('tmnt', $player['tid'], $player['ttitle']);
					if ($player['pot'])
					{
						$player['teamurl'] = tll_seo('team', $player['userid'], $player['username']);
					}
					$parray[] = $player;
				}
			}
			if ($vbulletin->options['tmnt_fp_com_loc'])
			{
				$tcarray = array();
				$comments = $vbulletin->db->query_read("
					SELECT c.*, t.title AS tmnttitle
					FROM " . TABLE_PREFIX . "tmnt_comments AS c
					LEFT JOIN " . TABLE_PREFIX . "tmnt_tmnts AS t
						ON (t.id = c.tid)
					WHERE t.catid = '$c'
					ORDER BY c.time DESC
					LIMIT 0, 15
				");
				$maxl = $vbulletin->options['tmnt_fp_com_cml'];
				while($comment = $vbulletin->db->fetch_array($comments))
				{
					$comment['comment'] = remove_bbcode($comment['comment']);
					if (strlen($comment['comment']) > $maxl)
					{
						$comment['comment'] = substr($comment['comment'], 0, $maxl)."<a href=\"tournaments.php?do=view&amp;id=".$comment['tid']."&amp;sh=4#vmessage".$comment['id']."\">...</a>";
					}
					$comment['tmnturl'] = tll_seo('tmnt', $comment['tid'], $comment['tmnttitle']);
					$tcarray["$comment[id]"] = $comment;
					$show['comments'] = true;
					$show['comments_tc']++;
				}
			}
		}
	}
	if ($tmntp['canviewkings'] && in_array('kings', $cinfo['tol']))
	{
		$rowcount = 0;
		$kings = $vbulletin->db->query_read("
			SELECT k.*
			FROM " . TABLE_PREFIX . "tmnt_kings AS k
			WHERE k.catid = '$c'
			ORDER BY k.id DESC
			LIMIT 0, 6
		");
		while($king = $vbulletin->db->fetch_array($kings))
		{
			if ($rowcount > 4)
			{
				$show['morekings'] = true;
				break;
			}
	        $description = preg_replace('/\[(.*?)\]/is', '', $king['description']);
			$descriptionlength = strlen($description);
			if ($descriptionlength > $vbulletin->options['tmnt_desclength'])
			{
				$description = substr($description, 0, $vbulletin->options['tmnt_desclength']);
				$description = $description . '...';
			}
			$rowcount++;
			$king['url'] = tll_seo('king', $king['id'], $king['title']);
			$templater = vB_Template::create('tmnt_index_kbit');
				$templater->register('king', $king);
				$templater->register('description', $description);
			$latestkings .= $templater->render();
		}
		if ($rowcount == 0)
		{
			$templater = vB_Template::create('tmnt_nokings');
			$latestkings .= $templater->render();
		}
	}
	if ($tmntp['canviewladder'] && in_array('ladders', $cinfo['tol']))
	{
		$lrowcount = 0;
		$ladders = $vbulletin->db->query_read("
			SELECT *
			FROM " . TABLE_PREFIX . "tmnt_ladders
			WHERE catid = '$c' AND league = 0
			ORDER BY id DESC
			LIMIT 0, 6
		");
		while($ladder = $vbulletin->db->fetch_array($ladders))
		{
			if ($lrowcount > 4)
			{
				$show['moreladders'] = true;
				break;
			}
	        $description = preg_replace('/\[(.*?)\]/is', '', $ladder['description']);
			if (strlen($description) > $vbulletin->options['tmnt_desclength'])
			{
				$description = substr($description, 0, $vbulletin->options['tmnt_desclength']);
				$description = $description . '...';
			}
			$ladder['url'] = tll_seo('ladder', $ladder['id'], $ladder['title'],1);
			$templater = vB_Template::create('tmnt_index_lbit');
				$templater->register('description', $description);
				$templater->register('hide', $hide);
				$templater->register('ladder', $ladder);
			$latestladders .= $templater->render();
			$lrowcount++;
		}
		if ($lrowcount == 0)
		{
			$templater = vB_Template::create('tmnt_ladder_noladders');
			$latestladders .= $templater->render();
		}
	}
	if ($tmntp['canviewladder'] && in_array('leagues', $cinfo['tol']))
	{
		$lgrowcount = 0;
		if (!$vbulletin->options['tmnt_disable_leagues'])
		{
			$leagues = $vbulletin->db->query_read("
				SELECT *
				FROM " . TABLE_PREFIX . "tmnt_ladders
				WHERE catid = '$c' AND league > 0
				ORDER BY id DESC
				LIMIT 0, 6
			");
			while($league = $vbulletin->db->fetch_array($leagues))
			{
				if ($lgrowcount > 4)
				{
					$show['moreleagues'] = true;
					break;
				}
				$description = preg_replace('/\[(.*?)\]/is', '', $league['description']);
				if (strlen($description) > $vbulletin->options['tmnt_desclength'])
				{
					$description = substr($description, 0, $vbulletin->options['tmnt_desclength']);
					$description = $description . '...';
				}
				$league['url'] = tll_seo('ladder', $league['id'], $league['title'],1);
				$templater = vB_Template::create('tmnt_index_lbit');
					$templater->register('description', $description);
					$templater->register('hide', $hide);
					$templater->register('ladder', $league);
				$latestleagues .= $templater->render();
				$lgrowcount++;
			}
			if ($lgrowcount == 0)
			{
				$templater = vB_Template::create('tmnt_ladder_noladders');
					$templater->register('league', 1);
				$latestleagues .= $templater->render();
			}
		}
	}
		if ($lrowcount > 0 || $lgrowcount > 0)
		{
			if ($vbulletin->options['tmnt_fp_com_loc'] && !$vbulletin->options['tmnt_ladder_priv_mc'])
			{
				$mcarray = array();
				$comments = $vbulletin->db->query_read("
					SELECT mcs.*, games.*, usera.username AS username_u, userb.username AS username_u2, teama.teamname AS teamname_u, teamb.teamname AS teamname_u2, ladders.title AS laddertitle, mcs.dateline
					FROM " . TABLE_PREFIX . "tmnt_ladder_mcs AS mcs
					LEFT JOIN " . TABLE_PREFIX . "tmnt_ladder_games AS games
						ON (mcs.mid = games.id)
					LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders
						ON (games.lid = ladders.id)
					LEFT JOIN " . TABLE_PREFIX . "user AS usera
						ON (games.u = usera.userid)
					LEFT JOIN " . TABLE_PREFIX . "user AS userb
						ON (games.u2 = userb.userid)
					LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS teama
						ON (games.u = teama.teamid)
					LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS teamb
						ON (games.u2 = teamb.teamid)
					WHERE ladders.catid = '$c'
						AND games.accepted = 1
					ORDER BY mcs.dateline DESC
					LIMIT 0, 15
				");
				$maxl = $vbulletin->options['tmnt_fp_com_cml'];
				while($comment = $vbulletin->db->fetch_array($comments))
				{
					$comment['comment'] = remove_bbcode($comment['comment']);
					if (strlen($comment['comment']) > $maxl)
					{
						$comment['comment'] = substr($comment['comment'], 0, $maxl)."<a href=\"ladders.php?do=view&amp;id=".$comment['lid'].($comment['finished'] ? "&amp;sh=1" : "&amp;sh=2")."&amp;mid=".$comment['mid']."#".$comment['mid']."\">...</a>";
					}
					$comment['ladderurl'] = tll_seo('ladder', $comment['lid'], $comment['laddertitle']);
					$mcarray["$comment[mid]"] = $comment;
					$show['comments'] = true;
					$show['comments_mc']++;
				}
			}
			if ($vbulletin->options['tmnt_fp_mat_loc'])
			{
				list($count, $recentmatches, $upcomingmatches) = get_rg_ug($c);
			}
		}
		if ($vbulletin->options['tmnt_fp_warl_loc'] && $vbulletin->options['tmnt_warlights'] && $vbulletin->options['tmnt_premium'])
		{
			$array2 = $array = array();
			$players_query = $vbulletin->db->query_read("
				SELECT p.*, l.title AS laddertitle, IF (p.pot = 1, t.teamname, u.username) AS username
				FROM " . TABLE_PREFIX . "tmnt_ladder_players AS p
				LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS l
					ON (p.lid = l.id)
				LEFT JOIN " . TABLE_PREFIX . "user AS u
					ON (p.userid = u.userid)
				LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS t
					ON (p.userid = t.teamid)
				WHERE p.warlight > '".TIMENOW."'
					AND (p.userid != '".$vbulletin->userinfo['userid']."'
						OR p.pot = 1)
					AND l.archive = 0
					AND p.active = 1
				LIMIT 0, 10
			");
			while($player = $vbulletin->db->fetch_array($players_query))
			{
				$array[] = $player;
			}
			if ($vbulletin->userinfo['userid'])
			{
				$players_query = $vbulletin->db->query_read("
					SELECT p.*, l.title AS laddertitle
					FROM " . TABLE_PREFIX . "tmnt_ladder_players AS p
					LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS l
						ON (p.lid = l.id)
					WHERE p.warlight < '".TIMENOW."'
						AND p.userid = '".$vbulletin->userinfo['userid']."'
						AND p.pot = 0
						AND l.league = 0
				");//filter closed ladders
				while($player = $vbulletin->db->fetch_array($players_query))
				{
					$array2[] = $player;
				}
			}
			$templater = vB_Template::create('tmnt_fp_warlights');
				$templater->register('hide', $hide);
				$templater->register('tll_array', $array);
				$templater->register('tll_array2', $array2);
			$warlights = $templater->render();
		}
	
	if (!$c && $lgrowcount+$lrowcount+$rowcount==0)
	{
		$show['no_uncat'] = true;
	}
	$sh = $vbulletin->input->clean_gpc('g', 'sh', TYPE_NOHTML);
	if (!in_array($sh, array('rg','ug')))
	{
		$sh = 'rg';
	}
	$show['fp'] = 1;
	$templater = vB_Template::create('tmnt_ladder_list_rm');
		$templater->register('tmntp', $tmntp);
		$templater->register('rowcount', $rowcount);
		$templater->register('categorytitle', $categorytitle);
		$templater->register('categories', $categories);
		$templater->register('ladder', $ladder);
		$templater->register('template_hook', $template_hook);
		$templater->register('recentmatches', $recentmatches);
		$templater->register('upcomingmatches', $upcomingmatches);
		$templater->register('random', $random);
		$templater->register('count', $count);
		$templater->register('sh', $sh);
		$templater->register('show', $show);
		$templater->register('c', $c);
	$recentmatches = $templater->render();
	$sh = $vbulletin->input->clean_gpc('g', 'sh', TYPE_NOHTML);
	if (!in_array($sh, array('l','t','lg')))
	{
		if (in_array('tmnts',$cinfo['tol']))
		{
			$sh = 't';
		}
		else
		{
			$sh = 'l';
		}
		if (!$lrowcount)
		{
			if (in_array('leagues',$cinfo['tol'])&&$lgrowcount)
			{
				$sh = 'lg';
			}
			elseif (in_array('tmnts',$cinfo['tol']))
			{
				$sh = 't';
			}
		}
	}
	$csh = $vbulletin->input->clean_gpc('g', 'csh', TYPE_NOHTML);
	if ($csh == 'tc' OR !$show['comments_mc'] OR in_array('tmnts',$cinfo['tol']))
	{
		$csh = 'tc';
	}
	else
	{
		$csh = 'mc';
	}
	if ($vbulletin->options['tmnt_fp_hof_loc'])
	{
		$show['marginbottom'] = true;
		$show['asblock'] = true;
		$rowcount = 1;
		$rowno = 0;
		$array = array();
		$hofs = $vbulletin->db->query_read("
			SELECT userid, username, tmnt_wins, tmnt_joins
			FROM " . TABLE_PREFIX . "user
			WHERE tmnt_wins != 0
				OR tmnt_joins != 0
			ORDER BY tmnt_wins DESC,
				tmnt_joins ASC
			LIMIT 0, 5
		");
		while($hof = $vbulletin->db->fetch_array($hofs))
		{
			$rowcount ++;
			$score = $hof['tmnt_wins'];
			if ($rowno == 0)
			{
				$topscore = $score;
				$lastscore_score = $topscore;
				$lastscore_row = 1;
			}
			$rowno ++;
			if ($score == $lastscore_score AND $rowno != 1)
			{
				$hof['rowno'] = $lastscore_row ."=";
			}
			else
			{
				$lastscore_row = $rowno;
				$lastscore_score = $score;
				$hof['rowno'] = $rowno;
			}
			$array[] = $hof;
		}
		if ($array)
		{
			$templater = vB_Template::create('tmnt_hof');
				$templater->register('array', $array);
				$templater->register('show', $show);
			$hofb .= $templater->render();
		}
	}
	if (($x = $vbulletin->options['tmnt_fp_credits_loc']) && $vbulletin->options['tmnt_premium'] && $vbulletin->options['tmnt_credit_system'] && $vbulletin->userinfo['userid'])
	{
require_once(DIR . '/includes/functions_tll_prem.php');
		$info = array();
		$info['currency_symbol'] = fetch_currency_symbol($vbulletin->options['tmnt_credits_currency']);
		$info['credit_value'] = $vbulletin->options['tmnt_credit_value'];
		$templater = vB_Template::create('tmnt_fpblock_credits');
			$templater->register('tmntp', $tmntp);
			$templater->register('info', $info);
		$template_hook['tmnt_fp_'.$x] .= $templater->render();
	}
	if (($x = $vbulletin->options['tmnt_fp_hof_loc']) && $hofb)
	{
		$template_hook['tmnt_fp_'.$x] .= $hofb;
	}
	if (($x = $vbulletin->options['tmnt_fp_anns_loc']) && $annarray)
	{
		$templater = vB_Template::create('tmnt_fpblock_anns');
			$templater->register('tmntp', $tmntp);
			$templater->register('annarray', $annarray);
		$template_hook['tmnt_fp_'.$x] .= $templater->render();
	}
	if (($x = $vbulletin->options['tmnt_fp_com_loc']) && ($mcarray || $tcarray))
	{
		$templater = vB_Template::create('tmnt_fpblock_comments');
			$templater->register('tmntp', $tmntp);
			$templater->register('mcarray', $mcarray);
			$templater->register('tcarray', $tcarray);
			$templater->register('show', $show);
			$templater->register('cinfo', $cinfo);
			$templater->register('csh', $csh);
		$template_hook['tmnt_fp_'.$x] .= $templater->render();
	}
	if (($x = $vbulletin->options['tmnt_fp_twins_loc']) && $parray)
	{
		$templater = vB_Template::create('tmnt_fpblock_twins');
			$templater->register('tmntp', $tmntp);
			$templater->register('parray', $parray);
		$template_hook['tmnt_fp_'.$x] .= $templater->render();
	}
	if ($x = $vbulletin->options['tmnt_fp_random_loc'])
	{
		$template_hook['tmnt_fp_'.$x] .= get_random_l_torp($c);
	}
	if (($x = $vbulletin->options['tmnt_fp_mat_loc']) && $recentmatches)
	{
		$css = '';
		$template_hook['tmnt_fp_'.$x] .= $recentmatches;
	}
	if (($x = $vbulletin->options['tmnt_fp_warl_loc']) && $warlights)
	{
		$template_hook['tmnt_fp_'.$x] .= $warlights;
	}
	//$random2 = get_random_t_torp($c);
	$tlhtml = str_replace('{recentmatches}', $recentmatches, $tlhtml);
	if ($vbulletin->options['tmnt_fp_carousel'] && !$c)
	{
		$tmnt_car_array = array();
		$query_banners = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "tmnt_banners");
		while ($banner = $vbulletin->db->fetch_array($query_banners))
		{
			$tmnt_car_array[] = $banner;
		}
	}
	$thisurl = tll_seo('cat', $c, $categorytitle);
	if ($vbulletin->options['fp_columns'])
	{
		$tcss['table'] .= 'display: table-row;';
		$tcss['cell'] .= 'display: table-cell; padding-right: 10px;';
	}
	else
	{
		$tcss['cellbody'] .= 'margin-bottom: 15px;';
	}
	($hook = vBulletinHook::fetch_hook('tll_prepare_index')) ? eval($hook) : false;
	$templater = vB_Template::create('tmnt_index_c');
		$templater->register('latesttmnts', $latesttmnts);
		$templater->register('categories', $categories);
		$templater->register('c', $c);
		$templater->register('cinfo', $cinfo);
		$templater->register('show', $show);
		$templater->register('sh', $sh);
		$templater->register('csh', $csh);
		$templater->register('tcss', $tcss);
		$templater->register('latestladders', $latestladders);
		$templater->register('latestleagues', $latestleagues);
		$templater->register('latestkings', $latestkings);
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt_car_array', $tmnt_car_array);
		$templater->register('template_hook', $template_hook);
		$templater->register('recentmatches', $recentmatches);
		$templater->register('thisurl', $thisurl);
	$tlhtml .= $templater->render();
	$navbits = array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname
	);
	if ($parentcategoryid)
	{
		$p_c_info = $vbulletin->tll_catcache["$parentcategoryid"];
		$x = 'competitions.php' . $p_c_info['url'];
		$navbits["$x"] = $parentcategorytitle;
	}
	if ($categorytitle)
	{
		$navbits[''] = $categorytitle;
	}
	$navbits = construct_navbits($navbits);
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('headinclude', $headinclude);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('tlhtml', $tlhtml);
		$templater->register('modname', $modname);
		$templater->register('header', $header);
		$templater->register('footer', $footer);
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt_version', $tmnt_version);
		$templater->register('show', $show);
	print_output($templater->render());
}

// #############################################################################

?>