<?php
/*======================================================================*\
|| #################################################################### ||
|| # Copyright  BananaLive Scripts. All Rights Reserved. ############# ||
|| #################################################################### ||
\*======================================================================*/

error_reporting(E_ALL & ~E_NOTICE);
define('THIS_SCRIPT', 'ladders');
if ($_REQUEST['do'] && in_array($_REQUEST['do'], array('pmcmpt')))
{
define('GET_EDIT_TEMPLATES', true);
}
$phrasegroups = array('posting', 'postbit', 'user', 'timezone', 'global', 'pm', 'reputationlevel', 'search', 'calendar');
$specialtemplates = array(
	'bbcodecache',
	'smiliecache',
	'tll_catcache',
);
$globaltemplates = array(
	'tmnt_shell'
);
$actiontemplates = array(
	'leaveladder' => array(
		'tmnt_ladder_teamleave'
	),
	'insertchal' => array(
		'tmnt_ladder_chalpm'
	),
	'warlights' => array(
		'tmnt_warlights'
	),
	'matchfinder' => array(
		'tmnt_warlights',
		'tmnt_ladder_mf'
	),
	'pm' => array(
		'tmnt_ladder_threadtemplate2'
	),
	'join' => array(
		'tmnt_ladder_join'
	),
	'editavatar' => array(
		'tmnt_ladder_editavatar'
	),
	'editbadge' => array(
		'tmnt_ladder_editbadge'
	),
	'insertchal' => array(
		'tmnt_ladder_chal'
	),
	'player_popup' => array(
		'tmnt_ladder_player_popup'
	),
	'pmcmpt' => array(
		'tmnt_ladder_threadtemplate2',
		'tmnt_newpm'
	),
	'challenges' => array(
		'tmnt_ladder_chll_top',
		'tmnt_ladder_chll',
		'tmnt_ladder_chll_bot',
		'tmnt_ladder_yourteams'
	),
	'rearrange_match' => array(
		'tmnt_date_time',
		'tmnt_ladder_rearrange'
	),
	'enable_warlight' => array(
		'tmnt_enablelivematch_chooseteam'
	),
	'allchallenges' => array(
		'tmnt_ladder_all_chll_top',
		'tmnt_ladder_chll',
		'tmnt_ladder_chll_bot'
	),
	'reportedmatches' => array(
		'tmnt_ladder_repmatch'
	),
	'acceptmf' => array(
		'tmnt_ladder_mfpm'
	),
	'submitscore' => array(
		'tmnt_ladder_submitscore'
	),
	'editsquad' => array(
		'tmnt_ladder_editsquad'
	),
	'viewmatch' => array(
		'tmnt_ladder_viewmatch'
	),
	'search_matches' => array(
		'tmnt_ladder_searchmatches'
	)
);

require_once('./global.php');
require_once(DIR . '/includes/functions.php');
require_once(DIR . '/includes/functions_tal.php');

($hook = vBulletinHook::fetch_hook('tll_ladders_start')) ? eval($hook) : false;

$navbits = construct_navbits(array(
	'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
	'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase[ladders],
	'' => construct_phrase('Error')
));
$navbar = render_navbar_template($navbits);

// #############################################################################

if (!$_REQUEST['do'] && !$_POST['do'])
{
	exit;
}

// #############################################################################

if ($_POST['do'] == 'insertscore' OR $_REQUEST['do'] == 'insertscore')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'u'             => TYPE_UINT,
		'u2'            => TYPE_UINT,
		'lid'           => TYPE_UINT,
		'id'            => TYPE_UINT,
		'orig_score_u'  => TYPE_UINT,
		'orig_score_u2' => TYPE_UINT,
		'score_u'       => TYPE_UINT,
		'score_u2'      => TYPE_UINT,
		'agree_u'       => TYPE_UINT,
		'agree_u2'      => TYPE_UINT,
		'pot'           => TYPE_UINT,
		'from'          => TYPE_NOHTML,
		'sh'           => TYPE_UINT,
		'squadscore'    => TYPE_ARRAY_UINT,
		'assists'    => TYPE_ARRAY_UINT,
		'yellowcard'    => TYPE_ARRAY_UINT,
		'cleansheet'    => TYPE_ARRAY_UINT,
		'redcard'    => TYPE_ARRAY_UINT,
		'screen'        => TYPE_NOHTML,
	));
	//print_r($vbulletin->GPC);
	if (!$tmntp['canjoinladder'])
	{
		print_no_permission();
	}
	$id            = $vbulletin->GPC['id'];
	$lid            = $vbulletin->GPC['lid'];
	$u             = $vbulletin->GPC['u'];
	$u2            = $vbulletin->GPC['u2'];
	$agree_u       = $vbulletin->GPC['agree_u'];
	$agree_u2      = $vbulletin->GPC['agree_u2'];
	$userid        = $thisuserid;
	$score_u       = $vbulletin->GPC['score_u'];
	$score_u2      = $vbulletin->GPC['score_u2'];
	$origscore_u   = $vbulletin->GPC['orig_score_u'];
	$origscore_u2  = $vbulletin->GPC['orig_score_u2'];
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id = '$lid' ");
	/*if (file_exists('tll_modules/tll_autoscoreconfirm.php')&& $ladder['autoscoreconfirm'])
	{
		$agree_u = $agree_u2 = 1;
	}*/
	$lid           = $vbulletin->GPC['lid'];
	$pot           = $vbulletin->GPC['pot'];
	$screen        = $vbulletin->GPC['screen'];
	$upload = $vbulletin->input->clean_gpc('f', 'upload', TYPE_FILE);
	$uploadDir = 'images/ladder_images/';
	$fileName = $upload['name'];
	$tmpName  = $upload['tmp_name'];
	function img_resize($tmpname, $width, $height, $save_dir, $save_name)
	{
		$save_dir .= ( substr($save_dir,-1) != "/") ? "/" : "";
		$gis       = GetImageSize($tmpname);
		$type       = $gis[2];
		switch($type)
		{
			case "1": $imorig = imagecreatefromgif($tmpname); break;
			case "2": $imorig = imagecreatefromjpeg($tmpname);break;
			case "3": $imorig = imagecreatefrompng($tmpname); break;
			default:  $imorig = imagecreatefromjpeg($tmpname);
		}
        $x = imageSX($imorig);
        $y = imageSY($imorig);
		$c = $x;
		$d = $y;
		if (($d > $height) OR ($c > $width))
		{
			$a = $d/$height;
			$b = $c/$width;
			if ($a > $b)
			{
				$r  = $d/$height;
				$d = $d/$r;
				$c  = $c/$r;
			}
			else
			{
				$r  = $c/$width;
				$d = $d/$r;
				$c  = $c/$r;
			}
		}
        $im = imagecreate($c, $d);
        $im = imagecreatetruecolor($c,$d);
		if (imagecopyresampled($im,$imorig,0,0,0,0,$c,$d,$x,$y))
		{
			if (imagejpeg($im, $save_dir.$save_name))
			{
				return true;
			}
			else
			{
				return false;
			}
		}
    }
	if ($tmpName != '')
	{
		if ($teamlogo['error'])
		{
			$errormessage = $vbphrase['error_uploading_team_logo'].$teamlogo['error'];
			eval(standard_error($errormessage));
		}
		else
		{
			$randName = md5(rand() * time());
			$ext      = substr(strrchr($fileName, "."), 1);
			$imgexts  = array('jpg', 'jpeg', 'png', 'gif');
			if (in_array(strtolower($ext), $imgexts)) 
			{
				@img_resize($tmpName, 800, 600, $uploadDir, $randName.".jpg");
				$filePath = $uploadDir.$randName.".jpg";
				if (file_exists($filePath))
				{
					$screen = ($screen ? "$screen;" : "").$vbulletin->options['bburl']."/".$filePath;
				}
			}
			
		}
	}
	$games = $vbulletin->db->query_first("
		SELECT games.*, ladders.pot, ladders.xp_win, ladders.xp_draw, ladders.xp_lose
		FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
		LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders
			ON(games.lid=ladders.id)
		WHERE games.id = '$id'
	");
	$player_u = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid = '$lid' AND userid = '$u' ");
	$player_u2 = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid = '$lid' AND userid = '$u2' ");
	if ($games['pot'])
	{
		$team = true;
		$pot = 1;
		$teamids = array();
		$teams = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "tmnt_members JOIN " . TABLE_PREFIX . "tmnt_teams on " . TABLE_PREFIX . "tmnt_members.teamid = " . TABLE_PREFIX . "tmnt_teams.teamid WHERE " . TABLE_PREFIX . "tmnt_members.leader=1 AND " . TABLE_PREFIX . "tmnt_members.userid=$userid");
		while($teamm = $vbulletin->db->fetch_array($teams))
		{
			$teamid = $teamm['teamid'];
			$teamids = array_merge((array)$teamid, $teamids);
		}
		$eteamids = $teamids;
		$teamids = implode(",", $teamids);
		if (!in_array($u, $eteamids) AND !in_array($u2, $eteamids))
		{
			print_no_permission();
		}
		if (file_exists(DIR . '/tll_modules/tll_squadscores.php'))
		{
			foreach ($vbulletin->GPC['assists'] AS $key => $value)
			{
				list($a, $b) = explode('_',$key);
				$assists["$a"]["$b"] = $value;
			}
			$assists = serialize($assists);
			$scores_hold = array();
			$vbulletin->GPC['squadscore'];
			foreach ($vbulletin->GPC['squadscore'] AS $key => $value)
			{
				list($a, $b) = explode('_',$key);
				
				if ($a == 'u')
				{
					$add_score_u += $value;
				}
				elseif ($a == 'u2')
				{
					$add_score_u2 += $value;
				}
				else
				{
					continue;
				}
				$scores_hold["$a"]["$b"] = $value;
			}
			if ($add_score_u > 0 && $add_score_u != $score_u)
			{
				$uinfo = fetch_teaminfo($u);
				$errormessage = "You have submitted team scores for ".$uinfo[teamname]." adding up to $add_score_u which does not match their score ($score_u). <br /><br /> Please press back and rectify this error.";
				eval(standard_error($errormessage));
			}
			if ($add_score_u2 > 0 && $add_score_u2 != $score_u2)
			{
				$u2info = fetch_teaminfo($u2);
				$errormessage = "You have submitted team scores for ".$u2info[teamname]." adding up to $add_score_u2 which does not match their score ($score_u2). <br /><br /> Please press back and rectify this error.";
				eval(standard_error($errormessage));
			}
			if ($add_score_u == 0 && $add_score_u2 == 0)
			{
				$squad_scores = '';
			}
			else
			{
				$squad_scores = array();
				if ($add_score_u == $score_u)
				{
					$squad_scores['u'] = $scores_hold['u'];
				}
				if ($add_score_u2 == $score_u2)
				{
					$squad_scores['u2'] = $scores_hold['u2'];
				}
				$squad_scores = serialize($squad_scores);
			}
		}
		foreach ($vbulletin->GPC['yellowcard'] AS $key => $value)
		{
			list($a, $b) = explode('_',$key);
			$yellow_cards["$a"][] = $b;
		}
		$yellow_cards = serialize($yellow_cards);
		foreach ($vbulletin->GPC['redcard'] AS $key => $value)
		{
			list($a, $b) = explode('_',$key);
			$red_cards["$a"][] = $b;
		}
		$red_cards = serialize($red_cards);
		foreach ($vbulletin->GPC['cleansheet'] AS $key => $value)
		{
			list($a, $b) = explode('_',$key);
			switch ($a)
			{
				case 'u':
					$ao = 'score_u2';
				break;
				case 'u2':
					$ao = 'score_u';
				break;
			}
			if ($$ao > 0)
			{
				continue;
			}
			$cleansheets["$a"][] = $b;
		}
		$cleansheets = serialize($cleansheets);
		if ($origscore_u == $score_u AND $origscore_u2 == $score_u2)
		{
			if (in_array($u, $eteamids))
			{
				if ($agree_u2 == 1) 
				{
					$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET agree_u = 1, finished = 1, screen_u = '".$vbulletin->db->escape_string($screen)."', squad_scores = '".$vbulletin->db->escape_string($squad_scores)."', assists = '".$vbulletin->db->escape_string($assists)."', cleansheets = '".$vbulletin->db->escape_string($cleansheets)."', yellow_cards = '".$vbulletin->db->escape_string($yellow_cards)."', red_cards = '".$vbulletin->db->escape_string($red_cards)."', dateline_finished = ".TIMENOW." WHERE id=$id ");
					$finished = true;
				} 
				elseif ($agree_u2 == 0)
				{
					$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET agree_u = 1, screen_u = '".$vbulletin->db->escape_string($screen)."', squad_scores = '".$vbulletin->db->escape_string($squad_scores)."', assists = '".$vbulletin->db->escape_string($assists)."', cleansheets = '".$vbulletin->db->escape_string($cleansheets)."', yellow_cards = '".$vbulletin->db->escape_string($yellow_cards)."', red_cards = '".$vbulletin->db->escape_string($red_cards)."' WHERE id=$id ");
					$finished = false;
				}
			} 
			if (in_array($u2, $eteamids) AND !$finished)
			{
				if ($agree_u == 1) 
				{
					$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET agree_u2 = 1, finished = 1, screen_u2 = '".$vbulletin->db->escape_string($screen)."', squad_scores = '".$vbulletin->db->escape_string($squad_scores)."', assists = '".$vbulletin->db->escape_string($assists)."', cleansheets = '".$vbulletin->db->escape_string($cleansheets)."', yellow_cards = '".$vbulletin->db->escape_string($yellow_cards)."', red_cards = '".$vbulletin->db->escape_string($red_cards)."', dateline_finished = ".TIMENOW." WHERE id=$id ");
					$finished = true;
				}
				elseif ($agree_u == 0)
				{
					$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET agree_u2 = 1, screen_u2 = '".$vbulletin->db->escape_string($screen)."', squad_scores = '".$vbulletin->db->escape_string($squad_scores)."', assists = '".$vbulletin->db->escape_string($assists)."', cleansheets = '".$vbulletin->db->escape_string($cleansheets)."', yellow_cards = '".$vbulletin->db->escape_string($yellow_cards)."', red_cards = '".$vbulletin->db->escape_string($red_cards)."' WHERE id=$id ");
					$finished = false;
				}
			}
		}
		elseif ($origscore_u != $score_u OR $origscore_u2 != $score_u2)
		{
			if (in_array($u, $eteamids)) 
			{
				$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET agree_u = 1, agree_u2 = 0, score_u = $score_u, score_u2 = $score_u2, screen_u2 = '".$vbulletin->db->escape_string($screen)."', squad_scores = '".$vbulletin->db->escape_string($squad_scores)."', assists = '".$vbulletin->db->escape_string($assists)."', cleansheets = '".$vbulletin->db->escape_string($cleansheets)."', yellow_cards = '".$vbulletin->db->escape_string($yellow_cards)."', red_cards = '".$vbulletin->db->escape_string($red_cards)."' WHERE id=$id ");
				$finished = false;
			} 
			if (in_array($u2, $eteamids)) 
			{
				$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET agree_u = 0, agree_u2 = 1, score_u = $score_u, score_u2 = $score_u2, screen_u2 = '".$vbulletin->db->escape_string($screen)."', squad_scores = '".$vbulletin->db->escape_string($squad_scores)."', assists = '".$vbulletin->db->escape_string($assists)."', cleansheets = '".$vbulletin->db->escape_string($cleansheets)."', yellow_cards = '".$vbulletin->db->escape_string($yellow_cards)."', red_cards = '".$vbulletin->db->escape_string($red_cards)."' WHERE id=$id ");
				$finished = false;
			}
		}
	}
	else 
	{
		$team = false;
		if ($userid != $u AND $userid != $u2)
		{
			print_no_permission();
		}
		if ($origscore_u == $score_u AND $origscore_u2 == $score_u2) {
			if ($userid == $u)
			{
				if ($agree_u2 == 1)
				{
					$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET agree_u = 1, finished = 1, screen_u = '".$vbulletin->db->escape_string($screen)."', dateline_finished = ".TIMENOW." WHERE id=$id ");
					$finished = true;
				}
				elseif ($agree_u2 == 0)
				{
					$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET agree_u = 1, screen_u = '".$vbulletin->db->escape_string($screen)."' WHERE id=$id ");
					$finished = false;
				}
			} 
			elseif ($userid == $u2) 
			{
				if ($agree_u == 1)
				{
					$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET agree_u2 = 1, finished = 1, screen_u2 = '".$vbulletin->db->escape_string($screen)."', dateline_finished = ".TIMENOW." WHERE id=$id ");
					$finished = true;
				}
				elseif ($agree_u == 0)
				{
					$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET agree_u2 = 1, screen_u2 = '".$vbulletin->db->escape_string($screen)."' WHERE id=$id ");
					$finished = false;
				}
			}
		}
		elseif ($origscore_u != $score_u OR $origscore_u2 != $score_u2)
		{
			if ($origscore_u > 0 || $origscore_u2 > 0)
			{
				$sql = ", flag = '$userid' ";
				$flag = true;
				//dominic90
			}
			if ($userid == $u) 
			{
				$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET agree_u = 1, agree_u2 = 0, score_u = $score_u, score_u2 = $score_u2, screen_u = '".$vbulletin->db->escape_string($screen)."'$sql WHERE id=$id ");
				$finished = false;
			} 
			elseif ($userid == $u2) 
			{
				$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET agree_u = 0, agree_u2 = 1, score_u = $score_u, score_u2 = $score_u2, screen_u2 = '".$vbulletin->db->escape_string($screen)."'$sql WHERE id=$id ");
				$finished = false;
		}
		}
	}
	$comment = $vbulletin->input->clean_gpc('p', 'comment', TYPE_NOHTML);
	if ($comment)
	{
		$vbulletin->db->query_write("
			INSERT INTO " . TABLE_PREFIX . "tmnt_ladder_mcs
				(mid, comment, userid, username, dateline, dispute)
			VALUES ('".$id."', '".$vbulletin->db->escape_string($comment)."', '".$thisuserid."',  '".$vbulletin->db->escape_string($thisusername)."', ".TIMENOW.",  '0')
		");
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET comments = comments + 1 WHERE id = $id");
	}
	if (file_exists(DIR . '/tll_modules/tll_autoscoreconfirm.php') && $ladder['autoscoreconfirm'])
	{
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET agree_u = 1, agree_u2 = 1, finished = 1 WHERE id=$id ");
		$finished = true;
	}
	if ($finished)
	{
		list($newrank_u, $newrank_u2, $uod_u, $uod_u2, $player_u, $player_u2) = calc_elo($rank_u, $rank_u2, $score_u, $score_u2, $player_u, $player_u2, $lid, $u, $u2);
		if ($score_u > $score_u2)
		{
			$player_u['wstreak']++;
			if ($player_u['wstreak'] >= $player_u['longeststreak']) $player_u['longeststreak'] = $player_u['wstreak'];
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
				SET wins = wins + 1, wstreak = wstreak + 1, lstreak = 0, latime =".TIMENOW.", rank = '$newrank_u', uod = '$uod_u', totalpoints = totalpoints + $score_u, pointsagainst = pointsagainst + $score_u2, longeststreak = '$player_u[longeststreak]', xp = xp + " . $games['xp_win'] . ", crown = '".$player_u2['crown']."'
				WHERE lid = $lid AND userid = $u
			");
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
				SET loses = loses + 1, wstreak = 0, lstreak = lstreak + 1, latime =".TIMENOW.", rank = $newrank_u2, uod = $uod_u2, totalpoints = totalpoints + $score_u2, pointsagainst = pointsagainst + $score_u, xp = xp + " . $games['xp_lose'] . ", crown = 0
				WHERE lid = $lid AND userid = $u2
			");
			if (!$team && $vbulletin->options['tmnt_credit_system'] && $games['win_credits'] > 0)
			{
require_once(DIR . '/includes/functions_tll_prem.php');		
				process_credits_transaction($u, $games['win_credits'], 'Won challenge against user', $u2, $u);
				tll_auto_cashout($u);
			}
			elseif ($team && $vbulletin->options['tmnt_credit_system'] && $games['win_credits'] > 0)
			{
require_once(DIR . '/includes/functions_tll_prem.php');		
				process_credits_transaction($u, $games['win_credits'], 'Won challenge against team', $u2, $u, $u, 1);
			}
		}
		elseif ($score_u == $score_u2)
		{
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
				SET draws = draws + 1, wstreak = 0, lstreak = 0, latime =".TIMENOW.", rank = $newrank_u, uod = $uod_u, totalpoints = totalpoints + $score_u, pointsagainst = pointsagainst + $score_u2, longeststreak = '$player_u[longeststreak]', xp = xp + " . $games['xp_draw'] . "
				WHERE lid = $lid AND userid = $u
			");
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
				SET draws = draws + 1, wstreak = 0, lstreak = 0, latime =".TIMENOW.", rank = '$newrank_u2', uod = '$uod_u2', totalpoints = totalpoints + $score_u2, pointsagainst = pointsagainst + $score_u, xp = xp + " . $games['xp_draw'] . "
				WHERE lid = $lid AND userid = $u2
			");
			if (!$team && $vbulletin->options['tmnt_credit_system'] && $games['win_credits'] > 0)
			{
require_once(DIR . '/includes/functions_tll_prem.php');
				$games['win_credits'] = $games['win_credits'] / 2;
				process_credits_transaction($u, $games['win_credits'], 'Drew challenge against user', $u2, $u);
				process_credits_transaction($u2, $games['win_credits'], 'Drew challenge against user', $u, $u2);
				tll_auto_cashout($u);
				tll_auto_cashout($u2);
			}
			elseif ($team && $vbulletin->options['tmnt_credit_system'] && $games['win_credits'] > 0)
			{
require_once(DIR . '/includes/functions_tll_prem.php');
				$games['win_credits'] = $games['win_credits'] / 2;
				process_credits_transaction($u, $games['win_credits'], 'Drew challenge against team', $u2, $u, $u, 1);
				process_credits_transaction($u2, $games['win_credits'], 'Drew challenge against team', $u, $u2, $u2, 1);
			}
		} 
		elseif ($score_u < $score_u2) 
		{
			$player_u2['wstreak']++;
			if ($player_u2['wstreak'] >= $player_u2['longeststreak']) $player_u2['longeststreak'] = $player_u2['wstreak'];
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
				SET loses = loses + 1, wstreak = 0, lstreak = lstreak + 1, latime =".TIMENOW.", rank = $newrank_u, uod = $uod_u, totalpoints = totalpoints + $score_u, pointsagainst = pointsagainst + $score_u2, xp = xp + " . $games['xp_lose'] . ", crown = 0
				WHERE lid = $lid AND userid = $u
			");
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
				SET wins = wins + 1, wstreak = wstreak + 1, lstreak = 0, latime =".TIMENOW.", rank = '$newrank_u2', uod = '$uod_u2', totalpoints = totalpoints + $score_u2, pointsagainst = pointsagainst + $score_u, longeststreak = '$player_u2[longeststreak]', xp = xp + " . $games['xp_win'] . ", crown = '".$player_u['crown']."'
				WHERE lid = $lid AND userid = $u2
			");
			if (!$team && $vbulletin->options['tmnt_credit_system'] && $games['win_credits'] > 0)
			{
require_once(DIR . '/includes/functions_tll_prem.php');		
				process_credits_transaction($u2, $games['win_credits'], 'Won challenge against user', $u, $u2);
				tll_auto_cashout($u2);
			}
			elseif ($team && $vbulletin->options['tmnt_credit_system'] && $games['win_credits'] > 0)
			{
require_once(DIR . '/includes/functions_tll_prem.php');		
				process_credits_transaction($u2, $games['win_credits'], 'Won challenge against team', $u, $u2, $u2, 1);
			}
		}
		else
		{
			$errormessage = $vbphrase['error_fatal_error']." error id: 3928";
			eval(standard_error($errormessage));
		}
		$altered_rank = abs($newrank_u - $player_u['rank']);
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET altered_rank = '$altered_rank' WHERE id=$id ");
		if ($squad_scores || $assists || $cleansheets)
		{
			$squad_scores = unserialize($squad_scores);
			$assists = unserialize($assists);
			$cleansheets = unserialize($cleansheets);
			if ($squad_scores['u'])
			{
			foreach ($squad_scores['u'] AS $sa => $sb)
			{
				$p = $vbulletin->db->query_first("
					SELECT c.*
					FROM " . TABLE_PREFIX . "tmnt_cstats AS c
					WHERE userid = '".$sa."' 
						AND teamid = '".$u."'
						AND lid = '".$vbulletin->db->escape_string($lid)."'
				");
				if ($p)
				{
					$vbulletin->db->query_write("
						UPDATE " . TABLE_PREFIX . "tmnt_cstats 
						SET goals = goals + ".$vbulletin->db->escape_string($sb)."
						WHERE userid = '".$sa."' 
							AND teamid = '".$u."'
							AND lid = '".$vbulletin->db->escape_string($lid)."'
					");
				}
				else
				{
					$vbulletin->db->query_write("
						INSERT INTO " . TABLE_PREFIX . "tmnt_cstats
							(userid, teamid, goals, lid)
						VALUES (
							'".$vbulletin->db->escape_string($sa)."',
							'".$vbulletin->db->escape_string($u)."',
							'".$vbulletin->db->escape_string($sb)."',
							'".$vbulletin->db->escape_string($lid)."'
						)
					");
				}
			} }
			if ($squad_scores['u2']) {
			foreach ($squad_scores['u2'] AS $sa => $sb)
			{
				$p = $vbulletin->db->query_first("
					SELECT c.*
					FROM " . TABLE_PREFIX . "tmnt_cstats AS c
					WHERE userid = '".$sa."' 
						AND teamid = '".$u2."'
						AND lid = '".$vbulletin->db->escape_string($lid)."'
				");
				if ($p)
				{
					$vbulletin->db->query_write("
						UPDATE " . TABLE_PREFIX . "tmnt_cstats 
						SET goals = goals + ".$vbulletin->db->escape_string($sb)."
						WHERE userid = '".$sa."' 
							AND teamid = '".$u2."'
							AND lid = '".$vbulletin->db->escape_string($lid)."'
					");
				}
				else
				{
					$vbulletin->db->query_write("
						INSERT INTO " . TABLE_PREFIX . "tmnt_cstats
							(userid, teamid, goals, lid)
						VALUES (
							'".$vbulletin->db->escape_string($sa)."',
							'".$vbulletin->db->escape_string($u2)."',
							'".$vbulletin->db->escape_string($sb)."',
							'".$vbulletin->db->escape_string($lid)."'
						)
					");
				}
			} }
			if ($assists['u']) {
			foreach ($assists['u'] AS $sa => $sb)
			{
				$p = $vbulletin->db->query_first("
					SELECT c.*
					FROM " . TABLE_PREFIX . "tmnt_cstats AS c
					WHERE userid = '".$sa."' 
						AND teamid = '".$u."'
						AND lid = '".$vbulletin->db->escape_string($lid)."'
				");
				if ($p)
				{
					$vbulletin->db->query_write("
						UPDATE " . TABLE_PREFIX . "tmnt_cstats 
						SET assists = assists + ".$vbulletin->db->escape_string($sb)."
						WHERE userid = '".$sa."' 
							AND teamid = '".$u."'
							AND lid = '".$vbulletin->db->escape_string($lid)."'
					");
				}
				else
				{
					$vbulletin->db->query_write("
						INSERT INTO " . TABLE_PREFIX . "tmnt_cstats
							(userid, teamid, assists, lid)
						VALUES (
							'".$vbulletin->db->escape_string($sa)."',
							'".$vbulletin->db->escape_string($u)."',
							'".$vbulletin->db->escape_string($sb)."',
							'".$vbulletin->db->escape_string($lid)."'
						)
					");
				}
			} }
			if ($assists['u2']) {
			foreach ($assists['u2'] AS $sa => $sb)
			{
				$p = $vbulletin->db->query_first("
					SELECT c.*
					FROM " . TABLE_PREFIX . "tmnt_cstats AS c
					WHERE userid = '".$sa."' 
						AND teamid = '".$u2."'
						AND lid = '".$vbulletin->db->escape_string($lid)."'
				");
				if ($p)
				{
					$vbulletin->db->query_write("
						UPDATE " . TABLE_PREFIX . "tmnt_cstats 
						SET assists = assists + ".$vbulletin->db->escape_string($sb)."
						WHERE userid = '".$sa."' 
							AND teamid = '".$u2."'
							AND lid = '".$vbulletin->db->escape_string($lid)."'
					");
				}
				else
				{
					$vbulletin->db->query_write("
						INSERT INTO " . TABLE_PREFIX . "tmnt_cstats
							(userid, teamid, assists, lid)
						VALUES (
							'".$vbulletin->db->escape_string($sa)."',
							'".$vbulletin->db->escape_string($u2)."',
							'".$vbulletin->db->escape_string($sb)."',
							'".$vbulletin->db->escape_string($lid)."'
						)
					");
				}
			} }
			if ($cleansheets['u']) {
			foreach ($cleansheets['u'] AS $sa => $sb)
			{
				$p = $vbulletin->db->query_first("
					SELECT c.*
					FROM " . TABLE_PREFIX . "tmnt_cstats AS c
					WHERE userid = '".$sb."' 
						AND teamid = '".$u."'
						AND lid = '".$vbulletin->db->escape_string($lid)."'
				");
				if ($p)
				{
					$vbulletin->db->query_write("
						UPDATE " . TABLE_PREFIX . "tmnt_cstats 
						SET cleansheets = cleansheets + 1
						WHERE userid = '".$sb."' 
							AND teamid = '".$u."'
							AND lid = '".$vbulletin->db->escape_string($lid)."'
					");
				}
				else
				{
					$vbulletin->db->query_write("
						INSERT INTO " . TABLE_PREFIX . "tmnt_cstats
							(userid, teamid, cleansheets, lid)
						VALUES (
							'".$vbulletin->db->escape_string($sb)."',
							'".$vbulletin->db->escape_string($u)."',
							'1',
							'".$vbulletin->db->escape_string($lid)."'
						)
					");
				}
			} }
			if ($cleansheets['u2']) {
			foreach ($cleansheets['u2'] AS $sa => $sb)
			{
				$p = $vbulletin->db->query_first("
					SELECT c.*
					FROM " . TABLE_PREFIX . "tmnt_cstats AS c
					WHERE userid = '".$sb."' 
						AND teamid = '".$u2."'
						AND lid = '".$vbulletin->db->escape_string($lid)."'
				");
				if ($p)
				{
					$vbulletin->db->query_write("
						UPDATE " . TABLE_PREFIX . "tmnt_cstats 
						SET cleansheets = cleansheets + 1
						WHERE userid = '".$sb."' 
							AND teamid = '".$u2."'
							AND lid = '".$vbulletin->db->escape_string($lid)."'
					");
				}
				else
				{
					$vbulletin->db->query_write("
						INSERT INTO " . TABLE_PREFIX . "tmnt_cstats
							(userid, teamid, cleansheets, lid)
						VALUES (
							'".$vbulletin->db->escape_string($sb)."',
							'".$vbulletin->db->escape_string($u2)."',
							'1',
							'".$vbulletin->db->escape_string($lid)."'
						)
					");
				}
			} }
		}
	}
	if (!$team)
	{
		if ($u==$thisuserid)
		{
			$opp_userid = $u2;
			$opp = fetch_userinfo($opp_userid);
		}
		elseif ($u2==$thisuserid)
		{
			$opp_userid = $u;
			$opp = fetch_userinfo($opp_userid);
		}
	}
	else
	{
		$teamtext = "".$vbphrase['tmnt_team']." ";
		if (in_array($u, $eteamids))
		{//is u
			$t = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_members WHERE leader='1' AND teamid = '$u2' AND userid != '$thisuserid'");
			$opp_userid = $t['userid'];
			$opp = fetch_userinfo($opp_userid);
		}
		elseif (in_array($u2, $eteamids))
		{//is u2
			$t = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_members WHERE leader='1' AND teamid = '$u' AND userid != '$thisuserid'");
			$opp_userid = $t['userid'];
			$opp = fetch_userinfo($opp_userid);
		}
	}
	if ($opp)
	{
		/* adding notification for u2 */
		$u2info = $opp;
		if (!is_array($u2info['tmnt_notifications']) && $u2info['tmnt_notifications'])
		{
			$u2info['tmnt_notifications'] = unserialize($u2info['tmnt_notifications']);
		}
		else if (!$u2info['tmnt_notifications'])
		{
			$u2info['tmnt_notifications'] = array();
		}
		if (!$finished)
		{
		$u2info['tmnt_notifications']['ladder_newscore']++;
		$u2info['tmnt_notifications']['ladder_newscoreid'] = $id;
		}
		else
		{
		$u2info['tmnt_notifications']['ladder_finishedmat']++;
		$u2info['tmnt_notifications']['ladder_finmid'] = $id;
		}
		$u2info['tmnt_notifications'] = serialize($u2info['tmnt_notifications']);
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET tmnt_notifications = '".$vbulletin->db->escape_string($u2info['tmnt_notifications'])."' WHERE userid = '".$u2info['userid']."'");
		/* end */
	}
	if ($opp && $vbulletin->options['tmnt_ladder_pm_result'])
	{
		if (!$finished)
		{
			$title = $teamtext.$vbphrase['ladder_match_score_submitted'];
			$recipients = $opp['username'];
			$message = construct_phrase($vbphrase['ladder_match_score_submitted_pmtext'], $thisusername, $vbulletin->options['bburl'], $id, $teamtext);
		}
		else
		{
			$title = $teamtext.$vbphrase['ladder_match_score_confirmed'];
			$recipients = $opp['username'];
			$message = construct_phrase($vbphrase['ladder_match_score_confirmed_pmtext'], $thisusername, $vbulletin->options['bburl'], $id, $teamtext);
		}
		$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_ARRAY);
		$pmdm->set('fromuserid', $thisuserid);
		$pmdm->set('fromusername', $thisusername);
		$pmdm->set('title', $title);
		$pmdm->set('message', $message);
		$pmdm->set_recipients($recipients, $botpermissions);
		$pmdm->set('dateline', TIMENOW); 
		$pmdm->overridequota = true;
		$errors = $pmdm->errors;
		/*if ($errors) {
			foreach ($errors as $error) {
				$errorss .= $error. "<br />";
			}
			$errormessage = $errorss;
			eval(standard_error($errormessage));
		}*/
		if (!$errors) 
		{
			$pmdm->save();
		}
		unset($pmdm);
	}
	if ($flag && $tmntp['canusetickets'])
	{
		$vbulletin->url = "tll_tickets.php?do=new&challengeid=".$games['id']."&ladderid=".$games['lid'];
	}
	elseif ($vbulletin->GPC['from']=='ladder')
	{
		$ladder = fetch_ladderinfo($lid);
		$vbulletin->url = $ladder['url']."&sh=".$vbulletin->GPC['sh']."&mid=$id#match$id";
	}
	else
	{
		$vbulletin->url = "ladders.php?do=challenges&mid=$id#".($finished? "l$lid" : "match$id");
	}
	eval(print_standard_redirect('redirect_updatedscore'));
}

// #############################################################################

if ($_POST['do'] == 'insertchal')
{
	if (!$tmntp['canjoinladder'])
	{
		print_no_permission();
	}
	$lid = $vbulletin->input->clean_gpc('p', 'lid', TYPE_UINT);
	if (!$lid)
	{
		$errormessage = $vbphrase[error_invalid_ladder];
		eval(standard_error($errormessage));
	}	
	$u2 = $vbulletin->input->clean_gpc('p', 'u2', TYPE_UINT);
	$mf = 0;
	if (!$u2)
	{
		$mf = 1;
	}
	$page = $vbulletin->input->clean_gpc('p', 'page', TYPE_UINT);
	$bestof = $vbulletin->input->clean_gpc('p', 'bestof', TYPE_UINT);
	$map = $vbulletin->input->clean_gpc('p', 'map', TYPE_NOHTML);
	$u1message = $vbulletin->input->clean_gpc('p', 'u1message', TYPE_NOHTML);
	$u2message = $vbulletin->input->clean_gpc('p', 'u2message', TYPE_NOHTML);
	$userid = $thisuserid;
	$u = $vbulletin->input->clean_gpc('p', 'u', TYPE_UINT);
	$squadsize = $vbulletin->input->clean_gpc('p', 'squadsize', TYPE_UINT);
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id=$lid ");
	if (!$ladder)
	{
		print_no_permission();
	}
	if ($ladder['status'] > 0)
	{
		print_no_permission();
	}
	$co_array = unserialize($ladder['chal_options']);
	$chal_options = array();
	if (is_array($co_array))
	{
		foreach ($co_array AS $key => $value)
		{
			$key = str_replace(' ','_',$key);
			$key = preg_replace("/[^a-zA-Z0-9_\s]/", "", unhtmlspecialchars($key));
			$chal_options["$key"] = $vbulletin->input->clean_gpc('p', "$key", TYPE_NOHTML);
		}
		$chal_options = serialize($chal_options);
	}
	if ($ladder['archive'] == '1')
	{
		$errormessage = $vbphrase[error_ladder_closed];
		eval(standard_error($errormessage));
	}
	if ($u == $u2)
	{
		$errormessage = $vbphrase[error_invalid_challenged];
		eval(standard_error($errormessage));
	}
	$time_limit = TIMENOW - ($vbulletin->options['tmnt_ladder_limitrematch'] * 60 * 60);
	$countlimit = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE lid=$lid AND ((u=$u AND u2=$u2) OR (u=$u2 AND u2=$u)) AND dateline_finished > '" . $time_limit . "' ");
	if ($countlimit['countrows'])
	{
		$errormessage = "Please wait 24 hours between challenging the same player/team.";
		eval(standard_error($errormessage));
	}
	/* challenge time/date */
	$vbulletin->input->clean_array_gpc('p', array(
		'timezoneoffset' => TYPE_ARRAY_NUM,
		'dst'            => TYPE_ARRAY_UINT,
		'date'       => TYPE_ARRAY_ARRAY,
		'time'       => TYPE_ARRAY_NOHTML
	));
	$type = 'range';
	$time = $vbulletin->GPC['time']["$type"];
	$date = $vbulletin->input->clean($vbulletin->GPC['date']["$type"], TYPE_ARRAY_UINT);
	$utc = $timezoneoffset = $vbulletin->GPC['timezoneoffset']["$type"];
	$dst = $vbulletin->GPC['dst']["$type"] = 1;
	require_once(DIR . '/includes/functions_misc.php');
	if (!fetch_timezone($timezoneoffset))
	{
		$errormessage = "Error: invalid timezone specified";
		eval(standard_error($errormessage));
	}
	if (!checkdate($date['month'], $date['day'], $date['year']))
	{
		$errormessage = "Error: Bad Date";
		eval(standard_error($errormessage));
	}
	$time_re = '#^(0?[1-9]|1[012])\s*[:.]\s*([0-5]\d)(\s*[AP]M)?|([01]\d|2[0-3])\s*[:.]\s*([0-5]\d)$#i';

	// match text in field for a valid time
	if (preg_match($time_re, $time, $matches))
	{
		if (count($matches) == 3)
		{
			$hour = intval($matches[1]);
			$minute = intval($matches[2]);
			$ampm = $matches[1] == '12' ? 'PM' : 'AM';
		}
		else if (count($matches) == 4)
		{
			$hour = intval($matches[1]);
			$minute = intval($matches[2]);
			$ampm = strtoupper(trim($matches[3]));
		}
		else // 24hr time
		{
			$hour = intval($matches[4]);
			$minute = intval($matches[5]);
			$ampm = ($hour <= 11) ? 'AM' : 'PM';
		}
	}
	if (($pos = strpos($vbulletin->options['timeformat'], 'H')) === false)
	{
		if ($ampm == 'PM')
		{
			if ($hour >= 1 AND $hour <= 11)
			{
				$hour += 12;
			}
		}
		else
		{
			if ($hour == 12)
			{
				$hour = 0;
			}
		}
	}
	$min_offset = $utc - intval($utc);
	$hour   -= intval($utc);
	$minute -= intval($min_offset * 60);
	$dateline = gmmktime($hour, $minute, 0, $date['month'], $date['day'], $date['year']);
	if ($_POST['now'])
	{
		$dateline = TIMENOW + 1800;
	}
	/* end challenge time/date */
	if ($ladder['pot'] != '1')
	{
		// start singles
		if ($u != $vbulletin->userinfo['userid'])
		{
			$errormessage = "Unexpected Error: Error in template 'tmnt_ladder_chal'";
			eval(standard_error($errormessage));
		}
		$countplayer = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE lid=$lid AND ((u=$u AND u2=$u2) OR (u=$u2 AND u2=$u)) AND finished=0 ");
		$countplayer = $countplayer['countrows'];  
		if ($countplayer >= $vbulletin->options['tmnt_ladder_maxc'] && $u2 > 0)
		{
			$errormessage = $vbphrase['error_already_challenged'];
			eval(standard_error($errormessage));
		}
		$countplayer = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid=$lid AND userid=$u2 AND active=1");
		$countplayer = $countplayer['countrows'];  
		if ($countplayer != 1 && $u2 > 0)
		{
			$errormessage = $vbphrase['error_player_not_ladder'];
			eval(standard_error($errormessage));
		}
		$countplayer = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid=$lid AND userid=$u AND active=1");
		$countplayer = $countplayer['countrows'];  
		if ($countplayer != 1)
		{
			$errormessage = construct_phrase($vbphrase['error_not_in_ladder'],$lid);
			eval(standard_error($errormessage));
		}
		$username_u = $thisusername;
		$u2info = fetch_userinfo($u2);
		$username_u2 = $u2info['username'];
		if (($ladder['chal_cost'] > 0 OR $ladder['chal_cost_xtra']) && $vbulletin->options['tmnt_credit_system'])
		{
require_once(DIR . '/includes/functions_tll_prem.php');
			if ($ladder['chal_cost'] > 0 OR $ladder['chal_cost_xtra'])
			{
				$chal_cost = $ladder['chal_cost'];
				if ($ladder['chal_cost_xtra'])
				{
					$chal_cost = $vbulletin->input->clean_gpc('p', 'chal_cost', TYPE_UNUM);
					if ($chal_cost < $ladder['chal_cost'])
					{
						$chal_cost = $ladder['chal_cost'];
					}
				}
				$ladder['win_credits'] = (1-$vbulletin->options['tmnt_credits_comm'])*2*$chal_cost;
			}
			if (!tll_check_credits($vbulletin->userinfo, $chal_cost))
			{
				$errormessage = 'Error, insufficient credits. Once accepted a challenge will cost you '.$chal_cost.' credits, you only have '.$vbulletin->userinfo['tmnt_credits'].' credits.';
				eval(standard_error($errormessage));
			}
		}
		$vbulletin->db->query_write("
			INSERT INTO " . TABLE_PREFIX . "tmnt_ladder_games
				(u, u2, lid, time, pot, bestof, matchdate, map, u1message, u2message, chal_options, dateline, mf, chal_cost, win_credits, squadsize)
			VALUES (
				'".$vbulletin->db->escape_string($u)."',
				'".$vbulletin->db->escape_string($u2)."',
				'".$vbulletin->db->escape_string($lid)."',
				'".TIMENOW."',
				'0',
				'".$vbulletin->db->escape_string($bestof)."',
				'".$vbulletin->db->escape_string($matchdate)."',
				'".$vbulletin->db->escape_string($map)."',
				'".$vbulletin->db->escape_string($u1message)."',
				'".$vbulletin->db->escape_string($u2message)."',
				'".$vbulletin->db->escape_string($chal_options)."',
				'".$vbulletin->db->escape_string($dateline)."',
				'".$vbulletin->db->escape_string($mf)."',
				'".$vbulletin->db->escape_string($chal_cost)."',
				'".$vbulletin->db->escape_string($ladder['win_credits'])."',
				'0'
			)
		");
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_players SET challenges = challenges + 1 WHERE lid=$lid AND userid=$u");
		/* adding notification for u2 */
		if (!is_array($u2info['tmnt_notifications']) && $u2info['tmnt_notifications'])
		{
			$u2info['tmnt_notifications'] = unserialize($u2info['tmnt_notifications']);
		}
		else if (!$u2info['tmnt_notifications'])
		{
			$u2info['tmnt_notifications'] = array();
		}
		$u2info['tmnt_notifications']['ladder_chals']++;
		$u2info['tmnt_notifications'] = serialize($u2info['tmnt_notifications']);
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET tmnt_notifications = '".$vbulletin->db->escape_string($u2info['tmnt_notifications'])."' WHERE userid = '".$u2info['userid']."'");
		/* end */
		if ($vbulletin->options['tmnt_ladder_pm_chal'])
		{
			require_once('./includes/functions_databuild.php');
			$fromuserid = $thisuserid;
			$fromusername = $thisusername;
			$title = construct_phrase($vbphrase['ladder_x_challenged_you'], $thisusername);
			$recipients = $username_u2;
			$templater = vB_Template::create('tmnt_ladder_chalpm');
			$templater->register('tmntp', $tmntp);
			$templater->register('ladder', $ladder);
			$templater->register('id', $id);
			$templater->register('lid', $lid);
			$templater->register('title', $title);
			$templater->register('fromusername', $fromusername);
			$templater->register('fromuserid', $fromuserid);
			$message = $templater->render();
			$message = preg_replace('/<!--(.|\s)*?-->/', '', $message);
			$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_ARRAY);
			$pmdm->set('fromuserid', $fromuserid);
			$pmdm->set('fromusername', $fromusername);
			$pmdm->set('title', $title);
			$pmdm->set('message', $message);
			$pmdm->set_recipients($recipients, $botpermissions);
			$pmdm->set('dateline', TIMENOW); 
			$pmdm->overridequota = true;
			$errors = $pmdm->errors;
			if ($errors) {
				foreach ($errors as $error) {
					$errorss .= $error. "<br />";
				}
				$errormessage = $vbphrase[error_success_chal_error_pm].$errorss;
				eval(standard_error($errormessage));
			}
			$pmdm->save();
			unset($pmdm);
		}
		// end singles
	}
	else
	{
		// start team
		$countteam = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE lid=$lid AND ((u=$u AND u2=$u2) OR (u=$u2 AND u2=$u)) AND finished = '0' " . ($u2 == 0 ? " AND dateline > ".TIMENOW." " : "") . " ");
		if ($countteam['countrows'] > $vbulletin->options['tmnt_ladder_maxc'])
		{
			$errormessage = $vbphrase['error_already_challenged'];
			eval(standard_error($errormessage));
		}
		$countteam = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid=$lid AND userid=$u2 ");
		if ($countteam['countrows'] != 1 && $u2 > 0)
		{
			$errormessage = $vbphrase['error_invalid_challenged'];
			eval(standard_error($errormessage));
		}
		$countteam = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid=$lid AND userid=$u ");
		if ($countteam['countrows'] != 1 && $u2 > 0)
		{
			$errormessage = $vbphrase[error_you_not_ladder];
			eval(standard_error($errormessage));
		}
		$team = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_teams WHERE teamid=$u ");
		if ($ladder['chal_cost'] > 0 && $vbulletin->options['tmnt_credit_system'] && $team['tmnt_credits'] < $ladder['chal_cost'])
		{
			$errormessage = 'Error, insufficient credits. Once accepted a challenge will cost your team '.$match['chal_cost'].'credits, you only have '.$team['tmnt_credits'].' credits.';
			eval(standard_error($errormessage));
		}
		if ($ladder['chal_cost'] > 0 OR $ladder['chal_cost_xtra'])
		{
			$chal_cost = $ladder['chal_cost'];
			if ($ladder['chal_cost_xtra'])
			{
				$chal_cost = $vbulletin->input->clean_gpc('p', 'chal_cost', TYPE_UNUM);
				if ($chal_cost < $ladder['chal_cost'])
				{
					$chal_cost = $ladder['chal_cost'];
				}
			}
			$ladder['win_credits'] = (1-$vbulletin->options['tmnt_credits_comm'])*2*$chal_cost;
		}
		$vbulletin->db->query_write("
			INSERT INTO " . TABLE_PREFIX . "tmnt_ladder_games
				(u, u2, lid, time, pot, bestof, matchdate, map, u1message, u2message, chal_options, dateline, mf, chal_cost, win_credits, squadsize)
			VALUES (
				'".$vbulletin->db->escape_string($u)."',
				'".$vbulletin->db->escape_string($u2)."',
				'".$vbulletin->db->escape_string($lid)."',
				'".TIMENOW."',
				'1',
				'".$vbulletin->db->escape_string($bestof)."',
				'".$vbulletin->db->escape_string($matchdate)."',
				'".$vbulletin->db->escape_string($map)."',
				'".$vbulletin->db->escape_string($u1message)."',
				'".$vbulletin->db->escape_string($u2message)."',
				'".$vbulletin->db->escape_string($chal_options)."',
				'".$vbulletin->db->escape_string($dateline)."',
				'".$vbulletin->db->escape_string($mf)."',
				'".$vbulletin->db->escape_string($chal_cost)."',
				'".$vbulletin->db->escape_string($ladder['win_credits'])."',
				'".$vbulletin->db->escape_string($squadsize)."'
			)
		");
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_players SET challenges = challenges + 1 WHERE lid='$lid' AND userid='$u' ");
		/* adding notification for u2 */
		$u2_leader = $vbulletin->db->query_first("SELECT userid FROM " . TABLE_PREFIX . "tmnt_members WHERE teamid = '$u2' AND leader = 1");
		$u2info = fetch_userinfo($u2_leader['userid']);
		if (!is_array($u2info['tmnt_notifications']) && $u2info['tmnt_notifications'])
		{
			$u2info['tmnt_notifications'] = unserialize($u2info['tmnt_notifications']);
		}
		else if (!$u2info['tmnt_notifications'])
		{
			$u2info['tmnt_notifications'] = array();
		}
		$u2info['tmnt_notifications']['ladder_chals']++;
		$u2info['tmnt_notifications'] = serialize($u2info['tmnt_notifications']);
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET tmnt_notifications = '".$vbulletin->db->escape_string($u2info['tmnt_notifications'])."' WHERE userid = '".$u2info['userid']."'");
		/* end */
		if ($vbulletin->options['tmnt_ladder_pm_chal'])
		{
		require_once('./includes/functions_databuild.php');
		$fromuserid = $thisuserid;
		$fromusername = $thisusername;
		$title = construct_phrase($vbphrase['ladder_x_challenged_your_team'], $thisusername); 
		$recipients = $u2info['username'];
		$templater = vB_Template::create('tmnt_ladder_chalpm');
		$templater->register('tmntp', $tmntp);
		$templater->register('ladder', $ladder);
		$templater->register('id', $id);
		$templater->register('lid', $lid);
		$templater->register('title', $title);
		$templater->register('fromusername', $fromusername);
		$templater->register('fromuserid', $fromuserid);
		$message = $templater->render();
		$message = preg_replace('/<!--(.|\s)*?-->/', '', $message);
			$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_ARRAY);
			$pmdm->set('fromuserid', $fromuserid);
			$pmdm->set('fromusername', $fromusername);
			$pmdm->set('title', $title);
			$pmdm->set('message', $message);
			$pmdm->set_recipients($recipients, $botpermissions);
			$pmdm->set('dateline', TIMENOW); 
			$pmdm->overridequota = true;
			$errors = $pmdm->errors;
			if ($errors) {
				foreach ($errors as $error) {
					$errorss .= $error. "<br />";
				}
				$errormessage = $vbphrase[error_success_chal_error_pm].$errorss;
				eval(standard_error($errormessage));
			}
			$pmdm->save();
			unset($pmdm);
		}
		// end team
	}
	if ($mf)
	{
		$vbulletin->url = "ladders.php?do=view&id=".$lid."&sh=5";
	}
	else
	{
		$ladder['url'] = tll_seo('ladder', $ladder['id'], $ladder['title'], 1);
		$vbulletin->url = $ladder['url']."&page=$page";
	}
	eval(print_standard_redirect('redirect_insertchalladder'));
}

// #############################################################################

if ($_POST['do'] == 'rearrange_match')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'timezoneoffset' => TYPE_ARRAY_NUM,
		'dst'            => TYPE_ARRAY_UINT,
		'mid'            => TYPE_UINT,
		'd1date'         => TYPE_ARRAY_ARRAY,
		'd1time'       => TYPE_ARRAY_NOHTML,
		'd2date'         => TYPE_ARRAY_ARRAY,
		'd2time'       => TYPE_ARRAY_NOHTML,
		'd3date'         => TYPE_ARRAY_ARRAY,
		'd3time'       => TYPE_ARRAY_NOHTML
	));
	$type = 'range';
	$timezoneoffset = $vbulletin->userinfo['timezoneoffset'];
	$d1time = $vbulletin->GPC['d1time']["$type"];
	$d1date = $vbulletin->input->clean($vbulletin->GPC['d1date']["$type"], TYPE_ARRAY_UINT);
	$d2time = $vbulletin->GPC['d2time']["$type"];
	$d2date = $vbulletin->input->clean($vbulletin->GPC['d2date']["$type"], TYPE_ARRAY_UINT);
	$d3time = $vbulletin->GPC['d3time']["$type"];
	$d3date = $vbulletin->input->clean($vbulletin->GPC['d3date']["$type"], TYPE_ARRAY_UINT);
	$utc = $timezoneoffset = $vbulletin->GPC['timezoneoffset']["$type"];
	$dst = $vbulletin->GPC['dst']["$type"];
	$mid = $vbulletin->GPC['mid'];
	require_once(DIR . '/includes/functions_misc.php');
	if (!fetch_timezone($timezoneoffset))
	{
		$errormessage = 'Error: invalid timezone specified';
		eval(standard_error($errormessage));
	}
	//print_r($d1time.$d2time.$d3time);
	$dateline1 = tmnt_fields_to_dateline($d1time, $d1date, $utc, $dst, $type);
	//print_r($dateline1);
	$dateline2 = tmnt_fields_to_dateline($d2time, $d2date, $utc, $dst, $type);
	$dateline3 = tmnt_fields_to_dateline($d3time, $d3date, $utc, $dst, $type);
	//exit;
	$game = $vbulletin->db->query_first("
		SELECT games.*, games.u AS uid, games.u2 AS u2id, ladders.title AS ltitle, user.username AS u, user2.username AS u2
		FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
		LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders
			ON (games.lid = ladders.id)
		LEFT JOIN " . TABLE_PREFIX . "user AS user
			ON (games.u = user.userid)
		LEFT JOIN " . TABLE_PREFIX . "user AS user2
			ON (games.u2 = user2.userid)
		WHERE games.finished = 0
			AND games.accepted != -1
			AND games.id = '$mid'
	");
	if (!$game)
	{
		print_no_permission();
	}
	if ($game['uid'] == $vbulletin->userinfo['userid'])
	{
		$is = 'u';
		$ois = 'u2';
	}
	elseif ($game['u2id'] == $vbulletin->userinfo['userid'])
	{
		$is = 'u2';
		$ois = 'u';
	}
	else
	{
		print_no_permission();
	}
	if ($game['ram'])
	{
		$game['ram'] = unserialize($game['ram']);
	}
	if (is_array($game['ram']))
	{
		$ram = serialize(array(
			"$ois" => $game['ram']["$ois"],
			"$is" => array('userid' => $vbulletin->userinfo['userid'], 'dateline' => TIMENOW, 'dateline1' => $dateline1, 'dateline2' => $dateline2, 'dateline3' => $dateline3)
		));
	}
	else
	{
		$ram = serialize(array(
			"$ois" => array(),
			"$is" => array('userid' => $vbulletin->userinfo['userid'], 'dateline' => TIMENOW, 'dateline1' => $dateline1, 'dateline2' => $dateline2, 'dateline3' => $dateline3)
		));
	}
	if (!$game['pot'])
	{
		require_once('./includes/functions_databuild.php');
		$fromuserid = $vbulletin->userinfo['userid'];
		$fromusername = $vbulletin->userinfo['username'];
		$recipients = $game["$ois"];
		$title = 'Rescheduled match';
		$message = construct_phrase($vbphrase['ladder_pm_resched'], $fromusername, $vbulletin->options['bburl'], $mid);
		$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_ARRAY);
			$pmdm->set('fromuserid', $fromuserid);
			$pmdm->set('fromusername', $fromusername);
			$pmdm->set('title', $title);
			$pmdm->set('message', $message);
			$pmdm->set_recipients($recipients, $botpermissions);
			$pmdm->set('dateline', TIMENOW); 
			$pmdm->overridequota = true;
			$errors = $pmdm->errors;
			if ($errors) {
				foreach ($errors as $error) {
					$errorss .= $error. "<br />";
				}
				$errormessage = $errorss;
				eval(standard_error($errormessage));
			}
			$pmdm->save();
			unset($pmdm);
		
		
		$u2info = fetch_userinfo($game[$ois."id"]);
		if (!is_array($u2info['tmnt_notifications']) && $u2info['tmnt_notifications'])
		{
			$u2info['tmnt_notifications'] = unserialize($u2info['tmnt_notifications']);
		}
		else if (!$u2info['tmnt_notifications'])
		{
			$u2info['tmnt_notifications'] = array();
		}
		$u2info['tmnt_notifications']['l_rearrange']++;
		$u2info['tmnt_notifications']['l_rearr_id'] = $mid;
		$u2info['tmnt_notifications'] = serialize($u2info['tmnt_notifications']);
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET tmnt_notifications = '".$vbulletin->db->escape_string($u2info['tmnt_notifications'])."' WHERE userid = '".$u2info['userid']."'");
	}
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "tmnt_ladder_games
		SET ram = '".$vbulletin->db->escape_string($ram)."'
		WHERE id = '".$vbulletin->GPC['mid']."'
	");
	$vbulletin->url = "ladder_match.php?do=rearrange_match&amp;mid=".$mid;
	eval(print_standard_redirect('redirect_updatechal'));
}


// #############################################################################

if ($_REQUEST['do'] == 'acceptmf')
{
	if (!$tmntp['canjoinladder'])
	{
		print_no_permission();
	}
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	if (!$id)
	{
		$errormessage = $vbphrase['error_invalid_challenge'];
		eval(standard_error($errormessage));
	}
	$u2 = $thisuserid;
	//query match info
	$match = $vbulletin->db->query_first("
		SELECT g.*
		FROM " . TABLE_PREFIX . "tmnt_ladder_games AS g
		WHERE g.id = $id AND g.u2 = 0 AND g.accepted = 0 AND g.finished = 0
	");
	if (!$match)
	{
		$errormessage = $vbphrase['error_invalid_match'];
		eval(standard_error($errormessage));
	}
	$lid = $match['lid'];
	$u = $match['u'];
	if ($match['pot'])
	{
		$u2 = $vbulletin->input->clean_gpc('g', 'u2', TYPE_UINT);
		//check thisuserid is leader of u2
		$countplayer = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_members WHERE (teamid = '$u2' AND leader = '1' AND userid = '$thisuserid') ");
		if ($countplayer['countrows'] != 1)
		{
			$errormessage = $vbphrase['error_not_leader'];
			eval(standard_error($errormessage));
		}
		$sh = 2;
	}
	else
	{
		$sh = 3;
	}
	if ($match['u'] == $u2)
	{
		$errormessage = "You cannot accept your own games in the match finder.";
		eval(standard_error($errormessage));
	}
	if ($match['dateline'] < TIMENOW)
	{
		$errormessage = $vbphrase['error_match_inpast'];
		eval(standard_error($errormessage));
	}
	//check accepting player in ladder
	$countplayer = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid = ".$lid." AND userid = $u2 AND active = 1");
	$countplayer = $countplayer['countrows'];  
	if ($countplayer != 1)
	{
		$errormessage = $vbphrase['error_player_not_ladder'];
		eval(standard_error($errormessage));
	}
	$countplayer = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE lid=$lid AND ((u=$u AND u2=$u2) OR (u=$u2 AND u2=$u)) AND finished=0 ");
		$countplayer = $countplayer['countrows'];  
		if ($countplayer >= $vbulletin->options['tmnt_ladder_maxc'] && $u2 > 0)
		{
			$errormessage = $vbphrase['error_already_challenged'];
			eval(standard_error($errormessage));
		}
	$time_limit = TIMENOW - ($vbulletin->options['tmnt_ladder_limitrematch'] * 60 * 60);
	$countlimit = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE lid=$lid AND ((u=$u AND u2=$u2) OR (u=$u2 AND u2=$u)) AND dateline_finished > '" . $time_limit . "' ");
	if ($countlimit['countrows'])
	{
		$days = floor($vbulletin->options['tmnt_ladder_limitrematch']/24);
		$hours = $vbulletin->options['tmnt_ladder_limitrematch'] - $days * 24;
		$errormessage = "Please wait " . ($days ? "$days days " : "") . ($hours ? "$hours hours " : "") . "between challenging the same player/team.";
		eval(standard_error($errormessage));
	}
	$u = $match['u'];
	if (!$match['pot'] && $match['chal_cost'] > 0 && $vbulletin->options['tmnt_credit_system'])
	{
		if ($match['win_credits'])
		{
			$credits_profit = 2 * $match['chal_cost'] - $match['win_credits'];
		}
		if ($vbulletin->userinfo['tmnt_credits'] < $match['chal_cost'])
		{
			$errormessage = 'Error, insufficient credits. Accepting a challenge costs '.$match['chal_cost'].' credits, you only have '.$vbulletin->userinfo['tmnt_credits'].' credits.';
			eval(standard_error($errormessage));
		}
require_once(DIR . '/includes/functions_tll_prem.php');		
		process_credits_transaction($match['u'], -$match['chal_cost'], 'Challenged another user', $match['u'], $match['u2']);
		process_credits_transaction($match['u2'], -$match['chal_cost'], 'Challenged another user', $match['u2'], $match['u']);
		update_forum_creditprofit(vbdate('W',TIMENOW), vbdate('Y',TIMENOW), $credits_profit, TIMENOW);
	}
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "tmnt_ladder_games
		SET accepted = '1', u2 = '$u2', accepted_dateline = '".TIMENOW."'
		WHERE id='$id' AND accepted = '0' AND finished = '0' AND pot = '".$match['pot']."'
	");
	if ($u && !$match['pot'])
	{
		$uinfo = fetch_userinfo($u);
		if ($uinfo)
		{
			if (!is_array($uinfo['tmnt_notifications']) && $uinfo['tmnt_notifications'])
			{
				$uinfo['tmnt_notifications'] = unserialize($uinfo['tmnt_notifications']);
			}
			else if (!$uinfo['tmnt_notifications'])
			{
				$uinfo['tmnt_notifications'] = array();
			}
			$uinfo['tmnt_notifications']['ladder_accepts']++;
			$uinfo['tmnt_notifications'] = serialize($uinfo['tmnt_notifications']);
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET tmnt_notifications = '".$vbulletin->db->escape_string($uinfo['tmnt_notifications'])."' WHERE userid = '".$uinfo['userid']."'");
			require_once('./includes/functions_databuild.php');
			$fromuserid = $thisuserid;
			$fromusername = $thisusername;
			$title = $vbphrase['ladder_someone_accepted_mf'];
			$recipients = $uinfo['username'];
			$templater = vB_Template::create('tmnt_ladder_mfpm');
			$templater->register('tmntp', $tmntp);
			$templater->register('match', $match);
			$templater->register('title', $title);
			$templater->register('fromusername', $fromusername);
			$templater->register('fromuserid', $fromuserid);
			$message = $templater->render();
			$message = preg_replace('/<!--(.|\s)*?-->/', '', $message);
				$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_ARRAY);
				$pmdm->set('fromuserid', $fromuserid);
				$pmdm->set('fromusername', $fromusername);
				$pmdm->set('title', $title);
				$pmdm->set('message', $message);
				$pmdm->set_recipients($recipients, $botpermissions);
				$pmdm->set('dateline', TIMENOW); 
				$pmdm->overridequota = true;
				$errors = $pmdm->errors;
				if ($errors)
				{
					foreach ($errors as $error) {
						$errorss .= $error. "<br />";
					}
					$errormessage = $vbphrase[error_success_chal_error_pm].$errorss;
					eval(standard_error($errormessage));
				}
				$pmdm->save();
				unset($pmdm);
		}
	}
	$vbulletin->url = "ladders.php?do=view&id=".$lid."&sh=$sh#match".$match['id'];
	eval(print_standard_redirect('redirect_acceptchal'));
}

// #############################################################################

if ($_REQUEST['do'] == 'accept')
{
	if (!$tmntp['canjoinladder'])
	{
		print_no_permission();
	}
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
		if (!$id) {
			$errormessage = $vbphrase[error_invalid_challenge];
			eval(standard_error($errormessage));
		}
	$u2 = $thisuserid;
	$match = $vbulletin->db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_ladder_games
		WHERE id='$id' AND u2='$u2' AND accepted = '0' AND finished = '0' AND pot = '0'
	");
	if (!$match)
	{
		print_no_permission();
	}
	if (!$match['pot'] && $match['chal_cost'] > 0 && $vbulletin->options['tmnt_credit_system'])
	{
		if ($match['win_credits'])
		{
			$credits_profit = 2 * $match['chal_cost'] - $match['win_credits'];
		}
		$vbc = $vbulletin->options['tmnt_vbcredits_conv'] * $match['chal_cost'];
		$vbb = 'vbcredits_'.$vbulletin->options['tmnt_vbcredits_curr'];
		//print_r($vbulletin->userinfo["$vbb"]);
		//print_r("_".($vbulletin->options['tmnt_vbcredits_conv'] * $vbc));
	//pr($vbulletin->options['tmnt_credits_vbcredits'] && ($u["$vbb"] >= $vbc))
	//	exit;
require_once(DIR . '/includes/functions_tll_prem.php');	
		if (!tll_check_credits($vbulletin->userinfo, $match['chal_cost'], 1))
		{
			$errormessage = 'Error, insufficient credits. Accepting a challenge costs '.$match['chal_cost'].' credits, you only have '.$vbulletin->userinfo['tmnt_credits'].' credits.';
			eval(standard_error($errormessage));
		}
		$uinfo = fetch_userinfo($match['u']);
		if (!tll_check_credits($uinfo, $match['chal_cost'], 1))
		{
			$errormessage = 'Error, insufficient credits. Match costs '.$match['chal_cost'].' credits, challenger only has '.$uinfo['tmnt_credits'].' credits.';
			eval(standard_error($errormessage));
		}
		process_credits_transaction($match['u'], -$match['chal_cost'], 'Challenged another user', $match['u'], $match['u2']);
		process_credits_transaction($match['u2'], -$match['chal_cost'], 'Challenged another user', $match['u2'], $match['u']);
		update_forum_creditprofit(vbdate('W',TIMENOW), vbdate('Y',TIMENOW), $credits_profit, TIMENOW);
	}
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET accepted = '1', accepted_dateline = '".TIMENOW."' WHERE id='$id' AND u2='$u2' AND accepted = '0' AND finished = '0' AND pot = '0'");
	$u = $vbulletin->input->clean_gpc('g', 'u', TYPE_UINT);
	if ($u)
	{
		$uinfo = fetch_userinfo($u);
		if ($uinfo)
		{
			if (!is_array($uinfo['tmnt_notifications']) && $uinfo['tmnt_notifications'])
			{
				$uinfo['tmnt_notifications'] = unserialize($uinfo['tmnt_notifications']);
			}
			else if (!$uinfo['tmnt_notifications'])
			{
				$uinfo['tmnt_notifications'] = array();
			}
			$uinfo['tmnt_notifications']['ladder_accepts']++;
			$uinfo['tmnt_notifications'] = serialize($uinfo['tmnt_notifications']);
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET tmnt_notifications = '".$vbulletin->db->escape_string($uinfo['tmnt_notifications'])."' WHERE userid = '".$uinfo['userid']."'");
			if ($vbulletin->options['tmnt_ladder_pm_acceptmatch'])
			{/*PM*/
				$title = $vbphrase['ladder_new_chll_accepted'];
				$recipients = $uinfo['username'];
				$message = construct_phrase($vbphrase[ladder_new_chll_accepted_pm], $thisusername, $vbulletin->options['bburl'], $id);
				$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_ARRAY);
				$pmdm->set('fromuserid', $thisuserid);
				$pmdm->set('fromusername', $thisusername);
				$pmdm->set('title', $title);
				$pmdm->set('message', $message);
				$pmdm->set_recipients($recipients, $botpermissions);
				$pmdm->set('dateline', TIMENOW); 
				$pmdm->overridequota = true;
				$errors = $pmdm->errors;
				if ($errors) 
				{
					foreach ($errors as $error) 
					{
						$errorss .= $error. "<br />";
					}
					$errormessage = $errorss;
					eval(standard_error($errormessage));
				}
				$pmdm->save();
				unset($pmdm);
			}/*PM*/
		}
	}
	$from = $vbulletin->input->clean_gpc('g', 'from', TYPE_NOHTML);
	if ($from=='ladder')
	{
		$ladder = fetch_ladderinfo($match['lid']);
		$vbulletin->url = $ladder['url']."&sh=3&mid=$id#match$id";
	}
	else
	{
		$vbulletin->url = "ladders.php?do=challenges&mid=".$id."#match".$id;
	}
	eval(print_standard_redirect('redirect_acceptchal'));
}

// #############################################################################

if ($_REQUEST['do'] == 'cancel')
{
	if (!$tmntp['canjoinladder'])
	{
		print_no_permission();
	}
	$from = $vbulletin->input->clean_gpc('g', 'from', TYPE_NOHTML);
	$sh = $vbulletin->input->clean_gpc('g', 'sh', TYPE_UINT);
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
		if (!$id) {
			$errormessage = $vbphrase[error_invalid_challenge];
			eval(standard_error($errormessage));
		}
	//$u = $thisuserid;
	$match = $vbulletin->db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_ladder_games
		WHERE id='$id' AND accepted = '0' AND finished = '0'
	");
	if (!$match)
	{
		print_no_permission();
	}
	if ($match['pot'])
	{//team
		$t = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_members WHERE leader='1' AND teamid = '".$match['u']."' ");
		if (!$t)
		{
			print_no_permission();
		}
	}
	else
	{//not team
		if ($match['u'] != $thisuserid)
		{
			print_no_permission();
		}
	}
	$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE id='$id' AND accepted = '0' AND finished = '0' ");
	switch ($from)
	{
		case 'ladder':
			$ladder = fetch_ladderinfo($match['lid']);
			$vbulletin->url = "ladders.php".$ladder['url']."&sh=".$sh;
			break;
		case 'challenges':
		default:
			$vbulletin->url = "ladders.php?do=challenges&l=".$match['lid']."#l".$match['lid'];
			break;
	}	
	eval(print_standard_redirect('redirect_cancelchal'));
}

// #############################################################################

if ($_REQUEST['do'] == 'teamaccept')
{
	if (!$tmntp['canjoinladder'])
	{
		print_no_permission();
	}
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
		if (!$id) {
			$errormessage = $vbphrase[error_invalid_challenge];
			eval(standard_error($errormessage));
		}
	$match = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE id = '$id' ");
	if (!$match['pot'] OR $match['accepted'])
	{
		print_no_permission();
	}
	$userid = $thisuserid;
	$teamids = array();
	$teams = $vbulletin->db->query_read("
		SELECT * FROM " . TABLE_PREFIX . "tmnt_members AS members
		JOIN " . TABLE_PREFIX . "tmnt_teams AS teams
			ON members.teamid = teams.teamid
		WHERE members.leader = '1'
			AND members.userid = '$userid'
	");
	while ($teamm = $vbulletin->db->fetch_array($teams)) 
	{
		$teamid = $teamm['teamid'];
		$teamids = array_merge((array)$teamid, $teamids);
	}
	$team_u = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_teams WHERE teamid = '".$match['u']."' ");
	$team_u2 = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_teams WHERE teamid = '".$match['u2']."' ");
	if ($match['chal_cost'] > 0 && $vbulletin->options['tmnt_credit_system'])
	{
		if ($match['win_credits'])
		{
			$credits_profit = 2 * $match['chal_cost'] - $match['win_credits'];
		}
		if ($team_u['tmnt_credits'] < $match['chal_cost'])
		{
			$errormessage = 'Error, insufficient credits. Accepting a challenge costs '.$match['chal_cost'].' credits, '.$team_u['teamname'].' has '.$team_u['tmnt_credits'].' credits.';
			eval(standard_error($errormessage));
		}
		if ($team_u2['tmnt_credits'] < $match['chal_cost'])
		{
			$errormessage = 'Error, insufficient credits. Accepting a challenge costs '.$match['chal_cost'].' credits, '.$team_u2['teamname'].' has '.$team_u2['tmnt_credits'].' credits.';
			eval(standard_error($errormessage));
		}
require_once(DIR . '/includes/functions_tll_prem.php');		
		process_credits_transaction($match['u'], -$match['chal_cost'], 'Challenged another team', $match['u'], $match['u2'], $match['u'], 1);
		process_credits_transaction($match['u2'], -$match['chal_cost'], 'Challenged another team', $match['u2'], $match['u'], $match['u2'], 1);
		update_forum_creditprofit(vbdate('W',TIMENOW), vbdate('Y',TIMENOW), $credits_profit, TIMENOW);
	}	
	$teamids = implode(",", $teamids);
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "tmnt_ladder_games
		SET accepted = '1'
		WHERE id = '$id'
			AND u2 IN ($teamids)
	");
	$vbulletin->url = "ladders.php?do=challenges&mid=".$id."#match".$id;
	eval(print_standard_redirect('redirect_acceptchal'));
}

// #############################################################################

if ($_REQUEST['do'] == 'reject')
{
	if (!$tmntp['canjoinladder'])
	{
		print_no_permission();
	}
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
		if (!$id) {
			$errormessage = $vbphrase[error_invalid_challenge];
			eval(standard_error($errormessage));
		}
	$u2 = $thisuserid;
	$match = $vbulletin->db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_ladder_games
		WHERE id='$id' AND u2='$u2' AND accepted = '0' AND finished = '0' AND pot = '0'
	");
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET accepted = -1, finished = 1 WHERE id=$id AND u2=$u2 AND finished = 0 AND accepted = 0");
	/*PM*/
	$uinfo = fetch_userinfo($match['u']);
	if ($uinfo && $vbulletin->options['tmnt_ladder_pm_acceptmatch'])
	{
		$title = $vbphrase['ladder_new_chll_rejected'];
		$recipients = $uinfo['username'];
		$message = construct_phrase($vbphrase['ladder_x_rejected_challenge'], $thisusername);
		$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_ARRAY);
		$pmdm->set('fromuserid', $thisuserid);
		$pmdm->set('fromusername', $thisusername);
		$pmdm->set('title', $title);
		$pmdm->set('message', $message);
		$pmdm->set_recipients($recipients, $botpermissions);
		$pmdm->set('dateline', TIMENOW); 
		$pmdm->overridequota = true;
		$errors = $pmdm->errors;
		if ($errors) {
			foreach ($errors as $error) {
				$errorss .= $error. "<br />";
			}
			$errormessage = $errorss;
			eval(standard_error($errormessage));
		}
		$pmdm->save();
		unset($pmdm);
	}
	/*PM*/
	$vbulletin->url = "ladders.php?do=challenges";
	eval(print_standard_redirect('redirect_rejectchal'));
}

// #############################################################################

if ($_REQUEST['do'] == 'teamreject')
{
	if (!$tmntp['canjoinladder'])
	{
		print_no_permission();
	}
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	if (!$id)
	{
		$errormessage = $vbphrase[error_invalid_challenge];
		eval(standard_error($errormessage));
	}
	$userid = $thisuserid;
	$teamids = array();
	$teams = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "tmnt_members JOIN " . TABLE_PREFIX . "tmnt_teams on " . TABLE_PREFIX . "tmnt_members.teamid = " . TABLE_PREFIX . "tmnt_teams.teamid WHERE " . TABLE_PREFIX . "tmnt_members.leader=1 AND " . TABLE_PREFIX . "tmnt_members.userid=$userid");
		while($teamm = $vbulletin->db->fetch_array($teams)){
			$teamid = $teamm['teamid'];
			$teamids = array_merge((array)$teamid, $teamids);
	}
	$teamids = implode(",", $teamids);
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET accepted = -1, finished = 1 WHERE id=$id AND agree_u = 0 AND agree_u2 = 0 AND score_u = 0 AND score_u2 = 0 AND u2 IN ($teamids)");
	$vbulletin->url = "ladders.php?do=challenges";
	eval(print_standard_redirect('redirect_rejectchal'));
}

// #############################################################################

if ($_REQUEST['do'] == 'submitscore')
{
	if (!$tmntp['canjoinladder'])
	{
		print_no_permission();
	}
	$sh = $vbulletin->input->clean_gpc('g', 'sh', TYPE_UINT);
	$from = $vbulletin->input->clean_gpc('g', 'from', TYPE_NOHTML);
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
		if (!$id)
		{
			$errormessage = $vbphrase[error_invalid_challenge];
			eval(standard_error($errormessage));
		}
	$teamids_array = array();
	$userid = $thisuserid;
	$games = $vbulletin->db->query_first("SELECT ladders.pot AS pot FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders ON(games.lid=ladders.id) WHERE games.id=$id");
	if ($games['pot'] == 1)
	{
		$team = true;
		$teamids = array();
		$teams = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "tmnt_members AS members JOIN " . TABLE_PREFIX . "tmnt_teams AS teams ON(members.teamid = teams.teamid) WHERE members.leader=1 AND members.userid=$userid");
		while($teamm = $vbulletin->db->fetch_array($teams))
		{
			$teamid = $teamm['teamid'];
			$teamids = array_merge((array)$teamid, $teamids);
		}
		$teamids_array = $teamids;
		$teamids = implode(",", $teamids);
	}
	else
	{
		$team = false;
		$teamids_array = array();
	}
	$rowno = 0;
	$game = $vbulletin->db->query_first("
		SELECT g.*, l.title AS laddertitle, l.tmin, l.tmax
		FROM " . TABLE_PREFIX . "tmnt_ladder_games AS g
		LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS l
			ON (l.id = g.lid)
		WHERE 
			" . (!$team ? "(g.u=$userid OR u2=$userid)" : "(g.u IN (".$teamids.") OR g.u2 IN (".$teamids.") )" ) . "
			AND g.id=$id 
			AND g.finished=0 
			AND g.accepted=1
	");
	if (!$game)
	{
		print_no_permission();
	}
	if ($game['u'] == $thisuserid OR in_array($game['u'], $teamids_array))
	{
		$game['screen'] = $game['screen_u'];
	}
	elseif ($game['u2'] == $thisuserid OR in_array($game['u2'], $teamids_array))
	{
		$game['screen'] = $game['screen_u2'];
	}
	if (!$game['pot'])
	{
		$game['uinfo'] = fetch_userinfo($game['u']);
		$game['u2info'] = fetch_userinfo($game['u2']);
	}
	else 
	{
		$game['uinfo'] = fetch_teaminfo($game['u']);
		$game['u2info'] = fetch_teaminfo($game['u2']);
	}
	if ($game['pot'] && !$game['squadsize'] && !$_REQUEST['redirect'])
	{
		if ($game['tmin']==$game['tmax'] && $game['tmin'] > 0)
		{
			$game['squadsize'] = $game['tmin'];
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET squadsize = '".$game['tmin']."' WHERE id = '$id' ");
			$red = 1;
		}
		else
		{
			$game['squadsize'] = min($game['uinfo']['noplayers'], $game['u2info']['noplayers']);
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET squadsize = '".$game['squadsize']."' WHERE id = '$id' ");
				//print_r($game);
			if ($game['squadsize'] == $game['uinfo']['noplayers'])
			{
				$ma = array();
				$ms = $vbulletin->db->query_read("
					SELECT *
					FROM " . TABLE_PREFIX . "tmnt_members 
					WHERE teamid = '".$game['uinfo']['teamid']."'
				");
				while($m = $vbulletin->db->fetch_array($ms))
				{
					$ma[] = $m['userid'];
				}
				$vbulletin->db->query_write("
					UPDATE " . TABLE_PREFIX . "tmnt_ladder_games
					SET u_squad = '".$vbulletin->db->escape_string(implode(',',$ma))."'
					WHERE id = '".$id."'
				");
			}
			if ($game['squadsize'] == $game['u2info']['noplayers'])
			{
				$ma = array();
				$ms = $vbulletin->db->query_read("
					SELECT *
					FROM " . TABLE_PREFIX . "tmnt_members 
					WHERE teamid = '".$game['u2info']['teamid']."'
				");
				while($m = $vbulletin->db->fetch_array($ms))
				{
					$ma[] = $m['userid'];
				}
				$vbulletin->db->query_write("
					UPDATE " . TABLE_PREFIX . "tmnt_ladder_games
					SET u2_squad = '".$vbulletin->db->escape_string(implode(',',$ma))."'
					WHERE id = '".$id."'
				");
			}
			$red = 1;
		}
	}
	elseif (!$_REQUEST['redirect'])
	{
		if ($game['pot'] && !$game['u_squad'])
		{
			if ($game['squadsize'] == $game['uinfo']['noplayers'])
			{
				$ma = array();
				$ms = $vbulletin->db->query_read("
					SELECT *
					FROM " . TABLE_PREFIX . "tmnt_members 
					WHERE teamid = '".$game['uinfo']['teamid']."'
				");
				while($m = $vbulletin->db->fetch_array($ms))
				{
					$ma[] = $m['userid'];
				}
				$vbulletin->db->query_write("
					UPDATE " . TABLE_PREFIX . "tmnt_ladder_games
					SET u_squad = '".$vbulletin->db->escape_string(implode(',',$ma))."'
					WHERE id = '".$id."'
				");
				$red = 1;
			}
		}
		if ($game['pot'] && !$game['u2_squad'])
		{
			if ($game['squadsize'] == $game['u2info']['noplayers'])
			{
				$ma = array();
				$ms = $vbulletin->db->query_read("
					SELECT *
					FROM " . TABLE_PREFIX . "tmnt_members 
					WHERE teamid = '".$game['u2info']['teamid']."'
				");
				while($m = $vbulletin->db->fetch_array($ms))
				{
					$ma[] = $m['userid'];
				}
				$vbulletin->db->query_write("
					UPDATE " . TABLE_PREFIX . "tmnt_ladder_games
					SET u2_squad = '".$vbulletin->db->escape_string(implode(',',$ma))."'
					WHERE id = '".$id."'
				");
				$red = 1;
			}
		}
	}
	if ($red)
	{
		$vbulletin->url = "ladder_match.php?do=submitscore&id=".$id."&redirect=1&ajax=".($_REQUEST['ajax']==1 ? 1 : 0);
		eval(print_standard_redirect('Redirecting...', 1));
	}
	$rowno++;
	$game['squad_scores'] = unserialize($game['squad_scores']);
	$game['assists'] = unserialize($game['assists']);
	$game['red_cards'] = unserialize($game['red_cards']);
	$game['yellow_cards'] = unserialize($game['yellow_cards']);
	$squads = array();
	if (file_exists(DIR . '/tll_modules/tll_squadscores.php'))
	{
		require_once(DIR . '/tll_modules/tll_squadscores.php');
		$squads = fetch_squads($game);
		$squads_js = fetch_squads_js($game);
	}
	$templater = vB_Template::create('tmnt_ladder_submitscore');
		$templater->register('tmntp', $tmntp);
		$templater->register('ladder', $ladder);
		$templater->register('id', $id);
		$templater->register('lid', $lid);
		$templater->register('team', $team);
		$templater->register('rowno', $rowno);
		$templater->register('game', $game);
		$templater->register('from', $from);
		$templater->register('sh', $sh);
		$templater->register('squads', $squads);
		$templater->register('squads_js', $squads_js);
		$templater->register('ajax', ($_REQUEST['ajax']?1:0));
	$tlhtml .= $templater->render();
	if ($_REQUEST['ajax']==1)
	{
		$tlhtml = str_replace('href="ladders.php?do=challenges"','href="javascript://" onclick="close_tll_popup();"',$tlhtml);
		print_r($tlhtml);
		exit;
	}
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladders'],
		'ladders.php?do=challenges' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladder_chlls'],
		'' => construct_phrase($vbphrase['ladder_submittingscore'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('headinclude', $headinclude);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('tlhtml', $tlhtml);
		$templater->register('modname', $modname);
		$templater->register('header', $header);
		$templater->register('footer', $footer);
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'matchfinder')
{
	if (!$tmntp['canviewladder'])
	{
		print_no_permission();
	}
	if ($vbulletin->userinfo['userid'] && $vbulletin->options['tmnt_warlights'])
	{
		$array3 = $array2 = $array = array();
		$players_query = $vbulletin->db->query_read("
			SELECT p.*, l.title AS laddertitle, IF (p.pot = 1, t.teamname, u.username) AS username
			FROM " . TABLE_PREFIX . "tmnt_ladder_players AS p
			LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS l
				ON (p.lid = l.id)
			LEFT JOIN " . TABLE_PREFIX . "user AS u
				ON (p.userid = u.userid)
			LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS t
				ON (p.userid = t.teamid)
			WHERE p.warlight > '".TIMENOW."'
				AND (p.userid != '".$vbulletin->userinfo['userid']."'
					OR p.pot = 1)
				AND l.archive = 0
				AND p.active = 1
			LIMIT 0, 10
		");
		while($player = $vbulletin->db->fetch_array($players_query))
		{
			$player['ladderurl'] = tll_seo('ladder', $player['lid'], $player['laddertitle']);
			$array[] = $player;
		}
		if ($vbulletin->userinfo['userid'])
		{
			$players_query = $vbulletin->db->query_read("
				SELECT p.*, l.title AS laddertitle
				FROM " . TABLE_PREFIX . "tmnt_ladder_players AS p
				LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS l
					ON (p.lid = l.id)
				WHERE p.userid = '".$vbulletin->userinfo['userid']."'
					AND p.pot = 0
					AND l.league = 0
					AND l.archive = 0
					AND p.active = 1
			");
			while($player = $vbulletin->db->fetch_array($players_query))
			{
				$player['ladderurl'] = tll_seo('ladder', $player['lid'], $player['laddertitle']);
				if ($player['warlight'] < TIMENOW)
				{
					$array2[] = $player;
				}
				else
				{
					$array3[] = $player;
				}
			}
		}
		$templater = vB_Template::create('tmnt_warlights');
			$templater->register('hide', $hide);
			$templater->register('tll_array', $array);
			$templater->register('tll_array2', $array2);
			$templater->register('tll_array3', $array3);
		$tlhtml .= $templater->render();
	}
	$inladders = array();
	$globalg = array();
	$globalg['yourteams'] = array();
	$globalg['teamcount'] = 0;
	$teamids = "0";
	$teams = $vbulletin->db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_members AS members
		RIGHT JOIN " . TABLE_PREFIX . "tmnt_teams AS teams
			ON (members.teamid = teams.teamid)
		WHERE members.leader = '1'
			AND members.userid = '$thisuserid'
	");
	while($teamm = $vbulletin->db->fetch_array($teams))
	{
		$globalg['yourteams'][] = $teamm;
		$globalg['teamcount']++;
		$teamids .= ",".$teamm['teamid'];
	}
	$qinladders = $vbulletin->db->query_read("SELECT lid FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE (userid=$thisuserid AND pot = 0) OR (userid IN (".$teamids.") AND pot = 1) AND active=1");
	while($ladder = $vbulletin->db->fetch_array($qinladders))
	{
		$inladders[] = $ladder['lid'];
	}
	$matches = array();
	$ladders = array();
	$games = $vbulletin->db->query_read("
		SELECT games.*, ladders.title AS laddertitle, IF (games.pot>0,t.teamname,u.username) AS username
		FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
		LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders
			ON (ladders.id = games.lid)
		LEFT JOIN " . TABLE_PREFIX . "user AS u
				ON (games.pot = 0 AND games.u = u.userid)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS t
			ON (games.pot = 1 AND games.u = t.teamid)
		WHERE
			games.u2 = 0
			AND games.finished = 0
			AND games.accepted = 0
			AND games.dateline > ".TIMENOW."
		ORDER BY games.lid ASC, games.dateline ASC
		LIMIT 0, 20
	");
	while($game = $vbulletin->db->fetch_array($games))
	{
		$game['time'] = vbdate($vbulletin->options['timeformat'], $game['dateline']);
		$game['date'] = vbdate($vbulletin->options['dateformat'], $game['dateline'], true);
		$game['showlt'] = true;
		if ($lastgame['lid'] == $game['lid'])
		{
			$game['showlt'] = false;
		}
		$game['notinladder'] = false;
		if (!in_array($game['lid'], $inladders))
		{
			$game['notinladder'] = true;
		}
		$game = process_chal_options($game);
		$game['ladderurl'] = tll_seo('ladder', $game['lid'], $game['laddertitle']);
		$matches[] = $game;
		$ladders[] = $game['lid'];
		$lastgame = $game;
	}
	$templater = vB_Template::create('tmnt_ladder_mf');
		$templater->register('pagenav', $pagenav);
		$templater->register('tmntp', $tmntp);
		$templater->register('team', $team);
		$templater->register('globalg', $globalg);
		$templater->register('matches', $matches);
		$templater->register('inladders', $inladders);
	$tlhtml .= $templater->render();
	$navbits = array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => construct_phrase($vbphrase[ladders])
	);
	$navbits[''] = construct_phrase($vbphrase['ladder_match_finder']);
	/*$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "tmnt_ladders SET views = views + 1 WHERE id = '$id'
	");*/
	$navbar = render_navbar_template(construct_navbits($navbits));
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'teamchal')
{
	$_REQUEST['do'] = 'insertchal';
}

// #############################################################################

if ($_REQUEST['do'] == 'insertchal')
{
	if (!$tmntp['canjoinladder'])
	{
		print_no_permission();
	}
	$lid = $vbulletin->input->clean_gpc('g', 'lid', TYPE_UINT);
	if (!$lid)
	{
		$errormessage = $vbphrase[error_invalid_ladder];
		eval(standard_error($errormessage));
	}	
	$page = $vbulletin->input->clean_gpc('g', 'page', TYPE_UINT);
	$u2 = $vbulletin->input->clean_gpc('g', 'u2', TYPE_INT);
		if (!$u2 || $u2 < -1)
		{
			$errormessage = $vbphrase['error_invalid_challenger'];
			eval(standard_error($errormessage));
		}
	$u = $thisuserid;
	$userid = $thisuserid;
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id = $lid ");
	//print_r($ladder);
	if ($ladder['archive'])
	{
		$errormessage = $vbphrase['error_ladder_closed'];
		eval(standard_error($errormessage));
	}
	if (!$ladder['allow_challenges'])
	{
		$errormessage = 'Challenges disabled';
		eval(standard_error($errormessage));
	}
	if ($ladder['league'])
	{
		$errormessage = 'Error, this is a league';
		eval(standard_error($errormessage));
	}
	if ($ladder['status'] > 0)
	{
		print_no_permission();
	}	
	$co_array2 = unserialize($ladder['chal_options']);
	if (is_array($co_array2))
	{
		$co_array = array();
		foreach($co_array2 AS $key => $value)
		{
			//print_r($value."<br>");
			if (substr($value, -3)=='#@1')
			{
				$value = substr($value, 0, -3);
				$ladder['co_c']["$key"] = 1;
			}
			$key2 = str_replace(' ','_',$key);
			$key2 = preg_replace("/[^a-zA-Z0-9_\s]/", "", unhtmlspecialchars($key2));
			if ($value)
			{
				$co_array["$key2"] = 
				array(
					'value' => explode("\r\n",$value),
					'key' => $key
				);
				$xyu = rand(0, (count($co_array["$key2"]['value'])-1));
				$co_array["$key2"]['rand'] = $co_array["$key2"]['value'][$xyu];
			}
			else
			{
				$co_array["$key2"] = 
				array(
					'value' => $value,
					'key' => $key
				);
			}
		}
	}
	$time_limit = TIMENOW - ($vbulletin->options['tmnt_ladder_limitrematch'] * 60 * 60);
	$countlimit = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE lid=$lid AND ((u=$u AND u2=$u2) OR (u=$u2 AND u2=$u)) AND finished = 0 ");
	if ($countlimit['countrows']>=$vbulletin->options['tmnt_ladder_maxc'])
	{
		$errormessage = "You are only allowed ".$vbulletin->options['tmnt_ladder_maxc']." open challenge(s) with a player at once.";
		if ($_REQUEST['ajax']==1)
		{
			$tlhtml = tll_popup_standard_error($errormessage);
			print_r($tlhtml);
			exit;
		}
		eval(standard_error($errormessage));
	}
	$countlimit = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE lid=$lid AND ((u=$u AND u2=$u2) OR (u=$u2 AND u2=$u)) AND dateline_finished > '" . $time_limit . "' ");
	if ($countlimit['countrows'])
	{
		$days = floor($vbulletin->options['tmnt_ladder_limitrematch']/24);
		$hours = $vbulletin->options['tmnt_ladder_limitrematch'] - $days * 24;
		$errormessage = "Please wait " . ($days ? "$days days " : "") . ($hours ? "$hours hours " : "") . "between challenging the same player/team.";
		if ($_REQUEST['ajax']==1)
		{
			$tlhtml = tll_popup_standard_error($errormessage);
			print_r($tlhtml);
			exit;
		}
		eval(standard_error($errormessage));
	}
	if (!$ladder['pot'])
	{
		if ($u == $u2)
		{
			$errormessage = $vbphrase['error_invalid_challenger'];
			eval(standard_error($errormessage));
		}
		$countplayer = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE lid=$lid AND ((u=$u AND u2=$u2) OR (u=$u2 AND u2=$u)) AND finished=0 ");
		$countplayer = $countplayer['countrows'];  
		if ($countplayer >= $vbulletin->options['tmnt_ladder_maxc'])
		{
			$errormessage = $vbphrase['error_already_challenged'];
			eval(standard_error($errormessage));
		}
		if ($u2 != -1)
		{
			$countplayer = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid=$lid AND userid=$u2 AND active=1");
			$countplayer = $countplayer['countrows'];  
			if ($countplayer != 1)
			{
				$errormessage = $vbphrase['error_player_not_ladder'];
				eval(standard_error($errormessage));
			}
		}
		$countplayer = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid=$lid AND userid=$u AND active=1");
		$countplayer = $countplayer['countrows'];  
		if ($countplayer != 1)
		{
			$errormessage = construct_phrase($vbphrase['error_not_in_ladder'],$lid);
			eval(standard_error($errormessage));
		}
		$username_u = $thisusername;
		$username_u2 = fetch_userinfo($u2);
		$username_u2 = $username_u2['username'];
		/*insufficient credit check*/
		if ($vbulletin->options['tmnt_credit_system'])
		{
			if ($ladder['chal_cost'])
			{
				$ladder['win_credits'] = (1-$vbulletin->options['tmnt_credits_comm'])*2*$ladder['chal_cost'];
			}
require_once(DIR . '/includes/functions_tll_prem.php');
			if (!tll_check_credits($vbulletin->userinfo, $ladder['chal_cost']))
			{
				$errormessage = 'Error, you have insufficient credits. Challenges for this ladder cost '.$ladder['chal_cost'].' credits, you only have '.$vbulletin->userinfo['tmnt_credits'].' credits.<br /><br /><a href="tll_credits.php?do=credits">Click here to buy some more credits.</a>';
				if ($_REQUEST['ajax']==1)
				{
					$tlhtml = tll_popup_standard_error($errormessage);
					print_r($tlhtml);
					exit;
				}
				eval(standard_error($errormessage));
			}
		}
		// end single bit
	}
	else
	{
		// start team bit
		if ($u2 != -1)
		{
			$countteam = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid=$lid AND userid=$u2 AND pot=1");
			$countteam = $countteam['countrows'];  
			if ($countteam != 1)
			{
				$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_players SET pot = 1 WHERE lid=$lid");
				$errormessage = $vbphrase['error_team_not_ladder'];
				eval(standard_error($errormessage));
			}
		}
		$userteams .= '<select name="u" id="u">';
		$teams = $vbulletin->db->query_read("SELECT *
			FROM " . TABLE_PREFIX . "tmnt_members
			RIGHT JOIN " . TABLE_PREFIX . "tmnt_teams
			on " . TABLE_PREFIX . "tmnt_members.teamid = " . TABLE_PREFIX . "tmnt_teams.teamid
			RIGHT JOIN " . TABLE_PREFIX . "tmnt_ladder_players
			on " . TABLE_PREFIX . "tmnt_members.teamid = " . TABLE_PREFIX . "tmnt_ladder_players.userid
			WHERE " . TABLE_PREFIX . "tmnt_members.leader=1
			AND " . TABLE_PREFIX . "tmnt_members.userid=$userid
			AND " . TABLE_PREFIX . "tmnt_ladder_players.lid=$lid
			AND " . TABLE_PREFIX . "tmnt_ladder_players.userid!=$u2");
		while($teamm = $vbulletin->db->fetch_array($teams))
		{
			$userteams .= "<option value=\"".$teamm['teamid']."\">".$teamm['teamname']."</option>";
			$countuserteams++ ;
		}
		$userteams .= '</select>';
		if ($countuserteams == 0)
		{
			$errormessage = $vbphrase['error_not_teamleader'];
			eval(standard_error($errormessage));
		}
		$challenged = fetch_teaminfo($u2);
		if ($vbulletin->options['tmnt_credit_system'] && $ladder['chal_cost'])
		{
			$ladder['win_credits'] = (1-$vbulletin->options['tmnt_credits_comm'])*2*$ladder['chal_cost'];
		}
		// end  team bit
	}
	
		
		
		$ladder['protected'] = array(
			'win_defending' => $ladder['protected_win_defending'], 
			'lose_defending' => $ladder['protected_lose_defending'], 
			'win_challenge' => $ladder['protected_win_challenge'], 
			'lose_challenge' => $ladder['protected_lose_challenge'], 
		);
		$r = $vbulletin->db->query_first("
			SELECT *
			FROM " . TABLE_PREFIX . "tmnt_ladder_games
			WHERE lid = '$lid'
				AND u = '$u2'
				AND dateline_finished > '".(TIMENOW-$ladder['protected']['win_challenge'])."'
				AND score_u > score_u2
		");
		if ($r)
		{//If you win a challenging match you are protected for 12h (no one will be able to challenge you).
			$errormessage = construct_phrase($vbphrase['tmnt_protected_win_challenging'], $username_u2, ($ladder['protected']['win_challenge']/3600), vbdate($vbulletin->options['dateformat']." ".$vbulletin->options['timeformat'], $r['dateline_finished']+$ladder['protected']['win_challenge']));
		}
		$s = $vbulletin->db->query_first("
			SELECT *
			FROM " . TABLE_PREFIX . "tmnt_ladder_games
			WHERE lid = '$lid'
				AND u2 = '$u2'
				AND dateline_finished > '".(TIMENOW-$ladder['protected']['win_defending'])."'
				AND score_u < score_u2
		");
		if ($s)
		{//If you win a defending match you are protected for 2 days (no one will be able to challenge you).
			$errormessage = $username_u2 . " has won their last challenging match and is protected for " . ($ladder['protected']['win_defending'] / 3600) . " hours, until " . vbdate($vbulletin->options['dateformat']." ".$vbulletin->options['timeformat'], $s['dateline_finished']+$ladder['protected']['win_defending']).".";
		}
		$t = $vbulletin->db->query_first("
			SELECT *
			FROM " . TABLE_PREFIX . "tmnt_ladder_games
			WHERE lid = '$lid'
				AND u2 = '$u'
				AND dateline_finished > '".(TIMENOW-$ladder['protected']['lose_defending'])."'
				AND score_u > score_u2
		");
		if ($t)
		{//If you lose a defending match you are vulnerable for 12h (you will be unable to challenge).
			$errormessage = "You have lost a defending match and are vulnerable for ". ($ladder['protected']['lose_defending'] / 3600)." hours (you will be unable to challenge), until " . vbdate($vbulletin->options['dateformat']." ".$vbulletin->options['timeformat'], $t['dateline_finished']+$ladder['protected']['lose_defending']).".";
		}
		$v = $vbulletin->db->query_first("
			SELECT *
			FROM " . TABLE_PREFIX . "tmnt_ladder_games
			WHERE lid = '$lid'
				AND u = '$u'
				AND dateline_finished > '".(TIMENOW-$ladder['protected']['lose_challenge'])."'
				AND score_u < score_u2
		");
		if ($v)
		{//If you lose a challenging match you are vulnerable for 2 days (you will be unable to challenge).
			$errormessage = "You have lost a challenging match and are vulnerable for ".($ladder['protected']['lose_challenge'] / 3600)." hours (you will be unable to challenge), until " . vbdate($vbulletin->options['dateformat']." ".$vbulletin->options['timeformat'], $v['dateline_finished']+$ladder['protected']['lose_challenge']).".";
		}
		/*
		You cannot play the same team twice in a row.
		Time given to accept a match: 2 days
		*/
		if ($errormessage)
		{
			if ($_REQUEST['ajax']==1)
			{
				$tlhtml = tll_popup_standard_error($errormessage);
				print_r($tlhtml);
				exit;
			}
			eval(standard_error($errormessage));
		}
		
	$day = vbdate("j", TIMENOW);
	if ($day == 'j')
	{
		$day = date("j", TIMENOW);
	}
	$month = vbdate("n", TIMENOW);
	if ($month == 'n')
	{
		$month = date("n", TIMENOW);
	}
	$year = vbdate("Y", TIMENOW);
	if ($year == 'Y')
	{
		$year = date("Y", TIMENOW);
	}
	$monthselected = array();
	$yearselected = array();
	$monthselected["$month"] = 'selected="selected"';
	$yearselected["$year"] = 'selected="selected"';
	$yearbits = '';
	for ($gyear = 2005; $gyear <= 2015; $gyear++)
	{
		$yearbits .= "\t\t<option value=\"$gyear\" $yearselected[$gyear]>$gyear</option>";
	}
	if (strpos($vbulletin->options['timeformat'], 'H') !== false)
	{
		$show['24hour'] = true;
	}
	else
	{
		$show['24hour'] = false;
	}
	$time = vbdate($vbulletin->options['timeformat'], TIMENOW);
	require_once(DIR . '/includes/functions_misc.php');
	$timezoneoptions = '';
	foreach (fetch_timezone() AS $optionvalue => $timezonephrase)
	{
		$optiontitle = $vbphrase["$timezonephrase"];
		$optionselected = ($optionvalue == $vbulletin->userinfo['timezoneoffset'] + $vbulletin->userinfo['dstonoff'] ? 'selected="selected"' : '');
		$timezoneoptions .= render_option_template($optiontitle, $optionvalue, $optionselected, $optionclass);
	}
	$templater = vB_Template::create('tmnt_ladder_chal');
		$templater->register('tmntp', $tmntp);
		$templater->register('ladder', $ladder);
		$templater->register('id', $id);
		$templater->register('page', $page);
		$templater->register('lid', $lid);
		$templater->register('challenged', $challenged);
		$templater->register('userteams', $userteams);
		$templater->register('username_u2', $username_u2);
		$templater->register('username_u', $username_u);
		$templater->register('u2', $u2);
		$templater->register('co_array', $co_array);
		$templater->register('time', $time);
		$templater->register('day', $day);
		$templater->register('timezoneoptions', $timezoneoptions);
		$templater->register('monthselected', $monthselected);
		$templater->register('yearbits', $yearbits);
		$templater->register('dstchecked', $dstchecked);
		if ($_REQUEST['ajax'])
		{
			$templater->register('ajax', '1');
		}
	$tlhtml .= $templater->render();
	if ($_REQUEST['ajax'])
	{
		$tlhtml = str_replace('history.go(-1);return false;','close_tll_popup();', $tlhtml);
		print_r($tlhtml);
		exit;
	}
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladders'],
		'ladders.php?' . $vbulletin->session->vars['sessionurl_q'] . 'do=view&amp;id=' . $lid => $ladder['title'],
		'' => construct_phrase($vbphrase['ladder_chal'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'acceptmatchdate')
{
	$vbulletin->input->clean_array_gpc('g', array(
		'mid' => TYPE_UINT,
		'dateline' => TYPE_UINT
	));
	$game = $vbulletin->db->query_first("
		SELECT games.*, games.u AS uid, games.u2 AS u2id, ladders.title AS ltitle, user.username AS u, user2.username AS u2
		FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
		LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders
			ON (games.lid = ladders.id)
		LEFT JOIN " . TABLE_PREFIX . "user AS user
			ON (games.u = user.userid)
		LEFT JOIN " . TABLE_PREFIX . "user AS user2
			ON (games.u2 = user2.userid)
		WHERE games.finished = 0
			AND games.accepted != -1
			AND games.id = '".$vbulletin->GPC['mid']."'
	");
	if (!$game OR !$vbulletin->GPC['dateline'])
	{
		print_no_permission();
	}
	if ($game['uid'] == $vbulletin->userinfo['userid'])
	{
		$is = 'u';
		$ois = 'u2';
	}
	elseif ($game['u2id'] == $vbulletin->userinfo['userid'])
	{
		$is = 'u2';
		$ois = 'u';
	}
	else
	{
		print_no_permission();
	}
	if ($game['ram'])
	{
		$game['ram'] = unserialize($game['ram']);
	}
	if (is_array($game['ram']) && $game['ram']["$ois"])
	{
		$game['opp_sd'] = array();
		for ($i = 1; $i <= 3; $i++)
		{
			if ($game['ram']["$ois"]["dateline$i"])
			{
				$game['opp_sd'][] = $game['ram']["$ois"]["dateline$i"];
			}
		}
	}
	if (!in_array($vbulletin->GPC['dateline'], $game['opp_sd']))
	{
		print_no_permission();
	}
	if (!$game['pot'])
	{
		require_once('./includes/functions_databuild.php');
		$fromuserid = $vbulletin->userinfo['userid'];
		$fromusername = $vbulletin->userinfo['username'];
		$recipients = $game["$ois"];
		$title = $fromusername.' accepted new match time';
		$new_date = vbdate($vbulletin->options['dateformat'] . " " . $vbulletin->options['timeformat'], $vbulletin->GPC['dateline']);
		$vs = $game['u']." ".$vbphrase['ladder_vs']." ".$game['u2'];
		$message = construct_phrase($vbphrase['ladder_pm_resched_accepted'], $fromusername, $vbulletin->options['bburl'], $vbulletin->GPC['mid'], $new_date, "[url=".$vbulletin->options['bburl']."/ladders.php?do=view&id=".$game['lid']."]".$game['ltitle']."[/url]: ".$vs, $game['lid']);
		$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_ARRAY);
			$pmdm->set('fromuserid', $fromuserid);
			$pmdm->set('fromusername', $fromusername);
			$pmdm->set('title', $title);
			$pmdm->set('message', $message);
			$pmdm->set_recipients($recipients, $botpermissions);
			$pmdm->set('dateline', TIMENOW); 
			$pmdm->overridequota = true;
			$errors = $pmdm->errors;
			if ($errors) {
				foreach ($errors as $error) {
					$errorss .= $error. "<br />";
				}
				$errormessage = $errorss;
				eval(standard_error($errormessage));
			}
		$pmdm->save();
		unset($pmdm);
	}
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "tmnt_ladder_games
		SET ram = '', dateline = '".$vbulletin->GPC['dateline']."'
		WHERE id = '".$vbulletin->GPC['mid']."'
	");
	$vbulletin->url = "ladders.php?do=view&amp;id=".$game['lid']."&amp;sh=2&amp;mid=".$vbulletin->GPC['mid']."#match".$vbulletin->GPC['mid'];
	eval(print_standard_redirect('redirect_updatechal'));
}

// #############################################################################

if ($_REQUEST['do'] == 'rearrange_match')
{
	$mid = $vbulletin->input->clean_gpc('g', 'mid', TYPE_UINT);
	$game = $vbulletin->db->query_first("
		SELECT games.*, games.u AS uid, games.u2 AS u2id, ladders.title AS ltitle, user.username AS u, user2.username AS u2
		FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
		LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders
			ON (games.lid = ladders.id)
		LEFT JOIN " . TABLE_PREFIX . "user AS user
			ON (games.u = user.userid)
		LEFT JOIN " . TABLE_PREFIX . "user AS user2
			ON (games.u2 = user2.userid)
		WHERE games.finished = 0
			AND games.accepted != -1
			AND games.id = '$mid'
	");
	if (!$game)
	{
		print_no_permission();
	}
	if ($game['uid'] == $vbulletin->userinfo['userid'])
	{
		$is = 'u';
		$ois = 'u2';
	}
	elseif ($game['u2id'] == $vbulletin->userinfo['userid'])
	{
		$is = 'u2';
		$ois = 'u';
	}
	else
	{
		print_no_permission();
	}
	if ($vbulletin->userinfo['tmnt_notifications'])
	{
		$thisu = $vbulletin->userinfo;
		if (!is_array($thisu['tmnt_notifications']))
		{
			$thisu['tmnt_notifications'] = unserialize($thisu['tmnt_notifications']);
		}
		if ($thisu['tmnt_notifications']['l_rearrange'] && $mid == $thisu['tmnt_notifications']['l_rearr_id'])
		{
			$thisu['tmnt_notifications']['l_rearrange']--;
			$thisu['tmnt_notifications']['l_rearr_id'] = '';
			$thisu['tmnt_notifications'] = serialize($thisu['tmnt_notifications']);
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET tmnt_notifications = '".$vbulletin->db->escape_string($thisu['tmnt_notifications'])."' WHERE userid = '".$thisu['userid']."'");
		}
	}
	if ($game['ram'])
	{
		$game['ram'] = unserialize($game['ram']);
	}
	if (!$game['dateline'])
	{
		$game['nodateline'] = true;
		$game['dateline'] = TIMENOW + 86400;
	}
	$utc = $vbulletin->userinfo['timezoneoffset'];
	$dst = 1;
	for ($i = 1; $i <= 3; $i++)
	{
		if (!is_array($game['ram']) OR !$game['ram']["$is"]["dateline$i"])
		{
			$dateline = $game['dateline'] + (($i - 1) * 86400);
		}
		else
		{
			$dateline = $game['ram']["$is"]["dateline$i"];
		}
		list ($timezoneoptions, $day, $monthselected, $yearbits, $time, $dstchecked, $show) = tmnt_dateline_to_fields($dateline, $utc, $dst, $show);
		$templater = vB_Template::create('tmnt_date_time');
			$templater->register('tmntp', $tmntp);
			$templater->register('ladder', $ladder);
			$templater->register('timezoneoptions', $timezoneoptions);
			$templater->register('dstchecked', $dstchecked);
			$templater->register('time', $time);
			$templater->register('day', $day);
			$templater->register('monthselected', $monthselected);
			$templater->register('yearbits', $yearbits);
			$templater->register('rangeid', 0);
			$templater->register('prefix', 'd'.$i);
		if ($i == 1)
		{
			$dh = "datehtml"; 
		}
		else
		{
			$dh = "datehtml$i"; 
		}
		$$dh = $templater->render();
	}
	if (is_array($game['ram']) && $game['ram']["$ois"])
	{
		$game['opp_sd'] = array();
		for ($i = 1; $i <= 3; $i++)
		{
			if ($game['ram']["$ois"]["dateline$i"])
			{
				$game['opp_sd'][] = $game['ram']["$ois"]["dateline$i"];
				$show['opponent_suggestions'] = true;
			}
		}
	}
	if (is_array($game['ram']) && $game['ram']["$is"])
	{
		$game['your_sd'] = array();
		for ($i = 1; $i <= 3; $i++)
		{
			if ($game['ram']["$is"]["dateline$i"])
			{
				$game['your_sd'][] = $game['ram']["$is"]["dateline$i"];
				$show['your_suggestions'] = true;
			}
		}
	}
	$templater = vB_Template::create('tmnt_ladder_rearrange');
		$templater->register('tmntp', $tmntp);
		$templater->register('game', $game);
		$templater->register('datehtml', $datehtml);
		$templater->register('datehtml2', $datehtml2);
		$templater->register('datehtml3', $datehtml3);
		$templater->register('timezoneoptions', $timezoneoptions);
		$templater->register('dstchecked', $dstchecked);
		$templater->register('show', $show);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladders'],
		'ladders.php?' . $vbulletin->session->vars['sessionurl_q'] . 'do=view&amp;id=' . $game['lid'] => $game['ltitle'],
		'' => $vbphrase['ladder_rearrange_md']
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('headinclude', $headinclude);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('tlhtml', $tlhtml);
		$templater->register('modname', $modname);
		$templater->register('header', $header);
		$templater->register('footer', $footer);
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'search_matches')
{
	if (!$tmntp['canviewladder'])
	{
		print_no_permission();
	}
	$mysql_cond_and = '';
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	$u1 = $vbulletin->input->clean_gpc('g', 'u1', TYPE_UINT);
	$u2 = $vbulletin->input->clean_gpc('g', 'u2', TYPE_UINT);
	if (!$id)
	{
		$errormessage = $vbphrase[error_invalid_ladder];
        eval(standard_error($errormessage));
	}
	$lid = $id;
	$ladder = $vbulletin->db->query_first("
		SELECT ladders.*, cats.title AS categorytitle, cats.parentid, cats2.title AS parenttitle, ladders.cr_userid AS userid, ladders.cr_username AS username
		FROM " . TABLE_PREFIX . "tmnt_ladders AS ladders
		LEFT JOIN " . TABLE_PREFIX . "tmnt_categories AS cats 
			ON (cats.catid = ladders.catid)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_categories AS cats2 
			ON (cats.parentid = cats2.catid)
		WHERE ladders.id = '$id'
	");
	if (!$ladder)
	{
		$errormessage = $vbphrase[error_invalid_ladder];
        eval(standard_error($errormessage));
	}
	if ($ladder['pot'])
	{
		$team = true;
	}
	if ($u1 > 0)
	{
		$mysql_cond_and .= " AND (games.u = '$u1' OR games.u2 = '$u1') ";
	}
	if ($u2 > 0)
	{
		$mysql_cond_and .= " AND (games.u = '$u2' OR games.u2 = '$u2') ";
	}
		$cmpt_array = array();
		$cmpts = $vbulletin->db->query_read("
			SELECT " . (!$team ? "user.*, " : "") . " players.*, players.userid AS userid
			" . (!$team ? ", user.username AS username" : "") . "
			, players.rank AS rank
		FROM " . TABLE_PREFIX . "tmnt_ladder_players AS players
		" . (!$team ? "LEFT JOIN " . TABLE_PREFIX . "user AS user ON (players.userid = user.userid) " : " LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS team ON (players.userid = team.teamid)") . "
		WHERE players.lid=$id 
			AND players.active=1
		ORDER BY 
			players.group ASC,
			" . ($vbulletin->options['tmnt_ladder_ranking'] == 'elo' ? "players.rank DESC," : "")
			. ($vbulletin->options['tmnt_ladder_ranking'] == 'xp' ? "players.xp DESC," : "") . "
			players.wins DESC,
			players.draws DESC,
			players.loses ASC,
			" . ($vbulletin->options['tmnt_ladder_ranking'] == 'elo' ? "players.xp DESC, " : "") . "
			players.totalpoints DESC,
			players.pointsagainst ASC
		");
		$ti = 0;
		while($cmpt = $vbulletin->db->fetch_array($cmpts))
		{
			if ($cmpt['userid'] == $u1)
			{
				$cmpt['selected_u1'] = ' selected="selected"';
			}
			if ($cmpt['userid'] == $u2)
			{
				$cmpt['selected_u2'] = ' selected="selected"';
			}
			$cmpt_array[] = $cmpt;
		}
	
	$u1_select = '<select name="u1" id="u1" onchange="this.form.submit();"><option></option>';
	$u2_select = '<select name="u2" id="u2" onchange="this.form.submit();"><option value="">All Other Players</option>';
	foreach ($cmpt_array AS $chash => $cmpt)
	{
		$u1_select .= '<option value="'.$cmpt['userid'].'" '.$cmpt['selected_u1'].'>'.$cmpt['username'].'</option>';
		$u2_select .= '<option value="'.$cmpt['userid'].'" '.$cmpt['selected_u2'].'>'.$cmpt['username'].'</option>';
	}
	$u1_select .= '</select>';
	$u2_select .= '</select>';
		$chlls = $vbulletin->db->query_read("
			SELECT games.*, games.u AS uid, games.u2 AS u2id,
			" . (!$team ? "user.username AS u, userb.username AS u2" : "user.teamname AS u, userb.teamname AS u2") . "
			FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
			" . (!$team ? "LEFT JOIN " . TABLE_PREFIX . "user AS user ON (games.u = user.userid) LEFT JOIN " . TABLE_PREFIX . "user AS userb ON (games.u2 = userb.userid)" : "LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS user ON (games.u = user.teamid) LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS userb ON (games.u2 = userb.teamid)") . "
			WHERE games.lid = '$id'
				AND games.finished = '1'
				" . ($ladder['filter_round'] ? " AND games.round = '" . $ladder['filter_round']."'" : "")
				. ($ladder['filter_group'] ? " AND games.group = '" . $ladder['filter_group']."'" : "") . "
				$mysql_cond_and
			ORDER BY games.dateline_finished DESC, games.id DESC
			LIMIT 0, 51
		");
		$rowno = 0;
		$chllarray = array();
		$mc_ids_array = array();
		while($chll = $vbulletin->db->fetch_array($chlls))
		{
			$rowno++;
			if ($rowno != 51)
			{
				$chll['display'] = 'none';
				if (
					$vbulletin->options['tmnt_ladder_priv_mc'] &&
						(  (!$team && !in_array($vbulletin->userinfo['userid'], array($chll['uid'],$chll['u2id'])))
						OR
						($team && !in_array($chll['uid'],$tml_array) && !in_array($chll['u2id'],$tml_array))  )
				)
				{
					$chll['hide_mc'] = true;
				}
				$chllarray["$chll[id]"] = $chll;
				if ($chll['comments'] > 0 && !$chll['hide_mc'])
				{
					$mc_ids_array[] = $chll['id'];
				}
			}
			else
			{
				$show['morechll'] = true;
			}
		}
		if (!empty($mc_ids_array))
		{
			$chllarray = fetch_ladder_mcs($mc_ids_array, $chllarray);
			
		}
		
			$templater = vB_Template::create('tmnt_ladder_searchmatches');
				$templater->register('tmntp', $tmntp);
				$templater->register('ladder', $ladder);
				$templater->register('id', $id);
				$templater->register('lid', $lid);
				$templater->register('sh', $sh);
				$templater->register('chll', $chll);
				$templater->register('team', $team);
				$templater->register('rowno', $rowno);
				$templater->register('chllarray', $chllarray);
				$templater->register('u1', $u1);
				$templater->register('u2', $u2);
				$templater->register('u1_select', $u1_select);
				$templater->register('u2_select', $u2_select);
			$competitors .= $templater->render();
	$tlhtml = $competitors;
	$navbits = array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname
	);
	if (!$ladder['league'])
	{
		$navbits['ladders.php?' . $vbulletin->session->vars['sessionurl_q'] . 'showonly=ladders'] = $vbphrase['ladders'];
	}
	else
	{
		$navbits['ladders.php?' . $vbulletin->session->vars['sessionurl_q'] . 'showonly=leagues'] = $vbphrase['ladder_leagues'];
	}
	if ($ladder['parenttitle'])
	{
		$navbits['ladders.php?c=' . $ladder['parentid'] . $vbulletin->session->vars['sessionurl_q']] = $ladder['parenttitle'];
	}
	$navbits['ladders.php?c=' . $ladder['catid'] . $vbulletin->session->vars['sessionurl_q']] = $ladder['categorytitle'];
	$navbits[''] = construct_phrase($ladder['title']);
	$navbar = render_navbar_template(construct_navbits($navbits));
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'viewmatch')
{
	$mid = $vbulletin->input->clean_gpc('g', 'mid', TYPE_UINT);
	$game = $match = $vbulletin->db->query_first("
		SELECT g.*, IF (g.pot = 1, t.teamname, '') AS u_teamname, IF (g.pot = 1, t2.teamname, '') AS u2_teamname, IF (g.pot = 0, u.username, '') AS u_username, IF (g.pot = 0, u2.username, '') AS u2_username, l.title AS laddertitle, l.league
		FROM " . TABLE_PREFIX . "tmnt_ladder_games AS g
		LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS l
			ON (g.lid = l.id)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS t
			ON (g.u = t.teamid)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS t2
			ON (g.u2 = t2.teamid)
		LEFT JOIN " . TABLE_PREFIX . "user AS u
			ON (g.u = u.userid)
		LEFT JOIN " . TABLE_PREFIX . "user AS u2
			ON (g.u2 = u2.userid)
		WHERE g.id = '$mid'");
	//print_r($game);
	if (!$game)
	{
		print_no_permission();
	}
	if ($vbulletin->userinfo['tmnt_notifications'])
	{
		$thisu = $vbulletin->userinfo;
		if (!is_array($thisu['tmnt_notifications']))
		{
			$thisu['tmnt_notifications'] = unserialize($thisu['tmnt_notifications']);
		}
		if ($thisu['tmnt_notifications']['ladder_finishedmat'] > 0 && $vbulletin->userinfo['tmnt_notifications']['ladder_finmid'] == $mid)
		{
			$thisu['tmnt_notifications']['ladder_finishedmat'] = 0;
			$thisu['tmnt_notifications'] = serialize($thisu['tmnt_notifications']);
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET tmnt_notifications = '".$vbulletin->db->escape_string($thisu['tmnt_notifications'])."' WHERE userid = '".$thisu['userid']."'");
		}
	}
	if ($game['screen_u'])
	{
		$game['screen_u'] = explode(";", $game['screen_u']);
	}
	if ($game['screen_u2'])
	{
		$game['screen_u2'] = explode(";", $game['screen_u2']);
	}
	if ($game['pot'])
	{
		$team = true;
		$players_u = $players_u2 = array();
		$game['squad_scores'] = unserialize($game['squad_scores']);
		$game['red_cards'] = unserialize($game['red_cards']);
		$game['yellow_cards'] = unserialize($game['yellow_cards']);
		if ($game['u_squad'])
		{
			$game['u_squad'] = explode(',',$game['u_squad']);
		}
		else
		{
			$game['u_squad'] = array();
		}
		if ($game['u2_squad'])
		{
			$game['u2_squad'] = explode(',',$game['u2_squad']);
		}
		else
		{
			$game['u2_squad'] = array();
		}
		$team_u_query = $vbulletin->db->query_read("
			SELECT m.*, u.username
			FROM " . TABLE_PREFIX . "tmnt_members AS m
			LEFT JOIN " . TABLE_PREFIX . "user AS u
				ON (u.userid = m.userid)
			WHERE m.teamid = '".$game['u']."'
		");
		while($teamplayer = $vbulletin->db->fetch_array($team_u_query))
		{
			if (in_array($teamplayer['userid'], $game['u_squad']))
			{
				$teamplayer['checked'] = ' checked="checked"';
			}
			if ($game['squad_scores']['u'])
			{
				$teamplayer['showscore'] = true;
				$teamplayer['score'] = $game['squad_scores']['u']["$teamplayer[userid]"];
			}
			if ($game['yellow_cards']['u'] && in_array($teamplayer['userid'], $game['yellow_cards']['u']))
			{
				$teamplayer['cards'] .= ' &nbsp; <img src="images/buttons/yellow-card_sm.png" alt="" />';
			}
			if ($game['red_cards']['u'] && in_array($teamplayer['userid'], $game['red_cards']['u']))
			{
				$teamplayer['cards'] .= ' &nbsp; <img src="images/buttons/red-card_sm.png" alt="" />';
			}
			$players_u[] = $teamplayer;
		}
		$team_u2_query = $vbulletin->db->query_read("
			SELECT m.*, u.username
			FROM " . TABLE_PREFIX . "tmnt_members AS m
			LEFT JOIN " . TABLE_PREFIX . "user AS u
				ON (u.userid = m.userid)
			WHERE m.teamid = '".$game['u2']."'
		");
		while($teamplayer = $vbulletin->db->fetch_array($team_u2_query))
		{
			if (in_array($teamplayer['userid'], $game['u2_squad']))
			{
				$teamplayer['checked'] = ' checked="checked"';
			}
			if ($game['squad_scores']['u2'])
			{
				$teamplayer['showscore'] = true;
				$teamplayer['score'] = $game['squad_scores']['u2']["$teamplayer[userid]"];
			}
			if ($game['yellow_cards']['u2'] && in_array($teamplayer['userid'], $game['yellow_cards']['u2']))
			{
				$teamplayer['cards'] .= ' &nbsp; <img src="images/buttons/yellow-card_sm.png" alt="" />';
			}
			if ($game['red_cards']['u2'] && in_array($teamplayer['userid'], $game['red_cards']['u2']))
			{
				$teamplayer['cards'] .= ' &nbsp; <img src="images/buttons/red-card_sm.png" alt="" />';
			}
			$players_u2[] = $teamplayer;
		}
	}
	elseif ($vbulletin->userinfo['userid'])
	{
		if ($vbulletin->userinfo['userid']==$game['u'])
		{
			$is_u = true;
		}
		elseif ($vbulletin->userinfo['userid']==$game['u2'])
		{
			$is_u2 = true;
		}
	}
	$game['u2id'] = $game['u2'];
	$game['uid'] = $game['u'];
	$game = switch_match_status($game, $is_u, $is_u2, 'viewmatch');
	if ($game['comments']>0)
	{
		$comments = array();
		$comments_query = $vbulletin->db->query_read("
			SELECT *
			FROM " . TABLE_PREFIX . "tmnt_ladder_mcs
			WHERE mid = '$mid'
			ORDER BY dateline ASC
		");
		while($comment = $vbulletin->db->fetch_array($comments_query))
		{
			if (!$comment['mid'])
			{
				continue;
			}
			$comments[] = $comment;
		}
	}
	$game['timetoaccept'] = number_format(($game['accepted_dateline'] - $game['dateline'])/86400);
	//print_r($game);
	$ladder = fetch_ladderinfo($game['lid']);
	$templater = vB_Template::create('tmnt_ladder_viewmatch');
		$templater->register('tmntp', $tmntp);
		$templater->register('ladder', $ladder);
		$templater->register('team', $team);
		$templater->register('game', $game);
		$templater->register('players_u', $players_u);
		$templater->register('players_u2', $players_u2);
		$templater->register('comments', $comments);
	$tlhtml .= $templater->render();
	if ($_REQUEST['ajax'])
	{
		$tlhtml = str_replace('history.go(-1);','close_tll_popup();',$tlhtml);
		print_r($tlhtml);
		exit;
	}
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladders'],
		$ladder['url'] => $ladder['title'],
		'' => 'View Match'
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

