<?php
/*======================================================================*\
|| #################################################################### ||
|| # Copyright  BananaLive Scripts. All Rights Reserved. ############# ||
|| #################################################################### ||
\*======================================================================*/

error_reporting(E_ALL & ~E_NOTICE);
define('THIS_SCRIPT', 'ladders');
if ($_REQUEST['do'] && in_array($_REQUEST['do'], array('pmcmpt')))
{
define('GET_EDIT_TEMPLATES', true);
}
$phrasegroups = array('posting', 'postbit', 'user', 'timezone', 'global', 'pm', 'reputationlevel', 'search', 'calendar');
$specialtemplates = array(
	'bbcodecache',
	'smiliecache',
	'tll_catcache',
);
$globaltemplates = array(
	'tmnt_shell'
);
$actiontemplates = array(
	'leaveladder' => array(
		'tmnt_ladder_teamleave'
	),
	'warlights' => array(
		'tmnt_warlights'
	),
	'pm' => array(
		'tmnt_ladder_threadtemplate2'
	),
	'join' => array(
		'tmnt_ladder_join'
	),
	'editavatar' => array(
		'tmnt_ladder_editavatar'
	),
	'editbadge' => array(
		'tmnt_ladder_editbadge'
	),
	'player_popup' => array(
		'tmnt_ladder_player_popup'
	),
	'pmcmpt' => array(
		'tmnt_ladder_threadtemplate2',
		'tmnt_newpm'
	),
	'challenges' => array(
		'tmnt_ladder_chll_top',
		'tmnt_ladder_chll',
		'tmnt_ladder_chll_bot',
		'tmnt_ladder_yourteams'
	),
	'enable_warlight' => array(
		'tmnt_enablelivematch_chooseteam'
	),
	'allchallenges' => array(
		'tmnt_ladder_all_chll_top',
		'tmnt_ladder_chll',
		'tmnt_ladder_chll_bot'
	),
	'reportedmatches' => array(
		'tmnt_ladder_repmatch'
	),
	'globalranks' => array(
		'tmnt_ladder_globalranks'
	),
	'create_player_image' => array(
		'tmnt_ladder_cpi'
	),
	'elorating' => array(
		'tmnt_ladder_elorating'
	),
	'editsquad' => array(
		'tmnt_ladder_editsquad'
	),
	'view' => array(
		'tmnt_ladder_cmpt_top',
		'tmnt_ladder_cmpt',
		'tmnt_ladder_cmpt_none',
		'tmnt_ladder_cmpt_bot',
		'tmnt_ladder_allchll_none',
		'tmnt_ladder_allchll_bot',
		'tmnt_ladder_allchll_top',
		'tmnt_ladder_allchll',
		'tmnt_ladder_tlchll_top',
		'tmnt_ladder_chll',
		'tmnt_ladder_chll_bot',
		'tmnt_ladder_tmnts',
		'facebook_likebutton',
		'memberaction_dropdown',
		'tmnt_ladder_allchll2',
		'tmnt_memberaction_dropdown',
		'tmnt_ladder_display',
		'tmnt_ladder_racemode',
		'tmnt_cstats',
		'tmnt_league_format2'
	),
	'none' => array(
		'tmnt_ladder_cmpt_top',
		'tmnt_ladder_cmpt',
		'tmnt_ladder_cmpt_none',
		'tmnt_ladder_cmpt_bot',
		'tmnt_ladder_allchll_none',
		'tmnt_ladder_allchll_bot',
		'tmnt_ladder_allchll_top',
		'tmnt_ladder_allchll',
		'tmnt_ladder_tlchll_top',
		'memberaction_dropdown',
		'tmnt_memberaction_dropdown',
		'tmnt_ladder_chll',
		'tmnt_ladder_chll_bot',
		'tmnt_ladder_tmnts',
		'facebook_likebutton',
		'tmnt_ladder_display',
		'tmnt_ladder_list_top',
		'tmnt_ladder_list_bot',
		'tmnt_ladder_list',
		'tmnt_ladder_noladders',
		'tmnt_ladder_list_rm',
		'tmnt_cat',
		'tmnt_ladder_allchll2',
		'tmnt_random_torp',
		'tmnt_ladder_racemode',
		'tmnt_cstats',
		'tmnt_league_format2'
	)
);

require_once('./global.php');
require_once(DIR . '/includes/functions.php');
require_once(DIR . '/includes/functions_tal.php');

($hook = vBulletinHook::fetch_hook('tll_ladders_start')) ? eval($hook) : false;

$navbits = construct_navbits(array(
	'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
	'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase[ladders],
	'' => construct_phrase('Error')
));
$navbar = render_navbar_template($navbits);

// #############################################################################

if ($_REQUEST['do'] == 'viewmatch')
{
	$mid = $vbulletin->input->clean_gpc('g', 'mid', TYPE_UINT);
	$vbulletin->url = "ladder_match.php?do=viewmatch&mid=".$mid;
	eval(print_standard_redirect('redirect_newpage'));
}

// #############################################################################

if ($_REQUEST['do'] == 'ladder_player_image')
{
	$iwidth = $vbulletin->input->clean_gpc('g', 'w', TYPE_UINT);
	if (!$iwidth)
	{
		$iwidth = 250;
	}
	$iheight = $vbulletin->input->clean_gpc('g', 'h', TYPE_UINT);
	if (!$iheight)
	{
		$iheight = 90;
	}
	$userid = $vbulletin->input->clean_gpc('g', 'u', TYPE_UINT);
	$f = $vbulletin->input->clean_gpc('g', 'f', TYPE_UINT);
	$lid = $vbulletin->input->clean_gpc('g', 'l', TYPE_UINT);
	$noavatar = $vbulletin->input->clean_gpc('g', 'noavatar', TYPE_UINT);
	$player = $vbulletin->db->query_first("
		SELECT players.*, users.*, ladders.title AS laddertitle, users.avatarrevision AS avatarrevision, avatar.avatarpath AS avatarpath, NOT ISNULL(customavatar.userid) AS hascustom, customavatar.dateline AS avatardateline, customavatar.width AS avwidth, customavatar.height AS avheight, teams.teamname, teams.teamlogo
		FROM " . TABLE_PREFIX . "tmnt_ladder_players AS players
		LEFT JOIN " . TABLE_PREFIX . "user AS users
			ON (users.userid = players.userid)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS teams
			ON (teams.teamid = players.userid)	
		LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders
			ON (players.lid = ladders.id)
		LEFT JOIN " . TABLE_PREFIX . "avatar AS avatar
			ON (avatar.avatarid = users.avatarid)
		LEFT JOIN " . TABLE_PREFIX . "customavatar AS customavatar
			ON (customavatar.userid = users.userid)
		WHERE players.userid = '$userid'
			AND players.lid = '$lid'
			AND players.active = 1
	");
	if ($player['pot'])
	{
		$player['username'] = $player['teamname'];
	}
	$countp = $vbulletin->db->query_first("SELECT COUNT(*) AS count FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE rank > '".$player['rank']."' AND active = 1 AND lid = '".$lid."'");
	$player['position'] = $countp['count'] + 1;
	$player['position'] = process_position($player['position']);
	if (!$noavatar)
	{
		if (!$player['pot'])
		{
			if (!empty($player['avatarpath']))
			{
				$player['avatarurl'] = $player['avatarpath'];
			}
			elseif ($player['hascustom'])
			{
				$avatarurl = array('hascustom' => 1);
				if ($vbulletin->options['usefileavatar'])
				{
					$player['avatarurl'] = $vbulletin->options['avatarurl'] . ($thumb ? '/thumbs' : '') . "/avatar{$player['userid']}_{$player['avatarrevision']}.gif";
				}
				else
				{
					$player['avatarurl'] = $vbulletin->options['bburl']."/image.php?u=$player[userid]&amp;dateline=$player[avatardateline]" . ($thumb ? '&type=thumb' : '') ;
				}
			}
		}
		else
		{
			$player['avatarurl'] = $player['teamlogo'];
		}
		if (empty($player['avatarurl']))
		{
			$player['avatarurl'] = vB_Template_Runtime::fetchStyleVar('imgdir_misc') . '/unknown.gif';
		}
		$player['image'] = $player['avatarurl'];
		$size = getimagesize($player['image']);
		$my_img = imagecreate($iwidth, $iheight);
		list($width, $height) = $size;
		if($size[2]==3)
		{
			$av = imagecreatefrompng($player['image']);
		}
		elseif ($size[2]==2)
		{
			$av = imagecreatefromjpeg($player['image']);
		}
		elseif ($size[2]==1)
		{
			$av = imagecreatefromgif($player['image']);
		}
		$minus = 0;
		$minus2 = 0;
	}
	else
	{
		$minus = -10;
		$minus2 = -30;
		$my_img = imagecreate($iwidth, $iheight);
	}
	$bgurl = $vbulletin->input->clean_gpc('g', 'bgurl', TYPE_NOHTML);
	if ($bgurl)
	{
		$imgattb = getimagesize($bgurl);
	}
	if (is_array($imgattb))
	{
		imagedestroy($my_img);
		list($bwidth, $bheight) = $imgattb;
		$type = $imgattb['mime'];
		if ($type == 'image/png')
		{
			$my_img = @imagecreatefrompng($bgurl);
		}
		elseif ($type == 'image/jpeg')
		{
			$my_img = @imagecreatefromjpeg($bgurl);
		}
		elseif ($type == 'image/gif')
		{
			$my_img = @imagecreatefromgif($bgurl);
		}
		if ($my_img && ($bwidth != $iwidth OR $bheight != $iheight))
		{
			$im20 = imagecreatetruecolor($iwidth, $iheight);
			imagecopyresampled($im20,$my_img,0,0,0,0,$iwidth,$iheight,$bwidth,$bheight); 
			imagedestroy($my_img);
			$my_img = $im20;
		}
	}
	$max = 45;
	$newwidth = $width;
	$newheight = $height;
	if ($newwidth > $max)
	{
		$ratio = $max / $newwidth;
		$newwidth = $newwidth * $ratio;
		$newheight = $newheight * $ratio;
	}
	if ($newheight > $max)
	{
		$ratio = $max / $newheight;
		$newwidth = $newwidth * $ratio;
		$newheight = $newheight * $ratio;
	}
	/*image*/
	function html2rgb($color)
	{
		if ($color[0] == '#')
			$color = substr($color, 1);

		if (strlen($color) == 6)
			list($r, $g, $b) = array($color[0].$color[1],
									 $color[2].$color[3],
									 $color[4].$color[5]);
		elseif (strlen($color) == 3)
			list($r, $g, $b) = array($color[0].$color[0], $color[1].$color[1], $color[2].$color[2]);
		else
			return false;

		$r = hexdec($r); $g = hexdec($g); $b = hexdec($b);

		return array($r, $g, $b);
	}
	$bg = $vbulletin->input->clean_gpc('g', 'bg', TYPE_NOHTML);
	$c = $vbulletin->input->clean_gpc('g', 'c', TYPE_NOHTML);
	
	if (!$bg)
	{
		$bg = 'FFFFFF';
	}
	if (!$c)
	{
		$c = '000000';
	}
	$border = $vbulletin->input->clean_gpc('g', 'b', TYPE_NOHTML);
	if (!$border)
	{
		$border = $bg;
	}
	$bg = html2rgb($bg);
	$c = html2rgb($c);
	$background = imagecolorallocate($my_img, $bg['0'], $bg['1'], $bg['2']);
	//$text_colour = imagecolorallocate($my_img, 199, 199, 199);
	$text_colour = imagecolorallocate($my_img, $c['0'], $c['1'], $c['2']);
	$line_colour = imagecolorallocate($my_img, 233, 233, 233);
	
	$border = html2rgb($border);
	$border_colour = imagecolorallocate($my_img, $border['0'], $border['1'], $border['2']);
	$bw = $vbulletin->input->clean_gpc('g', 'bw', TYPE_UINT);
	if (!$bw)
	{
		$bw = 1;
	}
	imagesetthickness($my_img, $bw);
	imagerectangle($my_img, 0, 0, $iwidth-1, $iheight-1, $border_colour);
	//imagestring(resource $image , int $font , int $x , int $y , string $string , int $color)
	//imageline(resource $image , int $x1 , int $y1 , int $x2 , int $y2 , int $color)
	//imageline($my_img, 30, 45, 165, 45, $line_colour);
	
	//imageline($my_img, $newwidth+20, 0, 300, 0, $line_colour);
	//imagestring($my_img, 5, 10, 10, $player['position'], $text_colour);
	if ($player['username'])
	{
		if (!$_REQUEST['simple'])
		{
			imagestring($my_img, 5, 10, 10, $player['username']."", $text_colour);
			imagestring($my_img, 4, $minus2+130, 30, html_entity_decode($player['laddertitle'],ENT_COMPAT,"UTF-8"), $text_colour);
			imagestring($my_img, 4, $minus+$newwidth+20, 30, 'Ladder:', $text_colour);
			imagestring($my_img, 4, $minus+$newwidth+20, 50, 'Rank:', $text_colour);
			imagestring($my_img, 4, $minus2+130, 50, $player['position'], $text_colour);
			//imagestring($my_img, 4, 15, 70, 'Elo Rating:', $text_colour);
			//imagestring($my_img, 4, 120, 70, $player['rank'], $text_colour);
			if ($_REQUEST['elo'])
			{
				imagestring($my_img, 4, $minus+$newwidth+20, 70, 'Elo Rating:', $text_colour);
				imagestring($my_img, 4, $minus2+175, 70, $player['rank'], $text_colour);
			}
			else
			{
				imagestring($my_img, 4, $minus+$newwidth+20, 70, 'XP:', $text_colour);
				imagestring($my_img, 4, $minus2+130, 70, $player['xp'], $text_colour);
			}
			if ($av)
			{
				//imagecopyresized($my_img, $av, $iwidth-$max-10, 10, 0, 0, $newwidth, $newheight, $width, $height);//top right
				imagecopyresized($my_img, $av, 10, 35, 0, 0, $newwidth, $newheight, $width, $height);//bottom left
			}
		}
		else
		{
			imagestring($my_img, 4, 5, 5, $player['wins']."/".$player['draws']."/".$player['loses'], $text_colour);
		}		
	}
	else
	{
		imagestring( $my_img, 5, 10, 10, "null", $text_colour );
		//debug
		//imagestring( $my_img, 4, 20, 30, 'lid='.$lid, $text_colour );
		//imagestring( $my_img, 4, 20, 50, 'userid='.$userid, $text_colour );
	}
	header("Content-Disposition: inline; filename=\"image.png\";");
	header('Cache-control: max-age=31536000');
	header('Expires: ' . gmdate('D, d M Y H:i:s', (TIMENOW + 31536000)) . ' GMT');
	header('Last-Modified: ' . gmdate('D, d M Y H:i:s', $player['latime']) . ' GMT');
	header('Content-transfer-encoding: binary');
	header('ETag: "' . $player['latime'] . '-' . $u . '"');
	header("Content-type: image/png");
	imagepng($my_img);
	imagecolordeallocate($line_color);
	imagecolordeallocate($text_color);
	imagecolordeallocate($background);
	imagedestroy($my_img);
	exit;
}

// #############################################################################

if ($_REQUEST['do'] == 'disable_warlight')
{
	if (!$vbulletin->userinfo['userid'] OR !$vbulletin->options['tmnt_premium'] OR !$vbulletin->options['tmnt_warlights'])
	{
		print_no_permission();
	}
	$lid = $vbulletin->input->clean_gpc('g', 'lid', TYPE_UINT);
	$sh = $vbulletin->input->clean_gpc('g', 'sh', TYPE_UINT);
	if ($lid <= 0)
	{
		print_no_permission();
	}
	$time = TIMENOW-60;
	$ladderinfo = fetch_ladderinfo($lid);
	if (!$ladderinfo)
	{
		print_no_permission();
	}
	require_once(DIR . '/includes/functions_tll_prem.php');
	if ($ladderinfo['pot'])
	{
		$teamid = $vbulletin->input->clean_gpc('g', 'teamid', TYPE_UINT);
		$t = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_members WHERE leader='1' AND teamid = '$teamid'");
		if (!$t)
		{
			print_no_permission();
		}
	}
	tll_update_warlight($vbulletin->userinfo['userid'],$lid,$time,$ladderinfo['pot'],$teamid);
	$vbulletin->url = "ladder_match.php?do=matchfinder";
	if ($sh)
	{
		$vbulletin->url = "ladders.php?do=view&amp;id=".$lid."&amp;sh=".$sh;
	}
	eval(print_standard_redirect('redirect_disabledwarlight'));
}

// #############################################################################

if ($_REQUEST['do'] == 'enable_warlight')
{
	if (!$vbulletin->userinfo['userid'] OR !$vbulletin->options['tmnt_premium'] OR !$vbulletin->options['tmnt_warlights'])
	{
		print_no_permission();
	}
	$lid = $vbulletin->input->clean_gpc('g', 'lid', TYPE_UINT);
	$from = $vbulletin->input->clean_gpc('g', 'from', TYPE_NOHTML);
	if ($lid <= 0)
	{
		print_no_permission();
	}
	$time = TIMENOW + 3600;
	$ladderinfo = fetch_ladderinfo($lid);
	if (!$ladderinfo)
	{
		print_no_permission();
	}
	if ($ladderinfo['pot'])
	{
		$teamid = $vbulletin->input->clean_gpc('g', 'teamid', TYPE_UINT);
		if ($teamid)
		{
			require_once(DIR . '/includes/functions_tll_prem.php');
			tll_update_warlight($teamid, $lid, $time, 1);
		}
		else
		{
			$array = array();
			$team_query = $vbulletin->db->query_read("
				SELECT p.*, t.teamname, m.leader, t.teamid
				FROM " . TABLE_PREFIX . "tmnt_ladder_players AS p
				LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS t
					ON (p.userid = t.teamid)
				LEFT JOIN " . TABLE_PREFIX . "tmnt_members AS m
					ON (t.teamid = m.teamid AND m.userid = '$thisuserid')
				WHERE p.pot = 1
					AND m.leader = 1
					AND p.lid = '$lid'
					AND m.userid = '$thisuserid'
			");
			while($row = $vbulletin->db->fetch_array($team_query))
			{
				$array[] = $row;
			}
			if (empty($array))
			{
				$errormessage = 'You do not have any teams in this ladder.';
				eval(standard_error($errormessage));
			}
			$templater = vB_Template::create('tmnt_enablelivematch_chooseteam');
				$templater->register('tmntp', $tmntp);
				$templater->register('ladder', $ladderinfo);
				$templater->register('from', $from);
				$templater->register('tll_array', $array);
			$tlhtml = $templater->render();
			$navbits = array(
				'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
				'ladders.php' . $vbulletin->session->vars['sessionurl_q'] . '?do=view' . "&amp;id=$lid" => $ladderinfo['title'],
				'' => construct_phrase('Enable Live Match')
			);
			$navbar = render_navbar_template(construct_navbits($navbits));
			$templater = vB_Template::create('tmnt_shell');
			$templater->register_page_templates();
			$templater->register('navbar', $navbar);
			$templater->register('headinclude', $headinclude);
			$templater->register('pagetitle', $pagetitle);
			$templater->register('tlhtml', $tlhtml);
			$templater->register('modname', $modname);
			$templater->register('header', $header);
			$templater->register('footer', $footer);
			$templater->register('tmntp', $tmntp);
			$templater->register('tmnt_version', $tmnt_version);
			print_output($templater->render());	
		}
	}
	else
	{
		require_once(DIR . '/includes/functions_tll_prem.php');
		tll_update_warlight($vbulletin->userinfo['userid'],$lid,$time);
	}
	if ($_REQUEST['from'] == 'competitions_frontpage')
	{
		$vbulletin->url = "competitions.php";
	}
	elseif ($_REQUEST['from'] == 'ladders_warlights')
	{
		$vbulletin->url = "ladders.php?do=warlights";
	}
	elseif ($_REQUEST['from'] == 'ladders_matchfinder')
	{
		$vbulletin->url = "ladder_match.php?do=matchfinder";
	}
	elseif ($_REQUEST['from'] == 'ladders_view5')
	{
		$vbulletin->url = "ladders.php?do=view&amp;id=".$lid."&amp;sh=5";
	}
	else
	{
		$vbulletin->url = "ladders.php?do=view&amp;id=".$lid;
	}
	eval(print_standard_redirect('redirect_enabledwarlight'));
}

// #############################################################################

if ($_REQUEST['do'] == 'optout')
{
	$u = $vbulletin->userinfo['userid'];
	$vbulletin->input->clean_array_gpc('g', array(
		'lid' => TYPE_UINT,
		'round' => TYPE_UINT,
	));
	if (!$u OR !$vbulletin->GPC['lid'] or !$vbulletin->GPC['round'])
	{
		print_no_permission();
	}
	$ladder = $vbulletin->db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_ladders
		WHERE id = '".$vbulletin->GPC['lid']."'
	");
	$p = $vbulletin->db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_ladder_players
		WHERE lid = '".$vbulletin->GPC['lid']."'
			AND userid = '$u'
	");
	if (!$ladder || !$ladder['allow_optouts'] || !$ladder['racemode'] || !$p)
	{
		print_no_permission();
	}
	if ($vbulletin->GPC['round'] > $ladder['racemode_rounds'])
	{
		print_no_permission();
	}
	$p['optout_rounds'] = explode(',',$p['optout_rounds']);
	if (!in_array($vbulletin->GPC['round'], $p['optout_rounds']))
	{
		$p['optout_rounds'][] = $vbulletin->GPC['round'];
		$p['optout_rounds'] = implode(',', $p['optout_rounds']);
		$vbulletin->db->query_write("
			UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
			SET optout_rounds = '".$p['optout_rounds']."'
			WHERE lid = '".$vbulletin->GPC['lid']."'
				AND userid = '$u'
		");
	}
	$ladder['url'] = tll_seo('ladder', $ladder['id'], $ladder['title']);
	$vbulletin->url = "ladders.php".$ladder['url']."&sh=1&round=".$vbulletin->GPC['round']."&group=".$p['group'];	
	eval(print_standard_redirect('redirect_insertladder'));
}

// #############################################################################

if ($_REQUEST['do'] == 'warlights')
{
	if (!$tmntp['canviewladder'] OR !$vbulletin->userinfo['userid'] OR !$vbulletin->options['tmnt_warlights'])
	{
		print_no_permission();
	}
	$array3 = $array2 = $array = array();
	$players_query = $vbulletin->db->query_read("
		SELECT p.*, l.title AS laddertitle, u.username
		FROM " . TABLE_PREFIX . "tmnt_ladder_players AS p
		LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS l
			ON (p.lid = l.id)
		LEFT JOIN " . TABLE_PREFIX . "user AS u
			ON (p.userid = u.userid)
		WHERE p.warlight > '".TIMENOW."'
			AND p.pot = 0
			AND p.userid != '".$vbulletin->userinfo['userid']."'
		LIMIT 0, 10
	");
	while($player = $vbulletin->db->fetch_array($players_query))
	{
		$player['ladderurl'] = tll_seo('ladder', $player['lid'], $player['laddertitle']);
		$array[] = $player;
	}
	if ($vbulletin->userinfo['userid'])
	{
		$players_query = $vbulletin->db->query_read("
			SELECT p.*, l.title AS laddertitle
			FROM " . TABLE_PREFIX . "tmnt_ladder_players AS p
			LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS l
				ON (p.lid = l.id)
			WHERE p.userid = '".$vbulletin->userinfo['userid']."'
				AND p.pot = 0
				AND l.league = 0
				AND l.archive = 0
				AND p.active = 1
		");
		while($player = $vbulletin->db->fetch_array($players_query))
		{
			$player['ladderurl'] = tll_seo('ladder', $player['lid'], $player['laddertitle'], 1);
			if ($player['warlight'] < TIMENOW)
			{
				$array2[] = $player;
			}
			else
			{
				$array3[] = $player;
			}
		}
	}
	$templater = vB_Template::create('tmnt_warlights');
		$templater->register('hide', $hide);
		$templater->register('tll_array', $array);
		$templater->register('tll_array2', $array2);
		$templater->register('tll_array3', $array3);
	$tlhtml .= $templater->render();
	$navbits = array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => construct_phrase($vbphrase[ladders])
	);
	$navbits[''] = construct_phrase($vbphrase['tmnt_war_lights']);
	$navbar = render_navbar_template(construct_navbits($navbits));
	$templater = vB_Template::create('tmnt_shell');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('headinclude', $headinclude);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('tlhtml', $tlhtml);
		$templater->register('modname', $modname);
		$templater->register('header', $header);
		$templater->register('footer', $footer);
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}


// #############################################################################

if ($_REQUEST['do'] == 'pm')
{
	if (!$show['member'] || !$tmntp['canviewladder']) {
		print_no_permission();
	}
    $lid = $id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	if (!$id)
	{
		$errormessage = $vbphrase['error_invalid_ladder'];
        eval(standard_error($errormessage));
	}
	require_once('./includes/functions_databuild.php');
	require_once(DIR . '/includes/functions_tll_pms.php');
	list($ladder, $message) = tll_default_ladder_pm($lid);
	$fromuserid = $vbulletin->userinfo['userid'];
	$fromusername = $vbulletin->userinfo['username'];
	$recipients = $vbulletin->userinfo['username'];
	$title = $ladder['title'];
	//global $vbulletin, $botpermissions;
	$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_ARRAY);
		$pmdm->set('fromuserid', $fromuserid);
		$pmdm->set('fromusername', $fromusername);
		$pmdm->set('title', $title);
		$pmdm->set('message', $message);
		$pmdm->set_recipients($recipients, $botpermissions);
		$pmdm->set('dateline', TIMENOW); 
		$pmdm->overridequota = true;
		$errors = $pmdm->errors;
		if ($errors) {
			foreach ($errors as $error) {
				$errorss .= $error. "<br />";
			}
			$errormessage = $errorss;
			eval(standard_error($errormessage));
		}
		$pmdm->save();
		unset($pmdm);
	$vbulletin->url = "ladders.php?do=view&id=$id";
	eval(print_standard_redirect('redirect_ladderpm'));
}

// #############################################################################

if ($_POST['do'] == 'insertpmcmpt')
{
    $id = $vbulletin->input->clean_gpc('p', 'id', TYPE_UINT);
	$ladder = $vbulletin->db->query_first("SELECT cr_userid FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id=$id ");
	if ($ladder['userid'] != $thisuserid) {
	if (!$tmntp['caneditladder']) {
		print_no_permission();
	} }
	$title = $vbulletin->input->clean_gpc('p', 'title', TYPE_NOHTML);
	$title = addslashes($title);
		if (!$title)
		{
			$errormessage = $vbphrase[error_invalid_title];
        	eval(standard_error($errormessage));
		}
	$vbulletin->input->clean_array_gpc('p', array(
		'message'      => TYPE_STR,
		'wysiwyg'			 => TYPE_BOOL,
		'recipients'     => TYPE_STR,
	));
	if ($vbulletin->GPC['wysiwyg'] && $vbulletin->options['simpleversion'] < 414)
	{
		require_once(DIR . '/includes/functions_wysiwyg.php');
		$description = convert_wysiwyg_html_to_bbcode($vbulletin->GPC['message'], 1);
	}
	else if ($vbulletin->GPC['wysiwyg'])
	{
		require_once(DIR . '/includes/class_wysiwygparser.php');
		$html_parser = new vB_WysiwygHtmlParser($vbulletin);
		$description = $html_parser->parse_wysiwyg_html_to_bbcode($vbulletin->GPC['message']);
	}
	else
	{
		$description = $vbulletin->GPC['message'];
	}
	if (!$description)
	{
		$errormessage = $vbphrase[error_invalid_message];
		eval(standard_error($errormessage));
	}
	$message = $description;
	$recipients = $vbulletin->GPC['recipients'];
	$fromuserid = $thisuserid;
	$fromusername = $thisusername;
	require_once('./includes/functions_databuild.php');
	global $vbulletin, $botpermissions;
	$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_ARRAY);
		$pmdm->set('fromuserid', $fromuserid);
		$pmdm->set('fromusername', $fromusername);
		$pmdm->set('title', $title);
		$pmdm->set('message', $message);
		$pmdm->set_recipients($recipients, $botpermissions);
		$pmdm->set('dateline', TIMENOW);
		$pmdm->overridequota = true;
		$errors = $pmdm->errors;
		if ($errors) {
			foreach ($errors as $error) {
				$errorss .= $error. "<br />";
			}
			$errormessage = $errorss;
			eval(standard_error($errormessage));
		}
		$pmdm->save();
		unset($pmdm);
	$vbulletin->url = "ladders.php?do=view&id=$id";
	eval(print_standard_redirect('redirect_pmcmpt'));
}

// #############################################################################

if ($_REQUEST['do'] == 'pmcmpt')
{
    if (!$show['member'] || !$tmntp['canviewladder']) {
		print_no_permission();
	}
    $lid = $id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	if (!$id)
	{
		$errormessage = $vbphrase['error_invalid_ladder'];
        eval(standard_error($errormessage));
	}
	require_once('./includes/functions_databuild.php');
	require_once(DIR . '/includes/functions_tll_pms.php');
	list($ladder, $message) = tll_default_ladder_pm($lid);
	$fromuserid = $vbulletin->userinfo['userid'];
	$fromusername = $vbulletin->userinfo['username'];
	$recipients = $vbulletin->userinfo['username'];
	$title = $ladder['title'];
	$user_names = $vbulletin->db->query_read("SELECT username FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid = '$id' AND userid != 0 ");
	$pmto_users = array();
        while ($name = $vbulletin->db->fetch_array($user_names))
        {
            $pmto_users[] = $name['username'];
        }
        $vbulletin->db->free_result($user_names); 
	$recipients = implode(' ; ', $pmto_users);  
	$show['sendmultiple'] = true;
	$show['parseurl'] = $vbulletin->options['privallowbbcode'];
	require_once(DIR . '/includes/functions_editor.php');
	if ($vbulletin->options['simpleversion'] < 414)
	{
		$editorid = construct_edit_toolbar($message, 0, 'nonforum', iif($vbulletin->options['privallowsmilies'], 1, 0));
	}
	else
	{
		$editorid = construct_edit_toolbar($message);
	}
	$templater = vB_Template::create('tmnt_newpm');
		$templater->register('ladder', $ladder);
		$templater->register('description', $ladder['description']);
		$templater->register('noplayers', $ladder['noplayers']);
		$templater->register('id', $id);
		$templater->register('fromuserid', $fromuserid);
		$templater->register('fromusername', $fromusername);
		$templater->register('title', $title);
		$templater->register('date', $date);
		$templater->register('editorid', $editorid);
		$templater->register('messagearea', $messagearea);
		$templater->register('postpreview', $postpreview);
		$templater->register('recipients', $recipients);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' => $vbphrase['ladders'],
		'ladders.php' . $ladder['url'] => $title,
		'' => construct_phrase($vbphrase['tmnt_pmcmpt'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_POST['do'] == 'updateavatar')
{
	if (!$tmntp['canviewladder'])
	{
		print_no_permission();
	}
require_once(DIR . '/tll_modules/tll_editavatar.php');
	$userid = $vbulletin->input->clean_gpc('p', 'userid', TYPE_UINT);
	$lid = $vbulletin->input->clean_gpc('p', 'lid', TYPE_UINT);
	$delete = $vbulletin->input->clean_gpc('p', 'delete', TYPE_UINT);
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id = '$lid' ");
	$player = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid = '$lid' AND userid = '$userid' ");
	if (!$player || !$ladder)
	{
		print_no_permission();
	}
	if ($ladder['pot'])
	{
		$team = true;
		$isleader = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_members WHERE teamid = '$userid' AND leader = '1' AND userid = '".$vbulletin->userinfo['userid']."'");
		if (!$isleader)
		{
			print_no_permission();
		}
	}
	else
	{
		$team = false;
		if ($vbulletin->userinfo['userid'] != $userid)
		{
			print_no_permission();
		}
	}
	if ($delete)
	{
		if (file_exists($player['avatar']))
		{
			unlink($player['avatar']);
		}
		$player['avatar'] = '';
	}
	$ladder['url'] = tll_seo('ladder', $lid, $ladder['title']);
	$avatar = $vbulletin->input->clean_gpc('f', 'avatar', TYPE_FILE);
	$uploadDir = 'images/ladder_avatars/';
	$fileName = $avatar['name'];
	$tmpName  = $avatar['tmp_name'];
	if ($tmpName != '')
	{
		if ($avatar['error'])
		{
			$errormessage = 'Error: '.$avatar['error'];
			eval(standard_error($errormessage));
		}
		$randName = md5(rand() * time());
		$ext      = substr(strrchr($fileName, "."), 1);
		$imgexts  = array('jpg', 'jpeg', 'png', 'gif');
		if (!in_array(strtolower($ext), $imgexts)) {
			$errormessage = 'Invalid file extension.';
			eval(standard_error($errormessage));
		}
		@img_resize($tmpName, 100, 100, $uploadDir, $randName.".jpg");
		$filePath = $uploadDir.$randName.".jpg";
		if (!file_exists($filePath))
		{
			$filePath = $player['avatar'];
		}
	}
	else
	{
		$filePath = $player['avatar'];
	}
	query_update_ladder_player_avatar($lid, $userid, $filePath);
	if ($player['avatar'] != $filePath AND file_exists($player['avatar']))
	{
		unlink($player['avatar']);
	}
	$vbulletin->url = "ladders.php".$ladder['url'];	
	eval(print_standard_redirect('redirect_updatedavatar'));
}

// #############################################################################

if ($_POST['do'] == 'updatebadge')
{
	if (!$tmntp['canviewladder'])
	{
		print_no_permission();
	}
require_once(DIR . '/tll_modules/tll_editbadge.php');
	$userid = $vbulletin->input->clean_gpc('p', 'userid', TYPE_UINT);
	$lid = $vbulletin->input->clean_gpc('p', 'lid', TYPE_UINT);
	$delete = $vbulletin->input->clean_gpc('p', 'delete', TYPE_UINT);
	$badge_text = $vbulletin->input->clean_gpc('p', 'badge_text', TYPE_NOHTML);
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id = '$lid' ");
	$player = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid = '$lid' AND userid = '$userid' ");
	if (!$player || !$ladder)
	{
		print_no_permission();
	}
	if ($ladder['pot'])
	{
		$team = true;
		$isleader = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_members WHERE teamid = '$userid' AND leader = '1' AND userid = '".$vbulletin->userinfo['userid']."'");
		if (!$isleader)
		{
			print_no_permission();
		}
	}
	else
	{
		$team = false;
		if ($vbulletin->userinfo['userid'] != $userid)
		{
			print_no_permission();
		}
	}
	if ($delete)
	{
		if (file_exists($player['badge']))
		{
			unlink($player['badge']);
		}
		$player['badge'] = '';
	}
	$ladder['url'] = tll_seo('ladder', $lid, $ladder['title']);
	$badge = $vbulletin->input->clean_gpc('f', 'badge', TYPE_FILE);
	$uploadDir = 'images/ladder_badges/';
	$fileName = $badge['name'];
	$tmpName  = $badge['tmp_name'];
	if ($tmpName != '')
	{
		if ($badge['error'])
		{
			$errormessage = 'Error: '.$badge['error'];
			eval(standard_error($errormessage));
		}
		$randName = md5(rand() * time());
		$ext = substr(strrchr($fileName, "."), 1);
		$imgexts  = array('jpg', 'jpeg', 'png', 'gif');
		if (!in_array(strtolower($ext), $imgexts)) {
			$errormessage = 'Invalid file extension.';
			eval(standard_error($errormessage));
		}
		@img_resize($tmpName, 150, 150, $uploadDir, $randName.".jpg");
		$filePath = $uploadDir.$randName.".jpg";
		if (!file_exists($filePath))
		{
			$filePath = $player['badge'];
		}
	}
	else
	{
		$filePath = $player['badge'];
	}
	query_update_ladder_player_badge($lid, $userid, $filePath);
	if ($player['badge'] != $filePath AND file_exists($player['badge']))
	{
		unlink($player['badge']);
	}
	$vbulletin->url = "ladders.php".$ladder['url'];	
	eval(print_standard_redirect('redirect_updatedbadge'));
}

// #############################################################################

if ($_REQUEST['do'] == 'editavatar')
{
	if (!$tmntp['canviewladder'])
	{
		print_no_permission();
	}
require_once(DIR . '/tll_modules/tll_editavatar.php');
	$userid = $vbulletin->input->clean_gpc('g', 'userid', TYPE_UINT);
	$lid = $vbulletin->input->clean_gpc('g', 'lid', TYPE_UINT);
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id = '$lid' ");
	$player = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid = '$lid' AND userid = '$userid' ");
	if (!$player || !$ladder)
	{
		print_no_permission();
	}
	if ($ladder['pot'])
	{
		$team = true;
		$isleader = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_members WHERE teamid = '$userid' AND leader = '1' AND userid = '".$vbulletin->userinfo['userid']."'");
		if (!$isleader)
		{
			print_no_permission();
		}
	}
	else
	{
		$team = false;
		if ($vbulletin->userinfo['userid'] != $userid)
		{
			print_no_permission();
		}
	}
	$ladder['url'] = tll_seo('ladder', $lid, $ladder['title'], 1);
	$templater = vB_Template::create('tmnt_ladder_editavatar');
		$templater->register('tmntp', $tmntp);
		$templater->register('player', $player);
		$templater->register('ladder', $ladder);
		$templater->register('team', $team);
	$tlhtml .= $templater->render();
	if ($_REQUEST['ajax'])
	{
		print_r($tlhtml);
		exit;
	}
	$navbits = array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => construct_phrase($vbphrase[ladders]),
		'ladders.php' . $ladder['url']  => construct_phrase($ladder['title'])
	);
	$navbits[''] = construct_phrase($vbphrase['ladder_editavatar']);
	$navbar = render_navbar_template(construct_navbits($navbits));
	$templater = vB_Template::create('tmnt_shell');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('headinclude', $headinclude);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('tlhtml', $tlhtml);
		$templater->register('modname', $modname);
		$templater->register('header', $header);
		$templater->register('footer', $footer);
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'editbadge')
{
	if (!$tmntp['canviewladder'])
	{
		print_no_permission();
	}
require_once(DIR . '/tll_modules/tll_editbadge.php');
	$userid = $vbulletin->input->clean_gpc('g', 'userid', TYPE_UINT);
	$lid = $vbulletin->input->clean_gpc('g', 'lid', TYPE_UINT);
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id = '$lid' ");
	$player = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid = '$lid' AND userid = '$userid' ");
	if (!$player || !$ladder)
	{
		print_no_permission();
	}
	if ($ladder['pot'])
	{
		$team = true;
		$isleader = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_members WHERE teamid = '$userid' AND leader = '1' AND userid = '".$vbulletin->userinfo['userid']."'");
		if (!$isleader)
		{
			print_no_permission();
		}
	}
	else
	{
		$team = false;
		if ($vbulletin->userinfo['userid'] != $userid)
		{
			print_no_permission();
		}
	}
	$ladder['url'] = tll_seo('ladder', $lid, $ladder['title'], 1);
	$templater = vB_Template::create('tmnt_ladder_editbadge');
		$templater->register('tmntp', $tmntp);
		$templater->register('player', $player);
		$templater->register('ladder', $ladder);
		$templater->register('team', $team);
	$tlhtml .= $templater->render();
	if ($_REQUEST['ajax'])
	{
		print_r($tlhtml);
		exit;
	}
	$navbits = array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => construct_phrase($vbphrase[ladders]),
		'ladders.php' . $ladder['url']  => construct_phrase($ladder['title'])
	);
	$navbits[''] = construct_phrase($vbphrase['ladder_editbadge']);
	$navbar = render_navbar_template(construct_navbits($navbits));
	$templater = vB_Template::create('tmnt_shell');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('headinclude', $headinclude);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('tlhtml', $tlhtml);
		$templater->register('modname', $modname);
		$templater->register('header', $header);
		$templater->register('footer', $footer);
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'claimcrown')
{
	if (!$tmntp['canviewladder'])
	{
		print_no_permission();
	}
	$userid = $vbulletin->input->clean_gpc('g', 'userid', TYPE_UINT);
	$lid = $vbulletin->input->clean_gpc('g', 'lid', TYPE_UINT);
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id = '$lid' ");
	if ($ladder['pot'])
	{
		$team = true;
		$userinfo = fetch_teaminfo($userid);
		$userinfo['team_members'] = array();
		$members = $vbulletin->db->query_read("
			SELECT members.*, user.*, user.username AS username, members.id AS id			
			FROM " . TABLE_PREFIX . "tmnt_members AS members
			LEFT JOIN " . TABLE_PREFIX . "user AS user
				ON(members.userid = user.userid)
			WHERE members.teamid = '$userid'
			ORDER BY members.leader DESC, members.coleader DESC, members.time ASC
		");
		while($member = $vbulletin->db->fetch_array($members))
		{
			if ($member['leader'])
			{
				$member['rank'] = 'Leader';
				if ($member['userid'] == $vbulletin->userinfo['userid'])
				{
					$isleader = true;
				}
			}
			elseif ($member['coleader'])
			{
				$member['rank'] = 'Co-Leader';
			}
			else
			{
				$member['rank'] = 'Member';
			}
			if ($prevmember && $prevmember['rank'] != $member['rank'])
			{
				$member['style'] = 'clear: left;';
			}
			$userinfo['team_members'][] = $member;
			$prevmember = $member;
		}
	}
	else
	{
		$team = false;
		$userinfo = fetch_userinfo($userid);
		if ($userid==$vbulletin->userinfo['userid'])
		{
			$isleader = true;
		}
	}
	$player = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE userid='$userid' AND lid='$lid' ");
	if (!$player OR !$isleader)
	{
		print_no_permission();
	}
	$crown_query = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE crown > 0 AND lid='$lid' AND active = 1 ");
	if ($crown_query['countrows'] == 0)
	{
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_players SET crown = 1 WHERE lid = '$lid' AND userid = '$userid' ");
	}
	$vbulletin->url = "ladders.php?do=view&id=$lid";
	eval(print_standard_redirect('redirect_claimedcrown'));
}

// #############################################################################

if ($_REQUEST['do'] == 'fsearch')
{
	if (!$tmntp['canviewladder'])
	{
		print_no_permission();
	}
	$lid = $vbulletin->input->clean_gpc('g', 'lid', TYPE_UINT);
	$sh = $vbulletin->input->clean_gpc('g', 'sh', TYPE_UINT);
	$uid = $vbulletin->input->clean_gpc('g', 'uid', TYPE_UINT);
	$group = $vbulletin->input->clean_gpc('g', 'group', TYPE_UINT);
	$round = $vbulletin->input->clean_gpc('g', 'round', TYPE_UINT);
	$ladder = fetch_ladderinfo($lid);
	if (!$ladder)
	{
		print_no_permission();
	}
	$team = false;
	if ($ladder['pot'])
	{
		$team = true;
	}
	$ladder['url'] = tll_seo('ladder', $ladder['id'], $ladder['title'], 1);
	$pq = $vbulletin->db->query_read("
		SELECT p.*, IF(p.pot, t.teamname, u.username) AS username
		FROM " . TABLE_PREFIX . "tmnt_ladder_players AS p
		LEFT JOIN " . TABLE_PREFIX . "user AS u
			ON (p.userid = u.userid AND p.pot = 0)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS t
			ON (t.teamid = p.userid AND p.pot > 0)
		WHERE p.lid = '$lid'
	");
	while($p = $vbulletin->db->fetch_array($pq))
	{
		if ($uid == $p['userid'])
		{
			$p['selected'] = ' selected="selected"';
		}
		$players[] = $p;
	}
	$ladder['selected']['group_'.$group] = ' selected="selected"';
	$ladder['selected']['round_'.$round] = ' selected="selected"';
	$templater = vB_Template::create('tmnt_ladder_fsearch');
		$templater->register('tmntp', $tmntp);
		$templater->register('ladder', $ladder);
		$templater->register('team', $team);
		$templater->register('players', $players);
		$templater->register('filter', $filter);
		$templater->register('uid', $uid);
		$templater->register('sh', $sh);
	$tlhtml .= $templater->render();
	if ($_REQUEST['ajax'])
	{
		$tlhtml = str_replace("history.go(-1);return false;","close_tll_popup()", $tlhtml);
		print_r($tlhtml);
		exit;
	}
	$navbits = array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => construct_phrase($vbphrase[ladders]),
		'ladders.php' . $ladder['url']  => construct_phrase($ladder['title'])
	);
	$navbits[''] = construct_phrase($vbphrase['search']);
	$navbar = render_navbar_template(construct_navbits($navbits));
	$templater = vB_Template::create('tmnt_shell');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('headinclude', $headinclude);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('tlhtml', $tlhtml);
		$templater->register('modname', $modname);
		$templater->register('header', $header);
		$templater->register('footer', $footer);
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'psearch')
{
	if (!$tmntp['canviewladder'])
	{
		print_no_permission();
	}
	$lid = $vbulletin->input->clean_gpc('g', 'lid', TYPE_UINT);
	$ladder = fetch_ladderinfo($lid);
	if (!$ladder)
	{
		print_no_permission();
	}
	$team = false;
	if ($ladder['pot'])
	{
		$team = true;
	}
	$cpp = $vbulletin->input->clean($vbulletin->options['tmnt_lcpp'], TYPE_UINT);
	$cmpts = $vbulletin->db->query_read("
		SELECT " . (!$team ? "user.*, " : "") . " players.*, players.userid AS userid
			" . (!$team ? ", user.avatarrevision AS avatarrevision, avatar.avatarpath AS avatarpath, NOT ISNULL(customavatar.userid) AS hascustom, customavatar.dateline AS avatardateline, customavatar.width AS avwidth, customavatar.height AS avheight, user.username AS username" : ", team.teamlogo AS avatarurl") . "
			" . (($vbulletin->options['tmnt_joinuf'] && !$team) ? ", userfield.*, usertextfield.* " : "") . ", players.rank AS rank
		FROM " . TABLE_PREFIX . "tmnt_ladder_players AS players
		" . (!$team ? "LEFT JOIN " . TABLE_PREFIX . "user AS user ON (players.userid = user.userid) LEFT JOIN " . TABLE_PREFIX . "avatar AS avatar ON(avatar.avatarid = user.avatarid) LEFT JOIN " . TABLE_PREFIX . "customavatar AS customavatar ON(customavatar.userid = user.userid) " : " LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS team ON (players.userid = team.teamid)") . "
		" . (($vbulletin->options['tmnt_joinuf'] && !$team) ? " LEFT JOIN " . TABLE_PREFIX . "userfield AS userfield ON (user.userid = userfield.userid) LEFT JOIN " . TABLE_PREFIX . "usertextfield AS usertextfield ON (usertextfield.userid = user.userid) " : "") . "
		WHERE players.lid=$lid 
			AND players.active=1
			" . ($hide == 'unranked' ? " AND (players.wins > 0 OR players.draws >0 OR players.loses > 0) " : "") . "
		ORDER BY 
			players.group ASC,
			" . ($vbulletin->options['tmnt_ladder_ranking'] == 'elo' ? "players.rank DESC," : "")
			. ($vbulletin->options['tmnt_ladder_ranking'] == 'xp' ? "players.xp DESC," : "") . "
			players.wins DESC,
			players.draws DESC,
			players.loses ASC,
			" . ($vbulletin->options['tmnt_ladder_ranking'] == 'elo' ? "players.xp DESC, " : "") . "
			players.totalpoints DESC,
			players.pointsagainst ASC
		");
		while($cmpt = $vbulletin->db->fetch_array($cmpts))
		{
			$c++;
			$tlh .= '<li><a href="'.$ladder['url'].'&amp;page='.ceil($c/$cpp).'">'.$cmpt['username']."</a></li>";
		}
	$templater = vB_Template::create('tmnt_ladder_psearch');
		$templater->register('tmntp', $tmntp);
		$templater->register('ladder', $ladder);
		$templater->register('tlh', $tlh);
		$templater->register('team', $team);
	$tlhtml .= $templater->render();
	if ($_REQUEST['ajax'])
	{
		$tlhtml = str_replace("history.go(-1);return false;","close_tll_popup()", $tlhtml);
		print_r($tlhtml);
		exit;
	}
	$navbits = array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => construct_phrase($vbphrase[ladders]),
		'ladders.php' . $ladder['url']  => construct_phrase($ladder['title'])
	);
	$navbits[''] = construct_phrase($vbphrase['search']);
	$navbar = render_navbar_template(construct_navbits($navbits));
	$templater = vB_Template::create('tmnt_shell');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('headinclude', $headinclude);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('tlhtml', $tlhtml);
		$templater->register('modname', $modname);
		$templater->register('header', $header);
		$templater->register('footer', $footer);
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'globalranks')
{
	if (!$tmntp['canviewladder'])
	{
		print_no_permission();
	}
	switch ($vbulletin->input->clean_gpc('g', 'rankby', TYPE_TEXT))
	{
		case 'elorating_avg':
			$rb = 'elorating_avg';
			$a = $vbulletin->db->query_read("
				SELECT u.username, u.userid, COUNT(p.rank) AS count, AVG(p.rank) AS glrank
				FROM " . TABLE_PREFIX . "tmnt_ladder_players AS p
				LEFT JOIN " . TABLE_PREFIX . "user AS u
					ON (u.userid = p.userid)
				WHERE p.pot = 0
					AND p.rank > 0
					AND p.active = 1
				GROUP BY p.userid
				ORDER BY glrank DESC
				LIMIT 0, 10
			");
			break;
		case 'elorating':
			$rb = 'elorating';
			$a = $vbulletin->db->query_read("
				SELECT u.username, u.userid, COUNT(p.rank) AS count, SUM(p.rank) AS glrank
				FROM " . TABLE_PREFIX . "tmnt_ladder_players AS p
				LEFT JOIN " . TABLE_PREFIX . "user AS u
					ON (u.userid = p.userid)
				WHERE p.pot = 0
					AND p.rank > 0
					AND p.active = 1
				GROUP BY p.userid
				ORDER BY glrank DESC
				LIMIT 0, 10
			");
			break;
		case 'xp':
		default:
			$rb = 'xp';
			$a = $vbulletin->db->query_read("
				SELECT u.username, u.userid, COUNT(p.xp) AS count, SUM(p.xp) AS glxp
				FROM " . TABLE_PREFIX . "tmnt_ladder_players AS p
				LEFT JOIN " . TABLE_PREFIX . "user AS u
					ON (u.userid = p.userid)
				WHERE p.pot = 0
					AND p.xp > 0
					AND p.active = 1
				GROUP BY p.userid
				ORDER BY glxp DESC
				LIMIT 0, 10
			");
			break;
	}
	$i = 1;
	$array = array();
	while($p = $vbulletin->db->fetch_array($a))
	{
		$p['pos'] = process_position($i, 1, 'vertical-align:super;');
		$p['glrank'] = number_format($p['glrank']);
		$array[] = $p;
		$i++;
	}
	$templater = vB_Template::create('tmnt_ladder_globalranks');
		$templater->register('tmntp', $tmntp);
		$templater->register('array', $array);
		$templater->register('rb', $rb);
		$templater->register('team', $team);
	$tlhtml .= $templater->render();
	$navbits = array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => construct_phrase($vbphrase[ladders]),
		''  => 'Global Ladders Rankings'
	);
	$navbar = render_navbar_template(construct_navbits($navbits));
	$templater = vB_Template::create('tmnt_shell');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('headinclude', $headinclude);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('tlhtml', $tlhtml);
		$templater->register('rb', $rb);
		$templater->register('modname', $modname);
		$templater->register('header', $header);
		$templater->register('footer', $footer);
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
	exit;
}

// #############################################################################

if ($_REQUEST['do'] == 'player_popup')
{
	if (!$tmntp['canviewladder'])
	{
		print_no_permission();
	}
	$userid = $vbulletin->input->clean_gpc('g', 'userid', TYPE_UINT);
	$lid = $vbulletin->input->clean_gpc('g', 'lid', TYPE_UINT);
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id = '$lid' ");
	if ($ladder['pot'])
	{
		$team = true;
		$userinfo = fetch_teaminfo($userid);
		$userinfo['team_members'] = array();
		$members = $vbulletin->db->query_read("
			SELECT members.*, user.*, user.username AS username, members.id AS id			
			FROM " . TABLE_PREFIX . "tmnt_members AS members
			LEFT JOIN " . TABLE_PREFIX . "user AS user
				ON(members.userid = user.userid)
			WHERE members.teamid = '$userid' AND members.accepted = 1
			ORDER BY members.leader DESC, members.coleader DESC, members.time ASC
		");
		while($member = $vbulletin->db->fetch_array($members))
		{
			if ($member['leader'])
			{
				$member['rank'] = 'Leader';
				if ($member['userid'] == $vbulletin->userinfo['userid'])
				{
					$isleader = true;
				}
			}
			elseif ($member['coleader'])
			{
				$member['rank'] = 'Co-Leader';
			}
			else
			{
				$member['rank'] = 'Member';
			}
			if ($prevmember && $prevmember['rank'] != $member['rank'])
			{
				$member['style'] = 'clear: left;';
			}
			$userinfo['team_members'][] = $member;
			$prevmember = $member;
		}
	}
	else
	{
		$team = false;
		$userinfo = fetch_userinfo($userid);
		if ($userid==$vbulletin->userinfo['userid'])
		{
			$isleader = true;
		}
	}
	$ladder['url'] = tll_seo(($ladder['league']>0?'league':'ladder'), $ladder['id'], $ladder['title'], 1);
	$player = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE userid='$userid' AND lid='$lid' ");
	if ($team)
	{
		$player['teamurl'] = tll_seo('team', $userinfo['teamid'], $userinfo['teamname']);
	}
	if (!$player['crown'] && $isleader)
	{
		$crown_query = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE crown > 0 AND lid='$lid' AND active = 1 ");
		if ($crown_query['countrows'] == 0)
		{
			$player['claim_crown'] = true;
		}
	}
	$player['streak'] = $player['wstreak'] - $player['lstreak'];
	$player['totalmatches'] = $player['wins']+$player['draws']+$player['loses'];
	if ($player['wins']==0)
	{
		$player['winpercentage'] = 0;
	}
	else
	{
		$player['winpercentage'] = round(($player['wins']/$player['totalmatches'])*100);
	}
	$comper = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE userid='$thisuserid' AND lid='$lid' AND active = 1 ");
	if (($comper OR $team) && $tmntp['canjoinladder'])
	{
		$comper = 1;
	}
	$countp = $vbulletin->db->query_first("SELECT COUNT(*) AS count FROM " . TABLE_PREFIX . "tmnt_ladder_players AS p WHERE rank > '".$player['rank']."' AND active = 1 AND lid = '".$lid."' AND p.group = '".$player['group']."' ");
	$player['position'] = $countp['count'] + 1;
	$player['position'] = process_position($player['position']);
	$matches = $vbulletin->db->query_read("
		SELECT games.*, IF(games.pot = 1, teama.teamname, usera.username) AS username_u, IF(games.pot = 1, teamb.teamname, userb.username) AS username_u2
		FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
		LEFT JOIN " . TABLE_PREFIX . "user AS usera
			ON (games.u = usera.userid)
		LEFT JOIN " . TABLE_PREFIX . "user AS userb
			ON (games.u2 = userb.userid)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS teama
			ON (games.u = teama.teamid)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS teamb
			ON (games.u2 = teamb.teamid)
		WHERE games.lid = '$lid'
			AND (games.u = '$userid' OR games.u2 = '$userid')
			AND games.accepted = 1
			AND games.finished = 1
		ORDER BY games.dateline DESC, games.dateline_finished DESC
		LIMIT 0, 5
	");
	$u_m = $r_m = array();
	while($match = $vbulletin->db->fetch_array($matches))
	{//recent matches
			if ($match['u']==$userid)
			{
				$match['opponent'] = $match['username_u2'];
				$match['opp_userid'] = $match['u2'];
				if ($match['score_u2']>$match['score_u'])
				{
					$match['text'] = 'Lost';
				}
				elseif ($match['score_u2']==$match['score_u'])
				{
					$match['text'] = 'Drew';
				}
				else
				{
					$match['text'] = 'Won';
				}
				$match['scoretext'] = $match['score_u'].'-'.$match['score_u2'];
			}
			else
			{
				$match['opponent'] = $match['username_u'];
				$match['opp_userid'] = $match['u'];
				if ($match['score_u']>$match['score_u2'])
				{
					$match['text'] = 'Lost';
				}
				elseif ($match['score_u2']==$match['score_u'])
				{
					$match['text'] = 'Drew';
				}
				else
				{
					$match['text'] = 'Won';
				}
				$match['scoretext'] = $match['score_u2'].'-'.$match['score_u'];
			}
		$r_m[] = $match;
	}
	$matches = $vbulletin->db->query_read("
		SELECT games.*, IF(games.pot = 1, teama.teamname, usera.username) AS username_u, IF(games.pot = 1, teamb.teamname, userb.username) AS username_u2
		FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
		LEFT JOIN " . TABLE_PREFIX . "user AS usera
			ON (games.u = usera.userid)
		LEFT JOIN " . TABLE_PREFIX . "user AS userb
			ON (games.u2 = userb.userid)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS teama
			ON (games.u = teama.teamid)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS teamb
			ON (games.u2 = teamb.teamid)
		WHERE games.lid = '$lid'
			AND (games.u = '$userid' OR games.u2 = '$userid')
			AND games.accepted = 1
			AND games.finished = 0
		ORDER BY games.dateline ASC
		LIMIT 0, 5
	");
	while($match = $vbulletin->db->fetch_array($matches))
	{//upcoming matches
		if ($match['u']==$userid)
		{
			$match['opponent'] = $match['username_u2'];
			$match['opp_userid'] = $match['u2'];
		}
		else
		{
			$match['opponent'] = $match['username_u'];
			$match['opp_userid'] = $match['u'];
		}
		$u_m[] = $match;
	}
	if ((($player['userid'] != $vbulletin->userinfo['userid']) OR $team) && !$ladder['archive'] && !$ladder['league'] && $comper)
	{
		$player['canchal'] = true;
	}
	if (!$team)
	{
		$chal = $vbulletin->db->query_first("
			SELECT g.* 
			FROM " . TABLE_PREFIX . "tmnt_ladder_games AS g
			WHERE 
				((g.u = '$userid' AND g.u2 = '$thisuserid')
				OR (g.u2 = '$userid' AND g.u = '$thisuserid')) 
				AND g.finished = 0
				AND g.lid='$lid'
		");
	}
	if ($chal)
	{
		if ($chal['accepted']==0)
		{
			$chal['status'] = 'Awaiting match to be accepted.';
		}
		else
		{
			if (!$chal['agree_u'] && $chal['agree_u2'] && $chal['u2']==$thisuserid)
			{
				$chal['status'] = 'Awaiting opponent\'s score.';
			}
			if (!$chal['agree_u2'] && $chal['agree_u'] && $chal['u']==$thisuserid)
			{
				$chal['status'] = 'Awaiting opponent\'s score.';
			}
			if (!$chal['agree_u2'] && $chal['u2']==$thisuserid)
			{
				$chal['status'] = 'Awaiting your score. <a class="button" style="float:right;" href="ladder_match.php?do=submitscore&amp;id='.$chal['id'].'&amp;from=ladder" class="tllpopup" onclick="tll_popup(this.href); return false;">Submit score</a>';
			}
			if (!$chal['agree_u'] && $chal['u']==$thisuserid)
			{
				$chal['status'] = 'Awaiting your score. <a class="button" style="float:right;" href="ladder_match.php?do=submitscore&amp;id='.$chal['id'].'&amp;from=ladder" class="tllpopup" onclick="tll_popup(this.href); return false;">Submit score</a>';
			}
			if (!$chal['agree_u'] && !$chal['agree_u2'])
			{
				$chal['status'] = 'Awaiting match scores. <a class="button" style="float:right;" href="ladder_match.php?do=submitscore&amp;id='.$chal['id'].'&amp;from=ladder" class="tllpopup" onclick="tll_popup(this.href); return false;">Submit score</a>';
			}
		}
	}
	/****/
	$countlimit = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE lid=$lid AND ((u=$userid AND u2=$thisuserid) OR (u=$thisuserid AND u2=$userid)) AND finished = 0 ");
	if ($countlimit['countrows']>=$vbulletin->options['tmnt_ladder_maxc'])
	{
		$player['canchal'] = false;
	}
	$time_limit = TIMENOW - ($vbulletin->options['tmnt_ladder_limitrematch'] * 60 * 60);
	$countlimit = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE lid=$lid AND ((u=$userid AND u2=$thisuserid) OR (u=$thisuserid AND u2=$userid)) AND dateline_finished > '" . $time_limit . "' ");
	if ($countlimit['countrows'])
	{
		$days = floor($vbulletin->options['tmnt_ladder_limitrematch']/24);
		$hours = $vbulletin->options['tmnt_ladder_limitrematch'] - $days * 24;
		$player['canchal'] = false;
	}
	/****/
	if ($isleader && file_exists(DIR . '/tll_modules/tll_editavatar.php'))
	{
		$tmntp['caneditavatar'] = true;
	}
	if ($isleader && file_exists(DIR . '/tll_modules/tll_editbadge.php'))
	{
		$tmntp['caneditbadge'] = true;
	}
	$count1 = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE lid = '$lid' AND u2 = '$userid' AND accepted = '1' ");
	$count2 = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE lid = '$lid' AND u2 = '$userid' AND accepted = '-1' ");
	if ($count1['countrows'] || $count2['countrows'])
	{
		$player['acceptance_percentage'] = number_format(($count1['countrows'] / ($count1['countrows'] + $count2['countrows'])) * 100);
	}
	$avg = $vbulletin->db->query_first("SELECT AVG(accepted_dateline-time) AS avg FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE lid = '$lid' AND u2 = '$userid' AND accepted_dateline > 0 ");
	switch ($avg['avg'])
	{
		case ($avg['avg'] < 3600):
			$player['average_acceptance_time'] = number_format($avg['avg']/60) . " mins";
			break;
		case ($avg['avg'] < 86400):
			$player['average_acceptance_time'] = number_format($avg['avg']/3600) . " hours";
			break;
		case ($avg['avg'] > 86400):
			$player['average_acceptance_time'] = number_format($avg['avg']/86400) . " days";
			break;
	}
	//$player['average_acceptance_time'] = number_format($player['average_acceptance_time']);
	//print_r($player);
	if (!$player['latime'])
	{
		$player['latime'] = $player['time'];
	}
	$templater = vB_Template::create('tmnt_ladder_player_popup');
		$templater->register('tmntp', $tmntp);
		$templater->register('team', $team);
		$templater->register('ladder', $ladder);
		$templater->register('isleader', $isleader);
		$templater->register('player', $player);
		$templater->register('userinfo', $userinfo);
		$templater->register('cmpt', $player);
		$templater->register('comper', $comper);
		$templater->register('r_m', $r_m);
		$templater->register('u_m', $u_m);
		$templater->register('chal', $chal);
	$tlhtml .= $templater->render();
	if ($_REQUEST['ajax'])
	{
		print_r($tlhtml);
		exit;
	}
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladders'],
		'ladders.php?' . $vbulletin->session->vars['sessionurl_q'] . 'do=view&amp;id=' . $lid => $ladder['title'],
		'' => $player['username']
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'join')
{
	if (!$tmntp['canjoinladder'])
	{
		print_no_permission();
	}
	$lid = $id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	$userid = $thisuserid;
	$username = $thisusername;
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id='$id' ");
	if (!$id OR !$ladder)
	{
		$errormessage = $vbphrase['error_invalid_ladder'];
		eval(standard_error($errormessage));
	}
	$ladder['url'] = tll_seo('ladder', $ladder['id'], $ladder['title']);
	if ($ladder['password'] && $vbulletin->options['tmnt_premium'])
	{
		require_once(DIR . '/includes/functions_tll_prem.php');	
		check_tmnt_password('join', 'ladder');
		$ladder['url'] .= '&amp;password='.$ladder['password'];
	}
	if ($ladder['league'] > 1)
	{
		$errormessage = "Sorry this league has already started, you will next to wait until next season to compete in this league.";
		if ($_REQUEST['ajax']==1)
		{
			$tlhtml = tll_popup_standard_error($errormessage);
			print_r($tlhtml);
			exit;
		}
		eval(standard_error($errormessage));
	}
	if ($ladder['pot'] == 0)
	{
		$team = false;
	}
	else
	{
		$team = true;
	}
	if ($ladder['archive'] == 1)
	{
		$errormessage = $vbphrase['error_ladder_closed'];
		if ($_REQUEST['ajax']==1)
		{
			$tlhtml = tll_popup_standard_error($errormessage);
			print_r($tlhtml);
			exit;
		}
		eval(standard_error($errormessage));
	}
	$tmax = $ladder['tmax'];
	$tmin = $ladder['tmin'];
	if ($ladder['maxplayers']>0)
	{
		$count = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid='$id' AND active = 1 ");
		if ($count['countrows'] >= $ladder['maxplayers'])
		{
			$errormessage = 'Sorry, max competitors for this ladder/league is '.$ladder['maxplayers'].'.';
			if ($_REQUEST['ajax']==1)
			{
				$tlhtml = tll_popup_standard_error($errormessage);
				print_r($tlhtml);
				exit;
			}
			eval(standard_error($errormessage));
		}
	}
	if (!$team)
	{
		$vbc = $vbulletin->userinfo['tmnt_credits'];
		if ($vbulletin->options['tmnt_credits_vbcredits'])
		{
			$vbb = 'vbcredits_'.$vbulletin->options['tmnt_vbcredits_curr'];
			$vbc += $vbulletin->options['tmnt_vbcredits_conv'] * $vbulletin->userinfo["$vbb"];
		}
		$vbc = number_format($vbc,2);
		$countplayer = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid='$id' AND (userid='$userid' OR username='".$vbulletin->db->escape_string($username)."')");
		$countplayer = $countplayer['countrows'];  
		if ($countplayer != 0) {
			$countplayer = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid=$id AND (userid=$userid OR username='".$vbulletin->db->escape_string($username)."') AND active=0");
			$countplayer = $countplayer['countrows'];  
			if ($countplayer == 1)
			{
				$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_players SET active=1, latime = ".TIMENOW." WHERE lid=$id AND (userid=$userid OR username='".$vbulletin->db->escape_string($username)."') AND active=0");
				$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladders SET noplayers = noplayers + 1 WHERE id=$id");
				$tmnt_ladders = array_merge((array)$vbulletin->userinfo['tmnt_ladders'], (array)$id);
				$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET tmnt_ladders = '" . implode(',' , $tmnt_ladders) . "' WHERE userid=$userid");
				$crown_query = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE crown > 0 AND lid='$lid' AND active = 1 ");
				if ($crown_query['countrows'] == 0)
				{
					$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_players SET crown = 1 WHERE lid = '$lid' AND userid = '$userid' ");
				}
				if ($_REQUEST['ajax'])
				{
					print_r('Reload');
					exit;
				}
				$vbulletin->url = "ladders.php?do=view&id=$id";
				eval(print_standard_redirect('redirect_rejoinedladder'));
			}
			$errormessage = $vbphrase['error_already_joined_ladder'];
			eval(standard_error($errormessage));
		}
	}
	if ($team)
	{
		$userteams .= '<select name="teamid" id="teamid">';
		$teams = $vbulletin->db->query_read("
			SELECT m.*, t.*
			FROM " . TABLE_PREFIX . "tmnt_members AS m
			LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS t
				ON (m.teamid = t.teamid)
			LEFT JOIN " . TABLE_PREFIX . "tmnt_ladder_players AS p
				ON (p.userid = t.teamid AND p.lid = $id AND active = 1)
			WHERE m.leader = 1
				AND m.userid = $userid
				AND t.noplayers <= $tmax
				AND t.noplayers >= $tmin
				AND p.id IS NULL
		");
		while($teamm = $vbulletin->db->fetch_array($teams))
		{
			$userteams .= "<option value=\"".$teamm['teamid']."\">".$teamm['teamname']."</option>";
			$countuserteams++ ;
		}
		$userteams .= '</select>';
		if ($countuserteams == 0)
		{
			$errormessage = construct_phrase($vbphrase['error_not_leader_ladder'], $id);
			if ($tmntp['cancreateteam'])
			{
				$errormessage .= '<br /><br /><a href="teams.php?do=addteam" class="button">Create new team</a>';
			}
			if ($_REQUEST['ajax']==1)
			{
				$tlhtml = tll_popup_standard_error($errormessage);
				print_r($tlhtml);
				exit;
			}
			eval(standard_error($errormessage));
		} 
	}
	$templater = vB_Template::create('tmnt_ladder_join');
		$templater->register('tmntp', $tmntp);
		$templater->register('ladder', $ladder);
		$templater->register('id', $id);
		$templater->register('lid', $lid);
		$templater->register('team', $team);
		$templater->register('userteams', $userteams);
		$templater->register('ladder', $ladder);
		$templater->register('vbc', $vbc);
	$tlhtml .= $templater->render();
	if ($_REQUEST['ajax']==1)
	{
		$tlhtml = str_replace("history.go(-1);return false;","close_tll_popup()", $tlhtml);
		print_r($tlhtml);
		exit;
	}
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladders'],
		'ladders.php?' . $vbulletin->session->vars['sessionurl_q'] . 'do=view&amp;id=' . $id => $ladder['title'],
		'' => construct_phrase($vbphrase['ladder_joining'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'leaveladder')
{
	$lid = $id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id='$id' ");
	if (!$ladder)
	{
		$errormessage = $vbphrase['error_invalid_ladder'];
		eval(standard_error($errormessage));
	}
	$ladder['url'] = tll_seo('ladder', $ladder['id'], $ladder['title']);
	if ($ladder['password'] && $vbulletin->options['tmnt_premium'])
	{
		require_once(DIR . '/includes/functions_tll_prem.php');	
		check_tmnt_password('leaveladder', 'ladder');
		$ladder['url'] .= '&amp;password='.$ladder['password'];
	}
	if ($ladder['archive'])
	{
		$errormessage = $vbphrase['error_ladder_closed'];
		eval(standard_error($errormessage));
	}
	$u = $vbulletin->input->clean_gpc('g', 'u', TYPE_UINT);
	if (!$ladder['pot'])
	{
		$team = false;
		if ($u == $thisuserid OR !$u)
		{
			$userid = $thisuserid;
			$username = $thisusername;
		}
		elseif ($tmntp['caneditladder'])
		{
			$userid = $u;
			$userinfo = fetch_userinfo($u);
			$username = $userinfo['username'];
		} 
		else 
		{
			print_no_permission();
		}
	}
	else 
	{
		$team = true;
		if (!$u)
		{
			$teams_query = $vbulletin->db->query_read("
				SELECT t.teamname, t.teamid
				FROM " . TABLE_PREFIX . "tmnt_ladder_players AS p
				LEFT JOIN " . TABLE_PREFIX . "tmnt_members AS m
					ON (p.userid = m.teamid AND leader = 1 AND m.userid = $thisuserid)
				LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS t
					ON (p.userid = t.teamid)
				WHERE m.id > 0
					AND p.lid = '$lid'
					AND p.active = 1
			");
			while($teamm = $vbulletin->db->fetch_array($teams_query))
			{
				$userteams .= "<option value=\"".$teamm['teamid']."\">".$teamm['teamname']."</option>";
			}
			if (!$userteams)
			{
				print_no_permission();
			}
			$templater = vB_Template::create('tmnt_ladder_teamleave');
				$templater->register('tmntp', $tmntp);
				$templater->register('userteams', $userteams);
				$templater->register('ladder', $ladder);
			$tlhtml .= $templater->render();
			$navbits = construct_navbits(array(
				'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
				'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladders'],
				'ladders.php?' . $vbulletin->session->vars['sessionurl_q'] . 'do=view&amp;id=' . $id => $ladder['title'],
				'' => construct_phrase('Leave Ladder')
			));
			$navbar = render_navbar_template($navbits);
			$templater = vB_Template::create('tmnt_shell');
			$templater->register_page_templates();
			$templater->register('navbar', $navbar);
			$templater->register('headinclude', $headinclude);
			$templater->register('pagetitle', $pagetitle);
			$templater->register('tlhtml', $tlhtml);
			$templater->register('modname', $modname);
			$templater->register('header', $header);
			$templater->register('footer', $footer);
			$templater->register('tmntp', $tmntp);
			$templater->register('tmnt_version', $tmnt_version);
			print_output($templater->render());
		}
		if (!$teaminfo = fetch_teaminfo($u))
		{
			$errormessage = $vbphrase['error_invalid_team'];
			eval(standard_error($errormessage));
		}
		$isleader = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_members WHERE teamid = '$u' AND leader = '1' AND userid = '$thisuserid'");
		if (!$isleader && !$tmntp['caneditladder'])
		{
			print_no_permission();
		}
		$username = $teaminfo['teamname'];
		$userid = $teaminfo['teamid'];
	}
	$countplayer = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid = '$id' AND userid = '$userid' AND active = 1 ");
	$countplayer = $countplayer['countrows'];  
	if ($countplayer == 1)
	{
		$vbulletin->db->query_write("
			UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
				SET active = 0, crown = 0
				WHERE lid = '$id'
					AND userid = '$userid'
					AND active = '1'
		");
		$vbulletin->db->query_write("
			UPDATE " . TABLE_PREFIX . "tmnt_ladders
			SET noplayers = noplayers - 1
			WHERE id = '$id'
		");
		if (!$team)
		{
			$userinfo = fetch_userinfo($u);
			$tmnt_ladders = array_delete(explode(',',$userinfo['tmnt_ladders']), $id);
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "user
				SET tmnt_ladders = '" . implode(',', $tmnt_ladders) . "'
				WHERE userid = '$userid'
			");
		}
	}
	$vbulletin->url = "ladders.php?".$ladder['url'];
	eval(print_standard_redirect('redirect_leaveladder'));
}

// #############################################################################

if ($_POST['do'] == 'insertjoin')
{
	if (!$tmntp['canjoinladder'])
	{
		print_no_permission();
	}
	$lid = $id = $vbulletin->input->clean_gpc('p', 'id', TYPE_UINT);
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id = '$id' ");
	if (!$ladder)
	{
		$errormessage = $vbphrase['error_invalid_ladder'];
		eval(standard_error($errormessage));
	}
	$ladder['url'] = tll_seo('ladder', $ladder['id'], $ladder['title'], 1);
	if ($ladder['archive'])
	{
		$errormessage = $vbphrase['error_ladder_closed'];
		eval(standard_error($errormessage));
	}
	$team = false;
	if ($ladder['pot'])
	{
		$team = true;
	}
	if (!$team)
	{
		$userid = $vbulletin->input->clean_gpc('p', 'userid', TYPE_UINT);
		if (!$userid) {
			$userid = $thisuserid;
		}
		$username = $vbulletin->input->clean_gpc('p', 'username', TYPE_STR);
		if (!$username)
		{
			$username = $thisusername;
		}
		$userinfo = fetch_userinfo($userid);
		$tmnt_ladders = array_merge((array)$userinfo['tmnt_ladders'], (array)$id);
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET tmnt_ladders = '" . implode(',' , $tmnt_ladders) . "' WHERE userid=$userid");
	}
	if ($team)
	{
		$userid = $vbulletin->input->clean_gpc('p', 'teamid', TYPE_UINT);
			if (!$userid)
			{
				$errormessage = $vbphrase['error_invalid_team'];
				eval(standard_error($errormessage));
			}
		$team = fetch_teaminfo($userid);
		$username = $team['teamname'];
		if (!$username)
		{
			$errormessage = $vbphrase['error_invalid_team'];
			eval(standard_error($errormessage));
		}
	}
	$countplayer = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid = '$id' AND (userid = '$userid' OR username = '".$vbulletin->db->escape_string($username)."') ");
	$countplayer = $countplayer['countrows'];  
	if ($countplayer != 0)
	{
		if ($countplayer == 1)
		{
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_players SET active=1, latime=".TIMENOW." WHERE lid=$id AND (userid=$userid OR username='".$vbulletin->db->escape_string($username)."') AND active=0");
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladders SET noplayers = noplayers + 1 WHERE id=$id");
			$vbulletin->url = "ladders.php?do=view&id=$id";
			eval(print_standard_redirect('redirect_rejoinedladder'));
		}
		$errormessage = $vbphrase['error_already_joined_ladder'];
		eval(standard_error($errormessage));
	}
	$crown_query = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE crown > 0 AND lid='$lid' AND active = 1 ");
	if ($crown_query['countrows'] == 0)
	{
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_players SET crown = 1 WHERE lid = '$lid' AND userid = '$userid' ");
	}
	if ($ladder['join_cost'] > 0 && $vbulletin->options['tmnt_credit_system'])
	{
require_once(DIR . '/includes/functions_tll_prem.php');	
		if (!$team && !tll_check_credits($vbulletin->userinfo, $ladder['join_cost'], 1))
		{
			$errormessage = 'Error, insufficient credits. Joining this ladder costs '.$ladder['join_cost'].' credits, you only have '.$vbulletin->userinfo['tmnt_credits'].' credits.';
			eval(standard_error($errormessage));
		}
		elseif ($team && $team['tmnt_credits'] < $ladder['join_cost'])
		{
			$errormessage = 'Error, insufficient credits. Joining this ladder costs '.$ladder['join_cost'].' credits, your team only has '.$team['tmnt_credits'].' credits.';
			eval(standard_error($errormessage));
		}	
		if ($team)
		{
			process_credits_transaction($userid, -$ladder['join_cost'], 'Joined ladder', 0, 0, $team['teamid'], 1);
		}
		else
		{
			process_credits_transaction($userid, -$ladder['join_cost'], 'Joined ladder', $userid, 0);
		}
		update_forum_creditprofit(vbdate('W',TIMENOW), vbdate('Y',TIMENOW), $ladder['join_cost'], TIMENOW);
	}
	if ($team && $ladder['comp_ugid'])
	{
		$members = $vbulletin->db->query_read("
			SELECT m.*, u.username
			FROM " . TABLE_PREFIX . "tmnt_members AS m
			LEFT JOIN " . TABLE_PREFIX . "user AS u
				ON (u.userid = m.userid)
			WHERE m.teamid = '$userid'
				AND m.accepted = 1
		");
		while($m = $vbulletin->db->fetch_array($members))
		{
			$userinfo = fetch_userinfo($m['userid']);
			$user = $userinfo;
			$newmembergroupid = $ladder['comp_ugid'];
			$user['membergroupids']=explode(',',$user['membergroupids']);
			if (!in_array($newmembergroupid, $user['membergroupids']))
			{
				$user['membergroupids'][]=$newmembergroupid;
			}
			else
			{
				continue;
			}
			//$display_usergroup = $newmembergroupid;
			$user['membergroupids']=implode(',',$user['membergroupids']);
			$userdata =& datamanager_init('User', $vbulletin, ERRTYPE_STANDARD);
			$userdata->set_existing($userinfo);
			$userdata->set('membergroupids', $user['membergroupids']);
			/*$userdata->set_usertitle(
					$userinfo['usertitle'],
					true,
					$vbulletin->usergroupcache["$newmembergroupid"],
					false,
					true
			);*/
			$userdata->save();
		}
	}
	elseif ($ladder['comp_ugid'])
	{
		$user = $userinfo = $vbulletin->userinfo;
		$newmembergroupid = $ladder['comp_ugid'];
		$user['membergroupids']=explode(',',$user['membergroupids']);
		$user['membergroupids'][]=$newmembergroupid;
		//$display_usergroup = $newmembergroupid;
		$user['membergroupids']=implode(',',$user['membergroupids']);
		$userdata =& datamanager_init('User', $vbulletin, ERRTYPE_STANDARD);
		$userdata->set_existing($userinfo);
		$userdata->set('membergroupids', $user['membergroupids']);
		/*$userdata->set_usertitle(
				$userinfo['usertitle'],
				true,
				$vbulletin->usergroupcache["$newmembergroupid"],
				false,
				true
		);*/
		$userdata->save();
	}
	$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "tmnt_ladder_players
		(userid, username, lid, time, ip, pot, rank)
		VALUES (
			'".$userid."',
			'".$vbulletin->db->escape_string($username)."',
			'".$ladder['id']."',
			".TIMENOW.",
			'".$vbulletin->db->escape_string($thisip)."',
			'".$ladder['pot']."',
			'".$ladder['startingelo']."'
		)
	");
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladders SET noplayers = noplayers + 1 WHERE id=$id");
	$password = $vbulletin->input->clean_gpc('p', 'password', TYPE_NOHTML);
	if (!$ladder['url'])
	{
		$ladder['url'] = 'ladders.php?do=view&id='.$lid;
	}
	$vbulletin->url = $ladder['url'].($password ? "&amp;password=".$password : "");
	eval(print_standard_redirect('redirect_insertjoinladder'));
}

// #############################################################################

if ($_REQUEST['do'] == 'challenges')
{
	if (!$tmntp['canjoinladder'])
	{
		print_no_permission();
	}
	$from = 'challenges';
	$rowcount = 0;
	$team = false;
	$vbulletin->input->clean_array_gpc('g', array(
		'accepted' => TYPE_UINT,
		'tobeaccepted' => TYPE_UINT,
		'pastmatches' => TYPE_UINT,
		'futurematches' => TYPE_UINT,
	));
	if ($vbulletin->GPC['accepted'])
	{
		$sql_where .= ' AND games.accepted = \'1\' ';
	}
	if ($vbulletin->GPC['pastmatches'])
	{
		$sql_where .= ' AND games.dateline < '.TIMENOW.' ';
	}
	if ($vbulletin->GPC['futurematches'])
	{
		$sql_where .= ' AND games.dateline > '.TIMENOW.' ';
	}
	if ($vbulletin->GPC['tobeaccepted'])
	{
		$sql_where .= ' AND ( (games.accepted = \'0\' AND games.pot = 0 AND games.u2 = '.$vbulletin->userinfo['userid'].') OR (games.pot = 1 AND games.accepted = \'0\') ) ';
	}
	if ($vbulletin->userinfo['tmnt_notifications'])
	{
		$thisu = $vbulletin->userinfo;
		if (!is_array($thisu['tmnt_notifications']))
		{
			$thisu['tmnt_notifications'] = unserialize($thisu['tmnt_notifications']);
		}
		if (($thisu['tmnt_notifications']['ladder_chals']+$thisu['tmnt_notifications']['ladder_accepts']+$thisu['tmnt_notifications']['ladder_newscore']+$thisu['tmnt_notifications']['l_rearrange']) > 0)
		{
			$thisu['tmnt_notifications']['ladder_chals'] = 0;
			$thisu['tmnt_notifications']['ladder_accepts'] = 0;
			$thisu['tmnt_notifications']['ladder_newscore'] = 0;
			$thisu['tmnt_notifications']['l_rearrange'] = 0;
			$thisu['tmnt_notifications']['l_rearr_id'] = 0;
			$thisu['tmnt_notifications'] = serialize($thisu['tmnt_notifications']);
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET tmnt_notifications = '".$vbulletin->db->escape_string($thisu['tmnt_notifications'])."' WHERE userid = '".$thisu['userid']."'");
		}
	}
	$show['filter'] = true;
	$templater = vB_Template::create('tmnt_ladder_chll_top');
		$templater->register('tmntp', $tmntp);
		$templater->register('rowno', $rowno);
		$templater->register('team', $team);
		$templater->register('show', $show);
		$templater->register('gpc', $vbulletin->GPC);
	$tlhtml .= $templater->render();
	$show['filter'] = false;
	$games = $vbulletin->db->query_read("
		SELECT games.*, games.u AS uid, games.u2 AS u2id, ladders.title AS ltitle, user.username AS u, user2.username AS u2
		FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
		LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders
			ON (games.lid = ladders.id)
		LEFT JOIN " . TABLE_PREFIX . "user AS user
			ON (games.u = user.userid)
		LEFT JOIN " . TABLE_PREFIX . "user AS user2
			ON (games.u2 = user2.userid)
		WHERE (games.u = $thisuserid OR games.u2 = $thisuserid)
			AND games.finished = 0
			AND games.accepted != -1
			AND games.pot = 0
			AND games.u2 != 0
			$sql_where
		ORDER BY lid, round ASC
		");
	$mc_ids_array = array();
	$lastltitle = '';
	$chllarray = array();
	while($game = $vbulletin->db->fetch_array($games))
	{
		$game['display'] = 'none';
		if ($game['comments'] > 0)
		{
			$mc_ids_array[] = $game['id'];
		}
		$game = process_chal_options($game);
		$game['showltitle'] = false;
		if ($lastltitle != $game['ltitle'])
		{
			$game['showltitle'] = true;
			$game['ladderurl'] = $thisurl = tll_seo('ladder', $game['lid'], $game['ltitle']);
		}
		$lastltitle = $game['ltitle'];
		if ($game['uid'] == $thisuserid)
		{
			$is_u = true;
		}
		else
		{
			$is_u = false;
		}
		if ($game['u2id'] == $thisuserid)
		{
			$is_u2 = true;
		}
		else
		{
			$is_u2 = false;
		}
		$lid = $game['lid'];
		$game['time'] = vbdate($vbulletin->options['timeformat'],$game['time']).$vbphrase['ladder_on'].vbdate($vbulletin->options['dateformat'],$game['time']);
		$game['showflags'] = true;
		//start match status
		if ($game['accepted'] == 0)
		{
			$game['status'] = $vbphrase[tmnt_awaiting_acceptance];
			if ($is_u)
			{
				$game['status'] .= ' <br /> <a href="ladder_match.php?do=cancel&amp;id='.$game['id'].'&amp;u='.$game['uid'].'&amp;from=challenges" onclick="return confirm(\'Are you sure you wish to cancel this challenge?\');">'.$vbphrase['tmnt_cancel_challenge'].'</a>';
			}
			if ($is_u2)
			{
				if ($game['chal_cost'] > 0 && $vbulletin->options['tmnt_credit_system'])
				{
					$game['onclick'] = ' onclick="return confirm(\'Are you sure you want to accept this challenge? It will cost you '.$game['chal_cost'].' credits.\');"';
				}
				$game['status'] = $game['status'].'. <br /> <a href="ladder_match.php?do=accept&amp;id='.$game['id'].'&amp;u='.$game['uid'].'"'.$game['onclick'].'>'.$vbphrase[tmnt_accept_now].'</a>! <br /> <a href="ladder_match.php?do=reject&amp;id='.$game['id'].'">'.$vbphrase[tmnt_reject_now].'</a>!';
			}
			$game['showflags'] = false;
		}
		elseif ($game['agree_u'] == 0 && $game['agree_u2'] == 0)
		{
			$game['status'] = $vbphrase['tmnt_awaiting_scores'] . ' <br /><a href="ladder_match.php?do=submitscore&amp;id='.$game['id'].'" class="tllpopup">' . $vbphrase['tmnt_submit_score_now'].'</a>!';
		}
		elseif ($game['agree_u'] == 0)
		{
			if ($is_u)
			{
				$game['status'] = $vbphrase['tmnt_awaiting_your_score'] . '. <br /><a href="ladder_match.php?do=submitscore&amp;id='.$game['id'].'" class="tllpopup">' . $vbphrase['tmnt_submit_score_now'] . '</a>!';
			}
			else
			{
				$game['status'] = $vbphrase['tmnt_awaiting_opponents_score'];
			}
		}
		elseif ($game['agree_u2'] == 0)
		{
			if ($is_u2)
			{
				$game['status'] = $vbphrase['tmnt_awaiting_your_score'] . '. <br /><a href="ladder_match.php?do=submitscore&amp;id='.$game['id'].'" class="tllpopup">' . $vbphrase['tmnt_submit_score_now'] . '</a>!';
			}
			else
			{
				$game['status'] = $vbphrase['tmnt_awaiting_opponents_score'];
			}
		}
		//end match status
		$rowno++ ;
		if ($game['comments'] > 0)
		{
			$mc_ids_array[] = $game['id'];
		}
		$chllarray["$game[id]"] = $game;
	}
	if (!empty($mc_ids_array))
	{
		$chllarray = fetch_ladder_mcs($mc_ids_array, $chllarray);
	}
	$templater = vB_Template::create('tmnt_ladder_chll');
		$templater->register('tmntp', $tmntp);
		$templater->register('rowno', $rowno);
		$templater->register('show', $show);
		$templater->register('from', $from);
		$templater->register('chllarray', $chllarray);
	$tlhtml .= $templater->render();
	$team = true;
	$templater = vB_Template::create('tmnt_ladder_chll_bot');
		$templater->register('tmntp', $tmntp);
		$templater->register('rowno', $rowno);
		$templater->register('team', $team);
	$tlhtml .= $templater->render();
	$userid = $thisuserid;
	$coteamids = $teamids = $teamnames = $co_teamarray = $teamarray = array();
	$coteamcount = $teamcount = 0;
	$teams = $vbulletin->db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_members AS members
		JOIN " . TABLE_PREFIX . "tmnt_teams AS teams
			on members.teamid = teams.teamid
		WHERE (members.leader=1 OR members.coleader=1)
			AND members.userid='$userid'");
	while($teamm = $vbulletin->db->fetch_array($teams))
	{
		$teamid = $teamm['teamid'];
		$teamname = $teamm['teamname'];
		if ($teamm['leader'])
		{
			$teamids = array_merge((array)$teamid, $teamids);
			$teamnames = array_merge((array)$teamname, $teamnames);
			$teamarray[] = $teamm;
			$teamcount++;
		}
		elseif ($teamm['coleader'])
		{
			$co_teamarray[] = $teamm;
			$coteamids = array_merge((array)$teamid, $coteamids);
			$coteamcount++;
		}
	}
	$eteamids = $teamids;
	$teamids = implode(",", $teamids);
	$coteamids = implode(",", $coteamids);
	$yourteams = implode(", ", $teamnames);
	/*co-leaders*/
	if ($teamcount+$coteamcount > 0)
	{
		$rowcount = 0;
		$team = true;
		$templater = vB_Template::create('tmnt_ladder_yourteams');
			$templater->register('teamarray', $teamarray);
			$templater->register('co_teamarray', $co_teamarray);
		$tlhtml .= $templater->render();
		$templater = vB_Template::create('tmnt_ladder_chll_top');
		$templater->register('tmntp', $tmntp);
		$templater->register('rowno', $rowno);
		$templater->register('team', $team);
		$tlhtml .= $templater->render();
		$cond_where = "(";
		if ($teamids)
		{
			$cond_where .= "games.u IN (".$teamids.") OR games.u2 IN (".$teamids.")";
		}
		if ($teamids && $coteamids)
		{
			$cond_where .= " OR ";
		}
		if ($coteamids)
		{
			$cond_where .= "games.u IN (".$coteamids.") OR games.u2 IN (".$coteamids.")";
		}
		$cond_where .= ")";
		if ($vbulletin->GPC['tobeaccepted'] && $teamids)
		{
			$sql_where .= ' AND (games.accepted = \'0\' AND games.pot = 1 AND games.u2 IN ('.$teamids.')) ';
		}
		$games = $vbulletin->db->query_read("
			SELECT games.*, games.u AS uid, games.u2 AS u2id, ladders.title AS ltitle, user.teamname AS u, user2.teamname AS u2
			FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
			LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders
				ON (games.lid = ladders.id)
			LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS user
				ON (games.u = user.teamid)
			LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS user2
				ON (games.u2 = user2.teamid)
			WHERE $cond_where
				AND games.finished = 0
				AND games.accepted != -1
				AND games.u2 != 0
				AND games.pot = 1
				$sql_where
			ORDER BY games.lid
		");
		$lastltitle = '';
		$chllarray = array();
		$mc_ids_array = array();
		while($game = $vbulletin->db->fetch_array($games))
		{
			if (in_array($game['uid'], $eteamids) OR in_array($game['u2id'], $eteamids))
			{
				$game['leader'] = 1;
			}
			$game['display'] = 'none';
			$game = process_chal_options($game);
			$lid = $game['lid']; 
			$game['showltitle'] = false;
			if ($lastltitle != $game['ltitle'])
			{
				$game['showltitle'] = true;
				$game['ladderurl'] = $thisurl = tll_seo('ladder', $game['lid'], $game['ltitle']);
			}
			$lastltitle = $game['ltitle'];
			$game['time'] = vbdate($vbulletin->options['timeformat'],$game['time']).$vbphrase['ladder_on'].vbdate($vbulletin->options['dateformat'],$game['time']);
			if (in_array($game['uid'], $eteamids))
			{
				$is_u = true;
			}
			else
			{
				$is_u = false;
			}
			if (in_array($game['u2id'], $eteamids))
			{
				$is_u2 = true;
			}
			else
			{
				$is_u2 = false;
			}
			$game['showflags'] = true;
			//start match status
			if ($game['accepted'] == 0)
			{
				$game['status'] = $vbphrase['tmnt_awaiting_acceptance'];
				if ($is_u && $game['leader'])
				{
					$game['status'] .= ' <br /> <a href="ladder_match.php?do=cancel&amp;id='.$game['id'].'&amp;u='.$game['uid'].'&amp;from=challenges" onclick="return confirm(\'Are you sure you wish to cancel this challenge?\');">'.$vbphrase['tmnt_cancel_challenge'].'</a>';
				}
				if ($is_u2)
				{
					$game['status'] = $game['status'] . ($game['leader'] ? '. <br /> <a href="ladder_match.php?do=teamaccept&amp;id='.$game['id'].'">'.$vbphrase['tmnt_accept_now'].'</a>! <br /> <a href="ladder_match.php?do=teamreject&amp;id='.$game['id'].'">'.$vbphrase['tmnt_reject_now'].'</a>!' : '');
				}
				$game['showflags'] = false;
			}
			elseif ($game['agree_u'] == 0 && $game['agree_u2'] == 0)
			{
				$game['status'] = $vbphrase['tmnt_awaiting_scores'] . ($game['leader'] ? ' <br /><a href="ladder_match.php?do=submitscore&amp;id='.$game['id'].'" class="tllpopup">' . $vbphrase['tmnt_submit_score_now'].'</a>!' : '');
			}
			elseif ($game['agree_u'] == 0)
			{
				if ($is_u)
				{
					$game['status'] = $vbphrase['tmnt_awaiting_your_score'] . ($game['leader'] ? '. <br /><a href="ladder_match.php?do=submitscore&amp;id='.$game['id'].'" class="tllpopup">' . $vbphrase['tmnt_submit_score_now'] . '</a>!' : '');
				}
				else
				{
					$game['status'] = $vbphrase['tmnt_awaiting_opponents_score'];
				}
			}
			elseif ($game['agree_u2'] == 0)
			{
				if ($is_u2)
				{
					$game['status'] = $vbphrase['tmnt_awaiting_your_score'] . ($game['leader'] ? '. <br /><a href="ladder_match.php?do=submitscore&amp;id='.$game['id'].'" class="tllpopup">' . $vbphrase['tmnt_submit_score_now'] . '</a>!' : '');
				}
				else
				{
					$game['status'] = $vbphrase['tmnt_awaiting_opponents_score'];
				}
			}
			$rowno++ ;
			if ($game['comments'] > 0)
			{
				$mc_ids_array[] = $game['id'];
			}
			$chllarray["$game[id]"] = $game;
		}
		if (!empty($mc_ids_array))
		{
			$chllarray = fetch_ladder_mcs($mc_ids_array, $chllarray);
		}
		$templater = vB_Template::create('tmnt_ladder_chll');
			$templater->register('tmntp', $tmntp);
			$templater->register('rowno', $rowno);
			$templater->register('team', $team);
			$templater->register('from', $from);
			$templater->register('chllarray', $chllarray);
		$tlhtml .= $templater->render();
		$templater = vB_Template::create('tmnt_ladder_chll_bot');
		$templater->register('tmntp', $tmntp);
		$templater->register('rowno', $rowno);
		$templater->register('team', $team);
		$tlhtml .= $templater->render();
	}
	$headinclude .= "\r\n<link rel=\"stylesheet\" type=\"text/css\" href=\"css.php?d=" . TIMENOW . "&amp;td=" . vB_Template_Runtime::fetchStyleVar('textdirection') . "&amp;styleid=" . $vbulletin->userinfo['styleid'] . "&amp;sheet=memberlist.css\" />";
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladders'],
		'' => $vbphrase['ladder'] . " " . $vbphrase['ladder_chlls']
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_POST['do'] == 'updatepositions')
{
	$lid = $vbulletin->input->clean_gpc('p', 'lid', TYPE_UINT);
	$sh = $vbulletin->input->clean_gpc('p', 'sh', TYPE_UINT);
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id = $lid");
	if (!$ladder)
	{
		print_no_permission();
	}
	if (!$tmntp['caneditladder'] && $ladder['cr_userid'] != $vbulletin->userinfo['userid'])
	{/*permissions*/
		print_no_permission();
	}
	$ladder['filter_round'] = $vbulletin->input->clean_gpc('p', 'round', TYPE_UINT);
	if (!$ladder['filter_round'])
	{
		$ladder['filter_round'] = 1;
	}
	$ladder['filter_group'] = $vbulletin->input->clean_gpc('p', 'group', TYPE_UINT);
	if (!$ladder['filter_group'])
	{
		$ladder['filter_group'] = 1;
	}
	$ladder['selected']['group_'.$ladder['filter_group']] = ' selected="selected"';
	$ladder['selected']['round_'.$ladder['filter_round']] = ' selected="selected"';
	$rowno = 0;
	if ($ladder['filter_round']==1)
	{
		$sql_g = 'round';
	}
	else
	{
		$sql_g = 'round'.$ladder['filter_round'];
	}
	$pq = $vbulletin->db->query_read("
		SELECT p.*, " . (!$team ? "u.username" : "u.teamname AS username") . " 
		FROM " . TABLE_PREFIX . "tmnt_ladder_players AS p
		" . (!$team ? "LEFT JOIN " . TABLE_PREFIX . "user AS u ON (p.userid = u.userid)" : "LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS u ON (p.userid = u.teamid)") . "
		WHERE p.lid = '$lid' 
			AND p.group = '".$ladder['filter_group']."'
	");
	while($p = $vbulletin->db->fetch_array($pq))
	{
		$p['rpos'] = $p["$sql_g"];
		$p['sel']["$sql_g"] = ' selected="selected"';
		$pcount++;
		$parray[] = $p;
		$pos = $vbulletin->input->clean_gpc('p', 'id_'.$p['id'], TYPE_UINT);
		$vbulletin->db->query_write("
			UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
			SET round" . ($ladder['filter_round']>1 ? $ladder['filter_round'] : "") . " = '$pos'
			WHERE lid='$lid' AND id = '".$p['id']."'
		");
	}
	require_once(DIR . '/includes/functions_tll_racemode.php');
	tll_league_racemode_refreshxp($ladder);
	$vbulletin->url = "ladders.php?do=view&amp;id=$lid&sh=$sh&group=".$ladder['filter_group']."&round=".$ladder['filter_round'];
	eval(print_standard_redirect('redirect_updatechal'));
}

// #############################################################################

if ($_REQUEST['do'] == 'allchallenges')
{
	if (!$tmntp['caneditladder'])
	{
		print_no_permission();
	}
	$from = 'allchallenges';
	$rowcount = 0;
	$team = false;
	$show['delete'] = true;
	$templater = vB_Template::create('tmnt_ladder_all_chll_top');
		$templater->register('tmntp', $tmntp);
		$templater->register('rowno', $rowno);
		$templater->register('team', $team);
	$tlhtml .= $templater->render();
	$games = $vbulletin->db->query_read("
		SELECT games.*, games.u AS uid, games.u2 AS u2id, ladders.title AS ltitle, user.username AS u, user2.username AS u2
		FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
		LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders
			ON (games.lid = ladders.id)
		LEFT JOIN " . TABLE_PREFIX . "user AS user
			ON (games.u = user.userid)
		LEFT JOIN " . TABLE_PREFIX . "user AS user2
			ON (games.u2 = user2.userid)
		WHERE games.finished = 0
			AND games.accepted != -1
			AND games.pot = 0
		ORDER BY lid, round ASC, games.group ASC
		LIMIT 0, 100
		");
	$chllarray = array();
	$mc_ids_array = array();
	$lastltitle = '';
	while($game = $vbulletin->db->fetch_array($games))
	{
		$game['script'] = 'allchallenges';
		$game['display'] = 'none';
		if ($game['comments'] > 0)
		{
			$mc_ids_array[] = $game['id'];
		}
		$game = process_chal_options($game);
		$game['showltitle'] = false;
		if ($lastltitle != $game['ltitle'])
		{
			$game['showltitle'] = true;
			$game['ladderurl'] = $thisurl = tll_seo('ladder', $game['lid'], $game['ltitle']);
		}
		$lastltitle = $game['ltitle'];
		if ($game['uid'] == $thisuserid)
		{
			$is_u = true;
		}
		else
		{
			$is_u = false;
		}
		if ($game['u2id'] == $thisuserid)
		{
			$is_u2 = true;
		}
		else
		{
			$is_u2 = false;
		}
		$lid = $game['lid'];
		$game['time'] = vbdate($vbulletin->options['timeformat'],$game['time']).$vbphrase['ladder_on'].vbdate($vbulletin->options['dateformat'],$game['time']);
		//$show['flags'] = true;//commented out for time being
		//start match status
		if ($game['accepted'] == 0)
		{
			$game['status'] = $vbphrase[tmnt_awaiting_acceptance];
			if ($is_u2)
			{
				$game['status'] = $game['status'].'. <br /> <a href="ladder_match.php?do=accept&amp;id='.$game['id'].'&amp;u='.$game['uid'].'">'.$vbphrase[tmnt_accept_now].'</a>! <br /> <a href="ladder_match.php?do=reject&amp;id='.$game['id'].'">'.$vbphrase[tmnt_reject_now].'</a>!';
			}
			$game['showflags'] = false;
		}
		elseif ($game['agree_u'] == 0 && $game['agree_u2'] == 0)
		{
			if ($is_u OR $is_u2)
			{
				$game['status'] = $vbphrase[tmnt_awaiting_scores] . ' <br /><a href="ladder_match.php?do=submitscore&amp;id='.$game['id'].'">' . $vbphrase[tmnt_submit_score_now].'</a>!';
			}
			else
			{
				$game['status'] = 'Awaiting scores from both players.';
			}
		}
		elseif ($game['agree_u'] == 0)
		{
			if ($is_u)
			{
				$game['status'] = $vbphrase[tmnt_awaiting_your_score] . '. <br /><a href="ladder_match.php?do=submitscore&amp;id='.$game['id'].'">' . $vbphrase[tmnt_submit_score_now] . '</a>!';
			}
			else
			{
				$game['status'] = $vbphrase[tmnt_awaiting_opponents_score];
			}
		}
		elseif ($game['agree_u2'] == 0)
		{
			if ($is_u2)
			{
				$game['status'] = $vbphrase[tmnt_awaiting_your_score] . '. <br /><a href="ladder_match.php?do=submitscore&amp;id='.$game['id'].'">' . $vbphrase[tmnt_submit_score_now] . '</a>!';
			}
			else
			{
				$game['status'] = $vbphrase[tmnt_awaiting_opponents_score];
			}
		}
		//end match status
		$rowno++;
		if ($game['comments'] > 0)
		{
			$mc_ids_array[] = $game['id'];
		}
		$chllarray["$game[id]"] = $game;
	}
	if (!empty($mc_ids_array))
	{
		$chllarray = fetch_ladder_mcs($mc_ids_array, $chllarray);
	}
	$templater = vB_Template::create('tmnt_ladder_chll');
		$templater->register('tmntp', $tmntp);
		$templater->register('rowno', $rowno);
		$templater->register('show', $show);
		$templater->register('from', $from);
		$templater->register('chllarray', $chllarray);
	$tlhtml .= $templater->render();
	$team = true;
	$templater = vB_Template::create('tmnt_ladder_chll_bot');
		$templater->register('tmntp', $tmntp);
		$templater->register('rowno', $rowno);
		$templater->register('team', $team);
	$tlhtml .= $templater->render();
	$tlhtml .= "<br />";
	$userid = $thisuserid;
		$rowcount = 0;
		$team = true;
		$templater = vB_Template::create('tmnt_ladder_all_chll_top');
		$templater->register('tmntp', $tmntp);
		$templater->register('rowno', $rowno);
		$templater->register('team', $team);
		$tlhtml .= $templater->render();
		$games = $vbulletin->db->query_read("
			SELECT games.*, games.u AS uid, games.u2 AS u2id, ladders.title AS ltitle, user.teamname AS u, user2.teamname AS u2
			FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
			LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders
				ON (games.lid = ladders.id)
			LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS user
				ON (games.u = user.teamid)
			LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS user2
				ON (games.u2 = user2.teamid)
			WHERE games.finished = 0
				AND games.accepted != -1
				AND games.pot = 1
			LIMIT 0, 100
		");
		$lastltitle = '';
		$chllarray = array();
		$mc_ids_array = array();
		while($game = $vbulletin->db->fetch_array($games))
		{
			$game['script'] = 'allchallenges';
			$game['display'] = 'none';
			$game = process_chal_options($game);
			$lid = $game['lid']; 
			$game['showltitle'] = false;
			if ($lastltitle != $game['ltitle'])
			{
				$game['showltitle'] = true;
				$game['ladderurl'] = $thisurl = tll_seo('ladder', $game['lid'], $game['ltitle']);
			}
			$lastltitle = $game['ltitle'];
			$game['time'] = vbdate($vbulletin->options['timeformat'],$game['time']).$vbphrase['ladder_on'].vbdate($vbulletin->options['dateformat'],$game['time']);
			$is_u = false;
			$is_u2 = false;
			//start match status
			if ($game['accepted'] == 0)
			{
				$game['status'] = $vbphrase[tmnt_awaiting_acceptance];
				if ($is_u2)
				{
					$game['status'] = $game['status'].'. <br /> <a href="ladder_match.php?do=teamaccept&amp;id='.$game['id'].'">'.$vbphrase[tmnt_accept_now].'</a>! <br /> <a href="ladder_match.php?do=teamreject&amp;id='.$game['id'].'">'.$vbphrase[tmnt_reject_now].'</a>!';
				}
			}
			elseif ($game['agree_u'] == 0 && $game['agree_u2'] == 0)
			{
				if ($is_u OR $is_u2)
				{
					$game['status'] = $vbphrase[tmnt_awaiting_scores] . ' <br /><a href="ladder_match.php?do=submitscore&amp;id='.$game['id'].'">' . $vbphrase[tmnt_submit_score_now].'</a>!';
				}
				else
				{
					$game['status'] = 'Awaiting scores from both teams.';
				}
			}
			elseif ($game['agree_u'] == 0)
			{
				if ($is_u)
				{
					$game['status'] = $vbphrase[tmnt_awaiting_your_score] . '. <br /><a href="ladder_match.php?do=submitscore&amp;id='.$game['id'].'">' . $vbphrase[tmnt_submit_score_now] . '</a>!';
				}
				else
				{
					$game['status'] = $vbphrase[tmnt_awaiting_opponents_score];
				}
			}
			elseif ($game['agree_u2'] == 0)
			{
				if ($is_u2)
				{
					$game['status'] = $vbphrase[tmnt_awaiting_your_score] . '. <br /><a href="ladder_match.php?do=submitscore&amp;id='.$game['id'].'">' . $vbphrase[tmnt_submit_score_now] . '</a>!';
				}
				else
				{
					$game['status'] = $vbphrase[tmnt_awaiting_opponents_score];
				}
			}
			//end match status
			$rowno++;
			if ($game['comments'] > 0)
			{
				$mc_ids_array[] = $game['id'];
			}
			$chllarray["$game[id]"] = $game;
		}
		if (!empty($mc_ids_array))
		{
			$chllarray = fetch_ladder_mcs($mc_ids_array, $chllarray);
		}
		$templater = vB_Template::create('tmnt_ladder_chll');
			$templater->register('tmntp', $tmntp);
			$templater->register('team', $team);
			$templater->register('from', $from);
			$templater->register('chllarray', $chllarray);
		$tlhtml .= $templater->render();
		$templater = vB_Template::create('tmnt_ladder_chll_bot');
			$templater->register('tmntp', $tmntp);
			$templater->register('rowno', $rowno);
			$templater->register('team', $team);
		$tlhtml .= $templater->render();
	
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladders'],
		'' => construct_phrase($vbphrase['ladder_all_chlls'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'reportedmatches')
{
	if (!$tmntp['caneditladder'])
	{
		print_no_permission();
	}
	$rowcount = 0;
	$rowno = 0;
	$mc_ids_array = array();
	$chllarray = array();
	$games = $vbulletin->db->query_read("
		SELECT games.*, games.u AS uid, games.u2 AS u2id, ladders.title AS laddertitle, user.username AS u, user2.username AS u2
		FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
		LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders
			ON (games.lid = ladders.id)
		LEFT JOIN " . TABLE_PREFIX . "user AS user
			ON (games.u = user.userid)
		LEFT JOIN " . TABLE_PREFIX . "user AS user2
			ON (games.u2 = user2.userid)
		WHERE games.finished = 0
			AND games.accepted = 1
			AND games.pot = 0
			AND games.flag != 0
		");
	while($game = $vbulletin->db->fetch_array($games))
	{
		//query comments dispute == 1
		$lid = $game['lid'];
		if ($game['flag'] == $game['uid'])
		{
			$game['flag'] = $game['u'];
		}
		elseif ($game['flag'] == $game['u2id'])
		{
			$game['flag'] = $game['u2'];
		}
		$game['display'] = 'none';
		$game['time'] = vbdate($vbulletin->options['timeformat'],$game['time']).$vbphrase['ladder_on'].vbdate($vbulletin->options['dateformat'],$game['time']);
		$rowno++ ;
		if ($game['comments'] > 0)
		{
			$mc_ids_array[] = $game['id'];
		}
		$chllarray["$game[id]"] = $game;
	}
	$games = $vbulletin->db->query_read("
		SELECT games.*, games.u AS uid, games.u2 AS u2id, ladders.title AS laddertitle, t.teamname AS u, t2.teamname AS u2, f.username AS flag, ladders.catid
		FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
		LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders
			ON (games.lid = ladders.id)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS t
			ON (games.u = t.teamid)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS t2
			ON (games.u2 = t2.teamid)
		LEFT JOIN " . TABLE_PREFIX . "user AS f
			ON (games.flag = f.userid)
		WHERE games.finished = 0
			AND games.accepted = 1
			AND games.pot = 1
			AND games.flag != 0
		");
	while($game = $vbulletin->db->fetch_array($games))
	{
		$lid = $game['lid'];
		$game['display'] = 'none';
		$game['time'] = vbdate($vbulletin->options['timeformat'],$game['time']).$vbphrase['ladder_on'].vbdate($vbulletin->options['dateformat'],$game['time']);
		$rowno++ ;
		if ($game['comments'] > 0)
		{
			$mc_ids_array[] = $game['id'];
		}
		if ($game['catid'])
		{
			$game['categorytitle'] = $vbulletin->tll_catcache["$game[catid]"]['title'];
			$game['caturl'] = $vbulletin->tll_catcache["$game[catid]"]['url'];
		}
		$chllarray["$game[id]"] = $game;
	}
	if (!empty($mc_ids_array))
	{
		$chllarray = fetch_ladder_mcs($mc_ids_array, $chllarray);
	}
	$templater = vB_Template::create('tmnt_ladder_repmatch');
		$templater->register('tmntp', $tmntp);
		$templater->register('lid', $lid);
		$templater->register('rowno', $rowno);
		$templater->register('chllarray', $chllarray);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladders'],
		'' => construct_phrase($vbphrase['ladder_reported_matches'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('headinclude', $headinclude);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('tlhtml', $tlhtml);
		$templater->register('modname', $modname);
		$templater->register('header', $header);
		$templater->register('footer', $footer);
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_POST['do'] == 'insertmc')
{
	if (!$tmntp['canmcomment'])
	{
		print_no_permission();
	}
	if ($vbulletin->userinfo['userid'] == 0)
	{
		print_no_permission();
	}
	$mid = $vbulletin->input->clean_gpc('p', 'mid', TYPE_UINT);
	$u1 = $vbulletin->input->clean_gpc('p', 'u1', TYPE_UINT);
	$u2 = $vbulletin->input->clean_gpc('p', 'u2', TYPE_UINT);
	$dispute = $vbulletin->input->clean_gpc('p', 'dispute', TYPE_BOOL);
		if (!$mid)
		{
			$errormessage = $vbphrase['error_invalid_match'];
        	eval(standard_error($errormessage));
		}
	$lid = $vbulletin->input->clean_gpc('p', 'lid', TYPE_UINT);
		if (!$lid)
		{
			$errormessage = $vbphrase['error_invalid_ladder'];
        	eval(standard_error($errormessage));
		}
	$sh = $vbulletin->input->clean_gpc('p', 'sh', TYPE_UINT);
	$from = $vbulletin->input->clean_gpc('p', 'from', TYPE_NOHTML);
	$userid = $thisuserid;
	$username = $thisusername;
	$comment = $vbulletin->input->clean_gpc('p', 'comment', TYPE_NOHTML);
	if (!$comment)
	{
		$errormessage = $vbphrase['error_invalid_message'];
		eval(standard_error($errormessage));
	}
	$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "tmnt_ladder_mcs
		(mid, comment, userid, username, dateline, dispute)
		VALUES ('".$mid."', '".$vbulletin->db->escape_string($comment)."', '".$userid."',  '".$vbulletin->db->escape_string($username)."', ".TIMENOW.",  '".$vbulletin->db->escape_string($dispute)."' )
		");
	$id = $vbulletin->db->insert_id();
	if ($dispute)
	{
		$vbulletin->url = "ladders.php?do=reportedmatches&mid=$mid#match$mid";
	}
	elseif ($from)
	{
		$vbulletin->url = "ladders.php?do=".$from.($from=='search_matches' ? "&id=$lid&u1=$u1&u2=$u2" : "")."&mid=$mid#match$mid";
	}
	elseif ($sh)
	{
		$vbulletin->url = "ladders.php?do=view&id=$lid&sh=$sh&mid=$mid#match$mid";
	}
	else
	{
		$vbulletin->url = "ladders.php?do=view&id=$lid&sh=1&mid=$mid#match$mid";
	}
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET comments = comments + 1 WHERE id = $mid");
	eval(print_standard_redirect('redirect_tmntcomment'));
}

// #############################################################################

if ($_REQUEST['do'] == 'elorating') 
{
	if (!$tmntp['canviewladder'])
	{
		print_no_permission();
	}
	$rank_u = $vbulletin->input->clean_gpc('g', 'rank_u', TYPE_UINT);
	$rank_u2 = $vbulletin->input->clean_gpc('g', 'rank_u2', TYPE_UINT);
	if ($rank_u == 0 && $rank_u2 == 0)
	{
		$rank_u = $rank_u2 = 1000;
	}
	$score_u = $vbulletin->input->clean_gpc('g', 'score_u', TYPE_UINT);
	$score_u2 = $vbulletin->input->clean_gpc('g', 'score_u2', TYPE_UINT);
	list($newrank_u, $newrank_u2, $uod_u, $uod_u2, $player_u, $player_u2) = calc_elo($rank_u, $rank_u2, $score_u, $score_u2, 1, 1, 0, 0, 0);
	$e = array();
	$e['e_u'] = $newrank_u - $rank_u;
	if ($e['e_u']<0)
	{
		$e['e_u'] = "<span style=\"color: #FF0000; font-weight: bold;\">" . $e['e_u'] . "</span>";
	}
	else
	{
		$e['e_u'] = "<span style=\"color:  #00611C; font-weight: bold;\">+" . $e['e_u'] . "</span>";
	}
	$e['e_u2'] = $newrank_u2 - $rank_u2;
	if ($e['e_u2']<0)
	{
		$e['e_u2'] = "<span style=\"color: #FF0000; font-weight: bold;\">" . $e['e_u2'] . "</span>";
	}
	else
	{
		$e['e_u2'] = "<span style=\"color:  #00611C; font-weight: bold;\">+" . $e['e_u2'] . "</span>";
	}
	$templater = vB_Template::create('tmnt_ladder_elorating');
		$templater->register('tmntp', $tmntp);
		$templater->register('score_u', $score_u);
		$templater->register('score_u2', $score_u2);
		$templater->register('rank_u', $rank_u);
		$templater->register('rank_u2', $rank_u2);
		$templater->register('newrank_u', $newrank_u);
		$templater->register('newrank_u2', $newrank_u2);
		$templater->register('e', $e);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladders'],
		'' => construct_phrase($vbphrase['ladder_elorating_calc'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('headinclude', $headinclude);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('tlhtml', $tlhtml);
		$templater->register('modname', $modname);
		$templater->register('header', $header);
		$templater->register('footer', $footer);
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'create_player_image')
{
	$vbulletin->input->clean_array_gpc('g', array(
		'l' => TYPE_UINT,
		'w' => TYPE_UINT,
		'h' => TYPE_UINT,
		'u' => TYPE_UINT,
		'bw' => TYPE_UINT,
		'noavatar' => TYPE_UINT,
		'f' => TYPE_UINT,
		'bg' => TYPE_NOHTML,
		'b' => TYPE_NOHTML,
		'c' => TYPE_NOHTML,
		'bgurl' => TYPE_NOHTML,
		'elo' => TYPE_UINT,
	));
	$var = array(
		'l' => $vbulletin->GPC['l'],
		'w' => ($vbulletin->GPC['w'] ? $vbulletin->GPC['w'] : 250),
		'h' => ($vbulletin->GPC['h'] ? $vbulletin->GPC['h'] : 90),
		'u' => $vbulletin->GPC['u'],
		'bw' => ($vbulletin->GPC['bw'] ? $vbulletin->GPC['bw'] : 1),
		'noavatar' => $vbulletin->GPC['noavatar'],
		'f' => $vbulletin->GPC['f'],
		'bg' => ($vbulletin->GPC['bg'] ? $vbulletin->GPC['bg'] : 'FFFFFF'),
		'b' => ($vbulletin->GPC['b'] ? $vbulletin->GPC['b'] : '000000'),
		'c' => ($vbulletin->GPC['c'] ? $vbulletin->GPC['c'] : '000000'),
		'bgurl' => ($vbulletin->GPC['bgurl'] ? $vbulletin->GPC['bgurl'] : ''),
		'elo' => ($vbulletin->GPC['elo'] ? 1 : 0),
	);
	$ladder_array = array();
	$ladders_query = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders ORDER BY title ASC");
	while ($l = $vbulletin->db->fetch_array($ladders_query))
	{
		if ($l['id'] == $vbulletin->GPC['l'])
		{
			$l['selected'] = ' selected="selected"';
			}
		$ladder_array["$l[id]"] = $l;
	}
	if ($vbulletin->GPC['l'])
	{//fetch ladder players, if l is valid
		$player_array = array();
		$players_query = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid = '".$var['l']."' AND active = 1 ORDER BY username ASC");
		while ($p = $vbulletin->db->fetch_array($players_query))
		{
			if ($p['userid']==$vbulletin->GPC['u'])
			{
				$p['selected'] = ' selected="selected"';
				$srt = true;
			}
			$player_array["$p[userid]"] = $p;
		}
		if (!$srt)
		{
			$vbulletin->GPC['u'] = $var['u'] = 0;
		}
	}
	$templater = vB_Template::create('tmnt_ladder_cpi');
		$templater->register('tmntp', $tmntp);
		$templater->register('ladders', $ladder_array);
		$templater->register('players', $player_array);
		$templater->register('var', $var);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladders'],
		'' => $vbphrase['ladder_create_player_image']
	));
	$navbar = render_navbar_template($navbits);
	$show['usernameajax'] = true;
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('show', $show);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_POST['do'] == 'updatesquad')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'mid' => TYPE_UINT,
		'u_userids' => TYPE_ARRAY_UINT,
		'u2_userids' => TYPE_ARRAY_UINT,
		'sh' => TYPE_UINT,
		'from' => TYPE_NOHTML,
	));
	$mid = $vbulletin->GPC['mid'];
	$game = $match = $vbulletin->db->query_first("
		SELECT g.*, u.teamname AS u_teamname, u2.teamname AS u2_teamname
		FROM " . TABLE_PREFIX . "tmnt_ladder_games AS g
		LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS u
			ON (g.u = u.teamid)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS u2
			ON (g.u2 = u2.teamid)
		WHERE g.id = '$mid' AND g.finished = 0");
	//print_r($game);
	if (!$game['pot'])
	{
		print_no_permission();
	}
	$controls_u = $controls_u2 = false;
	$players_u = $players_u2 = array();
	if ($game['u_squad'])
	{
		$game['u_squad'] = explode(',',$game['u_squad']);
	}
	else
	{
		$game['u_squad'] = array();
	}
	if ($game['u2_squad'])
	{
		$game['u2_squad'] = explode(',',$game['u2_squad']);
	}
	else
	{
		$game['u2_squad'] = array();
	}
	//check team perms
	$team_u_query = $vbulletin->db->query_read("
		SELECT m.*, u.username
		FROM " . TABLE_PREFIX . "tmnt_members AS m
		LEFT JOIN " . TABLE_PREFIX . "user AS u
			ON (u.userid = m.userid)
		WHERE m.teamid = '".$game['u']."'
			AND m.accepted = 1
	");
	while($teamplayer = $vbulletin->db->fetch_array($team_u_query))
	{
		if ($teamplayer['userid'] == $vbulletin->userinfo['userid'] && $teamplayer['leader'])
		{
			$controls_u = true;
		}
		if (in_array($teamplayer['userid'], $game['u_squad']))
		{
			$teamplayer['selected'] = ' checked="checked"';
		}
		$players_u[] = $teamplayer;
	}
	$team_u2_query = $vbulletin->db->query_read("
		SELECT m.*, u.username
		FROM " . TABLE_PREFIX . "tmnt_members AS m
		LEFT JOIN " . TABLE_PREFIX . "user AS u
			ON (u.userid = m.userid)
		WHERE m.teamid = '".$game['u2']."'
			AND m.accepted = 1
	");
	while($teamplayer = $vbulletin->db->fetch_array($team_u2_query))
	{
		if ($teamplayer['userid'] == $vbulletin->userinfo['userid'] && $teamplayer['leader'])
		{
			$controls_u2 = true;
		}
		if (in_array($teamplayer['userid'], $game['u2_squad']))
		{
			$teamplayer['selected'] = ' checked="checked"';
		}
		$players_u2[] = $teamplayer;
	}
	if (!$controls_u && !$controls_u2)
	{
		print_no_permission();
	}
	
	if ($controls_u)
	{
		if ($vbulletin->GPC['u_userids'] && is_array($vbulletin->GPC['u_userids']))
		{
			if (count($vbulletin->GPC['u_userids']) != $game['squadsize'])
			{
				$errormessage = 'Error: Please only select ' . $game['squadsize'] . ' players for challenger team\'s squad.';
				eval(standard_error($errormessage));
			}
			$vbulletin->GPC['u_userids'] = implode(',', $vbulletin->GPC['u_userids']);
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_games
				SET u_squad = '".$vbulletin->db->escape_string($vbulletin->GPC['u_userids'])."'
				WHERE id = '".$vbulletin->GPC['mid']."'
			");
		}
	}
	if ($controls_u2)
	{
		if ($vbulletin->GPC['u2_userids'] && is_array($vbulletin->GPC['u2_userids']))
		{
			if (count($vbulletin->GPC['u2_userids']) != $game['squadsize'])
			{
				$errormessage = 'Error: Please only select ' . $game['squadsize'] . ' players for challenged team\'s squad.';
				eval(standard_error($errormessage));
			}
			$vbulletin->GPC['u2_userids'] = implode(',', $vbulletin->GPC['u2_userids']);
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_games
				SET u2_squad = '".$vbulletin->db->escape_string($vbulletin->GPC['u2_userids'])."'
				WHERE id = '".$vbulletin->GPC['mid']."'
			");
		}
	}
	if (in_array($vbulletin->GPC['from'],array('ladder', 'ladders')))
	{
		$l = fetch_ladderinfo($game['lid']);
		$vbulletin->url = $l['url']."&sh=".$vbulletin->GPC['sh']."#match".$mid;
	}
	else
	{
		$vbulletin->url = "ladders.php?do=challenges&mid=".$mid."#match".$mid;
	}
	eval(print_standard_redirect('redirect_updatedsquad'));
}

// #############################################################################

if ($_REQUEST['do'] == 'editsquad')
{
	$vbulletin->input->clean_array_gpc('g', array(
		'sh' => TYPE_UINT,
		'from' => TYPE_NOHTML,
	));
	$mid = $vbulletin->input->clean_gpc('g', 'mid', TYPE_UINT);
	$game = $match = $vbulletin->db->query_first("
		SELECT g.*, u.teamname AS u_teamname, u2.teamname AS u2_teamname
		FROM " . TABLE_PREFIX . "tmnt_ladder_games AS g
		LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS u
			ON (g.u = u.teamid)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS u2
			ON (g.u2 = u2.teamid)
		WHERE g.id = '$mid' AND g.finished = 0");
	if (!$game['pot'])
	{
		print_no_permission();
	}
	$controls_u = $controls_u2 = false;
	$players_u = $players_u2 = array();
	if ($game['u_squad'])
	{
		$game['u_squad'] = explode(',',$game['u_squad']);
	}
	else
	{
		$game['u_squad'] = array();
	}
	if ($game['u2_squad'])
	{
		$game['u2_squad'] = explode(',',$game['u2_squad']);
	}
	else
	{
		$game['u2_squad'] = array();
	}
	//check team perms
	$team_u_query = $vbulletin->db->query_read("
		SELECT m.*, u.username
		FROM " . TABLE_PREFIX . "tmnt_members AS m
		LEFT JOIN " . TABLE_PREFIX . "user AS u
			ON (u.userid = m.userid)
		WHERE m.teamid = '".$game['u']."'
			AND m.accepted = 1
	");
	while($teamplayer = $vbulletin->db->fetch_array($team_u_query))
	{
		if ($teamplayer['userid'] == $vbulletin->userinfo['userid'] && $teamplayer['leader'])
		{
			$controls_u = true;
		}
		if (in_array($teamplayer['userid'], $game['u_squad']))
		{
			$teamplayer['checked'] = ' checked="checked"';
		}
		$players_u[] = $teamplayer;
	}
	$team_u2_query = $vbulletin->db->query_read("
		SELECT m.*, u.username
		FROM " . TABLE_PREFIX . "tmnt_members AS m
		LEFT JOIN " . TABLE_PREFIX . "user AS u
			ON (u.userid = m.userid)
		WHERE m.teamid = '".$game['u2']."'
			AND m.accepted = 1
	");
	while($teamplayer = $vbulletin->db->fetch_array($team_u2_query))
	{
		if ($teamplayer['userid'] == $vbulletin->userinfo['userid'] && $teamplayer['leader'])
		{
			$controls_u2 = true;
		}
		if (in_array($teamplayer['userid'], $game['u2_squad']))
		{
			$teamplayer['checked'] = ' checked="checked"';
		}
		$players_u2[] = $teamplayer;
	}
	$max = min(count($players_u),count($players_u2));
	if ($max && $max < $game['squadsize'])
	{
		$game['squadsize'] = $max;
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET squadsize = '$max' WHERE id='$mid' ");
	}
	if (!$controls_u && !$controls_u2)
	{
		print_no_permission();
	}
	$templater = vB_Template::create('tmnt_ladder_editsquad');
		$templater->register('tmntp', $tmntp);
		$templater->register('game', $game);
		$templater->register('controls_u', $controls_u);
		$templater->register('controls_u2', $controls_u2);
		$templater->register('players_u', $players_u);
		$templater->register('players_u2', $players_u2);
		$templater->register('from', $vbulletin->GPC['from']);
		$templater->register('sh', $vbulletin->GPC['sh']);
	$tlhtml .= $templater->render();
	
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladders'],
		'' => 'Edit Squad'
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'reportchallenge')
{
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	$games = $vbulletin->db->query_first("
		SELECT ladders.*, games.*
		FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
		LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders
			ON(games.lid=ladders.id)
		WHERE games.id = '$id'
	");
	if ($games['pot'])
	{
		$teamids = array();
		$teams = $vbulletin->db->query_read("
			SELECT *
			FROM " . TABLE_PREFIX . "tmnt_members AS members
			JOIN " . TABLE_PREFIX . "tmnt_teams AS teams
				on members.teamid = teams.teamid
			WHERE members.leader=1
				AND members.userid='$thisuserid'");
		while($team = $vbulletin->db->fetch_array($teams))
		{
			$teamids = array_merge((array)$team['teamid'], $teamids);
		}
	}
	if (
		!$games['flag'] &&
		( (($vbulletin->userinfo['userid'] == $games['u'] OR $vbulletin->userinfo['userid'] == $games['u2']) && !$games['pot'])
		OR
		( (in_array($games['u'], $teamids) OR in_array($games['u2'], $teamids)) && $games['pot']) )
		)
	{
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET flag = '" . $vbulletin->userinfo['userid'] . "' WHERE id = '$id' ");
	}
	if ($tmntp['canusetickets'])
	{
		$vbulletin->url = "tll_tickets.php?do=new&challengeid=".$id."&ladderid=".$games['lid'];
	}
	else
	{
		$vbulletin->url = "ladders.php?do=challenges&mid=".$id."#match".$id;
	}
	eval(print_standard_redirect('redirect_matchreported'));
}

// #############################################################################

$vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);

if (!$_REQUEST['do'] && $vbulletin->options['tmnt_premium'] && !$vbulletin->GPC['id'] && isset($_SERVER['REQUEST_URI']))
{
	$thisurl = explode('/',$vbulletin->input->clean($_SERVER['REQUEST_URI'], TYPE_NOHTML));
	$thisurl = end($thisurl);
	if (substr($thisurl, 0, 13)=='ladders.php?l' && strlen($thisurl)>13)
	{
		$id = $lid = $vbulletin->input->clean(substr($thisurl,13), TYPE_UINT);
		if ($lid)
		{
			$_REQUEST['do'] = 'view';
			$_REQUEST['id'] = $lid;
		}
	}
}

if ($_REQUEST['do'] == 'view')
{
	if (!$tmntp['canviewladder'])
	{
		print_no_permission();
	}
	if ($tmntp['caneditladder'] && file_exists(DIR . '/tll_modules/tll_editcolors.php'))
	{
		$tmntp['caneditcolors'] = true;
	}
	if (!$lid)
	{
		$lid = $id = $vbulletin->GPC['id'];
	}
	if (!$id)
	{
		$errormessage = $vbphrase[error_invalid_ladder];
        eval(standard_error($errormessage));
	}
	$ladder = $vbulletin->db->query_first("
		SELECT ladders.*, ladders.cr_userid AS userid, ladders.cr_username AS username
		FROM " . TABLE_PREFIX . "tmnt_ladders AS ladders
		WHERE ladders.id = '$id'
	");
	($hook = vBulletinHook::fetch_hook('tll_ladder_view_post_query')) ? eval($hook) : false;
	if (!$ladder)
	{
		$errormessage = $vbphrase[error_invalid_ladder];
        eval(standard_error($errormessage));
	}
	$ladder['url'] = tll_seo(($ladder['league'] > 0 ? 'league' : 'ladder'), $ladder['id'], $ladder['title'], 1);
	if ($ladder['password'] && $vbulletin->options['tmnt_premium'])
	{
		require_once(DIR . '/includes/functions_tll_prem.php');	
		check_tmnt_password('view', 'ladder');
		$ladder['url'] .= '&amp;password='.$ladder['password'];
	}
	if ($vbulletin->options['tmnt_premium'] && $vbulletin->options['tmnt_seo'] && !$thisurl && isset($_SERVER['REQUEST_URI']))
	{
		$thisurl = end(explode('/',$vbulletin->input->clean($_SERVER['REQUEST_URI'], TYPE_NOHTML)));
		if (substr($thisurl, 0, 27)=='ladders.php?do=view&amp;id=')
		{
			$thisurl = str_replace('&amp;','&',$ladder['url'].substr($thisurl,27+strlen($id)));
			Header( "HTTP/1.1 301 Moved Permanently" ); 
			Header( "Location: ".$vbulletin->options['bburl']."/".$thisurl ); 
		}
	}
	if ($ladder['catid'])
	{
		$ladder['categorytitle'] = $vbulletin->tll_catcache["$ladder[catid]"]['title'];
		$ladder['categoryurl'] = $vbulletin->tll_catcache["$ladder[catid]"]['url'];
		$ladder['parentid'] = $vbulletin->tll_catcache["$ladder[catid]"]['parentid'];
		if ($ladder['parentid'])
		{
			$ladder['parenttitle'] = $ladder['categorytitle2'] = $vbulletin->tll_catcache["$ladder[parentid]"]['title'];
			$ladder['parenturl'] = $vbulletin->tll_catcache["$ladder[parentid]"]['url'];
		}
	}
	$ladder['tmnt_status'] = $ladder['status'];
	if ($ladder['knockout'] > 0)
	{
		$vbphrase['ladder_singles_league'] = $vbphrase['ladder_singles_league_knockout'];
	}
	if ($ladder['league'] > 0)
	{
		$vbulletin->options['tmnt_ladder_ranking'] = 'xp';
		$vbulletin->options['tmnt_elorating'] = 0;
		if ($ladder['pot'])
		{
			$ladder['typetext'] = $vbphrase['ladder_teams_league'];
		}
		else
		{
			$ladder['typetext'] = $vbphrase['ladder_singles_league'];
		}
		$vbphrase['ladder'] = $vbphrase['ladder_league'];
		$vbphrase['ladder_insertmatch'] = $vbphrase['league_insertmatch'];
		$vbphrase['ladder_join'] = $vbphrase['ladder_league_join'];
		$vbphrase['ladder_leave'] = $vbphrase['ladder_league_leave'];
		$vbphrase['ladder_delete'] = $vbphrase['ladder_league_delete'];
		$vbphrase['ladder_details'] = $vbphrase['ladder_league_details'];
		$vbphrase['ladder_closing_on'] = $vbphrase['league_closing_on'];
		$vbphrase['ladder_starting_on'] = $vbphrase['league_starting_on'];
		$vbphrase['ladder_finished_on'] = $vbphrase['league_finished_on'];
	}
	else
	{
		if ($ladder['pot'])
		{
			$ladder['typetext'] = $vbphrase['ladder_teams_ladder'];
		}
		else
		{
			$ladder['typetext'] = $vbphrase['ladder_singles'];
		}
	}
	if ($ladder['cr_userid']==$vbulletin->userinfo['userid'])
	{
		$tmntp['caneditladder'] = 1;
	}
	$ladder['groupnames'] = explode(',', $ladder['groupnames']);
	$ladder['urlencoded'] = urlencode($vbulletin->options['bburl']."/ladders.php?do=view&id=".$ladder['id']);
	if ($ladder['archive'] == 1 && $ladder['dateline_to'] && $ladder['dateline_from'] && $ladder['dateline_from'] <= TIMENOW && TIMENOW <= $ladder['dateline_to'])
	{
		$vbulletin->db->query_write("
			UPDATE " . TABLE_PREFIX . "tmnt_ladders SET archive = 0 WHERE id = '$id'
		");
		$ladder['archive'] = 0;
	}
	elseif ($ladder['archive'] == 0 && $ladder['dateline_to'] && $ladder['dateline_from'] && ($ladder['dateline_to'] < TIMENOW OR $ladder['dateline_from'] > TIMENOW))
	{
		if ($ladder['league'] != 1)
		{
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladders SET archive = 1 WHERE id = '$id'
			");
		}
		$ladder['archive'] = 1;
	}
	switch ($ladder['archive'])
	{
		case 0:
			$ladder['status'] = $vbphrase['ladder_open'];
			break;
		case 1:
			$ladder['status'] = $vbphrase['ladder_closed'];
			break;
	}
	if ($ladder['archive'] == 1 && $ladder['dateline_from'] && $ladder['dateline_from'] > TIMENOW)
	{
		$ladder['status'] = $vbphrase['ladder_startingsoon'];
	}
	if ($ladder['league'] == 1)
	{
		$ladder['archive'] = 0;
		$ladder['status'] = $vbphrase['ladder_signups'];
	}
	if ($ladder['groupid'])
	{
		$gladders = $vbulletin->db->query_read("
			SELECT *
			FROM " . TABLE_PREFIX . "tmnt_ladders
			WHERE groupid = '" . $ladder['groupid'] . "'
		");
		$sarray = array();
		while($gl = $vbulletin->db->fetch_array($gladders))
		{
			if ($gl['id'] == $ladder['id'])
			{
				$gl['selected'] = ' selected="selected"';
			}
			$sarray[] = $gl;
		}
		$gltitle = $vbphrase['tmnt_newladder'];
		if ($ladder['league'])
		{
			$gltitle = $vbphrase['tmnt_newleague'];
		}
		$sarray[] = array('id' => '999','title' => $gltitle);
	}
	if ($ladder['league']>1 && $ladder['credits_1st2nd3rd'])
	{
		$ladder = tll_process_league_credits($ladder);
		$processwinner = false;
		//check if finished
		if (!$ladder['credits_awarded'])
		{
			$countbq = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE lid='$lid' AND finished=0 ");
			if ($countbq['countrows']==0)
			{
				$_REQUEST['sh']=0;
				$processwinner = true;
				require_once(DIR . '/includes/functions_tll_prem.php');	
			}
		}
	}
	$ladder['dateline'] = vbdate($vbulletin->options['dateformat'],$ladder['cr_time']);
	$ladder['ed_time'] = vbdate($vbulletin->options['timeformat'],$ladder['ed_time']).$vbphrase['ladder_on'].vbdate($vbulletin->options['dateformat'],$ladder['ed_time']);
	$ladder['link'] = unserialize($ladder['link']);
	$title = $ladder['title'];
	$title2 = addslashes($ladder['title']);
	require_once(DIR . '/includes/class_bbcode.php');
	$bbcode_parser = new vB_BbCodeParser($vbulletin, fetch_tag_list(), true); 
	$ladder['description'] = $bbcode_parser->do_parse($ladder['description']);
	list($ladder['description'], $ladder['rules']) = preg_split('/\[rules\]/', $ladder['description']);
	$ladder['rules'] = trim($ladder['rules']);
	if (substr($ladder['rules'],0,6)=='<br />')
	{
		$ladder['rules'] = substr($ladder['rules'],6);
	}
	$ladder['rounds_text'] = unserialize($ladder['rounds_text']);
	if (file_exists(DIR . '/includes/functions_tll_tabs.php'))
	{
		$sh = $vbulletin->input->clean_gpc('g', 'sh', TYPE_UINT);
		require_once(DIR . '/includes/functions_tll_tabs.php');
		$template_hook = tll_tabs($template_hook, 0, $lid, 0);
		$show['addtab'] = true;
	}
	$team = false;
	if ($ladder['pot'])
	{
		$team = true;
	}
	$ladder['hide'] = $hide = $vbulletin->input->clean_gpc('g', 'hide', TYPE_NOHTML);
	
	if ($ladder['league'] > 0 && $vbulletin->options['tmnt_premium'] && $ladder['tmnt_status'] > 0)
	{
		$ladder['tmnt_act_pcount'] = $ladder['knockout'] * $ladder['groups'];//knockout-actual player count
		$ladder['tmnt_noplayers'] = ceil($ladder['tmnt_act_pcount'] / 4) * 4;//tmnt noplayers - includes dummy spaces
		$ladder['show_tmnt_h2'] = true;
		if ($_REQUEST['sh'] == 8)
		{
			$ladder['show_tmnt_div'] = true;
		}
	}
	if ($team && $sh > 0 && $sh != 3)
	{
		$cmpq = $vbulletin->db->query_first("
			SELECT COUNT(*) AS countrows
			FROM " . TABLE_PREFIX . "tmnt_ladder_players AS l
			LEFT JOIN " . TABLE_PREFIX . "tmnt_members AS m
				ON (m.teamid = l.userid AND m.userid = '".$vbulletin->userinfo['userid']."')
			WHERE l.lid = '$lid' AND m.id
		");
		$cmpq = $cmpq['countrows'];
		if ($cmpq > 0)
		{
			$comper = true;
		}
	}
	if (!in_array($_REQUEST['sh'], array(1,2,3,4,5,6,7,8)) || ($team && in_array($_REQUEST['sh'], array(5))))
	{//dominic3,
		$cpp = $vbulletin->input->clean($vbulletin->options['tmnt_lcpp'], TYPE_UINT);
		$countcomps = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players AS players WHERE lid=$lid AND active=1" . ($hide == 'unranked' ? " AND (players.wins > 0 OR players.draws >0 OR players.loses > 0) " : "") . "");
		$noofcomps = $countcomps['countrows'];
		if (!$hide && $noofcomps != $ladder['noplayers'])
		{
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladders SET noplayers = '".$noofcomps."' WHERE id = '$lid'");
			$ladder['noplayers'] = $noofcomps;
		}
		$lastpage = ceil($noofcomps/$cpp);
		$page = $vbulletin->input->clean_gpc('g', 'page', TYPE_UINT);
		if ($page == 0)
		{
			$page = 1;
		}
		elseif ($page > $lastpage)
		{
			$page = $lastpage;
		}
		$offset = ($page - 1) * $cpp;
		if ($offset < 0)
		{
			$offset = 0;
		}
	}
	if (!in_array($_REQUEST['sh'], array(1,2,3,4,5,6,7,8,9,10,11,12,13,14)) ||  (!$vbulletin->options['tmnt_showrules'] && $_REQUEST['sh'] == 6))
	{//($team && in_array($_REQUEST['sh'], array(3))) ||
		$row_css = $lc_array = array();
		$lc_query = $vbulletin->db->query_read("
			SELECT *
			FROM " . TABLE_PREFIX . "tmnt_leaguecolors
			WHERE lid='$lid'
		");
		$lc_i = 0;
		while($lc = $vbulletin->db->fetch_array($lc_query))
		{
			//$lc['from']
			while ($lc['from'] <= $lc['to'])
			{
				$row_css["$lc[from]"] .= 'background: #'.$lc['color'].';';
				$lc['from']++;
			}
		}
		$_REQUEST['sh'] = 0;
		$sh = 0;
		if ($lastpage > 1)
		{
			$showpaging = true;
		}
		else
		{
			$showpaging = false;
		}
		if ($noofcomps > 0)
		{
			$from = $offset + 1;
			if ($lastpage == $page) {
				$to = $noofcomps;
			} else {
				$to = $page * $cpp;
			}
		} else {
			$from = 0;
			$to = 0;
		}
		$ladder['colspan'] = 9;
		if ($tmntp['ladder_superuser'])
		{
			$ladder['colspan']++;
		}
		if (!$vbulletin->options['tmnt_elorating'])
		{
			$ladder['colspan']--;
		}	
		if ($_REQUEST['rankingsonly'] || $_REQUEST['embed'])
		{
			$embed = true;
		}
		$array = array();
		$winnerlist = array();
		$rowno = $offset;
		$toprank = 1;
		$myteams = fetch_myteams();
		if ($ladder['racemode'])
		{
			function array_remove_value($array, $del_val)
			{
				if(($key = array_search($del_val, $array)) !== false)
				{
					unset($array[$key]);
				}
				return $array;
			}
			$vbulletin->options['tmnt_ladder_columns'] = array_remove_value($vbulletin->options['tmnt_ladder_columns'], 'draws');
			$vbulletin->options['tmnt_ladder_columns'] = array_remove_value($vbulletin->options['tmnt_ladder_columns'], 'losses');
			$vbulletin->options['tmnt_ladder_columns'] = array_remove_value($vbulletin->options['tmnt_ladder_columns'], 'pointsdifference');
			$vbulletin->options['tmnt_ladder_columns'] = array_remove_value($vbulletin->options['tmnt_ladder_columns'], 'streak');
			$vbulletin->options['tmnt_ladder_columns'] = array_remove_value($vbulletin->options['tmnt_ladder_columns'], 'xp');
			$vbulletin->options['tmnt_ladder_columns'] = array_remove_value($vbulletin->options['tmnt_ladder_columns'], 'lastresults');
			$vbulletin->options['tmnt_ladder_columns'] = array_remove_value($vbulletin->options['tmnt_ladder_columns'], 'la');
			$ladder['pos_points'] = unserialize($ladder['pos_points']);
			if (is_array($ladder['pos_points']) && array_sum($ladder['pos_points'])>0)
			{
				$vbulletin->options['tmnt_ladder_columns'][] = 'points';
			}
			else
			{
				$vbulletin->options['tmnt_ladder_columns'] = array_remove_value($vbulletin->options['tmnt_ladder_columns'], 'points');
			}
		}
		function tll_lr_html($wld, $lr)
		{
			global $vbphrase;
			$html = '';
			$html = ' <span title="' . ($lr['round'] ? construct_phrase($vbphrase['tmnt_round_x'], $lr[round])." : " : "") . ''.$lr['u'].' '.$lr['score_u'].'-'.$lr['score_u2'].' '.$lr['u2'].'" style="'.($wld=='L'?"color:#A80000;":"").($wld=='W'?"color:#009933;":"").'">'.$wld.'</span> ';
			return $html;
		}
vB_Template::preRegister('memberaction_dropdown',array('tmntp' => $tmntp));
		if (file_exists(DIR . '/tll_modules/tll_editbadge.php'))
		{
			$tmntp['caneditbadge'] = true;
			$headinclude .= '<script src="clientscript/tll_preview_popup.js" type="text/javascript"></script>';
			$headinclude .= "\r\n\r\n".'<style> #preview{ 	position:absolute; 	border:1px solid #ccc;	background:#333;	padding:5px;	display:none; 	color:#fff;	}</style>';
		}
		if (!$offset)
		{
			$offset = 0;
		}
		if (!$cpp)
		{
			$cpp = 10;
		}
		$cmpts = $vbulletin->db->query_read("
			SELECT " . (!$team ? "user.*, " : "") . " players.*, players.userid AS userid
			" . (!$team ? ", user.avatarrevision AS avatarrevision, avatar.avatarpath AS avatarpath, NOT ISNULL(customavatar.userid) AS hascustom, customavatar.dateline AS avatardateline, customavatar.width AS avwidth, customavatar.height AS avheight, user.username AS username" : ", team.teamname AS username, team.teamlogo AS avatarurl") . "
			" . (($vbulletin->options['tmnt_joinuf'] && !$team) ? ", userfield.*, usertextfield.* " : "") . ", players.rank AS rank
		FROM " . TABLE_PREFIX . "tmnt_ladder_players AS players
		" . (!$team ? "LEFT JOIN " . TABLE_PREFIX . "user AS user ON (players.userid = user.userid) LEFT JOIN " . TABLE_PREFIX . "avatar AS avatar ON(avatar.avatarid = user.avatarid) LEFT JOIN " . TABLE_PREFIX . "customavatar AS customavatar ON(customavatar.userid = user.userid) " : " LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS team ON (players.userid = team.teamid)") . "
		" . (($vbulletin->options['tmnt_joinuf'] && !$team) ? " LEFT JOIN " . TABLE_PREFIX . "userfield AS userfield ON (user.userid = userfield.userid) LEFT JOIN " . TABLE_PREFIX . "usertextfield AS usertextfield ON (usertextfield.userid = user.userid) " : "") . "
		WHERE players.lid=$id 
			AND players.active=1
			" . ($hide == 'unranked' ? " AND (players.wins > 0 OR players.draws >0 OR players.loses > 0) " : "") . "
		ORDER BY 
			players.group ASC,
			" /*. ($vbulletin->options['tmnt_ladder_ranking'] == 'elo' ? "ORDER BY FIELD(field_name, 3,2,5,7,8,1)" : "")*/
			 . ($vbulletin->options['tmnt_ladder_ranking'] == 'elo' ? "players.rank DESC," : "")
			. ($vbulletin->options['tmnt_ladder_ranking'] == 'xp' ? "players.xp DESC," : "") . "
			players.wins DESC,
			players.draws DESC,
			players.loses ASC,
			" . ($vbulletin->options['tmnt_ladder_ranking'] == 'elo' ? "players.xp DESC, " : "") . "
			players.totalpoints DESC,
			players.pointsagainst ASC
		". (!$ladder['league'] ? "LIMIT $offset, $cpp" : "") . "
		");
		$ti = 0;
		while($cmpt = $vbulletin->db->fetch_array($cmpts))
		{
			if (!$ladder['racemode'] && $vbulletin->options['tmnt_ladder_inactivity']>0 && $cmpt['latime']>0)
			{
				$cmpt['la_inactivity'] = TIMENOW-$cmpt['latime'];
				if ($cmpt['la_inactivity']>$vbulletin->options['tmnt_ladder_inactivity']*86400)
				{
					$aa = $vbulletin->db->query_first("
						UPDATE " . TABLE_PREFIX . "tmnt_ladder_players AS p
							LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS l 
						ON (p.lid = l.id)
						SET p.active = 0
						WHERE p.latime > 0
							AND p.latime < ".(TIMENOW-$vbulletin->options['tmnt_ladder_inactivity']*86400)."
							AND p.lid = '$lid'
							AND p.active = 1
							AND l.racemode = 0
					");
					$vbulletin->url = "ladders.php".$ladder['url'];	
					eval(print_standard_redirect('redirect_updateladder'));
				}
			}
			if ($processwinner)
			{
				switch ($ti)
				{
					case 0: 
						process_credits_transaction(
							$cmpt['userid'], $ladder['cr_1st'], 'Came 1st in League', 0, 0, ($ladder['pot']?$cmpt['userid']:0), ($ladder['pot']?1:0)
						);
						break;
					case 1:
						process_credits_transaction($cmpt['userid'], $ladder['cr_2nd'], 'Came 2nd in League', 0, 0, ($ladder['pot']?$cmpt['userid']:0), ($ladder['pot']?1:0));
						break;
					case 2:
						process_credits_transaction($cmpt['userid'], $ladder['cr_3rd'], 'Came 3rd in League', 0, 0, ($ladder['pot']?$cmpt['userid']:0), ($ladder['pot']?1:0));
						$ladder = tll_finish_league_credits($ladder);
						$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladders SET credits_1st2nd3rd = '".$vbulletin->db->escape_string($ladder['credits_1st2nd3rd'])."' WHERE id=$lid");
						$vbulletin->url = $ladder['url']."&creditsprocessed";	
						eval(print_standard_redirect('redirect_'));
						break;
				}
			}
			if ($cmpt['group'] > 1 && $cmpt['group'] > $lastcmpt['group'])
			{
				$c_idx = $cmpt['group'] - 1;
				$ladder['thisgroup'] = $cmpt['group'];
				//$ccompetitors .= "</tr></table><h3 class=\"blocksubhead\" colspan=\"".$ladder['colspan']."\"><a name=\"group".$cmpt['group']."\"></a>" . ($ladder['groupnames']["$c_idx"] ? $ladder['groupnames']["$c_idx"] : construct_phrase($vbphrase['ladder_league_group_x'], $cmpt['group'])) . "</h3><table class=\"blockbody\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"100%\"><tbody><tr>";
				$ccompetitors .= "</tbody></table></div>";
				$ladder['thisgroupname'] = $ladder['groupnames']["$c_idx"];
				$templater = vB_Template::create('tmnt_ladder_cmpt_top');
					$templater->register('tmntp', $tmntp);
					$templater->register('ladder', $ladder);
					$templater->register('id', $id);
					$templater->register('lid', $lid);
					$templater->register('from', $from);
					$templater->register('to', $to);
					$templater->register('ti', $ti);
					$templater->register('c_idx', $c_idx);
					$templater->register('noofcomps', $noofcomps);
					$templater->register('sh', $sh);
				$ccompetitors .= $templater->render();
				$cmpt['row'] = 1;
				$rowno = 0;
			}
			if ($team && in_array($cmpt['userid'], $myteams))
			{
				$cmpt['myteam'] = true;
			}
			$cmpt = process_tl_avatar($cmpt);
			$avatarlp = $cmpt['avatarlp'];
			$cmpt['time2'] = "<span class=\"smallfont\">".vbdate($vbulletin->options['dateformat'],$cmpt['time'])." <span class=\"time\"> ".vbdate($vbulletin->options['timeformat'],$cmpt['time'])."</span></span>";
			$cmpt['time3'] = " ".vbdate($vbulletin->options['dateformat'],$cmpt['time'])." ".vbdate($vbulletin->options['timeformat'],$cmpt['time'])." ";
			$cmpt['time'] = ' <span title="'.vbdate($vbulletin->options['dateformat'],$cmpt['time'])." ".vbdate($vbulletin->options['timeformat'],$cmpt['time']).'"> '.vbdate($vbulletin->options['dateformat'],$cmpt['time'])." </span> ";
			$var = $cmpt['userid'];
			$array = array_merge((array)$var, $array);
			$rank = $cmpt['rank'];
			if ($cmpt['lstreak'] > 0) {
				$streak = -$cmpt['lstreak'];
			} else {
				$streak = $cmpt['wstreak'];
			}
			if ($cmpt['latime'] == 0)
			{
				$cmpt['latime'] = "-";
			} 
			else
			{
				$cmpt['latime'] = " ".vbdate($vbulletin->options['dateformat'],$cmpt['latime'], 1);
			}
			if ($rowno == $offset)
			{
				$toprank = $rank;
				$lastrank_rank = $toprank;
				$lastrank_row = $offset+1;
			}
			if ($toprank == $rank)
			{
				$var2 = $cmpt['userid'];
				$winnerlist = array_merge((array)$var2, $winnerlist);
			}
			if ($cmpt['badge'])
			{
				$show['badges'] = true;
			}
			$rowno++;
			$cmpt['css'] = $row_css["$rowno"];
			$cmpt['rowno'] = $rowno;
			if ($rank == $lastrank_rank && $rowno != ($offset+1) && $cmpt['xp'] == $lastrank_xp)
			{
				$cmpt['row'] = $lastrank_row ."=";
			}
			else
			{
				$lastrank_row = $rowno;
				$lastrank_rank = $rank;
				$lastrank_xp = $cmpt['xp'];
				$cmpt['row'] = $rowno;
			}
			$ddms = "cmpt".$rowno;
			$cmpt['col'] = "cmpt_". $cmpt['userid'];
			$cmpt['obj'] = "collapseobj_cmpt_". $cmpt['userid'];
			$cmpt['matches'] = $cmpt['wins'] + $cmpt['draws'] + $cmpt['loses'];
			if ($cmpt['wins']>0 AND $cmpt['matches']>0) $cmpt['winp'] = $cmpt['wins'] / $cmpt['matches'] * 100;
			$cmpt['winp'] = (int)$cmpt['winp'];
			if ($cmpt['matches'] > 0)//dom
			{
				$cmpt['pointsaverage'] = vb_number_format(($cmpt['totalpoints'] / $cmpt['matches']), 2);
				$cmpt['pointsaverage'] = str_replace(".00", "", $cmpt['pointsaverage']);
			}
			$cmpt['pointsdifference'] = $cmpt['totalpoints'] - $cmpt['pointsagainst'];
			if (in_array('lastresults', $vbulletin->options['tmnt_ladder_columns']) && $ladder['league'] != '1' && $vbulletin->options['tmnt_premium'])
			{
				$lr_query = $vbulletin->db->query_read("
					SELECT games.*, games.u AS uid, games.u2 AS u2id, 
						" . (!$team ? "user.username AS u, userb.username AS u2" : "user.teamname AS u, userb.teamname AS u2") . "
					FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
					" . (!$team ? "LEFT JOIN " . TABLE_PREFIX . "user AS user ON (games.u = user.userid) LEFT JOIN " . TABLE_PREFIX . "user AS userb ON (games.u2 = userb.userid)" : "LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS user ON (games.u = user.teamid) LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS userb ON (games.u2 = userb.teamid)") . "
					WHERE games.lid = '$lid'
						AND games.finished = '1'
						AND (games.u = '".$cmpt['userid']."' OR games.u2 = '".$cmpt['userid']."')
					ORDER BY games.dateline_finished DESC
					LIMIT 0, 3
				");
				while($lr = $vbulletin->db->fetch_array($lr_query))
				{
					if ($lr['uid'] == $cmpt['userid'])
					{//is_u
						if ($lr['score_u']>$lr['score_u2'])
						{
							$cmpt['lr_html'] .= tll_lr_html('W', $lr);
						}
						elseif ($lr['score_u']<$lr['score_u2'])
						{
							$cmpt['lr_html'] .= tll_lr_html('L', $lr);
						}
						elseif ($lr['score_u']==$lr['score_u2'])
						{
							$cmpt['lr_html'] .= tll_lr_html('D', $lr);
						}
					}
					elseif ($lr['u2id'] == $cmpt['userid'])
					{//is_u2
						if ($lr['score_u']<$lr['score_u2'])
						{
							$cmpt['lr_html'] .= tll_lr_html('W', $lr);
						}
						elseif ($lr['score_u']>$lr['score_u2'])
						{
							$cmpt['lr_html'] .= tll_lr_html('L', $lr);
						}
						elseif ($lr['score_u']==$lr['score_u2'])
						{
							$cmpt['lr_html'] .= tll_lr_html('D', $lr);
						}
					}
					else
					{
						continue;
					}
				}
			}
			if ($ladder['pos_points'])
			{
				$cmpt['points'] = $ladder['pos_points']["$cmpt[round]"] + 					$ladder['pos_points']["$cmpt[round2]"] + 				$ladder['pos_points']["$cmpt[round3]"] + 					$ladder['pos_points']["$cmpt[round4]"] + 					$ladder['pos_points']["$cmpt[round5]"] + 					$ladder['pos_points']["$cmpt[round6]"] + 					$ladder['pos_points']["$cmpt[round7]"] + 					$ladder['pos_points']["$cmpt[round8]"] + 					$ladder['pos_points']["$cmpt[round9]"] + 					$ladder['pos_points']["$cmpt[round10]"] + 					$ladder['pos_points']["$cmpt[round11]"] + 					$ladder['pos_points']["$cmpt[round12]"]+ 					$ladder['pos_points']["$cmpt[round13]"]+ 					$ladder['pos_points']["$cmpt[round14]"]+ 					$ladder['pos_points']["$cmpt[round15]"]+ 					$ladder['pos_points']["$cmpt[round16]"]+ 					$ladder['pos_points']["$cmpt[round17]"]+ 					$ladder['pos_points']["$cmpt[round18]"]+ 					$ladder['pos_points']["$cmpt[round19]"]+ 					$ladder['pos_points']["$cmpt[round20]"]+ 					$ladder['pos_points']["$cmpt[round21]"]+					$ladder['pos_points']["$cmpt[round22]"]+					$ladder['pos_points']["$cmpt[round23]"]+					$ladder['pos_points']["$cmpt[round24]"]+					$ladder['pos_points']["$cmpt[round25]"]+					$ladder['pos_points']["$cmpt[round26]"]+					$ladder['pos_points']["$cmpt[round27]"]+					$ladder['pos_points']["$cmpt[round28]"]+					$ladder['pos_points']["$cmpt[round29]"]+					$ladder['pos_points']["$cmpt[round30]"]+				$ladder['pos_points']["$cmpt[round31]"]+				$ladder['pos_points']["$cmpt[round32]"];
			}
			$cmpt['lid'] = $lid;
			if ($team)
			{
				$cmpt['teamurl'] = tll_seo('team', $cmpt['userid'], $cmpt['username']);
			}
			$cmpt['userhtml'] = tll_userhtml($cmpt, $team, 1);
			vB_Template::preRegister('memberaction_dropdown',array('team' => $team));
			vB_Template::preRegister('memberaction_dropdown',array('lid' => $lid)); 
			vB_Template::preRegister('memberaction_dropdown',array('ladder' => $ladder));
			$vbulletin->templatecache['memberaction_dropdown'] = $vbulletin->templatecache['tmnt_memberaction_dropdown'];
			$memberaction_dropdown = construct_memberaction_dropdown($cmpt, $template_hook);
			$memberaction_dropdown = str_replace('</strong></a>', '</strong></a>'.$cmpt['userhtml'], $memberaction_dropdown);
			if ($cmpt['warlight']>TIMENOW && $vbulletin->options['tmnt_warlights'])
			{
				$cmpt['show_warlight_enabled'] = true;
			}
			if ($ladder['league'] != '1')
			{
				$c_idx = 0;
				$ladder['thisgroup'] = 1;
				if ($ti>0)
				{
					$cmpt['tooltip'] .= ' ttnh';
				}
				$templater = vB_Template::create('tmnt_ladder_cmpt');
					$templater->register('tmntp', $tmntp);
					$templater->register('ladder', $ladder);
					$templater->register('id', $id);
					$templater->register('page', $page);
					$templater->register('lid', $lid);
					$templater->register('cmpt', $cmpt);
					$templater->register('ddms', $ddms);
					$templater->register('rank', $rank);
					$templater->register('rowno', $rowno);
					$templater->register('avatarlp', $avatarlp);
					$templater->register('c_idx', $c_idx);
					$templater->register('team', $team);
					$templater->register('streak', $streak);
					$templater->register('memberaction_dropdown', $memberaction_dropdown);
				if ($ladder['racemode'])
				{
					$c_rm[$cmpt[points]] .= $templater->render();
				}
				else
				{
					$ccompetitors .= $templater->render();
				}
			}
			else
			{
				$competitors[] = $cmpt;
			}
			$ddms_id = "cmpt".$rowno."_menu";
			$ti++;
			$lastcmpt = $cmpt;
		}
		if ($ladder['racemode']&&$c_rm)
		{
			//print_r($c_rm);
			//print_r(12);
			$keys = array_keys($c_rm);
			//print_r($keys);
			$max = max($keys);
			//print_r($max);
			for ($i = $max; $i >= 0; $i--)
			{
				$ccompetitors .= $c_rm["$i"];
			}
		}
		/*$a = arsort($c_rm);
		print_r($a);
		$a =array(4,3,1,2);
		print_r(asort($a));*/
		//exit;
		$ladder['ti'] = $ti;
		if ($ladder['league'] != '1')
		{
			$ladder['thisgroupname'] = $ladder['groupnames']["0"];
			$templater = vB_Template::create('tmnt_ladder_cmpt_top');
				$templater->register('tmntp', $tmntp);
				$templater->register('ladder', $ladder);
				$templater->register('id', $id);
				$templater->register('lid', $lid);
				$templater->register('from', $from);
				$templater->register('to', $to);
				$templater->register('ti', $ti);
				$templater->register('noofcomps', $noofcomps);
				$templater->register('sh', $sh);
			$competitors .= $templater->render();
			$competitors .= $ccompetitors;
		}
		if ($rowno == $offset)
		{
			$templater = vB_Template::create('tmnt_ladder_cmpt_none');
				$templater->register('tmntp', $tmntp);
				$templater->register('ladder', $ladder);
				$templater->register('id', $id);
				$templater->register('lid', $lid);
				$templater->register('cmpt', $cmpt);
				$templater->register('ddms', $ddms);
				$templater->register('rank', $rank);
				$templater->register('rowno', $rowno);
			$competitors .= $templater->render();
		}
		if (!$ladder['league'])
		{
			$pagenav = construct_page_nav($page, $cpp, $noofcomps, $ladder['url'] . "", "". ($hide ? "&amp;hide=$hide" : "") . ($embed ? "&amp;embed=1" : "") . "", "content");
		}
		if ($ladder['league'] != '1')
		{
			$templater = vB_Template::create('tmnt_ladder_cmpt_bot');
				$templater->register('tmntp', $tmntp);
				$templater->register('ladder', $ladder);
				$templater->register('id', $id);
				$templater->register('lid', $lid);
			$competitors .= $templater->render();
		}
		if ((in_array($thisuserid, $array) OR $team) AND $show['member']) {
			$comper = true;
		} else {
			$userid = $thisuserid;
			$username = $thisusername;
			$countplayer = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid='$id' AND (userid='$userid' OR username='".$vbulletin->db->escape_string($username)."') AND active=1 ");
			$countplayer = $countplayer['countrows'];  
			if ($countplayer != 0) {
				$comper = true;
			} else {
				$comper = false;
				$competitorddms = str_replace("{comper}", "display: none;", $competitorddms);
			}
		}
	}
	else 
	{
		$userid = $thisuserid;
		$username = $thisusername;
		if (!$team) 
		{
			$countplayer = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid='$id' AND (userid='$userid' OR username='".$vbulletin->db->escape_string($username)."') AND active=1 ");
			$countplayer = $countplayer['countrows'];  
			if ($countplayer != 0) {
				$comper = true;
			} else {
				$comper = false;
			}
		}
	}
	/*print_r($ccompetitors);
	exit;*/
	/***/
	if ($team && $vbulletin->options['tmnt_ladder_priv_mc'] && in_array($_REQUEST['sh'], array(1,2)))
	{//teamids array of user teams in control (leaders or co-leaders)
		$tml_array = array();
		$tml_query = $vbulletin->db->query_read("
			SELECT teamid FROM " . TABLE_PREFIX . "tmnt_members WHERE userid='".$vbulletin->userinfo['userid']."' AND (leader=1 OR coleader=1)
		");
		while($tml_data = $vbulletin->db->fetch_array($tml_query))
		{
			$tml_array[] = $tml_data['teamid'];
		}
	}
	/***/
	if ($_REQUEST['sh'] == 1 && ($ladder['format2'] OR $_REQUEST['format2']) && !$ladder['racemode'])
	{
		$ladder['format2'] = 1;
		$chlls = $vbulletin->db->query_read("
			SELECT games.*, games.u AS uid, games.u2 AS u2id,
			" . (!$team ? "user.username AS u, userb.username AS u2" : "user.teamname AS u, userb.teamname AS u2, user.cache_teammembers AS u_tm, userb.cache_teammembers AS u2_tm") . "
			FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
			" . (!$team ? "LEFT JOIN " . TABLE_PREFIX . "user AS user ON (games.u = user.userid) LEFT JOIN " . TABLE_PREFIX . "user AS userb ON (games.u2 = userb.userid)" : "LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS user ON (games.u = user.teamid) LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS userb ON (games.u2 = userb.teamid)") . "
			WHERE games.lid = '$id'
				AND games.accepted = '1'
				" . ($ladder['filter_round'] ? " AND games.round = '" . $ladder['filter_round']."'" : "")
				. ($ladder['filter_group'] ? " AND games.group = '" . $ladder['filter_group']."'" : "") . "
			ORDER BY games.round ASC, games.group ASC, games.id DESC
			LIMIT 0, 100
		");
		$rowno = 0;
		$chllarray = array();
		$mc_ids_array = array();
		$competitors = '<div class="blockbody formcontrols" style="clear: both;">';
		while($chll = $vbulletin->db->fetch_array($chlls))
		{
			$c_idx = $chll['group'] - 1;
			$rowno++;
			$ladder['chlls'][] = $chll;
			//print_r($chll);
			//print_r($ladder['groupnames'][$c_idx]);
			if ($ladder['groupnames'][$c_idx])
			{
				$chll['roundname'] = $ladder['groupnames']["$c_idx"];
			}
			else
			{
				$chll['roundname'] =  construct_phrase($vbphrase['ladder_league_group_x'], $chll['group']);
			}
			$templater = vB_Template::create('tmnt_league_format2');
				$templater->register('tmntp', $tmntp);
				$templater->register('ladder', $ladder);
				$templater->register('id', $id);
				$templater->register('lid', $lid);
				$templater->register('sh', $sh);
				$templater->register('chll', $chll);
				$templater->register('team', $team);
				$templater->register('prev', $prev);
				$templater->register('c_idx', $c_idx);
				$templater->register('rowno', $rowno);
			$competitors .= $templater->render();
			$prev = $chll;
		//	$competitors .= 'test';
		}
		//print_r($ladder['groupnames']);
		$competitors .= '</div>';
	}
	elseif ($_REQUEST['sh'] == 1 && !$ladder['racemode'])
	{
		$sh = 1;
		if ($ladder['league'])
		{
			$maxrounds = $vbulletin->db->query_first("SELECT g.round FROM " . TABLE_PREFIX . "tmnt_ladder_games AS g WHERE g.lid = '$ladder[id]' AND g.group = 1 ORDER BY g.round DESC");
			$ladder['rounds'] = $maxrounds['round'];
		}
		$ladder['filter_round'] = $vbulletin->input->clean_gpc('g', 'round', TYPE_UINT);
		$ladder['filter_group'] = $vbulletin->input->clean_gpc('g', 'group', TYPE_UINT);
		$ladder['selected']['group_'.$ladder['filter_group']] = ' selected="selected"';
		$ladder['selected']['round_'.$ladder['filter_round']] = ' selected="selected"';
		$templater = vB_Template::create('tmnt_ladder_allchll_top');
			$templater->register('tmntp', $tmntp);
			$templater->register('ladder', $ladder);
			$templater->register('id', $id);
			$templater->register('lid', $lid);
			$templater->register('sh', $sh);
		$competitors .= $templater->render();
		$chlls = $vbulletin->db->query_read("
			SELECT games.*, games.u AS uid, games.u2 AS u2id,
			" . (!$team ? "user.username AS u, userb.username AS u2" : "user.teamname AS u, userb.teamname AS u2, user.cache_teammembers AS u_tm, userb.cache_teammembers AS u2_tm") . "
			FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
			" . (!$team ? "LEFT JOIN " . TABLE_PREFIX . "user AS user ON (games.u = user.userid) LEFT JOIN " . TABLE_PREFIX . "user AS userb ON (games.u2 = userb.userid)" : "LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS user ON (games.u = user.teamid) LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS userb ON (games.u2 = userb.teamid)") . "
			WHERE games.lid = '$id'
				AND games.finished = '1'
				" . ($ladder['filter_round'] ? " AND games.round = '" . $ladder['filter_round']."'" : "")
				. ($ladder['filter_group'] ? " AND games.group = '" . $ladder['filter_group']."'" : "") . "
			ORDER BY games.dateline_finished DESC, games.id DESC
			LIMIT 0, 11
		");
		$rowno = 0;
		$chllarray = array();
		$mc_ids_array = array();
		while($chll = $vbulletin->db->fetch_array($chlls))
		{
			$rowno++;
			if ($rowno != 11)
			{
				$chll['display'] = 'none';
				if (
					$vbulletin->options['tmnt_ladder_priv_mc'] &&
						(  (!$team && !in_array($vbulletin->userinfo['userid'], array($chll['uid'],$chll['u2id'])))
						OR
						($team && !in_array($chll['uid'],$tml_array) && !in_array($chll['u2id'],$tml_array))  )
				)
				{
					$chll['hide_mc'] = true;
				}
				if ($team)
				{
					$chll['teamurl_u'] = tll_seo('team', $chll['uid'], $chll['u']);
					$chll['teamurl_u2'] = tll_seo('team', $chll['u2id'], $chll['u2']);
				}
				$chll['from_tmnt'] = unserialize($chll['from_tmnt']);
				$chllarray["$chll[id]"] = $chll;
				if ($chll['comments'] > 0 && !$chll['hide_mc'])
				{
					$mc_ids_array[] = $chll['id'];
				}
			}
			else
			{
				$show['morechll'] = true;
			}
		}
		if ($rowno == 0)
		{
			$templater = vB_Template::create('tmnt_ladder_allchll_none');
				$templater->register('tmntp', $tmntp);
				$templater->register('ladder', $ladder);
				$templater->register('id', $id);
				$templater->register('lid', $lid);
				$templater->register('sh', $sh);
				$templater->register('chll', $chll);
				$templater->register('team', $team);
				$templater->register('rowno', $rowno);
			$competitors .= $templater->render();
		}
		else if (!empty($mc_ids_array))
		{
			$chllarray = fetch_ladder_mcs($mc_ids_array, $chllarray);
		}
		$templater = vB_Template::create('tmnt_ladder_allchll_bot');
			$templater->register('tmntp', $tmntp);
			$templater->register('ladder', $ladder);
			$templater->register('id', $id);
			$templater->register('lid', $lid);
			$templater->register('sh', $sh);
			$templater->register('chll', $chll);
			$templater->register('team', $team);
			$templater->register('rowno', $rowno);
		$competitors .= $templater->render();
	}
	elseif ($_REQUEST['sh'] == 1 && $ladder['racemode'])
	{
		$sh = 1;
		$ladder['filter_round'] = $vbulletin->input->clean_gpc('g', 'round', TYPE_UINT);
		if (!$ladder['filter_round'] || $ladder['filter_round'] > $ladder['racemode_rounds'])
		{
			$ladder['filter_round'] = 1;
		}
		$ladder['filter_group'] = $vbulletin->input->clean_gpc('g', 'group', TYPE_UINT);
		if (!$ladder['filter_group'] || $ladder['filter_group'] > $ladder['groups'])
		{
			$ladder['filter_group'] = 1;
		}
		$ladder['selected']['group_'.$ladder['filter_group']] = ' selected="selected"';
		$ladder['selected']['round_'.$ladder['filter_round']] = ' selected="selected"';
		$ladder['filter_round_text'] = $ladder['rounds_text']["$ladder[filter_round]"];
		$rowno = 0;
		if ($ladder['filter_round']==1)
		{
			$sql_g = 'round';
		}
		else
		{
			$sql_g = 'round'.$ladder['filter_round'];
		}
		$ladder['pergroup'] = ceil($ladder['noplayers']/$ladder['groups']);
		$pq = $vbulletin->db->query_read("
			SELECT p.*, " . (!$team ? "u.username" : "u.teamname AS username") . " 
			FROM " . TABLE_PREFIX . "tmnt_ladder_players AS p
			" . (!$team ? "LEFT JOIN " . TABLE_PREFIX . "user AS u ON (p.userid = u.userid)" : "LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS u ON (p.userid = u.teamid)") . "
			WHERE p.lid = '$lid' 
				AND p.group = '".$ladder['filter_group']."'
		");
		while($p = $vbulletin->db->fetch_array($pq))
		{
			$p['rpos'] = $p["$sql_g"];
			$p['optout_rounds'] = explode(',',$p['optout_rounds']);
			$p['sel']["$p[rpos]"] = ' selected="selected"';
			//print_r($p['sel']);
			$pcount++;
			if ($p['rpos']>0)
			{
				$p['rpos'] = process_position($p['rpos'], true);
			}
			else
			{
				$p['rpos'] = ' - ';
			}
			$p['userhtml'] = tll_userhtml($p, $ladder['pot'], 0);
			
			$parray[] = $p;
		}
		//print_r($vbulletin->GPC);
		$templater = vB_Template::create('tmnt_ladder_racemode');
			$templater->register('tmntp', $tmntp);
			$templater->register('ladder', $ladder);
			$templater->register('lid', $lid);
			$templater->register('sh', $sh);
			$templater->register('team', $team);
			$templater->register('parray', $parray);
			$templater->register('pcount', $pcount);
		$competitors .= $templater->render();
		
	}
	elseif ($_REQUEST['sh'] == 2 && !$ladder['racemode'])
	{
		$sh = 2;
		if ($ladder['league'])
		{
			$maxrounds = $vbulletin->db->query_first("SELECT g.round FROM " . TABLE_PREFIX . "tmnt_ladder_games AS g WHERE g.lid = '$ladder[id]' AND g.group = 1 ORDER BY g.round DESC");
			$ladder['rounds'] = $maxrounds['round'];
		}
		$ladder['filter_round'] = $vbulletin->input->clean_gpc('g', 'round', TYPE_UINT);
		$ladder['filter_group'] = $vbulletin->input->clean_gpc('g', 'group', TYPE_UINT);
		$ladder['filter_uid'] = $vbulletin->input->clean_gpc('g', 'uid', TYPE_UINT);
		$ladder['selected']['group_'.$ladder['filter_group']] = ' selected="selected"';
		$ladder['selected']['round_'.$ladder['filter_round']] = ' selected="selected"';
		$ladder['selected']['uid_'.$ladder['filter_uid']] = ' selected="selected"';
		$templater = vB_Template::create('tmnt_ladder_allchll_top');
			$templater->register('tmntp', $tmntp);
			$templater->register('ladder', $ladder);
			$templater->register('id', $id);
			$templater->register('lid', $lid);
			$templater->register('sh', $sh);
			$templater->register('chll', $chll);
			$templater->register('team', $team);
			$templater->register('rowno', $rowno);
		$competitors .= $templater->render();
		$chlls = $vbulletin->db->query_read("SELECT games.*, games.u AS uid, games.u2 AS u2id, " . (!$team ? "user.username AS u, userb.username AS u2" : "user.teamname AS u, userb.teamname AS u2, user.cache_teammembers AS u_tm, userb.cache_teammembers AS u2_tm") . " FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games " . (!$team ? "LEFT JOIN " . TABLE_PREFIX . "user AS user ON (games.u = user.userid) LEFT JOIN " . TABLE_PREFIX . "user AS userb ON (games.u2 = userb.userid)" : "LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS user ON (games.u = user.teamid) LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS userb ON (games.u2 = userb.teamid)") . " WHERE games.lid = '$id' AND games.finished = '0' AND games.accepted = '1' " . ($ladder['filter_round'] ? " AND games.round = '" . $ladder['filter_round']."'" : "") . ($ladder['filter_group'] ? " AND games.group = '" . $ladder['filter_group']."'" : "") . ($ladder['filter_uid'] ? " AND (games.u = '" . $ladder['filter_uid']."' OR games.u2 = '" . $ladder['filter_uid']."')" : "") . " ORDER BY games.dateline ASC LIMIT 0, 11");
		$rowno = 0;
		while($chll = $vbulletin->db->fetch_array($chlls))
		{
			$rowno ++;
			$chll = process_chal_options($chll);
			if ($rowno == 11)
			{
				$show['morechll'] = true;
			}
			else
			{
				if (
					$vbulletin->options['tmnt_ladder_priv_mc'] &&
						(  (!$team && !in_array($vbulletin->userinfo['userid'], array($chll['uid'],$chll['u2id'])))
						OR
						($team && !in_array($chll['uid'],$tml_array) && !in_array($chll['u2id'],$tml_array))  )
				)
				{
					$chll['hide_mc'] = true;
				}
				if ($chll['comments'] > 0 && !$chll['hide_mc'])
				{
					$mc_ids_array[] = $chll['id'];
				}
				$chll['display'] = 'none';
				if ($team)
				{
					$chll['teamurl_u'] = tll_seo('team', $chll['uid'], $chll['u']);
					$chll['teamurl_u2'] = tll_seo('team', $chll['u2id'], $chll['u2']);
				}
				$chllarray["$chll[id]"] = $chll;
			}
		}
		if ($rowno == 0)
		{
			$templater = vB_Template::create('tmnt_ladder_allchll_none');
			$templater->register('tmntp', $tmntp);
			$templater->register('ladder', $ladder);
			$templater->register('id', $id);
			$templater->register('lid', $lid);
			$templater->register('sh', $sh);
			$templater->register('chll', $chll);
			$templater->register('team', $team);
			$templater->register('rowno', $rowno);
			$competitors .= $templater->render();
		}
		else
		{
			if (!empty($mc_ids_array))
			{
				$chllarray = fetch_ladder_mcs($mc_ids_array, $chllarray);
			}
			if (!$vbulletin->options['tmnt_ladder_um_alt'] OR IS_MOBILE_STYLE)
			{
				$templater = vB_Template::create('tmnt_ladder_allchll');
			}
			else
			{
				$templater = vB_Template::create('tmnt_ladder_allchll2');
			}
				$templater->register('tmntp', $tmntp);
				$templater->register('ladder', $ladder);
				$templater->register('id', $id);
				$templater->register('lid', $lid);
				$templater->register('sh', $sh);
				$templater->register('chll', $chll);
				$templater->register('team', $team);
				$templater->register('rowno', $rowno);
				$templater->register('chllarray', $chllarray);
			$competitors .= $templater->render();
		}
		$templater = vB_Template::create('tmnt_ladder_allchll_bot');
			$templater->register('tmntp', $tmntp);
			$templater->register('ladder', $ladder);
			$templater->register('id', $id);
			$templater->register('lid', $lid);
			$templater->register('sh', $sh);
			$templater->register('show', $show);
			$templater->register('chll', $chll);
			$templater->register('team', $team);
			$templater->register('rowno', $rowno);
		$competitors .= $templater->render();
	}
	elseif ($_REQUEST['sh'] == 3)
	{
		$sh = 3;
		if (!$ladder['pot'])
		{
			$u = $thisuserid;
		}
		else
		{//your teams
			$u = array('0');
			$tq = $vbulletin->db->query_read("
				SELECT p.*, m.leader, t.teamid, t.teamname
				FROM " . TABLE_PREFIX . "tmnt_ladder_players AS p
				LEFT JOIN " . TABLE_PREFIX . "tmnt_members AS m
					ON (m.userid = $thisuserid AND p.userid = m.teamid)
				LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS t
					ON (p.userid = t.teamid)
				WHERE lid = '$lid'
					AND m.leader = 1
			");
			while($t = $vbulletin->db->fetch_array($tq))
			{
				$u[] = $t['teamid'];
				$comper = true;
			}
			$team_array = $u;
			$u = implode(',', $u);
		}
		$templater = vB_Template::create('tmnt_ladder_tlchll_top');//tlchll
			$templater->register('tmntp', $tmntp);
			$templater->register('ladder', $ladder);
			$templater->register('id', $id);
			$templater->register('lid', $lid);
			$templater->register('sh', $sh);
			$templater->register('team', $team);
			$templater->register('u', $u);
		$competitors .= $templater->render();
		$games = $vbulletin->db->query_read("
			SELECT games.*, games.u AS uid, games.u2 AS u2id, IF(games.pot, tu.teamname, user.username) AS u, IF(games.pot, tu2.teamname, user2.username) AS u2
			FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
			LEFT JOIN " . TABLE_PREFIX . "user AS user
				ON (games.u = user.userid AND games.pot = 0)
			LEFT JOIN " . TABLE_PREFIX . "user AS user2
				ON (games.u2 = user2.userid AND games.pot = 0)
			LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS tu
				ON (games.u = tu.teamid AND games.pot = 1)
			LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS tu2
				ON (games.u2 = tu2.teamid AND games.pot = 1)
			WHERE ( games.u IN($u) OR games.u2 IN($u) )
				AND games.finished = 0
				AND games.accepted != -1
				AND games.lid = $id	
			ORDER BY games.round ASC
		");  
		while($game = $vbulletin->db->fetch_array($games))
		{
			if ($game['u2id'] == 0 && $game['dateline'] < TIMENOW)
			{//remove old match finder challenges which were not accepted
				continue;
			}
			$game = process_chal_options($game);
			$is_u = is_u($game, $thisuserid);
			$is_u2 = is_u2($game, $thisuserid);
			$game['time'] = vbdate($vbulletin->options['timeformat'],$game['time']).$vbphrase['ladder_on'].vbdate($vbulletin->options['dateformat'],$game['time']);
			$game = switch_match_status($game, $is_u, $is_u2, 'ladder', $sh);
			$rowno++ ;
			$game['display'] = 'none';
			if ($game['comments'] > 0)
			{
				$mc_ids_array[] = $game['id'];
			}
			$chllarray["$game[id]"] = $game;
		}
		if (!empty($mc_ids_array))
		{
			$chllarray = fetch_ladder_mcs($mc_ids_array, $chllarray);
		}
		$templater = vB_Template::create('tmnt_ladder_chll');//tlchll
			$templater->register('tmntp', $tmntp);
			$templater->register('ladder', $ladder);
			$templater->register('id', $id);
			$templater->register('lid', $lid);
			$templater->register('sh', $sh);
			$templater->register('team', $team);
			$templater->register('rowno', $rowno);
			$templater->register('u', $u);
			$templater->register('game', $game);
			$templater->register('chllarray', $chllarray);
			$templater->register('from', 'ladder&sh=3');
		$competitors .= $templater->render();
		$templater = vB_Template::create('tmnt_ladder_chll_bot');//tlchll
			$templater->register('tmntp', $tmntp);
			$templater->register('ladder', $ladder);
			$templater->register('id', $id);
			$templater->register('lid', $lid);
			$templater->register('sh', $sh);
			$templater->register('team', $team);
			$templater->register('rowno', $rowno);
			$templater->register('u', $u);
		$competitors .= $templater->render();
	}
	elseif ($_REQUEST['sh'] == '4')
	{
		$sh = 4;
		$tcount = 0;
		$tmntarray = array();
		$tmnts = $vbulletin->db->query_read("
			SELECT tmnts.id, tmnts.title, w.username AS username, w.userid AS userid
			FROM " . TABLE_PREFIX . "tmnt_tmnts AS tmnts
			LEFT JOIN " . TABLE_PREFIX . "tmnt_players AS w
				ON (w.tid = tmnts.id AND w.winner = 1)
			WHERE tmnts.ladderid = '$lid'
			GROUP BY tmnts.id
		"); /*AND winner.winner = 1*/
		while($tmnt = $vbulletin->db->fetch_array($tmnts))
		{
			$tmntarray[] = $tmnt;
			$tcount++;
		}
		$templater = vB_Template::create('tmnt_ladder_tmnts');
			$templater->register('tmntp', $tmntp);
			$templater->register('tmntarray', $tmntarray);
			$templater->register('tcount', $tcount);
			$templater->register('ladder', $ladder);
			$templater->register('id', $id);
			$templater->register('lid', $lid);
			$templater->register('sh', $sh);
			$templater->register('team', $team);
			$templater->register('rowno', $rowno);
			$templater->register('u', $u);
		$competitors .= $templater->render();
	}
	elseif ($_REQUEST['sh'] == 5)
	{
		$sh = 5;
		//paginate this
		$ladder['yourteams'] = array();
		$ladder['teamcount'] = 0;
		if ($ladder['pot'])
		{
			$teams = $vbulletin->db->query_read("
				SELECT *
				FROM " . TABLE_PREFIX . "tmnt_members
				RIGHT JOIN " . TABLE_PREFIX . "tmnt_teams
					ON " . TABLE_PREFIX . "tmnt_members.teamid = " . TABLE_PREFIX . "tmnt_teams.teamid
				RIGHT JOIN " . TABLE_PREFIX . "tmnt_ladder_players
					ON " . TABLE_PREFIX . "tmnt_members.teamid = " . TABLE_PREFIX . "tmnt_ladder_players.userid
				WHERE " . TABLE_PREFIX . "tmnt_members.leader=1
					AND " . TABLE_PREFIX . "tmnt_members.userid=$thisuserid
					AND " . TABLE_PREFIX . "tmnt_ladder_players.lid=$lid
			");
			while($teamm = $vbulletin->db->fetch_array($teams))
			{
				$ladder['yourteams'][] = $teamm;
				$ladder['teamcount']++;
			}
		}
		$matches = array();
		$games = $vbulletin->db->query_read("
			SELECT games.*, ".($ladder['pot'] ? " t.teamname AS username" : " u.username AS username")."
			FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
			LEFT JOIN " . TABLE_PREFIX . "user AS u
				ON (games.pot = 0 AND games.u = u.userid)
			LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS t
				ON (games.pot = 1 AND games.u = t.teamid)
			WHERE
				games.u2 = 0
				AND games.finished = 0
				AND games.accepted = 0
				AND games.pot = ".$ladder['pot']."
				AND games.lid = $id
				AND games.dateline > ".TIMENOW."
			ORDER BY games.dateline ASC
			LIMIT 0, 20
		");
		while($game = $vbulletin->db->fetch_array($games))
		{
			$game['time'] = vbdate($vbulletin->options['timeformat'], $game['dateline']);
			$game['date'] = vbdate($vbulletin->options['dateformat'], $game['dateline'], true);
			$game = process_chal_options($game);
			$matches[] = $game;
		}
		if ($vbulletin->options['tmnt_warlights'] && $vbulletin->userinfo['userid'])
		{
			$ladder['wl_array'] = array();
			$ladder['wl_enabled'] = false;
			$players_query = $vbulletin->db->query_read("
				SELECT p.*, u.username, t.teamname, IF (m.userid, 1, 0) AS isleader
				FROM " . TABLE_PREFIX . "tmnt_ladder_players AS p
				LEFT JOIN " . TABLE_PREFIX . "user AS u
					ON (p.userid = u.userid)
				LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS t
					ON (p.userid = t.teamid)
				LEFT JOIN " . TABLE_PREFIX . "tmnt_members AS m
					ON (m.teamid = t.teamid AND m.userid = '$thisuserid' AND leader = 1)
				WHERE p.warlight > '".TIMENOW."'
					AND p.lid = '".$ladder['id']."'
			");
			while($playerq = $vbulletin->db->fetch_array($players_query))
			{
				if ($team)
				{
					$playerq['username'] = $playerq['teamname'];
				}
				if (!$team && $playerq['userid'] == $vbulletin->userinfo['userid'])
				{
					$ladder['wl_enabled'] = true;
					$ladder['userinfo_warlight'] = $playerq['warlight'];
				}
				else
				{
					$ladder['wl_array'][] = $playerq;
				}
			}
		}
	}
	elseif ($_REQUEST['sh'] == 6)
	{
		$sh = 6;
		$query_rules = $vbulletin->db->query_first("
			SELECT rules
			FROM " . TABLE_PREFIX . "tmnt_rules
		");
		$bbcode_parser = new vB_BbCodeParser($vbulletin, fetch_tag_list()); 
		$ladder['genrules'] = $bbcode_parser->do_parse($query_rules['rules']);
	}
	elseif ($_REQUEST['sh'] == 7)
	{
		$sh = 7;
	}
	elseif ($_REQUEST['sh'] == 8)
	{//knockout stage for leagues
		$sh = 8;
		$tmnt = array(
			'noplayers' => $ladder['tmnt_noplayers'],
			'freeslots' => 0,
			'id' => $ladder['id']
		);
		if ($ladder['tmnt_status']==1)
		{
			$tmnt['status'] = $vbphrase['tmnt_inprogress'];
		}
		if ($ladder['tmnt_status']==2)
		{
			$tmnt['status'] = $vbphrase['tmnt_finished'];
		}
		$type = $vbphrase['tmnt_'.$ladder[knockout_type]];
		/** START :: ADAPTED FROM TOURNAMENTS.PHP **/
		$bracketcolor = $vbulletin->options['tmnt_bracketcolor'];
		$cmpt_count = 1;
		$winnernames = $useridlist = $array = $p_array = array();
		$cmpts = $vbulletin->db->query_read("
			SELECT
				" . (!$team ? "user.*," : "") . " players.*, players.username AS sname,
				" . (!$team ? "user.username AS username, user.userid, user.avatarrevision AS avatarrevision, avatar.avatarpath AS avatarpath, NOT ISNULL(customavatar.userid) AS hascustom, customavatar.dateline AS avatardateline, customavatar.width AS avwidth, customavatar.height AS avheight, user.username AS username" : "user.teamname AS username, user.teamid, user.teamlogo AS avatarurl") . "
				" . (($vbulletin->options['tmnt_joinuf'] && !$team) ? ", userfield.*, usertextfield.* " : "") . "
			FROM " . TABLE_PREFIX . "tmnt_ladder_players AS players 
			" . ($team ? "LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS user ON (players.userid = user.teamid)" : "LEFT JOIN " . TABLE_PREFIX . "user AS user ON (players.userid = user.userid) LEFT JOIN " . TABLE_PREFIX . "avatar AS avatar ON(avatar.avatarid = user.avatarid) LEFT JOIN " . TABLE_PREFIX . "customavatar AS customavatar ON(customavatar.userid = user.userid) ") . "
			" . (($vbulletin->options['tmnt_joinuf'] && !$team) ? " LEFT JOIN " . TABLE_PREFIX . "userfield AS userfield ON (user.userid = userfield.userid) LEFT JOIN " . TABLE_PREFIX . "usertextfield AS usertextfield ON (usertextfield.userid = user.userid) " : "") . "
			WHERE lid = '$id' AND slot > 0
			ORDER BY slot ASC
		");
		$winnerlist = $pinfo = $rounduserinfo = array();
		$rui = 8;
		while ($rui > 0)
		{
			$ruj = 12;
			while ($ruj > 0)
			{
				$rounduserinfo["$rui"]["$ruj"] = array();
				$ruj--;
			}
			$rui--;
		}
		while ($cmpt = $vbulletin->db->fetch_array($cmpts))
		{
			$cmpt = process_tl_avatar($cmpt);
			$avatarlp = $cmpt['avatarlp'];
			$cmpt['time2'] = "<span class=\"smallfont\">".vbdate($vbulletin->options['dateformat'],$cmpt['time'], 1)." <span class=\"time\"> ".vbdate($vbulletin->options['timeformat'],$cmpt['time'])."</span></span>";
			$cmpt['time'] = " ".vbdate($vbulletin->options['dateformat'],$cmpt['time'], 1)." ".vbdate($vbulletin->options['timeformat'],$cmpt['time'])." ";
			$rowno ++;
			$cmpt['row'] = $rowno;
			$var = $cmpt['userid'];
			if (!$cmpt['username'])
			{
				$cmpt['username'] = $cmpt['sname'];
			}
			$array = array_merge((array)$var, $array);
			$var3 = $cmpt['username'];
			$useridlist = array_merge((array)$var3, $useridlist);
			if ($cmpt['winner'] == 1)
			{
				$var2 = $cmpt['userid'];
				$winnerlist = array_merge((array)$var2, $winnerlist);
				$winnernames = array_merge((array)$cmpt['username'], $winnernames);
			}
			$cmpt['userhtml'] = tll_userhtml($cmpt, $team);
			if ($type == $vbphrase['tmnt_1v1'] OR $type == $vbphrase['tmnt_de'])
			{
				$cmpt['round1'] = $rowno;
				$rounduserinfo['1']["$rowno"] = $cmpt;
				$rounduserinfo['2']["$cmpt[round2]"] = $cmpt;
				$rounduserinfo['3']["$cmpt[round3]"] = $cmpt;
				if ($cmpt['round5'] == 1 && $cmpt['round4'] == 0)
				{
					$cmpt['round4'] = 1;
				}
				$rounduserinfo['4']["$cmpt[round4]"] = $cmpt;
				$rounduserinfo['5']["$cmpt[round5]"] = $cmpt;
				$rounduserinfo['6']["$cmpt[round6]"] = $cmpt;
				$rounduserinfo['7']["$cmpt[round7]"] = $cmpt;
				$rounduserinfo['8']["$cmpt[round8]"] = $cmpt;
				if (($cmpt['round8'] & $tmnt['noplayers'] == 8) OR ($cmpt['round6'] & $tmnt['noplayers'] == 4) OR $tmnt['status'] == $vbphrase['tmnt_inprogress'])
				{
					$tmnt['show_round8'] = true;
				}
				$pinfo["$cmpt[userid]"] = $cmpt;
			}
			$p_array["$cmpt_count"] = $cmpt;
			$cmpt_count++;
		}
		$players = $tmnt['noplayers'];
		
		/** END :: ADAPTED FROM TOURNAMENTS.PHP PART 1 **/
		
		
		if ($players==4 && $ladder['knockout_type']=='de')
		{
		/** START :: ADAPTED FROM TOURNAMENTS.PHP PART 4 **/
#		if ($players == 4 && $type == $vbphrase['tmnt_de'])
#	{
		$rounds = ceil(log($tmnt['noplayers'], 2))+1;
		foreach ($rounduserinfo AS $round => $slot)
		{
			foreach ($rounduserinfo["$round"] AS $slot => $userinfo)
			{
				$loserround = 0;
				if ($userinfo['username'])
				{
					if ($userinfo['username'] == 'Bye' && $userinfo['userid'] == 0)
					{
						$rounduserinfo["$round"]["$slot"]['userurl'] .= $vbphrase['tmnt_bye_player'];
					}
					else
					{
						$rounduserinfo["$round"]["$slot"]['userurl'] .= tll_userhtml($userinfo, $team);
					}		
					$plusround = $round + 1;
					$minusround = $round - 1;
					if ($slot&1)
					{
						$ss = $slot + 1;
						$xx = $slot + 1;
					}
					else
					{
						$ss = $slot - 1;
						$xx = $slot;
					}
					$p = $xx / 2;
					$loserslot = (($p*2) + $players)/2;
					$loseruserid = $rounduserinfo["$round"]["$ss"]['userid'];
					if ($tmntp['canedittmnt'] AND $tmnt['status'] != $vbphrase['tmnt_finished'] AND $userinfo['userid'] != 0)
					{
						$show['progresslink'] = true;
						$show['loserplacement'] = true;
						$loserround = 0;
						if ($round == 1)
						{
							switch ($slot)
							{
								case 1:
								case 2:
									$loserslot = 5;
								break;
								case 3:
								case 4:
									$loserslot = 6;
								break;
							}
						}
						else if ($round == 2)
						{
							switch ($slot)
							{
								case 1:
								case 2:
									$p = 1;
									$loserslot = 3;
								break;
								case 5:
								case 6:
									$p = 4;
									$loserslot = 0;
									$show['loserplacement'] = false;
								break;
							}
						}
						elseif ($round == 3)
						{
							switch ($slot)
							{
								case 1:
								case 2:
									$p = 1;
									$loserslot = 2;
									$plusround = 5;
								break;
								case 3:
								case 4:
									$p = 2;
									$loserslot = 0;
									$show['loserplacement'] = false;
								break;
							}
						}
						elseif ($round == 4)
						{
							switch ($slot)
							{
								case 2:
									$p = 1;
									$loserslot = 2;
									$loseruserid = $rounduserinfo["3"]["1"]['userid'];
								break;
							}
						}
						elseif ($round == 5)
						{
							switch ($slot)
							{
								case 1:
									$p = 1;
									$loserslot = 0;
									$show['loserplacement'] = false;
								break;
							}
						}
						$plus_username = $rounduserinfo["$plusround"]["$p"]['username'];
						$plus_userinfo = $rounduserinfo["$plusround"]["$p"];
						if ($minusround && $dont)
						{
							$rounduserinfo["$round"]["$slot"]['userurl'] .= " <a href=\"javascript:ladder_regress('$tmnt[id]', '$userinfo[userid]', '$userinfo[username]', '$vbphrase[minusround]');\"><img src=\"" . vB_Template_Runtime::fetchStyleVar('imgdir_misc') . "/colorpicker_close.gif\" alt=\"$vbphrase[tmnt_regress]\" title=\"$vbphrase[tmnt_regress]\" class=\"inlineimg\" border=\"0\" /></a>";
						}
						if (!$plus_username)
						{
							$rounduserinfo["$round"]["$slot"]['progressfinish'] .= " <a href=\"javascript:ladder_progressfinish('$tmnt[id]', '$userinfo[userid]', '$userinfo[username]', 'round$plusround', '$p');\" style=\"float:right; padding-top: 5px; padding-right: 2px;\"><img src=\"" . vB_Template_Runtime::fetchStyleVar('imgdir_button') . "/viewpost.gif\" alt=\"$vbphrase[tmnt_progress]\" title=\"$vbphrase[tmnt_progress]\" class=\"inlineimg\" border=\"0\" /></a>";
							$rounduserinfo["$round"]["$slot"]['progress'] .= " <a href=\"javascript:ladder_progress('$tmnt[id]', '$userinfo[userid]', '$userinfo[username]', 'round$plusround', '$p'";
							if ($show['loserplacement'])
							{
								$rounduserinfo["$round"]["$slot"]['progress'] .= ", '$loseruserid', '$loserslot'" . ($loserround ? ", '$loserround'" : "");
							}
							$rounduserinfo["$round"]["$slot"]['progress'] .= ");\" style=\"float:right; padding-top: 5px; padding-right: 2px;\"><img src=\"" . vB_Template_Runtime::fetchStyleVar('imgdir_button') . "/viewpost.gif\" alt=\"$vbphrase[tmnt_progress]\" title=\"$vbphrase[tmnt_progress]\" class=\"inlineimg\" border=\"0\" /></a> ";
						}
					}
					if (($slot == 1 && $round == 3) OR ($round == 5))
					{
						$rounduserinfo["$round"]["$slot"]['userurl'] = $rounduserinfo["$round"]["$slot"]['progressfinish'].$rounduserinfo["$round"]["$slot"]['userurl'];
					}
					else
					{
						$rounduserinfo["$round"]["$slot"]['userurl'] = $rounduserinfo["$round"]["$slot"]['progress'].$rounduserinfo["$round"]["$slot"]['userurl'];
					}
				}
				else
				{
					$rounduserinfo["$round"]["$slot"]['userurl'] .= " &nbsp; &nbsp; &nbsp; &nbsp; ";
				}
				$rounduserinfo["$round"]["$slot"]['userurl'] = '<div id="bracket_round' . $round . "_slot" . $slot . '">' . $rounduserinfo["$round"]["$slot"]['userurl'] . "</div>";
			}
		}
		require_once(DIR . '/includes/functions_tll_brackets.php');
		$headinclude .= '<script type="text/javascript" src="clientscript/jquery/jquery-1.8.3.min.js"></script>'."\n";
		$headinclude .= '<script type="text/javascript" src="clientscript/javascript_tll_brackets.js"></script>'."\n";
		$brackets = tll_create_tmnt_brackets($tmnt['noplayers'], $rounduserinfo, 1, $tmnt['show_round8']);
		$results = $brackets;
		if ($tmnt['status'] == $vbphrase['tmnt_finished'])
		{
			$dom = $rounds + 2;
			$tmnt['winners'] = array();
			$domi = 1;
			if ($rounduserinfo["$rounds"]['1']['username'])
			{
				$tmnt['winners']['1'] = $rounduserinfo["$rounds"]['1']['username'];
				$domi = 2;
			}
			while ($dom > 1)
			{
				foreach ($rounduserinfo["$dom"] AS $a => $b)
				{
					if ($b['username'] && !in_array($b['username'], $tmnt['winners']) && $a > 0)
					{
						$tmnt['winners'][$domi] = $b['username'];
						$domi++;
					}
				}
				if (count($tmnt['winners'])==3)
				{
					break;
				}
				$dom--;
			}
		}
	#}
		$ladder['results_html'] = $brackets;
		/** END :: ADAPTED FROM TOURNAMENTS.PHP PART 4 **/
		}
		elseif ($players==8 && $ladder['knockout_type']=='de')
		{
		
		/** START :: ADAPTED FROM TOURNAMENTS.PHP PART 3 **/
#		if ($type == $vbphrase['tmnt_de'] && $players == 8)
#	{
		$rounds = ceil(log($tmnt['noplayers'], 2))+1;
		foreach ($rounduserinfo AS $round => $slot)
		{
			foreach ($rounduserinfo["$round"] AS $slot => $userinfo)
			{
				$loserround = 0;
				if ($userinfo['username'])
				{
					if ($userinfo['username'] == 'Bye' && $userinfo['userid'] == 0)
					{
						$rounduserinfo["$round"]["$slot"]['userurl'] .= $vbphrase['tmnt_bye_player'];
					}
					else
					{
						$rounduserinfo["$round"]["$slot"]['userurl'] .= tll_userhtml($userinfo, $team);
					}		
					$plusround = $round + 1;
					$minusround = $round - 1;
					if ($slot&1)
					{
						$ss = $slot + 1;
						$xx = $slot + 1;
					}
					else
					{
						$ss = $slot - 1;
						$xx = $slot;
					}
					$p = $xx / 2;
					$loserslot = (($p*2) + $players)/2;
					$loseruserid = $rounduserinfo["$round"]["$ss"]['userid'];
					if ($tmntp['canedittmnt'] AND $tmnt['status'] != $vbphrase['tmnt_finished'] AND $userinfo['userid'] != 0)
					{
						$show['progresslink'] = true;
						$show['loserplacement'] = true;
						$loserround = 0;
						if ($round == 1)
						{
							switch ($slot)
							{
								case 1:
								case 2:
									$loserslot = 9;
								break;
								case 3:
								case 4:
									$loserslot = 10;
								break;
								case 5:
								case 6:
									$loserslot = 11;
								break;
								case 7:
								case 8:
									$loserslot = 12;
								break;
							}
						}
						else if ($round == 2)
						{
							switch ($slot)
							{
								case 1:
								case 2:
									$p = 1;
									$loserslot = 5;
								break;
								case 3:
								case 4:
									$p = 2;
									$loserslot = 7;
								break;
								case 9:
								case 10:
									$p = 6;
									$loserslot = 0;
									$show['loserplacement'] = false;
								break;
								case 11:
								case 12:
									$p = 8;
									$loserslot = 0;
									$show['loserplacement'] = false;
								break;
							}
						}
						elseif ($round == 3)
						{
							switch ($slot)
							{
								case 1:
								case 2:
									$p = 1;
									$loserslot = 2;
									$loserround = "round5";//dom
								break;
								case 5:
								case 6:
									$p = 3;
									$loserslot = 0;
									$show['loserplacement'] = false;
								break;
								case 7:
								case 8:
									$p = 4;
									$loserslot = 0;
									$show['loserplacement'] = false;
								break;
							}
						}
						elseif ($round == 4)
						{
							switch ($slot)
							{
								case 1:
									$p = 1;
									$loserslot = 0;
									$plusround = 7;
									$show['loserplacement'] = false;
								break;
								case 3:
								case 4:
									$p = 3;
									$loserslot = 0;
									$show['loserplacement'] = false;
								break;
							}
						}
						elseif ($round == 5)
						{
							switch ($slot)
							{
								case 2:
								case 3:
									$p = 1;
									$loserslot = 0;
									$show['loserplacement'] = false;
								break;
							}
						}
						elseif ($round == 6)
						{
							switch ($slot)
							{
								case 1:
									$p = 1;
									$loserslot = 2;
									$loseruserid = $rounduserinfo["4"]["1"]['userid'];
								break;
							}
						}
						$plus_username = $rounduserinfo["$plusround"]["$p"]['username'];
						$plus_userinfo = $rounduserinfo["$plusround"]["$p"];
						if ($minusround && $dont)
						{
							$rounduserinfo["$round"]["$slot"]['userurl'] .= " <a href=\"javascript:ladder_regress('$tmnt[id]', '$userinfo[userid]', '$userinfo[username]', '$vbphrase[minusround]');\"><img src=\"" . vB_Template_Runtime::fetchStyleVar('imgdir_misc') . "/colorpicker_close.gif\" alt=\"$vbphrase[tmnt_regress]\" title=\"$vbphrase[tmnt_regress]\" class=\"inlineimg\" border=\"0\" /></a>";
						}
						if (!$plus_username)
						{
							$rounduserinfo["$round"]["$slot"]['progressfinish'] .= " <a href=\"javascript:ladder_progressfinish('$tmnt[id]', '$userinfo[userid]', '$userinfo[username]', 'round$plusround', '$p');\" style=\"float:right; padding-top: 5px; padding-right: 2px;\"><img src=\"" . vB_Template_Runtime::fetchStyleVar('imgdir_button') . "/viewpost.gif\" alt=\"$vbphrase[tmnt_progress]\" title=\"$vbphrase[tmnt_progress]\" class=\"inlineimg\" border=\"0\" /></a>";
							$rounduserinfo["$round"]["$slot"]['progress'] .= " <a href=\"javascript:ladder_progress('$tmnt[id]', '$userinfo[userid]', '$userinfo[username]', 'round$plusround', '$p'";
							if ($show['loserplacement'])
							{
								$rounduserinfo["$round"]["$slot"]['progress'] .= ", '$loseruserid', '$loserslot'" . ($loserround ? ", '$loserround'" : "");
							}
							$rounduserinfo["$round"]["$slot"]['progress'] .= ");\" style=\"float:right; padding-top: 5px; padding-right: 2px;\"><img src=\"" . vB_Template_Runtime::fetchStyleVar('imgdir_button') . "/viewpost.gif\" alt=\"$vbphrase[tmnt_progress]\" title=\"$vbphrase[tmnt_progress]\" class=\"inlineimg\" border=\"0\" /></a> ";
						}
					}
					if (($slot == 1 && $round == 4) OR ($round == 7))
					{
						$rounduserinfo["$round"]["$slot"]['userurl'] = $rounduserinfo["$round"]["$slot"]['progressfinish'].$rounduserinfo["$round"]["$slot"]['userurl'];
					}
					else
					{
						$rounduserinfo["$round"]["$slot"]['userurl'] = $rounduserinfo["$round"]["$slot"]['progress'].$rounduserinfo["$round"]["$slot"]['userurl'];
					}
				}
				else
				{
					$rounduserinfo["$round"]["$slot"]['userurl'] .= " &nbsp; &nbsp; &nbsp; &nbsp; ";
				}
				$rounduserinfo["$round"]["$slot"]['userurl'] = '<span id="bracket_round' . $round . "_slot" . $slot . '">' . $rounduserinfo["$round"]["$slot"]['userurl'] . "</span>";			
			}
		}
		require_once(DIR . '/includes/functions_tll_brackets.php');
		$headinclude .= '<script type="text/javascript" src="clientscript/jquery/jquery-1.8.3.min.js"></script>'."\n";
		$headinclude .= '<script type="text/javascript" src="clientscript/javascript_tll_brackets.js"></script>'."\n";
		$brackets = tll_create_tmnt_brackets($tmnt['noplayers'], $rounduserinfo, 1, $tmnt['show_round8']);
		$results = $brackets;
		if ($tmnt['status'] == $vbphrase['tmnt_finished'])
		{
			$dom = $rounds + 2;
			$tmnt['winners'] = array();
			$domi = 1;
			if ($rounduserinfo["$rounds"]['1']['username'])
			{
				$tmnt['winners']['1'] = $rounduserinfo["$rounds"]['1']['username'];
				$domi = 2;
			}
			while ($dom > 1)
			{
				foreach ($rounduserinfo["$dom"] AS $a => $b)
				{
					if ($b['username'] && !in_array($b['username'], $tmnt['winners']) && $a > 0)
					{
						$tmnt['winners'][$domi] = $b['username'];
						$domi++;
					}
				}
				if (count($tmnt['winners'])==3)
				{
					break;
				}
				$dom--;
			}
		}
	#}
		/** END :: ADAPTED FROM TOURNAMENTS.PHP PART 3 **/
		
		$ladder['results_html'] = $brackets;
		}
		else
		{
		/** START :: ADAPTED FROM TOURNAMENTS.PHP PART 2 **/
		
		$rounds = ceil(log($tmnt['noplayers'], 2))+1;
		foreach ($rounduserinfo AS $round => $slot)
		{
			foreach ($rounduserinfo["$round"] AS $slot => $userinfo)
			{
				if ($userinfo['username'])
				{
					if ($userinfo['username'] == 'Bye' && $userinfo['userid'] == 0)
					{
						$rounduserinfo["$round"]["$slot"]['userurl'] .= $vbphrase['tmnt_bye_player'];
					}
					else
					{
						$rounduserinfo["$round"]["$slot"]['userurl'] .= tll_userhtml($userinfo, $team);
					}
					$plusround = $round + 1;
					$minusround = $round - 1;
					if ($slot&1)
					{
						$ss = $slot + 1;
						$xx = $slot + 1;
					}
					else
					{
						$ss = $slot - 1;
						$xx = $slot;
					}
					$p = $xx / 2;
					
					if ($tmntp['canedittmnt'] AND $tmnt['status'] != $vbphrase['tmnt_finished'] AND $userinfo['userid'] != 0)
					{
						$show['progresslink'] = true;
						$plus_username = $rounduserinfo["$plusround"]["$p"]['username'];
						$plus_userinfo = $rounduserinfo["$plusround"]["$p"];
						if ($minusround && !$plus_username)
						{
							$rounduserinfo["$round"]["$slot"]['userurl'] .= " <a href=\"javascript:ladder_regress('$tmnt[id]', '$userinfo[userid]', '$userinfo[username]', 'round$round');\"><img src=\"" . vB_Template_Runtime::fetchStyleVar('imgdir_misc') . "/colorpicker_close.gif\" alt=\"$vbphrase[tmnt_regress]\" title=\"$vbphrase[tmnt_regress]\" class=\"inlineimg\" border=\"0\" /></a>";
						}
						if (!$plus_username)
						{
							$rounduserinfo["$round"]["$slot"]['progressfinish'] .= " <a href=\"javascript:ladder_progressfinish('$tmnt[id]', '$userinfo[userid]', '$userinfo[username]', 'round$plusround', '$p');\" style=\"float:right; padding-top: 5px; padding-right: 2px;\"><img src=\"" . vB_Template_Runtime::fetchStyleVar('imgdir_button') . "/viewpost.gif\" alt=\"$vbphrase[tmnt_progress]\" title=\"$vbphrase[tmnt_progress]\" class=\"inlineimg\" border=\"0\" /></a>";
							$rounduserinfo["$round"]["$slot"]['progress'] .= " <a href=\"javascript:ladder_progress('$tmnt[id]', '$userinfo[userid]', '$userinfo[username]', 'round$plusround', '$p'";
							if ($show['loserplacement'])
							{
								$rounduserinfo["$round"]["$slot"]['progress'] .= ", '$loseruserid', '$loserslot'" . ($loserround ? ", '$loserround'" : "");
							}
							$rounduserinfo["$round"]["$slot"]['progress'] .= ");\" style=\"float:right; padding-top: 5px; padding-right: 2px;\"><img src=\"" . vB_Template_Runtime::fetchStyleVar('imgdir_button') . "/viewpost.gif\" alt=\"$vbphrase[tmnt_progress]\" title=\"$vbphrase[tmnt_progress]\" class=\"inlineimg\" border=\"0\" /></a> ";
						}
						if ($round == $rounds - 1)
						{
							$rounduserinfo["$round"]["$slot"]['userurl'] = $rounduserinfo["$round"]["$slot"]['progressfinish'] . $rounduserinfo["$round"]["$slot"]['userurl'];
						}
						else
						{
							$rounduserinfo["$round"]["$slot"]['userurl'] = $rounduserinfo["$round"]["$slot"]['progress'] . $rounduserinfo["$round"]["$slot"]['userurl'];
						}
					}
				}
				else
				{
					$rounduserinfo["$round"]["$slot"]['userurl'] .= " &nbsp; &nbsp; &nbsp; &nbsp; ";
				}
				$rounduserinfo["$round"]["$slot"]['userurl'] = '<div id="bracket_round' . $round . "_slot" . $slot . '">' . $rounduserinfo["$round"]["$slot"]['userurl'] . "</div>";
			}
		}
		if (!$team && $pinfo["$thisuserid"] && $tmnt['status'] == $vbphrase['tmnt_inprogress'])
		{
			for ($i = $rounds; $i >= 1; $i--)
			{
				if (!$pinfo["$thisuserid"]['round'.$i])
				{
					continue;
				}
				else
				{
					$th_slot = $pinfo["$thisuserid"]['round'.$i];
					if ($th_slot % 2)
					{
						$op_slot = $th_slot - 1;
					}
					else
					{
						$op_slot = $th_slot + 1;
					}
					$op_userinfo = $rounduserinfo["$i"]["$op_slot"];
					$pp_slot = ceil($th_slot / 2);
					$ip = $i + 1;
					$pp = $rounduserinfo["$ip"]["$pp_slot"];
					if ($pp)
					{
						break;
					}
					$tmnt['nextinfo'] = array(
						'round' => $i,
						'userid' => $op_userinfo['userid'],
						'username' => $op_userinfo['username'],
					);
					break;
				}
			}
		}
		require_once(DIR . '/includes/functions_tll_brackets.php');
		$headinclude .= '<script type="text/javascript" src="clientscript/jquery/jquery-1.8.3.min.js"></script>'."\n";
		$headinclude .= '<script type="text/javascript" src="clientscript/javascript_tll_brackets.js"></script>'."\n";
		$brackets = tll_create_tmnt_brackets($tmnt['noplayers'], $rounduserinfo);
		$ladder['results_html'] = $brackets;
		//$competitors .= $brackets;
		/** END :: ADAPTED FROM TOURNAMENTS.PHP **/
		}
	}
	elseif ($_REQUEST['sh'] == 9 && file_exists(DIR . '/tll_modules/tll_squadscores.php') && $team)
	{//top goal scores
		$sh = 9;
		//tmnt_ladder_players
		$aa = array();
		$games = $vbulletin->db->query_read("
			SELECT games.*, t_u.teamname AS tu, t_u2.teamname AS tu2, t_u.teamid AS tuid, t_u2.teamid AS tu2id
			FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
			LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS t_u
				ON (games.pot = 1 AND games.u = t_u.teamid)
			LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS t_u2
				ON (games.pot = 1 AND games.u2 = t_u2.teamid)
			WHERE
				games.finished = 1
				AND games.lid = $lid
			ORDER BY games.dateline ASC
		");
		while($game = $vbulletin->db->fetch_array($games))
		{
			$game['squad_scores'] = unserialize($game['squad_scores']);
			if ($game['squad_scores']['u'])
			{
				foreach ($game['squad_scores']['u'] AS $uu => $uscore)
				{
					$aa["$uu"]['userinfo'] = fetch_userinfo($uu);
					$aa["$uu"]['scores'] += $uscore;
					$aa["$uu"]['teamname'] = $game['tu'];
					$aa["$uu"]['teamid'] = $game['tuid'];
				}
			}
			if ($game['squad_scores']['u2'])
			{
				foreach ($game['squad_scores']['u2'] AS $uu => $uscore)
				{
					$aa["$uu"]['userinfo'] = fetch_userinfo($uu);
					$aa["$uu"]['scores'] += $uscore;
					$aa["$uu"]['teamname'] = $game['tu2'];
					$aa["$uu"]['teamid'] = $game['tu2id'];
				}
			}
			//print_r($game['squad_scores']);
		}
		function aasort(&$array, $key) 
		{
			$sorter=array();
			$ret=array();
			reset($array);
			foreach ($array as $ii => $va) {
				$sorter[$ii]=$va[$key];
			}
			asort($sorter);
			foreach ($sorter as $ii => $va) {
				$ret[$ii]=$array[$ii];
			}
			$array=$ret;
		}

		aasort($aa, "scores");
		$aa = array_reverse($aa, true);
		$ladder['topplayers'] = $aa;
		/*
		$games = $vbulletin->db->query_read("
			SELECT games.*, ".($ladder['pot'] ? " t.teamname AS username" : " u.username AS username")."
			FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
			LEFT JOIN " . TABLE_PREFIX . "user AS u
				ON (games.pot = 0 AND games.u = u.userid)
			LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS t
				ON (games.pot = 1 AND games.u = t.teamid)
			WHERE
				games.u2 = 0
				AND games.finished = 0
				AND games.accepted = 0
				AND games.pot = ".$ladder['pot']."
				AND games.lid = $id
				AND games.dateline > ".TIMENOW."
			ORDER BY games.dateline ASC
			LIMIT 0, 20
		");
		while($game = $vbulletin->db->fetch_array($games))
		{
		
		$querytt = $vbulletin->db->query_read("
			SELECT *
			FROM " . TABLE_PREFIX . "tmnt_members AS m
			LEFT JOIN " . TABLE_PREFIX . "tmnt_ladder_players AS p 
				ON (m.id = p.userid)
			LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS l
				ON (p.lid = l.id)
			WHERE p.lid = $lid
		");
		while($row = $vbulletin->db->fetch_array($querytt))
		{
			print_r($row);
		}*/
	}
	elseif (($_REQUEST['sh'] == 10 OR $_REQUEST['sh'] == 11) && file_exists(DIR . '/tll_modules/tll_squadscores.php') && $team)
	{//yellow/red cards
		switch ($_REQUEST['sh'])
		{
			case 10:
				$car = 'yellow';
				$sh = 10;
				break;
			case 11:
				$car = 'red';
				$sh = 11;
				break;
		}
		$ladder['card_img'] = '<img src="images/buttons/'.$car.'-card_sm.png" alt="" />';
		$aa = array();
		$games = $vbulletin->db->query_read("
			SELECT games.*, t_u.teamname AS tu, t_u2.teamname AS tu2, t_u.teamid AS tuid, t_u2.teamid AS tu2id
			FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
			LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS t_u
				ON (games.pot = 1 AND games.u = t_u.teamid)
			LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS t_u2
				ON (games.pot = 1 AND games.u2 = t_u2.teamid)
			WHERE
				games.finished = 1
				AND games.lid = '$lid'
				AND games.".$car."_cards != ''
			ORDER BY games.dateline ASC
		");
		while($game = $vbulletin->db->fetch_array($games))
		{
			$game[$car.'_cards'] = unserialize($game[$car.'_cards']);
			if ($game[$car.'_cards']['u'])
			{
				foreach ($game[$car.'_cards']['u'] AS $uu => $uid)
				{
					$aa["$uid"]['userinfo'] = fetch_userinfo($uid);
					$aa["$uid"][$car.'_cards']++;
					$aa["$uid"]['teamname'] = $game['tu'];
					$aa["$uid"]['teamid'] = $game['tuid'];
				}
			}
			if ($game[$car.'_cards']['u2'])
			{
				foreach ($game[$car.'_cards']['u2'] AS $u2 => $u2id)
				{
					$aa["$u2id"]['userinfo'] = fetch_userinfo($u2id);
					$aa["$u2id"][$car.'_cards']++;
					$aa["$u2id"]['teamname'] = $game['tu2'];
					$aa["$u2id"]['teamid'] = $game['tu2id'];
				}
			}
		}
		function aasort(&$array, $key) 
		{
			$sorter=array();
			$ret=array();
			reset($array);
			foreach ($array as $ii => $va) {
				$sorter[$ii]=$va[$key];
			}
			asort($sorter);
			foreach ($sorter as $ii => $va) {
				$ret[$ii]=$array[$ii];
			}
			$array=$ret;
		}
		aasort($aa, $car."_cards");
		$aa = array_reverse($aa, true);
		$ladder['cards'] = $aa;
	}
	elseif ($_REQUEST['sh']==12)
	{
		$sh = 12;
		$q = $vbulletin->db->query_read("
			SELECT c.*, u.username, t.teamname
			FROM " . TABLE_PREFIX . "tmnt_cstats AS c	
			LEFT JOIN " . TABLE_PREFIX . "user AS u
				ON (u.userid = c.userid)
			LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS t
				ON (t.teamid = c.teamid)
			WHERE lid = '$lid'
			GROUP BY c.userid, c.teamid
			ORDER BY goals DESC, assists DESC
		");
		while ($a = $vbulletin->db->fetch_array($q))
		{
			$a['teamurl'] = tll_seo('team', $a['teamid'], $a['teamname'], 1);
			$array[] = $a;
		}
		$templater = vB_Template::create('tmnt_cstats');
			$templater->register('hide', 1);
			$templater->register('tll_array', $array);
			$templater->register('tll_array2', $array2);
			$templater->register('tll_array3', $array3);
			$templater->register('search_player', $vbulletin->GPC['search_player']);
			$templater->register('search_team', $vbulletin->GPC['search_team']);
			$templater->register('ladderinfo', $ladder);
			$templater->register('tmntinfo', $tmntinfo);
			$templater->register('tmntp', $tmntp);
			$templater->register('from', 'ladder');
		$template_hook['tmnt_tabs_html'] .= $templater->render();
	}
	elseif (in_array($_REQUEST['sh'], array(10,11,12,13,14,15)))
	{
		$sh = $vbulletin->input->clean_gpc('g', 'sh', TYPE_UINT);
	}
	if (file_exists(DIR . '/tll_modules/tll_squadscores.php') && $team )
	{
		if (!file_exists(DIR . '/cstats.php'))
		{
			$ladder['show_topscores'] = true;
		}
		$ladder['show_cards'] = true;
	}
	if (file_exists(DIR . '/cstats.php') && $team)
	{
		$ladder['show_pstats'] = true;
	}
	$offset = $ladder['dst'] ? $vbulletin->userinfo['timezoneoffset'] : $vbulletin->userinfo['tzoffset'];
	$ladder['dateline_from_user'] = $ladder['dateline_from'] + $offset * 3600;
	$ladder['dateline_to_user'] = $ladder['dateline_to'] + $offset * 3600;
	require_once(DIR . '/includes/functions_calendar.php');
	$ladder = fetch_event_date_time($ladder);
	if (TIMENOW < $ladder['dateline_from'])
	{
		$ladder['status2'] = $vbphrase['ladder_starting_on']." $date1 $time1";
	}
	elseif ($ladder['dateline_from'] < TIMENOW && TIMENOW < $ladder['dateline_to'])
	{
		$ladder['status2'] = $vbphrase['ladder_closing_on']." $date2 $time2";
	}
	else
	{
		$ladder['status2'] = $vbphrase['ladder_finished_on']." $date2 $time2";
	}
	// facebook options
	if (is_facebookenabled())
	{
		// display the like button for this ladder?
		$templater = vB_Template::create('facebook_likebutton');
		$fb_url = $vbulletin->options['bburl'].'/ladders.php?do=view&amp;id='.$id;
		if(is_browser('ie') || is_browser('opera'))
		{
			$templater->register('href', urlencode($fb_url));
		}
		else 
		{
			$templater->register('href', $fb_url);
		}
		$fblikebutton = $templater->render();
		$show['fb_likebutton'] = true;
	}
	if ($ladder['league'] && !$ladder['pot'] && $comper && !$ladder['racemode'])
	{
		$lnm = $vbulletin->db->query_first("
			SELECT games.*, games.u AS uid, games.u2 AS u2id, user.username, user2.username AS username2
			FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
			LEFT JOIN " . TABLE_PREFIX . "user AS user
				ON (games.u = user.userid AND games.pot = 0)
			LEFT JOIN " . TABLE_PREFIX . "user AS user2
				ON (games.u2 = user2.userid AND games.pot = 0)
			WHERE ( games.u IN(".$vbulletin->userinfo['userid'].") OR games.u2 IN(".$vbulletin->userinfo['userid'].") )
				AND games.finished = 0
				AND games.accepted != -1
				AND games.lid = $id	
			ORDER BY games.round ASC
		"); 
		if ($lnm['u'] == $vbulletin->userinfo['userid'])
		{
			$lnm['userid'] = $lnm['u2id'];
			$lnm['username'] = $lnm['username2'];
		}
		else
		{
			$lnm['userid'] = $games['uid'];
			$lnm['username'] = $lnm['username'];
		}
		$ladder['nextinfo'] = $lnm;
	}
	if ($tmntp['admintickets'])
	{
		$ticket_count = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_tickets WHERE ladderid = '$lid' AND closed = 0 ");
		if ($ticket_count['countrows'])
		{
			$ladder['open_support_tickets_link'] = '<a href="tll_tickets.php?ladderid=' . $lid . '" class="button" style="color: #FF0000; padding: 4px; border-color: #FF0000;">' . $ticket_count['countrows'] . ' Open Support Tickets</a>';
		}
	}
	if ($vbulletin->options['tmnt_navleft'])
	{
		require_once(DIR . '/includes/functions_tll_sidebar.php');
		if (((!$comper AND $tmntp['canjoinladder']) OR $team) && !$ladder['archive'] && $ladder['league'] < 2 && !$embed)
		{
			$nlcontent .= '<p><a href="ladders.php?do=join&amp;id='.$lid.'" class="tllpopup" style="color: inherit;">'.$vbphrase['ladder_join'].'</a></p>';
		}
		if ($comper && $ladder['league'] != 1 && !$team && !$ladder['racemode'])
		{
			$nlcontent .= '<p><a href="'.$ladder['url'].'&amp;sh=3" style="color: inherit;">'.$vbphrase['ladder_yourchlls'].'</a></p>';
		}
		if ($tmntp['caneditladder'] && $ladder['league'] == 1)
		{
			$nlcontent .= '<p><a href="ladders_admin.php?do=startleague&amp;lid='.$lid.'" style="color: inherit;">'.$vbphrase['ladder_startleague'].'</a></p>';
		}
		if ($tmntp['caneditladder'] && $ladder['league'] > 1 && $ladder['tmnt_status'] == 0 && $ladder['knockout'] > 0)
		{
			$nlcontent .= '<p style="padding-top: 5px;"><a href="ladders_admin.php?do=start_knockout&amp;lid='.$lid.'"  style="color: inherit;">Start Knockout</a></p>';
		}
		$template_hook['tmnt_navleft_top'] .= tll_sidebar_block($ladder['title'], $nlcontent, ''.$ladder['url'], 'ladder_'.$lid);
	}
	$headinclude = activate_tooltips($headinclude);
	$templater = vB_Template::create('tmnt_ladder_display');
		$templater->register('pagenav', $pagenav);
		$templater->register('tmntp', $tmntp);
		$templater->register('team', $team);
		$templater->register('ladder', $ladder);
		$templater->register('sarray', $sarray);
		$templater->register('TIMENOW', $TIMENOW);
		$templater->register('id', $id);
		$templater->register('sh', $sh);
		$templater->register('lid', $lid);
		$templater->register('comper', $comper);
		$templater->register('rowno', $rowno);
		$templater->register('show', $show);
		$templater->register('competitors', $competitors);
		$templater->register('matches', $matches);
		$templater->register('chllarray', $chllarray);
		$templater->register('competitorddms', $competitorddms);
		$templater->register('time1', $time1);
		$templater->register('time2', $time2);
		$templater->register('date1', $date1);
		$templater->register('date2', $date2);
		$templater->register('fblikebutton', $fblikebutton);
		$templater->register('embed', $embed);
		$templater->register('template_hook', $template_hook);
	$tlhtml .= $templater->render();
	$navbits = array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname
	);
	if (!$ladder['league'])
	{
		$navbits['ladders.php?' . $vbulletin->session->vars['sessionurl_q'] . 'showonly=ladders'] = $vbphrase['ladders'];
	}
	else
	{
		$navbits['ladders.php?' . $vbulletin->session->vars['sessionurl_q'] . 'showonly=leagues'] = $vbphrase['ladder_leagues'];
	}
	if ($ladder['parenttitle'])
	{
		$navbits['ladders.php' . $ladder['parenturl']] = $ladder['parenttitle'];
	}
	$navbits['ladders.php' . $ladder['categoryurl']] = $ladder['categorytitle'];
	$navbits[''] = construct_phrase($title);
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "tmnt_ladders SET views = views + 1 WHERE id = '$id'
	");
	$navbar = render_navbar_template(construct_navbits($navbits));
	if ($_REQUEST['rankingsonly'] || $_REQUEST['embed'])
	{
		//$tlhtml = $brackets;
		$navbar = $footer = $header = '';
		$vbulletin->options['tmnt_navtop'] = $vboptions['tmnt_navtop'] = $vboptions['tmnt_navleft'] = $show['scrolling_announcements'] = $vboptions['tmnt_active'] = 0;
		$vbulletin->options['tmnt_disablecopyright'] = 1;
		$vboptions['tmnt_navleftbanner']='';
		$tmntp = 0;
		$vbulletin->options['tmnt_navleft'] = 0; 
		$vboptions['tmnt_navleft'] = 0;
	}
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	$templater->register('template_hook', $template_hook);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'])
{
	$_REQUEST['do'] = '';
}

// #############################################################################

if (empty($_REQUEST['do']))
{
	if (!$tmntp['canviewladder'])
	{
		print_no_permission();
	}
	$c = $vbulletin->input->clean_gpc('g', 'c', TYPE_UINT);
	if (!$c && $vbulletin->options['tmnt_premium'] && $vbulletin->options['tmnt_seo'] && isset($_SERVER['REQUEST_URI']))
	{
		$thisurl = end(explode('/',$vbulletin->input->clean($_SERVER['REQUEST_URI'], TYPE_NOHTML)));
		if (substr($thisurl, 0, 12)=='ladders.php?' && strlen($thisurl)>12)
		{
			$c = $vbulletin->input->clean(substr($thisurl,12), TYPE_UINT);
		}
	}
	$filename = 'ladders';
	/*$cats = $vbulletin->db->query_read("
		SELECT cats.*, COUNT(DISTINCT ladders.id) AS countladders
		FROM " . TABLE_PREFIX . "tmnt_categories AS cats
		LEFT OUTER JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders
			ON (cats.catid = ladders.catid)
		WHERE cats.tol IN (2, 3)
		" . ($c ? " AND parentid = '$c' " : "") . "
		GROUP BY cats.catid
		ORDER BY cats.parentid DESC, cats.displayorder ASC, cats.title ASC
	");
	$carray = array();
	$ctarray  = array();
	while($cat = $vbulletin->db->fetch_array($cats))
	{
		$cat['counttmnts'] = -1;
		$cat['countladders'] += (int)$ctarray["$cat[catid]"]['lcount'];
		$ctarray["$cat[parentid]"]['lcount'] += $cat['countladders'];
		$templater = vB_Template::create('tmnt_cat');
			$templater->register('tmntp', $tmntp);
			$templater->register('cat', $cat);
			$templater->register('c', $c);
			$templater->register('filename', $filename);
		if (!$c && $cat['parentid'])
		{
			
			$carray["$cat[parentid]"] .= $templater->render();
		}
		else
		{
			$templater->register('subcs', $carray["$cat[catid]"]);
			$categories .= $templater->render();
		}
	}*/
	$showonly = $vbulletin->input->clean_gpc('g', 'showonly', TYPE_NOHTML);
	if ($vbulletin->tll_catcache)
	{
		foreach ($vbulletin->tll_catcache AS $cindex => $cat)
		{
			if ((!in_array('ladders',$cat['tol']) && !in_array('leagues',$cat['tol'])) OR ($c && $cat['parentid'] != $c))
			{
				continue;
			}
			$cat['counttmnts'] = -1;
			$templater = vB_Template::create('tmnt_cat');
				$templater->register('tmntp', $tmntp);
				$templater->register('cat', $cat);
				$templater->register('c', $c);
				$templater->register('showonly', $showonly);
				$templater->register('filename', $filename);
			if (!$c && $cat['parentid'])
			{
				
				$carray["$cat[parentid]"] .= $templater->render();
			}
			else
			{
				$templater->register('subcs', $carray["$cat[catid]"]);
				$categories .= $templater->render();
			}
		}
	}
	$recentmatches = array('1' => array('id' => '2', 'title' => 'xxx'));
	$rowcount = 0;
	require_once(DIR . '/includes/class_bbcode.php');
	$cinfo = $vbulletin->tll_catcache["$c"];
	$categorytitle = $cinfo['title'];
	$parentcategorytitle = $cinfo['parenttitle'];
	$parentcategoryid = $cinfo['parentid'];
	if (!$categorytitle && !$c)
	{
		if ($showonly == 'ladders')
		{
			$categorytitle = $vbphrase['tmnt_uncat_ladders'];
		}
		elseif ($showonly == 'leagues')
		{
			$categorytitle = $vbphrase['tmnt_uncat_leagues'];
		}
		else
		{
			$categorytitle = $vbphrase['tmnt_uncat_ldslgs'];
		}
	}
	elseif (!$categorytitle)
	{
		if ($showonly == 'ladders')
		{
			$categorytitle = $vbphrase['ladders'];
		}
		elseif ($showonly == 'leagues')
		{
			$categorytitle = $vbphrase['ladder_leagues'];
		}
		else
		{
			$categorytitle = $vbphrase['ladders_and_leagues'];
		}
	}
	if ($cinfo['parsed_banner'])
	{
		$cinfo['banner'] = $cinfo['parsed_banner'];
	}
	elseif ($cinfo['banner'])
	{
		require_once(DIR . '/includes/class_bbcode.php');
		$bbcode_parser = new vB_BbCodeParser($vbulletin, fetch_tag_list(), true); 
		$cinfo['banner'] = $bbcode_parser->do_parse($cinfo['banner']);
	}
	$parentcategoryurl = tll_seo('cat', $parentcategoryid, $parentcategorytitle);
	$ladders = $vbulletin->db->query_read("
		SELECT ladders.*
		FROM " . TABLE_PREFIX . "tmnt_ladders AS ladders
		WHERE ladders.catid = '$c'
			" . ($showonly == 'ladders' ? " AND ladders.league = 0" : "") . "
			" . ($showonly == 'leagues' ? " AND ladders.league > 0" : "") . "
		ORDER BY ladders.sticky DESC, ladders.title ASC
	");
	while($ladder = $vbulletin->db->fetch_array($ladders))
	{
		if ($rowcount == 0)
		{
			$templater = vB_Template::create('tmnt_ladder_list_top');
				$templater->register('tmntp', $tmntp);
				$templater->register('rowcount', $rowcount);
				$templater->register('categorytitle', $categorytitle);
				$templater->register('categories', $categories);
				$templater->register('ladder', $ladder);
				$templater->register('cinfo', $cinfo);
				$templater->register('showonly', $showonly);
			$tlhtml .= $templater->render();
		}
		$sticky = $ladder['sticky'];
        $description = preg_replace ('/\[(.*?)\]/is', '', $ladder['description']);
		$descriptionlength = strlen($description);
		if ($descriptionlength > $vbulletin->options['tmnt_desclength'])
		{
			$description = substr($description, 0, $vbulletin->options['tmnt_desclength']);
			$description = $description . '...';
		}
		$bbcode_parser = new vB_BbCodeParser($vbulletin, fetch_tag_list(), false); 
		$description = $bbcode_parser->do_parse($description,false,false,true,false,false,false);
		$ladder['url'] = tll_seo(($ladder['league'] > 0 ? 'league' : 'ladder'), $ladder['id'], $ladder['title'], 1);
		$templater = vB_Template::create('tmnt_ladder_list');
			$templater->register('tmntp', $tmntp);
			$templater->register('rowcount', $rowcount);
			$templater->register('categorytitle', $categorytitle);
			$templater->register('ladder', $ladder);
			$templater->register('description', $description);
			$templater->register('sticky', $sticky);
			$templater->register('rowcount', $rowcount);
		$tlhtml .= $templater->render();
		$rowcount ++;
	}
	if ($rowcount == 0)
	{
		if ($c)
		{
			/*$tol = "2,3";
			$titles = fetch_category_titles($c, $tol);
			$categorytitle = $titles['title'];
			$parentcategorytitle = $titles['parenttitle'];
			$parentcategoryid = $titles['parentid'];
			$parentcategoryurl = $titles['parenturl'];*/
			if (!$categorytitle)
			{
				$errormessage = $vbphrase[error_invalid_category];
				eval(standard_error($errormessage));
			}
			$cinfo = $vbulletin->tll_catcache["$c"];
			if ($cinfo['parsed_banner'])
			{
				$cinfo['banner'] = $cinfo['parsed_banner'];
			}
			elseif ($cinfo['banner'])
			{
				require_once(DIR . '/includes/class_bbcode.php');
				$bbcode_parser = new vB_BbCodeParser($vbulletin, fetch_tag_list(), true); 
				$cinfo['banner'] = $bbcode_parser->do_parse($cinfo['banner']);
			}
		}
		else
		{
			if ($showonly == 'leagues')
			{
				$categorytitle = $vbphrase['tmnt_uncat_leagues'];
			}
			elseif ($showonly == 'ladders')
			{
				$categorytitle = $vbphrase['tmnt_uncat_ladders'];
			}
			else
			{
				$categorytitle = $vbphrase['tmnt_uncat_ldslgs'];
			}
		}
		$templater = vB_Template::create('tmnt_ladder_list_top');
			$templater->register('tmntp', $tmntp);
			$templater->register('rowcount', $rowcount);
			$templater->register('categorytitle', $categorytitle);
			$templater->register('categories', $categories);
			$templater->register('ladder', $ladder);
			$templater->register('showonly', $showonly);
			$templater->register('cinfo', $cinfo);
		$tlhtml .= $templater->render();
		if (!$categories)
		{
			$templater = vB_Template::create('tmnt_ladder_noladders');
				$templater->register('tmntp', $tmntp);
				$templater->register('rowcount', $rowcount);
				$templater->register('categorytitle', $categorytitle);
				$templater->register('ladder', $ladder);
				$templater->register('league', ($showonly == 'leagues' ? "1" : "0"));
			$tlhtml .= $templater->render();
		}
	}
	$templater = vB_Template::create('tmnt_ladder_list_bot');
		$templater->register('tmntp', $tmntp);
		$templater->register('rowcount', $rowcount);
		$templater->register('categorytitle', $categorytitle);
		$templater->register('categories', $categories);
		$templater->register('ladder', $ladder);
		$templater->register('showonly', $showonly);
		$templater->register('c', $c);
	$tlhtml .= $templater->render();
	if ($rowcount)
	{
		list($count, $recentmatches, $upcomingmatches) = get_rg_ug($c);
		$random = get_random_l_torp($c);
		$sh = $vbulletin->input->clean_gpc('g', 'sh', TYPE_NOHTML);
		if (!$sh)
		{
			$sh = 'rg';
		}
		$templater = vB_Template::create('tmnt_ladder_list_rm');
			$templater->register('tmntp', $tmntp);
			$templater->register('rowcount', $rowcount);
			$templater->register('categorytitle', $categorytitle);
			$templater->register('categories', $categories);
			$templater->register('ladder', $ladder);
			$templater->register('recentmatches', $recentmatches);
			$templater->register('upcomingmatches', $upcomingmatches);
			$templater->register('random', $random);
			$templater->register('count', $count);
			$templater->register('sh', $sh);
			$templater->register('c', $c);
		$recentmatches = $templater->render();
		$tlhtml = str_replace('{recentmatches}', $recentmatches, $tlhtml);
	}
	$tlhtml = str_replace('{recentmatches}', '', $tlhtml);
	$navbits = array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname
	);
	$x = 'ladders.php?' . $vbulletin->session->vars['sessionurl_q'] . ($showonly ? "showonly=$showonly" : "");
	if ($showonly == 'leagues')
	{
		$navbits["$x"] = $vbphrase['ladder_leagues'];
	}
	elseif ($showonly == 'ladders')
	{
		$navbits["$x"] = $vbphrase['ladders'];
	}
	else
	{
		$navbits["$x"] = $vbphrase['ladders_and_leagues'];
	}
	if ($parentcategoryid)
	{
		$x = 'ladders.php' . $parentcategoryurl;
		$navbits["$x"] = $parentcategorytitle;
	}
	$navbits[''] = $categorytitle;
	$navbits = construct_navbits($navbits);
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('headinclude', $headinclude);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('tlhtml', $tlhtml);
		$templater->register('modname', $modname);
		$templater->register('header', $header);
		$templater->register('footer', $footer);
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################
	
?>