<?php
/*======================================================================*\
|| #################################################################### ||
|| # Copyright  BananaLive Scripts. All Rights Reserved. ############# ||
|| #################################################################### ||
\*======================================================================*/

error_reporting(E_ALL & ~E_NOTICE);
define('THIS_SCRIPT', 'ladders');

if ($_REQUEST['do'] && in_array($_REQUEST['do'], array('pmcmpt', 'add', 'new', 'edit', 'editrules')))
{
define('GET_EDIT_TEMPLATES', true);
}


if ($_REQUEST['do'] && in_array($_REQUEST['do'], array('pmcmpt', 'add', 'edit', 'editrules')))
{
define('GET_EDIT_TEMPLATES', true);
}
$phrasegroups = array('posting', 'postbit', 'user', 'timezone', 'global', 'pm', 'reputationlevel', 'search', 'calendar');
$specialtemplates = array(
	'bbcodecache',
	'smiliecache',
	'tll_catcache',
);
$globaltemplates = array(
	'tmnt_shell'
);
$actiontemplates = array(
	'admin_swap' => array(
		'tmnt_ladder_swap'
	),
	'admin' => array(
		'tmnt_ladder_admin'
	),
	'admin_editpt' => array(
		'tmnt_ladder_editpt'
	),
	'add' => array(
		'tmnt_date_time',
		'tmnt_ladder_new'
	),
	'new' => array(
		'tmnt_date_time',
		'tmnt_ladder_new'
	),
	'leaveladder' => array(
		'tmnt_ladder_teamleave'
	),
	'insertchal' => array(
		'tmnt_ladder_chalpm'
	),
	'warlights' => array(
		'tmnt_warlights'
	),
	'matchfinder' => array(
		'tmnt_warlights',
		'tmnt_ladder_mf'
	),
	'pm' => array(
		'tmnt_ladder_threadtemplate2'
	),
	'join' => array(
		'tmnt_ladder_join'
	),
	'editavatar' => array(
		'tmnt_ladder_editavatar'
	),
	'editbadge' => array(
		'tmnt_ladder_editbadge'
	),
	'adminsubmitscore' => array(
		'tmnt_ladder_submitscore'
	),
	'insertchal' => array(
		'tmnt_ladder_chal'
	),
	'insertmatch' => array(
		'tmnt_ladder_insertmatch'
	),
	'swapslots' => array(
		'tmnt_swapslots',
	),
	'player_popup' => array(
		'tmnt_ladder_player_popup'
	),
	'pmcmpt' => array(
		'tmnt_ladder_threadtemplate2',
		'tmnt_newpm'
	),
	'editcolors' => array(
		'tmnt_ladder_editcolors'
	),
	'challenges' => array(
		'tmnt_ladder_chll_top',
		'tmnt_ladder_chll',
		'tmnt_ladder_chll_bot',
		'tmnt_ladder_yourteams'
	),
	'rearrange_match' => array(
		'tmnt_date_time',
		'tmnt_ladder_rearrange'
	),
	'enable_warlight' => array(
		'tmnt_enablelivematch_chooseteam'
	),
	'allchallenges' => array(
		'tmnt_ladder_all_chll_top',
		'tmnt_ladder_chll',
		'tmnt_ladder_chll_bot'
	),
	'reportedmatches' => array(
		'tmnt_ladder_repmatch'
	),
	'acceptmf' => array(
		'tmnt_ladder_mfpm'
	),
	'submitscore' => array(
		'tmnt_ladder_submitscore'
	),
	'create_player_image' => array(
		'tmnt_ladder_cpi'
	),
	'adminsubmitscores' => array(
		'tmnt_ladder_adminsubmitscores'
	),
	'elorating' => array(
		'tmnt_ladder_elorating'
	),
	'editrules' => array(
		'tmnt_ladder_editrules'
	),
	'edit' => array(
		'tmnt_ladder_edit',
		'tmnt_date_time'
	),
	'addplayer' => array(
		'tmnt_ladder_newplayer'
	),
	'startleague' => array(
		'tmnt_organise_league'
	),
	'editsquad' => array(
		'tmnt_ladder_editsquad'
	),
	'viewmatch' => array(
		'tmnt_ladder_viewmatch'
	),
	'search_matches' => array(
		'tmnt_ladder_searchmatches'
	)
);

require_once('./global.php');
require_once(DIR . '/includes/functions.php');
require_once(DIR . '/includes/functions_tal.php');

($hook = vBulletinHook::fetch_hook('tll_ladders_start')) ? eval($hook) : false;

$navbits = construct_navbits(array(
	'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
	'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase[ladders],
	'' => construct_phrase('Error')
));
$navbar = render_navbar_template($navbits);

// #############################################################################

if (!$_REQUEST['do'] && !$_POST['do'])
{
	exit;
}

// #############################################################################

if ($_POST['do'] == 'updaterules')
{
	if (!$tmntp['caneditladder'])
	{
		print_no_permission();
	}
	$id = $vbulletin->input->clean_gpc('p', 'id', TYPE_UINT);
	if (!$id)
	{
		$errormessage = $vbphrase[error_invalid_ladder];
		eval(standard_error($errormessage));
	}
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id = '$id' ");
	$vbulletin->input->clean_array_gpc('p', array(
		'message'      => TYPE_STR,
		'wysiwyg'			 => TYPE_BOOL,
	));
	if ($vbulletin->GPC['wysiwyg'] && $vbulletin->options['simpleversion'] < 414)
	{
		require_once(DIR . '/includes/functions_wysiwyg.php');
		$rules = convert_wysiwyg_html_to_bbcode($vbulletin->GPC['message'], 1);
	}
	else if ($vbulletin->GPC['wysiwyg'])
	{
		require_once(DIR . '/includes/class_wysiwygparser.php');
		$html_parser = new vB_WysiwygHtmlParser($vbulletin);
		$rules = $html_parser->parse_wysiwyg_html_to_bbcode($vbulletin->GPC['message']);
	}
	else
	{
		$rules = $vbulletin->GPC['message'];
	}
	$description = explode('[rules]',$ladder['description']);
	$description = $description['0'].'[rules]'.$rules;
	
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "tmnt_ladders
		SET
			description = '".$vbulletin->db->escape_string($description)."'
		WHERE id = '$id'
	");
	$vbulletin->url = "ladders.php?do=view&id=$id&sh=6";	
	eval(print_standard_redirect('redirect_updatedladder'));
}

// #############################################################################

if ($_POST['do'] == 'admin_swap')
{
	if (!$tmntp['ladder_superuser'])
	{
		print_no_permission();
	}
	$lid = $vbulletin->input->clean_gpc('p', 'lid', TYPE_UINT);
	$pid = $vbulletin->input->clean_gpc('p', 'pid', TYPE_UINT);
	$ladder = $vbulletin->db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_ladders
		WHERE id = '$lid'
	");
	if (!$ladder)
	{
		print_no_permission();
	}
	$player = $vbulletin->db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_ladder_players
		WHERE lid = '$lid' AND id = '$pid'
	");
	if (!$player)
	{
		print_no_permission();
	}
	if ($ladder['pot'])
	{
		$teamid = $vbulletin->input->clean_gpc('p', 'teamid', TYPE_UINT);
		$user = $vbulletin->db->query_first("
			SELECT teamid AS userid, teamname AS username
			FROM " . TABLE_PREFIX . "tmnt_teams
			WHERE teamid = '".$vbulletin->db->escape_string($teamid)."'
		");
		if (!$user)
		{
			$errormessage = 'Error, that team does not exist.';
			eval(standard_error($errormessage));
		}
	}
	else
	{
		$username = $vbulletin->input->clean_gpc('p', 'username', TYPE_STR);
		$user = $vbulletin->db->query_first("
			SELECT userid, username
			FROM " . TABLE_PREFIX . "user
			WHERE username = '".$vbulletin->db->escape_string($username)."'
		");
		if (!$user)
		{
			$errormessage = 'Error, no user exists with username: '.$username.'.';
			eval(standard_error($errormessage));
		}
	}
	$countplayer = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid='$lid' AND userid='".$user['userid']."' ");
	$countplayer = $countplayer['countrows'];  
	if ($countplayer != 0)
	{
		$errormessage = 'Error, player already in ladder.';
		eval(standard_error($errormessage));
	}
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
		SET userid = '".$user['userid']."', username = '".$vbulletin->db->escape_string($user['username'])."'
		WHERE lid = '$lid' AND id = '$pid'
	");
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "tmnt_ladder_games
		SET u = '".$user['userid']."'
		WHERE lid = '$lid' AND u = '".$player['userid']."' 
	");
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "tmnt_ladder_games
		SET u2 = '".$user['userid']."'
		WHERE lid = '$lid' AND u2 = '".$player['userid']."' 
	");
	$vbulletin->url = "ladders.php?do=view&id=".$lid;	
	eval(print_standard_redirect('redirect_updateladder'));
}

// #############################################################################

if ($_POST['do'] == 'insertplayer')
{
	if (!$tmntp['caneditladder'])
	{
		print_no_permission();
	}
	$lid = $id = $vbulletin->input->clean_gpc('p', 'id', TYPE_UINT);
	if (!$id)
	{
		$errormessage = $vbphrase['error_invalid_ladder'];
		eval(standard_error($errormessage));
	}
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id='$id' ");
	$ladderid = $vbulletin->input->clean_gpc('p', 'ladderid', TYPE_UINT);
	$teamid = $vbulletin->input->clean_gpc('p', 'teamid', TYPE_UINT);
	$group = $vbulletin->input->clean_gpc('p', 'group', TYPE_UINT);
	if (!$ladder['pot'])
	{
		if ($ladderid)
		{
			$usernames = array();
			$cmpts_query = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid = '".$ladderid."' ");
			while ($cmpt = $vbulletin->db->fetch_array($cmpts_query))
			{
				$usernames[] = $cmpt['username'];
			}
		}
		else
		{
			$usernames = $vbulletin->input->clean_gpc('p', 'username', TYPE_STR);
			if (!$usernames)
			{
				$errormessage = $vbphrase['error_no_username'];
				eval(standard_error($errormessage));
			}
			$usernames = explode(';',$usernames);
		}
		foreach ($usernames AS $hash => $username)
		{
			$username = trim($username);
			$user = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "user WHERE username = '".$vbulletin->db->escape_string($username)."' ");
			if (!$user['userid'])
			{
				continue;
			}
			else
			{
				$userid = $user['userid'];
			}
			$checkuserid = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "user WHERE userid='$userid' ");
			$checkuserid = $checkuserid['countrows'];  
			if ($checkuserid != 1)
			{
				continue;
			}
			$player = $vbulletin->db->query_first("
				SELECT *
				FROM " . TABLE_PREFIX . "tmnt_ladder_players
				WHERE lid='$id'
					AND (userid='$userid' OR username='".$vbulletin->db->escape_string($username)."') 
			");
			if ($player && $player['active'])
			{
				continue;
			}
			if ($player)
			{
				$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_players SET active = '1', latime = '".TIMENOW."' WHERE lid = '$id' AND (userid = '$userid' OR username = '".$vbulletin->db->escape_string($username)."') AND active = '0'");
				$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladders SET noplayers = noplayers + 1 WHERE id = '$id'");
				$userinfo = fetch_userinfo($userid);
				$tmnt_ladders = array_merge((array)$userinfo['tmnt_ladders'], (array)$id);
				$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET tmnt_ladders = '" . implode(',' , $tmnt_ladders) . "' WHERE userid = '$userid'");
				continue;
			}
			
			if ($ladder['join_cost'] > 0 && $vbulletin->options['tmnt_credit_system'])
			{
	require_once(DIR . '/includes/functions_tll_prem.php');		
				if (!tll_check_credits($user, $ladder['join_cost'], 1))
				{
					continue;
				}
				else
				{

					process_credits_transaction($user['userid'], -$ladder['join_cost'], 'Joined ladder');
					update_forum_creditprofit(vbdate('W',TIMENOW), vbdate('Y',TIMENOW), $ladder['join_cost'], TIMENOW);
				}
			}
			$vbulletin->db->query_write("
				INSERT INTO " . TABLE_PREFIX . "tmnt_ladder_players
					(userid, username, lid, time, ip, pot, rank, " . TABLE_PREFIX . "tmnt_ladder_players.group, latime)
				VALUES (
					'".$vbulletin->db->escape_string($userid)."',
					'".$vbulletin->db->escape_string($username)."',
					'".$vbulletin->db->escape_string($id)."', 
					".TIMENOW.", 
					'".$vbulletin->db->escape_string($thisip)."', 
					'".$vbulletin->db->escape_string($ladder['pot'])."',
					'".$vbulletin->db->escape_string($ladder['startingelo'])."',
					'".$vbulletin->db->escape_string($group)."',
					'".TIMENOW."'
				)
			");
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladders SET noplayers = noplayers + 1 WHERE id=$id");
			if ($ladder['league']==2)
			{
				break;
			}
		}
	}
	else
	{//teams
		$team = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_teams WHERE teamid = '".$vbulletin->db->escape_string($teamid)."' ");
		if (!$team)
		{
			$errormessage = $vbphrase['error_invalid_team'];
			eval(standard_error($errormessage));
		}
		$player = $vbulletin->db->query_first("
			SELECT *
			FROM " . TABLE_PREFIX . "tmnt_ladder_players
			WHERE lid='$id'
				AND userid='$teamid'
		");
		if ($player && $player['active'])
		{
			$errormessage = 'Error, this team has already joined this ladder/league.';
			eval(standard_error($errormessage));
		}
		if ($player)
		{
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_players SET active = '1' WHERE lid = '$id' AND userid = '$teamid' AND active = '0'");
		}
		else
		{
			$vbulletin->db->query_write("
				INSERT INTO " . TABLE_PREFIX . "tmnt_ladder_players
					(userid, username, lid, time, ip, pot, rank, " . TABLE_PREFIX . "tmnt_ladder_players.group)
				VALUES (
					'".$vbulletin->db->escape_string($teamid)."',
					'".$vbulletin->db->escape_string($team['teamname'])."',
					'".$vbulletin->db->escape_string($id)."', 
					".TIMENOW.", 
					'".$vbulletin->db->escape_string($thisip)."', 
					'".$vbulletin->db->escape_string($ladder['pot'])."',
					'".$vbulletin->db->escape_string($ladder['startingelo'])."',
					'".$vbulletin->db->escape_string($group)."'
				)
			");
			if ($team && $ladder['comp_ugid'])
			{
				$members = $vbulletin->db->query_read("
					SELECT m.*, u.username
					FROM " . TABLE_PREFIX . "tmnt_members AS m
					LEFT JOIN " . TABLE_PREFIX . "user AS u
						ON (u.userid = m.userid)
					WHERE m.teamid = '$teamid'
						AND m.accepted = 1
				");
				while($m = $vbulletin->db->fetch_array($members))
				{
					$userinfo = fetch_userinfo($m['userid']);
					$user = $userinfo;
					$newmembergroupid = $ladder['comp_ugid'];
					$user['membergroupids']=explode(',',$user['membergroupids']);
					if (!in_array($newmembergroupid, $user['membergroupids']))
					{
						$user['membergroupids'][]=$newmembergroupid;
					}
					else
					{
						continue;
					}
					//$display_usergroup = $newmembergroupid;
					$user['membergroupids']=implode(',',$user['membergroupids']);
					$userdata =& datamanager_init('User', $vbulletin, ERRTYPE_STANDARD);
					$userdata->set_existing($userinfo);
					$userdata->set('membergroupids', $user['membergroupids']);
					/*$userdata->set_usertitle(
							$userinfo['usertitle'],
							true,
							$vbulletin->usergroupcache["$newmembergroupid"],
							false,
							true
					);*/
					$userdata->save();
				}
			}
		}
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladders SET noplayers = noplayers + 1 WHERE id=$id");
		$userid = $teamid;
	}
	if ($ladder['league'] == 2 && $group > 0)
	{//insert league games
		$count = 0;
		$c_array = $r_array = $r_userids = $userids = array();
		$cmpts = $vbulletin->db->query_read("
			SELECT players.*, IF (players.pot=0, 'u.username', '')
			FROM " . TABLE_PREFIX . "tmnt_ladder_players AS players
			LEFT JOIN " . TABLE_PREFIX . "user AS u
				ON (u.userid = players.userid)
			WHERE lid = '$lid'
				AND active = 1
				AND players.group = '$group'
				AND players.userid != '$userid'
			ORDER BY rand()
		");
		while ($cmpt = $vbulletin->db->fetch_array($cmpts))
		{
			$count++;
			$c_array[] = $cmpt;
			$userids[] = $cmpt['userid'];
		}
		$games = $vbulletin->db->query_read("
			SELECT *
			FROM " . TABLE_PREFIX . "tmnt_ladder_games AS g
			WHERE lid = '$lid'
				AND g.group = '$group'
			ORDER BY g.round ASC
		");
		while($game = $vbulletin->db->fetch_array($games))
		{
			$g_array[] = $game;
			$r_array["$game[round]"][] = $game;
			$r_userids["$game[round]"][] = $game['u'];
			$r_userids["$game[round]"][] = $game['u2'];
		}
		//what about home/away games???
		/*if ($count%2)
		{//odd
			//find empty
			$rounds = $count;
			for ($r = 1; $r <= $rounds; $r++)
			{
				foreach ($userids AS $u)
				{
					if (in_array($u,$r_userids["$r"]))
					{
						continue;
					}
					if (!$ladder['homeaway'])
					{
						if ($r%2)
						{
							$xxx .= "\r\n"."($userid, $u, $lid, ".TIMENOW.", $ladder[pot], 0, 0, $group, $r, 1, 0), ";
						}
						else
						{
							$xxx .= "\r\n"."($u, $userid, $lid, ".TIMENOW.", $ladder[pot], 0, 0, $group, $r, 1, 0), ";
						}
					
					}
					else
					{
						print_r("Not supported yet...");
						exit;
					}
					
					//break;
				}
			}
			//print_r($xxx);
		}
		else
		{*///even
			//rearrange completely...
			//print_r($count);
			//print_r($userids);
			//print_r($g_array);
		if (!$ladder['racemode'])
		{
			$r_hold = $count;
			$ingroup = $count+1;
			$database = fetch_rr_database($ingroup);
			//print_r($database);
			$ids = array_merge($userids, array($userid));
			//print_r($ids);
			foreach ($database AS $r => $rvalue)
			{
				$r = substr($r, 1);
				$s = '';
				//$xxx = '';
				//$xxx2 = '';
				//array('02v01','03v08','04v07','05v06')
				foreach ($rvalue AS $nh => $ndata)
				{
					list($pla, $plb) = explode('v', $ndata);
					//print_r("$pla, $plb\r\n\r\n\r\n\r\n\r\n\r\n");
					$pla = (int)$pla - 1;
					$plb = (int)$plb - 1;
					//print_r("$ids[$pla] $ids[$plb]       \ ");
					if ($ids[$pla] > 0 && $ids[$plb] > 0)
					{
						$u = $ids[$pla];
						$u2 = $ids[$plb];
						$querycheck = '';
						if (!$ladder['homeaway'])
						{
							$querycheck = $vbulletin->db->query_first("
								SELECT * 
								FROM " . TABLE_PREFIX . "tmnt_ladder_games AS g
								WHERE lid = '$lid'
									AND g.group = '$group'
									AND ((u = '$u' AND u2 = '$u2') OR (u = '$u2' AND u2 = '$u'))
							");
							if (!$querycheck)
							{
								$xxx .= "\r\n"."($ids[$pla], $ids[$plb], $lid, ".TIMENOW.", $ladder[pot], 0, 0, $group, $r, 1, 0), ";
							}
							else if ($querycheck['round'] != $r)
							{
								$vbulletin->db->query_write("
									UPDATE " . TABLE_PREFIX . "tmnt_ladder_games AS g 
									SET g.round = '$r' 
									WHERE id = '".$querycheck[id]."'
								");
							}
						}
						else
						{
							$querycheck = $vbulletin->db->query_first("
								SELECT * 
								FROM " . TABLE_PREFIX . "tmnt_ladder_games AS g
								WHERE lid = '$lid'
									AND g.group = '$group'
									AND (u = '$u' AND u2 = '$u2')
							");
							if (!$querycheck)
							{
								$xxx .= "\r\n"."($ids[$pla], $ids[$plb], $lid, ".TIMENOW.", $ladder[pot], 0, 0, $group, $r, 1, 0), ";
							}
							else if ($querycheck['round'] != $r)
							{
								$vbulletin->db->query_write("
									UPDATE " . TABLE_PREFIX . "tmnt_ladder_games AS g 
									SET g.round = '$r' 
									WHERE id = '".$querycheck[id]."'
								");
							}
							$s = $r_hold + $r;
							$querycheck = $vbulletin->db->query_first("
								SELECT * 
								FROM " . TABLE_PREFIX . "tmnt_ladder_games AS g
								WHERE lid = '$lid'
									AND g.group = '$group'
									AND (u = '$u2' AND u2 = '$u')
							");
							if (!$querycheck)
							{
								$xxx .= "\r\n"."($ids[$plb], $ids[$pla], $lid, ".TIMENOW.", $ladder[pot], 0, 0, $group, $s, 1, 0), ";
							}
							else if ($querycheck['round'] != $s)
							{
								$vbulletin->db->query_write("
									UPDATE " . TABLE_PREFIX . "tmnt_ladder_games AS g 
									SET g.round = '$s' 
									WHERE id = '".$querycheck[id]."'
								");
							}
						}
					}
				}
			}
		}
		/*}*/
	}
	if ($xxx)
	{//insert challenges
		$xxx = "INSERT INTO " . TABLE_PREFIX . "tmnt_ladder_games (`u`, `u2`, `lid`, `time`, `pot`, `dateline`, `mf`, `group`, `round`, `accepted`, `bestof`) VALUES  " . substr($xxx, 0, -2) . " ";
		$vbulletin->db->query_write("$xxx");
	}
	$ladder['url'] = tll_seo('ladder', $ladder['id'], $ladder['title']);
	$vbulletin->url = 'ladders.php'.$ladder['url'];
	eval(print_standard_redirect('redirect_insertplayer'));
}

// #############################################################################

if ($_POST['do'] == 'admininsertscores')
{
	if (!$tmntp['caneditladder'])
	{
		print_no_permission();
	}
	$vbulletin->input->clean_array_gpc('p', array(
		'u'             => TYPE_ARRAY_UINT,
		'u2'            => TYPE_ARRAY_UINT,
		'lid'           => TYPE_UINT,
		'pot'           => TYPE_BOOL,
		'id'            => TYPE_ARRAY_UINT,
		'orig_score_u'  => TYPE_ARRAY_UINT,
		'orig_score_u2' => TYPE_ARRAY_UINT,
		'score_u'       => TYPE_ARRAY_UINT,
		'score_u2'      => TYPE_ARRAY_UINT,
		'agree_u'       => TYPE_ARRAY_UINT,
		'agree_u2'      => TYPE_ARRAY_UINT,
		'from'          => TYPE_NOHTML
	));
	$lid = $vbulletin->GPC['lid'];
	$pot = $vbulletin->GPC['pot'];
	$userid = $thisuserid;
	foreach ($vbulletin->GPC['id'] AS $ha => $id)
	{
		$u = $vbulletin->GPC['u']["$ha"];
		$u2 = $vbulletin->GPC['u2']["$ha"];
		$score_u = $vbulletin->GPC['score_u']["$ha"];
		$score_u2 = $vbulletin->GPC['score_u2']["$ha"];
		$agree_u = $vbulletin->GPC['agree_u']["$ha"];
		$agree_u2 = $vbulletin->GPC['agree_u2']["$ha"];
		$countgames = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE id=$id AND finished=0 AND accepted=1");
		if ($countgames['countrows'] != 1) 
		{
			continue;
		}
		$games = $vbulletin->db->query_first("
			SELECT games.*, ladders.*
			FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
			LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders
				ON(games.lid=ladders.id)
			WHERE games.id = '$id'
		");
		$team = false;
		if ($games['pot'])
		{
			$team = true;
		}
		list($newrank_u, $newrank_u2, $uod_u, $uod_u2, $player_u, $player_u2) = calc_elo($rank_u, $rank_u2, $score_u, $score_u2, $player_u, $player_u2, $lid, $u, $u2);
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET agree_u = 1, agree_u2 = 1, score_u = $score_u, score_u2 = $score_u2, finished = 1, dateline_finished = ".TIMENOW." WHERE id=$id ");
		if ($score_u > $score_u2) 
		{
			$player_u['wstreak']++;
			if ($player_u['wstreak'] >= $player_u['longeststreak']) $player_u['longeststreak'] = $player_u['wstreak'];
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
				SET wins = wins + 1, wstreak = wstreak + 1, lstreak = 0, latime =".TIMENOW.", rank = $newrank_u, uod = $uod_u, totalpoints = totalpoints + $score_u, pointsagainst = pointsagainst + $score_u2, longeststreak = $player_u[longeststreak], xp = xp + " . $games['xp_win'] . "
				WHERE lid = $lid AND userid = $u
			");
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
				SET loses = loses + 1, wstreak = 0, lstreak = lstreak + 1, latime =".TIMENOW.", rank = $newrank_u2, uod = $uod_u2, totalpoints = totalpoints + $score_u2, pointsagainst = pointsagainst + $score_u, xp = xp + " . $games['xp_lose'] . "
				WHERE lid = $lid AND userid = $u2
			");
			if (!$team && $vbulletin->options['tmnt_credit_system'] && $games['win_credits'] > 0)
			{
require_once(DIR . '/includes/functions_tll_prem.php');		
				process_credits_transaction($u, $games['win_credits'], 'Won challenge against user', $u2, $u);
			}
			elseif ($team && $vbulletin->options['tmnt_credit_system'] && $games['win_credits'] > 0)
			{
require_once(DIR . '/includes/functions_tll_prem.php');		
				process_credits_transaction($u, $games['win_credits'], 'Won challenge against team', $u2, $u, $u, 1);
			}
		}
		elseif ($score_u == $score_u2) 
		{
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
				SET draws = draws + 1, wstreak = 0, lstreak = 0, latime =".TIMENOW.", rank = $newrank_u, uod = $uod_u, totalpoints = totalpoints + $score_u, pointsagainst = pointsagainst + $score_u2, longeststreak = $player_u[longeststreak], xp = xp + " . $games['xp_draw'] . "
				WHERE lid = $lid AND userid = $u
			");
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
				SET draws = draws + 1, wstreak = 0, lstreak = 0, latime =".TIMENOW.", rank = $newrank_u2, uod = $uod_u2, totalpoints = totalpoints + $score_u2, pointsagainst = pointsagainst + $score_u, xp = xp + " . $games['xp_draw'] . "
				WHERE lid = $lid AND userid = $u2
			");
			if (!$team && $vbulletin->options['tmnt_credit_system'] && $games['win_credits'] > 0)
			{
require_once(DIR . '/includes/functions_tll_prem.php');
				$games['win_credits'] = $games['win_credits'] / 2;
				process_credits_transaction($u, $games['win_credits'], 'Drew challenge against user', $u2, $u);
				process_credits_transaction($u2, $games['win_credits'], 'Drew challenge against user', $u, $u2);
			}
			elseif ($team && $vbulletin->options['tmnt_credit_system'] && $games['win_credits'] > 0)
			{
require_once(DIR . '/includes/functions_tll_prem.php');
				$games['win_credits'] = $games['win_credits'] / 2;
				process_credits_transaction($u, $games['win_credits'], 'Drew challenge against team', $u2, $u, $u, 1);
				process_credits_transaction($u2, $games['win_credits'], 'Drew challenge against team', $u, $u2, $u2, 1);
			}
		}
		elseif ($score_u < $score_u2)
		{
			$player_u2['wstreak']++;
			if ($player_u2['wstreak'] >= $player_u2['longeststreak']) $player_u2['longeststreak'] = $player_u2['wstreak'];
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
				SET loses = loses + 1, wstreak = 0, lstreak = lstreak + 1, latime =".TIMENOW.", rank = $newrank_u, uod = $uod_u, totalpoints = totalpoints + $score_u, pointsagainst = pointsagainst + $score_u2, xp = xp + " . $games['xp_lose'] . "
				WHERE lid = $lid AND userid = $u
			");
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
				SET wins = wins + 1, wstreak = wstreak + 1, lstreak = 0, latime =".TIMENOW.", rank = $newrank_u2, uod = $uod_u2, totalpoints = totalpoints + $score_u2, pointsagainst = pointsagainst + $score_u, longeststreak = $player_u2[longeststreak], xp = xp + " . $games['xp_win'] . "
				WHERE lid = $lid AND userid = $u2
			");
			if (!$team && $vbulletin->options['tmnt_credit_system'] && $games['win_credits'] > 0)
			{
require_once(DIR . '/includes/functions_tll_prem.php');		
				process_credits_transaction($u2, $games['win_credits'], 'Won challenge against user', $u, $u2);
			}
			elseif ($team && $vbulletin->options['tmnt_credit_system'] && $games['win_credits'] > 0)
			{
require_once(DIR . '/includes/functions_tll_prem.php');		
				process_credits_transaction($u2, $games['win_credits'], 'Won challenge against team', $u, $u2, $u2, 1);
			}
		} 
		else 
		{
			$errormessage = $vbphrase[error_fatal_error];
			eval(standard_error($errormessage));
		}
	}
	if ($vbulletin->GPC['from'] == 'ladder')
	{
		$vbulletin->url = "ladders.php?do=view&id=$lid&sh=2";
	}
	else
	{
		$vbulletin->url = "ladders.php?do=reportedmatches";
	}
	eval(print_standard_redirect('redirect_updatedscore'));
	
}

// #############################################################################

if ($_POST['do'] == 'admininsertscore')
{
	if (!$tmntp['caneditladder'])
	{
		print_r('<!--no admin permissions-->');
		print_no_permission();
	}
	$vbulletin->input->clean_array_gpc('p', array(
		'u'             => TYPE_UINT,
		'u2'            => TYPE_UINT,
		'lid'           => TYPE_UINT,
		'id'            => TYPE_UINT,
		'orig_score_u'  => TYPE_UINT,
		'orig_score_u2' => TYPE_UINT,
		'score_u'       => TYPE_UINT,
		'score_u2'      => TYPE_UINT,
		'agree_u'       => TYPE_UINT,
		'agree_u2'      => TYPE_UINT,
		'from'          => TYPE_NOHTML,
		'squadscore'    => TYPE_ARRAY_UINT,
		'yellowcard'    => TYPE_ARRAY_UINT,
		'redcard'    => TYPE_ARRAY_UINT,
		'cleansheet'    => TYPE_ARRAY_UINT,
		'assists'    => TYPE_ARRAY_UINT,
		'screen'        => TYPE_NOHTML,
	));
	$id            = $vbulletin->GPC['id'];
	$u             = $vbulletin->GPC['u'];
	$u2            = $vbulletin->GPC['u2'];
	$userid        = $thisuserid;
	$score_u       = $vbulletin->GPC['score_u'];
	$score_u2      = $vbulletin->GPC['score_u2'];
	$lid           = $vbulletin->GPC['lid'];
	$player_u = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid = '$lid' AND userid = '$u' ");
	$player_u2 = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid = '$lid' AND userid = '$u2' ");
	$countgames = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE id = '$id' AND finished = '0' AND accepted = '1' ");
	if ($countgames['countrows'] != 1)
	{
		$errormessage = "Error, game does not exist.\r\n<br> ID: $id\r\n<br> Rows returned: ". $countgames['countrows'];
		eval(standard_error($errormessage));
	}
	$games = $vbulletin->db->query_first("
		SELECT games.*, ladders.*
		FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
		LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders
			ON(games.lid=ladders.id)
		WHERE games.id = '$id'
	");
	$team = false;
	if ($games['pot'])
	{
		$team = true;
	}
	$screen = $vbulletin->GPC['screen'];
	$upload = $vbulletin->input->clean_gpc('f', 'upload', TYPE_FILE);
	$uploadDir = 'images/ladder_images/';
	$fileName = $upload['name'];
	$tmpName  = $upload['tmp_name'];
	function img_resize($tmpname, $width, $height, $save_dir, $save_name)
	{
		$save_dir .= ( substr($save_dir,-1) != "/") ? "/" : "";
		$gis       = GetImageSize($tmpname);
		$type       = $gis[2];
		switch($type)
		{
			case "1": $imorig = imagecreatefromgif($tmpname); break;
			case "2": $imorig = imagecreatefromjpeg($tmpname);break;
			case "3": $imorig = imagecreatefrompng($tmpname); break;
			default:  $imorig = imagecreatefromjpeg($tmpname);
		}
        $x = imageSX($imorig);
        $y = imageSY($imorig);
		$c = $x;
		$d = $y;
		if (($d > $height) OR ($c > $width))
		{
			$a = $d/$height;
			$b = $c/$width;
			if ($a > $b)
			{
				$r  = $d/$height;
				$d = $d/$r;
				$c  = $c/$r;
			}
			else
			{
				$r  = $c/$width;
				$d = $d/$r;
				$c  = $c/$r;
			}
		}
        $im = imagecreate($c, $d);
        $im = imagecreatetruecolor($c,$d);
		if (imagecopyresampled($im,$imorig,0,0,0,0,$c,$d,$x,$y))
		{
			if (imagejpeg($im, $save_dir.$save_name))
			{
				return true;
			}
			else
			{
				return false;
			}
		}
    }
	if ($tmpName != '')
	{
		if ($teamlogo['error'])
		{
			$errormessage = $vbphrase['error_uploading_team_logo'].$teamlogo['error'];
			eval(standard_error($errormessage));
		}
		else
		{
			$randName = md5(rand() * time());
			$ext      = substr(strrchr($fileName, "."), 1);
			$imgexts  = array('jpg', 'jpeg', 'png', 'gif');
			if (in_array(strtolower($ext), $imgexts)) 
			{
				@img_resize($tmpName, 800, 600, $uploadDir, $randName.".jpg");
				$filePath = $uploadDir.$randName.".jpg";
				if (file_exists($filePath))
				{
					$screen = ($screen ? "$screen;" : "").$vbulletin->options['bburl']."/".$filePath;
				}
			}
			
		}
	}
	if ($games['pot'])
	{
		$team = true;
		$pot = 1;
		$teamids = array();
		/*$teams = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "tmnt_members JOIN " . TABLE_PREFIX . "tmnt_teams on " . TABLE_PREFIX . "tmnt_members.teamid = " . TABLE_PREFIX . "tmnt_teams.teamid WHERE " . TABLE_PREFIX . "tmnt_members.leader=1 AND " . TABLE_PREFIX . "tmnt_members.userid=$userid");
		while($teamm = $vbulletin->db->fetch_array($teams))
		{
			$teamid = $teamm['teamid'];
			$teamids = array_merge((array)$teamid, $teamids);
		}
		$eteamids = $teamids;
		$teamids = implode(",", $teamids);
		if (!in_array($u, $eteamids) AND !in_array($u2, $eteamids))
		{
			print_no_permission();
		}*/
		if (file_exists(DIR . '/tll_modules/tll_squadscores.php'))
		{
			if ($vbulletin->GPC['assists'])
			{
				foreach ($vbulletin->GPC['assists'] AS $key => $value)
				{
					list($a, $b) = explode('_',$key);
					$assists["$a"]["$b"] = $value;
				}
			}
			$assists = serialize($assists);
			$scores_hold = array();
			$vbulletin->GPC['squadscore'];
			if ($vbulletin->GPC['squadscore'])
			{
				foreach ($vbulletin->GPC['squadscore'] AS $key => $value)
				{
					list($a, $b) = explode('_',$key);
					
					if ($a == 'u')
					{
						$add_score_u += $value;
					}
					elseif ($a == 'u2')
					{
						$add_score_u2 += $value;
					}
					else
					{
						continue;
					}
					$scores_hold["$a"]["$b"] = $value;
				}
			}
			if ($add_score_u > 0 && $add_score_u != $score_u)
			{
				$uinfo = fetch_teaminfo($u);
				$errormessage = "You have submitted team scores for ".$uinfo[teamname]." adding up to $add_score_u which does not match their score ($score_u). <br /><br /> Please press back and rectify this error.";
				eval(standard_error($errormessage));
			}
			if ($add_score_u2 > 0 && $add_score_u2 != $score_u2)
			{
				$u2info = fetch_teaminfo($u2);
				$errormessage = "You have submitted team scores for ".$u2info[teamname]." adding up to $add_score_u2 which does not match their score ($score_u2). <br /><br /> Please press back and rectify this error.";
				eval(standard_error($errormessage));
			}
			if ($add_score_u == 0 && $add_score_u2 == 0)
			{
				$squad_scores = '';
			}
			else
			{
				$squad_scores = array();
				if ($add_score_u == $score_u)
				{
					$squad_scores['u'] = $scores_hold['u'];
				}
				if ($add_score_u2 == $score_u2)
				{
					$squad_scores['u2'] = $scores_hold['u2'];
				}
				$squad_scores = serialize($squad_scores);
			}
		}
		if ($vbulletin->GPC['yellowcard'])
		{
			foreach ($vbulletin->GPC['yellowcard'] AS $key => $value)
			{
				list($a, $b) = explode('_',$key);
				$yellow_cards["$a"][] = $b;
			}
		}
		$yellow_cards = serialize($yellow_cards);
		if ($vbulletin->GPC['redcard'])
		{
			foreach ($vbulletin->GPC['redcard'] AS $key => $value)
			{
				list($a, $b) = explode('_',$key);
				$red_cards["$a"][] = $b;
			}
		}
		$red_cards = serialize($red_cards);
		if ($vbulletin->GPC['cleansheet'])
		{
			foreach ($vbulletin->GPC['cleansheet'] AS $key => $value)
			{
				list($a, $b) = explode('_',$key);
				switch ($a)
				{
					case 'u':
						$ao = 'score_u2';
					break;
					case 'u2':
						$ao = 'score_u';
					break;
				}
				if ($$ao > 0)
				{
					continue;
				}
				$cleansheets["$a"][] = $b;
			}
		}
		$cleansheets = serialize($cleansheets);
	}
	//$games = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id = $lid");
	list($newrank_u, $newrank_u2, $uod_u, $uod_u2, $player_u, $player_u2) = calc_elo($rank_u, $rank_u2, $score_u, $score_u2, $player_u, $player_u2, $lid, $u, $u2);
	$altered_rank = abs($newrank_u - $player_u['rank']);
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET agree_u = 1, agree_u2 = 1, score_u = $score_u, score_u2 = $score_u2, finished = 1, dateline_finished = ".TIMENOW.", screen_u = '".$vbulletin->db->escape_string($screen)."', screen_u2 = '".$vbulletin->db->escape_string($screen)."', squad_scores = '".$vbulletin->db->escape_string($squad_scores)."', assists = '".$vbulletin->db->escape_string($assists)."', cleansheets = '".$vbulletin->db->escape_string($cleansheets)."', yellow_cards = '".$vbulletin->db->escape_string($yellow_cards)."', red_cards = '".$vbulletin->db->escape_string($red_cards)."', altered_rank = '$altered_rank' WHERE id=$id ");
		if ($score_u > $score_u2) 
		{
			$player_u['wstreak']++;
			if ($player_u['wstreak'] >= $player_u['longeststreak']) $player_u['longeststreak'] = $player_u['wstreak'];
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
				SET wins = wins + 1, wstreak = wstreak + 1, lstreak = 0, latime =".TIMENOW.", rank = $newrank_u, uod = $uod_u, totalpoints = totalpoints + $score_u, pointsagainst = pointsagainst + $score_u2, longeststreak = $player_u[longeststreak], xp = xp + " . $games['xp_win'] . ", crown = '".$player_u2['crown']."'
				WHERE lid = $lid AND userid = $u
			");
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
				SET loses = loses + 1, wstreak = 0, lstreak = lstreak + 1, latime =".TIMENOW.", rank = $newrank_u2, uod = $uod_u2, totalpoints = totalpoints + $score_u2, pointsagainst = pointsagainst + $score_u, xp = xp + " . $games['xp_lose'] . ", crown = 0
				WHERE lid = $lid AND userid = $u2
			");
			if (!$team && $vbulletin->options['tmnt_credit_system'] && $games['win_credits'] > 0)
			{
require_once(DIR . '/includes/functions_tll_prem.php');		
				process_credits_transaction($u, $games['win_credits'], 'Won challenge against user', $u2, $u);
			}
			elseif ($team && $vbulletin->options['tmnt_credit_system'] && $games['win_credits'] > 0)
			{
require_once(DIR . '/includes/functions_tll_prem.php');		
				process_credits_transaction($u, $games['win_credits'], 'Won challenge against team', $u2, $u, $u, 1);
			}
		}
		elseif ($score_u == $score_u2) 
		{
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
				SET draws = draws + 1, wstreak = 0, lstreak = 0, latime =".TIMENOW.", rank = $newrank_u, uod = $uod_u, totalpoints = totalpoints + $score_u, pointsagainst = pointsagainst + $score_u2, longeststreak = $player_u[longeststreak], xp = xp + " . $games['xp_draw'] . "
				WHERE lid = $lid AND userid = $u
			");
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
				SET draws = draws + 1, wstreak = 0, lstreak = 0, latime =".TIMENOW.", rank = $newrank_u2, uod = $uod_u2, totalpoints = totalpoints + $score_u2, pointsagainst = pointsagainst + $score_u, xp = xp + " . $games['xp_draw'] . "
				WHERE lid = $lid AND userid = $u2
			");
			if (!$team && $vbulletin->options['tmnt_credit_system'] && $games['win_credits'] > 0)
			{
require_once(DIR . '/includes/functions_tll_prem.php');
				$games['win_credits'] = $games['win_credits'] / 2;
				process_credits_transaction($u, $games['win_credits'], 'Drew challenge against user', $u2, $u);
				process_credits_transaction($u2, $games['win_credits'], 'Drew challenge against user', $u, $u2);
			}
			elseif ($team && $vbulletin->options['tmnt_credit_system'] && $games['win_credits'] > 0)
			{
require_once(DIR . '/includes/functions_tll_prem.php');
				$games['win_credits'] = $games['win_credits'] / 2;
				process_credits_transaction($u, $games['win_credits'], 'Drew challenge against team', $u2, $u, $u, 1);
				process_credits_transaction($u2, $games['win_credits'], 'Drew challenge against team', $u, $u2, $u2, 1);
			}
		}
		elseif ($score_u < $score_u2)
		{
			$player_u2['wstreak']++;
			if ($player_u2['wstreak'] >= $player_u2['longeststreak']) $player_u2['longeststreak'] = $player_u2['wstreak'];
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
				SET loses = loses + 1, wstreak = 0, lstreak = lstreak + 1, latime =".TIMENOW.", rank = $newrank_u, uod = $uod_u, totalpoints = totalpoints + $score_u, pointsagainst = pointsagainst + $score_u2, xp = xp + " . $games['xp_lose'] . ", crown = 0
				WHERE lid = $lid AND userid = $u
			");
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
				SET wins = wins + 1, wstreak = wstreak + 1, lstreak = 0, latime =".TIMENOW.", rank = $newrank_u2, uod = $uod_u2, totalpoints = totalpoints + $score_u2, pointsagainst = pointsagainst + $score_u, longeststreak = $player_u2[longeststreak], xp = xp + " . $games['xp_win'] . ", crown = '".$player_u['crown']."'
				WHERE lid = $lid AND userid = $u2
			");
			if (!$team && $vbulletin->options['tmnt_credit_system'] && $games['win_credits'] > 0)
			{
require_once(DIR . '/includes/functions_tll_prem.php');		
				process_credits_transaction($u2, $games['win_credits'], 'Won challenge against user', $u, $u2);
			}
			elseif ($team && $vbulletin->options['tmnt_credit_system'] && $games['win_credits'] > 0)
			{
require_once(DIR . '/includes/functions_tll_prem.php');		
				process_credits_transaction($u2, $games['win_credits'], 'Won challenge against team', $u, $u2, $u2, 1);
			}
		} 
		else 
		{
			$errormessage = $vbphrase[error_fatal_error];
			eval(standard_error($errormessage));
		}
	if ($squad_scores || $assists || $cleansheets)
	{
		$squad_scores = unserialize($squad_scores);
		$assists = unserialize($assists);
		$cleansheets = unserialize($cleansheets);
		if ($squad_scores['u'])
		{
			foreach ($squad_scores['u'] AS $sa => $sb)
			{
				$p = $vbulletin->db->query_first("
					SELECT c.*
					FROM " . TABLE_PREFIX . "tmnt_cstats AS c
					WHERE userid = '".$sa."' 
						AND teamid = '".$u."'
						AND lid = '".$vbulletin->db->escape_string($lid)."'
				");
				if ($p)
				{
					$vbulletin->db->query_write("
						UPDATE " . TABLE_PREFIX . "tmnt_cstats 
						SET goals = goals + ".$vbulletin->db->escape_string($sb)."
						WHERE userid = '".$sa."' 
							AND teamid = '".$u."'
							AND lid = '".$vbulletin->db->escape_string($lid)."'
					");
				}
				else
				{
					$vbulletin->db->query_write("
						INSERT INTO " . TABLE_PREFIX . "tmnt_cstats
							(userid, teamid, goals, lid)
						VALUES (
							'".$vbulletin->db->escape_string($sa)."',
							'".$vbulletin->db->escape_string($u)."',
							'".$vbulletin->db->escape_string($sb)."',
							'".$vbulletin->db->escape_string($lid)."'
						)
					");
				}
			}
		}
		if ($squad_scores['u2'])
		{
			foreach ($squad_scores['u2'] AS $sa => $sb)
			{
				$p = $vbulletin->db->query_first("
					SELECT c.*
					FROM " . TABLE_PREFIX . "tmnt_cstats AS c
					WHERE userid = '".$sa."' 
						AND teamid = '".$u2."'
						AND lid = '".$vbulletin->db->escape_string($lid)."'
				");
				if ($p)
				{
					$vbulletin->db->query_write("
						UPDATE " . TABLE_PREFIX . "tmnt_cstats 
						SET goals = goals + ".$vbulletin->db->escape_string($sb)."
						WHERE userid = '".$sa."' 
							AND teamid = '".$u2."'
							AND lid = '".$vbulletin->db->escape_string($lid)."'
					");
				}
				else
				{
					$vbulletin->db->query_write("
						INSERT INTO " . TABLE_PREFIX . "tmnt_cstats
							(userid, teamid, goals, lid)
						VALUES (
							'".$vbulletin->db->escape_string($sa)."',
							'".$vbulletin->db->escape_string($u2)."',
							'".$vbulletin->db->escape_string($sb)."',
							'".$vbulletin->db->escape_string($lid)."'
						)
					");
				}
			}
		}
		if ($assists['u'])
		{
			foreach ($assists['u'] AS $sa => $sb)
			{
				$p = $vbulletin->db->query_first("
					SELECT c.*
					FROM " . TABLE_PREFIX . "tmnt_cstats AS c
					WHERE userid = '".$sa."' 
						AND teamid = '".$u."'
						AND lid = '".$vbulletin->db->escape_string($lid)."'
				");
				if ($p)
				{
					$vbulletin->db->query_write("
						UPDATE " . TABLE_PREFIX . "tmnt_cstats 
						SET assists = assists + ".$vbulletin->db->escape_string($sb)."
						WHERE userid = '".$sa."' 
							AND teamid = '".$u."'
							AND lid = '".$vbulletin->db->escape_string($lid)."'
					");
				}
				else
				{
					$vbulletin->db->query_write("
						INSERT INTO " . TABLE_PREFIX . "tmnt_cstats
							(userid, teamid, assists, lid)
						VALUES (
							'".$vbulletin->db->escape_string($sa)."',
							'".$vbulletin->db->escape_string($u)."',
							'".$vbulletin->db->escape_string($sb)."',
							'".$vbulletin->db->escape_string($lid)."'
						)
					");
				}
			}
		}
		if ($assists['u2'])
		{
			foreach ($assists['u2'] AS $sa => $sb)
			{
				$p = $vbulletin->db->query_first("
					SELECT c.*
					FROM " . TABLE_PREFIX . "tmnt_cstats AS c
					WHERE userid = '".$sa."' 
						AND teamid = '".$u2."'
						AND lid = '".$vbulletin->db->escape_string($lid)."'
				");
				if ($p)
				{
					$vbulletin->db->query_write("
						UPDATE " . TABLE_PREFIX . "tmnt_cstats 
						SET assists = assists + ".$vbulletin->db->escape_string($sb)."
						WHERE userid = '".$sa."' 
							AND teamid = '".$u2."'
							AND lid = '".$vbulletin->db->escape_string($lid)."'
					");
				}
				else
				{
					$vbulletin->db->query_write("
						INSERT INTO " . TABLE_PREFIX . "tmnt_cstats
							(userid, teamid, assists, lid)
						VALUES (
							'".$vbulletin->db->escape_string($sa)."',
							'".$vbulletin->db->escape_string($u2)."',
							'".$vbulletin->db->escape_string($sb)."',
							'".$vbulletin->db->escape_string($lid)."'
						)
					");
				}
			}
		}
		if ($cleansheets['u'])
		{
			foreach ($cleansheets['u'] AS $sa => $sb)
			{
				$p = $vbulletin->db->query_first("
					SELECT c.*
					FROM " . TABLE_PREFIX . "tmnt_cstats AS c
					WHERE userid = '".$sb."' 
						AND teamid = '".$u."'
						AND lid = '".$vbulletin->db->escape_string($lid)."'
				");
				if ($p)
				{
					$vbulletin->db->query_write("
						UPDATE " . TABLE_PREFIX . "tmnt_cstats 
						SET cleansheets = cleansheets + 1
						WHERE userid = '".$sb."' 
							AND teamid = '".$u."'
							AND lid = '".$vbulletin->db->escape_string($lid)."'
					");
				}
				else
				{
					$vbulletin->db->query_write("
						INSERT INTO " . TABLE_PREFIX . "tmnt_cstats
							(userid, teamid, cleansheets, lid)
						VALUES (
							'".$vbulletin->db->escape_string($sb)."',
							'".$vbulletin->db->escape_string($u)."',
							'1',
							'".$vbulletin->db->escape_string($lid)."'
						)
					");
				}
			}
		}
		if ($cleansheets['u2'])
		{
			foreach ($cleansheets['u2'] AS $sa => $sb)
			{
				$p = $vbulletin->db->query_first("
					SELECT c.*
					FROM " . TABLE_PREFIX . "tmnt_cstats AS c
					WHERE userid = '".$sb."' 
						AND teamid = '".$u2."'
						AND lid = '".$vbulletin->db->escape_string($lid)."'
				");
				if ($p)
				{
					$vbulletin->db->query_write("
						UPDATE " . TABLE_PREFIX . "tmnt_cstats 
						SET cleansheets = cleansheets + 1
						WHERE userid = '".$sb."' 
							AND teamid = '".$u2."'
							AND lid = '".$vbulletin->db->escape_string($lid)."'
					");
				}
				else
				{
					$vbulletin->db->query_write("
						INSERT INTO " . TABLE_PREFIX . "tmnt_cstats
							(userid, teamid, cleansheets, lid)
						VALUES (
							'".$vbulletin->db->escape_string($sb)."',
							'".$vbulletin->db->escape_string($u2)."',
							'1',
							'".$vbulletin->db->escape_string($lid)."'
						)
					");
				}
			}
		}
	}
	$comment = $vbulletin->input->clean_gpc('p', 'comment', TYPE_NOHTML);
	if ($comment)
	{
		$vbulletin->db->query_write("
			INSERT INTO " . TABLE_PREFIX . "tmnt_ladder_mcs
				(mid, comment, userid, username, dateline, dispute)
			VALUES ('".$id."', '".$vbulletin->db->escape_string($comment)."', '".$thisuserid."',  '".$vbulletin->db->escape_string($thisusername)."', ".TIMENOW.",  '0')
		");
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET comments = comments + 1 WHERE id = $id");
	}
	if ($vbulletin->GPC['from'] == 'ladder')
	{
		$vbulletin->url = "ladders.php?do=view&id=$lid&sh=2";
	}
	else
	{
		$vbulletin->url = "ladders.php?do=reportedmatches";
	}
	eval(print_standard_redirect('redirect_updatedscore'));
}

// #############################################################################

if ($_POST['do'] == 'admin_updatept')
{
	if (!$tmntp['ladder_superuser'])
	{
		print_no_permission();
	}
	$vbulletin->input->clean_array_gpc('p', array(
		'lid' => TYPE_UINT,
		'pid' => TYPE_UINT,
		'rank' => TYPE_UINT,
		'wins' => TYPE_UINT,
		'draws' => TYPE_UINT,
		'loses' => TYPE_UINT,
		'streak' => TYPE_INT,
		'xp' => TYPE_UINT,
		'challenges' => TYPE_UINT,
		'totalpoints' => TYPE_UINT,
		'pointsagainst' => TYPE_UINT,
		'longeststreak' => TYPE_UINT,
		'crown' => TYPE_BOOL,
		'active' => TYPE_BOOL
	));
	if ($vbulletin->GPC['pid'] && $vbulletin->GPC['lid'])
	{
		$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders");
		$player = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid = '".$vbulletin->GPC['lid']."'");
		if (!$player || !$ladder)
		{
			print_no_permission();
		}
		if ($vbulletin->GPC['streak'] > 0)
		{
			$vbulletin->GPC['lstreak'] = 0;
			$vbulletin->GPC['wstreak'] = $vbulletin->GPC['streak'];
		}
		else
		{
			$vbulletin->GPC['lstreak'] = 0-$vbulletin->GPC['streak'];
			$vbulletin->GPC['wstreak'] = 0;
		}
		$vbulletin->db->query_write("
			UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
			SET
				rank = '".$vbulletin->db->escape_string($vbulletin->GPC['rank'])."',
				wins = '".$vbulletin->db->escape_string($vbulletin->GPC['wins'])."',
				draws = '".$vbulletin->db->escape_string($vbulletin->GPC['draws'])."',
				loses = '".$vbulletin->db->escape_string($vbulletin->GPC['loses'])."',
				wstreak = '".$vbulletin->db->escape_string($vbulletin->GPC['wstreak'])."',
				lstreak = '".$vbulletin->db->escape_string($vbulletin->GPC['lstreak'])."',
				xp = '".$vbulletin->db->escape_string($vbulletin->GPC['xp'])."',
				challenges = '".$vbulletin->db->escape_string($vbulletin->GPC['challenges'])."',
				totalpoints = '".$vbulletin->db->escape_string($vbulletin->GPC['totalpoints'])."',
				pointsagainst = '".$vbulletin->db->escape_string($vbulletin->GPC['pointsagainst'])."',
				longeststreak = '".$vbulletin->db->escape_string($vbulletin->GPC['longeststreak'])."',
				crown = '".$vbulletin->db->escape_string($vbulletin->GPC['crown'])."',
				active = '".$vbulletin->db->escape_string($vbulletin->GPC['active'])."'
			WHERE lid='".$vbulletin->GPC['lid']."'
				AND id='".$vbulletin->GPC['pid']."'
		");
		$vbulletin->url = "ladders_admin.php?do=admin_editpt&lid=".$vbulletin->GPC['lid']."&pid=".$vbulletin->GPC['pid']."";	
		eval(print_standard_redirect('redirect_updatedladderpt', true, true));
	}
	else
	{
		$_REQUEST['do'] = 'admin_editpt';
	}
}

// #############################################################################

if ($_POST['do'] == 'insertmatch')
{
	if (!$tmntp['caneditladder'])
	{
		print_no_permission();
	}
	$lid = $vbulletin->input->clean_gpc('p', 'id', TYPE_UINT);
		if (!$lid) {
			$errormessage = $vbphrase[error_invalid_ladder];
			eval(standard_error($errormessage));
		}
	$pot = $vbulletin->input->clean_gpc('p', 'pot', TYPE_UINT);
	$u = $vbulletin->input->clean_gpc('p', 'u', TYPE_UINT);
		if (!$u) {
			$errormessage = $vbphrase[error_invalid_challenger];
			eval(standard_error($errormessage));
		}
	$u2 = $vbulletin->input->clean_gpc('p', 'u2', TYPE_UINT);
		if (!$u2)
		{
			$errormessage = $vbphrase[error_invalid_challenged];
			eval(standard_error($errormessage));
		}
	if ($u == $u2)
	{
		$errormessage = $vbphrase[error_invalid_challenger];
		eval(standard_error($errormessage));
	}
	$bestof = $vbulletin->input->clean_gpc('p', 'bestof', TYPE_UINT);
	$squadsize = $vbulletin->input->clean_gpc('p', 'squadsize', TYPE_UINT);
	$map = $vbulletin->input->clean_gpc('p', 'map', TYPE_NOHTML);
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id=$lid ");
	$co_array = unserialize($ladder['chal_options']);
	$chal_options = array();
	if (is_array($co_array))
	{
		foreach ($co_array AS $key => $value)
		{
			$key = str_replace(' ','_',$key);
			$key = preg_replace("/[^a-zA-Z0-9_\s]/", "", unhtmlspecialchars($key));
			$chal_options["$key"] = $vbulletin->input->clean_gpc('p', "$key", TYPE_NOHTML);
		}
		$chal_options = serialize($chal_options);
	}
	if ($ladder['archive'] == '1')
	{
		$errormessage = $vbphrase[error_ladder_closed];
		eval(standard_error($errormessage));
	}
	$countchal = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE lid=$lid AND ((u=$u AND u2=$u2) OR (u=$u2 AND u2=$u)) AND finished=0 ");
	$countchal = $countchal['countrows'];  
	if ($countchal != 0 && !$ladder['league'])
	{
		$errormessage = $vbphrase[error_already_challenged];
		eval(standard_error($errormessage));
	}
	$countu = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid=$lid AND userid=$u ");
	$countu = $countu['countrows'];  
	if ($countu != 1) {
		$errormessage = $vbphrase[error_invalid_challenger];
		eval(standard_error($errormessage));
	}
	$countu2 = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid=$lid AND userid=$u2 ");
	$countu2 = $countu2['countrows'];  
	if ($countu2 != 1)
	{
		$errormessage = $vbphrase[error_invalid_challenged];
		eval(standard_error($errormessage));
	}
	/* challenge time/date */
	$vbulletin->input->clean_array_gpc('p', array(
		'timezoneoffset' => TYPE_ARRAY_NUM,
		'dst'            => TYPE_ARRAY_UINT,
		'date'       => TYPE_ARRAY_ARRAY,
		'time'       => TYPE_ARRAY_NOHTML
	));
	$type = 'range';
	$time = $vbulletin->GPC['time']["$type"];
	$date = $vbulletin->input->clean($vbulletin->GPC['date']["$type"], TYPE_ARRAY_UINT);
	$utc = $timezoneoffset = $vbulletin->GPC['timezoneoffset']["$type"];
	$dst = $vbulletin->GPC['dst']["$type"] = 1;
	require_once(DIR . '/includes/functions_misc.php');
	if (!fetch_timezone($timezoneoffset))
	{
		$errormessage = "Error: invalid timezone specified";
		eval(standard_error($errormessage));
	}
	if (!checkdate($date['month'], $date['day'], $date['year']))
	{
		$errormessage = "Error: Bad Date";
		eval(standard_error($errormessage));
	}
	$time_re = '#^(0?[1-9]|1[012])\s*[:.]\s*([0-5]\d)(\s*[AP]M)?|([01]\d|2[0-3])\s*[:.]\s*([0-5]\d)$#i';

	// match text in field for a valid time
	if (preg_match($time_re, $time, $matches))
	{
		if (count($matches) == 3)
		{
			$hour = intval($matches[1]);
			$minute = intval($matches[2]);
			$ampm = $matches[1] == '12' ? 'PM' : 'AM';
		}
		else if (count($matches) == 4)
		{
			$hour = intval($matches[1]);
			$minute = intval($matches[2]);
			$ampm = strtoupper(trim($matches[3]));
		}
		else // 24hr time
		{
			$hour = intval($matches[4]);
			$minute = intval($matches[5]);
			$ampm = ($hour <= 11) ? 'AM' : 'PM';
		}
	}
	if (($pos = strpos($vbulletin->options['timeformat'], 'H')) === false)
	{
		if ($ampm == 'PM')
		{
			if ($hour >= 1 AND $hour <= 11)
			{
				$hour += 12;
			}
		}
		else
		{
			if ($hour == 12)
			{
				$hour = 0;
			}
		}
	}
	$min_offset = $utc - intval($utc);
	$hour   -= intval($utc);
	$minute -= intval($min_offset * 60);
	$dateline = gmmktime($hour, $minute, 0, $date['month'], $date['day'], $date['year']);
	if ($_POST['now'])
	{
		$dateline = TIMENOW;
	}
	/* end challenge time/date */
	if (!$ladder['pot'] && $ladder['chal_cost'] > 0 && $vbulletin->options['tmnt_credit_system'])
	{
		$ladder['win_credits'] = (1-$vbulletin->options['tmnt_credits_comm'])*2*$ladder['chal_cost'];
		$credits_profit = 2 * $ladder['chal_cost'] - $ladder['win_credits'];
		$query_u = $vbulletin->db->query_first("SELECT userid,username,tmnt_credits FROM " . TABLE_PREFIX . "user WHERE userid=$u ");
		if ($query_u['tmnt_credits'] < $ladder['chal_cost'])
		{
			$errormessage = 'Error, '.$query_u['username'].' has insufficient credits. This challenge costs '.$ladder['chal_cost'].' credits, but '.$query_u['username'].' only has '.$query_u['tmnt_credits'].' credits.';
			eval(standard_error($errormessage));
		}
		$query_u2 = $vbulletin->db->query_first("SELECT userid,username,tmnt_credits FROM " . TABLE_PREFIX . "user WHERE userid=$u2 ");
		if ($query_u2['tmnt_credits'] < $ladder['chal_cost'])
		{
			$errormessage = 'Error, '.$query_u2['username'].' has insufficient credits. This challenge costs '.$ladder['chal_cost'].' credits, but '.$query_u2['username'].' only has '.$query_u2['tmnt_credits'].' credits.';
			eval(standard_error($errormessage));
		}
require_once(DIR . '/includes/functions_tll_prem.php');		
		process_credits_transaction($u, -$ladder['chal_cost'], 'Challenged another user', $u, $u2);
		process_credits_transaction($u2, -$ladder['chal_cost'], 'Challenged another user', $u2, $u);
		update_forum_creditprofit(vbdate('W',TIMENOW), vbdate('Y',TIMENOW), $credits_profit, TIMENOW);
	}
	elseif($ladder['pot'] && $ladder['chal_cost'] > 0 && $vbulletin->options['tmnt_credit_system'])
	{
		$ladder['win_credits'] = (1-$vbulletin->options['tmnt_credits_comm'])*2*$ladder['chal_cost'];
		$credits_profit = 2 * $ladder['chal_cost'] - $ladder['win_credits'];
		$query_u = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_teams WHERE teamid=$u ");
		if ($query_u['tmnt_credits'] < $ladder['chal_cost'])
		{
			$errormessage = 'Error, '.$query_u['teamname'].' has insufficient credits. This challenge costs '.$ladder['chal_cost'].' credits, but '.$query_u['teamname'].' only has '.$query_u['tmnt_credits'].' credits.';
			eval(standard_error($errormessage));
		}
		$query_u2 = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_teams WHERE teamid=$u2 ");
		if ($query_u2['tmnt_credits'] < $ladder['chal_cost'])
		{
			$errormessage = 'Error, '.$query_u2['teamname'].' has insufficient credits. This challenge costs '.$ladder['chal_cost'].' credits, but '.$query_u2['username'].' only has '.$query_u2['tmnt_credits'].' credits.';
			eval(standard_error($errormessage));
		}
require_once(DIR . '/includes/functions_tll_prem.php');		
		process_credits_transaction($u, -$ladder['chal_cost'], 'Challenged another team', $u, $u2, $u2, 1);
		process_credits_transaction($u2, -$ladder['chal_cost'], 'Challenged another team', $u2, $u, $u, 1);
		update_forum_creditprofit(vbdate('W',TIMENOW), vbdate('Y',TIMENOW), $credits_profit, TIMENOW);
	}
	$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "tmnt_ladder_games
		(u, u2, lid, time, pot, accepted, bestof, matchdate, map, u1message, u2message, chal_options, dateline, chal_cost, win_credits, squadsize)
		VALUES (
			'".$vbulletin->db->escape_string($u)."',
			'".$vbulletin->db->escape_string($u2)."',
			'".$vbulletin->db->escape_string($lid)."',
			".TIMENOW.",
			'".$vbulletin->db->escape_string($pot)."',
			'1',
			'".$vbulletin->db->escape_string($bestof)."',
			'".$vbulletin->db->escape_string($matchdate)."',
			'".$vbulletin->db->escape_string($map)."',
			'".$vbulletin->db->escape_string($u1message)."',
			'".$vbulletin->db->escape_string($u2message)."',
			'".$vbulletin->db->escape_string($chal_options)."',
			'".$vbulletin->db->escape_string($dateline)."',
			'".$vbulletin->db->escape_string($ladder['chal_cost'])."',
			'".$vbulletin->db->escape_string($ladder['win_credits'])."',
			'".$vbulletin->db->escape_string($squadsize)."'
		)
	");
	$vbulletin->url = "ladders.php?do=view&id=$lid&sh=2";
	eval(print_standard_redirect('redirect_insertchalladder'));
}


// #############################################################################

if ($_REQUEST['do'] == 'startleague')
{
	$lid = $vbulletin->input->clean_gpc('g', 'lid', TYPE_UINT);
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id = '$lid' AND league = 1");
	if (!$ladder)
	{
		print_no_permission();
	}
	if (!$tmntp['caneditladder'] && $ladder['cr_userid'] != $vbulletin->userinfo['userid'])
	{
		print_no_permission();
	}
	$groups = $ladder['groups'];
	//print_r($groups);
	if ($pergroup > $tmnt_maxrr)
	{//check groups aren't too big
		$errormessage = "Maximum of $tmnt_maxrr per group; Increase number of groups.";
		eval(standard_error($errormessage));
	}
	
		if ($ladder['groupid'])
		{
			$basedonladder = $vbulletin->db->query_first("SELECT id, title FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id != '$lid' AND league = 2 AND groupid = '$ladder[groupid]' AND noplayers > 0 ORDER BY id DESC");
		}
		if ($_POST['do'] == 'startleague')
		{//post data
			$count = 0;
			$group_count = array();
			$xuser = array();
			$cmpts = $vbulletin->db->query_read("
				SELECT players.*, IF (players.pot=0, 'u.username', '')
				FROM " . TABLE_PREFIX . "tmnt_ladder_players AS players
				LEFT JOIN " . TABLE_PREFIX . "user AS u
					ON (u.userid = players.userid)
				WHERE lid = '$lid' AND active = 1
				ORDER BY rand()
			");
			while ($cmpt = $vbulletin->db->fetch_array($cmpts))
			{
				$count++;
				$cmpt['group'] = $vbulletin->input->clean_gpc('p', 'userid_'.$cmpt['userid'], TYPE_UINT);
				if ($cmpt['group'])
				{
					$group_count["$cmpt[group]"]++;
				}
				$c_array[] = $cmpt;
				$xuser["$cmpt[userid]"] = $cmpt;
				$g_array["$cmpt[group]"][] = $cmpt['userid'];
			}
		}
		elseif (!$ladder['groupid'] OR !$basedonladder)
		{ //new league - place players randomly into groups
			$count = 0;
			$xuser = array();
			$cmpts = $vbulletin->db->query_read("
				SELECT players.*, IF (players.pot=0, 'u.username', '')
				FROM " . TABLE_PREFIX . "tmnt_ladder_players AS players
				LEFT JOIN " . TABLE_PREFIX . "user AS u
					ON (u.userid = players.userid)
				WHERE lid = '$lid' AND active = 1
				ORDER BY rand()
			");
			while ($cmpt = $vbulletin->db->fetch_array($cmpts))
			{
				$count++;
				$c_array[] = $cmpt;
				$xuser["$cmpt[userid]"] = $cmpt;
			}
			//print_r($count);
			//print_r($groups);
			$pergroup = ceil($count / $groups);
			if ($count == 0)
			{
				$errormessage = 'This league has no competitors yet.';
				eval(standard_error($errormessage));
			}
			//split into X groups as per $ladder
			$g_array = array();
			$this_group = 0;
			//print_r($count);
			//Print_r($pergroup);
			for ($i = 0; $i < $count; $i++)
			{
				$this_user = $c_array[$i]['username'];
				/*if (($i % $pergroup) OR ($i % ($pergroup-1)))
				{
				}
				else
				{
					$this_group++;
				}*/
				$this_group++;
				if ($this_group > $groups)
				{
					$this_group = 1;
				}
				$g_array["$this_group"][] = $c_array[$i]['userid'];
			}
		}
		else
		{//based on last league		
			$lastcmpts = $vbulletin->db->query_read("
				SELECT players.*
				FROM " . TABLE_PREFIX . "tmnt_ladder_players AS players
				WHERE players.lid = '".$basedonladder['id']."' AND active = 1
			");
			while ($lastcmpt = $vbulletin->db->fetch_array($lastcmpts))
			{
				$last_c_array["$lastcmpt[userid]"] = $lastcmpt;
				$last_group["$lastcmpt[group]"][] = $lastcmpt['userid'];
			}
			$last_greatestround = count($last_group);
			foreach($last_group AS $thisgroup => $userids_array)
			{
				$this_count = count($userids_array);
				if ($thisgroup != 1)
				{//set first two as higher group
					$last_c_array["$userids_array[0]"]['group']--;
					if ($vbulletin->options['tmnt_league_pd'] > 1)
					{
						$last_c_array["$userids_array[1]"]['group']--;
					}
					if ($vbulletin->options['tmnt_league_pd'] > 2)
					{
						$last_c_array["$userids_array[2]"]['group']--;
					}
					if ($vbulletin->options['tmnt_league_pd'] > 3)
					{
						$last_c_array["$userids_array[3]"]['group']--;
					}
				}
				if ($last_greatestround != $thisgroup)
				{//set last two as lower group
					$j = $this_count - 1;
					$k = $this_count - 2;
					$l = $this_count - 3;
					$m = $this_count - 4;
					$last_c_array["$userids_array[$j]"]['group']++;
					if ($vbulletin->options['tmnt_league_pd'] > 1)
					{
						$last_c_array["$userids_array[$k]"]['group']++;
					}
					if ($vbulletin->options['tmnt_league_pd'] > 2)
					{
						$last_c_array["$userids_array[$l]"]['group']++;
					}
					if ($vbulletin->options['tmnt_league_pd'] > 3)
					{
						$last_c_array["$userids_array[$m]"]['group']++;
					}
				}
			}
			$count = 0;
			$group_count = array();
			$xuser = array();
			$cmpts = $vbulletin->db->query_read("
				SELECT players.*, IF (players.pot=0, 'u.username', '')
				FROM " . TABLE_PREFIX . "tmnt_ladder_players AS players
				LEFT JOIN " . TABLE_PREFIX . "user AS u
					ON (u.userid = players.userid)
				WHERE lid = '$lid' AND active = 1
				ORDER BY rand()
			");
			while ($cmpt = $vbulletin->db->fetch_array($cmpts))
			{
				$count++;
				//lastrank
				$cmpt['group'] = $last_c_array["$cmpt[userid]"]['group'];
				if ($cmpt['group'])
				{
					$group_count["$cmpt[group]"]++;
				}
				$c_array[] = $cmpt;
				$xuser["$cmpt[userid]"] = $cmpt;
			}
			$pergroup = ceil($count / $groups);
			if ($count == 0)
			{
				$errormessage = 'This league has no competitors yet.';
				eval(standard_error($errormessage));
			}
			$tg = 1;
			$g = 1;
			//print_r("pergroup = $pergroup;");
			$g_array = array();
			foreach ($c_array AS $chash => $cmpt)
			{
				if ($cmpt['group'])
				{
					$g_array["$cmpt[group]"][] = $cmpt['userid'];
					continue;
				}
				while ($group_count["$g"] >= $pergroup)
				{
					$g++;
					if ($g > 8)
					{
						break;
					}
				}
				$cmpt['group'] = $g;
				$group_count["$cmpt[group]"]++;
				$g_array["$cmpt[group]"][] = $cmpt['userid'];
				$c_array["$chash"] = $cmpt;
			}
		}
		if (!$_REQUEST['auto'] && $_POST['do'] != 'startleague')
		{//not automatic display, print out
			//$s = count($g_array);
			$s = $groups;
			$xo = 1;
			while ($xo <= $s)
			{
				$gdd .= '<option value="'.$xo.'">'.construct_phrase($vbphrase['ladder_league_group_x'], $xo).'</option>';
				$xo++;
			}
			//print_r($s);
			function create_dropdown_groups($userid, $groupid)
			{
				global $gdd;
				//
				//alert(this.parentNode.parentNode.id)
				$return = '<select name="userid_'.$userid.'" onchange="tll_icm(this);" id="sel_u_'.$userid.'">'.str_replace('value="'.$groupid.'"','value="'.$groupid.'" selected="selected"',$gdd).'</select>';
				return $return;
			}
			ksort($g_array);
			$aarray = array();
			foreach ($g_array AS $groupid => $ids)
			{
				foreach($ids AS $xnull => $xuserid)
				{
					if (!$xuser["$xuserid"]['username'])
					{//sort out $teams!!!
						$xuser["$xuserid"] = fetch_userinfo($xuserid);
					}
					$aarray[] = array(
						'username' => $xuser["$xuserid"]['username'],
						'dd' => create_dropdown_groups($xuserid, $groupid),
						'userid' => $xuserid,
						'groupid' => $groupid,
						'first' => ($xnull == 0 ? 1 : 0),
						'last' => ($xnull == count($ids) - 1 ? 1 : 0),
					);
				}
			}
			//print_r($aarray);
			//exit;
			/*require("includes/class_tll_sort.php"); 
			$srt = new arr_multisort(); 
				$srt->setArray($aarray); 
				$srt->addColumn("groupid",SRT_ASC);
			$aarray = $srt->sort();*/
			//print_r($aarray);
			$templater = vB_Template::create('tmnt_organise_league');
				$templater->register('tmntp', $tmntp);
				$templater->register('aarray', $aarray);
				$templater->register('ladder', $ladder);
				$templater->register('basedonladder', $basedonladder);
				$templater->register('lstyle', '');
			$tlhtml .= $templater->render();
			$navbits = array(
				'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
				'ladders.php?showonly=leagues' => $vbphrase['ladder_leagues'],
				'ladders.php?do=view&amp;id='.$ladder['id'] => $ladder['title'],
				'' => 'Organise League Groups'
			);
			$navbits = construct_navbits($navbits);
			$navbar = render_navbar_template($navbits);
			$templater = vB_Template::create('tmnt_shell');
				$templater->register_page_templates();
				$templater->register('navbar', $navbar);
				$templater->register('headinclude', $headinclude);
				$templater->register('pagetitle', $pagetitle);
				$templater->register('tlhtml', $tlhtml);
				$templater->register('modname', $modname);
				$templater->register('header', $header);
				$templater->register('footer', $footer);
				$templater->register('tmntp', $tmntp);
				$templater->register('tmnt_version', $tmnt_version);
			print_output($templater->render());
		}
		foreach ($g_array AS $groupid => $ids)
		{
			//implode then update players group
			//print_r("<br>$xxx<br>");
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_players AS players SET players.group = '$groupid' WHERE lid = '$lid' AND ( userid = '" . implode("' OR userid = '", $ids) . "' ) ");
			$ingroup = count($ids);
			$r_hold = $ingroup-1;
			//print_r("ingroup = $ingroup; <br>");
			//print_r($ids);
			//print_r($ingroup);
			if (!$ladder['racemode'])
			{
			$database = fetch_rr_database($ingroup);
			//print_r($database);
			foreach ($database AS $r => $rvalue)
			{
				$r = substr($r, 1);
				$s = '';
				$xxx = '';
				$xxx2 = '';
				//array('02v01','03v08','04v07','05v06')
				foreach ($rvalue AS $nh => $ndata)
				{
					list($pla, $plb) = explode('v', $ndata);
					$pla = (int)$pla - 1;
					$plb = (int)$plb - 1;
					if ($ids[$pla] && $ids[$plb])
					{
						/*
						$vbulletin->db->query_write("
							INSERT INTO " . TABLE_PREFIX . "tmnt_ladder_games
								(u, u2, lid, time, pot, bestof, matchdate, map, u1message, u2message, chal_options, dateline, mf)
							VALUES (
								'".$vbulletin->db->escape_string($u)."',
								'".$vbulletin->db->escape_string($u2)."',
								'".$vbulletin->db->escape_string($lid)."',
								'".TIMENOW."',
								'0',
								'".$vbulletin->db->escape_string($bestof)."',
								'".$vbulletin->db->escape_string($matchdate)."',
								'".$vbulletin->db->escape_string($map)."',
								'".$vbulletin->db->escape_string($u1message)."',
								'".$vbulletin->db->escape_string($u2message)."',
								'".$vbulletin->db->escape_string($chal_options)."',
								'".$vbulletin->db->escape_string($dateline)."',
								'".$vbulletin->db->escape_string($mf)."'
							)
						");*/
						if (!$ladder['homeaway'])
						{
							$xxx .= "\r\n"."($ids[$pla], $ids[$plb], $lid, ".TIMENOW.", $ladder[pot], 0, 0, $groupid, $r, 1, 0), ";
						}
						else
						{
							//$s = $r * 2;
							//player 1 home
							$xxx .= "\r\n"."($ids[$pla], $ids[$plb], $lid, ".TIMENOW.", $ladder[pot], 0, 0, $groupid, $r, 1, 0), ";
							//$s--;
							$s = $ingroup + $r -1;
							//player 2 home
							$xxx2 .= "\r\n"."($ids[$plb], $ids[$pla], $lid, ".TIMENOW.", $ladder[pot], 0, 0, $groupid, $s, 1, 0), ";
						}
					}
				}
				//print_r($xxx2);
				//exit;
				if ($xxx)
				{
					$xxx = "INSERT INTO " . TABLE_PREFIX . "tmnt_ladder_games (`u`, `u2`, `lid`, `time`, `pot`, `dateline`, `mf`, `group`, `round`, `accepted`, `bestof`) VALUES  " . substr($xxx, 0, -2) . " ";
					$vbulletin->db->query_write("$xxx");
				}
				if ($xxx2)
				{
					$xxx2 = "INSERT INTO " . TABLE_PREFIX . "tmnt_ladder_games (`u`, `u2`, `lid`, `time`, `pot`, `dateline`, `mf`, `group`, `round`, `accepted`, `bestof`) VALUES  " . substr($xxx2, 0, -2) . " ";
					$vbulletin->db->query_write("$xxx2");
				}
				//print_r("<br>$xxx<br>");
			}
			}
		}
	
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "tmnt_ladders
		SET
			league = 2
		WHERE id = '$lid' AND league = '1'
	");
	$vbulletin->url = "ladders.php?do=view&id=$lid";	
	eval(print_standard_redirect('redirect_updatedladder'));
}

// #############################################################################

if ($_REQUEST['do'] == 'insertmatch')
{
	if (!$tmntp['caneditladder'])
	{
		print_no_permission();
	}
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	$ajax = $vbulletin->input->clean_gpc('g', 'ajax', TYPE_UINT);
		if (!$id) {
			$errormessage = $vbphrase[error_invalid_ladder];
			eval(standard_error($errormessage));
		}
	$lid = $id;
	$ladder = $ladders = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id='$id'");
	if (!$ladders)
	{
		$errormessage = $vbphrase[error_invalid_ladder];
		eval(standard_error($errormessage));
	}
	$co_array2 = unserialize($ladders['chal_options']);
	if (is_array($co_array2))
	{
		$co_array = array();
		foreach($co_array2 AS $key => $value)
		{
			if (substr($value, -3)=='#@1')
			{
				$value = substr($value, 0, -3);
			}
			$key2 = str_replace(' ','_',$key);
			$key2 = preg_replace("/[^a-zA-Z0-9_\s]/", "", unhtmlspecialchars($key2));//dom101
			if ($value)
			{
				$co_array["$key2"] = 
				array(
					'value' => explode("\r\n",$value),
					'key' => $key
				);
			}
			else
			{
				$co_array["$key2"] = 
				array(
					'value' => $value,
					'key' => $key
				);
			}
		}
	}
	$title = $ladders['title'];
	$team = false;
	if ($ladders['pot'])
	{
		$team = true;
	}
	$cmpts = $vbulletin->db->query_read("SELECT players.*, players.userid AS userid" . (!$team ? ", user.username AS username" : ", user.teamname AS username") . "
		FROM " . TABLE_PREFIX . "tmnt_ladder_players AS players
		" . (!$team ? "LEFT JOIN " . TABLE_PREFIX . "user AS user ON (players.userid = user.userid) " : "LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS user ON (players.userid = user.teamid) ") . "
		WHERE players.lid=$id AND players.active=1 ORDER BY " . (!$team ? "user.username" : "user.teamname") . " ASC");
	while($cmpt = $vbulletin->db->fetch_array($cmpts))
	{
		$competitors .= '<option value="'. $cmpt[userid] .'">'. $cmpt[username] .'</option>';
	}
	$day = vbdate("j", TIMENOW);
	if ($day == 'j')
	{
		$day = date("j", TIMENOW);
	}
	$month = vbdate("n", TIMENOW);
	if ($month == 'n')
	{
		$month = date("n", TIMENOW);
	}
	$year = vbdate("Y", TIMENOW);
	if ($year == 'Y')
	{
		$year = date("Y", TIMENOW);
	}
	$monthselected = array();
	$yearselected = array();
	$monthselected["$month"] = 'selected="selected"';
	$yearselected["$year"] = 'selected="selected"';
	$yearbits = '';
	for ($gyear = 2005; $gyear <= 2015; $gyear++)
	{
		$yearbits .= "\t\t<option value=\"$gyear\" $yearselected[$gyear]>$gyear</option>";
	}
	if (strpos($vbulletin->options['timeformat'], 'H') !== false)
	{
		$show['24hour'] = true;
	}
	else
	{
		$show['24hour'] = false;
	}
	$time = vbdate($vbulletin->options['timeformat'], TIMENOW);
	require_once(DIR . '/includes/functions_misc.php');
	$timezoneoptions = '';
	foreach (fetch_timezone() AS $optionvalue => $timezonephrase)
	{
		$optiontitle = $vbphrase["$timezonephrase"];
		$optionselected = ($optionvalue == $vbulletin->userinfo['timezoneoffset']+$vbulletin->userinfo['dstonoff'] ? 'selected="selected"' : '');
		$timezoneoptions .= render_option_template($optiontitle, $optionvalue, $optionselected, $optionclass);
	}
	$templater = vB_Template::create('tmnt_ladder_insertmatch');
		$templater->register('tmntp', $tmntp);
		$templater->register('ladder', $ladder);
		$templater->register('id', $id);
		$templater->register('lid', $lid);
		$templater->register('competitors', $competitors);
		$templater->register('team', $team);
		$templater->register('title', $title);
		$templater->register('co_array', $co_array);
		$templater->register('time', $time);
		$templater->register('day', $day);
		$templater->register('timezoneoptions', $timezoneoptions);
		$templater->register('monthselected', $monthselected);
		$templater->register('yearbits', $yearbits);
		$templater->register('dstchecked', $dstchecked);
		$templater->register('ajax', $ajax);
	$tlhtml .= $templater->render();
	if ($_REQUEST['ajax']==1)
	{
		$tlhtml = str_replace("onclick=\"window.location.href='ladders.php?do=view&amp;id=$lid'\"",'onclick="close_tll_popup();"',$tlhtml);
		print_r($tlhtml);
		exit;
	}
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladders'],
		'ladders.php?do=view&id='.$lid . $vbulletin->session->vars['sessionurl_q'] => $title,
		'' => construct_phrase($vbphrase['ladder_insertmatch'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'adminsubmitscore')
{
	if (!$tmntp['caneditladder'])
	{
		print_no_permission();
	}
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	$from = $vbulletin->input->clean_gpc('g', 'from', TYPE_NOHTML);
	if (!$id)
	{
		$errormessage = $vbphrase[error_invalid_challenge];
		eval(standard_error($errormessage));
	}/*
	$games = $vbulletin->db->query_first("
		SELECT ladders.pot AS pot, ladders.title
		FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
		LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders 
			ON(games.lid=ladders.id)
		WHERE games.id = '$id'
	");*/
	$games = $game = $vbulletin->db->query_first("
		SELECT g.*, l.title AS laddertitle
		FROM " . TABLE_PREFIX . "tmnt_ladder_games AS g
		LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS l 
			ON (g.lid=l.id)
		WHERE g.id='$id'
			AND g.accepted='1'
	");
	$team = false;
	if ($games['pot'])
	{
		$team = true;
	}
	$userid = $thisuserid;
	if (!$game)
	{
		$errormessage = $vbphrase['error_invalid_challenge'];
		eval(standard_error($errormessage));
	}
	if ($game['pot'])
	{
		$game['uinfo'] = fetch_teaminfo($game['u']);
		$game['u2info'] = fetch_teaminfo($game['u2']);
	}
	else 
	{
		$game['uinfo'] = fetch_userinfo($game['u']);
		$game['u2info'] = fetch_userinfo($game['u2']);
	}
	$ladder = fetch_ladderinfo($game['lid']);
	$game['squad_scores'] = unserialize($game['squad_scores']);
	$game['red_cards'] = unserialize($game['red_cards']);
	$game['yellow_cards'] = unserialize($game['yellow_cards']);
	$squads = array();
	if (file_exists(DIR . '/tll_modules/tll_squadscores.php'))
	{
		require_once('./tll_modules/tll_squadscores.php');
		$squads = fetch_squads($game);
	}
	//$templater = vB_Template::create('tmnt_ladder_adminsubmitscore');
	$templater = vB_Template::create('tmnt_ladder_submitscore');
		$templater->register('tmntp', $tmntp);
		$templater->register('ladder', $ladder);
		$templater->register('from', $from);
		$templater->register('id', $id);
		$templater->register('lid', $lid);
		$templater->register('team', $team);
		$templater->register('games', $games);
		$templater->register('squads', $squads);
		$templater->register('game', $game);
		$templater->register('admin', 1);
		$templater->register('ajax', ($_REQUEST['ajax']?1:0));
	$tlhtml .= $templater->render();
	if ($_REQUEST['ajax']==1)
	{
		$tlhtml = str_replace("history.go(-1);",'close_tll_popup();',$tlhtml);
		print_r($tlhtml);
		exit;
	}
	$navbits = array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladders']
	);
	if ($from == 'ladder')
	{
		$navbits["ladders.php?do=view&amp;id=$game[lid]&amp;sh=2"] = $games['title'];
	}
	else
	{
		$navbits['ladders.php?do=reportedchallenges'] = $vbphrase['ladder_reported_matches'];
	}
	$navbits[''] = construct_phrase($vbphrase['ladder_submittingscore']);
	$navbits = construct_navbits($navbits);
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('headinclude', $headinclude);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('tlhtml', $tlhtml);
		$templater->register('modname', $modname);
		$templater->register('header', $header);
		$templater->register('footer', $footer);
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'adminsubmitscores')
{
	if (!$tmntp['caneditladder'])
	{
		print_no_permission();
	}
	$lid = $vbulletin->input->clean_gpc('g', 'lid', TYPE_UINT);
	$from = $vbulletin->input->clean_gpc('g', 'from', TYPE_NOHTML);
	$round = $vbulletin->input->clean_gpc('g', 'round', TYPE_UINT);
	if ($round > 0)
	{
		$where_cond .= " AND games.round = '$round' ";
	}
	$group = $vbulletin->input->clean_gpc('g', 'group', TYPE_UINT);
	if ($group > 0)
	{
		$where_cond .= " AND games.group = '$group' ";
	}
	if (!$lid)
	{
		$errormessage = $vbphrase[error_invalid_challenge];
		eval(standard_error($errormessage));
	}
	//, uu.username AS u2_username
	$games = $vbulletin->db->query_read("
		SELECT games.*, ladder.pot AS pot, ladder.title, IF (ladder.pot = 0, u.username, t.teamname) AS u_username, IF (ladder.pot = 0, uu.username, tt.teamname) AS u2_username
		FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
		LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladder
			ON (games.lid = ladder.id)
		LEFT JOIN " . TABLE_PREFIX . "user AS u
			ON (games.u = u.userid)
		LEFT JOIN " . TABLE_PREFIX . "user AS uu
			ON (games.u2 = uu.userid)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS t
			ON (games.u = t.teamid)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS tt
			ON (games.u2 = tt.teamid)
		WHERE games.lid = '$lid' $where_cond
	");
	while($game = $vbulletin->db->fetch_array($games))
	{
		$game['uinfo'] = array('userid'=>$game['u'],'username'=>$game['u_username']);
		$game['u2info'] = array('userid'=>$game['u2'],'username'=>$game['u2_username']);
		$array[] = $game;
	}
	/*print_r($array);
	exit;
	$team = false;
	if ($games['pot'])
	{
		$team = true;
	}
	$userid = $thisuserid;
	$game = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE id='$id' AND finished='0' AND accepted='1'");
	if (!$game)
	{
		$errormessage = $vbphrase['error_invalid_challenge'];
		eval(standard_error($errormessage));
	}
	if ($game['pot'])
	{
		$game['uinfo'] = fetch_teaminfo($game['u']);
		$game['u2info'] = fetch_teaminfo($game['u2']);
	}
	else 
	{
		$game['uinfo'] = fetch_userinfo($game['u']);
		$game['u2info'] = fetch_userinfo($game['u2']);
	}*/
	$templater = vB_Template::create('tmnt_ladder_adminsubmitscores');
		$templater->register('tmntp', $tmntp);
		$templater->register('ladder', $ladder);
		$templater->register('from', $from);
		$templater->register('id', $id);
		$templater->register('lid', $lid);
		$templater->register('team', $team);
		$templater->register('games', $games);
		$templater->register('game', $game);
		$templater->register('array', $array);
	$tlhtml .= $templater->render();
	$navbits = array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladders']
	);
	if ($from == 'ladder')
	{
		$navbits["ladders.php?do=view&amp;id=$game[lid]&amp;sh=2"] = $games['title'];
	}
	else
	{
		$navbits['ladders.php?do=reportedchallenges'] = $vbphrase['ladder_reported_matches'];
	}
	$navbits[''] = construct_phrase($vbphrase['ladder_submittingscores']);
	$navbits = construct_navbits($navbits);
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('headinclude', $headinclude);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('tlhtml', $tlhtml);
		$templater->register('modname', $modname);
		$templater->register('header', $header);
		$templater->register('footer', $footer);
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_POST['do'] == 'updatecolors')
{
	if (!$tmntp['caneditladder'])
	{
		print_no_permission();
	}
	$vbulletin->input->clean_array_gpc('p', array(
		'lid' => TYPE_UINT,
		'id' => TYPE_ARRAY_UINT,
		'from' => TYPE_ARRAY_UINT,
		'to' => TYPE_ARRAY_UINT,
		'color' => TYPE_ARRAY_NOHTML,
		'delete' => TYPE_ARRAY_BOOL,
	));
	$lid = $vbulletin->GPC['lid'];
	if (!$lid)
	{
		$errormessage = $vbphrase[error_invalid_ladder];
		eval(standard_error($errormessage));
	}
	$ladders = $ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id='$lid'");
	if (!$ladder)
	{
		$errormessage = $vbphrase[error_invalid_ladder];
		eval(standard_error($errormessage));
	}
	foreach ($vbulletin->GPC['id'] AS $hash => $id)
	{
		$from = $vbulletin->GPC['from']["$hash"];
		$to = $vbulletin->GPC['to']["$hash"];
		$color = $vbulletin->GPC['color']["$hash"];
		$delete = $vbulletin->GPC['delete']["$hash"];
		if ($delete)
		{
			$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "tmnt_leaguecolors WHERE `lid` = '$lid' AND `id` = '$id' ");
		}
		elseif ($id)
		{
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_leaguecolors
				SET `from` = '$from',
					`to` = '$to',
					`color` = '".$vbulletin->db->escape_string($color)."'
				WHERE lid = '$lid' AND id = '$id'
			");
		}
		elseif ($color)
		{
			$vbulletin->db->query_write("
				INSERT INTO " . TABLE_PREFIX . "tmnt_leaguecolors
					(lid, " . TABLE_PREFIX . "tmnt_leaguecolors.from, " . TABLE_PREFIX . "tmnt_leaguecolors.to, color)
				VALUES ('".$lid."', '".$from."', '".$to."', '".$vbulletin->db->escape_string($color)."')
			");
		}
	}
	$vbulletin->url = "ladders_admin.php?do=editcolors&lid=$lid";
	eval(print_standard_redirect('redirect_updateladder'));
}

// #############################################################################

if ($_POST['do'] == 'insert')
{
	if (!$tmntp['cancreateladder'])
	{
		print_no_permission();
	}
	$vbulletin->input->clean_array_gpc('p', array(
		'message' => TYPE_STR,
		'title' => TYPE_NOHTML,
		'icon' => TYPE_NOHTML,
		'wysiwyg' => TYPE_BOOL,
		'pot' => TYPE_UINT,
		'catid' => TYPE_UINT,
		'league' => TYPE_BOOL,
		'homeaway' => TYPE_UINT,
		'groups' => TYPE_UINT,
		'groupid' => TYPE_UINT,
		'timezoneoffset' => TYPE_ARRAY_NUM,
		'dst' => TYPE_ARRAY_UINT,
		'fromdate' => TYPE_ARRAY_ARRAY,
		'todate' => TYPE_ARRAY_ARRAY,
		'totime' => TYPE_ARRAY_NOHTML,
		'fromtime' => TYPE_ARRAY_NOHTML,
		'password' => TYPE_NOHTML,
		'chal_cost' => TYPE_NUM,
		'join_cost' => TYPE_NUM,
		'chal_cost_xtra' => TYPE_BOOL,
		'racemode' => TYPE_UINT,
	));
	if (!$vbulletin->GPC['title'])
	{
		$errormessage = $vbphrase[error_invalid_title];
		eval(standard_error($errormessage));
	}
	if ($vbulletin->GPC['wysiwyg'] && $vbulletin->options['simpleversion'] < 414)
	{
		require_once(DIR . '/includes/functions_wysiwyg.php');
		$description = convert_wysiwyg_html_to_bbcode($vbulletin->GPC['message'], 1);
	}
	else if ($vbulletin->GPC['wysiwyg'])
	{
		require_once(DIR . '/includes/class_wysiwygparser.php');
		$html_parser = new vB_WysiwygHtmlParser($vbulletin);
		$description = $html_parser->parse_wysiwyg_html_to_bbcode($vbulletin->GPC['message']);
	}
	else
	{
		$description = $vbulletin->GPC['message'];
	}
	if (!$description)
	{
		$errormessage = $vbphrase[error_invalid_description];
		eval(standard_error($errormessage));
	}
	$chal_options = serialize(
		array(
			/*'Best Of' => '',
			'Map' => ''*/
		)
	);
	//start date
	$type = 'range';
	$fromtime = $vbulletin->GPC['fromtime']["$type"];
	$totime = $vbulletin->GPC['totime']["$type"];
	$fromdate = $vbulletin->input->clean($vbulletin->GPC['fromdate']["$type"], TYPE_ARRAY_UINT);
	$todate = $vbulletin->input->clean($vbulletin->GPC['todate']["$type"], TYPE_ARRAY_UINT);
	$utc = $timezoneoffset = $vbulletin->GPC['timezoneoffset']["$type"];
	$dst = $vbulletin->GPC['dst']["$type"];
	require_once(DIR . '/includes/functions_misc.php');
	if (!fetch_timezone($timezoneoffset))
	{
		$errormessage = 'Error: invalid timezone specified';
		eval(standard_error($errormessage));
	}	
	$dateline_to = tmnt_fields_to_dateline($totime, $todate, $utc, $dst, $type);
	if (!is_numeric($dateline_to))
	{
		$errormessage = $dateline_to;
		eval(standard_error($errormessage));
	}
	$dateline_from = tmnt_fields_to_dateline($fromtime, $fromdate, $utc, $dst, $type);
	if (!is_numeric($dateline_from))
	{
		$errormessage = $dateline_from;
		eval(standard_error($errormessage));
	}
	if ($dateline_to < $dateline_from)
	{
		$errormessage = 'Error: End date must be after start date.';
		eval(standard_error($errormessage));
	}
	//end date
	if (!$vbulletin->options['tmnt_premium'] OR !$vbulletin->options['tmnt_credit_system'])
	{
		$vbulletin->GPC['chal_cost'] = $vbulletin->GPC['join_cost'] = $vbulletin->GPC['chal_cost_xtra'] = 0;
	}
	if ($vbulletin->options['tmnt_createthread'])
	{
		require_once('./includes/functions_databuild.php');
        $forumid = $vbulletin->options['tmnt_createthread'];
		$templater = vB_Template::create('tmnt_ladder_threadtemplate');
			$templater->register('ladder', $ladder);
			$templater->register('description', $description);
			$templater->register('id', $id);
			$templater->register('title', $vbulletin->GPC['title']);
			$templater->register('catid', $vbulletin->GPC['catid']);
			$templater->register('pot', $vbulletin->GPC['pot']);
			$templater->register('userid', $thisuserid);
			$templater->register('forumid', $forumid);
			$templater->register('username', $thisusername);
		$pagetext = $templater->render();
		$pagetext = preg_replace('/<!--(.|\s)*?-->/', '', $pagetext);
        $open = 1;
        $allow_smilie = 1;
        $visible = 1;
		$threadid = new_thread($thisuserid, $forumid, $vbulletin->GPC['title'], $pagetext, $open, $allow_smilie, $visible);
	}
	else
	{
		$threadid = 0;
	}
	$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "tmnt_ladders
		(title, description, noplayers, cr_userid, cr_username, cr_time, cr_ip, threadid, pot, catid, icon, chal_options, league, homeaway, groups, groupid, dateline_from, dateline_to, dst, utc, chal_cost, join_cost, chal_cost_xtra, xp_win, xp_draw, xp_lose, racemode, password)
		VALUES (
			'".$vbulletin->db->escape_string($vbulletin->GPC['title'])."', 
			'".$vbulletin->db->escape_string($description)."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['noplayers'])."',
			'".$vbulletin->db->escape_string($thisuserid)."', 
			'".$vbulletin->db->escape_string($thisusername)."', 
			".TIMENOW.",
			'".$vbulletin->db->escape_string($thisip)."',
			'".$vbulletin->db->escape_string($threadid)."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['pot'])."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['catid'])."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['icon'])."',
			'".$vbulletin->db->escape_string($chal_options)."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['league'])."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['homeaway'])."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['groups'])."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['groupid'])."',
			'".$vbulletin->db->escape_string($dateline_from)."',
			'".$vbulletin->db->escape_string($dateline_to)."',
			'".$vbulletin->db->escape_string($dst)."',
			'".$vbulletin->db->escape_string($utc)."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['chal_cost'])."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['join_cost'])."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['chal_cost_xtra'])."',
			'".$vbulletin->db->escape_string(3)."',
			'".$vbulletin->db->escape_string(1)."',
			'".$vbulletin->db->escape_string(0)."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['racemode'])."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['password'])."'
		)
		");
	$id = $vbulletin->db->insert_id();
	build_tll_catcache();
	$vbulletin->url = tll_seo(($vbulletin->GPC['league']?"league":"ladder"), $id, $vbulletin->GPC['title'], 1)."&new=1";	
	eval(print_standard_redirect('redirect_insertladder'));
}

// #############################################################################

if ($_POST['do'] == 'updateladder')
{
	$id = $vbulletin->input->clean_gpc('p', 'id', TYPE_UINT);
	if (!$id)
	{
		$errormessage = $vbphrase[error_invalid_ladder];
		eval(standard_error($errormessage));
	}
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id = '$id' ");
	if (!$tmntp['caneditladder'] && $ladder['cr_userid'] != $vbulletin->userinfo['userid'])
	{
		print_no_permission();
	}
    $userid = $thisuserid;
	$username = $thisusername;
	$co_a = $vbulletin->input->clean_gpc('p', 'co_a', TYPE_ARRAY_NOHTML);
	$co_b = $vbulletin->input->clean_gpc('p', 'co_b', TYPE_ARRAY_NOHTML);
	$co_c = $vbulletin->input->clean_gpc('p', 'co_c', TYPE_ARRAY_NOHTML);
	$co = array();
	if (is_array($co_a))
	{
		//$key = preg_replace("/[^a-zA-Z0-9_\s]/", "", unhtmlspecialchars($key));
		foreach($co_a AS $key_a => $a)
		{
			if (!$a)
			{
				continue;
			}
			$a = preg_replace("/[^a-zA-Z0-9\s]/", "", unhtmlspecialchars($a));
			$co["$a"] = $co_b["$key_a"] . ($co_c["$key_a"] ? "#@1" : "");
		}
		$co = serialize($co);
	}
	$icon = $vbulletin->input->clean_gpc('p', 'icon', TYPE_NOHTML);
	$title = $vbulletin->input->clean_gpc('p', 'title', TYPE_NOHTML);
		if (!$title)
		{
			$errormessage = $vbphrase['error_invalid_title'];
			eval(standard_error($errormessage));
		}
	$tmin = $vbulletin->input->clean_gpc('p', 'tmin', TYPE_INT);
	$tmax = $vbulletin->input->clean_gpc('p', 'tmax', TYPE_INT);
	$xp_win = $vbulletin->input->clean_gpc('p', 'xp_win', TYPE_INT);
	$xp_draw = $vbulletin->input->clean_gpc('p', 'xp_draw', TYPE_INT);
	$xp_lose = $vbulletin->input->clean_gpc('p', 'xp_lose', TYPE_INT);
	$catid = $vbulletin->input->clean_gpc('p', 'catid', TYPE_UINT);
	$groupid = $vbulletin->input->clean_gpc('p', 'groupid', TYPE_UINT);
	$racemode = $vbulletin->input->clean_gpc('p', 'racemode', TYPE_UINT);
	$groups = $vbulletin->input->clean_gpc('p', 'groups', TYPE_UINT);
	$fielda = $vbulletin->input->clean_gpc('p', 'fielda', TYPE_NOHTML);
	$fieldb = $vbulletin->input->clean_gpc('p', 'fieldb', TYPE_NOHTML);
	$chal_cost = $vbulletin->input->clean_gpc('p', 'chal_cost', TYPE_NUM);
	$join_cost = $vbulletin->input->clean_gpc('p', 'join_cost', TYPE_NUM);
	$knockout = $vbulletin->input->clean_gpc('p', 'knockout', TYPE_UINT);
	$format2 = $vbulletin->input->clean_gpc('p', 'format2', TYPE_UINT);
	$comp_ugid = $vbulletin->input->clean_gpc('p', 'comp_ugid', TYPE_UINT);
	$allow_challenges = $vbulletin->input->clean_gpc('p', 'allow_challenges', TYPE_UINT);
	$knockout_type = $vbulletin->input->clean_gpc('p', 'knockout_type', TYPE_NOHTML);
	$password = $vbulletin->input->clean_gpc('p', 'password', TYPE_NOHTML);
	$autoscoreconfirm = $vbulletin->input->clean_gpc('p', 'autoscoreconfirm', TYPE_UINT);
	$maxplayers = $vbulletin->input->clean_gpc('p', 'maxplayers', TYPE_UINT);
	$racemode_rounds = $vbulletin->input->clean_gpc('p', 'racemode_rounds', TYPE_UINT);
	$allow_optouts = $vbulletin->input->clean_gpc('p', 'allow_optouts', TYPE_UINT);
	$groupnames = implode(',', $vbulletin->input->clean_gpc('p', 'groupname', TYPE_ARRAY_NOHTML));
	if ($tmin > $tmax)
	{
		$tmin = $tmax;
		$tmax = $vbulletin->input->clean_gpc('p', 'tmin', TYPE_INT);
	}
	$league = $vbulletin->input->clean_gpc('p', 'league', TYPE_UINT);
	$chal_cost_xtra = $vbulletin->input->clean_gpc('p', 'chal_cost_xtra', TYPE_BOOL);
	$startingelo = $vbulletin->input->clean_gpc('p', 'startingelo', TYPE_UINT);
	if (!$startingelo)
	{
		$startingelo = 1000;
	}
	$sticky = $vbulletin->input->clean_gpc('p', 'sticky', TYPE_INT);
	$archive = $vbulletin->input->clean_gpc('p', 'archive', TYPE_INT);
	$vbulletin->input->clean_array_gpc('p', array(
		'message'      => TYPE_STR,
		'wysiwyg'			 => TYPE_BOOL,
	));
	if ($vbulletin->GPC['wysiwyg'] && $vbulletin->options['simpleversion'] < 414)
	{
		require_once(DIR . '/includes/functions_wysiwyg.php');
		$description = convert_wysiwyg_html_to_bbcode($vbulletin->GPC['message'], 1);
	}
	else if ($vbulletin->GPC['wysiwyg'])
	{
		require_once(DIR . '/includes/class_wysiwygparser.php');
		$html_parser = new vB_WysiwygHtmlParser($vbulletin);
		$description = $html_parser->parse_wysiwyg_html_to_bbcode($vbulletin->GPC['message']);
	}
	else
	{
		$description = $vbulletin->GPC['message'];
	}
		if (!$description)
		{
			$errormessage = $vbphrase['error_invalid_description'];
			eval(standard_error($errormessage));
		}
	//start date
	$vbulletin->input->clean_array_gpc('p', array(
		'timezoneoffset' => TYPE_ARRAY_NUM,
		'dst' => TYPE_ARRAY_UINT,
		'points' => TYPE_ARRAY_NUM,
		'rounds_text' => TYPE_ARRAY_NOHTML,
		'fromdate' => TYPE_ARRAY_ARRAY,
		'todate' => TYPE_ARRAY_ARRAY,
		'totime' => TYPE_ARRAY_NOHTML,
		'fromtime' => TYPE_ARRAY_NOHTML,
		'protected_win_defending' => TYPE_UINT,
		'protected_lose_defending' => TYPE_UINT,
		'protected_win_challenge' => TYPE_UINT,
		'protected_lose_challenge' => TYPE_UINT,
		'link_href' => TYPE_NOHTML,
		'link_text' => TYPE_NOHTML,
		'cr_1st' => TYPE_INT,
		'cr_2nd' => TYPE_INT,
		'cr_3rd' => TYPE_INT,
	));
	$credits_1st2nd3rd = serialize(array(
		'cr_1st' => $vbulletin->GPC['cr_1st'],
		'cr_2nd' => $vbulletin->GPC['cr_2nd'],
		'cr_3rd' => $vbulletin->GPC['cr_3rd'],
	));
	$type = 'range';
	$fromtime = $vbulletin->GPC['fromtime']["$type"];
	$totime = $vbulletin->GPC['totime']["$type"];
	$fromdate = $vbulletin->input->clean($vbulletin->GPC['fromdate']["$type"], TYPE_ARRAY_UINT);
	$todate = $vbulletin->input->clean($vbulletin->GPC['todate']["$type"], TYPE_ARRAY_UINT);
	$utc = $timezoneoffset = $vbulletin->GPC['timezoneoffset']["$type"];
	$dst = $vbulletin->GPC['dst']["$type"];
	require_once(DIR . '/includes/functions_misc.php');
	if (!fetch_timezone($timezoneoffset))
	{
		$errormessage = 'Error: invalid timezone specified';
		eval(standard_error($errormessage));
	}
	$dateline_to = tmnt_fields_to_dateline($totime, $todate, $utc, $dst, $type);
	if (!is_numeric($dateline_to))
	{
		$errormessage = $dateline_to;
		eval(standard_error($errormessage));
	}
	$dateline_from = tmnt_fields_to_dateline($fromtime, $fromdate, $utc, $dst, $type);
	if (!is_numeric($dateline_from))
	{
		$errormessage = $dateline_from;
		eval(standard_error($errormessage));
	}
	if ($dateline_to < $dateline_from)
	{
		$errormessage = 'Error: End date must be after start date.';
		eval(standard_error($errormessage));
	}
	if ($vbulletin->GPC['link_href'] && !in_array($vbulletin->GPC['link_href'], array('http://www.','www.','http://')))
	{
		$vbulletin->GPC['link'] = serialize(array(
			'href' => $vbulletin->GPC['link_href'],
			'text' => $vbulletin->GPC['link_text']
		));
	}
	if ($ladder['pot'] && !$tmin && !$tmax)
	{
		$tmin = 1;
		$tmax = 999;
	}
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "tmnt_ladders
		SET
			title = '".$vbulletin->db->escape_string($title)."',
			description = '".$vbulletin->db->escape_string($description)."', 
			ed_userid = '$userid', 
			ed_username = '".$vbulletin->db->escape_string($username)."',
			ed_time ='".TIMENOW."', 
			ed_ip ='".$vbulletin->db->escape_string($thisip)."',
			tmin = '".$vbulletin->db->escape_string($tmin)."', 
			tmax = '".$vbulletin->db->escape_string($tmax)."',
			sticky = '".$vbulletin->db->escape_string($sticky)."',
			archive = '".$vbulletin->db->escape_string($archive)."', 
			catid = '".$vbulletin->db->escape_string($catid)."', 
			startingelo = '".$vbulletin->db->escape_string($startingelo)."',
			icon = '".$vbulletin->db->escape_string($icon)."',
			dateline_from = '".$vbulletin->db->escape_string($dateline_from)."',
			dateline_to = '".$vbulletin->db->escape_string($dateline_to)."',
			dst = '".$vbulletin->db->escape_string($dst)."',
			utc = '".$vbulletin->db->escape_string($utc)."',
			groupid = '".$vbulletin->db->escape_string($groupid)."',
			chal_options = '".$vbulletin->db->escape_string($co)."',
			xp_win = '".$vbulletin->db->escape_string($xp_win)."',
			xp_draw = '".$vbulletin->db->escape_string($xp_draw)."',
			xp_lose = '".$vbulletin->db->escape_string($xp_lose)."',
			groupnames = '".$vbulletin->db->escape_string($groupnames)."',
			groups = '".$vbulletin->db->escape_string($groups)."',
			chal_cost = '".$vbulletin->db->escape_string($chal_cost)."',
			join_cost = '".$vbulletin->db->escape_string($join_cost)."',
			chal_cost_xtra = '".$vbulletin->db->escape_string($chal_cost_xtra)."',
			knockout = '".$vbulletin->db->escape_string($knockout)."',
			comp_ugid = '".$vbulletin->db->escape_string($vbulletin->GPC['comp_ugid'])."',
			knockout_type = '".$vbulletin->db->escape_string($knockout_type)."',
			autoscoreconfirm = '".$vbulletin->db->escape_string($autoscoreconfirm)."',
			fielda = '".$vbulletin->db->escape_string($fielda)."',
			fieldb = '".$vbulletin->db->escape_string($fieldb)."',
			maxplayers = '".$vbulletin->db->escape_string($maxplayers)."',
			allow_challenges = '".$vbulletin->db->escape_string($allow_challenges)."',
			racemode = '".$vbulletin->db->escape_string($racemode)."',
			password = '".$vbulletin->db->escape_string($password)."',
			racemode_rounds = '".$vbulletin->db->escape_string($racemode_rounds)."',
			protected_win_defending = '".$vbulletin->db->escape_string($vbulletin->GPC['protected_win_defending'])."',
			protected_lose_defending = '".$vbulletin->db->escape_string($vbulletin->GPC['protected_lose_defending'])."',
			protected_win_challenge = '".$vbulletin->db->escape_string($vbulletin->GPC['protected_win_challenge'])."',
			protected_lose_challenge = '".$vbulletin->db->escape_string($vbulletin->GPC['protected_lose_challenge'])."',
			format2 = '".$vbulletin->db->escape_string($vbulletin->GPC['format2'])."',
			allow_optouts = '".$vbulletin->db->escape_string($allow_optouts)."',
			pos_points = '".$vbulletin->db->escape_string(serialize($vbulletin->GPC['points']))."',
			rounds_text = '".$vbulletin->db->escape_string(serialize($vbulletin->GPC['rounds_text']))."',
			link = '".$vbulletin->db->escape_string($vbulletin->GPC['link'])."',
			credits_1st2nd3rd = '".$vbulletin->db->escape_string($credits_1st2nd3rd)."'
		WHERE id = '$id'
	");
	if ($league)
	{
		for ($i=1;$i<=$tmnt_maxrr;$i++)
		{//for each round update dateline for all games upto 14
			$vbulletin->input->clean_array_gpc('p', array(
				"round".$i."date" => TYPE_ARRAY_ARRAY,
				"round".$i."time" => TYPE_ARRAY_NOHTML,
			));
			$time = $vbulletin->GPC["round".$i.'time']["$type"];
			$date = $vbulletin->input->clean($vbulletin->GPC["round".$i.'date']["$type"], TYPE_ARRAY_UINT);
			if (!$time && !$date)
			{
				break;
			}
			$dateline = tmnt_fields_to_dateline($time, $date, $utc, $dst, $type);
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_games
				SET
					dateline = '".$vbulletin->db->escape_string($dateline)."'
				WHERE lid = '$id' AND round = '$i'
			");
		}
	}
	build_tll_catcache();
	$ladder['url'] = tll_seo('ladder', $id, $title);
	$vbulletin->url = "ladders.php?".$ladder['url'].($password?"&amp;password=$password":"");	
	eval(print_standard_redirect('redirect_updatedladder'));
}

// #############################################################################

if ($_REQUEST['do'] == 'delete')
{
    $id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	if (!$id)
	{
		$errormessage = $vbphrase[error_invalid_ladder];
		eval(standard_error($errormessage));
	}
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id=$id");
	if (!$tmntp['caneditladder'] && $ladder['cr_userid'] != $vbulletin->userinfo['userid'])
	{
		print_no_permission();
	}
    $vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id=$id");
	$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid=$id");
	$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE lid=$id");
	build_tll_catcache();
	$vbulletin->url = "ladders.php";
	eval(print_standard_redirect('redirect_deletedladder'));
}

// #############################################################################

if ($_REQUEST['do'] == 'edit')
{
    $id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	if (!$id)
	{
		$errormessage = $vbphrase[error_invalid_ladder];
		eval(standard_error($errormessage));
	}
	$ladders = $ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id='$id'");
	if (!$ladder)
	{
		$errormessage = $vbphrase[error_invalid_ladder];
		eval(standard_error($errormessage));
	}
	if (!$tmntp['caneditladder'] && $ladder['cr_userid'] != $vbulletin->userinfo['userid'])
	{
		print_no_permission();
	}
	$title = $ladder['title'];
	$description = $ladder['description'];
	if ($ladder['pot'])
	{
		$team = true;
	} 
	else 
	{
		$team = false;
	}
	if ($ladder['league'])
	{
		$vbphrase['ladder_title'] = $vbphrase['league_title'];
		$vbphrase['ladder_date'] = $vbphrase['league_date'];
		$vbphrase['ladder_editing'] = $vbphrase['league_editing'];
	}
	$ladder = tll_process_league_credits($ladder);
	//print_r($ladder);
	$co_array = unserialize($ladder['chal_options']);
	$co_array[''] = ''; // blank row
	$ladder['co_c']= array();
	foreach ($co_array AS $k1 => $k2)
	{
		if (substr($k2, -3)=='#@1')
		{
			$co_array["$k1"] = substr($k2, 0, -3);
			$ladder['co_c']["$k1"] = 1;
		}
	}
	$sticky   = $ladder['sticky'];
	$archive  = $ladder['archive'];
	$catid    = $ladder['catid'];
	if (!$ladder['startingelo'])
	{
		$ladder['startingelo'] = 1000;
	}
	$categories = '<select name="catid" id="catid">';
	if ($vbulletin->options['tmnt_allow_uncat'])
	{
		$categories .= '<option value="0"></option>';
	}
	/*$cats = $vbulletin->db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_categories
		WHERE tol IN (2,3)
		ORDER BY parentid DESC, displayorder ASC, title ASC
	");
	$carray = array();
	while($cat = $vbulletin->db->fetch_array($cats))
	{*/
	$ladder['link'] = unserialize($ladder['link']);
	if (!$ladder['link'])
	{
		$ladder['link'] = array('href' => 'http://www.');
	}
	if ($vbulletin->tll_catcache)
	{
		foreach ($vbulletin->tll_catcache AS $cindex => $cat)
		{
			if (!in_array('ladders',$cat['tol']) && !in_array('leagues',$cat['tol']) && !$carray["$cat[catid]"])
			{
				continue;
			}
			if ($cat['parentid'])
			{
				$carray["$cat[parentid]"] .= '<option value="'.$cat['catid'].'"';
				if ($catid == $cat['catid'])
				{
					$carray["$cat[parentid]"] .= ' selected="selected" ';
				}
				$carray["$cat[parentid]"] .= '> - '.$cat['title'].'</option>';
			}
			else 
			{
				$categories .= '<option value="'.$cat['catid'].'"';
				if ($catid == $cat['catid'])
				{
					$categories .= ' selected="selected" ';
				}
				$categories .= '>'.$cat['title'].'</option>';
				$categories .= $carray["$cat[catid]"];
			}
		}
	}
	$categories .= '</select>';
	$squery = $vbulletin->db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_ladders
		WHERE groupid != 0
		ORDER BY groupid ASC
	");
	$seasons = array();
	$lastseason = array();
	while($season = $vbulletin->db->fetch_array($squery))
	{
		if ($season['groupid'] != $lastseason['groupid'])
		{
			$season['optgroup'] = true;
			$season['optgroupid'] = ++$optgroup;
		}
		if ($season['groupid'] == $ladder['groupid'] && !$selectedseason)
		{
			$selectedseason = true;
			$season['selected'] = ' selected="selected"';
		}
		$season['lastseason'] = $lastseason['groupid'];
		$seasons[] = $season;
		$lastseason = $season;
	}
	$season = array(
		'optgroupid' => ($optgroup+1),
		'optgroup' => true,
		'title' => $vbphrase['ladder_new_seasons_group'],
		'groupid' => ($lastseason['groupid']+1)
	);
	$seasons[] = $season;
	require_once(DIR . '/includes/functions_editor.php');
	if ($vbulletin->options['simpleversion'] < 414)
	{
		$editorid = construct_edit_toolbar($description, 0, 'nonforum', iif($vbulletin->options['privallowsmilies'], 1, 0));
	}
	else
	{
		$editorid = construct_edit_toolbar($description);
	}
	if (!$ladder['dateline_from'])
	{
		$ladder['dateline_from'] = $ladder['cr_time'];
	}
	if (!$ladder['dateline_to'])
	{
		$ladder['dateline_to'] = TIMENOW + 2592000;
	}
	list ($timezoneoptions, $from_day, $from_monthselected, $from_yearbits, $user_from_time, $dstchecked, $show) = tmnt_dateline_to_fields($ladder['dateline_from'], $ladder['utc'], $ladder['dst'], $show);
	list ($timezoneoptions, $to_day, $to_monthselected, $to_yearbits, $user_to_time, $dstchecked, $show) = tmnt_dateline_to_fields($ladder['dateline_to'], $ladder['utc'], $ladder['dst'], $show);
	$templater = vB_Template::create('tmnt_date_time');
		$templater->register('tmntp', $tmntp);
		$templater->register('ladder', $ladder);
		$templater->register('timezoneoptions', $timezoneoptions);
		$templater->register('dstchecked', $dstchecked);
		$templater->register('time', $user_from_time);
		$templater->register('day', $from_day);
		$templater->register('monthselected', $from_monthselected);
		$templater->register('yearbits', $from_yearbits);
		$templater->register('rangeid', 0);
		$templater->register('prefix', 'from');
	$ladder['startdatehtml'] = $templater->render();
	$templater = vB_Template::create('tmnt_date_time');
		$templater->register('tmntp', $tmntp);
		$templater->register('ladder', $ladder);
		$templater->register('timezoneoptions', $timezoneoptions);
		$templater->register('dstchecked', $dstchecked);
		$templater->register('time', $user_to_time);
		$templater->register('day', $to_day);
		$templater->register('monthselected', $to_monthselected);
		$templater->register('yearbits', $to_yearbits);
		$templater->register('rangeid', 1);
		$templater->register('prefix', 'to');
	$ladder['enddatehtml'] = $templater->render();
	if (file_exists(DIR . '/tll_modules/tll_autoscoreconfirm.php'))
	{
		$tmntp['autoscoreconfirm'] = true;
	}
	if ($ladder['league'])
	{
		//work out round datelines
		$lrquery = $vbulletin->db->query_read("
			SELECT round, dateline
			FROM " . TABLE_PREFIX . "tmnt_ladder_games AS g
			WHERE g.lid = '$ladder[id]'
			GROUP BY g.round
			ORDER BY round ASC
		");
		$qqq = array();//round=>dateline
		while($qq = $vbulletin->db->fetch_array($lrquery))
		{
			$qqq[$qq[round]] = $qq['dateline'];
		}
		$g_i = 1;
		$maxrounds = $vbulletin->db->query_first("
			SELECT g.round
			FROM " . TABLE_PREFIX . "tmnt_ladder_games AS g
			WHERE g.lid = '$ladder[id]'
				AND g.group = '$g_i'
			ORDER BY g.round DESC
		");
		$ladder['rounds'] = $maxrounds['round'];
		//need to get dateline
		$ri = 1;
		while ($ri <= $ladder['rounds'])
		{
			$s = $ri+1;
			$s_dateline = $qqq["$ri"];
			if (!$s_dateline)
			{
				$s_dateline = TIMENOW + $ri * 86400;
			}
			list ($timezoneoptions, $s_day, $s_monthselected, $s_yearbits, $user_s_time, $dstchecked, $show) = tmnt_dateline_to_fields($s_dateline, $ladder['utc'], $ladder['dst'], $show);
			$templater = vB_Template::create('tmnt_date_time');
				$templater->register('tmntp', $tmntp);
				$templater->register('ladder', $ladder);
				$templater->register('timezoneoptions', $timezoneoptions);
				$templater->register('dstchecked', $dstchecked);
				$templater->register('time', $user_s_time);
				$templater->register('day', $s_day);
				$templater->register('monthselected', $s_monthselected);
				$templater->register('yearbits', $s_yearbits);
				$templater->register('rangeid', $s);
				$templater->register('prefix', "round$ri");
			$rhtml = $templater->render();
			$ladder['league_rounds'] .= "<div style=\"clear: both; " . ($ri > 1 ? "border: inherit; " : "") . "padding: inherit;\"><label for=\"range_mm$s\" class=\"label\" style=\"float: left; \">" . construct_phrase($vbphrase['ladder_league_round_x_date'], $ri) . " </label>\r\n<div class=\"rightcol\">" . $rhtml . "</div></div>\r\n";
			$ri++;
		}
		//for racemode
		$ladder['rounds_text'] = unserialize($ladder['rounds_text']);
		for ($rtg = 1; $rtg <= $ladder['racemode_rounds']; $rtg++)
		{
			$ladder['league_rounds'] .= "<div style=\"clear: both; border: inherit; padding: inherit;\"><p class=\"label\" style=\"float: left;\">" . construct_phrase($vbphrase['ladder_league_round_x_text'], $rtg) . " </p>\r\n<div class=\"rightcol\"><input type=\"text\" class=\"textbox\" name=\"rounds_text[$rtg]\" value=\"" . $ladder['rounds_text']["$rtg"] . "\" size=\"40\" /></div></div>\r\n";
		}
		$ladder['groupnames'] = explode(',', $ladder['groupnames']);
		for ($rtg = 1; $rtg <= $ladder['groups']; $rtg++)
		{
			$rtgm = $rtg - 1;
			$ladder['league_groups'] .= "<div style=\"clear: both; border: inherit; padding: inherit;\"><p class=\"label\" style=\"float: left;\">" . construct_phrase($vbphrase['ladder_league_group_x_name'], $rtg) . " </p>\r\n<div class=\"rightcol\"><input type=\"text\" class=\"textbox\" name=\"groupname[$rtg]\" value=\"" . ($ladder['groupnames']["$rtgm"] ? $ladder['groupnames']["$rtgm"] : construct_phrase($vbphrase['ladder_league_group_x'], $rtg)) . "\" /></div></div>\r\n";
		}
	}
	$srty = array('protected_win_defending','protected_lose_defending','protected_win_challenge','protected_lose_challenge');
	foreach($srty AS $sss)
	{
		if ($sss != 'protected_win_defending')
		{
			$ladder['rules_option'] .= "<div class=\"blockrow\">";
		}
		$ladder['rules_option'] .= "<label for=\"$sss\">".$vbphrase['tmnt_'.$sss.'_desc']."</label>";
		$ladder['rules_option'] .= "<div class=\"rightcol\"><select name=\"$sss\" id=\"$sss\">";
		for ($zad = 0; $zad <= 36000; )
		{
			$ladder['rules_option'] .= "<option value=\"$zad\"".($zad==$ladder["$sss"] ? ' selected="selected"' : "").">".($zad/3600)." Hours</option>";
			$zad += 3600;
		}
		$ladder['rules_option'] .= "</select></div>";
		if ($sss == 'protected_win_defending')
		{
			$ladder['rules_option'] .= "</fieldset>";
		}
		else
		{
			$ladder['rules_option'] .= "</div>";
		}
	}
	if ($ladder['racemode'])
	{
		if ($ladder['groups']<2)
		{
			$ladder['positions'] = $ladder['noplayers'];
		}
		else
		{
			$ladder['positions'] = ceil($ladder['noplayers']/$ladder['groups']);
		}
		if ($ladder['pos_points'])
		{
			$ladder['pos_points'] = unserialize($ladder['pos_points']);
		}
		else
		{
			$ladder['pos_points'] = array();
		}
		for ($pi = 1; $pi <= max($ladder['positions'],2); $pi++)
		{
			$ladder['pos_html'] .= '<li> <label for="points_'.$pi.'">'.process_position($pi).'</label> <input id="points_'.$pi.'" type="number" step="0.5" class="textbox numeric" name="points['.$pi.']" value="'.($ladder['pos_points']["$pi"]+0).'" size="3" maxlength="4" title="" tabindex="1" style="width: 50px;" /> </li>';
		}
	}
	$templater = vB_Template::create('tmnt_ladder_edit');
		$templater->register('tmntp', $tmntp);
		$templater->register('ladder', $ladder);
		$templater->register('editorid', $editorid);
		$templater->register('messagearea', $messagearea);
		$templater->register('seasons', $seasons);
		$templater->register('categories', $categories);
		$templater->register('catid', $catid);
		$templater->register('timezoneoptions', $timezoneoptions);
		$templater->register('dstchecked', $dstchecked);
		$templater->register('to_day', $to_day);
		$templater->register('to_monthselected', $to_monthselected);
		$templater->register('to_yearbits', $to_yearbits);
		$templater->register('totime', $user_to_time);
		$templater->register('fromtime', $user_from_time);
		$templater->register('from_day', $from_day);
		$templater->register('from_monthselected', $from_monthselected);
		$templater->register('from_yearbits', $from_yearbits);
		$templater->register('co_array', $co_array);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladders'],
		'ladders.php?' . $vbulletin->session->vars['sessionurl_q'] . 'do=view&amp;id='.$id . '' => $title,
		'' => construct_phrase($vbphrase['ladder_editing'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################


if ($_REQUEST['do'] == 'editrules')
{
	if (!$tmntp['caneditladder'])
	{
		print_no_permission();
	}
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id='$id'");
	if (!$ladder)
	{
		$errormessage = $vbphrase[error_invalid_ladder];
		eval(standard_error($errormessage));
	}
	$ladder['description'] = explode('[rules]',$ladder['description']);
	$ladder['rules'] = $ladder['description']['1'];
	$ladder['description'] = $ladder['description']['0'];
	require_once(DIR . '/includes/functions_editor.php');
	if ($vbulletin->options['simpleversion'] < 414)
	{
		$editorid = construct_edit_toolbar($ladder['rules'], 0, 'nonforum', iif($vbulletin->options['privallowsmilies'], 1, 0));
	}
	else
	{
		$editorid = construct_edit_toolbar($ladder['rules']);
	}
	$templater = vB_Template::create('tmnt_ladder_editrules');
		$templater->register('tmntp', $tmntp);
		$templater->register('ladder', $ladder);
		$templater->register('editorid', $editorid);
		$templater->register('messagearea', $messagearea);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladders'],
		'ladders.php?' . $vbulletin->session->vars['sessionurl_q'] . 'do=view&amp;id='.$id . '' => $title,
		'' => construct_phrase($vbphrase['tmnt_editrules'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}


// #############################################################################

if ($_REQUEST['do'] == 'admin')
{
	$id = $lid = $vbulletin->input->clean_gpc('g', 'lid', TYPE_UINT);
	$l = fetch_ladderinfo($lid);
	if ($l['userid'] == $vbulletin->userinfo['userid'])
	{
		$tmntp['canedittmnt'] = true;
	}	
	if (!$tmntp['canedittmnt'])
	{
		print_no_permission();
	}
	if (file_exists(DIR . '/includes/functions_tll_tabs.php'))
	{
		$sh = $vbulletin->input->clean_gpc('g', 'sh', TYPE_UINT);
		require_once(DIR . '/includes/functions_tll_tabs.php');
		//$template_hook = tll_tabs($template_hook, $tid, 0, 0);
		$show['addtab'] = true;
	}
	if ($tmntp['caneditladder'] && file_exists(DIR . '/tll_modules/tll_editcolors.php'))
	{
		$tmntp['caneditcolors'] = true;
	}
	$templater = vB_Template::create('tmnt_ladder_admin');
		$templater->register('tmntp', $tmntp);
		$templater->register('ladder', $l);
		$templater->register('e', $e);
	$tlhtml .= $templater->render();
	if ($_REQUEST['ajax'])
	{
		print_r($tlhtml);
		exit;
	}
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladders'],
		$l['url'] => $ladder['title'],
		'' => 'Admin Options'
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('headinclude', $headinclude);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('tlhtml', $tlhtml);
		$templater->register('modname', $modname);
		$templater->register('header', $header);
		$templater->register('footer', $footer);
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'editcolors')
{
	require_once('./tll_modules/tll_editcolors.php');
	if (!$tmntp['caneditladder'] && $tmntp['caneditcolors'])
	{
		print_no_permission();
	}
	$lid = $vbulletin->input->clean_gpc('g', 'lid', TYPE_UINT);
	if (!$lid)
	{
		$errormessage = $vbphrase[error_invalid_ladder];
		eval(standard_error($errormessage));
	}
	$ladders = $ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id='$lid'");
	if (!$ladder)
	{
		$errormessage = $vbphrase[error_invalid_ladder];
		eval(standard_error($errormessage));
	}
	$array = array();
	$lc_query = $vbulletin->db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_leaguecolors
		WHERE lid='$lid'
	");
	$i = 0;
	while($lc = $vbulletin->db->fetch_array($lc_query))
	{
		$i++;
		$lc['i'] = $i;
		$array[] = $lc;
	}
	$array[] = array(
		'id' => '',
		'from' => '',
		'to' => '',
		'color' => '',
		'delete' => '-1',
	);
	$ladder['url'] = tll_seo('league', $ladder['id'], $ladder['title'], 1);
	$templater = vB_Template::create('tmnt_ladder_editcolors');
		$templater->register('tmntp', $tmntp);
		$templater->register('ladder', $ladder);
		$templater->register('array', $array);
	$tlhtml .= $templater->render();
	if ($_REQUEST['ajax']==1)
	{
		$tlhtml = str_replace("href=\"ladders.php?do=view&amp;id=$lid\"","href=\"javascript://\" onclick=\"close_tll_popup();\"", $tlhtml);
		print_r($tlhtml);
		exit;
	}
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'leagues.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladder_leagues'],
		$ladder['url'] => $ladder['title'],
		'ladder_admin.php?' . $vbulletin->session->vars['sessionurl_q'] . 'do=edit&amp;id='.$lid => construct_phrase($vbphrase['ladder_editing']),
		'' => construct_phrase($vbphrase['ladder_editcolors'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
	exit;
}

// #############################################################################

if ($_REQUEST['do'] == 'admin_swap')
{
	if (!$tmntp['ladder_superuser'])
	{
		print_no_permission();
	}
	$lid = $vbulletin->input->clean_gpc('g', 'lid', TYPE_UINT);
	$ladder = $vbulletin->db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_ladders
		WHERE id = '$lid'
	");
	if (!$ladder)
	{
		print_no_permission();
	}
	$pid = $vbulletin->input->clean_gpc('g', 'pid', TYPE_UINT);
	$playerarray = array();
	$player = $vbulletin->db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_ladder_players
		WHERE lid = '$lid' AND id = '$pid'
	");
	if (!$player)
	{
		print_no_permission();
	}
	if ($ladder['pot'])
	{
		$player['teamurl'] = tll_seo('team',$player['userid'],$player['username']);
		$teamarray = array();
		$teamsquery = $vbulletin->db->query_read("
			SELECT t.*
			FROM  " . TABLE_PREFIX . "tmnt_teams AS t
			LEFT JOIN " . TABLE_PREFIX . "tmnt_ladder_players AS p
				ON (p.userid = t.teamid AND p.lid = $lid AND active = 1)
			WHERE t.noplayers <= $ladder[tmax]
				AND t.noplayers >= $ladder[tmin]
				AND p.id IS NULL
		");
		while($teamrow = $vbulletin->db->fetch_array($teamsquery))
		{
			$teamarray[] = $teamrow;
		}
	}
	$player['streak'] = $player['wstreak']-$player['lstreak'];
	$show['single'] = $show['usernameajax'] = true;
	$templater = vB_Template::create('tmnt_ladder_swap');
		$templater->register('tmntp', $tmntp);
		$templater->register('ladder', $ladder);
		$templater->register('player', $player);
		$templater->register('lid', $lid);
		$templater->register('pid', $pid);
		$templater->register('thisladder', $thisladder);
		$templater->register('thisplayer', $thisplayer);
		$templater->register('teamarray', $teamarray);
	$tlhtml .= $templater->render();
	$navbits = array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladders']
	);
	$navbits['ladders.php?do=view&id='.$lid.''] = $ladder['title'];
	$navbits[''] = $vbphrase['ladder_swapplayer'];
	$navbits = construct_navbits($navbits);
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('headinclude', $headinclude);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('tlhtml', $tlhtml);
		$templater->register('modname', $modname);
		$templater->register('header', $header);
		$templater->register('footer', $footer);
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}


// #############################################################################

if ($_REQUEST['do'] == 'admin_editpt')
{
	if (!$tmntp['ladder_superuser'])
	{
		print_no_permission();
	}
	if ($lid < 1)
	{
		$lid = $vbulletin->input->clean_gpc('g', 'lid', TYPE_UINT);
	}
	$ladderarray = array();
	$ladders = $vbulletin->db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_ladders
		ORDER BY title ASC
	");
	while($ladder = $vbulletin->db->fetch_array($ladders))
	{
		if ($ladder['id'] == $lid)
		{
			$ladder['selected'] = ' selected="selected"';
			$thisladder = $ladder;
		}
		$ladderarray[] = $ladder;
	}
	if ($thisladder)
	{
		if ($pid < 1)
		{
			$pid = $vbulletin->input->clean_gpc('g', 'pid', TYPE_UINT);
		}
		$playerarray = array();
		$players = $vbulletin->db->query_read("
			SELECT *
			FROM " . TABLE_PREFIX . "tmnt_ladder_players
			WHERE lid = '$lid'
			ORDER BY username ASC
		");
		while($player = $vbulletin->db->fetch_array($players))
		{
			$player['streak'] = $player['wstreak']-$player['lstreak'];
			if ($player['id'] == $pid)
			{
				$player['selected'] = ' selected="selected"';
				$thisplayer = $player;
			}
			$playerarray[] = $player;
		}
	}
	$templater = vB_Template::create('tmnt_ladder_editpt');
		$templater->register('tmntp', $tmntp);
		$templater->register('ladders', $ladderarray);
		$templater->register('players', $playerarray);
		$templater->register('lid', $lid);
		$templater->register('pid', $pid);
		$templater->register('thisladder', $thisladder);
		$templater->register('thisplayer', $thisplayer);
	$tlhtml .= $templater->render();
	$navbits = array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladders']
	);
	if ($thisladder)
	{
		$navbits['ladders.php?do=view&id='.$lid.''] = $thisladder['title'];
	}
	$navbits[''] = $vbphrase['ladder_editpt'];
	$navbits = construct_navbits($navbits);
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('headinclude', $headinclude);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('tlhtml', $tlhtml);
		$templater->register('modname', $modname);
		$templater->register('header', $header);
		$templater->register('footer', $footer);
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if (in_array($_REQUEST['do'], array('add', 'new')))
{
	if (!$tmntp['cancreateladder'])
	{
		print_no_permission();
	}
	$select_catid = $vbulletin->input->clean_gpc('g', 'c', TYPE_UINT);
	$select_pot = $vbulletin->input->clean_gpc('g', 'pot', TYPE_BOOL);
	$select_league = $vbulletin->input->clean_gpc('g', 'league', TYPE_UINT);
	$select_groups = $vbulletin->input->clean_gpc('g', 'groups', TYPE_UINT);
	$carray = array();
	$categories = '<select name="catid" id="catid">';
	if ($vbulletin->options['tmnt_allow_uncat'])
	{
		$categories .= '<option value="0"></option>';
	}
	/*$cats = $vbulletin->db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_categories
		WHERE tol IN (2,3)
		ORDER BY parentid DESC, displayorder ASC, title ASC
	");
	while($cat = $vbulletin->db->fetch_array($cats))
	{*/
	if ($vbulletin->tll_catcache)
	{
		foreach ($vbulletin->tll_catcache AS $cindex => $cat)
		{
			if (!in_array('ladders',$cat['tol']) && !in_array('leagues',$cat['tol']) && !$carray["$cat[catid]"])
			{
				continue;
			}
			if (!in_array('ladders',$cat['tol']) && !$select_league)
			{
				continue;
			}
			if (!in_array('leagues',$cat['tol']) && $select_league)
			{
				continue;
			}
			if ($cat['parentid'])
			{
				$carray["$cat[parentid]"] .= '<option value="'.$cat['catid'].'"';
				if ($cat['catid'] == $select_catid)
				{
					$carray["$cat[parentid]"] .= ' selected="selected"';
				}
				$carray["$cat[parentid]"] .= '> - '.$cat[title].'</option>';
			}
			else
			{
				$categories .= '<option value="'.$cat[catid].'"';
				if ($cat['catid'] == $select_catid)
				{
					$categories .= ' selected="selected"';
				}
				$categories .= '>'.$cat[title].'</option>';
				$categories .= $carray["$cat[catid]"];
			}
		}
	}
	$categories .= '</select>';
	$squery = $vbulletin->db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_ladders
		WHERE groupid != 0
		ORDER BY groupid ASC
	");
	$select_season = $vbulletin->input->clean_gpc('g', 'season', TYPE_UINT);
	$seasons = array();
	$lastseason = array();
	while($season = $vbulletin->db->fetch_array($squery))
	{
		if ($season['groupid'] != $lastseason['groupid'])
		{
			$season['optgroup'] = true;
			$season['optgroupid'] = ++$optgroup;
		}
		if ($season['groupid'] == $select_season && !$selectedseason)
		{
			$selectedseason = true;
			$season['selected'] = ' selected="selected"';
		}
		$season['lastseason'] = $lastseason['groupid'];
		$seasons[] = $season;
		$lastseason = $season;
	}
	$season = array(
		'optgroupid' => ($optgroup+1),
		'optgroup' => true,
		'title' => $vbphrase['ladder_new_seasons_group'],
		'groupid' => ($lastseason['groupid']+1)
	);
	$seasons[] = $season;
	if (!$dateline_from)
	{
		$dateline_from = TIMENOW;
	}
	if (!$dateline_to)
	{
		$dateline_to = TIMENOW + 2592000;
	}
	$utc = 0.00;
	$dst = 1;
	list ($timezoneoptions, $from_day, $from_monthselected, $from_yearbits, $user_from_time, $dstchecked, $show) = tmnt_dateline_to_fields($dateline_from, $utc, $dst, $show);
	list ($timezoneoptions, $to_day, $to_monthselected, $to_yearbits, $user_to_time, $dstchecked, $show) = tmnt_dateline_to_fields($dateline_to, $utc, $dst, $show);
	$templater = vB_Template::create('tmnt_date_time');
		$templater->register('tmntp', $tmntp);
		$templater->register('ladder', $ladder);
		$templater->register('timezoneoptions', $timezoneoptions);
		$templater->register('dstchecked', $dstchecked);
		$templater->register('time', $user_from_time);
		$templater->register('day', $from_day);
		$templater->register('monthselected', $from_monthselected);
		$templater->register('yearbits', $from_yearbits);
		$templater->register('rangeid', 0);
		$templater->register('prefix', 'from');
	$startdatehtml = $templater->render();
	$templater = vB_Template::create('tmnt_date_time');
		$templater->register('tmntp', $tmntp);
		$templater->register('ladder', $ladder);
		$templater->register('timezoneoptions', $timezoneoptions);
		$templater->register('dstchecked', $dstchecked);
		$templater->register('time', $user_to_time);
		$templater->register('day', $to_day);
		$templater->register('monthselected', $to_monthselected);
		$templater->register('yearbits', $to_yearbits);
		$templater->register('rangeid', 1);
		$templater->register('prefix', 'to');
	$enddatehtml = $templater->render();
	require_once(DIR . '/includes/functions_editor.php');
	if ($vbulletin->options['simpleversion'] < 414)
	{
		$editorid = construct_edit_toolbar('', 0, 'nonforum', iif($vbulletin->options['privallowsmilies'], 1, 0));
	}
	else
	{
		$editorid = construct_edit_toolbar('');
	}
	if ($select_league)
	{
		$vbphrase['ladder_create'] = $vbphrase['ladder_create_league'];
		$vbphrase['ladder_date'] = $vbphrase['league_date'];
	}
	$templater = vB_Template::create('tmnt_ladder_new');
		$templater->register('tmntp', $tmntp);
		$templater->register('ladder', $ladder);
		$templater->register('id', $id);
		$templater->register('lid', $lid);
		$templater->register('editorid', $editorid);
		$templater->register('messagearea', $messagearea);
		$templater->register('categories', $categories);
		$templater->register('seasons', $seasons);
		$templater->register('pot', $select_pot);
		$templater->register('league', $select_league);
		$templater->register('groups', $select_groups);
		$templater->register('startdatehtml', $startdatehtml);
		$templater->register('enddatehtml', $enddatehtml);
		$templater->register('utc', $utc);
		$templater->register('dstchecked', $dstchecked);
		$templater->register('timezoneoptions', $timezoneoptions);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladders'],
		'' => construct_phrase($vbphrase['ladder_create'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('headinclude', $headinclude);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('tlhtml', $tlhtml);
		$templater->register('modname', $modname);
		$templater->register('header', $header);
		$templater->register('footer', $footer);
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}


// #############################################################################

if ($_REQUEST['do'] == 'progress')
{
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
		if (!$id) {
			$errormessage = $vbphrase['error_invalid_ladder'];
			eval(standard_error($errormessage));
		}
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id=$id AND league > 0 AND knockout > 0 AND status = 1 ");
	if (($ladder['userid'] != $thisuserid && !$tmntp['caneditladder']) OR !$ladder)
	{
		print_no_permission();
	}
	$userid = $vbulletin->input->clean_gpc('g', 'userid', TYPE_UINT);
		if (!$userid) {
			$errormessage = $vbphrase[error_no_userid];
			eval(standard_error($errormessage));
		}
	$round = $vbulletin->input->clean_gpc('g', 'round', TYPE_STR);
		if (!$round) {
			$errormessage = $vbphrase[error_invalid_round];
			eval(standard_error($errormessage));
		}
	$rounds = array("round2", "round3",  "round4", "round5", "round6", "round7", "round8", "round9", "round10", "round11", "round12");
		if (!in_array($round, $rounds))
		{
			$errormessage = $vbphrase[error_invalid_round];
			eval(standard_error($errormessage));
		}
	$slot = $vbulletin->input->clean_gpc('g', 'slot', TYPE_UINT);
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_players SET ".$round." = '".$slot."' WHERE lid='".$id."' AND userid='".$userid."' ");
	// process loser for double elimination
	if ($ladder['knockout_type'] == 'de' && $slot > 0)
	{
		$slot2 = $vbulletin->input->clean_gpc('g', 'slot2', TYPE_UINT);
		$userid2 = $vbulletin->input->clean_gpc('g', 'userid2', TYPE_UINT);
		$round2 = $vbulletin->input->clean_gpc('g', 'round2', TYPE_STR);
		if (!in_array($round2, $rounds))
		{
			$round2 = $round;
		}
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_players SET ".$round2." = '".$slot2."' WHERE lid='".$id."' AND userid='".$userid2."' ");
	}
	$vbulletin->url = "ladders.php?do=view&id=".$id."&sh=8#".$round."_slot".($slot&1 ? $slot : ($slot-1));	
	eval(print_standard_redirect('redirect_progressedplayer'));
}

// #############################################################################

if ($_POST['do'] == 'swapslots')
{
	if (!$tmntp['caneditladder'])
	{
		print_no_permission();
	}
	$id = $vbulletin->input->clean_gpc('p', 'id', TYPE_UINT);
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id='$id' AND status>'0' AND knockout > 0 AND league > 0 ");
	if (!$ladder)
	{
		$errormessage = $vbphrase['error_invalid_ladder'];
        eval(standard_error($errormessage));
	}
	if (!in_array($ladder['knockout_type'], array('1v1','de')))
	{
		print_no_permission();
	}
	$c_array = $array = array();
	$cmpts = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid='$id' AND slot > 0 ORDER BY slot ASC");
	while ($cmpt = $vbulletin->db->fetch_array($cmpts))
	{
		$c_array[] = $cmpt;
		$vbulletin->input->clean_gpc('p', 's_'.$cmpt['id'], TYPE_UINT);
		if (in_array($vbulletin->GPC['s_'.$cmpt['id']], $array))
		{
			$errormessage = 'Error, two players/teams cannot have the same slot.';
			eval(standard_error($errormessage));
		}
		$array[] = $vbulletin->GPC['s_'.$cmpt['id']];
	}
	foreach ($c_array AS $cd => $c)
	{
		//print_r("$c[id] = ".$vbulletin->GPC['s_'.$c['id']].";<br>");
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_players SET slot = '".$vbulletin->GPC['s_'.$c['id']]."' WHERE id = '".$c['id']."' ");
	}
	$ladder['url'] = tll_seo('league', $ladder['id'], $ladder['title'], 1)."&sh=8";
	$vbulletin->url = $ladder['url'];
	eval(print_standard_redirect('redirect_swappedslots'));
}

// #############################################################################

if ($_REQUEST['do'] == 'swapslots')
{
	if (!$tmntp['caneditladder'] OR !$vbulletin->options['tmnt_premium'])
	{
		print_no_permission();
	}
	$lid = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id='$lid' AND status > 0 AND knockout > 0 AND league > 0 ");
	if (!$ladder)
	{
		$errormessage = $vbphrase['error_invalid_tournament'];
        eval(standard_error($errormessage));
	}
	if (!in_array($ladder['knockout_type'], array('1v1','de')))
	{
		print_no_permission();
	}
	$ladder['url'] = tll_seo('league', $lid, $ladder['title'], 1);
	$ladder['noplayers'] = $ladder['knockout'] * $ladder['groups'];
	for ($si = 1; $si <= $ladder['noplayers']; $si++)
	{
		$options .= '<option value="'.$si.'">'.construct_phrase($vbphrase['tmnt_slot_x'], $si).'</option>';
	}
	$ci = 0;
	$slots = array();
	$cmpts = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid='$lid' AND slot > 0 ORDER BY slot ASC");
	while ($cmpt = $vbulletin->db->fetch_array($cmpts))
	{
		$ci++;
		if ($cmpt['round2'])
		{//already started competing...
			$errormessage = 'You cannot swap slots once players/teams have started progressing through the rounds.';
			eval(standard_error($errormessage));
		}
		if (!$cmpt['userid'])
		{
			$show['slot_'.$ci] = false;
		}
		else
		{
			$show['slot_'.$ci] = true;
		}
		$cmpt['options'] = str_replace('value="'.$ci.'"','value="'.$ci.'" selected="selected"', $options);
		$slots["$ci"] = $cmpt;
	}
	$templater = vB_Template::create('tmnt_swapslots');
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt', $ladder);
		$templater->register('slots', $slots);
		$templater->register('show', $show);
		$templater->register('ci', $ci);
		$templater->register('form_action', 'ladders_admin.php?do=swapslots&amp;id='.$lid);
		$templater->register('cancel_link', $ladder['url']);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' => $modname,
		'leagues.php' => $vbphrase['ladder_leagues'],
		$ladder['url'] => $ladder['title'],
		'' => construct_phrase($vbphrase['tmnt_swapslots'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'restart_knockout')
{
	if (!$tmntp['caneditladder'] OR !$vbulletin->options['tmnt_premium'])
	{
		print_no_permission();
	}
	$lid = $vbulletin->input->clean_gpc('g', 'lid', TYPE_UINT);
	$test = $vbulletin->input->clean_gpc('g', 'test', TYPE_UINT);
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id=$lid AND status = 1 AND league > 1 AND knockout > 0");
	if (!$ladder)
	{
		print_no_permission();
	}
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_players SET round = 0, slot = 0 WHERE lid='".$lid."'");
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladders SET status = 0 WHERE id='".$ladder['id']."'");
	$vbulletin->url = "ladders.php?do=view&id=".$lid;
	eval(print_standard_redirect('redirect_restartedknockoutleague'));
}

// #############################################################################

if ($_REQUEST['do'] == 'start_knockout')
{
	if (!$tmntp['caneditladder'] OR !$vbulletin->options['tmnt_premium'])
	{
		print_no_permission();
	}
	$lid = $vbulletin->input->clean_gpc('g', 'lid', TYPE_UINT);
	$test = $vbulletin->input->clean_gpc('g', 'test', TYPE_UINT);
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id=$lid AND status = 0 AND league > 1 AND knockout > 0");
	
	if (!$ladder)
	{
		print_no_permission();
	}
	$games = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE lid=$lid AND finished = 0");
	if ($games['countrows'] > 0)
	{
		$errormessage = 'You have ' . $games['countrows'] . ' outstanding unfinished matches.';
		eval(standard_error($errormessage));
	}
	require_once(DIR . '/includes/functions_tll_prem.php');
	//$ladder['groups']=4;
	$limit = $ladder['knockout'];//top X of each group
	$total = $ladder['knockout'] * $ladder['groups'];//no of knockout players
	$noplayers = ceil($total / 4) * 4;//tmnt noplayers
	$curr_slots = array();
	if ($noplayers > $total)
	{
		$curr_slots[] = 2;
	}
	if ($ladder['league'] > 0)
	{
		$vbulletin->options['tmnt_ladder_ranking'] = 'xp';
		$vbulletin->options['tmnt_elorating'] = 0;
	}
	$mh = $total + 2;
	//print_r($total);
	for ($i = 1; $i <=$ladder['groups']; $i++)
	{//get top two sorted by groups
		$c = 0;
		$cmpts = $vbulletin->db->query_read("
			SELECT players.* 
			FROM " . TABLE_PREFIX . "tmnt_ladder_players AS players
			WHERE lid = '$lid' AND players.group = '$i'
			ORDER BY 
				" . ($vbulletin->options['tmnt_ladder_ranking'] == 'elo' ? "players.rank DESC," : "")
				. ($vbulletin->options['tmnt_ladder_ranking'] == 'xp' ? "players.xp DESC," : "") . "
				players.wins DESC,
				players.draws DESC,
				players.loses ASC,
				" . ($vbulletin->options['tmnt_ladder_ranking'] == 'elo' ? "players.xp DESC, " : "") . "
				players.totalpoints DESC,
				players.pointsagainst ASC
			LIMIT 0, $limit
		");
		while($cmpt = $vbulletin->db->fetch_array($cmpts))
		{
			$c++;
			/*if ($i == 1)
			{
				if ($c == 1)
				{
					$slot = 1;
				}
				elseif ($c == 2)
				{
					
				}
			}*/
			/*if ($i % 2)
			{//odds
				//print_r($i.'a');
				if ($c == 1)
				{
					$ml++;
					$slot = $ml;
				}
				else
				{
					$slot = $ml + ($ladder['groups']) * ($c - 1);
				}
			}
			else
			{//evens
				if ($c == 1)
				{
					$mh--;
					$slot = $mh;
				}
				else
				{
					$slot = $mh - ($ladder['groups']) * ($c - 1) + 1;
				}
				//$slot = $ml + ($ladder['groups']) * ($c - 1);
			}*/
			if ($c == 1)
			{
				$slot = ($i * 2) - 1;
			}
			else
			{
				$mh -= 2;
				$slot = $mh;
			}
			if (in_array($slot, $curr_slots) OR $slot <= 0)
			{
				$slot = tll_rand_slot(1, $noplayers, $curr_slots);
			}
			//print_r("$i $c $slot;<br>");
			//print_r($cmpt[username].$slot);
			//$slot = tll_rand_slot(1, $noplayers, $curr_slots);
			$curr_slots[] =  $slot;
			$cmpt['round'] = $cmpt['slot'] = $slot;
			//print_r($cmpt);
	//give them each random slots
	//give them each round 1 position
			if (!$test)
			{
				$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_players SET round = $slot, slot = $slot WHERE id='".$cmpt['id']."'");
			}
			else
			{
				print_r("UPDATE " . TABLE_PREFIX . "tmnt_ladder_players SET round = $slot, slot = $slot WHERE id='".$cmpt['id']."'<br>");
			}
		}
	}
	if ($test)
	{
		exit;
	}
	//set ladder status => 1 
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladders SET status = 1 WHERE id='".$lid."'");
	$vbulletin->url = "ladders.php?do=view&id=".$lid."&sh=8";
	eval(print_standard_redirect('redirect_startedknockoutleague'));
}

// #############################################################################

if ($_REQUEST['do'] == 'deletechallenge')
{
	if (!$tmntp['caneditladder'])
	{
		print_no_permission();
	}
    $id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	if (!$id)
	{
		$errormessage = $vbphrase['error_invalid_challenge'];
		eval(standard_error($errormessage));
	}
    $vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE id=$id");
	$vbulletin->url = "ladders.php?do=allchallenges";
	eval(print_standard_redirect('redirect_deletedchallenge'));
}

// #############################################################################

if ($_REQUEST['do'] == 'progressfinish')
{
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
		if (!$id)
		{
			$errormessage = $vbphrase['error_invalid_tournament'];
			eval(standard_error($errormessage));
		}
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id=$id AND league > 0 AND knockout > 0 AND status = 1 ");
	if (($ladder['userid'] != $thisuserid && !$tmntp['caneditladder']) OR !$ladder)
	{
		print_no_permission();
	}
	$team = false;
	if ($ladder['pot'])
	{
		$team = true;
	}
	$userid = $vbulletin->input->clean_gpc('g', 'userid', TYPE_UINT);
		if (!$userid) 
		{
			$errormessage = $vbphrase[error_invalid_userid];
			eval(standard_error($errormessage));
		}
	$round = $vbulletin->input->clean_gpc('g', 'round', TYPE_STR);
		if (!$round) 
		{
			$errormessage = $vbphrase[error_invalid_round];
			eval(standard_error($errormessage));
		}
	$rounds = array("round2", "round3",  "round4", "round5", "round6", "round7", "round8", "round9", "round10", "round11", "round12");
		if (!in_array($round, $rounds))
		{
			$errormessage = $vbphrase[error_invalid_round];
			eval(standard_error($errormessage));
		}
	$slot = $vbulletin->input->clean_gpc('g', 'slot', TYPE_UINT);
		if (!$slot)
		{
			$errormessage = $vbphrase[error_invalid_slot];
			eval(standard_error($errormessage));
		}
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
		SET $round = '$slot', winner = '1' WHERE lid = '$id' AND userid = '$userid' 
	");
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "tmnt_ladders
		SET status = '2', dateline_to = '".TIMENOW."'  WHERE id = '$id'
	");
	
	/*if (!$tmnt['pot'] && $tmnt['win_credits'] > 0 && $vbulletin->options['tmnt_credit_system'])
	{//winner gets credits
require_once(DIR . '/includes/functions_tll_prem.php');		
		process_credits_transaction($userid, $tmnt['win_credits'], 'Won tournament');
		update_forum_creditprofit(vbdate('W',TIMENOW), vbdate('Y',TIMENOW), -$tmnt['win_credits'], TIMENOW);
	}*/
	/*if ($tmnt['ladderid'])
	{
		if ($tmnt['lwinxp'])
		{
			list($tmnt['xp_1st'], $tmnt['xp_2nd'], $tmnt['xp_3rd']) = explode(',', $tmnt['lwinxp']);
		}
		else
		{
			$tmnt['xp_1st'] = $tmnt['xp_2nd'] = $tmnt['xp_3rd'] = 0;
		}
		if ($tmnt['prize'] OR $tmnt['xp_1st'] OR $tmnt['xp_2nd'] OR $tmnt['xp_3rd'])
		{
			list($winners, $winners2nd, $winners3rd) = get_se_ftt(null, 0, 1, $id);
			$userids2nd = implode("' OR userid = '", $winners2nd);
			$userids3rd = implode("' OR userid = '", $winners3rd);
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
				SET rank = rank + " . $tmnt['prize'] . "
				" . ($tmnt['xp_1st'] ? ", xp = xp + " . $tmnt['xp_1st'] : "") . "
				WHERE (userid = '$userid')
					AND lid = '" . $tmnt['ladderid'] . "'
			");
			if ($tmnt['xp_2nd'] > 0 && $userids2nd)
			{
				$vbulletin->db->query_write("
					UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
					SET xp = xp + $tmnt[xp_2nd]
					WHERE (userid = '$userids2nd')
						AND lid = '" . $tmnt['ladderid'] . "'
				");
			}
			if ($tmnt['xp_3rd'] > 0 && $userids3rd)
			{
				$vbulletin->db->query_write("
					UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
					SET xp = xp + $tmnt[xp_3rd]
					WHERE (userid = '$userids3rd')
						AND lid = '" . $tmnt['ladderid'] . "'
				");
			}
		}
	}*/
	/*if (!$team)
	{
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET tmnt_wins = tmnt_wins + 1 WHERE userid=$userid");
	}
	else
	{
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_teams SET wins = wins + 1 WHERE teamid=$userid");
	}*/
	$vbulletin->url = "ladders.php?do=view&id=" . $id . "&sh=8";	
	eval(print_standard_redirect('redirect_progressedplayer'));
}

// #############################################################################

if ($_REQUEST['do'] == 'addplayer')
{
	if (!$tmntp['caneditladder'])
	{
		print_no_permission();
	}
    $id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	if (!$id)
	{
		$errormessage = $vbphrase[error_invalid_ladder];
		eval(standard_error($errormessage));
	}
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id='$id'");
	if (!$ladder)
	{
		$errormessage = $vbphrase[error_invalid_ladder];
		eval(standard_error($errormessage));
	}
	if ($ladder['pot'])
	{
		$team = true;
		$teamarray = array();
		$teams_query = $vbulletin->db->query_read("
			SELECT *
			FROM " . TABLE_PREFIX . "tmnt_teams AS t
			LEFT JOIN " . TABLE_PREFIX . "tmnt_ladder_players AS p
				ON (p.userid = t.teamid AND p.lid = $id AND active = 1)
			WHERE p.id IS NULL
		");
		while($teamq = $vbulletin->db->fetch_array($teams_query))
		{
			$teamarray[] = $teamq;
		}
		if (!$teamarray)
		{
			$errormessage = $vbphrase['tmnt_noteams'];
        	eval(standard_error($errormessage));
		}
	} 
	else 
	{
		$team = false;
	}
	if (isset($_REQUEST['added']))
	{
		$added_success = true;
	}
	if ($ladder['groupid'])
	{
		$ladder_array = array();
		$ladders_query = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE groupid = '".$ladder['groupid']."' ");
		while ($l = $vbulletin->db->fetch_array($ladders_query))
		{
			$ladder_array["$l[id]"] = $l;
		}
	}
	$templater = vB_Template::create('tmnt_ladder_newplayer');
		$templater->register('tmntp', $tmntp);
		$templater->register('ladder', $ladder);
		$templater->register('ladder_array', $ladder_array);
		$templater->register('added_success', $added_success);
		$templater->register('id', $id);
		$templater->register('team', $team);
		$templater->register('teamarray', $teamarray);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladders'],
		'ladders.php?' . $vbulletin->session->vars['sessionurl_q'] . 'do=view&amp;id='.$id . '' => $ladder['title'],
		'' => ($ladder['pot'] ? $vbphrase['ladder_addingteam'] : $vbphrase['ladder_addingplayer'])
	));
	$navbar = render_navbar_template($navbits);
	$show['usernameajax'] = true;
	if ($ladder['league']==2)
	{
		$show['single'] = true;
	}
	if ($_REQUEST['ajax'] == 1)
	{
		$tlhtml = str_replace('onclick="window.location.href=\'ladders.php?do=view&amp;id='.$id.'\'"','onclick="close_tll_popup();"',$tlhtml);
		print_r($tlhtml);
		exit;
	}
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('show', $show);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'killmc')
{
    $id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	if (!$id)
	{
		$errormessage = $vbphrase['error_invalid_comment'];
        eval(standard_error($errormessage));
	}
	$lid = $vbulletin->input->clean_gpc('g', 'lid', TYPE_UINT);
	$mid = $vbulletin->input->clean_gpc('g', 'mid', TYPE_UINT);
	if (!$mid)
	{
		$errormessage = $vbphrase['error_invalid_match'];
        eval(standard_error($errormessage));
	}
	$sh = $vbulletin->input->clean_gpc('g', 'sh', TYPE_UINT);
	$u1 = $vbulletin->input->clean_gpc('g', 'u1', TYPE_UINT);
	$u2 = $vbulletin->input->clean_gpc('g', 'u2', TYPE_UINT);
	$from = $vbulletin->input->clean_gpc('g', 'from', TYPE_NOHTML);
	if ($tmntp['candelmcomments'])
	{
		$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "tmnt_ladder_mcs WHERE id=$id");
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET comments = comments - 1 WHERE id=$mid");
	}
	elseif ($vbulletin->options['tmnt_ladder_candelown_mcs'] && $vbulletin->userinfo['userid'])
	{
		$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "tmnt_ladder_mcs WHERE id=$id AND userid=$thisuserid");
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET comments = comments - 1 WHERE id = $mid");
	}
	if ($from)
	{
		$vbulletin->url = "ladders.php?do=".$from.($from=='search_matches' ? "&id=$lid&u1=$u1&u2=$u2" : "")."&mid=$mid#match$mid";
	}
	else
	{
		$vbulletin->url = "ladders.php?do=view&id=$lid&sh=$sh&mid=$mid#match$mid";
	}
	eval(print_standard_redirect('redirect_killcomment'));
}

// #############################################################################

if ($_REQUEST['do'] == 'killmatch')
{
	if (!$tmntp['ladder_superuser'])
	{
		print_no_permission();
	}
	$mid = $vbulletin->input->clean_gpc('g', 'mid', TYPE_UINT);
	if (!$mid)
	{
		$errormessage = $vbphrase['error_invalid_match'];
        eval(standard_error($errormessage));
	}
	$matchinfo = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE id = '$mid'");
	$lid = $matchinfo['lid'];
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id = '".$matchinfo['lid']."' ");
	function check_reset_ladder_player($lid, $userid, $ladder)
	{
		global $vbulletin;
		$player = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid = '".$lid."' AND userid = '".$userid."' ");
		if ($player)
		{
			$player['tm'] = $player['wins']+$player['draws']+$player['loses'];
			if ($player['tm'] == 0 && $player['rank'] > 0)
			{
				$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_players SET rank = '".$ladder['startingelo']."', wstreak = 0, lstreak = 0, longeststreak = 0 WHERE lid = '$lid' AND userid = '".$userid."' ");
			}
		}
		return true;
	}
	if ($matchinfo['finished'])
	{
		$player_u = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid = '".$lid."' AND userid = '".$matchinfo['u']."' ");
		$player_u2 = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid = '".$lid."' AND userid = '".$matchinfo['u2']."' ");
		list($oldrank_u, $oldrank_u2) = calc_reverse_elo(0, 0, $matchinfo['score_u'], $matchinfo['score_u2'], '', '', $lid, $matchinfo['u'], $matchinfo['u2']);
		$lm_u = current($vbulletin->db->query_first("SELECT id FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE (u = '".$matchinfo['u']."' OR u2 = '".$matchinfo['u']."') AND lid = '$lid' ORDER BY dateline_finished DESC "));
		$lm_u2 = current($vbulletin->db->query_first("SELECT id FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE (u = '".$matchinfo['u2']."' OR u2 = '".$matchinfo['u2']."') AND lid = '$lid' ORDER BY dateline_finished DESC "));
		$altrank = $matchinfo['altered_rank'];
		if ($matchinfo['score_u'] > $matchinfo['score_u2'])
		{//u won
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_players 
				SET
					wins = wins - 1,
					totalpoints = totalpoints - ".$matchinfo['score_u'].", 
					pointsagainst = pointsagainst - ".$matchinfo['score_u2'].", 
					xp = xp - ".$ladder['xp_win'].",
					challenges = challenges - 1 
					".($lm_u==$mid && $altrank ? ", rank = rank - $altrank " : "")."
					".($player_u['wstreak'] > 0 ? ", wstreak = wstreak - 1 " : "")." 
				WHERE lid = '$lid' 
					AND userid = '".$matchinfo['u']."'
			");
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_players 
				SET loses = loses - 1, 
					totalpoints = totalpoints - ".$matchinfo['score_u2'].", 
					pointsagainst = pointsagainst - ".$matchinfo['score_u'].",
					xp = xp - ".$ladder['xp_lose']."
					".($lm_u2==$mid && $altrank ?", rank = rank + $altrank" :"")."
					".($player_u2['lstreak'] > 0 ? ", lstreak = lstreak - 1 " : "")." 
				WHERE lid = '$lid'
					AND userid = '".$matchinfo['u2']."'
			");
		}
		elseif ($matchinfo['score_u'] < $matchinfo['score_u2'])
		{//u2 won
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_players 
				SET loses = loses - 1,
					totalpoints = totalpoints - ".$matchinfo['score_u'].",
					pointsagainst = pointsagainst - ".$matchinfo['score_u2'].", 
					xp = xp - ".$ladder['xp_lose'].", 
					challenges = challenges - 1
					".($lm_u==$mid && $altrank ?", rank = rank + $altrank" :"")."
					".($player_u['lstreak'] > 0 ? ", lstreak = lstreak - 1 " : "")." 
				WHERE lid = '$lid' 
					AND userid = '".$matchinfo['u']."'
			");
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
				SET wins = wins - 1, 
					totalpoints = totalpoints - ".$matchinfo['score_u2'].", 
					pointsagainst = pointsagainst - ".$matchinfo['score_u'].", 
					xp = xp - ".$ladder['xp_win']."
					".($lm_u2==$mid && $altrank ? ", rank = rank - $altrank " : "")."
					".($player_u2['wstreak'] > 0 ? ", wstreak = wstreak - 1 " : "")." 
				WHERE lid = '$lid'
					AND userid = '".$matchinfo['u2']."'
			");
		}
		else
		{//draw
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_players SET draws = draws - 1, totalpoints = totalpoints - ".$matchinfo['score_u'].", pointsagainst = pointsagainst - ".$matchinfo['score_u2'].", xp = xp - ".$ladder['xp_draw'].", challenges = challenges - 1, rank = '$oldrank_u' WHERE lid = '$lid' AND userid = '".$matchinfo['u']."'");
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_players SET draws = draws - 1, totalpoints = totalpoints - ".$matchinfo['score_u2'].", pointsagainst = pointsagainst - ".$matchinfo['score_u'].", xp = xp - ".$ladder['xp_draw'].", rank = '$oldrank_u2' WHERE lid = '$lid' AND userid = '".$matchinfo['u2']."'");
		}
	}
	check_reset_ladder_player($lid, $matchinfo['u'], $ladder);
	check_reset_ladder_player($lid, $matchinfo['u2'], $ladder);
	$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "tmnt_ladder_mcs WHERE mid=$mid");
	$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE id=$mid");
	$from = $vbulletin->input->clean_gpc('g', 'from', TYPE_STR);
	if (!$sh)
	{
		$sh = 1;
	}
	$vbulletin->url = "ladders.php?do=view&id=".$matchinfo['lid']."&sh=$sh";
	eval(print_standard_redirect('redirect_killmatch'));
}

// #############################################################################

if ($_REQUEST['do'] == 'restartleague')
{
	if (!$tmntp['caneditladder'])
	{
		print_no_permission();
	}
	$lid = $id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id='$id' AND league > 1 ");
	if (!$ladder)
	{
		$errormessage = $vbphrase['error_invalid_league'];
		eval(standard_error($errormessage));
	}
	$ladder['url'] = tll_seo('league', $ladder['id'], $ladder['title'], 1);
	if ($_REQUEST['confirm'] != 1)
	{
		$errormessage = "Are you sure you want to delete all matches for this league?<br /><br />This cannot be undone!<br><br><a href=\"ladders_admin.php?do=restartleague&amp;confirm=1&amp;id=$id\" class=\"button\">Yes</a> <a href=\"".$ladder['url']."\" class=\"button\">No</a>";
		eval(standard_error($errormessage));
	}
	$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE lid=$id");
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "tmnt_ladders
		SET
			league = 1
		WHERE id = '$lid' AND league > 1
	");
	$vbulletin->url = $ladder['url'];
	eval(print_standard_redirect('redirect_restartleague'));
}

// #############################################################################

if ($_REQUEST['do'] == 'increaserounds')
{
	$vbulletin->input->clean_array_gpc('g', array(
		'lid' => TYPE_UINT,
	));
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id = '".$vbulletin->GPC['lid']."'");
	if (!$tmntp['cancreateladder'] && $ladder['cr_userid'] != $vbulletin->userinfo['userid'])
	{
		print_no_permission();
	}
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "tmnt_ladders
		SET racemode_rounds = racemode_rounds +1
		WHERE id = '".$vbulletin->GPC['lid']."'
	");
	$ladder['url'] = tll_seo('ladder', $ladder['id'], $ladder['title']);
	$vbulletin->url = "ladders.php".$ladder['url'];	
	eval(print_standard_redirect('redirect_updateladder'));
}

// #############################################################################

if ($_REQUEST['do'] == 'admindeletematch')
{
	if (!$tmntp['caneditladder'])
	{
		print_no_permission();
	}
	$vbulletin->input->clean_array_gpc('g', array(
		'id' => TYPE_UINT,
		'lid' => TYPE_UINT,
		'sh' => TYPE_UINT,
		'from' => TYPE_NOHTML
	));
	$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE id = '" . $vbulletin->GPC['id'] . "'");
	$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "tmnt_ladder_mcs WHERE mid = '" . $vbulletin->GPC['id'] . "'");
	if ($vbulletin->GPC['from'] == 'ladder')
	{
		$vbulletin->url = "ladders.php?do=view&id=" . $vbulletin->GPC['lid'] . "&sh=" . $vbulletin->GPC['sh'];
	}
	else
	{
		$vbulletin->url = "ladders.php?do=reportedmatches";
	}
	eval(print_standard_redirect('redirect_deletedmatch'));
}

// #############################################################################


