<?php
/**
 * login2, an alternate login process script, which is mandatory for linking/unlinking/registering with steam connect
 *
 * @author Disasterpiece
 * @author Andreas "Radon" Rudolph <radon@purgatory-labs.de>
 * @version 1.4.5rc3
 */

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'login2');
define('CSRF_PROTECTION', true);
define('CONTENT_PAGE', false);

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array('timezone', 'user', 'register', 'cprofilefield');

// get special data templates from the datastore
$specialtemplates = array('steam_softlinks');

// pre-cache templates used by all actions
$globaltemplates = array(
	'register_rules',
	'register_verify_age',
);

// ######################### REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/functions_login.php');
require_once(DIR . '/includes/openid.php');
require_once(DIR . '/includes/functions_steamconnect.php');

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

if (!isset($_POST['do']) || $_POST['do'] != 'unlink') { // Don't need an openid connection while unlinking
	try {
		$openid = new LightOpenID;
	}
	catch(ErrorException $e) {
		eval(standard_error(fetch_error('stc_err_openid', $e->getMessage())));
	}
}

// ############################### start do login ###############################
// User clicked button, so redirect him to the steam openid page
if ($_REQUEST['do'] == 'login' && !$openid->mode)
{

	try {
		$openid->identity = 'http://steamcommunity.com/openid';
		$openid->realm     = ($vbulletin->options['stc_force_https'] ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST'];
		$openid->returnUrl = $openid->realm . $_SERVER['REQUEST_URI'];
		header('Location: ' . $openid->authUrl());
		exit();
	}
	catch(ErrorException $e) {
		stc_log_action("Exception thrown while trying to login steam user: ".$e->getMessage());
		eval(standard_error(fetch_error('stc_err_openid',$e->getMessage())));
		exit();
	}

}

if ($_POST['do'] == 'unlink')
{

	// Check if logged in
	if (!isset($vbulletin->userinfo['userid']) || $vbulletin->userinfo['userid'] < 1) {
		stc_log_action("User tried to unlink without being logged in: ".$_SERVER['REMOTE_ADDR']);
		eval(standard_error(fetch_error('stc_err_linkmember_notloggedin')));
		exit();
	}

	// Test for steam id
	if (!$vbulletin->userinfo['steam_link'] || empty($vbulletin->userinfo['steam_link']))
	{
		stc_log_action(sprintf("User #%d tried to unlink without having a real steam_id",$vbulletin->userinfo['userid']));
		eval(standard_error(fetch_error('stc_err_steamid')));
		exit();
	}

	// Test if unlinking is allowed
	if (!$vbulletin->options['stc_allow_unlink']) {
		eval(standard_error(fetch_error('stc_unlink_not_allowed')));
		exit();
	}

	// Check if user has provided an email and a password. otherwise we can't unlink his steam-id
	list($xxx,$no_email,$no_password) = explode('|',$vbulletin->userinfo['steam_link']);

	if ($no_email==1 || $no_password==1) {
		stc_log_action(sprintf("User #%d tried to unlink without having email/pw set",$vbulletin->userinfo['userid']));
		eval(standard_error(fetch_error('stc_err_authinfo')));
		exit();
	}

	$userdata =& datamanager_init('User', $vbulletin, ERRTYPE_SILENT);
	$userdata->set_existing($vbulletin->userinfo);
	$stc_newgroups = $userdata->fetch_field('membergroupids');
	
	if ($vbulletin->options['stc_default_usergroup'] && $userdata->fetch_field('usergroupid') == $vbulletin->options['stc_default_usergroup']) {
		// User is in primary steam usergroup, put him into the regular registered users group
		$userdata->set('usergroupid', 2);
		$userdata->set('displaygroupid', 0); // Displaygroup: "Default"
	}

	($hook = vBulletinHook::fetch_hook('stc_unlinkuser_start')) ? eval($hook) : false;

	$userdata->set('steam_link', '');
	$userdata->set('steam_code', '');

	if ($vbulletin->options['stc_remove_secondary'] && $vbulletin->options['stc_secondary_usergroup'] && $vbulletin->options['stc_secondary_usergroup'] != 6) {
		$stc_newgroups = remove_secondary_group_membership($stc_newgroups, $vbulletin->options['stc_secondary_usergroup']);
	}
	if ($vbulletin->options['stc_secondary_group_usergroup'] && !empty($vbulletin->options['stc_secondary_group_id'])) {
		$stc_newgroups = remove_secondary_group_membership($stc_newgroups, $vbulletin->options['stc_secondary_group_usergroup']);
	}

	if ($stc_newgroups != $userdata->fetch_field('membergroupids')) {
		stc_log_action(sprintf("User #%d unlinked, changed secondary groups from [%s] to [%s]",
			$vbulletin->userinfo['userid'],
			$userdata->fetch_field('membergroupids'),
			$stc_newgroups));
	}

	$userdata->set('membergroupids', $stc_newgroups);

	($hook = vBulletinHook::fetch_hook('stc_unlinkuser_complete')) ? eval($hook) : false;

	stc_log_action(sprintf("Unlinked user #%d from steam_id %s",$vbulletin->userinfo['userid'],$vbulletin->userinfo['steam_link']));
	$userdata->save();

	$vbulletin->url = fetch_seo_url('forumhome', array());

	print_standard_redirect(fetch_error('stc_unlink_success'), false, true, $vbulletin->userinfo['languageid']);
	exit();
}

if ($_POST['do'] == 'linkmember') {

	// Check if logged in
	if (!isset($vbulletin->userinfo['userid']) || $vbulletin->userinfo['userid'] < 1) {
		stc_log_action("User wants to link accounts, but is not logged in: ".$_SERVER['REMOTE_ADDR']);
		eval(standard_error(fetch_error('stc_err_linkmember_notloggedin')));
	}

	// Fetch steam id
	if (!$vbulletin->steam_softlinks || !is_array($vbulletin->steam_softlinks) || !isset($vbulletin->steam_softlinks[$vbulletin->session->vars['dbsessionhash']]))
	{
		stc_log_action("While transferring login process, the cached steam softlink seems to have vanished. Here's what we have:");
		stc_log_action(print_r($vbulletin->steam_softlinks, true));
		stc_log_action("---");
		eval(standard_error(fetch_error('stc_err_steamidt')));
	}
	else $steam_id = $vbulletin->steam_softlinks[$vbulletin->session->vars['dbsessionhash']];

	$userdata_rank =& datamanager_init('User', $vbulletin, ERRTYPE_SILENT);
	$userdata_rank->set_existing($vbulletin->userinfo);

	$stc_additionalgroups = array();

	($hook = vBulletinHook::fetch_hook('stc_linkuser_start')) ? eval($hook) : false;

	if ($vbulletin->options['stc_secondary_group_usergroup'] && !empty($vbulletin->options['stc_secondary_group_id'])) {
		// Check if user is member of the specified steamgroup. If so, put him in the defined vB usergroup
		// Depending on the group size, this may take a while. We use a hard limit of 50 pages for sanity reasons, otherwise
		// the whole process might time out.
		$group = fetch_group_info($vbulletin->options['stc_secondary_group_id'], 50);
		if ($group !== false && in_array($steam_id, $group['members']))
			$stc_additionalgroups []= $vbulletin->options['stc_secondary_group_usergroup'];
	}

	if ($vbulletin->options['stc_secondary_usergroup'] && $vbulletin->options['stc_secondary_usergroup'] != 6) {
		$stc_additionalgroups []= $vbulletin->options['stc_secondary_usergroup'];
	}

	$userdata_rank->set('steam_link', $vbulletin->db->escape_string($steam_id).'|0|0');
	$userdata_rank->set('steam_code', calc_steam_code($steam_id));

	$stc_newgroups = explode(',',$userdata_rank->fetch_field('membergroupids'));
	if (!empty($stc_additionalgroups)) {
		$stc_newgroups = array_merge($stc_newgroups, $stc_additionalgroups);
		$stc_newgroups = array_unique($stc_newgroups);
		stc_log_action(sprintf("User #%d linked, changed old groups from [%s] to [%s]",$vbulletin->userinfo['userid'],
			$userdata_rank->fetch_field('membergroupids'),
			implode(',',$stc_newgroups)
			));
	}
	$userdata_rank->set('membergroupids', implode(',',$stc_newgroups));

	($hook = vBulletinHook::fetch_hook('stc_linkuser_complete')) ? eval($hook) : false;

	$userdata_rank->save();
	stc_log_action(sprintf("Created a link for user #%d with steam_id %s",$vbulletin->userinfo['userid'],$steam_id));

	$vbulletin->url = fetch_seo_url('forumhome', array());

	print_standard_redirect(fetch_error('stc_link_success'), false, true, $vbulletin->userinfo['languageid']);
	exit();
}

// ############################### handle user canceled ###############################
// User canceled the login


if ($openid->mode == 'cancel') {

	eval(standard_error(fetch_error('stc_auth_canceled')));
	exit();

}


// ############################### handle user authenticated ###############################
// validate steamid and fetch steam user infos

$handle_method = '';
if ($openid->validate()) {

	#var_dump($openid);

	$raw_identity = $openid->identity;
	// Fetch the steamid
	$match = array();
	preg_match("#^https?:\/\/steamcommunity\.com\/openid\/id\/(\d+)$#", $raw_identity, $match);
	if (isset($match[1]) && is_numeric($match[1])) {
		$steam_id = $match[1];
	} else {
		eval(standard_error(fetch_error('stc_err_steamid')));
		exit();
	}

	$steam_info = array('steamid'=>$steam_id);
	#var_dump($steam_info);

	if (!empty($vbulletin->options['stc_banned_steamids']) && is_banned_steam_id($steam_info)) {
		stc_log_action(sprintf("Rejected banned steam id: %s with ip: %s",$steam_info['steamid'],$_SERVER['REMOTE_ADDR']));
		$handle_method = 'banned';
	} else {

		$new_userinfo = verify_steam_authentication($steam_info);
		$a_userid = &$new_userinfo['userid'];

		if ($a_userid && empty($vbulletin->userinfo['userid'])) {
			// User is not logged in and we found a user record. So this is a login with the found data
			$handle_method = 'login';
			$vbulletin->userinfo = $new_userinfo;
		}
		elseif ($a_userid && $vbulletin->userinfo['userid'] > 0 && $a_userid != $vbulletin->userinfo['userid']) {
			// User tries to link the steam account to a forum account, but this steam id is already linked with another forum account.
			$handle_method = 'alreadylinked';
		}
		elseif (!$a_userid && $vbulletin->userinfo['userid'] > 0 && empty($vbulletin->userinfo['steam_link'])) {
			// User is logged in but there hasnt been found a associated steam record. So ask him to link those.
			// Only allow linking, if there hasn't already been a steamid associated with this account. otherwise, tell him it's already linked
			$handle_method = 'link';
	 	}
		elseif (!$a_userid && $vbulletin->userinfo['userid'] > 0 && !empty($vbulletin->userinfo['steam_link'])) {
			// User has a SteamID linked and authenticates with a different SteamID while being logged in.
			// Normally we'd offer to link those, but then we'd overwrite the old link.
			// To prevent this, he must unlink his account first to link the account with a new steamid.
	    	$handle_method = 'duplicatelink';
	 	}
		elseif (!$a_userid) {
			// Not logged in and no steam record found, this must be a new user. Show a small register form
			$handle_method = $vbulletin->options['stc_enable_quickreg'] ? 'register' : 'nolink';
		} else {
			$handle_method = 'reject';
			($hook = vBulletinHook::fetch_hook('stc_linkuser_process')) ? eval($hook) : false;
		}
	}

} elseif ((!isset($_POST['do']) && $_POST['do'] == 'addmember') || (!isset($_POST['do']) && $_POST['do'] == 'linkmember')) { // Exclude script calls while registering or linking user

	eval(standard_error(fetch_error('stc_err_login')));
	exit();

}

#var_dump($handle_method);



// ############################### start add member ###############################
// yeah i KNOW its shitty to copypaste the register addmember section. Thank vb for being greedy with hooks.

if ($_POST['do'] == 'addmember')
{
	if (!$vbulletin->options['stc_enable_quickreg']) {
		eval(standard_error(fetch_error('stc_err_quickregdisabled')));
		exit();
	}

	include_once(DIR . '/includes/functions_user.php');

	$vbulletin->input->clean_array_gpc('p', array(
		'agree'               => TYPE_BOOL,
		'options'             => TYPE_ARRAY_BOOL,
		'username'            => TYPE_STR,
		'email'               => TYPE_STR,
		'emailconfirm'        => TYPE_STR,
		'parentemail'         => TYPE_STR,
		'password'            => TYPE_STR,
		'password_md5'        => TYPE_STR,
		'passwordconfirm'     => TYPE_STR,
		'passwordconfirm_md5' => TYPE_STR,
		'referrername'        => TYPE_NOHTML,
		'coppauser'           => TYPE_BOOL,
		'day'                 => TYPE_UINT,
		'month'               => TYPE_UINT,
		'year'                => TYPE_UINT,
		'timezoneoffset'      => TYPE_NUM,
		'dst'                 => TYPE_UINT,
		'userfield'           => TYPE_ARRAY,
		'showbirthday'        => TYPE_UINT,
		'humanverify'         => TYPE_ARRAY
	));

	if (!$vbulletin->steam_softlinks || !is_array($vbulletin->steam_softlinks) || !isset($vbulletin->steam_softlinks[$vbulletin->session->vars['dbsessionhash']]))
	{
		eval(standard_error(fetch_error('stc_err_steamidt', fetch_seo_url('forumhome', array()))));
	}
	else $steam_id = $vbulletin->steam_softlinks[$vbulletin->session->vars['dbsessionhash']];

	if (!$vbulletin->GPC['agree'])
	{
		eval(standard_error(fetch_error('register_not_agreed', fetch_seo_url('forumhome', array()))));
	}

	if (!$vbulletin->options['allowregistration'])
	{
		eval(standard_error(fetch_error('noregister')));
	}

	// check for multireg
	if ($vbulletin->userinfo['userid'] AND !$vbulletin->options['allowmultiregs'])
	{
		eval(standard_error(fetch_error('alreadyregistered', $vbulletin->userinfo['username'], $vbulletin->session->vars['sessionurl'])));
	}

	// check for banned
	if (!empty($vbulletin->options['stc_banned_steamids']) && is_banned_steam_id($steam_info))
	{
		eval(standard_error(fetch_error('stc_err_banned')));
	}

	// init user datamanager class
	$userdata =& datamanager_init('User', $vbulletin, ERRTYPE_ARRAY);

	$vbulletin->GPC['coppauser'] = false;

	$userdata->set_info('coppauser', $vbulletin->GPC['coppauser']);
	$userdata->set_info('coppapassword', $vbulletin->GPC['password']);
	$userdata->set_bitfield('options', 'coppauser', $vbulletin->GPC['coppauser']);
	$userdata->set('parentemail', $vbulletin->GPC['parentemail']);

	// check for missing fields
	if (empty($vbulletin->GPC['username'])
		OR ($vbulletin->options['stc_force_email'] && empty($vbulletin->GPC['email']))  // email optional?
		OR ($vbulletin->options['stc_force_email'] && empty($vbulletin->GPC['emailconfirm']))
		//OR ($vbulletin->GPC['coppauser'] AND empty($vbulletin->GPC['parentemail'])) // coppa not supported...
		//OR (empty($vbulletin->GPC['password']) AND empty($vbulletin->GPC['password_md5'])) // password optional...
		//OR (empty($vbulletin->GPC['passwordconfirm']) AND empty($vbulletin->GPC['passwordconfirm_md5']))
	)
	{
		$userdata->error('fieldmissing');
	}

	// check for matching passwords
	if ($vbulletin->GPC['password'] != $vbulletin->GPC['passwordconfirm'] OR (strlen($vbulletin->GPC['password_md5']) == 32 AND $vbulletin->GPC['password_md5'] != $vbulletin->GPC['passwordconfirm_md5']))
	{
		$userdata->error('passwordmismatch');
	}

	// check for matching email addresses
	if ($vbulletin->GPC['email'] != $vbulletin->GPC['emailconfirm'])
	{
		$userdata->error('emailmismatch');
	}
	if (empty($vbulletin->GPC['email'])) {
		$em_optout = true;
		//$vbulletin->GPC['email'] = 'steam_' . uniqid() . '@example.com'; // just any email adress if the user decided not to specify one
		$userdata->set('email', "''", false, false);
	} else {
		$em_optout = false;
		$userdata->set('email', $vbulletin->GPC['email']);
	}

	$userdata->set('username', $vbulletin->GPC['username']);

	if (empty($vbulletin->GPC['password'])) {
		// Pick any random password so it won't be crackable so easily
    	$userdata->set('password', uniqid($steam_id, true));
    	$pw_optout = true;
	} else {
		// set password
		$userdata->set('password', ($vbulletin->GPC['password_md5'] ? $vbulletin->GPC['password_md5'] : $vbulletin->GPC['password']));
    	$pw_optout = false;
 	}

	// check referrer
	if ($vbulletin->GPC['referrername'] AND !$vbulletin->userinfo['userid'])
	{
		$userdata->set('referrerid', $vbulletin->GPC['referrername']);
	}

	/*/ Human Verification, not neccessary if user is logged into facebook
	if (fetch_require_hvcheck('register') AND (!is_facebookenabled() OR (is_facebookenabled() AND !vB_Facebook::instance()->userIsLoggedIn())))
	{
		require_once(DIR . '/includes/class_humanverify.php');
		$verify =& vB_HumanVerify::fetch_library($vbulletin);
		if (!$verify->verify_token($vbulletin->GPC['humanverify']))
		{
			$userdata->error($verify->fetch_error());
		}
	}*/  // Also not required here, we're working with authenticated steam users.

	// Set specified options
	if (!empty($vbulletin->GPC['options']))
	{
		foreach ($vbulletin->GPC['options'] AS $optionname => $onoff)
		{
			$userdata->set_bitfield('options', $optionname, $onoff);
		}
	}

	// assign user to usergroup 3 if email needs verification
	if (!empty($vbulletin->GPC['email']) && $vbulletin->options['verifyemail']) // Only verify if the user specified an email adress
	{
		$newusergroupid = 3;
	}
	else if ($vbulletin->options['moderatenewmembers'] OR $vbulletin->GPC['coppauser'])
	{
		$newusergroupid = 4;
	}
	else if ($pw_optout || $em_optout)
	{
		// set default steam usergroup if the user did not specify
		$newusergroupid = $vbulletin->options['stc_default_usergroup'] ? (int)$vbulletin->options['stc_default_usergroup'] : 2; // Default to 2=registered users, since steam users can't verify their email adress
	} else {
		// User specified email and password, so lets treat him like a regular user
		$newusergroupid = 2;
	}
	// set usergroupid
	$userdata->set('usergroupid', $newusergroupid);

    $stc_newusergroups = '';
	if ($vbulletin->options['stc_secondary_usergroup'] && $vbulletin->options['stc_secondary_usergroup'] != 6) {
		// set secondary usergroupid
		$stc_newusergroups = $vbulletin->options['stc_secondary_usergroup'];
	}

	if ($vbulletin->options['stc_set_group_usergroup_immediately'] && $vbulletin->options['stc_secondary_group_usergroup']) {
		// Check if the user is member of the specified steam group
		$group = fetch_group_info($vbulletin->options['stc_secondary_group_id'], $vbulletin->options['stc_fetch_max_grouppages'], false, false);
        if ($group !== false) {
            if (in_array($steam_id, $group['members'])) {
				$stc_newusergroups = ensure_secondary_group_membership($stc_newusergroups, $vbulletin->options['stc_secondary_group_usergroup']);
            }
        }
	}

	$userdata->set('membergroupids', $stc_newusergroups);

	// set languageid
	$userdata->set('languageid', $vbulletin->userinfo['languageid']);

	// set user title
	$userdata->set_usertitle('', false, $vbulletin->usergroupcache["$newusergroupid"], false, false);

	// set profile fields
	$customfields = $userdata->set_userfields($vbulletin->GPC['userfield'], true, 'register');

	if (isset($vbulletin->GPC['day'], $vbulletin->GPC['month'], $vbulletin->GPC['year'])) {
		// set birthday
		$userdata->set('showbirthday', $vbulletin->GPC['showbirthday']);
		$userdata->set('birthday', array(
			'day'   => $vbulletin->GPC['day'],
			'month' => $vbulletin->GPC['month'],
			'year'  => $vbulletin->GPC['year']
		));
	}

	// set time options
	$userdata->set_dst($vbulletin->GPC['dst']);
	$userdata->set('timezoneoffset', $vbulletin->GPC['timezoneoffset']);

	// register IP address
	$userdata->set('ipaddress', IPADDRESS);

	// set steam information
	$userdata->set('steam_link', $steam_id.'|'.(int)$em_optout.'|'.(int)$pw_optout);
	$userdata->set('steam_code', calc_steam_code($steam_id));

	($hook = vBulletinHook::fetch_hook('register_addmember_process')) ? eval($hook) : false;

	($hook = vBulletinHook::fetch_hook('stc_addmember_process')) ? eval($hook) : false;

	$userdata->pre_save();

	// check for errors
	if (!empty($userdata->errors))
	{
		$handle_method = 'register';

		$errorlist = '';
		if (!VB_API)
		{
			foreach ($userdata->errors AS $index => $error)
			{
				$errorlist .= "<li>$error</li>";
			}
		}
		else
		{
			$errorlist = $userdata->errors;
		}

		$username = htmlspecialchars_uni($vbulletin->GPC['username']);
		$email = htmlspecialchars_uni($vbulletin->GPC['email']);
		$emailconfirm = htmlspecialchars_uni($vbulletin->GPC['emailconfirm']);
		$parentemail = htmlspecialchars_uni($vbulletin->GPC['parentemail']);
		$selectdst = array($vbulletin->GPC['dst'] => 'selected="selected"');
		$sbselected = array($vbulletin->GPC['showbirthday'] => 'selected="selected"');
		$show['errors'] = true;

		eval(standard_error(fetch_error('stc_err_input', $errorlist)));
		exit();
	}
	else
	{
		$show['errors'] = false;

		// save the data
		$vbulletin->userinfo['userid']
			= $userid
			= $userdata->save();

		if ($userid)
		{
			$userinfo = fetch_userinfo($userid);
			$userdata_rank =& datamanager_init('User', $vbulletin, ERRTYPE_SILENT);
			$userdata_rank->set_existing($userinfo);
			$userdata_rank->set('posts', 0);
			$userdata_rank->save();

			// force a new session to prevent potential issues with guests from the same IP, see bug #2459
			require_once(DIR . '/includes/functions_login.php');
			$vbulletin->session->created = false;
			process_new_login('', false, '');

			// send new user email
			if ($vbulletin->options['newuseremail'] != '')
			{
				$username = $vbulletin->GPC['username'];
				$email = $vbulletin->GPC['email'];

				if ($birthday = $userdata->fetch_field('birthday'))
				{
					$bday = explode('-', $birthday);
					$year = vbdate('Y', TIMENOW, false, false);
					$month = vbdate('n', TIMENOW, false, false);
					$day = vbdate('j', TIMENOW, false, false);
					if ($year > $bday[2] AND $bday[2] > 1901 AND $bday[2] != '0000')
					{
						require_once(DIR . '/includes/functions_misc.php');
						$vbulletin->options['calformat1'] = mktimefix($vbulletin->options['calformat1'], $bday[2]);
						if ($bday[2] >= 1970)
						{
							$yearpass = $bday[2];
						}
						else
						{
							// day of the week patterns repeat every 28 years, so
							// find the first year >= 1970 that has this pattern
							$yearpass = $bday[2] + 28 * ceil((1970 - $bday[2]) / 28);
						}
						$birthday = vbdate($vbulletin->options['calformat1'], mktime(0, 0, 0, $bday[0], $bday[1], $yearpass), false, true, false);
					}
					else
					{
						// lets send a valid year as some PHP3 don't like year to be 0
						$birthday = vbdate($vbulletin->options['calformat2'], mktime(0, 0, 0, $bday[0], $bday[1], 1992), false, true, false);
					}

					if ($birthday == '')
					{
						// Should not happen; fallback for win32 bug regarding mktime and dates < 1970
						if ($bday[2] == '0000')
						{
							$birthday = "$bday[0]-$bday[1]";
						}
						else
						{
							$birthday = "$bday[0]-$bday[1]-$bday[2]";
						}
					}
				}

				if ($userdata->fetch_field('referrerid') AND $vbulletin->GPC['referrername'])
				{
					$referrer = unhtmlspecialchars($vbulletin->GPC['referrername']);
				}
				else
				{
					$referrer = $vbphrase['n_a'];
				}
				$ipaddress = IPADDRESS;
				$memberlink = fetch_seo_url('member|nosession|bburl', array('userid' => $userid, 'username' => htmlspecialchars_uni($vbulletin->GPC['username'])));

				eval(fetch_email_phrases('newuser', 0));

				$newemails = explode(' ', $vbulletin->options['newuseremail']);
				foreach ($newemails AS $toemail)
				{
					if (trim($toemail))
					{
						vbmail($toemail, $subject, $message);
					}
				}
			}

			$username = htmlspecialchars_uni($vbulletin->GPC['username']);
			$email = htmlspecialchars_uni($vbulletin->GPC['email']);

			// sort out emails and usergroups
			if ($vbulletin->options['verifyemail'] && !$em_optout)
			{
				$activateid = build_user_activation_id($userid, (($vbulletin->options['moderatenewmembers'] OR $vbulletin->GPC['coppauser']) ? 4 : 2), 0);

				eval(fetch_email_phrases('activateaccount'));

				vbmail($email, $subject, $message, true);

			}
			else if ($newusergroupid == 2)
			{
				if ($vbulletin->options['welcomemail'])
				{
					eval(fetch_email_phrases('welcomemail'));
					vbmail($email, $subject, $message);
				}
			}

			($hook = vBulletinHook::fetch_hook('register_addmember_complete')) ? eval($hook) : false;

			// Login the new user

			// create new session
			process_new_login('vb', false, '');

			// now redirect the user to the home page
			$vbulletin->url = str_replace('"', '', $vbulletin->url);
			if (!$vbulletin->url)
			{
				$vbulletin->url = fetch_seo_url('forumhome', array());
			}
			else
			{
				$vbulletin->url = iif(strpos($vbulletin->url, 'register.php') !== false, fetch_seo_url('forumhome', array()), $vbulletin->url);
			}

			if ($vbulletin->options['moderatenewmembers'])
			{
				eval(standard_error(fetch_error('moderateuser', $username, fetch_seo_url('forumhome', array())), '', false));
			}
			else
			{
				eval(standard_error(fetch_error('registration_complete', $username,
					$vbulletin->session->vars['sessionurl'], fetch_seo_url('forumhome', array())), '', false));
			}
		} else {
			// log this error if attempting to access the control panel
			require_once(DIR . '/includes/functions_log_error.php');
			log_vbulletin_error(sprintf($vbphrase['stc_err_createlog'], $username,$steam_id), 'security');

			eval(standard_error(fetch_error('stc_err_create')));
		}
		stc_log_action(sprintf("Successfully created new member from steamid %s and ip %s", $userinfo['steam_link'], $_SERVER['REMOTE_ADDR']));
	}
}
else if ($_GET['do'] == 'addmember')
{
	// hmm, this probably happened because of a template edit that put the login box in the header.
	stc_log_action("Tried to access addmember function from a non-post request. This is probably not intendend.");
	exec_header_redirect(fetch_seo_url('forumhome|nosession', array()));
	exit();
}


// ############################### handle login/first register ###############################

if ($handle_method == 'register' || $handle_method == 'link') {
	// User authenticated but register info doesn't exist, so this must be the first time login

	if (!isset($vbulletin->options['stc_apikey']) || empty($vbulletin->options['stc_apikey'])) {
		eval(standard_error(fetch_error('stc_err_apikey')));
		exit();
	}

	// instantiate the data manager class
	$userdata =& datamanager_init('user', $vbulletin, ERRTYPE_ARRAY);
	$userdata->pre_save();

	#echo "Fetching steam info: \n";
	$steam_info = fetch_steam_info($steam_id, $vbulletin->options['stc_apikey']);

	($hook = vBulletinHook::fetch_hook('stc_linkform_start')) ? eval($hook) : false;

	$hash = &$vbulletin->session->vars['dbsessionhash'];

	if (!is_array($vbulletin->steam_softlinks)) $vbulletin->steam_softlinks = array();
	$vbulletin->steam_softlinks[$hash] = $steam_id;
	build_datastore('steam_softlinks', serialize($vbulletin->steam_softlinks), true);
    #var_dump($vbulletin->steam_softlinks);

	$username = strip_tags($steam_info['personaname']);

	$navbits['login2.php' . $vbulletin->session->vars['sessionurl_q']] = $vbphrase['stc_steamconnect'];
	$navbar = render_navbar_template($navbits);

	if ($vbulletin->options['reqbirthday'])
	{
		$show['birthday'] = true;
		$monthselected[str_pad($vbulletin->GPC['month'], 2, '0', STR_PAD_LEFT)] = 'selected="selected"';
		$dayselected[str_pad($vbulletin->GPC['day'], 2, '0', STR_PAD_LEFT)] = 'selected="selected"';
		$year = !$vbulletin->GPC['year'] ? '' : $vbulletin->GPC['year'];

		// Default Birthday Privacy option to show all
		if (empty($errorlist))
		{
			$sbselected = array(2 => 'selected="selected"');
		}
		$templater = vB_Template::create('modifyprofile_birthday');
			$templater->register('birthdate', $birthdate);
			$templater->register('dayselected', $dayselected);
			$templater->register('monthselected', $monthselected);
			$templater->register('sbselected', $sbselected);
			$templater->register('year', $year);
		$birthdayfields = $templater->render();
	}
	else
	{
		$show['birthday'] = false;

		$birthdayfields = '';
	}

	$templater = vB_Template::create('register_steam');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('birthdayfields', $birthdayfields);
		$templater->register('checkedoff', $checkedoff);
		$templater->register('customfields_option', $customfields_option);
		$templater->register('customfields_other', $customfields_other);
		$templater->register('customfields_profile', $customfields_profile);
		$templater->register('day', $day);
		$templater->register('email', $email);
		$templater->register('emailconfirm', $emailconfirm);
		$templater->register('errorlist', $errorlist);
		$templater->register('human_verify', $human_verify);
		$templater->register('month', $month);
		$templater->register('parentemail', $parentemail);
		$templater->register('password', $password);
		$templater->register('passwordconfirm', $passwordconfirm);
		$templater->register('referrername', $referrername);
		$templater->register('timezoneoptions', $timezoneoptions);
		$templater->register('url', $url);
		$templater->register('username', str_replace('"','',$username));
		$templater->register('year', $year);

		$templater->register('linkmode', $handle_method == 'link');
		$templater->register('steam_info', $steam_info);

	($hook = vBulletinHook::fetch_hook('stc_linkform_complete')) ? eval($hook) : false;

	print_output($templater->render());


} elseif ($handle_method == 'login') {

	exec_unstrike_user($vbulletin->GPC['vb_login_username']);

	// create new session
	process_new_login('vb', true, ''); 	// For convenience, we'll set $cookieuser to true, so the user doesn't have to authenticate over and over again.
	set_authentication_cookies(true);	// (Cookieuser means: "remember me next time")

	($hook = vBulletinHook::fetch_hook('stc_loginuser_complete')) ? eval($hook) : false;
	
	$vbulletin->url = fetch_seo_url('forumhome', array());

	// do redirect
	do_login_redirect();

// ############################### most error handling ###############################

} elseif ($handle_method == 'reject') {

	eval(standard_error(fetch_error('stc_err_reject', $vbulletin->userinfo['username'])));
	exit();


} elseif ($handle_method == 'alreadylinked') {

	eval(standard_error(fetch_error('stc_err_alreadylinked')));
	exit();


} elseif ($handle_method == 'duplicatelink') {

	eval(standard_error(fetch_error('stc_err_duplicatelink')));
	exit();


} elseif ($handle_method == 'nolink') {

	eval(standard_error(fetch_error('stc_err_nolink')));
	exit();

} elseif ($handle_method == 'banned') {

	eval(standard_error(fetch_error('stc_err_banned')));
	exit();

} else {

	eval(standard_error(fetch_error('stc_err_default')));
	exit();

}

?>