<?php if (!defined('VB_ENTRY')) die('Access denied.');
/*======================================================================*\
|| #################################################################### ||
|| # vBGamEz 4.0.4 Lite
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2008-2009 GiveMeABreak. All Rights Reserved.            ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBGAMEZ IS NOT FREE SOFTWARE ------------------ # ||
|| # http://vbgamez.cyber-worlds.cn | http://cyber-worlds.cn          # ||
|| #################################################################### ||
\*======================================================================*/

/**
 * VBGamEz  
 *
 * @package vBGamEz
 * @author GiveMeABreak aka Developer, LGSL author
 * @version $Revision: 277 $
 * @copyright GiveMeABreak
 */

class vB_vBGamez extends vB_vBGamez_Datastore
{
	 /*========================================================================
         * 
	 *   
	 *
	 */

         public static function fetch_player_fields_names($value)
         {
            global $vbphrase;

            $fields_names = array("name" => $vbphrase['username'],
                                  "score" => $vbphrase['vbgamez_frags'],
                                  "deaths" => $vbphrase['vbgamez_deaths'],
                                  "team" => $vbphrase['vbgamez_team'],
                                  "ping" => $vbphrase['vbgamez_ping'],
                                  "bot" => $vbphrase['vbgamez_bot'],
                                  "time" => $vbphrase['time'], 
                                  "teamindex" => "Team Index",
                                  "teamindex" => "Team Index",
                                  "pid" => "Pid",
                                  "pbguid" => "Pbguid");

           return $fields_names[$value];
         }

	 /*========================================================================
         * 
	 *  
	 *
	 */

         public static function fetch_player_fields($server)
         {

              $fields_show  = array("name", "score", "deaths", "team", "ping", "bot", "time");
              $fields_hide  = array("teamindex", "pid", "pbguid");

              $fields_other = true;

              $fields_list = array();

              if (!is_array($server['p']))
              {
                      return $fields_list;
              }

              foreach ($server['p'] as $player)
              {
                      foreach ($player as $field => $value)
                      {
                              if ($value === "")
                              {
                                             continue;
                              }

                              if (in_array($field, $fields_list))
                              {
                                              continue;
                              }

                              if (in_array($field, $fields_hide))
                              {
                                               continue;
                              }

                              $fields_list[] = $field;
                      }
              }

              $fields_show = array_intersect($fields_show, $fields_list);

              if ($fields_other == FALSE)
              {
                           return $fields_show;
              }

              $fields_list = array_diff($fields_list, $fields_show);

              return array_merge($fields_show, $fields_list);

         }


	 /*========================================================================
         *
	 *   
	 *
	 */

         public static function parse_game($game)
         {

              return preg_replace("/[^A-Za-z0-9_]/", "_", strtolower($game));

         }

	 /*========================================================================
         *
	 *  stylevars
	 *
	 */

         public static function fetch_stylevars()
         {

           if(!vB_Template_Runtime::fetchStyleVar('imgdir_statusicon'))
           {
                   vB_Template_Runtime::addStyleVar('imgdir_statusicon', 'images/statusicon');
           }

           if(!vB_Template_Runtime::fetchStyleVar('imgdir_misc'))
           {
                   vB_Template_Runtime::addStyleVar('imgdir_misc', 'images/misc');
           }

         }

	 /*========================================================================
         *
	 *  
	 *
	 */

         public static function sanitize_perpage($perpage, $max, $default = 25)
         {
	       $perpage = intval($perpage);

	       if ($perpage == 0)
	       {
		       return $default;
	       }
	       else if ($perpage < 1)
	       {
		       return 1;
	       }
	       else if ($perpage > $max)
	       {
		       return $max;
	       }
	       else
	       {
		       return $perpage;
	       }
         }

	 /*========================================================================
         *
	 *  
	 *
	 */

         public static function vbgamez_charset_detect($server)
         {
                    if (!function_exists("mb_detect_encoding")) { return "AUTO"; }

                    $test = $server['s']['name'];

                    if (is_array($server['p']))
                    {
                      foreach ($server['p'] as $player)
                      {
                        $test .= " {$player['name']}";
                      }
                    }

                    $charset = @mb_detect_encoding($server['s']['name'], "UTF-8, Windows-1252, ISO-8859-1, ISO-8859-15");

                    return $charset ? $charset : "AUTO";
         }

	 /*========================================================================
         *
	 *    
	 *
	 */

         public static function vbgamez_charset_convert($server, $charset)
         {
                  if (!function_exists("mb_convert_encoding")) { return $server; }

                  if (is_array($server))
                  {
                    foreach ($server as $key => $value)
                    {
                      $server[$key] = vB_vBGamez::vbgamez_charset_convert($value, $charset);
                    }
                  }else{

                    $server = @mb_convert_encoding($server, "UTF-8", $charset);

                  }

               return $server;
         }

	 /*========================================================================
         *
	 *  ID     
	 *
	 */

	 public static function vbgamez_verify_id($id, $skipcheck = false)
	 {
                  if($skipcheck == true)
                  {
                                           if(!can_administer())
                                           {
                                                   $where_sql_query = " AND disabled = 0 AND valid = 0 ";
                                           }
                  }

                  $query = vB::$vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "vbgamez WHERE id = '" . intval($id) . "' " . $where_sql_query . " LIMIT 1");
                  return vB::$vbulletin->db->fetch_array($query);
	 }

	 /*========================================================================
         *
	 *   
	 *
	 */

          public static function vbgamez_string_html($string)
          {
            if (function_exists("mb_convert_encoding")) // REQUIRES http://php.net/mbstring
            {
              $string = htmlspecialchars($string, ENT_QUOTES);
              $string = @mb_convert_encoding($string, "HTML-ENTITIES", "UTF-8");

            }else{

              $string = htmlentities($string, ENT_QUOTES);
            }

             return $string;
          }

	 /*========================================================================
         *
	 *     
	 *
	 */

          public static function vbgamez_server_html($server)
          {

           if (isset($server['e']) && is_array($server['e']))
           {
             foreach ($server['e'] as $key => $value)
             {
               $server['e'][$key] = vB_vBGamez::vbgamez_word_wrap($value, 90);
             }
           }

           foreach ($server as $key => $value)
           {
             $server[$key] = is_array($value) ? vB_vBGamez::vbgamez_server_html($value) : vB_vBGamez::vbgamez_string_html($value);
           }

           return $server;
         }


	 /*========================================================================
         *
	 *  
	 *
	 */

         public static function vbgamez_word_wrap($string, $length_limit)
         {
           $words = explode(" ", $string);

           foreach ($words as $word)
           {
             $word_length = function_exists("mb_strlen") ? mb_strlen($word, "UTF-8") : strlen($word);

             if ($word_length < $length_limit)
             {
               $words_new[] = $word;
             }
             else
             {
               for ($i=0; $i<$word_length; $i+=$length_limit)
               {
                 $words_new[] = function_exists("mb_substr") ? mb_substr($word, $i, $length_limit, "UTF-8") : substr($word, $i, $length_limit);
               }
             }
           }

           return implode(" ",       $words_new);

        }


	 /*========================================================================
         *
	 *     
	 *
	 */

         public static function vbgamez_timer($action)
         {
                  global $vbgamez_timer;
                  global $vbulletin;

           if (!$vbgamez_timer)
           {
             $microtime  = microtime();
             $microtime  = explode(' ', $microtime);
             $microtime  = $microtime[1] + $microtime[0];
             $vbgamez_timer = $microtime - 0.01;
           }

           $time_limit = intval($vbulletin->options['vbgamez_time']);
           $time_php   = ini_get("max_execution_time");

           if ($time_limit > $time_php)
           {
             @set_time_limit($time_limit + 5);

             $time_php = ini_get("max_execution_time");

             if ($time_limit > $time_php)
             {
               $time_limit = $time_php - 5;
             }
           }

           if ($action == "limit")
           {
             return $time_limit;
           }

           $microtime  = microtime();
           $microtime  = explode(' ', $microtime);
           $microtime  = $microtime[1] + $microtime[0];
           $time_taken = $microtime - $vbgamez_timer;

           if ($action == "check")
           {
             return ($time_taken > $time_limit) ? TRUE : FALSE;
           }
           else
           {
             return round($time_taken, 2);
           }
         }

	 /*========================================================================
         *
	 *    
	 *
	 */

         public static function vbgamez_server_misc($server)
         {
           $misc['icon_game']          = vB_vBGamez::vbgamez_icon_game($server['b']['type'], $server['s']['game']);

           $misc['image_map']          = vB_vBGamez::vbgamez_image_map($server['b']['status'], $server['b']['type'], $server['s']['game'], $server['s']['map']);
           $misc['image_map_password'] = vB_vBGamez::vbgamez_image_map_password($server['b']['status'], $server['s']['password']);

           $misc['text_status']        = vB_vBGamez::vbgamez_text_status($server['b']['status'], $server['s']['password'], $server['b']['pending']);
           $misc['text_type_game']     = vB_vBGamez::vbgamez_text_type_game($server['b']['type'], $server['s']['game']);
           $misc['image_status']       = vB_vBGamez::vbgamez_image_status($server['b']['status'], $server['s']['password'], $server['b']['pending']);
       
           return $misc;
         }       

	 /*========================================================================
         *
	 *    
	 *
	 */

         public static function vbgamez_icon_game($type, $game)
         {

           $type = preg_replace("/[^A-Za-z0-9_]/", "_", strtolower($type));
           $game = preg_replace("/[^A-Za-z0-9_]/", "_", strtolower($game));


           $location = array(
           "images/vbgamez/icons/{$type}/{$game}.gif",
           "images/vbgamez/icons/{$type}/{$game}.png",
           "images/vbgamez/icons/{$type}/{$type}.gif",
           "images/vbgamez/icons/{$type}/{$type}.png");

           foreach ($location as $path)
           {
             if (file_exists($path)) { return vB::$vbulletin->options['bburl']."/".$path; }
           }

             //  Stylevar'
             vB_vBGamez::fetch_stylevars();

             if(file_exists(vB_Template_Runtime::fetchStyleVar('imgdir_misc').'/question_icon.gif'))
             {
                       return vB::$vbulletin->options['bburl']."/".vB_Template_Runtime::fetchStyleVar('imgdir_misc').'/question_icon.gif';
             }else{
                       return vB::$vbulletin->options['bburl'].'/images/misc/question_icon.gif';
             }

         }

	 /*========================================================================
         *
	 *   
	 *
	 */

         public static function vbgamez_image_status($status, $password, $pending = 0)
         {

           //  Stylevar'
           vB_vBGamez::fetch_stylevars();

           if ($pending)
           {
                       return vB::$vbulletin->options['bburl']."/".vB_Template_Runtime::fetchStyleVar('imgdir_statusicon').'/user-invisible.png';
           }

           if (!$status)
           {
                       return vB::$vbulletin->options['bburl']."/".vB_Template_Runtime::fetchStyleVar('imgdir_statusicon').'/user-offline.png';
           }

           if ($password)
           {
                       return vB::$vbulletin->options['bburl']."/".vB_Template_Runtime::fetchStyleVar('imgdir_statusicon').'/user-invisible.png';
           }

           return vB::$vbulletin->options['bburl']."/".vB_Template_Runtime::fetchStyleVar('imgdir_statusicon').'/user-online.png';
         }

	 /*========================================================================
         *
	 *   
	 *
	 */

         public static function vbgamez_image_map($status, $type, $game, $map, $check_exists = TRUE)
         {
                  global $vbulletin, $vbphrase;

           if (!$status)
           {
             return vB::$vbulletin->options['bburl']."/images/vbgamez/map_no_response.jpg";
           }

           $type = preg_replace("/[^A-Za-z0-9_]/", "_", strtolower($type));
           $game = preg_replace("/[^A-Za-z0-9_]/", "_", strtolower($game));
           $map  = preg_replace("/[^A-Za-z0-9_]/", "_", strtolower($map));

           $map = str_replace('$', '_', $map);

           if (file_exists("images/vbgamez/maps/{$type}/{$game}/{$map}.jpg") || $check_exists == FALSE)
           {
             return vB::$vbulletin->options['bburl']."/images/vbgamez/maps/{$type}/{$game}/{$map}.jpg";
           }

           if ($status)
           {
             $location = array(
             "images/vbgamez/maps/{$type}/{$game}/{$map}.jpg",
             "images/vbgamez/maps/{$type}/{$game}/{$map}.gif",
             "images/vbgamez/maps/{$type}/{$game}/{$map}.png",
             "images/vbgamez/maps/{$type}/{$map}.jpg",
             "images/vbgamez/maps/{$type}/{$map}.gif",
             "images/vbgamez/maps/{$type}/{$map}.png",
             "images/vbgamez/maps/{$type}/map_no_image.jpg",
             "images/vbgamez/maps/{$type}/map_no_image.gif",
             "images/vbgamez/maps/{$type}/map_no_image.png",
             "images/vbgamez/map_no_image.jpg");
           }
           else
           {
             $location = array(
             "images/vbgamez/maps/{$type}/map_no_response.jpg",
             "images/vbgamez/maps/{$type}/map_no_response.gif",
             "images/vbgamez/maps/{$type}/map_no_response.png",
             "images/vbgamez/map_no_response.jpg");
           }

           foreach ($location as $path)
           {
             if (file_exists($path)) { return vB::$vbulletin->options['bburl']."/".$path; }
           }

           return vB::$vbulletin->options['bburl']."/images/vbgamez/map_no_image.jpg";
         }

	 /*========================================================================
         *
	 *     
	 *
	 */

         public static function vbgamez_image_map_password($status, $password)
         {

           if (!$password || !$status)
           {
             return vB::$vbulletin->options['bburl']."/images/vbgamez/map_overlay.gif";
           }

           return vB::$vbulletin->options['bburl']."/images/vbgamez/map_overlay_password.gif";
         }

	 /*========================================================================
         *
	 *   
	 *
	 */

         public static function vbgamez_text_status($status, $password, $pending = 0)
         {
                global $vbulletin, $vbphrase;

           if ($pending)
           {
             return $vbphrase['vbgamez_wait_connect'];
           }

           if (!$status)
           {
             return $vbphrase['vbgamez_server_offline'];
           }

           if ($password)
           {
             return $vbphrase['vbgamez_server_online_with_password'];
           }

           return $vbphrase['vbgamez_server_online'];
         }       

	 /*========================================================================
         *
	 *    
	 *
	 */

         public static function vbgamez_text_type_game($type, $game)
         {
           global $vbulletin, $vbphrase;

           return $vbphrase['vbgamez_type'].": {$type} ".$vbphrase['vbgamez_game']." {$game}";
         }


	 /*========================================================================
         *
	 *   
	 *
	 */

         public static function vbgamez_name_filtered($name)
         {
           $name = preg_replace("/[^\x20-\x7E]/", "", $name); // x20-x7E IS HEX FOR ASCII RANGE
           $name = vbgamez_string_html($name);

           return $name;
         }
}

?>
