<?php
/*======================================================================*\
|| #################################################################### ||
|| # U.S. Military Life                                               # ||
|| # Staff Application 4.2.0.0                                        # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright  U.S. Military Life 2012                              # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # http://www.USMilitaryLife.com                                    # ||
|| #################################################################### ||
\*======================================================================*/

// #######################################################################
// ####################### SET PHP ENVIRONMENT ###########################
// #######################################################################

error_reporting(E_ALL & ~E_NOTICE);

// #######################################################################
// #################### DEFINE IMPORTANT CONSTANTS #######################
// #######################################################################

define('THIS_SCRIPT', 'staff-application');
define('CSRF_PROTECTION', true);

// #######################################################################
// ################### PRE-CACHE TEMPLATES AND DATA ######################
// #######################################################################

$phrasegroups = array();

$specialtemplates = array();

$globaltemplates = array(
    'usml_staff_application',
    'humanverify'
);

$actiontemplates = array();

// #######################################################################
// ######################### REQUIRE BACK-END ############################
// #######################################################################

require_once('./global.php');
require_once(DIR . '/includes/functions_staff-application.php');

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

$navbits = construct_navbits(array('' => 'Staff Application'));

$navbar = render_navbar_template($navbits);
$pagetitle = 'Staff Application';

$imp_vars = array(
    'do' => $_REQUEST['do']
);

$pages = array(
    'main',
    'send'
);

if (!in_array($imp_vars['do'], $pages)) { $imp_vars['do'] = 'main'; }

$addresses = explode(',', $vbulletin->options['usml_staffapp_notifyemail']);
$usml_days_registered = floor((TIMENOW - $vbulletin->userinfo['joindate']) / 86400);

if (!$vbulletin->options['usml_staffapp_onoff'])
{
    standard_error(fetch_error('usml_staffapp_disabled'));
}
if (!($permissions['usmlsaperms'] & $vbulletin->bf_ugp['usmlsaperms']['cansubmitstaffapp']))
{
    print_no_permission();
}
if ($vbulletin->userinfo['posts'] < $vbulletin->userinfo['permissions']['staffappminpostreq'] & $vbulletin->userinfo['reputation'] < $vbulletin->userinfo['permissions']['staffappminrepreq'] & floor((TIMENOW - $vbulletin->userinfo['joindate']) / 86400) < $vbulletin->userinfo['permissions']['staffappminregreq'])
{
    standard_error(fetch_error('usml_staffapp_post_rep_register_permissions', $vbulletin->userinfo['username'], $vbulletin->userinfo['permissions']['staffappminpostreq'], $vbulletin->userinfo['permissions']['staffappminrepreq'], $vbulletin->userinfo['permissions']['staffappminregreq'], $vbulletin->userinfo['posts'], $vbulletin->userinfo['reputation'], $usml_days_registered));
}
else if ($vbulletin->userinfo['posts'] < $vbulletin->userinfo['permissions']['staffappminpostreq'] & $vbulletin->userinfo['reputation'] < $vbulletin->userinfo['permissions']['staffappminrepreq'])
{
    standard_error(fetch_error('usml_staffapp_post_rep_permissions', $vbulletin->userinfo['username'], $vbulletin->userinfo['permissions']['staffappminpostreq'], $vbulletin->userinfo['permissions']['staffappminrepreq'], $vbulletin->userinfo['posts'], $vbulletin->userinfo['reputation']));
}
else if ($vbulletin->userinfo['posts'] < $vbulletin->userinfo['permissions']['staffappminpostreq'] & floor((TIMENOW - $vbulletin->userinfo['joindate']) / 86400) < $vbulletin->userinfo['permissions']['staffappminregreq'])
{
    standard_error(fetch_error('usml_staffapp_post_register_permissions', $vbulletin->userinfo['username'], $vbulletin->userinfo['permissions']['staffappminpostreq'], $vbulletin->userinfo['permissions']['staffappminregreq'], $vbulletin->userinfo['posts'], $usml_days_registered));
}
else if ($vbulletin->userinfo['reputation'] < $vbulletin->userinfo['permissions']['staffappminrepreq'] & floor((TIMENOW - $vbulletin->userinfo['joindate']) / 86400) < $vbulletin->userinfo['permissions']['staffappminregreq'])
{
    standard_error(fetch_error('usml_staffapp_rep_register_permissions', $vbulletin->userinfo['username'], $vbulletin->userinfo['permissions']['staffappminrepreq'], $vbulletin->userinfo['permissions']['staffappminregreq'], $vbulletin->userinfo['reputation'], $usml_days_registered));
}
else if ($vbulletin->userinfo['posts'] < $vbulletin->userinfo['permissions']['staffappminpostreq'])
{
    standard_error(fetch_error('usml_staffapp_post_permissions', $vbulletin->userinfo['username'], $vbulletin->userinfo['permissions']['staffappminpostreq'], $vbulletin->userinfo['posts']));
}
else if ($vbulletin->userinfo['reputation'] < $vbulletin->userinfo['permissions']['staffappminrepreq'])
{
    standard_error(fetch_error('usml_staffapp_rep_permissions', $vbulletin->userinfo['username'], $vbulletin->userinfo['permissions']['staffappminrepreq'], $vbulletin->userinfo['reputation']));
}
else if (floor((TIMENOW - $vbulletin->userinfo['joindate']) / 86400) < $vbulletin->userinfo['permissions']['staffappminregreq'])
{
    standard_error(fetch_error('usml_staffapp_register_permissions', $vbulletin->userinfo['username'], $vbulletin->userinfo['permissions']['staffappminregreq'], $usml_days_registered));
}

// #######################################################################
// ############################# MAIN SCRIPT #############################
// #######################################################################

if ($imp_vars['do'] == 'main')
{
    $vbgpc = array(
        'positionapplying' => '',
        'forumids'         => '',
        'username'         => '',
        'othernames'       => '',
        'firstname'        => '',
        'lastname'         => '',
        'birthday'         => '',
        'location'         => '',
        'whyhelp'          => '',
        'skills'           => '',
        'backend'          => '',
        'knowoptions'      => '',
        'moderateothers'   => '',
        'forumnames'       => '',
        'modlength'        => '',
        'everresigned'     => '',
        'resreason'        => '',
        'addlinfo'         => '',
        'contactemail'     => '',
        'contactphone'     => '',
        'humanverify'      => ''
    );

    $forumids = usml_construct_forum_options(usml_construct_forum_chooser());

    if ($vbulletin->userinfo['permissions']['usmlsaperms'] & $vbulletin->bf_ugp_usmlsaperms['staffappreqhv'])
    {
        require_once(DIR . '/includes/class_humanverify.php');
        $verify =& vB_HumanVerify::fetch_library($vbulletin);
        $human_verify = $verify->output_token();
    }

    $templater = vB_Template::create('usml_staff_application');
        $templater->register_page_templates();
        $templater->register('navbar', $navbar);
        $templater->register('navbits', $navbits);
        $templater->register('pagetitle', $pagetitle);
        $templater->register('imp_vars', $imp_vars);
        $templater->register('pages', $pages);
        $templater->register('pos1', $vbulletin->options[usml_staffapp_position_1]);
        $templater->register('pos2', $vbulletin->options[usml_staffapp_position_2]);
        $templater->register('pos3', $vbulletin->options[usml_staffapp_position_3]);
        $templater->register('pos4', $vbulletin->options[usml_staffapp_position_4]);
        $templater->register('pos5', $vbulletin->options[usml_staffapp_position_5]);
        $templater->register('pos6', $vbulletin->options[usml_staffapp_position_6]);
        $templater->register('pos7', $vbulletin->options[usml_staffapp_position_7]);
        $templater->register('pos8', $vbulletin->options[usml_staffapp_position_8]);
        $templater->register('pos9', $vbulletin->options[usml_staffapp_position_9]);
        $templater->register('pos10', $vbulletin->options[usml_staffapp_position_10]);
        $templater->register('human_verify', $human_verify);
        $templater->register('vbgpc', $vbgpc);
        $templater->register('error', $error);
        $templater->register('errors', $errors);
        $templater->register('error_info', $error_info);
        $templater->register('new_errors', $new_errors);
        $templater->register('submit', $submit);
        $templater->register('forumids', $forumids);
    print_output($templater->render());
}

if ($imp_vars['do'] == 'send')
{
    $vbulletin->input->clean_array_gpc('p', array(
        'positionapplying' => TYPE_NOHTML,
        'forumids'         => TYPE_ARRAY_UINT,
        'username'         => TYPE_NOHTML,
        'othernames'       => TYPE_NOHTML,
        'firstname'        => TYPE_NOHTML,
        'lastname'         => TYPE_NOHTML,
        'birthday'         => TYPE_NOHTML,
        'location'         => TYPE_NOHTML,
        'whyhelp'          => TYPE_NOHTML,
        'skills'           => TYPE_NOHTML,
        'backend'          => TYPE_NOHTML,
        'knowoptions'      => TYPE_NOHTML,
        'moderateothers'   => TYPE_NOHTML,
        'forumnames'       => TYPE_NOHTML,
        'modlength'        => TYPE_NOHTML,
        'everresigned'     => TYPE_NOHTML,
        'resreason'        => TYPE_NOHTML,
        'addlinfo'         => TYPE_NOHTML,
        'contactemail'     => TYPE_STR,
        'contactphone'     => TYPE_NOHTML,
        'humanverify'      => TYPE_ARRAY
    ));

    $forumids = usml_construct_forum_options(usml_construct_forum_chooser());

    $errors = array();
    $error_info = '';

    if ($vbulletin->userinfo['permissions']['usmlsaperms'] & $vbulletin->bf_ugp_usmlsaperms['staffappreqhv'])
    {
        require_once(DIR . '/includes/class_humanverify.php');
        $verify =& vB_HumanVerify::fetch_library($vbulletin);
        $human_verify = $verify->output_token();
    }

    $vbgpc =& $vbulletin->GPC;

    if (empty($vbulletin->GPC['positionapplying'])) { $errors[] = fetch_error('usml_staffapp_position'); }
    if (empty($vbulletin->GPC['forumids'])) { $errors[] = fetch_error('usml_staffapp_forumids'); }
    if (empty($vbulletin->GPC['firstname'])) { $errors[] = fetch_error('usml_staffapp_firstname'); }
    if (empty($vbulletin->GPC['lastname'])) { $errors[] = fetch_error('usml_staffapp_lastname'); }
    if (empty($vbulletin->GPC['birthday'])) { $errors[] = fetch_error('usml_staffapp_birthday'); }
    if (empty($vbulletin->GPC['location'])) { $errors[] = fetch_error('usml_staffapp_location'); }
    if (empty($vbulletin->GPC['whyhelp'])) { $errors[] = fetch_error('usml_staffapp_whyhelp', $vbulletin->options['bbtitle']); }
    if (empty($vbulletin->GPC['skills'])) { $errors[] = fetch_error('usml_staffapp_skills', $vbulletin->options['bbtitle']); }
    if (empty($vbulletin->GPC['backend'])) { $errors[] = fetch_error('usml_staffapp_backend'); }
    if (empty($vbulletin->GPC['knowoptions'])) { $errors[] = fetch_error('usml_staffapp_knowoptions'); }
    if (empty($vbulletin->GPC['moderateothers'])) { $errors[] = fetch_error('usml_staffapp_moderateothers'); }
    if ($vbulletin->GPC['moderateothers'] == 'Yes' & empty($vbulletin->GPC['forumnames'])) { $errors[] = fetch_error('usml_staffapp_forumnames'); }
    if ($vbulletin->GPC['moderateothers'] == 'Yes' & empty($vbulletin->GPC['modlength'])) { $errors[] = fetch_error('usml_staffapp_modlength'); }
    if (empty($vbulletin->GPC['everresigned'])) { $errors[] = fetch_error('usml_staffapp_everresigned'); }
    if ($vbulletin->GPC['everresigned'] == 'Yes' & empty($vbulletin->GPC['resreason'])) { $errors[] = fetch_error('usml_staffapp_resreason'); }
    if (empty($vbulletin->GPC['contactemail']) & empty($vbulletin->GPC['contactphone'])) { $errors[] = fetch_error('usml_staffapp_contactinfo'); }
    if ($vbulletin->userinfo['permissions']['usmlsaperms'] & $vbulletin->bf_ugp_usmlsaperms['staffappreqhv']) { if (!$verify->verify_token($vbulletin->GPC['humanverify'])) { $errors[] = fetch_error('humanverify_image_wronganswer'); } }
    if (empty($vbulletin->GPC['othernames'])) { $vbulletin->GPC['othernames'] = $vbphrase['usml_staffapp_notapplicable']; }
    if ($vbulletin->GPC['moderateothers'] == 'No' & empty($vbulletin->GPC['forumnames'])) { $vbulletin->GPC['forumnames'] = $vbphrase['usml_staffapp_notapplicable']; }
    if ($vbulletin->GPC['moderateothers'] == 'No' & empty($vbulletin->GPC['modlength'])) { $vbulletin->GPC['modlength'] = $vbphrase['usml_staffapp_notapplicable']; }
    if ($vbulletin->GPC['everresigned'] == 'No' & empty($vbulletin->GPC['resreason'])) { $vbulletin->GPC['resreason'] = $vbphrase['usml_staffapp_notapplicable']; }
    if (empty($vbulletin->GPC['addlinfo'])) { $vbulletin->GPC['addlinfo'] = $vbphrase['usml_staffapp_notapplicable']; }
    if (empty($vbulletin->GPC['contactphone']) & !empty($vbulletin->GPC['contactemail'])) { $vbulletin->GPC['contactphone'] = $vbphrase['usml_staffapp_notapplicable']; }
    if (empty($vbulletin->GPC['contactemail']) & !empty($vbulletin->GPC['contactphone'])) { $vbulletin->GPC['contactemail'] = $vbphrase['usml_staffapp_notapplicable']; }

    if ($vbulletin->userinfo['permissions']['usmlsaperms'] & $vbulletin->bf_ugp_usmlsaperms['staffappviewip']) { $ipaddress = IPADDRESS; } else { $ipaddress = $vbphrase['usml_staffapp_restricted']; }
    if ($vbulletin->userinfo['permissions']['usmlsaperms'] & $vbulletin->bf_ugp_usmlsaperms['staffappviewhost']) { $hostname = gethostbyaddr(IPADDRESS); } else { $hostname = $vbphrase['usml_staffapp_restricted']; }

    if (!empty($vbulletin->GPC['forumids']))
    {
        foreach ($vbulletin->GPC['forumids'] AS $forumid)
        {
            $applyingto[] = $vbulletin->forumcache["$forumid"]['title_clean'];
        }
        $applyingto = implode(', ', $applyingto);
    }

    $submit = false;

    if (count($errors) > 0)
    {
        foreach ($errors AS $error)
        {
            $error = str_replace('{vb:raw vboptions.bbtitle}', $vbulletin->options['bbtitle'], $error);
            $new_errors .= $error . "<br />\n";
        }

        $errors = $vbphrase['usml_staffapp_errorsfound'];
        $errors .= $new_errors;

        $submit = false;
    }
    else
    {
        $submit = true;
    }

    if ($submit === true)
    {

	// ####################### START BUILDING MESSAGES #######################

        $subject = construct_phrase($vbphrase['usml_staffapp_subject'], $vbulletin->GPC['positionapplying'], $vbulletin->GPC['username']);
        $posttitle = construct_phrase($vbphrase['usml_staffapp_vote'], $vbulletin->GPC['username'], $vbulletin->GPC['positionapplying']);
        $emailappmsg = "$vbphrase[usml_staffapp_fname]: {$vbulletin->GPC['firstname']}
$vbphrase[usml_staffapp_lname]: {$vbulletin->GPC['lastname']}
$vbphrase[usml_staffapp_posapply]: {$vbulletin->GPC['positionapplying']}
$vbphrase[usml_staffapp_username]: {$vbulletin->GPC['username']}
$vbphrase[usml_staffapp_addlusernames]: {$vbulletin->GPC['othernames']}
$vbphrase[usml_staffapp_bday]: {$vbulletin->GPC['birthday']}
$vbphrase[usml_staffapp_loc]: {$vbulletin->GPC['location']}

$vbphrase[usml_staffapp_applyingto]:
$applyingto

$vbphrase[usml_staffapp_whyhelp] {$vbulletin->options['bbtitle']}?:
{$vbulletin->GPC['whyhelp']}

$vbphrase[usml_staffapp_skills] {$vbulletin->options['bbtitle']}?:
{$vbulletin->GPC['skills']}

$vbphrase[usml_staffapp_backend]: {$vbulletin->GPC['backend']}
$vbphrase[usml_staffapp_knowops]: {$vbulletin->GPC['knowoptions']}
$vbphrase[usml_staffapp_modothers]: {$vbulletin->GPC['moderateothers']}
$vbphrase[usml_staffapp_forumnames]:
{$vbulletin->GPC['forumnames']}

$vbphrase[usml_staffapp_modlength]: {$vbulletin->GPC['modlength']}
$vbphrase[usml_staffapp_everres]: {$vbulletin->GPC['everresigned']}
$vbphrase[usml_staffapp_resreason]:
{$vbulletin->GPC['resreason']}

$vbphrase[usml_staffapp_comments]:
{$vbulletin->GPC['addlinfo']}

$vbphrase[usml_staffapp_email]: {$vbulletin->GPC['contactemail']}
$vbphrase[usml_staffapp_phone]: {$vbulletin->GPC['contactphone']}

$vbphrase[ip_address]: $ipaddress
$vbphrase[usml_staffapp_hostname]: $hostname

$vbphrase[usml_staffapp_greeting]
{$vbulletin->options['bbtitle']}
";

        $postappmsg = "[b]$vbphrase[usml_staffapp_fname]:[/b] {$vbulletin->GPC['firstname']}
[b]$vbphrase[usml_staffapp_lname]:[/b] {$vbulletin->GPC['lastname']}
[b]$vbphrase[usml_staffapp_posapply]:[/b] {$vbulletin->GPC['positionapplying']}
[b]$vbphrase[usml_staffapp_username]:[/b] {$vbulletin->GPC['username']}
[b]$vbphrase[usml_staffapp_addlusernames]:[/b] {$vbulletin->GPC['othernames']}
[b]$vbphrase[usml_staffapp_bday]:[/b] {$vbulletin->GPC['birthday']}
[b]$vbphrase[usml_staffapp_loc]:[/b] {$vbulletin->GPC['location']}

[b]$vbphrase[usml_staffapp_applyingto]:[/b]
$applyingto

[b]$vbphrase[usml_staffapp_whyhelp] {$vbulletin->options['bbtitle']}?:[/b]
{$vbulletin->GPC['whyhelp']}

[b]$vbphrase[usml_staffapp_skills] {$vbulletin->options['bbtitle']}?:[/b]
{$vbulletin->GPC['skills']}

[b]$vbphrase[usml_staffapp_backend]:[/b] {$vbulletin->GPC['backend']}
[b]$vbphrase[usml_staffapp_knowops]:[/b] {$vbulletin->GPC['knowoptions']}
[b]$vbphrase[usml_staffapp_modothers]:[/b] {$vbulletin->GPC['moderateothers']}
[b]$vbphrase[usml_staffapp_forumnames]:[/b]
{$vbulletin->GPC['forumnames']}

[b]$vbphrase[usml_staffapp_modlength]:[/b] {$vbulletin->GPC['modlength']}
[b]$vbphrase[usml_staffapp_everres]:[/b] {$vbulletin->GPC['everresigned']}
[b]$vbphrase[usml_staffapp_resreason]:[/b]
{$vbulletin->GPC['resreason']}

[b]$vbphrase[usml_staffapp_comments]:[/b]
{$vbulletin->GPC['addlinfo']}

[b]$vbphrase[usml_staffapp_email]:[/b] {$vbulletin->GPC['contactemail']}
[b]$vbphrase[usml_staffapp_phone]:[/b] {$vbulletin->GPC['contactphone']}

[b]$vbphrase[ip_address]:[/b] $ipaddress
[b]$vbphrase[usml_staffapp_hostname]:[/b] $hostname

$vbphrase[usml_staffapp_greeting]
{$vbulletin->options['bbtitle']}
";

	// ############################# SEND E-MAIL #############################

        if (!empty($addresses))
        {
            foreach ($addresses AS $address)
            {
                vbmail($address, $subject, $emailappmsg, true, $vbulletin->GPC['webmasteremail']);
            }
        }

	// ###################### CREATE THREAD IF ENABLED #######################

        switch($vbulletin->options['usml_staffapp_createthread'])
        {
            case 1;
                require_once(DIR . '/includes/functions_newpost.php');

                $forumid = $vbulletin->options['usml_staffapp_forumid'];
                $user_id = $vbulletin->userinfo['userid'];
                $username = $vbulletin->userinfo['username'];
                $target_foruminfo = fetch_foruminfo($forumid);
                $newpost = array(
                    'userid'        => $user_id,
                    'username'      => $username,
                    'message'       => $postappmsg,
                    'title'         => $subject,
                    'poststarttime' => TIMENOW,
                    'emailupdate'   => 0
                );

                build_new_post('thread', $target_foruminfo, array(), array(), $newpost, $errors);

                if (sizeof($errors) > 0) { $error_info = construct_errors($errors); }

                require_once(DIR . '/includes/functions_databuild.php');
                build_forum_counters($forumid);
            break;

            case 2;
                require_once(DIR . '/includes/functions_newpost.php');

                $forumid = $vbulletin->options['usml_staffapp_forumid'];
                $user_id = $vbulletin->userinfo['userid'];
                $username = $vbulletin->userinfo['username'];
                $target_foruminfo = fetch_foruminfo($forumid);
                $newpost = array(
                    'userid'        => $user_id,
                    'username'      => $username,
                    'message'       => $postappmsg,
                    'title'         => $subject,
                    'poststarttime' => TIMENOW,
                    'emailupdate'   => 0
                );

                build_new_post('thread', $target_foruminfo, array(), array(), $newpost, $errors);

                $pollpublic = ($vbulletin->options['usml_staffapp_pollpublic']);
                $polloption[1] = ($vbulletin->options['usml_staffapp_polloption1']);
                $polloption[2] = ($vbulletin->options['usml_staffapp_polloption2']);
                if (!empty($vbulletin->options['usml_staffapp_polloption3'])) { $polloption[3] = ($vbulletin->options['usml_staffapp_polloption3']); }
                if (!empty($vbulletin->options['usml_staffapp_polloption4'])) { $polloption[4] = ($vbulletin->options['usml_staffapp_polloption4']); }

                $threadinfo = verify_id('thread', $newpost[threadid], 0, 1);
                $polloptions = count($polloption);
                $question = $posttitle;
                $vbulletin->GPC['options'] = $polloption;
                $counter = 0;
                $optioncount = 0;
                $badoption = '';
                while ($counter++ < $polloptions)
                {
                    if ($vbulletin->options['maxpolllength'] AND vbstrlen($vbulletin->GPC['options']["$counter"]) > $vbulletin->options['maxpolllength'])
                    {
                        $badoption .= iif($badoption, ', ') . $counter;
                    }
                    if (!empty($vbulletin->GPC['options']["$counter"]))
                    {
                        $optioncount++;
                    }
                }

                $poll =& datamanager_init('Poll', $vbulletin, ERRTYPE_STANDARD);
                $counter = 0;
                while ($counter++ < $polloptions)
                {
                    if ($vbulletin->GPC['options']["$counter"] != '')
                    {
                        $poll->set_option($vbulletin->GPC['options']["$counter"]);
                    }
                }

                $poll->set('question',	$question);
                $poll->set('dateline',	TIMENOW);
                $poll->set('active',	'1');
                $poll->set('public',	'1');
                $pollid = $poll->save();
                $threadman = datamanager_init('Thread', $vbulletin, ERRTYPE_STANDARD, 'threadpost');
                $threadman->set_existing($threadinfo);
                $threadman->set('pollid', $pollid);
                $threadman->save();

                if (sizeof($errors) > 0) { $error_info = construct_errors($errors); }

                require_once(DIR . '/includes/functions_databuild.php');
                build_forum_counters($forumid);
            break;

            case 3;
                require_once(DIR . '/includes/functions_newpost.php');

                $forumid = $vbulletin->options['usml_staffapp_forumid'];
                $user_id = $vbulletin->userinfo['userid'];
                $username = $vbulletin->userinfo['username'];
                $target_foruminfo = fetch_foruminfo($forumid);
                $newpost = array(
                    'userid'        => $user_id,
                    'username'      => $username,
                    'message'       => $postappmsg,
                    'title'         => $subject,
                    'poststarttime' => TIMENOW,
                    'emailupdate'   => 0
                );

                build_new_post('thread', $target_foruminfo, array(), array(), $newpost, $errors);

                $pollpublic = ($vbulletin->options['usml_staffapp_pollpublic']);
                $polloption[1] = ($vbulletin->options['usml_staffapp_polloption1']);
                $polloption[2] = ($vbulletin->options['usml_staffapp_polloption2']);
                if (!empty($vbulletin->options['usml_staffapp_polloption3'])) { $polloption[3] = ($vbulletin->options['usml_staffapp_polloption3']); }
                if (!empty($vbulletin->options['usml_staffapp_polloption4'])) { $polloption[4] = ($vbulletin->options['usml_staffapp_polloption4']); }

                $threadinfo = verify_id('thread', $newpost[threadid], 0, 1);
                $polloptions = count($polloption);
                $question = $posttitle;
                $vbulletin->GPC['options'] = $polloption;
                $counter = 0;
                $optioncount = 0;
                $badoption = '';
                while ($counter++ < $polloptions)
                {
                    if ($vbulletin->options['maxpolllength'] AND vbstrlen($vbulletin->GPC['options']["$counter"]) > $vbulletin->options['maxpolllength'])
                    {
                        $badoption .= iif($badoption, ', ') . $counter;
                    }
                    if (!empty($vbulletin->GPC['options']["$counter"]))
                    {
                        $optioncount++;
                    }
                }

                $poll =& datamanager_init('Poll', $vbulletin, ERRTYPE_STANDARD);
                $counter = 0;
                while ($counter++ < $polloptions)
                {
                    if ($vbulletin->GPC['options']["$counter"] != '')
                    {
                        $poll->set_option($vbulletin->GPC['options']["$counter"]);
                    }
                }

                $poll->set('question',	$question);
                $poll->set('dateline',	TIMENOW);
                $poll->set('active',	'1');
                $poll->set('public',	'0');
                $pollid = $poll->save();
                $threadman = datamanager_init('Thread', $vbulletin, ERRTYPE_STANDARD, 'threadpost');
                $threadman->set_existing($threadinfo);
                $threadman->set('pollid', $pollid);
                $threadman->save();

                if (sizeof($errors) > 0) { $error_info = construct_errors($errors); }

                require_once(DIR . '/includes/functions_databuild.php');
                build_forum_counters($forumid);
            break;
        }

	// ######################### CREATE PM IF ENABLED ########################

        switch($vbulletin->options['usml_staffapp_notifypm'])
        {
            case 1;
                require_once(DIR . '/includes/functions_staff-application.php');

                $sendfrom = $vbulletin->db->fetch_array(get_name($vbulletin->userinfo['userid']));
                $blank = array();
                $pmdata =& datamanager_init('PM', $vbulletin, ERRTYPE_SILENT);
                $pmdata->set('fromuserid', $vbulletin->userinfo['userid']);
                $pmdata->set('fromusername', $sendfrom['username']);
                $pmdata->set_recipients($vbulletin->options['usml_staffapp_pmreceive'], $blank);
                $pmdata->set_info('reciept', false);
                $pmdata->set_info('savecopy', false);
                $pmdata->set('title', $subject);
                $pmdata->set('message', $postappmsg);
                $pmdata->set('dateline', TIMENOW);
                $pmdata->set_info('is_automated', true);
                $pmdata->save();
                unset($pmdata);
            break;

            case 2;
                require_once(DIR . '/includes/functions_staff-application.php');

                $sendfrom = $vbulletin->db->fetch_array(get_name($vbulletin->options['usml_staffapp_pmsender']));
                $blank = array();
                $pmdata =& datamanager_init('PM', $vbulletin, ERRTYPE_SILENT);
                $pmdata->set('fromuserid', $vbulletin->options['usml_staffapp_pmsender']);
                $pmdata->set('fromusername', $sendfrom['username']);
                $pmdata->set_recipients($vbulletin->options['usml_staffapp_pmreceive'], $blank);
                $pmdata->set_info('reciept', false);
                $pmdata->set_info('savecopy', false);
                $pmdata->set('title', $subject);
                $pmdata->set('message', $postappmsg);
                $pmdata->set('dateline', TIMENOW);
                $pmdata->set_info('is_automated', true);
                $pmdata->save();
                unset($pmdata);
            break;
        }
        $vbulletin->url = $vbulletin->options['forumhome'] . '.php' . $vbulletin->session->vars['sessionurl_q'];
        eval(print_standard_redirect('usml_staffapp_thanks', true, true));
    }
    else
    {
        $imp_vars['do'] = 'errors';
    }

    $templater = vB_Template::create('usml_staff_application');
        $templater->register_page_templates();
        $templater->register('navbar', $navbar);
        $templater->register('navbits', $navbits);
        $templater->register('pagetitle', $pagetitle);
        $templater->register('imp_vars', $imp_vars);
        $templater->register('pages', $pages);
        $templater->register('pos1', $vbulletin->options[usml_staffapp_position_1]);
        $templater->register('pos2', $vbulletin->options[usml_staffapp_position_2]);
        $templater->register('pos3', $vbulletin->options[usml_staffapp_position_3]);
        $templater->register('pos4', $vbulletin->options[usml_staffapp_position_4]);
        $templater->register('pos5', $vbulletin->options[usml_staffapp_position_5]);
        $templater->register('pos6', $vbulletin->options[usml_staffapp_position_6]);
        $templater->register('pos7', $vbulletin->options[usml_staffapp_position_7]);
        $templater->register('pos8', $vbulletin->options[usml_staffapp_position_8]);
        $templater->register('pos9', $vbulletin->options[usml_staffapp_position_9]);
        $templater->register('pos10', $vbulletin->options[usml_staffapp_position_10]);
        $templater->register('human_verify', $human_verify);
        $templater->register('vbgpc', $vbgpc);
        $templater->register('errors', $errors);
        $templater->register('new_errors', $new_errors);
        $templater->register('error_info', $error_info);
        $templater->register('submit', $submit);
        $templater->register('forumids', $forumids);
    print_output($templater->render());
}

?>