<?php
/*======================================================================*\
|| #################################################################### ||
|| # Copyright  BananaLive Scripts. All Rights Reserved. ############# ||
|| #################################################################### ||
\*======================================================================*/

error_reporting(E_ALL & ~E_NOTICE);
define('THIS_SCRIPT', 'tournaments');
if (!$_REQUEST['do'] || in_array($_REQUEST['do'], array('pmcmpt', 'add', 'new', 'edit', 'editcomment', 'view', 'editrules', 'comment')))
{
define('GET_EDIT_TEMPLATES', true);
}
$phrasegroups = array('posting', 'postbit', 'user', 'timezone', 'global', 'pm', 'reputationlevel', 'search');
$specialtemplates = array(
	'bbcodecache',
	'smiliecache',
	'tll_catcache',
);
$globaltemplates = array(
	'tmnt_shell'
);
$actiontemplates = array(
	'pm' => array(
		'tmnt_threadtemplate'
	),
	'pmcmpt' => array(
		'tmnt_threadtemplate',
		'tmnt_newpm'
	),
	'swapslots' => array(
		'tmnt_swapslots'
	),
	'add' => array(
		'tmnt_new'
	),
	'comment' => array(
		'tmnt_addcomment',
		'tmnt_comment'
	),
	'new' => array(
		'tmnt_new'
	),
	'addplayer' => array(
		'tmnt_newplayer'
	),
	'inserttmnt' => array(
		'tmnt_threadtemplate'
	),
	'edit' => array(
		'tmnt_edit'
	),
	'editrules' => array(
		'tmnt_tmnt_editrules'
	),
	'editcomment' => array(
		'tmnt_editcomment'
	),
	'editplayer' => array(
		'tmnt_editplayer'
	),
	'swapplayer' => array(
		'tmnt_swapplayer'
	),
	'submitloss' => array(
		'tmnt_submitloss'
	),
	'subresults' => array(
		'tmnt_submitted_results'
	),
	'submitresult' => array(
		'tmnt_submitresult',
		'tmnt_submitresult_chooseteam'
	),
	'adminsubmitscores' => array(
		'tmnt_adminsubmitscores'
	),
	'join' => array(
		'tmnt_join'
	),
	'hof' => array(
		'tmnt_hof'
	),
	'view' => array(
		'tmnt_rr_headcell',
		'tmnt_rr_cell',
		'tmnt_ind_sched_bit',
		'tmnt_ind_sched',
		'tmnt_rr_comp',
		'tmnt_rr_comp_alt',
		'tmnt_cmptlms_top',
		'tmnt_cmptlms',
		'tmnt_cmptlms_bot',
		'tmnt_addcomment',
		'tmnt_comment',
		'tmnt_nocomments',
		'tmnt_display',
		'tmnt_cmpt',
		'tmnt_cmpt_none'
	),
	'none' => array(
		'tmnt_cat',
		'tmnt_fpblock_comments',
		'tmnt_fpblock_twins',
		'tmnt_list_top',
		'tmnt_list',
		'tmnt_list_dynamic',
		'tmnt_notmnts',
		'tmnt_list_bot'
	)
);
$actiontemplates['none'] = array_merge($actiontemplates['none'], $actiontemplates['view']);

require_once('./global.php');
require_once(DIR . '/includes/functions.php');
require_once(DIR . '/includes/functions_tal.php');

($hook = vBulletinHook::fetch_hook('tll_tournaments_start')) ? eval($hook) : false;

$tournament = true;
$ladder = false;

$navbits = construct_navbits(array(
	'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
	'tournaments.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['tmnts'],
	'' => construct_phrase('Error')
));
$navbar = render_navbar_template($navbits);

// #############################################################################

if ($_REQUEST['do'] == 'kill')
{
	if (!$tmntp['canedittmnt']) {
		print_no_permission();
	}
    $id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	if (!$id)
	{
		$errormessage = $vbphrase[error_invalid_tournament];
        eval(standard_error($errormessage));
	}
    $vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "tmnt_tmnts WHERE id=$id");
	$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "tmnt_players WHERE tid=$id");
	$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "tmnt_comments WHERE tid=$id");
	build_tll_catcache();
	$vbulletin->url = "tournaments.php";
	eval(print_standard_redirect('redirect_killtmnt'));
}

// #############################################################################

if ($_REQUEST['do'] == 'addslot')
{
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	if (!$id) {
		$errormessage = $vbphrase[error_invalid_tournament];
        eval(standard_error($errormessage));
	}
	$tmnt = $vbulletin->db->query_first("SELECT userid, noplayers, type FROM " . TABLE_PREFIX . "tmnt_tmnts WHERE id=$id ");
	if ($tmnt['noplayers'] > $tmnt_maxde - 1 && $tmnt['type'] == 'de')
	{
		$errormessage = "Error. Double Elimination tournaments can have a maximum of 8 players.";
        eval(standard_error($errormessage));
	}
	if ($tmnt['userid'] != $thisuserid)
	{
		if (!$tmntp['canedittmnt'])
		{
			print_no_permission();
		}
	}
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_tmnts SET noplayers = noplayers+1, freeslots = freeslots+1 WHERE id=$id");
	if ($tmnt['password'])
	{
		$urll = '&password='.$tmnt['password'];
	}
	$vbulletin->url = "tournaments.php?do=view&id=$id".$urll;
	eval(print_standard_redirect('redirect_addedslot'));
}

// #############################################################################

if ($_REQUEST['do'] == 'pm')
{
	if (!$show['member'] || !$tmntp['canviewtmnt']) {
		print_no_permission();
	}
    $id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	if (!$id)
	{
		$errormessage = $vbphrase[error_invalid_tournament];
        eval(standard_error($errormessage));
	}
	require_once('./includes/functions_databuild.php');
	$tmnt = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_tmnts WHERE id=$id ");
	if (!$tmnt)
	{
		$errormessage = $vbphrase['error_invalid_tournament'];
        eval(standard_error($errormessage));
	}
	$fromuserid = $thisuserid;
	$fromusername = $thisusername;
	$title = $tmnt['title'];
	$noplayers = $tmnt['noplayers'];
	$tmnt = switch_tmnt_type($tmnt);
	$date = $tmnt['date'];
	$tmntbbcode = <<<TBB
[u][b]$1:[/b][/u]
$2
TBB;
	$tmnt['description'] = preg_replace('/\[newbox\=(.+?)\](.+?)\[\/newbox\]/is',$tmntbbcode,$tmnt['description']);
	$description = $tmnt['description'];
	$templater = vB_Template::create('tmnt_threadtemplate');
		$templater->register('tmnt', $tmnt);
		$templater->register('description', $description);
		$templater->register('noplayers', $noplayers);
		$templater->register('id', $id);
		$templater->register('fromuserid', $fromuserid);
		$templater->register('fromusername', $fromusername);
		$templater->register('title', $title);
		$templater->register('type', $type);
		$templater->register('date', $date);
	$message = $templater->render();
	$message = preg_replace('/<!--(.|\s)*?-->/', '', $message);
	$recipients = $thisusername;
	//global $vbulletin, $botpermissions;
	$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_ARRAY);
		$pmdm->set('fromuserid', $fromuserid);
		$pmdm->set('fromusername', $fromusername);
		$pmdm->set('title', $title);
		$pmdm->set('message', $message);
		$pmdm->set_recipients($recipients, $botpermissions);
		$pmdm->set('dateline', TIMENOW); 
		$pmdm->overridequota = true;
		$errors = $pmdm->errors;
		if ($errors) {
			foreach ($errors as $error) {
				$errorss .= $error. "<br />";
			}
			$errormessage = $errorss;
			eval(standard_error($errormessage));
		}
		$pmdm->save();
		unset($pmdm);
	$vbulletin->url = "tournaments.php?do=view&id=$id";
	eval(print_standard_redirect('redirect_tmntpm'));
}

// #############################################################################

if ($_REQUEST['do'] == 'pmcmpt')
{
    $id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	if (!$id)
	{
		$errormessage = $vbphrase[error_invalid_tournament];
        eval(standard_error($errormessage));
	}
	$tmnt = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_tmnts WHERE id=$id ");
	if ($tmnt['userid'] != $thisuserid) {
	if (!$tmntp['canedittmnt']) {
		print_no_permission();
	} }
	$fromuserid = $thisuserid;
	$fromusername = $thisusername;
	$title = $tmnt['title'];
	$noplayers = $tmnt['noplayers'];
	$tmnt = switch_tmnt_type($tmnt);
	$type = $tmnt['type'];
	$date = $tmnt['date'];
	$tmntbbcode = <<<TBB
[u][b]$1:[/b][/u]
$2
TBB;
	$tmnt['description'] = preg_replace('/\[newbox\=(.+?)\](.+?)\[\/newbox\]/is',$tmntbbcode,$tmnt['description']);
	$description = $tmnt['description'];
	$templater = vB_Template::create('tmnt_threadtemplate');
	$templater->register('tmnt', $tmnt);
	$templater->register('description', $description);
	$templater->register('noplayers', $noplayers);
	$templater->register('id', $id);
	$templater->register('fromuserid', $fromuserid);
	$templater->register('fromusername', $fromusername);
	$templater->register('title', $title);
	$templater->register('date', $date);
	$message = $templater->render();
	$message = preg_replace('/<!--(.|\s)*?-->/', '', $message);
	$user_names = $vbulletin->db->query_read("SELECT username FROM " . TABLE_PREFIX . "tmnt_players WHERE tid=$id");
	$pmto_users = array();
        while ($name = $vbulletin->db->fetch_array($user_names))
        {
            $pmto_users[] = $name['username'];
        }
        $vbulletin->db->free_result($user_names); 
	$recipients = implode(' ; ', $pmto_users);  
	$show['sendmultiple'] = true;
	$show['parseurl'] = $vbulletin->options['privallowbbcode'];
	require_once(DIR . '/includes/functions_editor.php');
	if ($vbulletin->options['simpleversion'] < 414)
	{
		$editorid = construct_edit_toolbar($message, 0, 'nonforum', iif($vbulletin->options['privallowsmilies'], 1, 0));
	}
	else
	{
		$editorid = construct_edit_toolbar($message);
	}
	$templater = vB_Template::create('tmnt_newpm');
		$templater->register('tmnt', $tmnt);
		$templater->register('description', $description);
		$templater->register('noplayers', $noplayers);
		$templater->register('id', $id);
		$templater->register('fromuserid', $fromuserid);
		$templater->register('fromusername', $fromusername);
		$templater->register('title', $title);
		$templater->register('date', $date);
		$templater->register('editorid', $editorid);
		$templater->register('messagearea', $messagearea);
		$templater->register('postpreview', $postpreview);
		$templater->register('recipients', $recipients);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'tournaments.php?do=view&amp;id=' . $id . $vbulletin->session->vars['sessionurl_q'] => $title,
		'' => construct_phrase($vbphrase['tmnt_pmcmpt'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_POST['do'] == 'updaterules')
{
	if (!$tmntp['canedittmnt'])
	{
		print_no_permission();
	}
	$id = $vbulletin->input->clean_gpc('p', 'id', TYPE_UINT);
	if (!$id)
	{
		$errormessage = $vbphrase[error_invalid_tmnt];
		eval(standard_error($errormessage));
	}
	$tmnt = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_tmnts WHERE id = '$id' ");
	$vbulletin->input->clean_array_gpc('p', array(
		'message'      => TYPE_STR,
		'wysiwyg'			 => TYPE_BOOL,
	));
	if ($vbulletin->GPC['wysiwyg'] && $vbulletin->options['simpleversion'] < 414)
	{
		require_once(DIR . '/includes/functions_wysiwyg.php');
		$rules = convert_wysiwyg_html_to_bbcode($vbulletin->GPC['message'], 1);
	}
	else if ($vbulletin->GPC['wysiwyg'])
	{
		require_once(DIR . '/includes/class_wysiwygparser.php');
		$html_parser = new vB_WysiwygHtmlParser($vbulletin);
		$rules = $html_parser->parse_wysiwyg_html_to_bbcode($vbulletin->GPC['message']);
	}
	else
	{
		$rules = $vbulletin->GPC['message'];
	}
	$description = explode('[rules]',$tmnt['description']);
	$description = $description['0'].'[rules]'.$rules;
	
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "tmnt_tmnts
		SET
			description = '".$vbulletin->db->escape_string($description)."'
		WHERE id = '$id'
	");
	$vbulletin->url = "tournaments.php?do=view&id=$id&sh=6";	
	eval(print_standard_redirect('redirect_updatedtmnt'));
}

// #############################################################################

if ($_POST['do'] == 'rrupdatescores')
{
	$id = $vbulletin->input->clean_gpc('p', 'id', TYPE_UINT);
	if (!$id)
	{
		$errormessage = $vbphrase[error_invalid_tournament];
		eval(standard_error($errormessage));
	}
	$tmnt = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_tmnts WHERE id = '$id' ");
	if (!$tmnt || !in_array($tmnt['type'], array('rr','drr')))
	{
		$errormessage = $vbphrase['error_invalid_tournament'];
		eval(standard_error($errormessage));
	}
	if ($tmnt['userid'] != $thisuserid)
	{
		if (!$tmntp['canedittmnt'])
		{
			print_no_permission();
		}
	}
	$tmnt = rr_get_rounds($tmnt);
	$rounds = array();
	$players = array();
	$ci = 1;
	while ($ci <= $tmnt['rounds'])
	{
		$plx = 'round'.$ci;
		if ($ci == 1)
		{
			$plx = 'round';
		}
		$rounds["$plx"] = $vbulletin->input->clean_gpc('p', "round$ci", TYPE_ARRAY_UINT);
		foreach($rounds["$plx"] AS $userid => $score)
		{
			$players["$userid"]["$plx"] = $score;
		}
		$ci++;
	}	
	foreach ($players AS $userid => $userdata)
	{
		$vbulletin->db->query_write("
			UPDATE " . TABLE_PREFIX . "tmnt_players
				SET round = '".$userdata['round']."',
					round2 = '".$userdata['round2']."',
					round3 = '".$userdata['round3']."',
					round4 = '".$userdata['round4']."',
					round5 = '".$userdata['round5']."',
					round6 = '".$userdata['round6']."',
					round7 = '".$userdata['round7']."',
					round8 = '".$userdata['round8']."',
					round9 = '".$userdata['round9']."',
					round10 = '".$userdata['round10']."',
					round11 = '".$userdata['round11']."',
					round12 = '".$userdata['round12']."',
					round13 = '".$userdata['round13']."',
					round14 = '".$userdata['round14']."',
					round15 = '".$userdata['round15']."',
					round16 = '".$userdata['round16']."',
					round17 = '".$userdata['round17']."',
					round18 = '".$userdata['round18']."',
					round19 = '".$userdata['round19']."',
					round20 = '".$userdata['round20']."',
					round21 = '".$userdata['round21']."',
					round22 = '".$userdata['round22']."',
					round23 = '".$userdata['round23']."',
					round24 = '".$userdata['round24']."',
					round25 = '".$userdata['round25']."',
					round26 = '".$userdata['round26']."',
					round27 = '".$userdata['round27']."',
					round28 = '".$userdata['round28']."',
					round29 = '".$userdata['round29']."',
					round30 = '".$userdata['round30']."',
					round31 = '".$userdata['round31']."',
					round32 = '".$userdata['round32']."'
			WHERE tid='".$id."'
				AND userid='".$userid."'
			");
	}
	$vbulletin->url = "tournaments.php?do=view&id=".$id."&sh=2";	
	eval(print_standard_redirect('redirect_tmnt'));
}

// #############################################################################

if ($_POST['do'] == 'insertpmcmpt')
{
    $id = $vbulletin->input->clean_gpc('p', 'id', TYPE_UINT);
	$tmnt = $vbulletin->db->query_first("SELECT userid FROM " . TABLE_PREFIX . "tmnt_tmnts WHERE id=$id ");
	if ($tmnt['userid'] != $thisuserid) {
	if (!$tmntp['canedittmnt']) {
		print_no_permission();
	} }
	$title = $vbulletin->input->clean_gpc('p', 'title', TYPE_NOHTML);
	$title = addslashes($title);
		if (!$title)
		{
			$errormessage = $vbphrase[error_invalid_title];
        	eval(standard_error($errormessage));
		}
	$vbulletin->input->clean_array_gpc('p', array(
		'message'      => TYPE_STR,
		'wysiwyg'			 => TYPE_BOOL,
		'recipients'     => TYPE_STR,
	));
	if ($vbulletin->GPC['wysiwyg'] && $vbulletin->options['simpleversion'] < 414)
	{
		require_once(DIR . '/includes/functions_wysiwyg.php');
		$description = convert_wysiwyg_html_to_bbcode($vbulletin->GPC['message'], 1);
	}
	else if ($vbulletin->GPC['wysiwyg'])
	{
		require_once(DIR . '/includes/class_wysiwygparser.php');
		$html_parser = new vB_WysiwygHtmlParser($vbulletin);
		$description = $html_parser->parse_wysiwyg_html_to_bbcode($vbulletin->GPC['message']);
	}
	else
	{
		$description = $vbulletin->GPC['message'];
	}
	if (!$description)
	{
		$errormessage = $vbphrase[error_invalid_message];
		eval(standard_error($errormessage));
	}
	$message = $description;
	$recipients = $vbulletin->GPC['recipients'];
	$fromuserid = $thisuserid;
	$fromusername = $thisusername;
	require_once('./includes/functions_databuild.php');
	global $vbulletin, $botpermissions;
	$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_ARRAY);
		$pmdm->set('fromuserid', $fromuserid);
		$pmdm->set('fromusername', $fromusername);
		$pmdm->set('title', $title);
		$pmdm->set('message', $message);
		$pmdm->set_recipients($recipients, $botpermissions);
		$pmdm->set('dateline', TIMENOW);
		$pmdm->overridequota = true;
		$errors = $pmdm->errors;
		if ($errors) {
			foreach ($errors as $error) {
				$errorss .= $error. "<br />";
			}
			$errormessage = $errorss;
			eval(standard_error($errormessage));
		}
		$pmdm->save();
		unset($pmdm);
	$vbulletin->url = "tournaments.php?do=view&id=$id";
	eval(print_standard_redirect('redirect_pmcmpt'));
}

// #############################################################################

if ($_REQUEST['do'] == 'removeslot')
{
    $id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	if (!$id)
	{
		$errormessage = $vbphrase[error_invalid_tournament];
        eval(standard_error($errormessage));
	}
	$tmnt = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_tmnts WHERE id=$id ");
	if ($tmnt['userid'] != $thisuserid && !$tmntp['canedittmnt'])
	{
		print_no_permission();
	}
	$freeslots = $tmnt['freeslots'];
	if ($freeslots == 0)
	{
		if ($status == 1)
		{
			process_full_tmnt($id);
		}
		$errormessage = $vbphrase['error_full_tournament'];
        eval(standard_error($errormessage));
	}
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_tmnts SET noplayers = noplayers-1, freeslots = freeslots-1 WHERE id=$id");
	if ($freeslots == 1 && $status == 1)
	{
		process_full_tmnt($id);
	}
	if ($tmnt['password'])
	{
		$urll = '&password='.$tmnt['password'];
	}
	$vbulletin->url = "tournaments.php?do=view&id=$id".$urll;
	eval(print_standard_redirect('redirect_removedslot'));
}

// #############################################################################

if ($_REQUEST['do'] == 'startlms')
{
    $id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	if (!$id)
	{
		$errormessage = $vbphrase[error_invalid_tournament];
        eval(standard_error($errormessage));
	}
	$tmnt = $vbulletin->db->query_first("SELECT userid, freeslots, status, noplayers FROM " . TABLE_PREFIX . "tmnt_tmnts WHERE id='$id' AND status='1' AND type='LMS' ");
	if (!$tmnt)
	{
		$errormessage = $vbphrase[error_invalid_tournament];
        eval(standard_error($errormessage));
	}
	if ($tmnt['userid'] != $thisuserid && !$tmntp['canedittmnt'])
	{
		print_no_permission();
	}
	if (($tmnt['noplayers'] - $tmnt['freeslots']) >= 2)
	{
		$noplayers = $tmnt['noplayers'] - $tmnt['freeslots'];
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_tmnts SET status = 2, noplayers = '".$noplayers."', freeslots = 0 WHERE id=$id ");
	}
	$vbulletin->url = "tournaments.php?do=view&id=$id";
	eval(print_standard_redirect('redirect_startedtmnt'));
}

// #############################################################################

if ($_POST['do'] == 'swapslots')
{
	if (!$tmntp['canedittmnt'])
	{
		print_no_permission();
	}
	$id = $vbulletin->input->clean_gpc('p', 'id', TYPE_UINT);
	$tmnt = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_tmnts WHERE id='$id' AND status='2' ");
	if (!$tmnt)
	{
		$errormessage = $vbphrase['error_invalid_tournament'];
        eval(standard_error($errormessage));
	}
	if (!in_array($tmnt['type'], array('1v1','de')))
	{
		print_no_permission();
	}
	$c_array = $array = array();
	$cmpts = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "tmnt_players WHERE tid='$id' ORDER BY slot ASC");
	while ($cmpt = $vbulletin->db->fetch_array($cmpts))
	{
		$c_array[] = $cmpt;
		$vbulletin->input->clean_gpc('p', 's_'.$cmpt['id'], TYPE_UINT);
		if (in_array($vbulletin->GPC['s_'.$cmpt['id']], $array))
		{
			$errormessage = 'Error, two players/teams cannot have the same slot.';
			eval(standard_error($errormessage));
		}
		$array[] = $vbulletin->GPC['s_'.$cmpt['id']];
	}
	foreach ($c_array AS $cd => $c)
	{
		//print_r("$c[id] = ".$vbulletin->GPC['s_'.$c['id']].";<br>");
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_players SET slot = '".$vbulletin->GPC['s_'.$c['id']]."' WHERE id = '".$c['id']."' ");
	}
	$vbulletin->url = "tournaments.php?do=view&id=$id";
	eval(print_standard_redirect('redirect_swappedslots'));
}

// #############################################################################

if ($_REQUEST['do'] == 'swapslots')
{
	if (!$tmntp['canedittmnt'])
	{
		print_no_permission();
	}
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	if (!$id)
	{
		$errormessage = $vbphrase['error_invalid_tournament'];
        eval(standard_error($errormessage));
	}
	$tmnt = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_tmnts WHERE id='$id' AND status='2' ");
	if (!$tmnt)
	{
		$errormessage = $vbphrase['error_invalid_tournament'];
        eval(standard_error($errormessage));
	}
	if (!in_array($tmnt['type'], array('1v1','de')))
	{
		print_no_permission();
	}
	for ($si = 1; $si <= $tmnt['noplayers']; $si++)
	{
		$options .= '<option value="'.$si.'">'.construct_phrase($vbphrase['tmnt_slot_x'], $si).'</option>';
	}
	$ci = 0;
	$slots = array();
	$cmpts = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "tmnt_players WHERE tid='$id' ORDER BY slot ASC");
	while ($cmpt = $vbulletin->db->fetch_array($cmpts))
	{
		$ci++;
		if ($cmpt['round2'])
		{//already started competing...
			$errormessage = 'You cannot swap slots once players/teams have started progressing through the rounds.';
			eval(standard_error($errormessage));
		}
		if (!$cmpt['userid'])
		{
			$show['slot_'.$ci] = false;
		}
		else
		{
			$show['slot_'.$ci] = true;
		}
		$cmpt['options'] = str_replace('value="'.$ci.'"','value="'.$ci.'" selected="selected"', $options);
		$slots["$ci"] = $cmpt;
	}
	$templater = vB_Template::create('tmnt_swapslots');
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt', $tmnt);
		$templater->register('slots', $slots);
		$templater->register('show', $show);
		$templater->register('ci', $ci);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'tournaments.php?' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['tmnts'],
		'tournaments.php?' . $vbulletin->session->vars['sessionurl_q'] . 'do=view&amp;id=' . $tmnt['id'] => $tmnt['title'],
		'' => construct_phrase($vbphrase['tmnt_swapslots'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'start1v1')
{
    $id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	if (!$id)
	{
		$errormessage = $vbphrase[error_invalid_tournament];
        eval(standard_error($errormessage));
	}
	$tmnt = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_tmnts WHERE id='$id' AND status='1' AND (type='1v1' OR type='de') ");
	if (!$tmnt)
	{
		$errormessage = $vbphrase['error_invalid_tournament'];
        eval(standard_error($errormessage));
	}
	if ($tmnt['userid'] != $thisuserid && !$tmntp['canedittmnt'])
	{
		print_no_permission();
	}
	$noplayers = $tmnt['noplayers'] - $tmnt['freeslots'];
	if ($noplayers >= 2)
	{
		if ($noplayers <= 4)
		{
			$byes = 4 - $noplayers;
			$noplayers = 4;
		}
		elseif ($noplayers <= 8)
		{
			$byes = 8 - $noplayers;
			$noplayers = 8;
		}
		elseif ($noplayers <= 16)
		{
			$byes = 16 - $noplayers;
			$noplayers = 16;
		}
		elseif ($noplayers <= 32)
		{
			$byes = 32 - $noplayers;
			$noplayers = 32;
		}
		elseif ($noplayers <= 64)
		{
			$byes = 64 - $noplayers;
			$noplayers = 64;
		}
		elseif ($noplayers <= 128)
		{
			$byes = 128 - $noplayers;
			$noplayers = 128;
		}
		elseif ($noplayers <= 256)
		{
			$byes = 256 - $noplayers;
			$noplayers = 256;
		}
		elseif ($noplayers <= 512)
		{
			$byes = 512 - $noplayers;
			$noplayers = 512;
		}
		$cmpts = $vbulletin->db->query_read("SELECT userid, username, slot FROM " . TABLE_PREFIX . "tmnt_players WHERE tid='$id' ORDER BY slot ASC");
		while ($cmpt = $vbulletin->db->fetch_array($cmpts))
		{
			if ($cmpt['userid'] == 0)
			{
				continue;
			}
			if ($byes <= 0)
			{
				break;
			}
			$slot = $cmpt['slot'] + 1;
			$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "tmnt_players
			(userid, username, tid, time, slot, pot)
			VALUES ('0', 'Bye', '".$id."', ".TIMENOW.", '".$slot."', '".$tmnt[pot]."')
			");
			$byes--;
		}
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_tmnts SET status = 2, noplayers = '".$noplayers."', freeslots = 0 WHERE id=$id AND status = 1");
	}
	$vbulletin->url = "tournaments.php?do=view&id=$id";
	eval(print_standard_redirect('redirect_startedtmnt'));
}

// #############################################################################

if ($_REQUEST['do'] == 'startgp')
{
    $id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	$tmnt = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_tmnts WHERE id='$id' AND status='1' AND type='groupplay' ");
	if (!$tmnt)
	{
		$errormessage = $vbphrase[error_invalid_tournament];
        eval(standard_error($errormessage));
	}
	if ($tmnt['userid'] != $thisuserid && !$tmntp['canedittmnt'])
	{
		print_no_permission();
	}
	$noplayers = $tmnt['noplayers'] - $tmnt['freeslots'];
	if ($noplayers >= 2)
	{
		if ($noplayers <= 4)
		{
			$byes = 4 - $noplayers;
			$noplayers = 4;
		}
		elseif ($noplayers <= 16)
		{
			$byes = 16 - $noplayers;
			$noplayers = 16;
		}
		elseif ($noplayers <= 64)
		{
			$byes = 64 - $noplayers;
			$noplayers = 64;
		}
		elseif ($noplayers <= 128)
		{
			$byes = 128 - $noplayers;
			$noplayers = 128;
		}
		$cmpts = $vbulletin->db->query_read("SELECT userid, username, slot FROM " . TABLE_PREFIX . "tmnt_players WHERE tid='$id' ORDER BY slot ASC");
		while ($cmpt = $vbulletin->db->fetch_array($cmpts))
		{
			if ($cmpt['userid'] == 0)
			{
				continue;
			}
			if ($byes <= 0)
			{
				break;
			}
			$slot = $cmpt['slot'] + 1;
			$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "tmnt_players
			(userid, username, tid, time, slot, pot)
			VALUES ('0', 'Bye', '".$id."', ".TIMENOW.", '".$slot."', '".$tmnt[pot]."')
			");
			$byes--;
		}
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_tmnts SET status = 2, noplayers = '".$noplayers."', freeslots = 0 WHERE id=$id AND status = 1");	
	}	
	$vbulletin->url = "tournaments.php?do=view&id=$id";
	eval(print_standard_redirect('redirect_startedtmnt'));
}

// #############################################################################

if ($_REQUEST['do'] == 'killplayer')
{
    $id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	$userid = $vbulletin->input->clean_gpc('g', 'userid', TYPE_UINT);
	$tid = $vbulletin->input->clean_gpc('g', 'tid', TYPE_UINT);
	$player = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_players WHERE id = '$id' OR (userid = '$userid' AND tid = '$tid')");
	if (!$player)
	{
		$errormessage = $vbphrase['error_invalid_player'];
        eval(standard_error($errormessage));
	}
	$team = false;
	if ($player['pot'])
	{
		$team = true;
	}
	$id = $player['id'];
	$tid = $player['tid'];
	$userid = $player['userid'];
	$tmnt = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_tmnts WHERE id=$tid ");
	if (($tmnt['userid'] == $thisuserid && !$team) OR ($tmntp['canedittmnt']))
	{
		if ($tmnt['status'] == 1)
		{//awaiting players
			$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "tmnt_players WHERE id=$id AND tid=$tid");
			if (!$team)
			{
				$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET tmnt_joins = tmnt_joins-1 WHERE userid=$userid");
			}
			else
			{
				$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_teams SET joins = joins-1 WHERE teamid=$userid");
			}
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_tmnts SET freeslots = freeslots+1 WHERE id=$tid");
		}
		elseif ($tmnt['status'] == 2)
		{//in progress
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_players SET userid = 0, username = 'Bye', round2 = 0, round3 = 0, round4 = 0, round5 = 0 WHERE userid=$userid");
		}
		else
		{//finished
			print_no_permission();
		}
	}
	else
	{
		if ($userid == $thisuserid AND !$team) 
		{
			$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "tmnt_players WHERE id=$id AND userid=$userid AND tid=$tid");
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET tmnt_joins = tmnt_joins-1 WHERE userid=$userid");
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_tmnts SET freeslots = freeslots+1 WHERE id=$tid");
		} 
		else 
		{
			print_no_permission();
		}
	}
	if ($tmnt['password'])
	{
		$urll = '&password='.$tmnt['password'];
	}
	$vbulletin->url = "tournaments.php?do=view&id=$tid".$urll;
	eval(print_standard_redirect('redirect_killplayer'));
}

// #############################################################################

if ($_REQUEST['do'] == 'killcomment')
{
    $id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	if (!$id) {
		$errormessage = $vbphrase[error_invalid_comment];
        eval(standard_error($errormessage));
	}
	$tid = $vbulletin->input->clean_gpc('g', 'tid', TYPE_UINT);
	if (!$tid) {
		$errormessage = $vbphrase[error_invalid_tournament];
        eval(standard_error($errormessage));
	}
	$userid = $vbulletin->input->clean_gpc('g', 'userid', TYPE_UINT);
	if (!$userid) {
		$errormessage = $vbphrase[error_no_userid];
        eval(standard_error($errormessage));
	}
	if ($tmntp['candelcomment']) {
		$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "tmnt_comments WHERE id=$id");
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_tmnts SET comments = comments - 1 WHERE id=$tid");
	} elseif ($tmntp['candelowncomment']) {
	if ($userid == $thisuserid) {
		$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "tmnt_comments WHERE id=$id AND userid=$userid");
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_tmnts SET comments = comments - 1 WHERE id=$tid");
	} else {
		print_no_permission();
	}
	} else {
		print_no_permission();
	}
	$vbulletin->url = "tournaments.php?do=view&id=".$tid."#comments";
	eval(print_standard_redirect('redirect_killcomment'));
}

// #############################################################################

if ($_REQUEST['do'] == 'finish')
{
    $tid = $id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	if (!$id)
	{
		$errormessage = $vbphrase[error_invalid_tournament];
        eval(standard_error($errormessage));
	}
	$tmnt = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_tmnts WHERE id = '$id' AND status = '2' ");
	if (!$tmnt)
	{
		$errormessage = $vbphrase[error_invalid_tournament];
        eval(standard_error($errormessage));
	}
	if ($tmnt['userid'] != $thisuserid)
	{
		if (!$tmntp['canedittmnt'])
		{
			print_no_permission();
		}
	}
	if ($tmnt['type'] == 'race')
	{
		$count = $vbulletin->db->query_first("
			SELECT COUNT(*) AS c
			FROM " . TABLE_PREFIX . "tmnt_players AS players
			WHERE tid = '$id' AND position = '0'
		");
		if ($count['c'])
		{
			$errormessage = 'Not all players have positions.';
			eval(standard_error($errormessage));
		}
		$w123a = array();
		$rowno = 0;
		$winners = $winners2nd = $winners3rd = array();
		$cmpts = $vbulletin->db->query_read("
			SELECT *
			FROM " . TABLE_PREFIX . "tmnt_players AS players
			WHERE tid = '$id'
			ORDER BY position ASC
		");
		while ($cmpt = $vbulletin->db->fetch_array($cmpts))
		{
			if ($cmpt['position'] == 1)
			{
				$winners[] = $cmpt['userid'];
			}
			if ($cmpt['position'] == 2)
			{
				$winners2nd[] = $cmpt['userid'];
			}
			if ($cmpt['position'] == 3)
			{
				$winners3rd[] = $cmpt['userid'];
			}
		}
		if ($tmnt['win_credits'] > 0 && $vbulletin->options['tmnt_credit_system'])
		{//winner gets credits
			$tmnt['win_credits'] = $tmnt['win_credits'] / count($winners);
require_once(DIR . '/includes/functions_tll_prem.php');
			foreach ($winners AS $winx => $winner_userid)
			{
				if ($tmnt['pot'])
				{
					process_credits_transaction($winner_userid, $tmnt['win_credits'], 'Won tournament', 0, 0, $winner_userid, 1);
				}
				else
				{
					process_credits_transaction($winner_userid, $tmnt['win_credits'], 'Won tournament');
					tll_auto_cashout($winner_userid);
				}
				update_forum_creditprofit(vbdate('W',TIMENOW), vbdate('Y',TIMENOW), -$tmnt['win_credits'], TIMENOW);
			}
		}
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_players SET winner = '1' WHERE tid = '$id' AND position = '1'");
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_tmnts SET status = 3 WHERE id = '$id'");
	}
	elseif ($tmnt['type'] == 'LMS')
	{
		$w123a = array();
		$rowno = 0;
		$winners = $winners2nd = $winners3rd = array();
		$cmpts = $vbulletin->db->query_read("
			SELECT *, (players.score + players.round2 + players.round3 + players.round4 + players.round5 + players.round6 + players.round7 + players.round8 + players.round9) AS score
			FROM " . TABLE_PREFIX . "tmnt_players AS players
			WHERE tid = '$id'
			ORDER BY score ".$tmnt['lms_order']."
		");
		while ($cmpt = $vbulletin->db->fetch_array($cmpts))
		{
			if (!$cmpt['score'])
			{
				break;
			}
			$rowno++;
			if ($rowno == 1)
			{
				$score_1st = $cmpt['score'];
			}
			if ($cmpt['score'] == $score_1st)
			{
				$winners[] = $cmpt['userid'];
			}
			$count_winners = $count = count($winners);
			if ($cmpt['score'] != $score_1st && !$score_2nd && $count < 3)
			{
				$score_2nd = $cmpt['score'];
			}
			if ($cmpt['score'] == $score_2nd)
			{
				$winners2nd[] = $cmpt['userid'];
			}
			$count += count($winners2nd);
			if ($cmpt['score'] != $score_2nd && !$score_3rd && $count < 3)
			{
				$score_3rd = $cmpt['score'];
				$score_3rda = $cmpt['score'];
			}
			if ($cmpt['score'] == $score_3rd)
			{
				$winners3rd[] = $cmpt['userid'];
			}
		}
		if (!$score_1st)
		{
			$errormessage = $vbphrase['error_no_results'];
			eval(standard_error($errormessage));
		}
		if ($tmnt['win_credits'] > 0 && $vbulletin->options['tmnt_credit_system'])
		{//winner gets credits
			$tmnt['win_credits'] = $tmnt['win_credits'] / $count_winners;
require_once(DIR . '/includes/functions_tll_prem.php');		
			foreach ($winners AS $winx => $winner_userid)
			{
				if ($tmnt['pot'])
				{
					process_credits_transaction($winner_userid, $tmnt['win_credits'], 'Won tournament', 0, 0, $winner_userid, 1);
				}
				else
				{
					process_credits_transaction($winner_userid, $tmnt['win_credits'], 'Won tournament');
					tll_auto_cashout($winner_userid);
				}
				update_forum_creditprofit(vbdate('W',TIMENOW), vbdate('Y',TIMENOW), -$tmnt['win_credits'], TIMENOW);
			}
		}
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_players SET winner = '1' WHERE tid = '$id' AND score = '$score_1st'");
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_tmnts SET status = 3 WHERE id = '$id'");
	}
	else if (in_array($tmnt['type'], array('rr','drr')))
	{
		$p_array = array();
		$cmpt_count = 1;
		$cmpts = $vbulletin->db->query_read("
			SELECT
				players.*
			FROM " . TABLE_PREFIX . "tmnt_players AS players 
			WHERE tid = '$id'
			ORDER BY slot ASC
		");
		while ($cmpt = $vbulletin->db->fetch_array($cmpts))
		{
			$p_array["$cmpt_count"] = $cmpt;
			$cmpt_count++;
		}
		if ($tmnt['type'] == 'rr')
		{
			$database = fetch_rr_database($tmnt['noplayers']);
		}
		else
		{
			$database = fetch_drr_database($tmnt['noplayers']);
		}
		foreach ($database AS $r => $rvalue)
		{
			$r = substr($r, 1);
			$s = '';
			foreach ($rvalue AS $nh => $ndata)
			{
				list($pla, $plb) = explode('v', $ndata);
				$pla = (int)$pla;
				$plb = (int)$plb;
				$s = $plb;
				$plx = 'round'.$r;
				if ($r == 1)
				{
					$plx = 'round';
				}
				if ($p_array["$pla"]["$plx"] > $p_array["$plb"]["$plx"])
				{
					$p_array["$pla"]['roundwins']++;
					$p_array["$plb"]['roundloses']++;
				}
				if ($p_array["$plb"]["$plx"] > $p_array["$pla"]["$plx"])
				{
					$p_array["$plb"]['roundwins']++;
					$p_array["$pla"]['roundloses']++;
				}
			}
		}
		$rr4 = array();
		foreach ($p_array AS $playerid => $userinfo)
		{
			if (!$userinfo[roundwins])
			{
				$userinfo[roundwins] = 0;
			}
			if (!$userinfo[roundloses])
			{
				$userinfo[roundloses] = 0;
			}
			$index = $userinfo[roundwins] - $userinfo[roundloses];
			$rr4[$index] = $rr4[$index] . ",$userinfo[userid]";
		}
		$jxr = 15;
		$count = 0;
		$winners = $winners2nd = $winners3rd = array();
		while ($jxr > -15)
		{
			if ($rr4[$jxr] && $winners && $winners2nd && !$winners3rd)
			{
				$winners3rd = substr($rr4[$jxr], 1);
				$winners3rd = explode(",", $winners3rd);
			}
			if ($rr4[$jxr] && !empty($winners) && empty($winners2nd))
			{
				$winners2nd = substr($rr4[$jxr], 1);
				$winners2nd = explode(",", $winners2nd);
				$count += count($winners2nd);
			}
			if ($rr4[$jxr] && empty($winners))
			{
				$winners = substr($rr4[$jxr], 1);
				$winners = explode(",", $winners);
				$count = count($winners);
			}
			if ($count >= 3 OR $winners3rd)
			{
				break;
			}
			$jxr--;
		}
		if ($tmnt['win_credits'] > 0 && $vbulletin->options['tmnt_credit_system'])
		{//winner gets credits
			$count_winners = count($winners);
			$tmnt['win_credits'] = $tmnt['win_credits'] / $count_winners;
require_once(DIR . '/includes/functions_tll_prem.php');		
			foreach ($winners AS $winx => $winner_userid)
			{
				if ($tmnt['pot'])
				{
					process_credits_transaction($winner_userid, $tmnt['win_credits'], 'Won tournament', 0, 0, $winner_userid, 1);
				}
				else
				{
					process_credits_transaction($winner_userid, $tmnt['win_credits'], 'Won tournament');
					tll_auto_cashout($winner_userid);
				}
				update_forum_creditprofit(vbdate('W',TIMENOW), vbdate('Y',TIMENOW), -$tmnt['win_credits'], TIMENOW);
			}
		}
		$winners = implode(",", $winners);
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_players SET winner = '1' WHERE tid = '$id' AND userid IN (".$winners.")");
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_tmnts SET status = 3 WHERE id = '$id'");
		$winners = explode(",", $winners);
	}
	else
	{
		print_no_permission();
	}
	$userids = implode("' OR userid = '", $winners);
	$userids2nd = implode("' OR userid = '", $winners2nd);
	$userids3rd = implode("' OR userid = '", $winners3rd);
	if ($tmnt['ladderid'])
	{
		if ($tmnt['lwinxp'])
		{
			list($tmnt['xp_1st'], $tmnt['xp_2nd'], $tmnt['xp_3rd']) = explode(',', $tmnt['lwinxp']);
		}
		else
		{
			$tmnt['xp_1st'] = $tmnt['xp_2nd'] = $tmnt['xp_3rd'] = 0;
		}
		if ($tmnt['prize'] OR $tmnt['xp_1st'] OR $tmnt['xp_2nd'] OR $tmnt['xp_3rd'])
		{
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
				SET rank = rank + " . $tmnt['prize'] . "
				" . ($tmnt['xp_1st'] ? ", xp = xp + " . $tmnt['xp_1st'] : "") . "
				WHERE (userid = '$userids')
					AND lid = '" . $tmnt['ladderid'] . "'
			");
			if ($tmnt['xp_2nd'] > 0 && $userids2nd)
			{
				$vbulletin->db->query_write("
					UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
					SET xp = xp + $tmnt[xp_2nd]
					WHERE (userid = '$userids2nd')
						AND lid = '" . $tmnt['ladderid'] . "'
				");
			}
			if ($tmnt['xp_3rd'] > 0 && $userids3rd)
			{
				$vbulletin->db->query_write("
					UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
					SET xp = xp + $tmnt[xp_3rd]
					WHERE (userid = '$userids3rd')
						AND lid = '" . $tmnt['ladderid'] . "'
				");
			}
		}
	}
	if (!$tmnt['pot'])
	{
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET tmnt_wins = tmnt_wins + 1 WHERE userid = '$userids'");
	}
	else
	{
		$userids = implode("' OR teamid = '", $winners);
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_teams SET wins = wins + 1 WHERE teamid = '$userids'");
	}
	$vbulletin->url = "tournaments.php?do=view&id=" . $id;
	eval(print_standard_redirect('redirect_tmntfinish'));
}

// #############################################################################

if ($_POST['do'] == 'insertcomment')
{
	if (!$tmntp['cancomment']) {
		print_no_permission();
	}
	$tid = $vbulletin->input->clean_gpc('p', 'tid', TYPE_UINT);
		if (!$tid) {
			$errormessage = $vbphrase[error_invalid_tournament];
        	eval(standard_error($errormessage));
		}
	$userid = $vbulletin->input->clean_gpc('p', 'userid', TYPE_UINT);
		if (!$userid) {
			$userid = $thisuserid;
		}
	$username = $vbulletin->input->clean_gpc('p', 'username', TYPE_STR);
		if (!$username) {
			$username = $thisusername;
		}
	$vbulletin->input->clean_array_gpc('p', array(
		'message'      => TYPE_STR,
		'wysiwyg'	   => TYPE_BOOL,
		'round'	   => TYPE_UINT,
		'u1'	   => TYPE_UINT,
		'u2'	   => TYPE_UINT,
	));
	if ($vbulletin->GPC['wysiwyg'] && $vbulletin->options['simpleversion'] < 414)
	{
		require_once(DIR . '/includes/functions_wysiwyg.php');
		$comment = convert_wysiwyg_html_to_bbcode($vbulletin->GPC['message'], 1);
	}
	else if ($vbulletin->GPC['wysiwyg'])
	{
		require_once(DIR . '/includes/class_wysiwygparser.php');
		$html_parser = new vB_WysiwygHtmlParser($vbulletin);
		$comment = $html_parser->parse_wysiwyg_html_to_bbcode($vbulletin->GPC['message']);
	}
	else 
	{
		$comment = $vbulletin->GPC['message'];
	}
	if (!$comment)
	{
		$errormessage = $vbphrase['error_invalid_message'];
		eval(standard_error($errormessage));
	}
	$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "tmnt_comments
		(tid, comment, userid, username, time, round, players)
		VALUES ('".$tid."', '".$vbulletin->db->escape_string($comment)."', '".$userid."',  '".$vbulletin->db->escape_string($username)."', ".TIMENOW.", '".$vbulletin->db->escape_string($vbulletin->GPC['round'])."', '".$vbulletin->db->escape_string($vbulletin->GPC['u1']."_".$vbulletin->GPC['u2'])."')
		");
	$id = $vbulletin->db->insert_id();
	$vbulletin->url = "tournaments.php?do=view&id=$tid&sh=4";	
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_tmnts SET comments = comments + 1 WHERE id=$tid");
	eval(print_standard_redirect('redirect_tmntcomment'));
}

// #############################################################################

if ($_REQUEST['do'] == 'recountcomments')
{
	if (!$tmntp['canedittmnt'])
	{
		print_no_permission();
	}
	$count = $vbulletin->db->query_read("
		SELECT tid, COUNT(*) AS countrows
		FROM " . TABLE_PREFIX . "tmnt_comments
		GROUP BY tid
	");
	while ($row = $vbulletin->db->fetch_array($count))
	{
		if ($row['countrows'] > 0)
		{
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_tmnts SET comments = '$row[countrows]' WHERE id = '$row[tid]'");
		}
	}
	$vbulletin->url = "competitions.php?";	
	eval(print_standard_redirect('redirecting'));
}

// #############################################################################

if (in_array($_REQUEST['do'], array('add','new')))
{
	if (!$tmntp['cancreatetmnt'])
	{
		print_no_permission();
	}
	if ($vbulletin->options['tmnt_limit_creator'] && !$tmntp['canedittmnt'])
	{
		$hide1 = false;
	}
	$catid = $vbulletin->input->clean_gpc('r', 'catid', TYPE_UINT);
	$ladderid = $vbulletin->input->clean_gpc('r', 'ladderid', TYPE_UINT);
	$pot = $vbulletin->input->clean_gpc('r', 'ladderid', TYPE_BOOL);
	$thisday = date("j");
	$ladders = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE archive = '0'");
	$ladderarray = array();
	while($ladder = $vbulletin->db->fetch_array($ladders))
	{
		if ($ladder['id'] == $ladderid)
		{
			$ladder['selected'] = " selected=\"selected\"";
			if ($ladder['catid'])
			{
				$catid = $ladder['catid'];
			}
			$pot = $ladder['pot'];
		}
		$ladderarray[] = $ladder;
	}
	$carray = array();
	$categories = '<select name="catid" id="catid">';
	if ($vbulletin->options['tmnt_allow_uncat'])
	{
		$categories .= '<option value="0"></option>';
	}
	/*$cats = $vbulletin->db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_categories
		WHERE tol IN (1,3)
		ORDER BY parentid DESC, displayorder ASC, title ASC
	");
	while($cat = $vbulletin->db->fetch_array($cats))
	{*/
	if ($vbulletin->tll_catcache)
	{
		foreach ($vbulletin->tll_catcache AS $cindex => $cat)
		{
			if (!in_array('tmnts',$cat['tol']) && !$carray["$cat[catid]"])
			{
				continue;
			}
			$show['categories'] = true;
			if ($cat['catid'] == $catid)
			{
				$cat['selected'] = '" selected="selected';
			}
			if ($cat['parentid'])
			{
				$carray["$cat[parentid]"] .= '<option value="'.$cat['catid'].$cat['selected'].'"';
				$carray["$cat[parentid]"] .= '> - '.$cat['title'].'</option>';
			}
			else
			{
				$categories .= '<option value="'.$cat['catid'].$cat['selected'].'"';
				$categories .= '>'.$cat['title'].'</option>';
				$categories .= $carray["$cat[catid]"];
			}
		}
	}
	$categories .= '</select>';
	require_once(DIR . '/includes/functions_editor.php');
	if ($vbulletin->options['simpleversion'] < 414)
	{
		$editorid = construct_edit_toolbar('', 0, 'nonforum', iif($vbulletin->options['privallowsmilies'], 1, 0));
	}
	else
	{
		$editorid = construct_edit_toolbar('');
	}
	$vbulletin->options['tmnt_types'] = explode(',',$vbulletin->options['tmnt_types']);
	$vboptions['tmnt_types'] = explode(',',$vboptions['tmnt_types']);
	($hook = vBulletinHook::fetch_hook('tll_tournaments_new')) ? eval($hook) : false;
	$templater = vB_Template::create('tmnt_new');
		$templater->register('editorid', $editorid);
		$templater->register('messagearea', $messagearea);
		$templater->register('categories', $categories);
		$templater->register('thisday', $thisday);
		$templater->register('ladderarray', $ladderarray);
		$templater->register('pot', $pot);
		$templater->register('show', $show);
		$templater->register('hide1', $hide1);
	$tlhtml .= $templater->render();
	$thismonth = "<option value=\"".date("n")."\" title=\"Month";
	$tlhtml = str_replace($thismonth, $thismonth."\" selected=\"selected", $tlhtml);
	$thisyear = "<option title=\"year\" value=\"".date("Y");
	$tlhtml = str_replace($thisyear, $thisyear."\" selected=\"selected", $tlhtml);
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'tournaments.php?' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase[tmnts],
		'' => construct_phrase($vbphrase['tmnt_create'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'addplayer')
{
	if (!$tmntp['canedittmnt'])
	{
		print_no_permission();
	}
	$filename = 'ajax_competitions.php';
	if (!file_exists($filename))
	{
		$errormessage = $vbphrase['error_missing_file'];
        eval(standard_error($errormessage));
	}
	$tid = $vbulletin->input->clean_gpc('g', 'tid', TYPE_UINT);
		if (!$tid)
		{
			$errormessage = $vbphrase['error_invalid_tournament'];
        	eval(standard_error($errormessage));
		}
	$tmnt = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_tmnts WHERE id = '$tid' ");
	$team = false;
	if ($tmnt['pot'])
	{
		$team = true;
		$teamarray = array();
		$teams_query = $vbulletin->db->query_read("
			SELECT t.*
			FROM " . TABLE_PREFIX . "tmnt_teams AS t
			LEFT JOIN " . TABLE_PREFIX . "tmnt_players AS p
				ON (p.userid = t.teamid AND p.tid = $tid)
			WHERE p.id IS NULL
		");
		while($teamq = $vbulletin->db->fetch_array($teams_query))
		{
			$teamarray[] = $teamq;
		}
		if (!$teamarray)
		{
			$errormessage = $vbphrase['tmnt_noteams'];
        	eval(standard_error($errormessage));
		}
	}
	$tmnt['usernameadded'] = $vbulletin->input->clean_gpc('g', 'username', TYPE_STR);
	if (!$tmnt['usernameadded'])
	{
		$tmnt['usernameadded'] = "Forum member ";
	}
	if ($tmnt['freeslots'] < 1)
	{
		$errormessage = $vbphrase['error_full_tournament'];
        eval(standard_error($errormessage));
	}
	if (isset($_REQUEST['added']))
	{
		$added_success = true;
	}
	$templater = vB_Template::create('tmnt_newplayer');
		$templater->register('added_success', $added_success);
		$templater->register('tid', $tid);
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt', $tmnt);
		$templater->register('team', $team);
		$templater->register('teamarray', $teamarray);
	$tlhtml .= $templater->render();
	if ($team)
	{
		$pph = $vbphrase['tmnt_addingteam'];
	}
	else
	{
		$pph = $vbphrase['tmnt_addingplayer'];
	}
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'tournaments.php'. $vbulletin->session->vars['sessionurl_q'] => $vbphrase['tmnts'],
		'tournaments.php?do=view&amp;id='. $tid . $vbulletin->session->vars['sessionurl_q'] => $tmnt['title'],
		'' => construct_phrase($pph)
	));
	$navbar = render_navbar_template($navbits);
	$show['usernameajax'] = true;
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_POST['do'] == 'update')
{
	$id = $vbulletin->input->clean_gpc('p', 'id', TYPE_UINT);
		if (!$id) {
			$errormessage = $vbphrase[error_invalid_tournament];
        	eval(standard_error($errormessage));
		}
	$tmnt = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_tmnts WHERE id=$id ");
	if ($tmnt['userid'] != $thisuserid) {
	if (!$tmntp['canedittmnt']) {
		print_no_permission();
	} }
	$changedate = $vbulletin->input->clean_gpc('p', 'changedate', TYPE_UINT);
		if ($changedate == 1)
		{
			$day = $vbulletin->input->clean_gpc('p', 'day', TYPE_UINT);
			$month = $vbulletin->input->clean_gpc('p', 'month', TYPE_UINT);
			$year = $vbulletin->input->clean_gpc('p', 'year', TYPE_UINT);
			$hour = $vbulletin->input->clean_gpc('p', 'time', TYPE_STR);
			$hourb = str_replace(".5", "", $hour);
			if ($hourb != $hour) {
				$min = 30;
			} else {
				$min = 0;
			}
			$hour = $vbulletin->input->clean_gpc('p', 'time', TYPE_INT);
			if (function_exists('cal_days_in_month'))
			{
				$days = cal_days_in_month(CAL_GREGORIAN, $month, $year);
			}
			else
			{
				$days = 31;
			}
			if ($day > $days OR $day == 0) {
				$errormessage = $vbphrase[error_invalid_date];
				eval(standard_error($errormessage));
			}
			$userinfo = fetch_userinfo($thisuserid);
			$timezoneoffset = $userinfo[timezoneoffset];
			$servertimezone = date(O);
			$serverdst = date(I);
			$servertimezone = substr($servertimezone, 0, 3);
			$servertimezone = $hour + $servertimezone;
			$date = mktime($servertimezone, $min, 0, $month, $day, $year);
		} else {
			$origdate = $vbulletin->input->clean_gpc('p', 'origdate', TYPE_UINT);
			$date = $origdate;
		}
    $userid = $vbulletin->input->clean_gpc('p', 'userid', TYPE_UINT);
		if (!$userid) {
			$userid = $thisuserid;
		}
	$username = $vbulletin->input->clean_gpc('p', 'username', TYPE_STR);
		if (!$username) {
			$username = $thisusername;
		}
	$status = $vbulletin->input->clean_gpc('p', 'status', TYPE_STR);
	if ($status == $vbphrase['tmnt_waiting'])
	{
		$status = 1;
	}
	elseif (in_array($status, array($vbphrase['tmnt_inprogress'],"Awaiting Start")))
	{
		$status = 2;
	}
	elseif ($status == $vbphrase['tmnt_finished']) 
	{
		$status = 3;
	}
	else
	{
		$errormessage = $vbphrase[error_invalid_status];
        eval(standard_error($errormessage));
	}
	$title = $vbulletin->input->clean_gpc('p', 'title', TYPE_STR);
		if (!$title) {
			$errormessage = $vbphrase[error_invalid_title];
        	eval(standard_error($errormessage));
		}
	$icon = $vbulletin->input->clean_gpc('p', 'icon', TYPE_NOHTML);
	$allowreserves = $vbulletin->input->clean_gpc('p', 'allowreserves', TYPE_BOOL);
	$type = $vbulletin->input->clean_gpc('p', 'type', TYPE_NOHTML);
		if (!$type) {
			$type = $tmnt['type'];
		}
	$noplayers = $vbulletin->input->clean_gpc('p', 'noplayers', TYPE_UINT);
		if (!$noplayers) {
			$errormessage = $vbphrase[error_invalid_noplayers];
        	eval(standard_error($errormessage));
		}
	$checkin = $vbulletin->input->clean_gpc('p', 'checkin', TYPE_UINT);
	$sticky    = $vbulletin->input->clean_gpc('p', 'sticky', TYPE_UINT);
	$archive   = $vbulletin->input->clean_gpc('p', 'archive', TYPE_UINT);
	$comp_ugid = $vbulletin->input->clean_gpc('p', 'comp_ugid', TYPE_UINT);
	$hide_untilstart = $vbulletin->input->clean_gpc('p', 'hide_untilstart', TYPE_UINT);
	$tmin      = $vbulletin->input->clean_gpc('p', 'tmin', TYPE_UINT);
	$tmax      = $vbulletin->input->clean_gpc('p', 'tmax', TYPE_UINT);
	if ($tmax < $tmin) {
		$tmax  = $tmin;
		$tmin  = $vbulletin->input->clean_gpc('p', 'tmax', TYPE_UINT);
	}
	$ladderid = $vbulletin->input->clean_gpc('p', 'ladderid', TYPE_UINT);
	$prize = $vbulletin->input->clean_gpc('p', 'prize', TYPE_UINT);
	$scoretype = $vbulletin->input->clean_gpc('p', 'scoretype', TYPE_STR);
	$vbulletin->input->clean_array_gpc('p', array(
		'password' => TYPE_NOHTML,
		'xp_1st' => TYPE_UINT,
		'xp_2nd' => TYPE_UINT,
		'xp_3rd' => TYPE_UINT,
		'join_cost' => TYPE_UNUM,
		'win_credits' => TYPE_UNUM,
		'message' => TYPE_STR,
		'wysiwyg' => TYPE_BOOL,
		'roundtext' => TYPE_ARRAY_NOHTML,
		'link_href' => TYPE_NOHTML,
		'link_text' => TYPE_NOHTML,
		'fielda' => TYPE_NOHTML,
		'fieldb' => TYPE_NOHTML,
		'comp_ugid' => TYPE_UINT,
		'groups' => TYPE_UINT,
		'playoff' => TYPE_UINT,
		'points_win' => TYPE_UINT,
		'points_draw' => TYPE_UINT,
		'points_lose' => TYPE_UINT,
		'knockout_places' => TYPE_UINT,
		'starting_points' => TYPE_UINT,
		'lms_rounds' => TYPE_UINT,
		'lms_order' => TYPE_NOHTML,
	));
	$additional = serialize(array(
		'points_win' => $vbulletin->GPC['points_win'],
		'points_draw' => $vbulletin->GPC['points_draw'],
		'points_lose' => $vbulletin->GPC['points_lose'],
		'knockout_places' => $vbulletin->GPC['knockout_places'],
	));
	if ($vbulletin->GPC['link_href'] && !in_array($vbulletin->GPC['link_href'], array('http://www.','www.','http://')))
	{
		$vbulletin->GPC['link'] = serialize(array(
			'href' => $vbulletin->GPC['link_href'],
			'text' => $vbulletin->GPC['link_text']
		));
	}
	switch ($vbulletin->GPC['lms_order'])
	{
		case 'DESC':
		case 'ASC':
			break;
		default:
			$vbulletin->GPC['lms_order'] = 'DESC';
			break;
	}
	$vbulletin->GPC['roundtext'] = serialize($vbulletin->GPC['roundtext']);
	$vbulletin->GPC['lwinxp'] = $vbulletin->GPC['xp_1st'].','.$vbulletin->GPC['xp_2nd'].','.$vbulletin->GPC['xp_3rd'];
	if ($vbulletin->GPC['wysiwyg'] && $vbulletin->options['simpleversion'] < 414)
	{
		require_once(DIR . '/includes/functions_wysiwyg.php');
		$description = convert_wysiwyg_html_to_bbcode($vbulletin->GPC['message'], 1);
	}
	else if ($vbulletin->GPC['wysiwyg'])
	{
		require_once(DIR . '/includes/class_wysiwygparser.php');
		$html_parser = new vB_WysiwygHtmlParser($vbulletin);
		$description = $html_parser->parse_wysiwyg_html_to_bbcode($vbulletin->GPC['message']);
	}
	else 
	{
		$description = $vbulletin->GPC['message'];
	}
		if (!$description) 
		{
			$errormessage = $vbphrase[error_invalid_description];
        	eval(standard_error($errormessage));
		}
	$catid = $vbulletin->input->clean_gpc('p', 'catid', TYPE_UINT);
	if (!in_array($type, array('1v1','LMS','race','de','rr','drr','groupplay','groupplay_ko')))
	{
		$type = $tmnt['type'];
	}
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "tmnt_tmnts
		SET
			title = '".$vbulletin->db->escape_string($title)."',
			description = '".$vbulletin->db->escape_string($description)."', 
			type = '".$vbulletin->db->escape_string($type)."', 
			status = '".$vbulletin->db->escape_string($status)."', 
			le_userid = '".$vbulletin->db->escape_string($userid)."', 
			le_username = '".$vbulletin->db->escape_string($username)."',
			le_time =".TIMENOW.", 
			scoretype = '".$vbulletin->db->escape_string($scoretype)."',
			date = '".$vbulletin->db->escape_string($date)."',
			archive = '".$vbulletin->db->escape_string($archive)."',
			sticky = '".$vbulletin->db->escape_string($sticky)."',
			tmin = '".$vbulletin->db->escape_string($tmin)."',
			tmax = '".$vbulletin->db->escape_string($tmax)."',
			catid = '".$vbulletin->db->escape_string($catid)."',
			icon = '".$vbulletin->db->escape_string($icon)."',
			ladderid = '".$vbulletin->db->escape_string($ladderid)."',
			prize = '".$vbulletin->db->escape_string($prize)."',
			lwinxp = '".$vbulletin->db->escape_string($vbulletin->GPC['lwinxp'])."',
			checkin = '".$vbulletin->db->escape_string($vbulletin->GPC['checkin'])."',
			join_cost = '".$vbulletin->db->escape_string($vbulletin->GPC['join_cost'])."',
			win_credits = '".$vbulletin->db->escape_string($vbulletin->GPC['win_credits'])."',
			roundtext = '".$vbulletin->db->escape_string($vbulletin->GPC['roundtext'])."',
			comp_ugid = '".$vbulletin->db->escape_string($vbulletin->GPC['comp_ugid'])."',
			fielda = '".$vbulletin->db->escape_string($vbulletin->GPC['fielda'])."',
			fieldb = '".$vbulletin->db->escape_string($vbulletin->GPC['fieldb'])."',
			allowreserves = '".$vbulletin->db->escape_string($vbulletin->GPC['allowreserves'])."',
			hide_untilstart = '".$vbulletin->db->escape_string($vbulletin->GPC['hide_untilstart'])."',
			password = '".$vbulletin->db->escape_string($vbulletin->GPC['password'])."',
			groups = '".$vbulletin->db->escape_string($vbulletin->GPC['groups'])."',
			playoff = '".$vbulletin->db->escape_string($vbulletin->GPC['playoff'])."',
			starting_points = '".$vbulletin->db->escape_string($vbulletin->GPC['starting_points'])."',
			link = '".$vbulletin->db->escape_string($vbulletin->GPC['link'])."',
			lms_order = '".$vbulletin->db->escape_string($vbulletin->GPC['lms_order'])."',
			lms_rounds = '".$vbulletin->db->escape_string($vbulletin->GPC['lms_rounds'])."',
			additional = '".$vbulletin->db->escape_string($additional)."'
		WHERE id='$id' ");
	build_tll_catcache();
	if ($vbulletin->GPC['password'])
	{
		$urll = '&password='.$vbulletin->GPC['password'];
	}
	$vbulletin->url = "tournaments.php?do=view&id=".$id.$urll;	
	eval(print_standard_redirect('redirect_updatetmnt'));
}

// #############################################################################

if ($_POST['do'] == 'inserttmnt')
{
	if (!$tmntp['cancreatetmnt'])
	{
		print_no_permission();
	}
	$day = $vbulletin->input->clean_gpc('p', 'day', TYPE_UINT);
	if (empty($day))
	{
		$errormessage = $vbphrase[error_no_day];
		eval(standard_error($errormessage));
	}
	$month = $vbulletin->input->clean_gpc('p', 'month', TYPE_UINT);
	if (empty($month)) {
		$errormessage = $vbphrase[error_no_month];
		eval(standard_error($errormessage));
	}
	$year = $vbulletin->input->clean_gpc('p', 'year', TYPE_UINT);
	if (empty($year))
	{
		$errormessage = $vbphrase[error_no_year];
		eval(standard_error($errormessage));
	}
	$hour = $vbulletin->input->clean_gpc('p', 'time', TYPE_STR);
	$hourb = str_replace(".5", "", $hour);
    if ($hourb != $hour) { 
		$min = 30;
	} else {
		$min = 0;
	}
	$hour = $vbulletin->input->clean_gpc('p', 'time', TYPE_UINT);
	if (function_exists('cal_days_in_month'))
	{
		$days = cal_days_in_month(CAL_GREGORIAN, $month, $year);
	}
	else
	{
		$days = 31;
	}
	if ($day > $days OR $day == 0)
	{
		$errormessage = $vbphrase[error_invalid_date];
        eval(standard_error($errormessage));
	}
	$userinfo = fetch_userinfo($thisuserid);
	$timezoneoffset = $userinfo[timezoneoffset];
	$servertimezone = date(O);
	$serverdst = date(I);
	$servertimezone = substr($servertimezone, 0, 3);
	$servertimezone = $hour + $servertimezone;
	$date = mktime($servertimezone, $min, 0, $month, $day, $year);
	$userid = $thisuserid;
	$username = $thisusername;
	$vbulletin->input->clean_array_gpc('p', array(
		'prize' => TYPE_UINT,
		'ladderid' => TYPE_UINT,
		'type' => TYPE_STR,
		'pot' => TYPE_UINT,
		'status' => TYPE_UINT,
		'checkin' => TYPE_UINT,
		'title' => TYPE_NOHTML,
		'catid' => TYPE_UINT,
		'xp_1st' => TYPE_UINT,
		'xp_2nd' => TYPE_UINT,
		'xp_3rd' => TYPE_UINT,
		'noplayers' => TYPE_UINT,
		'icon' => TYPE_NOHTML,
		'message' => TYPE_STR,
		'wysiwyg' => TYPE_BOOL,
		'join_cost' => TYPE_UNUM,
		'win_credits' => TYPE_UNUM,
	));
	$vbulletin->GPC['lwinxp'] = $vbulletin->GPC['xp_1st'].','.$vbulletin->GPC['xp_2nd'].','.$vbulletin->GPC['xp_3rd'];
	if (!$vbulletin->GPC['status'])
	{
		$vbulletin->GPC['status'] = 1;
	}
	if (!$title = $vbulletin->GPC['title'])
	{
		$errormessage = $vbphrase['error_invalid_title'];
		eval(standard_error($errormessage));
	}
	if (!$vbulletin->GPC['noplayers'])
	{
		$errormessage = $vbphrase[error_no_noplayers];
		eval(standard_error($errormessage));
	}
	if (!$vbulletin->GPC['type'])
	{
		$errormessage = $vbphrase[error_no_tmnt_type];
		eval(standard_error($errormessage));
	}
	if ($vbulletin->GPC['wysiwyg'] && $vbulletin->options['simpleversion'] < 414)
	{
		require_once(DIR . '/includes/functions_wysiwyg.php');
		$description = convert_wysiwyg_html_to_bbcode($vbulletin->GPC['message'], 1);
	}
	else if ($vbulletin->GPC['wysiwyg'])
	{
		require_once(DIR . '/includes/class_wysiwygparser.php');
		$html_parser = new vB_WysiwygHtmlParser($vbulletin);
		$description = $html_parser->parse_wysiwyg_html_to_bbcode($vbulletin->GPC['message']);
	}
	else
	{
		$description = $vbulletin->GPC['message'];
	}
	if (!$description)
	{
		$errormessage = $vbphrase[error_invalid_description];
		eval(standard_error($errormessage));
	} 
	if ($vbulletin->GPC['type'] == 'de' && $vbulletin->GPC['noplayers'] > $tmnt_maxde)
	{
		$vbulletin->GPC['noplayers'] = $tmnt_maxde;
	}
	if ($vbulletin->options['tmnt_createthread'])
	{
		switch ($vbulletin->GPC['type'])
		{
			case 'LMS';
				$typetext = $vbphrase['tmnt_lms'];
				break;
			case '1v1';
				$typetext = $vbphrase['tmnt_1v1'];
				break;
			case 'de';
				$typetext = $vbphrase['tmnt_de'];
				break;
			case 'rr';
				$typetext = $vbphrase['tmnt_rr'];
				break;
			case 'drr';
				$typetext = $vbphrase['tmnt_drr'];
				break;
			case 'race';
				$typetext = $vbphrase['tmnt_race'];
				break;
			case 'groupplay';
				$typetext = $vbphrase['tmnt_groupplay'];
				break;
			case 'groupplay_ko';
				$typetext = $vbphrase['tmnt_groupplay_ko'];
				break;
			case 'swiss';
				$typetext = $vbphrase['tmnt_swiss'];
				break;
		}
		require_once('./includes/functions_databuild.php');
        $forumid = $vbulletin->options['tmnt_createthread'];
        $userid = $thisuserid;
		$templater = vB_Template::create('tmnt_threadtemplate');
			$templater->register('tmnt', $tmnt);
			$templater->register('description', $description);
			$templater->register('noplayers', $vbulletin->GPC['noplayers']);
			$templater->register('id', $id);
			$templater->register('title', $vbulletin->GPC['title']);
			$templater->register('date', $date);
			$templater->register('type', $typetext);
			$templater->register('catid', $vbulletin->GPC['catid']);
			$templater->register('pot', $vbulletin->GPC['pot']);
			$templater->register('userid', $userid);
			$templater->register('forumid', $forumid);
			$templater->register('status', $vbulletin->GPC['status']);
			$templater->register('username', $username);
		$pagetext = $templater->render();
		$pagetext = preg_replace('/<!--(.|\s)*?-->/', '', $pagetext);
		$open = 1;
        $allow_smilie = 1;
        $visible = 1;
		$threadid = new_thread($userid, $forumid, $title, $pagetext, $open, $allow_smilie, $visible);
	}
	else
	{
		$threadid = 0;
	}
	$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "tmnt_tmnts
		(title, description, type, date, noplayers, freeslots, status, userid, username, time, le_userid, le_username, le_time, threadid, pot, catid, icon, ladderid, prize, lwinxp, checkin, join_cost, win_credits)
		VALUES (
			'".$vbulletin->db->escape_string($vbulletin->GPC['title'])."',
			'".$vbulletin->db->escape_string($description)."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['type'])."',
			'".$vbulletin->db->escape_string($date)."', 
			'".$vbulletin->db->escape_string($vbulletin->GPC['noplayers'])."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['noplayers'])."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['status'])."', 
			'".$vbulletin->db->escape_string($userid)."',
			'".$vbulletin->db->escape_string($username)."',
			".TIMENOW.", 
			'".$vbulletin->db->escape_string($userid)."',
			'".$vbulletin->db->escape_string($username)."', 
			".TIMENOW.", 
			'".$vbulletin->db->escape_string($threadid)."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['pot'])."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['catid'])."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['icon'])."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['ladderid'])."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['prize'])."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['lwinxp'])."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['checkin'])."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['join_cost'])."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['win_credits'])."'
			)
		");
	$id = $vbulletin->db->insert_id();
	build_tll_catcache();
	$t_url = tll_seo('tmnt', $id, $vbulletin->GPC['title'], 1);
	$vbulletin->url = $t_url."&new=1";	
	eval(print_standard_redirect('redirect_inserttmnt'));
}

// #############################################################################

if ($_POST['do'] == 'updateplayer')
{
	$id = $vbulletin->input->clean_gpc('p', 'id', TYPE_UINT);
		if (!$id)
		{
			$errormessage = $vbphrase[error_invalid_player];
        	eval(standard_error($errormessage));
		}
	$tid = $vbulletin->input->clean_gpc('p', 'tid', TYPE_UINT);
		if (!$tid) {
			$errormessage = $vbphrase[error_invalid_tournament];
        	eval(standard_error($errormessage));
		}
	$tmnt = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_tmnts WHERE id=$tid ");
	if ($tmnt['status'] != 2)
	{
		$errormessage = $vbphrase[error_tournament_not_inprogress];
        eval(standard_error($errormessage));
	}
	if ($tmnt['userid'] != $thisuserid) {
	if (!$tmntp['canedittmnt']) {
		print_no_permission();
	} }
	$vbulletin->input->clean_array_gpc('p', array(
		'position' => TYPE_INT,
		'score' => TYPE_INT,
		'round2' => TYPE_INT,
		'round3' => TYPE_INT,
		'round4' => TYPE_INT,
		'round5' => TYPE_INT,
		'round6' => TYPE_INT,
		'round7' => TYPE_INT,
		'round8' => TYPE_INT,
	));
	if ($tmnt['type']=='race')
	{
		$vbulletin->db->query_write("
			UPDATE " . TABLE_PREFIX . "tmnt_players
			SET position = '".$vbulletin->db->escape_string($vbulletin->GPC['position'])."'
			WHERE id = '$id'
		");
	}
	else
	{
		$vbulletin->db->query_write("
			UPDATE " . TABLE_PREFIX . "tmnt_players
			SET score = '".$vbulletin->db->escape_string($vbulletin->GPC['score'])."',
				round2 = '".$vbulletin->db->escape_string($vbulletin->GPC['round2'])."',
				round3 = '".$vbulletin->db->escape_string($vbulletin->GPC['round3'])."',
				round4 = '".$vbulletin->db->escape_string($vbulletin->GPC['round4'])."',
				round5 = '".$vbulletin->db->escape_string($vbulletin->GPC['round5'])."',
				round6 = '".$vbulletin->db->escape_string($vbulletin->GPC['round6'])."',
				round7 = '".$vbulletin->db->escape_string($vbulletin->GPC['round7'])."',
				round8 = '".$vbulletin->db->escape_string($vbulletin->GPC['round8'])."'
			WHERE id = '$id'
		");
	}
	$vbulletin->url = tll_seo('tmnt',$tid,$tmnt['title'],1);	
	eval(print_standard_redirect('redirect_updateplayer'));
}

// #############################################################################

if ($_REQUEST['do'] == 'edit')
{
    $id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	if (!$id) {
		$errormessage = $vbphrase[error_invalid_tournament];
        eval(standard_error($errormessage));
	}
	if ($vbulletin->options['tmnt_limit_creator'] && !$tmntp['canedittmnt'])
	{
		$hide1 = true;
	}
	if (!$tmntp['canedittmnt']) {$tmnt = $vbulletin->db->query_first("SELECT userid FROM " . TABLE_PREFIX . "tmnt_tmnts WHERE id=$id ");
	if ($tmnt['userid'] != $thisuserid) {
		print_no_permission();
	}} 
	$tmnt = $tmnts = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_tmnts WHERE id='$id'");
	if (!$tmnts)
	{
		$errormessage = $vbphrase[error_invalid_tournament];
        eval(standard_error($errormessage));
	}
	$ladders = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE archive = '0' AND pot = '$tmnt[pot]'");
	$ladderarray = array();
	while($ladder = $vbulletin->db->fetch_array($ladders))
	{
		if ($ladder['id'] == $tmnt['ladderid'])
		{
			$ladder['selected'] = " selected=\"selected\"";
		}
		$ladderarray[] = $ladder;
	}
	$title = $tmnts['title'];
	$description = $tmnts['description'];
	$tmnt['rawtype'] = $tmnt['type'];
	$tmnts = switch_tmnt_type($tmnts);
	$type = $tmnts['type'];
	$team = false;
	if ($tmnts['pot'])
	{
		$team = true;
	}
	if ($tmnt['lwinxp'])
	{
		list($tmnt['xp_1st'], $tmnt['xp_2nd'], $tmnt['xp_3rd']) = explode(',', $tmnt['lwinxp']);
	}
	else
	{
		$tmnt['xp_1st'] = $tmnt['xp_2nd'] = $tmnt['xp_3rd'] = 0;
	}
	$origdate    = $tmnts['date'];
	$date        = $tmnts['date'];
	$tmin        = $tmnts['tmin'];
	$tmax        = $tmnts['tmax'];
	$sticky      = $tmnts['sticky'];
	$archive     = $tmnts['archive'];
	$catid       = $tmnts['catid'];
	$categories = '<select name="catid" id="catid">';
	if ($vbulletin->options['tmnt_allow_uncat'])
	{
		$categories .= '<option value="0"></option>';
	}
	if ($vbulletin->tll_catcache)
	{
		foreach ($vbulletin->tll_catcache AS $cindex => $cat)
		{
			if (!in_array('tmnts', $cat['tol']) && !$carray["$cat[catid]"])
			{
				continue;
			}
			if ($cat[parentid])
			{
				$carray["$cat[parentid]"] .= '<option value="'.$cat[catid].'"';
				if ($catid == $cat[catid])
				{
					$carray["$cat[parentid]"] .= ' selected="selected" ';
				}
				$carray["$cat[parentid]"] .= '> - '.$cat[title].'</option>';
			}
			else
			{
				$categories .= '<option value="'.$cat[catid].'"';
				if ($catid == $cat[catid])
				{
					$categories .= ' selected="selected" ';
				}
				$categories .= '>'.$cat[title].'</option>';
				$categories .= $carray["$cat[catid]"];
			}
		}
	}
	$categories .= '</select>';
	$properdate  = vbdate($vbulletin->options['dateformat'], $date, 1)." <span class=\"time\">".vbdate($vbulletin->options['timeformat'], $date)."</span>";
	$noplayers   = $tmnts['noplayers'];
	$tmnts = switch_tmnt_status($tmnts);
	$status = $tmnts['status'];
	$scoretype   = $tmnts['scoretype'];
	$checkin = $tmnts['checkin'];
	$tmnt['sel']['checkin']["$checkin"] = 'selected="selected"';
	if ($tmnt['additional'])
	{
		$tmnt['additional'] = unserialize($tmnt['additional']);
		if (is_array($tmnt['additional']))
		{
			$tmnt = array_merge($tmnt, $tmnt['additional']);
		}
	}
	require_once(DIR . '/includes/functions_editor.php');
	if ($vbulletin->options['simpleversion'] < 414)
	{
		$editorid = construct_edit_toolbar($description, 0, 'nonforum', iif($vbulletin->options['privallowsmilies'], 1, 0));
	}
	else
	{
		$editorid = construct_edit_toolbar($description);
	}
	if ($vbulletin->options['tmnt_premium'] && in_array($tmnt['type'], array('1v1','de','rr','drr','LMS')))
	{
		$rt_array = array();
		$tmnt['roundtext'] = unserialize($tmnt['roundtext']);
		if ($tmnt['type']=='de')
		{
			$tmnt['rounds'] = ceil(log($tmnt['noplayers'], 2))+1;
			$tmnt['rounds'] += 3;
		}
		elseif ($tmnt['type']=='1v1')
		{
			$tmnt['rounds'] = ceil(log($tmnt['noplayers'], 2))+1;
		}
		elseif ($tmnt['type']=='rr' || $tmnt['type']=='drr')
		{
			$tmnt = rr_get_rounds($tmnt);
		}
		elseif ($tmnt['type']=='LMS' && $tmnt['lms_rounds'] > 1)
		{
			$tmnt['rounds'] = $tmnt['lms_rounds'];
		}
		for ($i = 1; $i <= $tmnt['rounds']; $i++)
		{
			$rt_array["$i"] = $tmnt['roundtext']["$i"];
		}
	}
	$tmnt['dateline_tmnt_startdate'] = vbdate($vbulletin->options['dateformat'], $tmnt['date']);
	$tmnt['dateline_tmnt_starttime'] = vbdate($vbulletin->options['timeformat'], $tmnt['date']);
	$tmnt['link'] = unserialize($tmnt['link']);
	if (!$tmnt['link'])
	{
		$tmnt['link'] = array('href' => 'http://www.');
	}
	$tmnt['url'] = tll_seo('tmnt', $tmnt['id'], $tmnt['title'], 1);
	$templater = vB_Template::create('tmnt_edit');
		$templater->register('tmnt', $tmnt);
		$templater->register('description', $description);
		$templater->register('ladderarray', $ladderarray);
		$templater->register('noplayers', $noplayers);
		$templater->register('id', $id);
		$templater->register('title', $title);
		$templater->register('type', $type);
		$templater->register('date', $date);
		$templater->register('editorid', $editorid);
		$templater->register('messagearea', $messagearea);
		$templater->register('scoretype', $scoretype);
		$templater->register('status', $status);
		$templater->register('categories', $categories);
		$templater->register('properdate', $properdate);
		$templater->register('catid', $catid);
		$templater->register('origdate', $origdate);
		$templater->register('tmin', $tmin);
		$templater->register('tmax', $tmax);
		$templater->register('sticky', $sticky);
		$templater->register('archive', $archive);
		$templater->register('team', $team);
		$templater->register('rt_array', $rt_array);
		$templater->register('hide1', $hide1);
	$tlhtml = $templater->render();
	$servertimezone = date(O);
	$serverdst = date(I);
	$servertimezone = substr($servertimezone, 0, 3);
	$servertimezone = 0 + $servertimezone;
	$date = $date - (($servertimezone)*3600);
	$thismonth = "<option value=\"".date("n", $date)."\" title=\"Month";
	$tlhtml = str_replace($thismonth, $thismonth."\" selected=\"selected", $tlhtml);
	$tlhtml = str_replace("name=\"day\" value=\"\"", "name=\"day\" value=\"".date("j", $date)."\"", $tlhtml);
	$thishour = 0 + date("H", $date);
	$thismin = 0 + date("i", $date);
	if ($thismin >= 30) {
		$thismin = ".5";
	} else {
		$thismin = "";
	}
	$thishour = "<option title=\"time\" value=\"".$thishour.$thismin."\" class=\"";
	$tlhtml = str_replace($thishour, $thishour."\" selected=\"selected", $tlhtml);
	$thisyear = "<option title=\"year\" value=\"".date("Y", $date);
	$tlhtml = str_replace($thisyear, $thisyear."\" selected=\"selected", $tlhtml);
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'tournaments.php' => $vbphrase['tmnts'],
		tll_seo('tmnt', $tmnt['id'], $tmnt['title'], 1) => $title,
		'' => construct_phrase($vbphrase['tmnt_editing'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'editcomment')
{
    $id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	if (!$id) {
		$errormessage = $vbphrase[error_invalid_comment];
        eval(standard_error($errormessage));
	}
	$comments = $vbulletin->db->query_first("SELECT tid, comment, userid, username, time
		FROM " . TABLE_PREFIX . "tmnt_comments
		WHERE id=$id ");
	if (!$comments)
	{
		$errormessage = $vbphrase[error_invalid_comment];
        eval(standard_error($errormessage));
	}
	$tid       = $comments['tid'];
	$comment   = $comments['comment'];
	$userid    = $comments['userid'];
	$username  = $comments['username'];
	$time      = $comments['time'];
	if (!$tmntp['canedittmnt'] AND !($userid == $thisuserid))
	{
		print_no_permission();
	}
	require_once(DIR . '/includes/functions_editor.php');
	if ($vbulletin->options['simpleversion'] < 414)
	{
		$editorid = construct_edit_toolbar($comment, 0, 'nonforum', iif($vbulletin->options['privallowsmilies'], 1, 0));
	}
	else
	{
		$editorid = construct_edit_toolbar($comment);
	}
	$title = construct_phrase($vbphrase['tmnt_xs_comment'], $username);
	$templater = vB_Template::create('tmnt_editcomment');
		$templater->register('description', $description);
		$templater->register('comment', $comment);
		$templater->register('id', $id);
		$templater->register('title', $title);
		$templater->register('time', $time);
		$templater->register('editorid', $editorid);
		$templater->register('messagearea', $messagearea);
		$templater->register('tid', $tid);
		$templater->register('comments', $comments);
		$templater->register('userid', $userid);
		$templater->register('username', $username);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'tournaments.php?do=view&id='.$tid . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['tmnt'],
		'' => construct_phrase($vbphrase['tmnt_xs_comment'], $username)
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_POST['do'] == 'updatecomment')
{
	$id = $vbulletin->input->clean_gpc('p', 'id', TYPE_UINT);
		if (!$id)
		{
			$errormessage = $vbphrase[error_invalid_comment];
       		eval(standard_error($errormessage));
		}
	$tid = $vbulletin->input->clean_gpc('p', 'tid', TYPE_UINT);
	$vbulletin->input->clean_array_gpc('p', array(
		'message'      => TYPE_STR,
		'wysiwyg'			 => TYPE_BOOL,
	));
	if ($vbulletin->GPC['wysiwyg'] && $vbulletin->options['simpleversion'] < 414)
	{
		require_once(DIR . '/includes/functions_wysiwyg.php');
		$message = convert_wysiwyg_html_to_bbcode($vbulletin->GPC['message'], 1);
	}
	else if ($vbulletin->GPC['wysiwyg'])
	{
		require_once(DIR . '/includes/class_wysiwygparser.php');
		$html_parser = new vB_WysiwygHtmlParser($vbulletin);
		$message = $html_parser->parse_wysiwyg_html_to_bbcode($vbulletin->GPC['message']);
	}
	else
	{
		$message = $vbulletin->GPC['message'];
	}
		if (!$message)
		{
			$errormessage = $vbphrase[error_invalid_comment];
       		eval(standard_error($errormessage));
		}
	$userid = $thisuserid;
	$username = $thisusername;
	$ip = $_SERVER['REMOTE_ADDR'];
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_comments SET comment = '".$vbulletin->db->escape_string($message)."', ed_userid = '".$vbulletin->db->escape_string($userid)."', ed_username = '".$vbulletin->db->escape_string($username)."', ed_time = ".TIMENOW.", ed_ip = '".$vbulletin->db->escape_string($ip)."' WHERE id=$id ");
	$vbulletin->url = "tournaments.php?do=view&id=".$tid."&sh=4#comments";	
	eval(print_standard_redirect('redirect_edittmntcomment'));
}

// #############################################################################

if ($_REQUEST['do'] == 'editplayer')
{
    $id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	if (!$id) 
	{
		$errormessage = $vbphrase[error_invalid_player];
        eval(standard_error($errormessage));
	}
	if (!$tmntp['canedittmnt']) 
	{
		print_no_permission();
	}
	$cmpt = $players = $vbulletin->db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_players
		WHERE id='".$id."'
		");
	$userid   = $players['userid'];
	$username = $players['username'];
	$tid      = $players['tid'];
	$tmnt = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_tmnts WHERE id='$tid' ");
	if ('race' == strtolower($tmnt['type']))
	{
		$tmnt['arraya'] = array();
		for ($ta = 1; $ta <= $tmnt['noplayers']; $ta++)
		{
			$tmnt['arraya']["$ta"] = process_position($ta);
		}
	}
	$score    = $players['score'];
	if ('lms' == strtolower($tmnt['type']) && $tmnt['lms_rounds']>1)
	{
		$tmnt['raw'] .= '<div class="blockrow"><label for="round_1">'.$vbphrase['tmnt_rounds'].'</label><ul class="multifield group floatcontainer">';
		for ($li = 1; $li <= $tmnt['lms_rounds']; $li++)
		{
			if ($li == 1)
			{
				$aa = $cmpt['score'];
			}
			else
			{
				$aa = $cmpt["round$li"];
			}
			$tmnt['raw'] .= '<li> <label for="round_'.$li.'">'.construct_phrase($vbphrase['tmnt_round_x'], $li).'</label> <input id="round_'.$li.'" type="number" class="textbox numeric" name="'.($li==1?"score":"round$li").'" value="'.$aa.'" size="3" maxlength="2" tabindex="1" style="max-width: 50px;" /> </li>';
		}
		$tmnt['raw'] .= '</div></ul>';
	}
	$templater = vB_Template::create('tmnt_editplayer');
		$templater->register('userid', $userid);
		$templater->register('username', $username);
		$templater->register('cmpt', $cmpt);
		$templater->register('tid', $tid);
		$templater->register('score', $score);
		$templater->register('players', $players);
		$templater->register('tmnt', $tmnt);
		$templater->register('tmntp', $tmntp);
		$templater->register('id', $id);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'tournaments.php' => $vbphrase['tmnts'],
		tll_seo('tmnt', $tid, $tmnt['title'], 1) => $tmnt['title'],
		'' => construct_phrase($vbphrase['tmnt_editingplayer'])
	));
	if ($_REQUEST['ajax']==1)
	{
		$tlhtml = str_replace("href=\"tournaments.php?do=view&amp;id=$tid\"",'href="javascript://" onclick="close_tll_popup();"', $tlhtml);
		print_r($tlhtml);
		exit;
	}
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'swapplayer')
{
    $id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	if (!$id) {
		$errormessage = $vbphrase['error_invalid_player'];
        eval(standard_error($errormessage));
	}
	$players = $vbulletin->db->query_first("SELECT userid, username, tid FROM " . TABLE_PREFIX . "tmnt_players WHERE id=$id");
	$userid   = $players['userid'];
	$username = $players['username'];
	$tid      = $players['tid'];
	$tmnt = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_tmnts WHERE id='$tid' ");
	if ($tmnt['userid'] != $thisuserid) 
	{
		if (!$tmntp['canedittmnt'])
		{
			print_no_permission();
		} 
	}
	$team = false;
	if ($tmnt['pot'])
	{
		$team = true;
		$vbphrase['tmnt_swapplayers'] = $vbphrase['tmnt_swapteams'];
		$teamarray = array();
		$teams_array = $vbulletin->db->query_read("
			SELECT * FROM " . TABLE_PREFIX . "tmnt_teams
			ORDER BY teamname
		");
		while($row = $vbulletin->db->fetch_array($teams_array))
		{
			$stest = $vbulletin->db->query_first("SELECT id FROM " . TABLE_PREFIX . "tmnt_players WHERE id != '$id' AND userid = '".$row['teamid']."' AND tid = '$tid' ");
			if (!$stest)
			{
				$teamarray[] = $row;
			}
		}
	}
	if ($tmnt['allowreserves'])
	{
		$tmnt['reserves_array'] = array();
		$resquery = $vbulletin->db->query_read("
			SELECT r.*, " . ($tmnt['pot'] ? "t.teamname" : "u.username") . " AS username
			FROM " . TABLE_PREFIX . "tmnt_reserves AS r
			" . (!$tmnt['pot'] ? "LEFT JOIN " . TABLE_PREFIX . "user AS u
				ON (u.userid = r.userid)" : "") . "
			" . ($tmnt['pot'] ? "LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS t
				ON (t.teamid = r.userid)" : "") . "
			WHERE r.tmntid = '$tid' 
		");
		while($reserve = $vbulletin->db->fetch_array($resquery))
		{
			if ($tmnt['pot'])
			{
				$reserve['url'] = tll_seo('team', $reserve['userid'], $reserve['username']);
			}
			else
			{
				$reserve['url'] = fetch_seo_url('member', $reserve);
			}
			$tmnt['reserves_array'][] = $reserve;
		}
	}
	$templater = vB_Template::create('tmnt_swapplayer');
		$templater->register('id', $id);
		$templater->register('tmnt', $tmnt);
		$templater->register('team', $team);
		$templater->register('teamarray', $teamarray);
		$templater->register('players', $players);
		$templater->register('userid', $userid);
		$templater->register('username', $username);
		$templater->register('tid', $tid);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'tournaments.php?'. $vbulletin->session->vars['sessionurl_q'] => $vbphrase['tmnts'],
		'tournaments.php?do=view&id='.$tid. $vbulletin->session->vars['sessionurl_q'] => $tmnt['title'],
		'' => construct_phrase($vbphrase['tmnt_swappingplayer'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('headinclude', $headinclude);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('tlhtml', $tlhtml);
		$templater->register('modname', $modname);
		$templater->register('header', $header);
		$templater->register('footer', $footer);
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_POST['do'] == 'doswap')
{
	$id = $vbulletin->input->clean_gpc('p', 'id', TYPE_UINT);
	$player = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_players WHERE id = '$id'");
	if (!$player)
	{
		$errormessage = $vbphrase['error_invalid_player'];
		eval(standard_error($errormessage));
	}
	$tmnt = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_tmnts WHERE id='".$player['tid']."' ");
	if ($tmnt['userid'] != $thisuserid OR !$tmnt) {
	if (!$tmntp['canedittmnt'] OR !$tmnt) {
		print_no_permission();
	} }
	$username = trim($vbulletin->input->clean_gpc('p', 'username', TYPE_STR));
	$teamid = $vbulletin->input->clean_gpc('p', 'teamid', TYPE_UINT);
	if ($tmnt['pot'])
	{
		if ($username)
		{
			$user = $vbulletin->db->query_first("SELECT teamid AS userid FROM " . TABLE_PREFIX . "tmnt_teams WHERE teamname = '".$vbulletin->db->escape_string($username)."' ");
		}
		elseif ($teamid)
		{
			$user = $vbulletin->db->query_first("SELECT teamid AS userid, teamname AS username FROM " . TABLE_PREFIX . "tmnt_teams WHERE teamid = '".$vbulletin->db->escape_string($teamid)."' ");
			$username = $user['username'];
		}
	}
	else
	{
		if (!$username)
		{
			$errormessage = $vbphrase['error_no_username'];
			eval(standard_error($errormessage));
		}
		$user = $vbulletin->db->query_first("SELECT userid FROM " . TABLE_PREFIX . "user WHERE username = '".$vbulletin->db->escape_string($username)."' ");
	}
	if (!$user['userid'])
	{
		$errormessage = $vbphrase['error_no_userid'];
        eval(standard_error($errormessage));
	}
	$checkplayer = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_players WHERE userid = '".$user['userid']."' AND tid = '".$player['tid']."' AND id != '$id'");
	if ($checkplayer)
	{
		$errormessage = construct_phrase($vbphrase['error_already_joined_tmnt'], $username);
		eval(standard_error($errormessage));
	}
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_players SET userid='".$vbulletin->db->escape_string($user['userid'])."', username='".$vbulletin->db->escape_string($username)."' WHERE id='$id'");
	$vbulletin->url = "tournaments.php?do=view&id=".$player['tid'];	
	eval(print_standard_redirect('redirect_swapplayer'));
}

// #############################################################################

if ($_REQUEST['do'] == 'admin_checkin')
{
	if (!$tmntp['canedittmnt'])
	{
		print_no_permission();
	}
	$tid = $id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	$userid = $u = $vbulletin->input->clean_gpc('g', 'u', TYPE_UINT);
	$tmnt = $vbulletin->db->query_first("SELECT * FROM ". TABLE_PREFIX ."tmnt_tmnts WHERE id = '$id' AND status != '3' AND checkin > 0 AND pot = 0");
	if (!$tmnt)
	{
		$errormessage = $vbphrase['error_invalid_tournament'];
        eval(standard_error($errormessage));
	}
	if (!$userid)
	{
		$errormessage = $vbphrase['error_invalid_player'];
        eval(standard_error($errormessage));
	}
	if ($_REQUEST['reserve'])
	{
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_reserves SET checkedin = '".TIMENOW."' WHERE tmntid = '$id' AND userid = '$userid'");
	}
	else
	{
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_players SET checkedin = '".TIMENOW."' WHERE tid = '$id' AND userid = '$userid'");
	}
	$vbulletin->url = "tournaments.php?do=view&id=".$tid;	
	eval(print_standard_redirect('redirect_updatetmnt'));
}
// #############################################################################

if ($_REQUEST['do'] == 'checkin')
{
	if (!$tmntp['canjointmnt'])
	{
		print_no_permission();
	}
	$tid = $id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	$teamid = $vbulletin->input->clean_gpc('g', 'teamid', TYPE_UINT);
	$tmnt = $vbulletin->db->query_first("SELECT * FROM ". TABLE_PREFIX ."tmnt_tmnts WHERE id = '$id' AND status != '3' AND checkin > 0");
	if (!$tmnt)
	{
		$errormessage = $vbphrase['error_invalid_tournament'];
        eval(standard_error($errormessage));
	}
	if (!$tmnt['pot'])
	{
		
		if ($_REQUEST['reserve'])
		{
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_reserves SET checkedin = '".TIMENOW."' WHERE tmntid = '$id' AND userid = '$thisuserid'");	
		}
		else
		{
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_players SET checkedin = '".TIMENOW."' WHERE tid = '$id' AND userid = '$thisuserid'");
		}
	}
	else
	{
		if (!$teamid)
		{
			$errormessage = 'No teamid';
			eval(standard_error($errormessage));
		}
		$isq = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_members WHERE teamid = '$teamid' AND userid = '$thisuserid'");
		if (!$isq['leader'] && !$tmntp['canedittmnt'])
		{
			$errormessage = 'You are not leader of this team.';
			eval(standard_error($errormessage));
		}
		if ($_REQUEST['reserve'])
		{
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_reserves SET checkedin = '".TIMENOW."' WHERE tmntid = '$id' AND userid = '$teamid'");
		}
		else
		{
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_players SET checkedin = '".TIMENOW."' WHERE tid = '$id' AND userid = '$teamid'");
		}
	}
	$vbulletin->url = "tournaments.php?do=view&id=".$tid;	
	eval(print_standard_redirect('redirect_updatetmnt'));
}

// #############################################################################

if ($_REQUEST['do'] == 'restart')
{
	if (!$tmntp['canedittmnt'])
	{
		print_no_permission();
	}
	$tid = $id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	if (!$id)
	{
		$errormessage = $vbphrase['error_invalid_tournament'];
        eval(standard_error($errormessage));
	}
	$tmnt = $vbulletin->db->query_first("SELECT * FROM ". TABLE_PREFIX ."tmnt_tmnts WHERE id = '$id' AND status = '2'");
	if (!$tmnt)
	{
		$errormessage = $vbphrase['error_invalid_tournament'];
        eval(standard_error($errormessage));
	}
	$cp = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_players WHERE tid = '$tid' AND userid = '0'");
	if ($cp['countrows'])
	{
		$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "tmnt_players WHERE userid=0 AND tid=$tid");
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_tmnts SET freeslots = freeslots+".$cp['countrows']." WHERE id=$tid");
	}
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_tmnts SET noplayers = noplayers+1, freeslots = freeslots+1, status=1 WHERE id=$id");
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_players SET round = 0, round2 = 0, round3 = 0, round4 = 0, round5 = 0, round6 = 0, round7 = 0, winner = 0, score = 0, round8 = 0, round9 = 0, round10 = 0, round11 = 0, round12 = 0, round13 = 0, round14 = 0, score = 0, loser_rounds = '' WHERE tid = '$id'");
	$vbulletin->url = "tournaments.php?do=view&id=".$tid;	
	eval(print_standard_redirect('redirect_updatetmnt'));
}

// #############################################################################

if ($_POST['do'] == 'insertjoin')
{
	if (!$tmntp['canjointmnt'])
	{
		print_no_permission();
	}
	$id = $vbulletin->input->clean_gpc('p', 'id', TYPE_UINT);
	$tmnt = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_tmnts WHERE id = '$id'");
	if (!$tmnt)
	{
		$errormessage = $vbphrase[error_invalid_tournament];
		eval(standard_error($errormessage));
	}
	$pot = $vbulletin->input->clean_gpc('p', 'pot', TYPE_INT);
		if ($pot == 0) {
			$team = false;
		} elseif ($pot == 1) {
			$team = true;
		}
	/*if (!$team) {
	$userid = $vbulletin->input->clean_gpc('p', 'userid', TYPE_UINT);
		if (!$userid) {
			$userid = $thisuserid;
		}
	$username = $vbulletin->input->clean_gpc('p', 'username', TYPE_STR);
		if (!$username) {
			$username = $thisusername;
		}
	}*/
	//print_r('a');
	if ($team)
	{
		$userid = $vbulletin->input->clean_gpc('p', 'teamid', TYPE_UINT);
			if (!$userid)
			{
				$errormessage = $vbphrase[error_invalid_team];
				eval(standard_error($errormessage));
			}
		$team = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_teams WHERE teamid=$userid ");
		$username = $team['teamname'];
			if (!$username)
			{
				$errormessage = $vbphrase[error_invalid_team];
				eval(standard_error($errormessage));
			}
	}
	else
	{
		$userid = $thisuserid;
		$username = $thisusername;
	}
	$slot = rand();
	$countplayer = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_players WHERE tid = '$id' AND (userid = '$userid' OR username='".$vbulletin->db->escape_string($username)."') ");
	$countplayer = $countplayer['countrows'];  
	if ($countplayer > 0)
	{
		$errormessage = construct_phrase($vbphrase['error_already_joined_tournament'], $id);
		eval(standard_error($errormessage));
	}
	if ($_POST['reserve'])
	{
		$countplayers = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_reserves WHERE tmntid = '$id' AND userid = '$userid' ");
		if ($countplayers['countrows'] > 0)
		{
			$errormessage = construct_phrase($vbphrase['error_already_joined_tournament'], $id);
			eval(standard_error($errormessage));
		}
		$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "tmnt_reserves
			(userid, tmntid, dateline)
			VALUES ('".$userid."', '".$id."', ".TIMENOW.")
		");	
		$vbulletin->url = "tournaments.php?do=view&id=".$id;	
		eval(print_standard_redirect('redirect_jointmnt'));
	}
	$freeslots = $tmnt['freeslots'];
	$noplayers = $tmnt['noplayers'];
	$tmnt = switch_tmnt_status($tmnt);
	if ($freeslots == 0)
	{	
		$errormessage = $vbphrase['error_no_free_slots'];
		if ($status == $vbphrase['tmnt_waiting'])
		{
			process_full_tmnt($id);
		}	
		eval(standard_error($errormessage));
	}
require_once(DIR . '/includes/functions_tll_prem.php');
	if (!$team && $tmnt['join_cost'] > 0 && $vbulletin->options['tmnt_credit_system'])
	{
		if (!tll_check_credits($vbulletin->userinfo, $tmnt['join_cost'], 1))
		{
			$errormessage = 'Error, insufficient credits. Joining this tournament costs '.$tmnt['join_cost'].' credits, you only have '.$vbulletin->userinfo['tmnt_credits'].' credits.';
			eval(standard_error($errormessage));
			/*$vbc = $vbulletin->options['tmnt_vbcredits_conv'] * $tmnt['join_cost'];
			if (!$vbulletin->options['tmnt_credits_vbcredits'] OR $vbulletin->userinfo['vbcredits_1']<=0 OR $vbulletin->userinfo['vbcredits_1'] < $vbc)
			{
				
			}
			if ($vbulletin->userinfo['vbcredits_1'] >= $vbc)
			{
				$usernote = 'Swapped '.$vbc.' forum credits for ' . $tmnt['join_cost'] . ' competition credits.';
				VBCREDITS::action(
					'adjust', 
					$vbulletin->userinfo['userid'], 
					null, 
					false, 
					array(
						'currencyid' => 1, 
						'userinfo' => $vbulletin->userinfo, 
						'multiplier' => -$vbc, 
						'message' => $usernote
					)
				);
				VBCREDITS::shutdown();
				process_credits_transaction($vbulletin->userinfo['userid'], $tmnt['join_cost'], $usernote);
			}*/
		}
		process_credits_transaction($userid, -$tmnt['join_cost'], 'Joined tournament');
		update_forum_creditprofit(vbdate('W',TIMENOW), vbdate('Y',TIMENOW), $tmnt['join_cost'], TIMENOW);
	}
	elseif ($team && $tmnt['join_cost'] > 0 && $vbulletin->options['tmnt_credit_system'])
	{
		if ($team['tmnt_credits'] < $tmnt['join_cost'])
		{
			$errormessage = 'Error, insufficient credits. Joining this tournament costs '.$tmnt['join_cost'].' credits, your team only has '.$team['tmnt_credits'].' credits.';
			eval(standard_error($errormessage));
		}
require_once(DIR . '/includes/functions_tll_prem.php');		
		process_credits_transaction($userid, -$tmnt['join_cost'], 'Joined tournament', 0, 0, $userid, 1);
		update_forum_creditprofit(vbdate('W',TIMENOW), vbdate('Y',TIMENOW), $tmnt['join_cost'], TIMENOW);
	}
	$freeslots = $freeslots-1;
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_tmnts SET freeslots = '$freeslots' WHERE id = $id ");
	if ($freeslots == 0)
	{
		process_full_tmnt($id);
	}
	$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "tmnt_players
		(userid, username, tid, time, slot, pot, score)
		VALUES ('".$userid."', '".$vbulletin->db->escape_string($username)."', '".$id."', ".TIMENOW.", '".$slot."', '".$pot."', '".$tmnt['starting_points']."')
	");
	if ($team)
	{
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_teams SET joins = joins + 1 WHERE teamid=$userid");
		if ($tmnt['comp_ugid'])
		{
			$members = $vbulletin->db->query_read("
				SELECT m.*, u.username
				FROM " . TABLE_PREFIX . "tmnt_members AS m
				LEFT JOIN " . TABLE_PREFIX . "user AS u
					ON (u.userid = m.userid)
				WHERE m.teamid = '$userid'
					AND m.accepted = 1
			");
			while($m = $vbulletin->db->fetch_array($members))
			{
				$userinfo = fetch_userinfo($m['userid']);
				$user = $userinfo;
				$newmembergroupid = $tmnt['comp_ugid'];
				$user['membergroupids']=explode(',',$user['membergroupids']);
				if (!in_array($newmembergroupid, $user['membergroupids']))
				{
					$user['membergroupids'][]=$newmembergroupid;
				}
				else
				{
					continue;
				}
				//$display_usergroup = $newmembergroupid;
				$user['membergroupids']=implode(',',$user['membergroupids']);
				$userdata =& datamanager_init('User', $vbulletin, ERRTYPE_STANDARD);
				$userdata->set_existing($userinfo);
				$userdata->set('membergroupids', $user['membergroupids']);
				/*$userdata->set_usertitle(
						$userinfo['usertitle'],
						true,
						$vbulletin->usergroupcache["$newmembergroupid"],
						false,
						true
				);*/
				$userdata->save();
			}
		}
	}
	else
	{
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET tmnt_joins = tmnt_joins + 1 WHERE userid=$userid");
		if ($tmnt['comp_ugid'])
		{
			$user = $userinfo = $vbulletin->userinfo;
			$newmembergroupid = $tmnt['comp_ugid'];
			$user['membergroupids']=explode(',',$user['membergroupids']);
			$user['membergroupids'][]=$newmembergroupid;
			//$display_usergroup = $newmembergroupid;
			$user['membergroupids']=implode(',',$user['membergroupids']);
			$userdata =& datamanager_init('User', $vbulletin, ERRTYPE_STANDARD);
			$userdata->set_existing($userinfo);
			$userdata->set('membergroupids', $user['membergroupids']);
			/*$userdata->set_usertitle(
					$userinfo['usertitle'],
					true,
					$vbulletin->usergroupcache["$newmembergroupid"],
					false,
					true
			);*/
			$userdata->save();
		}
	}
	if ($tmnt['password'])
	{
		$urll = '&password='.$tmnt['password'];
	}
	$vbulletin->url = "tournaments.php?do=view&id=".$id.$urll;	
	eval(print_standard_redirect('redirect_jointmnt'));
}

// #############################################################################

if ($_POST['do'] == 'insertplayer')
{
	$tid = $id = $vbulletin->input->clean_gpc('p', 'id', TYPE_UINT);
		if (!$id)
		{
			$errormessage = $vbphrase[error_invalid_tournament];
			eval(standard_error($errormessage));
		}
	$tmnt = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_tmnts WHERE id=$id AND freeslots > 0");
	if (!$tmnt)
	{
		$errormessage = $vbphrase[error_invalid_tournament];
		eval(standard_error($errormessage));
	}
	if ($tmnt['userid'] != $thisuserid AND !$tmntp['canedittmnt'])
	{
		print_no_permission();
	}
	if ($tmnt['pot'])
	{//teams
		$userid = $teamid = $vbulletin->input->clean_gpc('p', 'teamid', TYPE_UINT);
		$team = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_teams WHERE teamid = '".$vbulletin->db->escape_string($teamid)."' ");
		if (!$team)
		{
			$errormessage = $vbphrase['error_invalid_team'];
			eval(standard_error($errormessage));
		}
		$slot = rand();
		$countplayer = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_players WHERE tid = '$id' AND userid=$teamid ");
		if ($countplayer['countrows'] != 0)
		{
			$errormessage = 'Error, team is already in tournament.';
			eval(standard_error($errormessage));
		}
		if ($tmnt['join_cost'] > 0 && $vbulletin->options['tmnt_credit_system'])
		{
require_once(DIR . '/includes/functions_tll_prem.php');		
			if ($team['tmnt_credits'] < $tmnt['join_cost'])
			{
				$errormessage = 'Error, team has insufficient credits to join this tournament.';
				eval(standard_error($errormessage));
			}
			else
			{
				process_credits_transaction($teamid, -$tmnt['join_cost'], 'Joined tournament', 0, 0, $teamid, 1);
				update_forum_creditprofit(vbdate('W',TIMENOW), vbdate('Y',TIMENOW), $tmnt['join_cost'], TIMENOW);
			}
		}
		$vbulletin->db->query_write("
			INSERT INTO " . TABLE_PREFIX . "tmnt_players
				(userid, username, tid, time, slot, pot, score)
			VALUES
				('".$vbulletin->db->escape_string($teamid)."', '".$vbulletin->db->escape_string($team['teamname'])."', '".$vbulletin->db->escape_string($id)."', ".TIMENOW.", '".$vbulletin->db->escape_string($slot)."', 1, '".$tmnt['starting_points']."')
		");
		$freeslots = $tmnt['freeslots'];
		$tmnt = switch_tmnt_status($tmnt);
		$status = $tmnt['status'];
		$noplayers = $tmnt['noplayers'];
		if ($freeslots == 0)
		{
			process_full_tmnt($id);
			$errormessage = $vbphrase['error_no_free_slots'];
			eval(standard_error($errormessage));
		}
		$freeslots = $freeslots-1;
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_tmnts SET freeslots = '".$vbulletin->db->escape_string($freeslots)."' WHERE id=$id ");
		if ($freeslots == 0)
		{
			process_full_tmnt($id);
		}
		$vbulletin->url = "tournaments.php?do=view&id=".$id;
		eval(print_standard_redirect('redirect_insertplayer'));
		//end teams
	}
	$usernames = $vbulletin->input->clean_gpc('p', 'username', TYPE_STR);
		if (!$usernames)
		{
			$errormessage = $vbphrase['error_no_username'];
			eval(standard_error($errormessage));
		}
	$usernames = explode(';',$usernames);
	foreach ($usernames AS $hash => $username)
	{
		$username = trim($username);
		$user = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "user WHERE username = '".$vbulletin->db->escape_string($username)."' ");
		if (!$user['userid'])
		{
			continue;
		}
		else
		{
			$userid = $user['userid'];
		}
		$slot = rand();
		$countplayer = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_players WHERE tid = '$id' AND (userid=$userid OR username='".$vbulletin->db->escape_string($username)."') ");
		$countplayer = $countplayer['countrows'];  
		if ($countplayer != 0)
		{
			continue;
		}
		$tmnt = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_tmnts WHERE id = '$id' ");
		$freeslots = $tmnt['freeslots'];
		$tmnt = switch_tmnt_status($tmnt);
		$status = $tmnt['status'];
		$noplayers = $tmnt['noplayers'];
		if ($freeslots == 0)
		{
			process_full_tmnt($id);
			$errormessage = $vbphrase['error_no_free_slots'];
			eval(standard_error($errormessage));
		}
		if ($tmnt['join_cost'] > 0 && $vbulletin->options['tmnt_credit_system'])
		{
require_once(DIR . '/includes/functions_tll_prem.php');	
			if (!tll_check_credits($user, $tmnt['join_cost'], 1))
			{
				continue;
			}
			else
			{	
				process_credits_transaction($user['userid'], -$tmnt['join_cost'], 'Joined tournament');
				update_forum_creditprofit(vbdate('W',TIMENOW), vbdate('Y',TIMENOW), $tmnt['join_cost'], TIMENOW);
			}
		}
		$vbulletin->db->query_write("
			INSERT INTO " . TABLE_PREFIX . "tmnt_players
				(userid, username, tid, time, slot, score)
			VALUES
				('".$vbulletin->db->escape_string($userid)."', '".$vbulletin->db->escape_string($username)."', '".$vbulletin->db->escape_string($id)."', ".TIMENOW.", '".$vbulletin->db->escape_string($slot)."', '".$tmnt['starting_points']."')
		");
		$freeslots = $freeslots-1;
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_tmnts SET freeslots = '".$vbulletin->db->escape_string($freeslots)."' WHERE id=$id ");
		if ($freeslots == 0)
		{
			process_full_tmnt($id);
		}
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET tmnt_joins = tmnt_joins + 1 WHERE userid=$userid");
		if ($tmnt['comp_ugid'])
		{
			$user = $userinfo = fetch_userinfo($userid);
			$newmembergroupid = $tmnt['comp_ugid'];
			$user['membergroupids']=explode(',',$user['membergroupids']);
			$user['membergroupids'][]=$newmembergroupid;
			//$display_usergroup = $newmembergroupid;
			$user['membergroupids']=implode(',',$user['membergroupids']);
			$userdata =& datamanager_init('User', $vbulletin, ERRTYPE_STANDARD);
			$userdata->set_existing($userinfo);
			$userdata->set('membergroupids', $user['membergroupids']);
			/*$userdata->set_usertitle(
					$userinfo['usertitle'],
					true,
					$vbulletin->usergroupcache["$newmembergroupid"],
					false,
					true
			);*/
			$userdata->save();
		}
		$addedusernames .= ($addedusernames ? ', ' : '') . $username;
	}
	if ($tmnt['password'])
	{
		$urll = '&password='.$tmnt['password'];
	}
	if ($freeslots > 0)
	{
		$vbulletin->url = "tournaments.php?do=addplayer&tid=".$id."&added=success&username=".$addedusernames."&freeslots=".$freeslots;
	}
	else
	{
		$vbulletin->url = "tournaments.php?do=view&id=".$id.$urll;
	}
	eval(print_standard_redirect('redirect_insertplayer'));
}

// #############################################################################

if ($_POST['do'] == 'submitloss')
{
	if (!$tmntp['canjointmnt'])
	{
		print_no_permission();
	}
	$tid = $vbulletin->input->clean_gpc('g', 'tid', TYPE_UINT);
	if (!$tid)
	{
		$errormessage = $vbphrase['error_invalid_tournament'];
        eval(standard_error($errormessage));
	}
	$userid = $vbulletin->userinfo['userid'];
	$tmnt = $vbulletin->db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_tmnts 
		WHERE id = '$tid' AND pot = '0' AND status = 2 AND type = '1v1'
	");
	if (!$tmnt)
	{
		$errormessage = $vbphrase['error_invalid_tournament'];
        eval(standard_error($errormessage));
	}
	$player = $vbulletin->db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_players
		WHERE tid = '$tid'
			AND userid = '$userid'
			AND pot = '0'
	");
	$players = $tmnt['noplayers'];
	if ($players <= 2)
	{
		$rounds = 1;
	}
	elseif ($players <= 4)
	{
		$rounds = 2;
	}
	elseif ($players <= 8)
	{
		$rounds = 3;
	}
	elseif ($players <= 16)
	{
		$rounds = 4;
	}
	elseif ($players <= 32)
	{
		$rounds = 5;
	}
	elseif ($players <= 64)
	{
		$rounds = 6;
	}
	elseif ($players <= 128)
	{
		$rounds = 7;
	}
	elseif ($players <= 256)
	{
		$rounds = 8;
	}
	elseif ($players <= 512)
	{
		$rounds = 9;
	}
	$rounds++;
	$i = $rounds;
	while ($i >= 1)
	{
		if ($i == 1)
		{
			$x = $player['slot'];
			if ($x > 0)
			{
				$count = $vbulletin->db->query_first("
					SELECT COUNT(*) AS countrows
					FROM " . TABLE_PREFIX . "tmnt_players
					WHERE slot < '$x'
						AND tid = '$tid'
				");
				
				$x = $count['countrows'] + 1;
				if ($x % 2)
				{
					$y = $x + 1;
					$pr = $y / 2;
				}
				else
				{
					$y = $x - 1;
					$pr = $x / 2;
				}
				
				$op = $vbulletin->db->query_first("
					SELECT *
					FROM " . TABLE_PREFIX . "tmnt_players
					WHERE tid = '$tid'
					ORDER BY slot ASC
					LIMIT ".($y-1).", 1
				");
				break;
			}
		} 
		else
		{
			$x = $player['round'.$i];
			if ($x > 0)
			{
				if ($x % 2)
				{
					$y = $x + 1;
					$pr = $y / 2;
				}
				else
				{
					$y = $x - 1;
					$pr = $x / 2;
				}
				$op = $vbulletin->db->query_first("
					SELECT *
					FROM " . TABLE_PREFIX . "tmnt_players
					WHERE tid = '$tid'
						AND round$i = '$y'
						AND pot = '0'
				");
				if (!$op)
				{
					$errormessage = "Error. No opponent.";
					eval(standard_error($errormessage));
				}
				break;
			}
		}
		$i--;
	}
	$j = $i + 1;
	$pp = $vbulletin->db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_players
		WHERE tid = '$tid'
			AND round$j = '$pr'
			AND pot = '0'
	");
	if ($pp)
	{
		$errormessage = "Error. Next round filled.";
        eval(standard_error($errormessage));
	}
	if ($i + 1 == $rounds)
	{
		$final = true;
	}
	if ($final)
	{
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_players SET round".$j." = '".$pr."', winner = '1' WHERE tid='".$tid."' AND userid='".$op['userid']."' ");
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET tmnt_wins = tmnt_wins + 1 WHERE userid = '".$op['userid']."' ");
		$vbulletin->db->query_write("
			UPDATE " . TABLE_PREFIX . "tmnt_tmnts
			SET status = '3' WHERE id = '$tid'
		");
		if ($tmnt['win_credits'] > 0 && $vbulletin->options['tmnt_credit_system'])
		{//winner gets credits
require_once(DIR . '/includes/functions_tll_prem.php');		
			if ($tmnt['pot'])
			{
				process_credits_transaction($op['userid'], $tmnt['win_credits'], 'Won tournament', 0, 0, $op['userid'], 1);
			}
			else
			{
				process_credits_transaction($op['userid'], $tmnt['win_credits'], 'Won tournament');
			}
			update_forum_creditprofit(vbdate('W',TIMENOW), vbdate('Y',TIMENOW), -$tmnt['win_credits'], TIMENOW);
		}
		
		if ($tmnt['ladderid'])
		{
			if ($tmnt['lwinxp'])
			{
				list($tmnt['xp_1st'], $tmnt['xp_2nd'], $tmnt['xp_3rd']) = explode(',', $tmnt['lwinxp']);
			}
			else
			{
				$tmnt['xp_1st'] = $tmnt['xp_2nd'] = $tmnt['xp_3rd'] = 0;
			}
			$userids2nd = implode("' OR userid = '", $winners2nd);
			$userids3rd = implode("' OR userid = '", $winners3rd);
			if ($tmnt['prize'] OR $tmnt['xp_1st'] OR $tmnt['xp_2nd'] OR $tmnt['xp_3rd'])
			{
				if ($tmnt['prize'] OR $tmnt['xp_1st'])
				{
					$vbulletin->db->query_write("
						UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
						SET rank = rank + " . $tmnt['prize'] . "
						" . ($tmnt['xp_1st'] ? ", xp = xp + " . $tmnt['xp_1st'] : "") . "
						WHERE userid = '".$op['userid']."'
							AND lid = '" . $tmnt['ladderid'] . "'
					");
				}
				if ($tmnt['xp_2nd'] > 0 && $userids2nd)
				{
					$vbulletin->db->query_write("
						UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
						SET xp = xp + $tmnt[xp_2nd]
						WHERE (userid = '$userids2nd')
							AND lid = '" . $tmnt['ladderid'] . "'
					");
				}
				if ($tmnt['xp_3rd'] > 0 && $userids3rd)
				{
					$vbulletin->db->query_write("
						UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
						SET xp = xp + $tmnt[xp_3rd]
						WHERE (userid = '$userids3rd')
							AND lid = '" . $tmnt['ladderid'] . "'
					");
				}
			}
		}
	}
	else
	{
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_players SET round".$j." = '".$pr."' WHERE tid='".$tid."' AND userid='".$op['userid']."' ");
	}
	if ($tmnt['password'])
	{
		$urll = '&password='.$tmnt['password'];
	}
	$vbulletin->url = "tournaments.php?do=view&id=" . $tid.$urll;	
	eval(print_standard_redirect('redirect_submitloss'));
}

// #############################################################################

if ($_REQUEST['do'] == 'submitloss')
{
	if (!$tmntp['canjointmnt'])
	{
		print_no_permission();
	}
	$tid = $vbulletin->input->clean_gpc('g', 'tid', TYPE_UINT);
	if (!$tid)
	{
		$errormessage = $vbphrase['error_invalid_tournament'];
        eval(standard_error($errormessage));
	}
	$userid = $vbulletin->userinfo['userid'];
	$tmnt = $vbulletin->db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_tmnts 
		WHERE id = '$tid' AND pot = '0' AND status = 2 AND type = '1v1'
	");
	if (!$tmnt)
	{
		$errormessage = $vbphrase['error_invalid_tournament'];
        eval(standard_error($errormessage));
	}
	$player = $vbulletin->db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_players
		WHERE tid = '$tid'
			AND userid = '$userid'
			AND pot = '0'
	");
	$players = $tmnt['noplayers'];
	if ($players <= 2)
	{
		$rounds = 1;
	}
	elseif ($players <= 4)
	{
		$rounds = 2;
	}
	elseif ($players <= 8)
	{
		$rounds = 3;
	}
	elseif ($players <= 16)
	{
		$rounds = 4;
	}
	elseif ($players <= 32)
	{
		$rounds = 5;
	}
	elseif ($players <= 64)
	{
		$rounds = 6;
	}
	elseif ($players <= 128)
	{
		$rounds = 7;
	}
	elseif ($players <= 256)
	{
		$rounds = 8;
	}
	elseif ($players <= 512)
	{
		$rounds = 9;
	}
	$rounds++;
	$i = $rounds;
	while ($i >= 1)
	{
		if ($i == 1)
		{
			$x = $player['slot'];
			if ($x > 0)
			{
				$count = $vbulletin->db->query_first("
					SELECT COUNT(*) AS countrows
					FROM " . TABLE_PREFIX . "tmnt_players
					WHERE slot < '$x'
						AND tid = '$tid'
				");
				
				$x = $count['countrows'] + 1;
				//print_r(" \$x = $x <br>");
				if ($x % 2)
				{
					$y = $x + 1;
					$pr = $y / 2;
				}
				else
				{
					$y = $x - 1;
					$pr = $x / 2;
				}
				
				$op = $vbulletin->db->query_first("
					SELECT *
					FROM " . TABLE_PREFIX . "tmnt_players
					WHERE tid = '$tid'
					ORDER BY slot ASC
					LIMIT ".($y-1).", 1
				");
				break;
			}
		} 
		else
		{
			$x = $player['round'.$i];
			if ($x > 0)
			{
				if ($x % 2)
				{
					$y = $x + 1;
					$pr = $y / 2;
				}
				else
				{
					$y = $x - 1;
					$pr = $x / 2;
				}
				$op = $vbulletin->db->query_first("
					SELECT *
					FROM " . TABLE_PREFIX . "tmnt_players
					WHERE tid = '$tid'
						AND round$i = '$y'
						AND pot = '0'
				");
				if (!$op)
				{
					$errormessage = "Please wait for your opponent to progress through to round $i.";
					if ($_REQUEST['ajax']==1)
					{
						$tlhtml = tll_popup_standard_error($errormessage);
						print_r($tlhtml);
						exit;
					}
					eval(standard_error($errormessage));
				}
				break;
			}
		}
		//print_r(" round $i = $x <br> ");
		$i--;
	}
	$j = $i + 1;
	//dominic
	$pp = $vbulletin->db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_players
		WHERE tid = '$tid'
			AND round$j = '$pr'
			AND pot = '0'
	");
	if ($pp)
	{
		$errormessage = "Error. You are already out of this tournament.";
		if ($_REQUEST['ajax']==1)
		{
			$tlhtml = tll_popup_standard_error($errormessage);
			print_r($tlhtml);
			exit;
		}
        eval(standard_error($errormessage));
	}
	if ($i + 1 == $rounds)
	{
		$final = true;
	}
	if ($op['userid']==0 && $op['username']=='Bye' && $j == 2)
	{
		//progress player to round 2 if first round is against a bye player
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_players SET round".$j." = '".$pr."' WHERE tid='".$tid."' AND userid='".$userid."' ");
		$vbulletin->url = "tournaments.php?do=view&id=" . $tid;	
		if ($_REQUEST['ajax']==1)
		{
			print_r("Reload");
			exit;
		}
		eval(print_standard_redirect('redirect_submitloss'));
	}
	$templater = vB_Template::create('tmnt_submitloss');
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt', $tmnt);
		$templater->register('op', $op);
		$templater->register('i', $i);
		$templater->register('j', $j);
	$tlhtml = $templater->render();
	if ($_REQUEST['ajax']==1)
	{
		$tlhtml = str_replace("href=\"tournaments.php?do=view&amp;id=$tid\"",'href="javascript://" onclick="close_tll_popup();"', $tlhtml);
		print_r($tlhtml);
		exit;
	}
	$navbits = array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'tournaments.php' . $vbulletin->session->vars['sessionurl_q'] . '?do=view' . "&amp;id=$tid" => $tmnt['title'],
		'' => construct_phrase($vbphrase['tmnt_submitloss'])
	);
	$navbar = render_navbar_template(construct_navbits($navbits));
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_POST['do'] == 'submitresult' && !$_POST['stopsubmit'])
{
	if (!$tmntp['canjointmnt'])
	{
		print_no_permission();
	}
	$vbulletin->input->clean_array_gpc('p', array(
		'tid'      => TYPE_UINT,
		'teamid'      => TYPE_UINT,
		'userid'      => TYPE_UINT,
		'admin'      => TYPE_BOOL,
		'score_u'      => TYPE_UINT,
		'score_u2'      => TYPE_UINT,
		'u'      => TYPE_UINT,
		'u2'      => TYPE_UINT,
		'screen'      => TYPE_NOHTML,
	));
	$admin = $vbulletin->GPC['admin'];
	$tid = $vbulletin->GPC['tid'];
	$score_u = $vbulletin->GPC['score_u'];
	$score_u2 = $vbulletin->GPC['score_u2'];
	$u = $vbulletin->GPC['u'];
	$u2 = $vbulletin->GPC['u2'];
	$screen = $vbulletin->GPC['screen'];
	$dateline = TIMENOW;
	if (!$admin)
	{
		$userid = $vbulletin->userinfo['userid'];
		if (!in_array($userid, array($u, $u2)))
		{
			print_no_permission();
		}
	}
	else
	{
		$userid = $vbulletin->GPC['userid'];
	}
	//print_r($userid);
	if (!$tid)
	{
		$errormessage = $vbphrase['error_invalid_tournament'];
        eval(standard_error($errormessage));
	}
	$tmnt = $vbulletin->db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_tmnts 
		WHERE id = '$tid' AND status = 2 AND type IN ('1v1', 'swiss')
	");
	if (!$tmnt)
	{
		$errormessage = $vbphrase['error_invalid_tournament'];
        eval(standard_error($errormessage));
	}
	if ($tmnt['pot'])
	{
		$userid = $vbulletin->GPC['teamid'];
		$team = true;
	}
	if ($_POST['stopsubmit'])
	{
		$errormessage = 'Error 3443';
        eval(standard_error($errormessage));
	}
	$player = $vbulletin->db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_players
		WHERE tid = '$tid'
			AND userid = '$userid'
	");
	if (!$player)
	{
		print_no_permission();
	}
if ($tmnt['type']!='swiss')
{
	$players = $tmnt['noplayers'];
	if ($players <= 2)
	{
		$rounds = 1;
	}
	elseif ($players <= 4)
	{
		$rounds = 2;
	}
	elseif ($players <= 8)
	{
		$rounds = 3;
	}
	elseif ($players <= 16)
	{
		$rounds = 4;
	}
	elseif ($players <= 32)
	{
		$rounds = 5;
	}
	elseif ($players <= 64)
	{
		$rounds = 6;
	}
	elseif ($players <= 128)
	{
		$rounds = 7;
	}
	elseif ($players <= 256)
	{
		$rounds = 8;
	}
	elseif ($players <= 512)
	{
		$rounds = 9;
	}
	$rounds++;
	$i = $rounds;
	while ($i >= 1)
	{
		if ($i == 1)
		{
			$x = $player['slot'];
			if ($x > 0)
			{
				$count = $vbulletin->db->query_first("
					SELECT COUNT(*) AS countrows
					FROM " . TABLE_PREFIX . "tmnt_players
					WHERE slot < '$x'
						AND tid = '$tid'
				");
				
				$x = $count['countrows'] + 1;
				//print_r(" \$x = $x <br>");
				if ($x % 2)
				{
					$y = $x + 1;
					$pr = $y / 2;
				}
				else
				{
					$y = $x - 1;
					$pr = $x / 2;
				}
				
				$op = $vbulletin->db->query_first("
					SELECT *
					FROM " . TABLE_PREFIX . "tmnt_players
					WHERE tid = '$tid'
					ORDER BY slot ASC
					LIMIT ".($y-1).", 1
				");
				break;
			}
		} 
		else
		{
			$x = $player['round'.$i];
			if ($x > 0)
			{
				if ($x % 2)
				{
					$y = $x + 1;
					$pr = $y / 2;
				}
				else
				{
					$y = $x - 1;
					$pr = $x / 2;
				}
				$op = $vbulletin->db->query_first("
					SELECT *
					FROM " . TABLE_PREFIX . "tmnt_players
					WHERE tid = '$tid'
						AND round$i = '$y'
				");
				if (!$op)
				{
					$errormessage = "Please wait for your opponent to progress through to round $i.";
					eval(standard_error($errormessage));
				}
				break;
			}
		}
		//print_r(" round $i = $x <br> ");
		$i--;
	}
	$j = $i + 1;
	$pp = $vbulletin->db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_players
		WHERE tid = '$tid'
			AND round$j = '$pr'
	");
	if ($pp)
	{
		$errormessage = "Error. You are already out of this tournament.";
        eval(standard_error($errormessage));
	}
	if ($i + 1 == $rounds)
	{
		$final = 1;
	}
	else
	{
		$final = 0;
	}
}
else
{
		$i = 1;
		$q = $vbulletin->db->query_first("
			SELECT *
			FROM " . TABLE_PREFIX . "tmnt_result
			WHERE tid = '$tid'
				AND (userid = '$userid' OR opp_userid = '$userid') 
				AND (confirm_u = 0 OR confirm_u2 = 0)
			ORDER BY round ASC
		");	
		if ($q)
		{
			$i = $q['round'];
		}
		if ($i == 1)
		{
			$x = $player['slot'];
			if ($x > 0)
			{
				$count = $vbulletin->db->query_first("
					SELECT COUNT(*) AS countrows
					FROM " . TABLE_PREFIX . "tmnt_players
					WHERE slot < '$x'
						AND tid = '$tid'
				");
				
				$x = $count['countrows'] + 1;
				//print_r(" \$x = $x <br>");
				if ($x % 2)
				{
					$y = $x + 1;
					$pr = $y / 2;
				}
				else
				{
					$y = $x - 1;
					$pr = $x / 2;
				}
				
				$op = $vbulletin->db->query_first("
					SELECT *
					FROM " . TABLE_PREFIX . "tmnt_players
					WHERE tid = '$tid'
					ORDER BY slot ASC
					LIMIT ".($y-1).", 1
				");
			}
		} 
}
	if ($vbulletin->GPC['score_u'] == $vbulletin->GPC['score_u2'])
	{
		$errormessage = "Error, you cannot enter a draw.";
		eval(standard_error($errormessage));
	}
	$round = $i;
	$q = $vbulletin->db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_result
		WHERE tid = '$tid'
			AND round = '$i'
			AND (userid = '$userid' OR opp_userid = '$userid')
	");
	if ($q && $q['confirm_u'] && $q['confirm_u2'])
	{
		$errormessage = "Scores already confirmed for round $i.";
		if ($_REQUEST['ajax']==1)
		{
			$tlhtml = tll_popup_standard_error($errormessage);
			print_r($tlhtml);
			exit;
		}
		eval(standard_error($errormessage));
	}
	//print_r($op);
	//print_r($q);
	//exit;
	$slot = $x;
	$plusround = $round + 1;
	$minusround = $round - 1;
	if ($slot&1)
	{
		$ss = $slot + 1;
		$xx = $slot + 1;
	}
	else
	{
		$ss = $slot - 1;
		$xx = $slot;
	}
	$p = $xx / 2;
	if ($q)
	{
		if ($score_u > $score_u2)
		{
			$winner_userid = $q['userid'];
		}
		else
		{
			$winner_userid = $q['opp_userid'];
		}
		if ($admin)
		{
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_result SET score_u = '$score_u', score_u2 = '$score_u2', confirm_u = 1, confirm_u2 = 1 WHERE id = '".$q['id']."' ");
		}
		elseif ($q['userid'] == $userid)
		{//is_u
			if ($q['confirm_u2'] && $score_u == $q['score_u'] && $score_u2 == $q['score_u2'])
			{
				$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_result SET confirm_u = 1, screen_u = '".$vbulletin->db->escape_string($screen)."' WHERE id = '".$q['id']."' ");
				if ($tmnt['type']!='swiss')
				{
					$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_players SET round".$j." = '".$p."', winner = '$final' WHERE tid='".$tid."' AND userid='".$winner_userid."' ");
				}
				$finished = true;
			}
			else
			{
				$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_result SET score_u = '$score_u', score_u2 = '$score_u2', confirm_u = 1, confirm_u2 = 0, screen_u = '".$vbulletin->db->escape_string($screen)."' WHERE id = '".$q['id']."' ");
				if ($q['confirm_u2'])
				{
					$disagree = true;
				}
			}
			
		}
		else
		{//is_u2
			if ($q['confirm_u'] && $score_u == $q['score_u'] && $score_u2 == $q['score_u2'])
			{
				$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_result SET confirm_u2 = 1, screen_u2 = '$screen' WHERE id = '".$q['id']."' ");
				if ($tmnt['type']!='swiss')
				{
					$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_players SET round".$j." = '".$p."', winner = '$final' WHERE tid='".$tid."' AND userid='".$winner_userid."' ");
				}
				$finished = true;
			}
			else
			{
				$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_result SET score_u = '$score_u', score_u2 = '$score_u2', confirm_u = 0, confirm_u2 = 1, screen_u2 = '".$vbulletin->db->escape_string($screen)."' WHERE id = '".$q['id']."' ");
				if ($q['confirm_u'])
				{
					$disagree = true;
				}
			}
		}
		if ($final && $finished)
		{
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_tmnts
				SET status = '3' WHERE id = '".$tmnt['id']."'
			");
			if ($tmnt['win_credits'] > 0 && $vbulletin->options['tmnt_credit_system'])
			{//winner gets credits
require_once(DIR . '/includes/functions_tll_prem.php');
				if ($tmnt['pot'])
				{
					process_credits_transaction($winner_userid, $tmnt['win_credits'], 'Won tournament', 0, 0, $winner_userid, 1);
				}
				else
				{
					process_credits_transaction($winner_userid, $tmnt['win_credits'], 'Won tournament');
				}
				update_forum_creditprofit(vbdate('W',TIMENOW), vbdate('Y',TIMENOW), -$tmnt['win_credits'], TIMENOW);
			}
			if ($tmnt['ladderid'])
			{
				if ($tmnt['lwinxp'])
				{
					list($tmnt['xp_1st'], $tmnt['xp_2nd'], $tmnt['xp_3rd']) = explode(',', $tmnt['lwinxp']);
				}
				else
				{
					$tmnt['xp_1st'] = $tmnt['xp_2nd'] = $tmnt['xp_3rd'] = 0;
				}
				if ($tmnt['prize'] OR $tmnt['xp_1st'] OR $tmnt['xp_2nd'] OR $tmnt['xp_3rd'])
				{
					list($winners, $winners2nd, $winners3rd) = get_se_ftt(null, 0, 1, $tid);
					$userids2nd = implode("' OR userid = '", $winners2nd);
					$userids3rd = implode("' OR userid = '", $winners3rd);
					$vbulletin->db->query_write("
						UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
						SET rank = rank + " . $tmnt['prize'] . "
						" . ($tmnt['xp_1st'] ? ", xp = xp + " . $tmnt['xp_1st'] : "") . "
						WHERE (userid = '$winner_userid')
							AND lid = '" . $tmnt['ladderid'] . "'
					");
					if ($tmnt['xp_2nd'] > 0 && $userids2nd)
					{
						$vbulletin->db->query_write("
							UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
							SET xp = xp + $tmnt[xp_2nd]
							WHERE (userid = '$userids2nd')
								AND lid = '" . $tmnt['ladderid'] . "'
						");
					}
					if ($tmnt['xp_3rd'] > 0 && $userids3rd)
					{
						$vbulletin->db->query_write("
							UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
							SET xp = xp + $tmnt[xp_3rd]
							WHERE (userid = '$userids3rd')
								AND lid = '" . $tmnt['ladderid'] . "'
						");
					}
				}
			}
			if (!$tmnt['pot'])
			{
				$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET tmnt_wins = tmnt_wins + 1 WHERE userid = '".$winner_userid."' ");
			}
			else
			{
				$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_teams SET wins = wins + 1 WHERE teamid = '".$winner_userid."' ");
			}
		}
	}
	else
	{
		$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "tmnt_result
			(tid, round, dateline, userid, opp_userid, score_u, score_u2, confirm_u, confirm_u2, screen_u)
			VALUES (
				'".$vbulletin->db->escape_string($tid)."', 
				'".$vbulletin->db->escape_string($round)."', 
				'".$vbulletin->db->escape_string($dateline)."',
				'".$vbulletin->db->escape_string($userid)."',
				'".$vbulletin->db->escape_string($op['userid'])."',
				'".$vbulletin->db->escape_string($score_u)."',
				'".$vbulletin->db->escape_string($score_u2)."',
				'1',
				".($admin ? "'1'" : "'0'").",
				'".$vbulletin->db->escape_string($screen)."'
			)
		");
	}
	if ($tmnt['password'])
	{
		$urll = '&password='.$tmnt['password'];
	}
	if ($disagree && $tmntp['canusetickets'])
	{
		$vbulletin->url = "tll_tickets.php?do=new&issue=Tournament&tmntid=".$tid."".($tmnt['pot'] ? "&teamid=".$userid : "");
	}
	else
	{
		$vbulletin->url = "tournaments.php?do=view&id=" . $tid.$urll;	
	}
	eval(print_standard_redirect('redirect_submitresult'));
}

// #############################################################################

if ($_REQUEST['do'] == 'editrules')
{
	if (!$tmntp['canedittmnt'])
	{
		print_no_permission();
	}
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	$tmnt = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_tmnts WHERE id='$id'");
	if (!$tmnt)
	{
		$errormessage = $vbphrase[error_invalid_ladder];
		eval(standard_error($errormessage));
	}
	$tmnt['description'] = explode('[rules]',$tmnt['description']);
	$tmnt['rules'] = $tmnt['description']['1'];
	$tmnt['description'] = $tmnt['description']['0'];
	require_once(DIR . '/includes/functions_editor.php');
	if ($vbulletin->options['simpleversion'] < 414)
	{
		$editorid = construct_edit_toolbar($tmnt['rules'], 0, 'nonforum', iif($vbulletin->options['privallowsmilies'], 1, 0));
	}
	else
	{
		$editorid = construct_edit_toolbar($tmnt['rules']);
	}
	$templater = vB_Template::create('tmnt_tmnt_editrules');
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt', $tmnt);
		$templater->register('editorid', $editorid);
		$templater->register('messagearea', $messagearea);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'tournaments.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['tmnts'],
		'tournaments.php?' . $vbulletin->session->vars['sessionurl_q'] . 'do=view&amp;id='.$id . '' => $title,
		'' => construct_phrase($vbphrase['tmnt_editrules'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('headinclude', $headinclude);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('tlhtml', $tlhtml);
		$templater->register('modname', $modname);
		$templater->register('header', $header);
		$templater->register('footer', $footer);
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'submitresult')
{
	if (!$tmntp['canjointmnt'])
	{
		print_no_permission();
	}
	$tid = $vbulletin->input->clean_gpc('g', 'tid', TYPE_UINT);
	$admin = $vbulletin->input->clean_gpc('g', 'admin', TYPE_BOOL);
	if (!$tid)
	{
		$errormessage = $vbphrase['error_invalid_tournament'];
        eval(standard_error($errormessage));
	}
	$userid = $vbulletin->userinfo['userid'];
	$tmnt = $vbulletin->db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_tmnts 
		WHERE id = '$tid' AND status = 2 AND type IN ('1v1','swiss')
	");
	if (!$tmnt)
	{
		$errormessage = $vbphrase['error_invalid_tournament'];
        eval(standard_error($errormessage));
	}
	if ($tmnt['pot'])
	{//select team
		$teamid = $userid = $vbulletin->input->clean_gpc('g', 'teamid', TYPE_UINT);
		if (!$userid)
		{
			$array = array();
			$team_query = $vbulletin->db->query_read("
				SELECT p.*, t.teamname, m.leader, t.teamid
				FROM " . TABLE_PREFIX . "tmnt_players AS p
				LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS t
					ON (p.userid = t.teamid)
				LEFT JOIN " . TABLE_PREFIX . "tmnt_members AS m
					ON (t.teamid = m.teamid AND m.userid = '$thisuserid')
				WHERE p.pot = 1
					AND m.leader = 1
					AND p.tid = '$tid'
					AND m.userid = '$thisuserid'
			");
			while($row = $vbulletin->db->fetch_array($team_query))
			{
				$array[] = $row;
			}
			$templater = vB_Template::create('tmnt_submitresult_chooseteam');
				$templater->register('tmntp', $tmntp);
				$templater->register('tmnt', $tmnt);
				$templater->register('array', $array);
			$tlhtml = $templater->render();
			$stop = true;
		}
		$team = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_teams WHERE teamid = '$teamid' ");
	}
	if (!$stop)
	{
		if ($admin && $tmntp['canedittmnt'] && $tmnt['type'] == 'swiss')
		{
			$userid = $vbulletin->input->clean_gpc('g', 'userid', TYPE_UINT);
		}
		$player = $vbulletin->db->query_first("
			SELECT *
			FROM " . TABLE_PREFIX . "tmnt_players
			WHERE tid = '$tid'
				AND userid = '$userid'
		");
		if (!$player)
		{
			print_no_permission();
		}
if ($tmnt['type']!='swiss')
{
		$players = $tmnt['noplayers'];
		if ($players <= 2)
		{
			$rounds = 1;
		}
		elseif ($players <= 4)
		{
			$rounds = 2;
		}
		elseif ($players <= 8)
		{
			$rounds = 3;
		}
		elseif ($players <= 16)
		{
			$rounds = 4;
		}
		elseif ($players <= 32)
		{
			$rounds = 5;
		}
		elseif ($players <= 64)
		{
			$rounds = 6;
		}
		elseif ($players <= 128)
		{
			$rounds = 7;
		}
		elseif ($players <= 256)
		{
			$rounds = 8;
		}
		elseif ($players <= 512)
		{
			$rounds = 9;
		}
		$rounds++;
		$i = $rounds;
		while ($i >= 1)
		{
			if ($i == 1)
			{
				$x = $player['slot'];
				if ($x > 0)
				{
					$count = $vbulletin->db->query_first("
						SELECT COUNT(*) AS countrows
						FROM " . TABLE_PREFIX . "tmnt_players
						WHERE slot < '$x'
							AND tid = '$tid'
					");
					
					$x = $count['countrows'] + 1;
					//print_r(" \$x = $x <br>");
					if ($x % 2)
					{
						$y = $x + 1;
						$pr = $y / 2;
					}
					else
					{
						$y = $x - 1;
						$pr = $x / 2;
					}
					
					$op = $vbulletin->db->query_first("
						SELECT *
						FROM " . TABLE_PREFIX . "tmnt_players
						WHERE tid = '$tid'
						ORDER BY slot ASC
						LIMIT ".($y-1).", 1
					");
					break;
				}
			} 
			else
			{
				$x = $player['round'.$i];
				if ($x > 0)
				{
					if ($x % 2)
					{
						$y = $x + 1;
						$pr = $y / 2;
					}
					else
					{
						$y = $x - 1;
						$pr = $x / 2;
					}
					$op = $vbulletin->db->query_first("
						SELECT *
						FROM " . TABLE_PREFIX . "tmnt_players
						WHERE tid = '$tid'
							AND round$i = '$y'
					");
					if (!$op)
					{
						$errormessage = "Please wait for your opponent to progress through to round $i.";
						if ($_REQUEST['ajax']==1)
						{
							$tlhtml = tll_popup_standard_error($errormessage);
							print_r($tlhtml);
							exit;
						}
						eval(standard_error($errormessage));
					}
					break;
				}
			}
			//print_r(" round $i = $x <br> ");
			$i--;
		}
		$j = $i + 1;
		$pp = $vbulletin->db->query_first("
			SELECT *
			FROM " . TABLE_PREFIX . "tmnt_players
			WHERE tid = '$tid'
				AND round$j = '$pr'
		");
		if ($pp)
		{
			$errormessage = "Error. You are already out of this tournament.";
			if ($_REQUEST['ajax']==1)
			{
				$tlhtml = tll_popup_standard_error($errormessage);
				print_r($tlhtml);
				exit;
			}
			eval(standard_error($errormessage));
		}
		if ($i + 1 == $rounds)
		{
			$final = true;
		}
		if ($op['userid']==0 && $op['username']=='Bye' && $j == 2)
		{
			//progress player to round 2 if first round is against a bye player
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_players SET round".$j." = '".$pr."' WHERE tid='".$tid."' AND userid='".$userid."' ");
			$vbulletin->url = "tournaments.php?do=view&id=" . $tid;	
			if ($_REQUEST['ajax']==1)
			{
				print_r("Reload");
				exit;
			}
			eval(print_standard_redirect('redirect_submitresult'));
		}
}
else
{
		$i = 1;
		$q = $vbulletin->db->query_first("
			SELECT *
			FROM " . TABLE_PREFIX . "tmnt_result
			WHERE tid = '$tid'
				AND (userid = '$userid' OR opp_userid = '$userid') 
				AND (confirm_u = 0 OR confirm_u2 = 0)
			ORDER BY round ASC
		");	
		if ($q)
		{
			$i = $q['round'];
		}
		if ($i == 1)
		{
			$x = $player['slot'];
			if ($x > 0)
			{
				$count = $vbulletin->db->query_first("
					SELECT COUNT(*) AS countrows
					FROM " . TABLE_PREFIX . "tmnt_players
					WHERE slot < '$x'
						AND tid = '$tid'
				");
				
				$x = $count['countrows'] + 1;
				//print_r(" \$x = $x <br>");
				if ($x % 2)
				{
					$y = $x + 1;
					$pr = $y / 2;
				}
				else
				{
					$y = $x - 1;
					$pr = $x / 2;
				}
				
				$op = $vbulletin->db->query_first("
					SELECT *
					FROM " . TABLE_PREFIX . "tmnt_players
					WHERE tid = '$tid'
					ORDER BY slot ASC
					LIMIT ".($y-1).", 1
				");
			}
		} 
}
		$q = $vbulletin->db->query_first("
			SELECT *
			FROM " . TABLE_PREFIX . "tmnt_result
			WHERE tid = '$tid'
				AND round = '$i'
				AND (userid = '$userid' OR opp_userid = '$userid')
		");
		if (!$q)
		{
			$q['userid'] = $userid;
			$q['opp_userid'] = $op['userid'];
		}
		//print_r($q);
		//print_r($op);
		$score_u = $q['score_u'];
		$score_u2 = $q['score_u2'];
		if ($q['userid']==$userid)
		{
			$screen = $q['screen_u'];
		}
		elseif ($q['opp_userid']==$userid)
		{
			$screen = $q['screen_u2'];
		}
		if ($q && $q['confirm_u'] && $q['confirm_u2'])
		{
			$errormessage = "Scores already confirmed for round $i.";
			if ($_REQUEST['ajax']==1)
			{
				$tlhtml = tll_popup_standard_error($errormessage);
				print_r($tlhtml);
				exit;
			}
			eval(standard_error($errormessage));
		}
		/*if (!$op)
		{
			$op = $vbulletin->db->query_first("
				SELECT *
				FROM " . TABLE_PREFIX . "tmnt_players
				WHERE tid = '$tid'
					AND userid = '".($q['userid'] == $userid ? $q['opp_userid'] : $q['userid'])."'
			");
		}*/
		
			if ($userid == $q['userid'] && !$admin && !$team)
			{
				$u = $vbulletin->userinfo;
				$u2 = fetch_userinfo($q['opp_userid']);
			}
			elseif ($userid == $q['opp_userid'] && !$admin && !$team)
			{
				$u2 = $vbulletin->userinfo;
				$u = fetch_userinfo($q['userid']);
			}
		
		if (!$u)
		{
			if (!$team)
			{
				$u = fetch_userinfo($q['userid']);
			}
			else
			{
				$u = fetch_teaminfo($q['userid']);
			}
		}
		if (!$u2)
		{
			if (!$team)
			{
				$u2 = fetch_userinfo($q['opp_userid']);
			}
			else
			{
				$u2 = fetch_teaminfo($q['opp_userid']);
			}
		}
		//print_r($u2);
	//	print_r("Go");
		$templater = vB_Template::create('tmnt_submitresult');
			$templater->register('tmntp', $tmntp);
			$templater->register('tmnt', $tmnt);
			$templater->register('op', $op);
			$templater->register('i', $i);
			$templater->register('j', $j);
			$templater->register('q', $q);
			$templater->register('team', $team);
			$templater->register('final', $final);
			$templater->register('screen', $screen);
			$templater->register('score_u', $score_u);
			$templater->register('u', $u);
			$templater->register('score_u2', $score_u2);
			$templater->register('u2', $u2);
			$templater->register('userid', $userid);
			$templater->register('admin', $admin);
		$tlhtml = $templater->render();
	}
	if ($_REQUEST['ajax']==1)
	{
		$tlhtml = str_replace("href=\"tournaments.php?do=view&amp;id=$tid\"",'href="javascript://" onclick="close_tll_popup();"', $tlhtml);
		print_r($tlhtml);
		exit;
	}
	$navbits = array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'tournaments.php' . $vbulletin->session->vars['sessionurl_q'] . '?do=view' . "&amp;id=$tid" => $tmnt['title'],
		'' => construct_phrase($vbphrase['tmnt_submitresult'])
	);
	$navbar = render_navbar_template(construct_navbits($navbits));
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'join')
{
	if (!$tmntp['canjointmnt']) {
		print_no_permission();
	}
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	if (!$id) {
		$errormessage = $vbphrase['error_invalid_tournament'];
        eval(standard_error($errormessage));
	}
	$tmnt = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_tmnts WHERE id=$id ");
	switch ($tmnt['pot'])
	{
		case 0:
			$team = false;
			break;
		case 1:
			$team = true;
			break;
	}
	$tmnt['url'] = tll_seo('tmnt', $tmnt['id'], $tmnt['title']);
	if ($tmnt['password'] && $vbulletin->options['tmnt_premium'])
	{
		require_once(DIR . '/includes/functions_tll_prem.php');	
		check_tmnt_password('join');
		$tmnt['turl'] = '&amp;password='.$tmnt['password'];
	}
	if ($tmnt['archive'])
	{
		$errormessage = 'Sorry, tournament is closed.';
        eval(standard_error($errormessage));
	}
	$tmax = $tmnt['tmax'];
	$tmin = $tmnt['tmin'];
	$userid = $thisuserid;
	if ($tmnt['status'] < 3 && $tmnt['allowreserves'] && $tmnt['freeslots'] == 0)
	{
		$tmnt['status'] = 1;
		$tmnt['freeslots'] = 1;
		$tmnt['reserve'] = 1;
		$countplayers = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_reserves WHERE tmntid = '$id' AND userid = '$userid' ");
		if ($countplayers['countrows'] > 0)
		{
			$errormessage = construct_phrase($vbphrase['error_already_tournament_reserve'], $id);
			eval(standard_error($errormessage));
		}
	}
	if ($tmnt['freeslots']==0)
	{
		$errormessage = 'Sorry, you cannot join this tournament, it is already full';
        eval(standard_error($errormessage));
	}
	if ($tmnt['status']>1)
	{
		$errormessage = 'Sorry, you cannot join this tournament, it has already started or is already full.';
        eval(standard_error($errormessage));
	}
	if ($tmnt['ladderid'] && !$team)
	{
		// tournament linked to ladder check player is in ladder.
		$players = $vbulletin->db->query_first("
			SELECT COUNT(*) AS countrows
			FROM " . TABLE_PREFIX . "tmnt_ladder_players
			WHERE lid = '" . $tmnt['ladderid'] . "' AND userid = '$userid'
				AND active = '1'
		");
		if ($players['countrows'] != 1)
		{
			$errormessage = construct_phrase($vbphrase['error_must_be_in_ladder'], $id, $tmnt['ladderid']);
			eval(standard_error($errormessage));
		}
		//check team is in ladder later
	}
	if (!$team)
	{
		$username = $thisusername;
		$players = $vbulletin->db->query_first("
			SELECT COUNT(*) AS countrows
			FROM " . TABLE_PREFIX . "tmnt_players
			WHERE tid='$id'
				AND (userid='$userid' OR username='".$vbulletin->db->escape_string($username)."')
		");
		if ($players['countrows'] != 0)
		{
			$errormessage = construct_phrase($vbphrase['error_already_joined_tournament'], $id);
			eval(standard_error($errormessage));
		}
	}
	else
	{
		$ua = array(-1);
		$ts = $vbulletin->db->query_read("
			SELECT userid
			FROM " . TABLE_PREFIX . "tmnt_players
			WHERE tid = '$id'
		");
		while($tm = $vbulletin->db->fetch_array($ts))
		{
			$ua[] = $tm['userid'];
		}
		$userteams .= '<select name="teamid" id="teamid">';
		$teams = $vbulletin->db->query_read("
			SELECT teams.*
			FROM " . TABLE_PREFIX . "tmnt_members AS members
			LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS teams
				ON members.teamid = teams.teamid
			WHERE members.leader = 1
				AND members.userid = '$userid'
				AND teams.noplayers <= '$tmax' 
				AND teams.noplayers >= '$tmin'
				AND teams.teamid NOT IN (".implode(',',$ua).")
		");
		while($teamm = $vbulletin->db->fetch_array($teams))
		{
			$userteams .= "<option value=\"".$teamm['teamid']."\">".$teamm['teamname']."</option>";
			$countuserteams++ ;
		}
		$userteams .= '</select>';
		if ($countuserteams == 0)
		{
			$errormessage = $vbphrase['error_not_leader_team_tournament'];
			eval(standard_error($errormessage));
		} 
	}
	$templater = vB_Template::create('tmnt_join');
		$templater->register('userteams', $userteams);
		$templater->register('username', $username);
		$templater->register('userid', $userid);
		$templater->register('id', $id);
		$templater->register('tmnt', $tmnt);
		$templater->register('teamid', $teamid);
		$templater->register('team', $team);
		$templater->register('pot', $pot);
		$templater->register('tmax', $tmax);
		$templater->register('tmin', $tmin);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'tournaments.php?do=view&amp;id='.$id. $vbulletin->session->vars['sessionurl_q'] => $tmnt['title'],
		'' => construct_phrase($vbphrase['tmnt_join'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('headinclude', $headinclude);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('tlhtml', $tlhtml);
		$templater->register('modname', $modname);
		$templater->register('header', $header);
		$templater->register('footer', $footer);
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'progress')
{
	$tid = $id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
		if (!$id) {
			$errormessage = $vbphrase[error_invalid_tournament];
			eval(standard_error($errormessage));
		}
	$userid = $vbulletin->input->clean_gpc('g', 'userid', TYPE_UINT);
		if (!$userid) {
			$errormessage = $vbphrase[error_no_userid];
			eval(standard_error($errormessage));
		}
	$round = $vbulletin->input->clean_gpc('g', 'round', TYPE_NOHTML);
		if (!$round) {
			$errormessage = $vbphrase[error_invalid_round];
			eval(standard_error($errormessage));
		}
	$tmnt = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_tmnts WHERE id = '$id' ");
	if ($tmnt['type']=='swiss')
	{
		$round = substr($round, 0, -1)."1".substr($round, -1);
	}
	$cmpt = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_players WHERE tid='".$id."' AND userid='".$userid."' ");
	if ($tmnt['userid'] != $thisuserid) {
	if (!$tmntp['canedittmnt']) {
		print_no_permission();
	} }
	$rounds = array("round2", "round3",  "round4", "round5", "round6", "round7", "round8", "round9", "round10", "round11", "round12", "round13", "round14", "round15");
		if (!in_array($round, $rounds)) {
			$errormessage = $vbphrase[error_invalid_round];
			eval(standard_error($errormessage));
		}
	$slot = $vbulletin->input->clean_gpc('g', 'slot', TYPE_UINT);
	$check1 = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_players WHERE tid='".$id."' AND ".$round." = '".$slot."' ");
	if ($check1 && $slot)
	{
		$errormessage = 'Already a player in this slot';
		eval(standard_error($errormessage));
	}
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_players SET ".$round." = '".$slot."' WHERE tid='".$id."' AND userid='".$userid."' ");
	// process loser for double elimination
	if ($tmnt['type'] == 'de' && $slot > 0)
	{
		$slot2 = $vbulletin->input->clean_gpc('g', 'slot2', TYPE_UINT);
		$userid2 = $vbulletin->input->clean_gpc('g', 'userid2', TYPE_UINT);
		$round2 = $vbulletin->input->clean_gpc('g', 'round2', TYPE_STR);
		if (in_array($round2, array(1,2,3,4,5,6,7,8,9)))
		{
			$round2 = 'round'.$round2;
		}
		if (!in_array($round2, $rounds) && $round2 != 'round1')
		{
			$round2 = $round;
		}
		if (in_array($tmnt['noplayers'], array(4,8)))
		{
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_players SET ".$round2." = '".$slot2."' WHERE tid='".$id."' AND userid='".$userid2."' ");
		}
		elseif ($tmnt['noplayers'] == 16)
		{
			$player = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_players WHERE tid = '$tid' AND userid = '".$userid2."' ");
			if ($player['loser_rounds'])
			{
				$player['loser_rounds'] = unserialize($player['loser_rounds']);
			}
			else
			{
				$player['loser_rounds'] = array();
			}
			$player['loser_rounds']["loser$round2"] = $slot2;
			$player['loser_rounds'] = serialize($player['loser_rounds']);
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_players SET loser_rounds = '".$vbulletin->db->escape_string($player['loser_rounds'])."' WHERE tid='".$id."' AND userid='".$userid2."' ");
		}
	}
	if ($tmnt['type'] == 'de' && $slot == 0 && $tmnt['noplayers'] == 4)
	{
		$slot2 = 0;
		
		if ($round == 'round2')
		{
			switch ($cmpt["$round"])
			{
				case 5:
					$slot2 = 1;
					break;
				case 6:
					$slot2 = 2;
					break;
				case 2:
					$slot2 = 6;
					break;
				case 1:
					$slot2 = 5;
					break;
			}
		}
		elseif ($round == 'round3')
		{
			switch ($cmpt["$round"])
			{
				case 3:
					$slot2 = 1;
					break;
				case 1:
					$slot2 = 3;
					break;
			}
		}
		elseif ($round == 'round5')
		{
			switch ($cmpt["$round"])
			{
				case 2:
					$slot2 = 1;
					break;
				case 1:
					$slot2 = 2;
					break;
			}
		}
		if ($slot2)
		{
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_players SET ".$round." = '".$slot."' WHERE tid='".$id."' AND ".$round." = '".$slot2."' ");
		}
	}
	
	if ($tmnt['type'] == 'de' && $slot == 0 && $tmnt['noplayers'] == 8)
	{
		$slot2 = 0;
		$round2 = $round;
		if ($round == 'round2')
		{
			switch ($cmpt["$round"])
			{
				case 9:
					$slot2 = 1;
					break;
				case 10:
					$slot2 = 2;
					break;
				case 11:
					$slot2 = 3;
					break;
				case 12:
					$slot2 = 4;
					break;
				case 4:
					$slot2 = 12;
					break;
				case 3:
					$slot2 = 11;
					break;
				case 2:
					$slot2 = 10;
					break;
				case 1:
					$slot2 = 9;
					break;
			}
		}
		elseif ($round == 'round3')
		{
			switch ($cmpt["$round"])
			{
				case 5:
					$slot2 = 1;
					break;
				case 1:
					$slot2 = 5;
					break;
				case 2:
					$slot2 = 7;
					break;
				case 7:
					$slot2 = 2;
					break;
			}
		}
		elseif ($round == 'round4')
		{
			switch ($cmpt["$round"])
			{
				case 1:
					$slot2 = 2;
					$round2 = 'round5';
					break;
			}
		}
		elseif ($round == 'round5')
		{
			switch ($cmpt["$round"])
			{
				case 2:
					$slot2 = 1;
					$round2 = 'round4';
					break;
			}
		}
		elseif ($round == 'round7')
		{
			switch ($cmpt["$round"])
			{
				case 1:
					$slot2 = 2;
					break;
				case 2:
					$slot2 = 1;
					break;
			}
		}
		if ($slot2)
		{
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_players SET ".$round2." = '".$slot."' WHERE tid='".$id."' AND ".$round2." = '".$slot2."' ");
		}
	}
	if ($tmnt['password'])
	{
		$urll = '&password='.$tmnt['password'];
	}
	$vbulletin->url = "tournaments.php?do=view&id=".$id.$urll."#".$round."_slot".($slot&1 ? $slot : ($slot-1));	
	eval(print_standard_redirect('redirect_progressedplayer'));
}

// #############################################################################

if ($_REQUEST['do'] == 'loserprogress')
{
	$tid = $id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
		if (!$id) {
			$errormessage = $vbphrase[error_invalid_tournament];
			eval(standard_error($errormessage));
		}
	$tmnt = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_tmnts WHERE id = '$id' ");
	if ($tmnt['userid'] != $thisuserid) {
	if (!$tmntp['canedittmnt']) {
		print_no_permission();
	} }
	$userid = $vbulletin->input->clean_gpc('g', 'userid', TYPE_UINT);
		if (!$userid) {
			$errormessage = $vbphrase[error_no_userid];
			eval(standard_error($errormessage));
		}
	$round = $vbulletin->input->clean_gpc('g', 'round', TYPE_STR);
		if (!$round) {
			$errormessage = $vbphrase[error_invalid_round];
			eval(standard_error($errormessage));
		}
	$rounds = array("loserround1", "loserround2", "loserround3",  "loserround4", "loserround5", "loserround6", "loserround7", "loserround8", "loserround9", "loserround10", "loserround11", "loserround12");
		if (!in_array($round, $rounds)) {
			$errormessage = $vbphrase[error_invalid_round];
			eval(standard_error($errormessage));
		}
	$slot = $vbulletin->input->clean_gpc('g', 'slot', TYPE_UINT);
	//$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_players SET ".$round." = '".$slot."' WHERE tid='".$id."' AND userid='".$userid."' ");
		$player = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_players WHERE tid = '$tid' AND userid = '".$userid."' ");
			if ($player['loser_rounds'])
			{
				$player['loser_rounds'] = unserialize($player['loser_rounds']);
			}
			else
			{
				$player['loser_rounds'] = array();
			}
			$player['loser_rounds']["$round"] = $slot;
			$player['loser_rounds'] = serialize($player['loser_rounds']);
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_players SET loser_rounds = '".$vbulletin->db->escape_string($player['loser_rounds'])."' WHERE tid='".$id."' AND userid='".$userid."' ");
	if ($round == 'loserround7' && $slot == 1)
	{
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_players SET round5 = '2' WHERE tid='".$id."' AND userid='".$userid."' ");
	}
	if ($tmnt['password'])
	{
		$urll = '&password='.$tmnt['password'];
	}
	$vbulletin->url = "tournaments.php?do=view&id=".$id.$urll."#".$round."_slot".($slot&1 ? $slot : ($slot-1));	
	eval(print_standard_redirect('redirect_progressedplayer'));
}

// #############################################################################

if ($_REQUEST['do'] == 'progressfinish')
{
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
		if (!$id)
		{
			$errormessage = $vbphrase['error_invalid_tournament'];
			eval(standard_error($errormessage));
		}
	$tmnt = $tmnts = $vbulletin->db->query_first("
		SELECT * 
		FROM " . TABLE_PREFIX . "tmnt_tmnts 
		WHERE id = '$id'
	");
	if ($tmnt['userid'] != $thisuserid) {
	if (!$tmntp['canedittmnt']) {
		print_no_permission();
	} }
	if (!$tmnt)
	{
		print_no_permission();
	}
	$team = false;
	if ($tmnts['pot'])
	{
		$team = true;
	}
	$userid = $vbulletin->input->clean_gpc('g', 'userid', TYPE_UINT);
		if (!$userid) 
		{
			$errormessage = $vbphrase[error_invalid_userid];
			eval(standard_error($errormessage));
		}
	$round = $vbulletin->input->clean_gpc('g', 'round', TYPE_STR);
		if (!$round) 
		{
			$errormessage = $vbphrase[error_invalid_round];
			eval(standard_error($errormessage));
		}
	if ($tmnt['type']=='swiss')
	{
		$round = substr($round, 0, -1)."1".substr($round, -1);
	}
	$rounds = array("round2", "round3",  "round4", "round5", "round6", "round7", "round8", "round9", "round10", "round11", "round12", "round13", "round14", "round15");
		if (!in_array($round, $rounds))
		{
			$errormessage = $vbphrase[error_invalid_round];
			eval(standard_error($errormessage));
		}
	$slot = $vbulletin->input->clean_gpc('g', 'slot', TYPE_UINT);
		if (!$slot)
		{
			$errormessage = $vbphrase[error_invalid_slot];
			eval(standard_error($errormessage));
		}
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "tmnt_players
		SET $round = '$slot', winner = '1' WHERE tid = '$id' AND userid = '$userid' 
	");
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "tmnt_tmnts
		SET status = '3' WHERE id = '$id'
	");
	
	if ($tmnt['win_credits'] > 0 && $vbulletin->options['tmnt_credit_system'])
	{//winner gets credits
require_once(DIR . '/includes/functions_tll_prem.php');
		if ($tmnt['pot'])
		{
			process_credits_transaction($userid, $tmnt['win_credits'], 'Won tournament', 0, 0, $userid, 1);
		}
		else
		{
			process_credits_transaction($userid, $tmnt['win_credits'], 'Won tournament');
		}
		update_forum_creditprofit(vbdate('W',TIMENOW), vbdate('Y',TIMENOW), -$tmnt['win_credits'], TIMENOW);
	}
	if ($tmnt['ladderid'])
	{
		if ($tmnt['lwinxp'])
		{
			list($tmnt['xp_1st'], $tmnt['xp_2nd'], $tmnt['xp_3rd']) = explode(',', $tmnt['lwinxp']);
		}
		else
		{
			$tmnt['xp_1st'] = $tmnt['xp_2nd'] = $tmnt['xp_3rd'] = 0;
		}
		if ($tmnt['prize'] OR $tmnt['xp_1st'] OR $tmnt['xp_2nd'] OR $tmnt['xp_3rd'])
		{
			list($winners, $winners2nd, $winners3rd) = get_se_ftt(null, 0, 1, $id);
			$userids2nd = implode("' OR userid = '", $winners2nd);
			$userids3rd = implode("' OR userid = '", $winners3rd);
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
				SET rank = rank + " . $tmnt['prize'] . "
				" . ($tmnt['xp_1st'] ? ", xp = xp + " . $tmnt['xp_1st'] : "") . "
				WHERE (userid = '$userid')
					AND lid = '" . $tmnt['ladderid'] . "'
			");
			if ($tmnt['xp_2nd'] > 0 && $userids2nd)
			{
				$vbulletin->db->query_write("
					UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
					SET xp = xp + $tmnt[xp_2nd]
					WHERE (userid = '$userids2nd')
						AND lid = '" . $tmnt['ladderid'] . "'
				");
			}
			if ($tmnt['xp_3rd'] > 0 && $userids3rd)
			{
				$vbulletin->db->query_write("
					UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
					SET xp = xp + $tmnt[xp_3rd]
					WHERE (userid = '$userids3rd')
						AND lid = '" . $tmnt['ladderid'] . "'
				");
			}
		}
	}
	if (!$team)
	{
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET tmnt_wins = tmnt_wins + 1 WHERE userid=$userid");
	}
	else
	{
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_teams SET wins = wins + 1 WHERE teamid=$userid");
	}
	$vbulletin->url = "tournaments.php?do=view&id=" . $id;	
	eval(print_standard_redirect('redirect_progressedplayer'));
}

// #############################################################################

if ($_REQUEST['do'] == 'admin')
{
	$id = $tid = $vbulletin->input->clean_gpc('g', 'tid', TYPE_UINT);
	$tmnt = fetch_tmntinfo($tid);
	if ($tmnt['userid'] == $vbulletin->userinfo['userid'])
	{
		$tmntp['canedittmnt'] = true;
	}	
	if (!$tmntp['canedittmnt'])
	{
		print_no_permission();
	}
	if (file_exists(DIR . '/includes/functions_tll_tabs.php'))
	{
		$sh = $vbulletin->input->clean_gpc('g', 'sh', TYPE_UINT);
		require_once(DIR . '/includes/functions_tll_tabs.php');
		//$template_hook = tll_tabs($template_hook, $tid, 0, 0);
		$show['addtab'] = true;
	}
	$tmnt = switch_tmnt_status($tmnt);
	$tmnt = switch_tmnt_type($tmnt);
	$templater = vB_Template::create('tmnt_admin');
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt', $tmnt);
		$templater->register('e', $e);
	$tlhtml .= $templater->render();
	if ($_REQUEST['ajax'])
	{
		print_r($tlhtml);
		exit;
	}
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'tournaments.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['tmnts'],
		$tmnt['url'] => $tmnt['title'],
		'' => 'Admin Options'
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('headinclude', $headinclude);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('tlhtml', $tlhtml);
		$templater->register('modname', $modname);
		$templater->register('header', $header);
		$templater->register('footer', $footer);
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'reset_hof')
{
	if (!$tmntp['canedittmnt'])
	{
		print_no_permission();
	}
	if ($_REQUEST['confirm'] != 1)
	{
		$errormessage = "Are you sure you want to delete the stats for all players?<br /><br />This cannot be undone!<br><br><a href=\"tournaments.php?do=reset_hof&amp;confirm=1\" class=\"button\">Yes</a> <a href=\"competitions.php\" class=\"button\">No</a>";
		eval(standard_error($errormessage));
	}
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET tmnt_wins = 0, tmnt_joins = 0 ");
	$errormessage = 'You have reset the Hall of Fame';
	eval(standard_error($errormessage));
}

// #############################################################################

if ($_REQUEST['do'] == 'hof')
{
	if (!$tmntp['canviewtmnt'])
	{
		print_no_permission();
	}
	$rowcount = 1;
	$rowno = 0;
	$array = array();
	if ($_REQUEST['teams'])
	{
		$sql_select = '*, joins AS tmnt_joins, wins AS tmnt_wins';
		$sql_table = 'tmnt_teams';
		$sql_where = 'wins != 0 OR joins != 0';
		$sql_order = 'wins DESC, joins ASC';
		$team = true;
	}
	else
	{
		$sql_select = '*';
		$sql_table = 'user';
		$sql_where = 'tmnt_wins != 0 OR tmnt_joins != 0';
		$sql_order = 'tmnt_wins DESC, tmnt_joins ASC';
	}
	$hofs = $vbulletin->db->query_read("
		SELECT $sql_select
		FROM " . TABLE_PREFIX . "$sql_table
		WHERE $sql_where
		ORDER BY $sql_order
		LIMIT 0, 10
	");
	while($hof = $vbulletin->db->fetch_array($hofs))
	{
	  	$rowcount ++;
		$score = $hof['tmnt_wins'];
		if ($rowno == 0)
		{
			$topscore = $score;
			$lastscore_score = $topscore;
			$lastscore_row = 1;
		}
		$rowno ++;
		if ($score == $lastscore_score AND $rowno != 1)
		{
			$hof['rowno'] = $lastscore_row ."=";
		}
		else
		{
			$lastscore_row = $rowno;
			$lastscore_score = $score;
			$hof['rowno'] = $rowno;
		}
		$array[] = $hof;
	}
	$templater = vB_Template::create('tmnt_hof');
		$templater->register('array', $array);
		$templater->register('team', $team);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'tournaments.php?' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase[tmnts],
		'' => construct_phrase($vbphrase['tmnt_hof'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################


if ($_REQUEST['do'] == 'comment')
{
	$tid = $vbulletin->input->clean_gpc('g', 'tid', TYPE_UINT);
	$vbulletin->input->clean_array_gpc('g', array(
		'round' => TYPE_UINT,
		'u1' => TYPE_UINT,
		'u2' => TYPE_UINT,
	));
	$tmnt = fetch_tmntinfo($tid);
	if (!$tmntp['cancomment'] OR $tmnt['archive'] == 1)
	{
		print_no_permission();
	}
	if ($vbulletin->options['tmnt_premium'])
	{
		$info = $vbulletin->GPC;
	}
	if (!$tmnt['pot'])
	{
		$info['u1info'] = fetch_userinfo($info['u1']);
		$info['u2info'] = fetch_userinfo($info['u2']);
	}
	else
	{
		$info['u1info'] = fetch_teaminfo($info['u1']);
		$info['u1info']['username']=$info['u1info']['teamname'];
		$info['u2info'] = fetch_teaminfo($info['u2']);
		$info['u2info']['username']=$info['u2info']['teamname'];
	}
	require_once(DIR . '/includes/functions_editor.php');
	$show['wysiwyg'] = is_wysiwyg_compatible();
	if ($vbulletin->options['simpleversion'] < 414)
	{
		$editorid = construct_edit_toolbar('', 0, 'nonforum', ($foruminfo['allowsmilies'] ? 1 : 0), 1, false, 'qr', '', array());
	}
	else
	{
		$editorid = construct_edit_toolbar('', 0, 0, 1, 1,0,'qr');
	}
	$templater = vB_Template::create('tmnt_addcomment');
		$templater->register('tmnt', $tmnt);
		$templater->register('show', $show);
		$templater->register('tid', $tid);
		$templater->register('info', $info);
		$templater->register('editorid', $editorid);
		$templater->register('messagearea', $messagearea);
	$addcomment .= $templater->render();
	if ($info)
	{
		require_once(DIR . '/includes/class_bbcode.php');
		$bbcode_parser = new vB_BbCodeParser($vbulletin, fetch_tag_list(), true); 
		$comments = $vbulletin->db->query_read("
			SELECT c.*, user.avatarrevision AS avatarrevision, avatar.avatarpath AS avatarpath, NOT ISNULL(customavatar.userid) AS hascustom, customavatar.dateline AS avatardateline, customavatar.width AS avwidth, customavatar.height AS avheight " . ($thumb ? ", customavatar.width_thumb AS width_thumb, customavatar.height_thumb AS height_thumb" : "") . "
			FROM " . TABLE_PREFIX . "tmnt_comments AS c
			LEFT JOIN " . TABLE_PREFIX . "user AS user
				ON (c.userid = user.userid)
			LEFT JOIN " . TABLE_PREFIX . "avatar AS avatar
				ON (avatar.avatarid = user.avatarid)
			LEFT JOIN " . TABLE_PREFIX . "customavatar AS customavatar
				ON (customavatar.userid = user.userid)
			WHERE c.tid = '$tid' 
				AND c.round = '".$info['round']."'
				AND c.players IN('".$info['u1']."_".$info['u2']."', '".$info['u2']."_".$info['u1']."')
			ORDER BY c.id DESC
			LIMIT 0, 5
		");
		while($comment = $vbulletin->db->fetch_array($comments))
		{
			if (!empty($comment['avatarpath']))
			{
				$comment['avatarurl'] = $comment['avatarpath'];
				$comment['avwidth'] = getimagesize($comment['avatarurl']);
				$comment['avheight'] = $comment['avwidth']['1'];
				$comment['avwidth'] = $comment['avwidth']['0'];
				if ($comment['avwidth'] > 60)
				{
					$comment['avratio'] = $comment['avwidth']/60;
					$comment['avatarwidth'] = $comment['avwidth']/$comment['avratio'];
					$comment['avatarheight'] = $comment['avheight']/$comment['avratio'];
				}
			} else if ($comment['hascustom']) {
				$avatarurl = array('hascustom' => 1);
				if ($vbulletin->options['usefileavatar']) {
					$comment['avatarurl'] = $vbulletin->options['avatarurl'] . ($thumb ? '/thumbs' : '') . "/avatar{$comment['userid']}_{$comment['avatarrevision']}.gif";
				} else {
					$comment['avatarurl'] = "image.php?u=$comment[userid]&amp;dateline=$comment[avatardateline]" . ($thumb ? '&amp;type=thumb' : '') ;
				}
			}
			/*if ($comment['round'] && $comment['players'])
			{
				list($comment['u1'], $comment['u2']) = explode('_',$comment['players']);
				if (!$tmnt['pot'])
				{
					$comment['u1info'] = fetch_userinfo($comment['u1']);
					$comment['u2info'] = fetch_userinfo($comment['u2']);
				}
				else
				{
					$comment['u1info'] = fetch_teaminfo($comment['u1']);
					$comment['u1info']['username'] = $comment['u1info']['teamname'];
					$comment['u2info'] = fetch_teaminfo($comment['u2']);
					$comment['u2info']['username'] = $comment['u2info']['teamname'];
				}
			}*/
			if ($thumb)
			{
				if ($comment['width_thumb'] AND $comment['height_thumb']) {
					$avatarwidth = $comment['width_thumb'];
					$avatarheight = $comment['height_thumb'];
				}
			}
			else
			{
				$avatarwidth = $comment['avwidth'];
				$avatarheight = $comment['avheight'];
			}
			if (empty($comment['avatarurl'])) {
				$comment['avatarurl'] = vB_Template_Runtime::fetchStyleVar('imgdir_misc') . '/unknown.gif';
			}
			$id = $comment['id'];
			$comment_userid = $comment['userid'];
			/*if (in_array($comment_userid, $array)) {
				$comper = true;
			} else {
				$comper = false;
			}
			if (in_array($comment_userid, $winnerlist)) {
				$winner = true;
			} else {
				$winner = false;
			}*/
			$comment['date'] = vbdate($vbulletin->options['dateformat'],$comment['time'], 1);
			$comment['time'] = vbdate($vbulletin->options['timeformat'],$comment['time']);
			//$show['detailedtime'] = true;
			$comment['ed_time'] = vbdate($vbulletin->options['timeformat'],$comment['ed_time']).$vbphrase['ladder_on'].vbdate($vbulletin->options['dateformat'],$comment['ed_time'], 1);
			//print_r($comment);
			$comment['comment'] = $bbcode_parser->do_parse($comment['comment'],false,true,true,true,true,false);
			if ($tmntp['candelcomment'] OR ($tmntp['candelowncomment'] AND ($comment_userid == $thisuserid))) {
				$comment_delete = true;
			} else {
				$comment_delete = false;
			}
			$templater = vB_Template::create('tmnt_comment');
				$templater->register('tmnt', $tmnt);
				$templater->register('tmntp', $tmntp);
				$templater->register('comment_delete', $comment_delete);
				$templater->register('comment_userid', $comment_userid);
				$templater->register('comment', $comment);
				$templater->register('comper', $comper);
				$templater->register('winner', $winner);
				$templater->register('team', $team);
				$templater->register('comper', $comper);
				$templater->register('id', $id);
				$templater->register('tid', $tid);
				$templater->register('show', $show);
			$prev_comments .= $templater->render();
		}
	}
	$x = "<div class=\"blockbody formcontrols\"><div class=\"blocksubhead\">Previous Comments for this match</div><div class=\"blockrow\"><ol id=\"message_list\" style=\"padding-top: 10px; padding-right: 10px; padding-left: 10px;\">";
	$tlhtml = $addcomment.($prev_comments ? "$x $prev_comments </ol></div></div>":"");
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'tournaments.php?' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase[tmnts],
		$tmnt['url'] => $tmnt['title'],
		'' => $vbphrase['comment']
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'subresults')
{
	$id = $tid = $vbulletin->input->clean_gpc('g', 'tid', TYPE_UINT); 
	$r_array = array();
	$tmnt = $vbulletin->db->query_first("
		SELECT tmnts.*, ladders.title AS laddertitle
		FROM ". TABLE_PREFIX ."tmnt_tmnts AS tmnts
		LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders
			ON (tmnts.ladderid = ladders.id)
		WHERE tmnts.id = '$id'
	");
	if (!$tmnt)
	{
		$errormessage = $vbphrase['error_invalid_tournament'];
        eval(standard_error($errormessage));
	}
	$tmnt['url'] = tll_seo('tmnt', $tmnt['id'], $tmnt['title']);
	$team = false;
	if ($tmnt['pot'])
	{
		$team = true;
	}
		$cmpt_count = 1;
		$winnerlist = $array = $p_array = array();
		$cmpts = $vbulletin->db->query_read("
			SELECT
				" . (!$team ? "user.*," : "") . " players.*, players.username AS sname,
				" . (!$team ? "user.username AS username, user.userid, user.avatarrevision AS avatarrevision, avatar.avatarpath AS avatarpath, NOT ISNULL(customavatar.userid) AS hascustom, customavatar.dateline AS avatardateline, customavatar.width AS avwidth, customavatar.height AS avheight, user.username AS username" : "user.teamname AS username, user.teamid, user.teamlogo AS avatarurl") . "
				" . (($vbulletin->options['tmnt_joinuf'] && !$team) ? ", userfield.*, usertextfield.* " : "") . "
			FROM " . TABLE_PREFIX . "tmnt_players AS players 
			" . ($team ? "LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS user ON (players.userid = user.teamid)" : "LEFT JOIN " . TABLE_PREFIX . "user AS user ON (players.userid = user.userid) LEFT JOIN " . TABLE_PREFIX . "avatar AS avatar ON(avatar.avatarid = user.avatarid) LEFT JOIN " . TABLE_PREFIX . "customavatar AS customavatar ON(customavatar.userid = user.userid) ") . "
			" . (($vbulletin->options['tmnt_joinuf'] && !$team) ? " LEFT JOIN " . TABLE_PREFIX . "userfield AS userfield ON (user.userid = userfield.userid) LEFT JOIN " . TABLE_PREFIX . "usertextfield AS usertextfield ON (usertextfield.userid = user.userid) " : "") . "
			WHERE tid = '$id'
			ORDER BY slot ASC
		");
		$winnernames = $useridlist = $pinfo = $rounduserinfo = array();
		$rui = 8;
		while ($rui > 0)
		{
			$ruj = 12;
			while ($ruj > 0)
			{
				$rounduserinfo["$rui"]["$ruj"] = array();
				$ruj--;
			}
			$rui--;
		}
		while ($cmpt = $vbulletin->db->fetch_array($cmpts))
		{
			$cmpt = process_tl_avatar($cmpt);
			$avatarlp = $cmpt['avatarlp'];
			$cmpt['time2'] = "<span class=\"smallfont\">".vbdate($vbulletin->options['dateformat'],$cmpt['time'], 0)." <span class=\"time\"> ".vbdate($vbulletin->options['timeformat'],$cmpt['time'])."</span></span>";
			$cmpt['time'] = " ".vbdate($vbulletin->options['dateformat'],$cmpt['time'], 1)." ".vbdate($vbulletin->options['timeformat'],$cmpt['time'])." ";
			$rowno ++;
			$cmpt['row'] = $rowno;
			$var = $cmpt['userid'];
			if (!$cmpt['username'])
			{
				$cmpt['username'] = $cmpt['sname'];
			}
			$array = array_merge((array)$var, $array);
			$var3 = $cmpt['username'];
			$useridlist = array_merge((array)$var3, $useridlist);
			if ($cmpt['winner'] == 1)
			{
				$var2 = $cmpt['userid'];
				$winnerlist = array_merge((array)$var2, $winnerlist);
				$winnernames = array_merge((array)$cmpt['username'], $winnernames);
			}
			$cmpt['userhtml'] = tll_userhtml($cmpt, $team);
			
				$cmpt['round1'] = $rowno;
				$rounduserinfo['1']["$rowno"] = $cmpt;
				$rounduserinfo['2']["$cmpt[round2]"] = $cmpt;
				$rounduserinfo['3']["$cmpt[round3]"] = $cmpt;
				if ($cmpt['round5'] == 1 && $cmpt['round4'] == 0)
				{
					$cmpt['round4'] = 1;
				}
				$rounduserinfo['4']["$cmpt[round4]"] = $cmpt;
				$rounduserinfo['5']["$cmpt[round5]"] = $cmpt;
				$rounduserinfo['6']["$cmpt[round6]"] = $cmpt;
				$rounduserinfo['7']["$cmpt[round7]"] = $cmpt;
				$rounduserinfo['8']["$cmpt[round8]"] = $cmpt;
				$rounduserinfo['9']["$cmpt[round9]"] = $cmpt;
				$rounduserinfo['10']["$cmpt[round10]"] = $cmpt;
				$rounduserinfo['11']["$cmpt[round11]"] = $cmpt;
				$rounduserinfo['12']["$cmpt[round12]"] = $cmpt;
				$rounduserinfo['13']["$cmpt[round13]"] = $cmpt;
				$rounduserinfo['14']["$cmpt[round14]"] = $cmpt;
				if (($cmpt['round8'] & $tmnt['noplayers'] == 8) OR ($cmpt['round6'] & $tmnt['noplayers'] == 4) OR $tmnt['status'] == $vbphrase['tmnt_inprogress'])
				{
					$tmnt['show_round8'] = true;
				}
				$pinfo["$cmpt[userid]"] = $cmpt;
			
			$p_array["$cmpt_count"] = $cmpt;
			$cmpt_count++;
			
		}
		$players = $tmnt['noplayers'];
	//rounds as columns.
	//foreach round, do users, then numbers
	$s_array = $dba = array();
	$query = $vbulletin->db->query_read("
		SELECT r.*
		".(!$team ? ", u.username AS u, u2.username AS u2" :
		", u.teamname AS u, u2.teamname AS u2")."
		FROM " . TABLE_PREFIX . "tmnt_result AS r
		LEFT JOIN " . TABLE_PREFIX . (!$team ? "user" :"tmnt_teams")." AS u
			ON (r.userid = u.".($team?"team":"user")."id)
		LEFT JOIN " . TABLE_PREFIX . (!$team ? "user" :"tmnt_teams")." AS u2
			ON (r.opp_userid = u2.".($team?"team":"user")."id)
		WHERE r.tid = '$tid'
		ORDER BY r.round ASC
	");
	while($qq = $vbulletin->db->fetch_array($query))
	{
		if ($qq['confirm_u'] && $qq['confirm_u2'])
		{
			$qq['confirmed'] = true;
		}
		$round = $qq['round'];
		$dba["$round"][''.$qq['userid'].'.'.$qq['opp_userid'].''] = $qq;
		$r_array[] = $qq;
	}
	$lastround = 1;
	$imax = $players;
	$maxrounds = ceil(log($tmnt['noplayers'], 2))+1;
	for ($round = 1; $round <= $maxrounds; $round++)
	{
		for ($i = 1; $i <= $imax; $i++)
		{
			$ai = $i;
			$a = $rounduserinfo["$round"]["$i"]['userid'];
			$i++;
			$bi = $i;
			$b = $rounduserinfo["$round"]["$i"]['userid'];
			if (!$b && $rounduserinfo["$round"]["$bi"]['username'] == 'Bye')
			{//hide bye rounds
				//continue;
			}
			if (($a || $b) && $dba["$round"]["$a.$b"])
			{
				$si = $dba["$round"]["$a.$b"];
				if ($si['confirmed'] && $si['score_u'] > $si['score_u2'])
				{
					$si['winner'] = 'u';
				}
				elseif ($si['confirmed'] && $si['score_u'] < $si['score_u2'])
				{
					$si['winner'] = 'u2';
				}
				$si['screenshots'] = array();
				if ($si['screen_u'])
				{
					$si['screenshots'] = array_merge($si['screenshots'], explode(';',$si['screen_u']));
				}
				if ($si['screen_u2'])
				{
					$si['screenshots'] = array_merge($si['screenshots'], explode(';',$si['screen_u2']));
				}
				$s_array[] = $si;
			}
			elseif (($a || $b) && $dba["$round"]["$b.$a"])
			{
				$si = $dba["$round"]["$b.$a"];
				if ($si['confirmed'] && $si['score_u'] > $si['score_u2'])
				{
					$si['winner'] = 'u';
				}
				elseif ($si['confirmed'] && $si['score_u'] < $si['score_u2'])
				{
					$si['winner'] = 'u2';
				}
				$si['screenshots'] = array();
				if ($si['screen_u'])
				{
					$si['screenshots'] = array_merge($si['screenshots'], explode(';',$si['screen_u']));
				}
				if ($si['screen_u2'])
				{
					$si['screenshots'] = array_merge($si['screenshots'], explode(';',$si['screen_u2']));
				}
				$s_array[] = $si;
			}
			elseif ($rounduserinfo["$round"]["$ai"] && $rounduserinfo["$round"]["$bi"])
			{
				$roundplus = $round+1;
				$winner = '';
				if ($rounduserinfo["$round"]["$ai"]['round'.$roundplus] > $rounduserinfo["$round"]["$bi"]['round'.$roundplus])
				{
					$winner = 'u';
				}
				elseif ($rounduserinfo["$round"]["$ai"]['round'.$roundplus] < $rounduserinfo["$round"]["$bi"]['round'.$roundplus])
				{
					$winner = 'u2';
				}
				$s_array[] = array(
					'round' => $round,
					'userid' => $rounduserinfo["$round"]["$ai"]['userid'],
					'opp_userid' => $rounduserinfo["$round"]["$bi"]['userid'],
					'u' => $rounduserinfo["$round"]["$ai"]['username'],
					'u2' => $rounduserinfo["$round"]["$bi"]['username'],
					'winner' => $winner
				);
				$show['tmnt_ss_link'] = true;
			}
			if ($changeround)
			{
				$la = count($s_array)-1;
				if ($s_array["$la"]['round'] == $round)
				{
					$s_array["$la"]['changeround'] = 1;
				}
				$changeround = 0;
			}
		}
		$changeround = 1;
		$imax = $imax / 2;
	}
	if ($tmnt['userid']==$thisuserid)
	{
		$tmntp['canedittmnt'] = true;
	}
	if ($tmntp['canedittmnt'])
	{
		$larray = array();
		$ls = $vbulletin->db->query_read("
			SELECT * FROM ".TABLE_PREFIX."tmnt_ladders 
			ORDER BY title ASC
		");
		while($l = $vbulletin->db->fetch_array($ls))
		{
			$larray["$l[id]"] = str_replace(array('"','>'), ' ', $l['title']);
		}
	}
	if ($tmntp['canedittmnt'] && $_REQUEST['export'] == 1 && $_REQUEST['ladderid'])
	{
		$lid = $ladderid = $vbulletin->input->clean_gpc('g', 'ladderid', TYPE_UINT); 
		$ladder = $vbulletin->db->query_first("SELECT * FROM ".TABLE_PREFIX."tmnt_ladders WHERE id = '$lid' AND pot = '".$tmnt['pot']."' ");
		if (!$ladder)
		{
			print_no_permission();
		}
		$ladder['url'] = tll_seo('ladder', $ladder['id'], $ladder['title']);
		$l_ins = array();
		foreach ($s_array AS $s)
		{
			if (!$s['confirmed'])
			{
				continue;
			}
			$sea = ';s:2:"id";s:'.strlen($s['id']).':"'.$s['id'].'";';
			if ($vbulletin->db->query_first("SELECT * FROM ".TABLE_PREFIX."tmnt_ladder_games WHERE from_tmnt LIKE '%".$vbulletin->db->escape_string($sea)."%' AND lid = '$lid'"))
			{
				continue;
			}
			$from_tmnt = serialize(array(
				'tid' => $tmnt['id'],
				'round' => $s['round'],
				'id' => $s['id'],
				'tmnt_title' => $tmnt['title']
			));
			$vbulletin->db->query_write("
				INSERT INTO " . TABLE_PREFIX . "tmnt_ladder_games
					(u, u2, time, dateline, matchdate, dateline_finished, accepted, lid, score_u, score_u2, screen_u, screen_u2, agree_u, agree_u2, finished, pot, from_tmnt)
				VALUES (
					'".$s['userid']."',
					'".$s['opp_userid']."',
					'".$s['dateline']."',
					'".$tmnt['dateline']."',
					'".$s['dateline']."',
					'".$s['dateline']."',
					1,
					'".$lid."',
					'".$s['score_u']."',
					'".$s['score_u2']."',
					'".$s['screen_u']."',
					'".$s['screen_u2']."',
					1,
					1,
					1,
					'".$tmnt['pot']."',
					'".$vbulletin->db->escape_string($from_tmnt)."'
				)
			");
			if ($s['score_u'] > $s['score_u2'])
			{//winner=u
				$win = $s['userid'];
				$lose = $s['opp_userid'];
			}
			else
			{//winner=u2
				$lose = $s['userid'];
				$win = $s['opp_userid'];
			}
				$vbulletin->db->query_write("
					UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
					SET wins = wins + 1, 
						xp = xp + " . $ladder['xp_win'] . ",
						wstreak = wstreak + 1,
						lstreak = 0,
						longeststreak = GREATEST(longeststreak, wstreak)
					WHERE lid = '".$lid."' 
						AND userid = '".$win."'
				");
				$vbulletin->db->query_write("
					UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
					SET loses = loses + 1, 
						xp = xp + " . $ladder['xp_lose'] . ",
						wstreak = 0,
						lstreak = lstreak +1
					WHERE lid = '".$lid."' 
						AND userid = '".$lose."'
				");
		}
		$errormessage = "Exported to Ladder: <a href=\"ladders.php".$ladder['url']."\">".$ladder['title']."</a><br />\r\n<br />\r\n <a href=\"tournaments.php?do=subresults&amp;tid=$tid\">Go back to tournament</a>";
		eval(standard_error($errormessage));
		exit;
	}
	$templater = vB_Template::create('tmnt_submitted_results');
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt', $tmnt);
		$templater->register('rarray', $s_array);
		$templater->register('rounduserinfo', $rounduserinfo);
		$templater->register('show', $show);
		$templater->register('ladders', $larray);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'tournaments.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase[tmnts],
		'tournaments.php' . $tmnt['url'] => $tmnt['title'],
		'' => construct_phrase('Results')
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'updatepositions')
{
	$tid = $vbulletin->input->clean_gpc('p', 'tid', TYPE_UINT);
	$tmnt = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_tmnts WHERE id = '".$tid."' AND type = 'groupplay' ");
	if ((!$tmntp['canedittmnt'] && $tmnt['userid'] != $thisuserid) OR !$tmnt)
	{
		print_no_permission();
	}
	if ($tmnt['status'] != 2)
	{
		print_no_permission();
	}
	$tmnt['url'] = tll_seo('tmnt', $tmnt['id'], $tmnt['title']);
	$tmnt['pergroup'] = ceil(sqrt($tmnt['noplayers']));
	$tmnt['startinggroups'] = ceil($tmnt['noplayers'] / $tmnt['pergroup']);
	$tmnt['progressionrate'] = 0.5;//50%
	$s = $tmnt['noplayers'];
	$tmnt['rounds'] = 0;
	while ($s >= $tmnt['pergroup'])
	{
		$tmnt['rounds']++;
		$s = $s * $tmnt['progressionrate'];
	}
	$cmpts = $vbulletin->db->query_read("
		SELECT p.*, " . (!$tmnt['pot'] ? "u.username" : "t.teamname") . "
		FROM " . TABLE_PREFIX . "tmnt_players AS p
		" . (!$tmnt['pot'] ?
			"LEFT JOIN " . TABLE_PREFIX . "user AS u ON (u.userid = p.userid) " :
			"LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS t ON (t.teamid = p.userid) ") . "
		WHERE p.tid = '$tid'
			AND p.round".$tmnt['rounds']." = 1
		ORDER BY p.slot ASC
	");	
	while ($cmpt = $vbulletin->db->fetch_array($cmpts))
	{
		$array[] = $cmpt;
	}
	$vbulletin->input->clean_array_gpc('p', array(
		'id' => TYPE_ARRAY_UINT,
		'position' => TYPE_ARRAY_UINT,
	));
	foreach ($vbulletin->GPC['id'] AS $h => $id)
	{
		//print_r($id);
		$p = $vbulletin->GPC['position']["$h"];
		if (!$p)
		{
			$incomplete = true;
		}
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_players SET position = '$p' WHERE id = '$id' ");
		//print_r(" $p ");
	}
	if ($_REQUEST['finish'] && !$incomplete)
	{
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_players SET winner = 1 WHERE position = 1 AND tid = '$tid' ");
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_tmnts SET status = 3 WHERE id = '$tid'");
		//print_r("finish");
	}
	//exit;
	$vbulletin->url = "tournaments.php".$tmnt['url'];	
	eval(print_standard_redirect('redirect_tmnt'));
}

// #############################################################################

if ($_REQUEST['do'] == 'editpositions')
{
	$tid = $vbulletin->input->clean_gpc('g', 'tid', TYPE_UINT);
	$tmnt = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_tmnts WHERE id = '".$tid."' AND type = 'groupplay' ");
	if ((!$tmntp['canedittmnt'] && $tmnt['userid'] != $thisuserid) OR !$tmnt)
	{
		print_no_permission();
	}
	if ($tmnt['status'] != 2)
	{
		print_no_permission();
	}
	$tmnt['url'] = tll_seo('tmnt', $tmnt['id'], $tmnt['title']);
	$tmnt['pergroup'] = ceil(sqrt($tmnt['noplayers']));
	$tmnt['startinggroups'] = ceil($tmnt['noplayers'] / $tmnt['pergroup']);
	$tmnt['progressionrate'] = 0.5;//50%
	$s = $tmnt['noplayers'];
	$tmnt['rounds'] = 0;
	while ($s >= $tmnt['pergroup'])
	{
		$tmnt['rounds']++;
		//print_r($s);
		$s = $s * $tmnt['progressionrate'];
		//print_r($s);
	}
	//print_r($tmnt);
	$cmpts = $vbulletin->db->query_read("
		SELECT p.*, " . (!$tmnt['pot'] ? "u.username" : "t.teamname") . "
		FROM " . TABLE_PREFIX . "tmnt_players AS p
		" . (!$tmnt['pot'] ?
			"LEFT JOIN " . TABLE_PREFIX . "user AS u ON (u.userid = p.userid) " :
			"LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS t ON (t.teamid = p.userid) ") . "
		WHERE p.tid = '$tid'
			AND p.round".$tmnt['rounds']." = 1
		ORDER BY p.slot ASC
	");	
	while ($cmpt = $vbulletin->db->fetch_array($cmpts))
	{
		$array[] = $cmpt;
		//print_r($cmpt['username']. $cmpt['position']);
	}
	$templater = vB_Template::create('tmnt_editpositions');
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt', $tmnt);
		$templater->register('array', $array);
	$tlhtml .= $templater->render();
	if ($_REQUEST['ajax']==1)
	{
		print_r($tlhtml);
		exit;
	}
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'tournaments.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase[tmnts],
		'tournaments.php' . $tmnt['url'] => $tmnt['title'],
		'' => construct_phrase('Final Positions')
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
	exit;
}

// #############################################################################

if ($_POST['do'] == 'adminsubmitscores')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'tid'      => TYPE_UINT,
		'pot' => TYPE_BOOL,
		'round'     => TYPE_ARRAY_UINT,
		'score_u'     => TYPE_ARRAY_UINT,
		'score_u2'     => TYPE_ARRAY_UINT,
		'userid'     => TYPE_ARRAY_UINT,
		'opp_userid'     => TYPE_ARRAY_UINT,
		'winner'     => TYPE_ARRAY_NOHTML,
	));
	$id = $tid = $vbulletin->GPC['tid'];
	$tmnt = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_tmnts WHERE id = '$tid' ");
	if ((!$tmntp['canedittmnt'] && $tmnt['userid'] != $thisuserid) OR !$tmnt)
	{
		//print_no_permission();
	}
	if ($tmnt['status'] != 3)
	{//check finished
		//print_no_permission();
	}
	$tmnt['url'] = tll_seo('tmnt', $tmnt['id'], $tmnt['title']);
	$team = false;
	if ($tmnt['pot'])
	{
		$team = true;
	}
	$sarray = array();
	foreach ($vbulletin->GPC['round'] AS $k => $round)
	{
		if (!$vbulletin->GPC['score_u']["$k"] && !$vbulletin->GPC['score_u2']["$k"])
		{
			continue;
		}
		if ($vbulletin->GPC['winner']["$k"]=='u' && $vbulletin->GPC['score_u']["$k"] < $vbulletin->GPC['score_u2']["$k"])
		{
			$errormessage = "Error, some of the scores you have submitted do not match tournament bracket.";
			eval(standard_error($errormessage));
		}
		elseif ($vbulletin->GPC['winner']["$k"]=='u2' && $vbulletin->GPC['score_u']["$k"] > $vbulletin->GPC['score_u2']["$k"])
		{
			$errormessage = "Error, some of the scores you have submitted do not match tournament bracket.";
			eval(standard_error($errormessage));
		}
		elseif ($vbulletin->GPC['score_u']["$k"] == $vbulletin->GPC['score_u2']["$k"])
		{
			$errormessage = "Error, cannot enter a draw.";
			eval(standard_error($errormessage));
		}
		$sarray[] = array(
			'tid' => $vbulletin->GPC['tid'],
			'round' => $round,
			'dateline' => TIMENOW,
			'userid'     => $vbulletin->GPC['userid']["$k"],
			'opp_userid'     =>  $vbulletin->GPC['opp_userid']["$k"],
			'score_u'     =>  $vbulletin->GPC['score_u']["$k"],
			'score_u2'     =>  $vbulletin->GPC['score_u2']["$k"],
			'confirm_u'     => 1,
			'confirm_u2'     => 1
		);
	}
	foreach ($sarray AS $row)
	{
		$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "tmnt_result
			(tid, round, dateline, userid, opp_userid, score_u, score_u2, confirm_u, confirm_u2)
			VALUES (
				'".$vbulletin->db->escape_string($tid)."', 
				'".$vbulletin->db->escape_string($row['round'])."', 
				'".$vbulletin->db->escape_string($row['dateline'])."',
				'".$vbulletin->db->escape_string($row['userid'])."',
				'".$vbulletin->db->escape_string($row['opp_userid'])."',
				'".$vbulletin->db->escape_string($row['score_u'])."',
				'".$vbulletin->db->escape_string($row['score_u2'])."',
				'1',
				'1'
			)
		");
	}
	$vbulletin->url = "tournaments.php?do=subresults&tid=".$tid;	
	eval(print_standard_redirect('redirect_updatetmnt'));
}

// #############################################################################

if ($_REQUEST['do'] == 'adminsubmitscores')
{
	$id = $tid = $vbulletin->input->clean_gpc('g', 'tid', TYPE_UINT);
	$tmnt = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_tmnts WHERE id = '$tid' ");
	if ((!$tmntp['canedittmnt'] && $tmnt['userid'] != $thisuserid) OR !$tmnt)
	{
		print_no_permission();
	}
	if ($tmnt['status'] != 3)
	{//check finished
		$errormessage = 'Admins can only submit scores once tournament has finished.';
        eval(standard_error($errormessage));
	}
	$tmnt['url'] = tll_seo('tmnt', $tmnt['id'], $tmnt['title']);
	//
	$team = false;
	if ($tmnt['pot'])
	{
		$team = true;
	}
		$cmpt_count = 1;
		$winnerlist = $array = $p_array = array();
		$cmpts = $vbulletin->db->query_read("
			SELECT
				" . (!$team ? "user.*," : "") . " players.*, players.username AS sname,
				" . (!$team ? "user.username AS username, user.userid, user.avatarrevision AS avatarrevision, avatar.avatarpath AS avatarpath, NOT ISNULL(customavatar.userid) AS hascustom, customavatar.dateline AS avatardateline, customavatar.width AS avwidth, customavatar.height AS avheight, user.username AS username" : "user.teamname AS username, user.teamid, user.teamlogo AS avatarurl") . "
				" . (($vbulletin->options['tmnt_joinuf'] && !$team) ? ", userfield.*, usertextfield.* " : "") . "
			FROM " . TABLE_PREFIX . "tmnt_players AS players 
			" . ($team ? "LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS user ON (players.userid = user.teamid)" : "LEFT JOIN " . TABLE_PREFIX . "user AS user ON (players.userid = user.userid) LEFT JOIN " . TABLE_PREFIX . "avatar AS avatar ON(avatar.avatarid = user.avatarid) LEFT JOIN " . TABLE_PREFIX . "customavatar AS customavatar ON(customavatar.userid = user.userid) ") . "
			" . (($vbulletin->options['tmnt_joinuf'] && !$team) ? " LEFT JOIN " . TABLE_PREFIX . "userfield AS userfield ON (user.userid = userfield.userid) LEFT JOIN " . TABLE_PREFIX . "usertextfield AS usertextfield ON (usertextfield.userid = user.userid) " : "") . "
			WHERE tid = '$id'
			ORDER BY slot ASC
		");
		$winnernames = $useridlist = $pinfo = $rounduserinfo = array();
		$rui = 8;
		while ($rui > 0)
		{
			$ruj = 12;
			while ($ruj > 0)
			{
				$rounduserinfo["$rui"]["$ruj"] = array();
				$ruj--;
			}
			$rui--;
		}
		while ($cmpt = $vbulletin->db->fetch_array($cmpts))
		{
			$cmpt = process_tl_avatar($cmpt);
			$avatarlp = $cmpt['avatarlp'];
			$cmpt['time2'] = "<span class=\"smallfont\">".vbdate($vbulletin->options['dateformat'],$cmpt['time'], 0)." <span class=\"time\"> ".vbdate($vbulletin->options['timeformat'],$cmpt['time'])."</span></span>";
			$cmpt['time'] = " ".vbdate($vbulletin->options['dateformat'],$cmpt['time'], 1)." ".vbdate($vbulletin->options['timeformat'],$cmpt['time'])." ";
			$rowno ++;
			$cmpt['row'] = $rowno;
			$var = $cmpt['userid'];
			if (!$cmpt['username'])
			{
				$cmpt['username'] = $cmpt['sname'];
			}
			$array = array_merge((array)$var, $array);
			$var3 = $cmpt['username'];
			$useridlist = array_merge((array)$var3, $useridlist);
			if ($cmpt['winner'] == 1)
			{
				$var2 = $cmpt['userid'];
				$winnerlist = array_merge((array)$var2, $winnerlist);
				$winnernames = array_merge((array)$cmpt['username'], $winnernames);
			}
			$cmpt['userhtml'] = tll_userhtml($cmpt, $team);
			
				$cmpt['round1'] = $rowno;
				$rounduserinfo['1']["$rowno"] = $cmpt;
				$rounduserinfo['2']["$cmpt[round2]"] = $cmpt;
				$rounduserinfo['3']["$cmpt[round3]"] = $cmpt;
				if ($cmpt['round5'] == 1 && $cmpt['round4'] == 0)
				{
					$cmpt['round4'] = 1;
				}
				$rounduserinfo['4']["$cmpt[round4]"] = $cmpt;
				$rounduserinfo['5']["$cmpt[round5]"] = $cmpt;
				$rounduserinfo['6']["$cmpt[round6]"] = $cmpt;
				$rounduserinfo['7']["$cmpt[round7]"] = $cmpt;
				$rounduserinfo['8']["$cmpt[round8]"] = $cmpt;
				$rounduserinfo['9']["$cmpt[round9]"] = $cmpt;
				$rounduserinfo['10']["$cmpt[round10]"] = $cmpt;
				if (($cmpt['round8'] & $tmnt['noplayers'] == 8) OR ($cmpt['round6'] & $tmnt['noplayers'] == 4) OR $tmnt['status'] == $vbphrase['tmnt_inprogress'])
				{
					$tmnt['show_round8'] = true;
				}
				$pinfo["$cmpt[userid]"] = $cmpt;
			
			$p_array["$cmpt_count"] = $cmpt;
			$cmpt_count++;
			
		}
		$players = $tmnt['noplayers'];
	//rounds as columns.
	//foreach round, do users, then numbers
	$s_array = $dba = array();
	$query = $vbulletin->db->query_read("
		SELECT r.*, u.username AS u, u2.username AS u2
		FROM " . TABLE_PREFIX . "tmnt_result AS r
		LEFT JOIN " . TABLE_PREFIX . "user AS u
			ON (r.userid = u.userid)
		LEFT JOIN " . TABLE_PREFIX . "user AS u2
			ON (r.opp_userid = u2.userid)
		WHERE r.tid = '$tid'
		ORDER BY r.round ASC
	");
	while($qq = $vbulletin->db->fetch_array($query))
	{
		if ($qq['confirm_u'] && $qq['confirm_u2'])
		{
			$qq['confirmed'] = true;
		}
		$round = $qq['round'];
		$dba["$round"][''.$qq['userid'].'.'.$qq['opp_userid'].''] = $qq;
		$r_array[] = $qq;
	}
	$lastround = 1;
	$imax = $players;
	$maxrounds = ceil(log($tmnt['noplayers'], 2))+1;
	for ($round = 1; $round <= $maxrounds; $round++)
	{
		for ($i = 1; $i <= $imax; $i++)
		{
			$ai = $i;
			$a = $rounduserinfo["$round"]["$i"]['userid'];
			$i++;
			$bi = $i;
			$b = $rounduserinfo["$round"]["$i"]['userid'];
			if (!$b && $rounduserinfo["$round"]["$bi"]['username'] == 'Bye')
			{//hide bye rounds
				//continue;
			}
			if (($a || $b) && $dba["$round"]["$a.$b"])
			{
				/**/
			}
			elseif (($a || $b) && $dba["$round"]["$b.$a"])
			{
				/**/
			}
			elseif ($rounduserinfo["$round"]["$ai"] && $rounduserinfo["$round"]["$bi"])
			{
				$roundplus = $round+1;
				$winner = '';
				$score_u = $score_u2 = 0;
				if ($rounduserinfo["$round"]["$ai"]['round'.$roundplus] > $rounduserinfo["$round"]["$bi"]['round'.$roundplus])
				{
					$winner = 'u';
					$score_u = 1;
				}
				elseif ($rounduserinfo["$round"]["$ai"]['round'.$roundplus] < $rounduserinfo["$round"]["$bi"]['round'.$roundplus])
				{
					$winner = 'u2';
					$score_u2 = 1;
				}
				$s_array[] = array(
					'round' => $round,
					'userid' => $rounduserinfo["$round"]["$ai"]['userid'],
					'opp_userid' => $rounduserinfo["$round"]["$bi"]['userid'],
					'u' => $rounduserinfo["$round"]["$ai"]['username'],
					'u2' => $rounduserinfo["$round"]["$bi"]['username'],
					'score_u' => $score_u,
					'score_u2' => $score_u2,
					'winner' => $winner
				);
			}
			if ($changeround)
			{
				$la = count($s_array)-1;
				if ($s_array["$la"]['round'] == $round)
				{
					$s_array["$la"]['changeround'] = 1;
				}
				$changeround = 0;
			}
		}
		$changeround = 1;
		$imax = $imax / 2;
	}
	if (empty($s_array))
	{
		$errormessage = 'All scores have already been submitted.<br /><br /><a href="tournaments.php?do=subresults&amp;tid='.$tid.'">Click here to view scores.</a><br /><a href="tournaments.php'.$tmnt['url'].'">Click here to go back to the tournament.</a>';
        eval(standard_error($errormessage));
	}
	$templater = vB_Template::create('tmnt_adminsubmitscores');
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt', $tmnt);
		$templater->register('array', $s_array);
		$templater->register('rounduserinfo', $rounduserinfo);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'tournaments.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase[tmnts],
		'tournaments.php' . $tmnt['url'] => $tmnt['title'],
		'' => construct_phrase('Results')
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if (!$_REQUEST['do'] && $vbulletin->options['tmnt_seo'] && $vbulletin->options['tmnt_premium'] && isset($_SERVER['REQUEST_URI']))
{
	$thisurl = end(explode('/',$vbulletin->input->clean($_SERVER['REQUEST_URI'], TYPE_NOHTML)));
	if (substr($thisurl, 0, 17)=='tournaments.php?t')
	{
		$id = $tid = $vbulletin->input->clean(substr($thisurl,17), TYPE_UINT);
		if ($tid)
		{
			$_REQUEST['do'] = 'view';
			$_REQUEST['id'] = $tid;
		}
	}
}

if ($_REQUEST['do'] == 'view')
{
	if (!$tmntp['canviewtmnt'])
	{
		print_no_permission();
	}
	require_once(DIR . '/includes/class_bbcode.php');
	if (!$tid)
	{
		$tid = $id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	}
	if (!$id)
	{
		$errormessage = $vbphrase[error_invalid_tournament];
        eval(standard_error($errormessage));
	}
	$showcomps = $vbulletin->input->clean_gpc('g', 'showcomps', TYPE_UINT);
	$tmnt = $vbulletin->db->query_first("
		SELECT tmnts.*, ladders.title AS laddertitle, round(total_votes/count_votes,2) AS avg_vote
		FROM ". TABLE_PREFIX ."tmnt_tmnts AS tmnts
		LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders
			ON (tmnts.ladderid = ladders.id)
		WHERE tmnts.id = '$id'
	");
	($hook = vBulletinHook::fetch_hook('tll_tmnt_view_post_query')) ? eval($hook) : false;
	if (!$tmnt)
	{
		$errormessage = $vbphrase['error_invalid_tournament'];
        eval(standard_error($errormessage));
	}
	$tmnt['av'] = number_format($tmnt['avg_vote']);
	$tmnt['url'] = tll_seo('tmnt', $tmnt['id'], $tmnt['title']);
	if ($tmnt['password'] && $vbulletin->options['tmnt_premium'])
	{
		require_once(DIR . '/includes/functions_tll_prem.php');	
		check_tmnt_password('view');
		$tmnt['turl'] = '&amp;password='.$tmnt['password'];
	}
	if ($vbulletin->options['tmnt_premium'] && $vbulletin->options['tmnt_seo'] && !$thisurl && isset($_SERVER['REQUEST_URI']))
	{
		$thisurl = end(explode('/',$vbulletin->input->clean($_SERVER['REQUEST_URI'], TYPE_NOHTML)));
		if (substr($thisurl, 0, 31)=='tournaments.php?do=view&amp;id=')
		{
			$thisurl = $tmnt['url'].str_replace('&amp;','&',substr($thisurl,31+strlen($id)));
			Header("HTTP/1.1 301 Moved Permanently"); 
			Header("Location: ".$vbulletin->options['bburl']."/tournaments.php".$thisurl);
		}
	}
	if (($tmnt['noplayers'] > $tmnt_maxde && $tmnt['type']=='de') || ($tmnt['noplayers'] > $tmnt_maxrr && $tmnt['type']=='rr') OR ($tmnt['noplayers'] > $tmnt_maxdrr && $tmnt['type']=='drr'))
	{ //Adjust too large Tournaments
		if ($tmnt['type'] == 'rr')
		{//round robin
			$x = $tmnt['noplayers'] - $tmnt_maxrr;
		}
		elseif ($tmnt['type'] == 'drr')
		{//round robin
			$x = $tmnt['noplayers'] - $tmnt_maxdrr;
		}
		else
		{//double elimination
			$x = $tmnt['noplayers'] - $tmnt_maxde;
		}
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_tmnts SET noplayers = noplayers-$x".($tmnt['freeslots']>0 ? ", freeslots = freeslots-$x" : "") . " WHERE id=$id");
		$vbulletin->url = "tournaments.php".$tmnt['url'];	
		eval(print_standard_redirect('redirect_updatetmnt'));
		exit;
	}
	if ($tmnt['freeslots'] == 0 && $tmnt['status'] == 1)
	{//adjust wrong status
		process_full_tmnt($id);
		$vbulletin->url = "tournaments.php".$tmnt['url'];
		eval(print_standard_redirect('redirect_updatetmnt'));
	}
	if ($tmnt['catid'])
	{
		$tmnt['categorytitle'] = $vbulletin->tll_catcache["$tmnt[catid]"]['title'];
		$tmnt['categoryurl'] = $vbulletin->tll_catcache["$tmnt[catid]"]['url'];
		$tmnt['parentid'] = $vbulletin->tll_catcache["$tmnt[catid]"]['parentid'];
		if ($tmnt['parentid'])
		{
			$tmnt['parenttitle'] = $tmnt['categorytitle2'] = $vbulletin->tll_catcache["$tmnt[parentid]"]['title'];
			$tmnt['parenturl'] = $vbulletin->tll_catcache["$tmnt[parentid]"]['url'];
		}
	}
	$tmnt['link'] = unserialize($tmnt['link']);
	$cpp = $vbulletin->options['tmnt_cpp'];
	$noofcomments = $tmnt['comments'];
	$lastpage = ceil($noofcomments/$cpp);
	$page = $vbulletin->input->clean_gpc('g', 'page', TYPE_UINT);
	if (!$page OR $page == 0)
	{
		$page = 1;
	}
	$offset = ($page - 1) * $cpp;
	if ($offset < 0) {
		$offset = 0;
	}
	if ($tmnt['userid'] == $thisuserid)
	{
		$tmntp['canedittmnt'] = true;
	}
	$edited = false;
	if ($tmnt['time'] != $tmnt['le_time'])
	{
		$edited = true;
	}
	$tmnt['dateline']=$tmnt['time'];
	//$tmnt['dateline'] = vbdate($vbulletin->options['dateformat'], $tmnt['time'], 1) . " " . vbdate($vbulletin->options['timeformat'], $tmnt['time']);
	$tmnt['dateline_tmnt_startdate'] = vbdate($vbulletin->options['dateformat'], $tmnt['date']);
	$tmnt['dateline_tmnt_starttime'] = vbdate($vbulletin->options['timeformat'], $tmnt['date']);
	$tmnt['le_time'] = vbdate($vbulletin->options['timeformat'],$tmnt['le_time']).$vbphrase['ladder_on'].vbdate($vbulletin->options['dateformat'],$tmnt['le_time']);
	/*$date = vbdate($vbulletin->options['dateformat'],$tmnt['date'], 1);
	$time = vbdate($vbulletin->options['timeformat'],$tmnt['date']);*/
	$title = $tmnt['title'];
	$title2 = addslashes($tmnt['title']);
	$tmnt = switch_tmnt_status($tmnt);
	$team = false;
	if ($tmnt['pot'])
	{
		$team = true;
		$vbphrase['tmnt_swapplayers'] = $vbphrase['tmnt_swapteams'];
	}
	$tmnt = switch_tmnt_type($tmnt);
	$type = $tmnt['type'];
	$sticky = $tmnt['sticky'];
	$archive = $tmnt['archive'];
	switch ($tmnt['checkin'])
	{
		case 600:
			$tmnt['checkin_timetext'] = '10 minutes';
			break;
		case 1200:
			$tmnt['checkin_timetext'] = '20 minutes';
			break;
		case 1800:
			$tmnt['checkin_timetext'] = '30 minutes';
			break;
		case 3600:
			$tmnt['checkin_timetext'] = '1 hour';
			break;
		case 7200:
			$tmnt['checkin_timetext'] = '2 hours';
			break;
			
	}
	$tmnt['dateline_checkin_startdate'] = vbdate($vbulletin->options['dateformat'], $tmnt['date'] - $tmnt['checkin']);
	$tmnt['dateline_checkin_starttime'] = vbdate($vbulletin->options['timeformat'], $tmnt['date'] - $tmnt['checkin']);
	if (TIMENOW < $tmnt['date'])
	{
		$tmnt['not_started'] = true;
	}
	if ($tmnt['checkin'] && TIMENOW > $tmnt['date'] - $tmnt['checkin'] && TIMENOW <= $tmnt['date'])
	{
		$tmnt['checkin_now'] = true;
		$showcomps = 1;
	}
	elseif ($tmnt['checkin'] && TIMENOW <= $tmnt['date'])
	{
		$showcomps = 1;
	}
	if ($tmnt['hide_untilstart'] && $tmnt['not_started'])
	{
		$showcomps = 1;
		$tmnt['hide_brackets'] = 1;
		if ($_REQUEST['sh'] == 1)
		{
			$_REQUEST['sh'] = 2;
			$sh = 2;
		}
	}
	if ($tmnt['additional'])
	{
		$tmnt['additional'] = unserialize($tmnt['additional']);
		if (is_array($tmnt['additional']))
		{
			$tmnt = array_merge($tmnt, $tmnt['additional']);
		}
	}
	if ($showcomps && $tmnt['allowreserves'] && $tmnt['freeslots']==0)
	{
		//$tmnt['status'] = 'Awaiting Start';
		$tmnt['reserves_array'] = array();
		$resquery = $vbulletin->db->query_read("
			SELECT r.*, " . ($tmnt['pot'] ? "t.teamname" : "u.username") . " AS username
			FROM " . TABLE_PREFIX . "tmnt_reserves AS r
			" . (!$tmnt['pot'] ? "LEFT JOIN " . TABLE_PREFIX . "user AS u
				ON (u.userid = r.userid)" : "") . "
			" . ($tmnt['pot'] ? "LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS t
				ON (t.teamid = r.userid)" : "") . "
			WHERE r.tmntid = '$tid' 
		");
		while($reserve = $vbulletin->db->fetch_array($resquery))
		{
			if ($tmnt['pot'])
			{
				$reserve['url'] = tll_seo('team', $reserve['userid'], $reserve['username']);
			}
			else
			{
				$reserve['url'] = fetch_seo_url('member', $reserve);
			}
			$tmnt['reserves_array'][] = $reserve;
		}
	}
	if ($tmnt['roundtext'])
	{
		$tmnt['roundtext'] = unserialize($tmnt['roundtext']);
		foreach ($tmnt['roundtext'] AS $roundi => $roundtext)
		{
			$template_hook['round'.$roundi] .= '<br /><span style="font-weight: normal;">'.$roundtext.'</span>';
		}
	}
	$bbcode_parser = new vB_BbCodeParser($vbulletin, fetch_tag_list(), true); 
	$tmnt['description'] = $bbcode_parser->do_parse($tmnt['description'],false,true,true,true,true,false);
	//$tmnt['description'] = preg_replace('/\[newbox\=(.+?)\](.+?)\[\/newbox\]/is','</div></div></div><br /><h2 class="blockhead">$1</h2><div class="blockbody formcontrols"><div class="blockrow"><div class="restore"> $2',$tmnt['description']);
	list($tmnt['description'], $tmnt['rules']) = preg_split('/\[rules\]/', $tmnt['description']);
	$tmnt['rules'] = trim($tmnt['rules']);
	if (substr($tmnt['rules'],0,6)=='<br />')
	{
		$tmnt['rules'] = substr($tmnt['rules'],6);
	}
	if (file_exists(DIR . '/includes/functions_tll_tabs.php'))
	{
		$sh = $vbulletin->input->clean_gpc('g', 'sh', TYPE_UINT);
		require_once(DIR . '/includes/functions_tll_tabs.php');
		$template_hook = tll_tabs($template_hook, $tid, 0, 0);
		$show['addtab'] = true;
	}
	$rowno = 0;
	$array = array();
	$winnerlist = array();
	$winnernames = array();
	$useridlist = array();
	if (in_array($type, array($vbphrase['tmnt_1v1'], $vbphrase['tmnt_de'], $vbphrase['tmnt_rr'], $vbphrase['tmnt_drr'], $vbphrase['tmnt_groupplay'], $vbphrase['tmnt_groupplay_ko'], $vbphrase['tmnt_swiss'])))
	{
		$bracketcolor = $vbulletin->options['tmnt_bracketcolor'];
		$cmpt_count = 1;
		$p_array = array();
		/*GROUP_CONCAT(tmu.username ORDER BY tm.id) AS teammembers,*/
		/*" . ($team ? " LEFT JOIN " . TABLE_PREFIX . "tmnt_members AS tm ON (tm.teamid = players.userid AND tm.accepted = 1) LEFT JOIN " . TABLE_PREFIX . "user AS tmu ON (tm.userid = tmu.userid) " : "") . "*/
		/*" . ($team ? " GROUP BY players.userid " : "") . "*/
		$cmpts = $vbulletin->db->query_read("
			SELECT
				" . (!$team ? "user.*," : "  ") . " players.*, players.username AS sname,
				" . (!$team ? "user.username AS username, user.userid, user.avatarrevision AS avatarrevision, avatar.avatarpath AS avatarpath, NOT ISNULL(customavatar.userid) AS hascustom, customavatar.dateline AS avatardateline, customavatar.width AS avwidth, customavatar.height AS avheight, user.username AS username" : "user.teamname AS username, user.teamid, user.teamlogo AS avatarurl, user.locked ") . "
				" . (($vbulletin->options['tmnt_joinuf'] && !$team) ? ", userfield.*, usertextfield.* " : "") . "
				$cmpts_mysql_select
			FROM " . TABLE_PREFIX . "tmnt_players AS players 
			" . ($team ? "LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS user ON (players.userid = user.teamid)" : "LEFT JOIN " . TABLE_PREFIX . "user AS user ON (players.userid = user.userid) LEFT JOIN " . TABLE_PREFIX . "avatar AS avatar ON(avatar.avatarid = user.avatarid) LEFT JOIN " . TABLE_PREFIX . "customavatar AS customavatar ON(customavatar.userid = user.userid) ") . "
			" . (($vbulletin->options['tmnt_joinuf'] && !$team) ? " LEFT JOIN " . TABLE_PREFIX . "userfield AS userfield ON (user.userid = userfield.userid) LEFT JOIN " . TABLE_PREFIX . "usertextfield AS usertextfield ON (usertextfield.userid = user.userid) " : "") . "
			WHERE tid = '$id'
			ORDER BY slot ASC
		");
		$pinfo = $rounduserinfo = array();
		$rui = 8;
		while ($rui > 0)
		{
			$ruj = 12;
			while ($ruj > 0)
			{
				$rounduserinfo["$rui"]["$ruj"] = array();
				$ruj--;
			}
			$rui--;
		}
		while ($cmpt = $vbulletin->db->fetch_array($cmpts))
		{
			$cmpt = process_tl_avatar($cmpt);
			$avatarlp = $cmpt['avatarlp'];
			$cmpt['time2'] = "<span class=\"smallfont\">".vbdate($vbulletin->options['dateformat'],$cmpt['time'], 0)." <span class=\"time\"> ".vbdate($vbulletin->options['timeformat'],$cmpt['time'])."</span></span>";
			$cmpt['time'] = " ".vbdate($vbulletin->options['dateformat'],$cmpt['time'], 1)." ".vbdate($vbulletin->options['timeformat'],$cmpt['time'])." ";
			$rowno ++;
			$cmpt['row'] = $rowno;
			$var = $cmpt['userid'];
			if (!$cmpt['username'])
			{
				$cmpt['username'] = $cmpt['sname'];
			}
			$cmpt['username'] = str_replace("'","&#8217;",$cmpt['username']);
			$array = array_merge((array)$var, $array);
			$var3 = $cmpt['username'];
			$useridlist = array_merge((array)$var3, $useridlist);
			if ($cmpt['winner'] == 1)
			{
				$var2 = $cmpt['userid'];
				$winnerlist = array_merge((array)$var2, $winnerlist);
				$winnernames = array_merge((array)$cmpt['username'], $winnernames);
			}
			$cmpt['userhtml'] = tll_userhtml($cmpt, $team);
			if (in_array($type, array($vbphrase['tmnt_1v1'], $vbphrase['tmnt_de'], $vbphrase['tmnt_groupplay'], $vbphrase['tmnt_groupplay_ko'], $vbphrase['tmnt_swiss'])))
			{
				$cmpt['round1'] = $rowno;
				$rounduserinfo['1']["$rowno"] = $cmpt;
				if ($type != $vbphrase['tmnt_groupplay'])
				{
					$rounduserinfo['2']["$cmpt[round2]"] = $cmpt;
					$rounduserinfo['3']["$cmpt[round3]"] = $cmpt;
					if ($cmpt['round5'] == 1 && $cmpt['round4'] == 0)
					{
						$cmpt['round4'] = 1;
					}
					$rounduserinfo['4']["$cmpt[round4]"] = $cmpt;
					$rounduserinfo['5']["$cmpt[round5]"] = $cmpt;
					$rounduserinfo['6']["$cmpt[round6]"] = $cmpt;
					$rounduserinfo['7']["$cmpt[round7]"] = $cmpt;
					$rounduserinfo['8']["$cmpt[round8]"] = $cmpt;
					$rounduserinfo['9']["$cmpt[round9]"] = $cmpt;
					$rounduserinfo['10']["$cmpt[round10]"] = $cmpt;
					$rounduserinfo['11']["$cmpt[round11]"] = $cmpt;
					$rounduserinfo['12']["$cmpt[round12]"] = $cmpt;
					$rounduserinfo['13']["$cmpt[round13]"] = $cmpt;
					$rounduserinfo['14']["$cmpt[round14]"] = $cmpt;
					if (($cmpt['round8'] & $tmnt['noplayers'] == 8) OR ($cmpt['round6'] & $tmnt['noplayers'] == 4) OR $tmnt['status'] == $vbphrase['tmnt_inprogress'])
					{
						$tmnt['show_round8'] = true;
					}
				}
				else
				{
					if ($cmpt['round2'] > 0)
					{
						$sx = 1 + ($cmpt['round2']-1) * ceil(sqrt($tmnt['noplayers']));
						while ($rounduserinfo["2"]["$sx"]['username'])
						{
							$sx++;
						}
						$rounduserinfo["2"]["$sx"] = $cmpt;
					}
					if ($cmpt['round3'] > 0)
					{
						$sx = 1 + ($cmpt['round3']-1) * ceil(sqrt($tmnt['noplayers']));
						while ($rounduserinfo["3"]["$sx"]['username'])
						{
							$sx++;
						}
						$rounduserinfo["3"]["$sx"] = $cmpt;
					}
					if ($cmpt['round4'] > 0)
					{
						$sx = 1 + ($cmpt['round4']-1) * ceil(sqrt($tmnt['noplayers']));
						while ($rounduserinfo["4"]["$sx"]['username'])
						{
							$sx++;
						}
						$rounduserinfo["4"]["$sx"] = $cmpt;
					}
				}
				$pinfo["$cmpt[userid]"] = $cmpt;
			}
			$p_array["$cmpt_count"] = $cmpt;
			$cmpt_count++;
			if (!$team && $cmpt['userid'] == $vbulletin->userinfo['userid'] && $cmpt['checkedin'] > 0)
			{
				$vbulletin->userinfo['checkedin'] = $cmpt['checkedin'];
			}
			if (TIMENOW > $tmnt['date'] && !$cmpt['checkedin'] && $tmnt['checkin'])
			{
				process_full_tmnt($id, 1);
				$vbulletin->url = "tournaments.php".$tmnt['url'];	
				eval(print_standard_redirect('redirect_updatetmnt'));
			}
			$templater = vB_Template::create('tmnt_cmpt');
				$templater->register('tmnt', $tmnt);
				$templater->register('tmntp', $tmntp);
				$templater->register('team', $team);
				$templater->register('tid', $tid);
				$templater->register('topscore', $topscore);
				$templater->register('cmpt', $cmpt);
			$competitors .= $templater->render();
		}
		if ($rowno == 0)
		{
			$templater = vB_Template::create('tmnt_cmpt_none');
				$templater->register('tmnt', $tmnt);
				$templater->register('cmpt', $cmpt);
			$competitors .= $templater->render();
		}
		$players = $tmnt['noplayers'];
	}
	if (in_array($type, array($vbphrase['tmnt_1v1'], $vbphrase['tmnt_de'], $vbphrase['tmnt_swiss'])))
	{
		require_once(DIR . '/includes/functions_tll_brackets.php');
		if ($vbulletin->options['tmnt_premium'])
		{
			$scores_db = array(); //round => userid => score
			$query = $vbulletin->db->query_read("
				SELECT r.*
				FROM " . TABLE_PREFIX . "tmnt_result AS r
				WHERE r.tid = '$tid'
				ORDER BY r.round ASC
			");
			while($qq = $vbulletin->db->fetch_array($query))
			{
				if (!$qq['confirm_u'] || !$qq['confirm_u2'])
				{
					continue;
				}
				$stre1 = $qq['round'];
				$stre2 = $qq['userid'];
				$stre3 = $qq['opp_userid'];
				$scores_db["$stre1"]["$stre2"] = $qq['score_u'];
				$scores_db["$stre1"]["$stre3"] = $qq['score_u2'];
			}
		}
	}
	if (in_array($type, array($vbphrase['tmnt_swiss'])))
	{
		if ($tmnt['lms_rounds']<1)
		{
			$results = 'Please edit tournament and select number of rounds';
		}
		else
		{
require_once(DIR . '/includes/functions_tll_brackets.php');
require_once(DIR . '/includes/functions_tll_prem.php');
			$tmnt['knockout_started'] = true;
			$results = '';
			//print_r($scores_db);
			//print_r($tmnt);
			$tmnt['current_round'] = $tmnt['lms_rounds'];
			//print_r($scores_db["$tll_r"]);
			for ($tll_r = 1; $tll_r <= $tmnt['lms_rounds']; $tll_r++)
			{
				$results .= '<div><div class="blocksubhead" style="clear: both;">'.construct_phrase($vbphrase['tmnt_round_x'], $tll_r).'</div>';
				if ($tll_r == 1)
				{
					for ($ru = 1; $ru <= $tmnt['noplayers']; $ru++)
					{
						$ru2 = $ru + 1;
						$ri = $rounduserinfo['1']["$ru"];
						$ri2 = $rounduserinfo['1']["$ru2"];
						if ($tmntp['canedittmnt'])
						{
							$editlink = 'tournaments.php?do=submitresult&amp;admin=1&amp;tid='.$tid.'&amp;round='.$ru.'&amp;userid=';
						}
						$results .= '<div style="margin-right: 15px; float: left; text-align: center;">'.tll_frame_s($ri, $ri2, $scores_db["$tll_r"]["$ri[userid]"], $scores_db["$tll_r"]["$ri2[userid]"], $editlink).'</div>';
						if ($ri['userid'] == $vbulletin->userinfo['userid'] && !$team && !($scores_db["$tll_r"]["$ri[userid]"] + $scores_db["$tll_r"]["$ri2[userid]"]))
						{
							$tmnt['nextinfo'] = array(
								'round' => $tll_r,
								'userid' => $ri2['userid'],
								'username' => $ri2['username'],
							);
						}
						else if ($ri2['userid'] == $vbulletin->userinfo['userid'] && !$team && !($scores_db["$tll_r"]["$ri[userid]"] + $scores_db["$tll_r"]["$ri2[userid]"]))
						{
							$tmnt['nextinfo'] = array(
								'round' => $tll_r,
								'userid' => $ri2['userid'],
								'username' => $ri2['username'],
							);
						}
						if (!$scores_db["$tll_r"]["$ri[userid]"] AND !$scores_db["$tll_r"]["$ri2[userid]"])
						{
							$tmnt['current_round'] = min(1,$tmnt['current_round']);
						}
						$ru++;
					}
					continue;
				}
				if ($tll_r > $tmnt['current_round'])
				{
					$results .= '<div style="padding: 10px;">Round not started yet</a></div>';
					$tmnt['knockout_started'] = false;
				}
				else
				{
					$tll_array1 = $vbulletin->db->query_read("
						SELECT r.*
						".(!$team ? ", u.username AS u, u2.username AS u2" :
						", u.teamname AS u, u2.teamname AS u2")."
						FROM " . TABLE_PREFIX . "tmnt_result AS r
						LEFT JOIN " . TABLE_PREFIX . (!$team ? "user" :"tmnt_teams")." AS u
							ON (r.userid = u.".($team?"team":"user")."id)
						LEFT JOIN " . TABLE_PREFIX . (!$team ? "user" :"tmnt_teams")." AS u2
							ON (r.opp_userid = u2.".($team?"team":"user")."id)
						WHERE r.tid = '$tid' AND r.round = '$tll_r'
					");
					if ($vbulletin->db->num_rows($tll_array1)==0)
					{
						print_r(check_ready_next_round_swiss($tid, $tll_r));
						//print_r('go!');
						$results .= '<div style="padding: 10px;">Round not started yet</a></div>';
						$tmnt['current_round'] = min($tll_r,$tmnt['current_round']);
						$tmnt['knockout_started'] = false;
					}
					else
					{
						while ($t1a = $vbulletin->db->fetch_array($tll_array1))
						{
							/*if ($t1b)
							{*/
							$t1a1 = array(
								'userid' => $t1a['userid'],
								'username' => $t1a['u'],
							);
							$t1a2 = array(
								'userid' => $t1a['opp_userid'],
								'username' => $t1a['u2'],
							);
							if ($tmntp['canedittmnt'])
							{
								$editlink = 'tournaments.php?do=submitresult&amp;admin=1&amp;tid='.$tid.'&amp;round='.$ru.'&amp;userid=';
							}
							$results .= '<div style="margin-right: 15px; float: left; text-align: center;">'.tll_frame_s($t1a1, $t1a2, $scores_db["$tll_r"]["$t1a[userid]"], $scores_db["$tll_r"]["$t1a[opp_userid]"], $editlink).'</div>';
								//$tlb = '';
							/*}
							else
							{
								$t1b = $t1a;
							}"*/
							if (!$scores_db["$tll_r"]["$t1a[userid]"] AND !$scores_db["$tll_r"]["$t1a[opp_userid]"])
							{
								$tmnt['current_round'] = min($tll_r,$tmnt['current_round']);
								$tmnt['knockout_started'] = false;
								//print_r('fail'.$tll_r.'.'.$ri[userid]);
							}
						}
					}
				}
				$results .= '</div>';
			}
			$a = array();
			//print_r($rounduserinfo);
			foreach ($scores_db AS $tll_r => $tlar)
			{
				$z2 = '';
				foreach ($tlar AS $a_u => $a_s)
				{
					$z1 = $a_u;
					if ($z2)
					{
						$a["$z1"]['userid'] = $z1;
						$a["$z2"]['userid'] = $z2;
						$a["$z1"]['score'] += ($tlar[$z1] > $tlar[$z2] ? $tmnt['points_win'] : $tmnt['points_lose']);
						$a["$z2"]['score'] += ($tlar[$z2] > $tlar[$z1] ? $tmnt['points_win'] : $tmnt['points_lose']);
						$a["$z1"]['pd'] += $tlar[$z1] - $tlar[$z2];
						$a["$z2"]['pd'] += $tlar[$z2] - $tlar[$z1];
						$z2 = '';
					}
					else
					{
						$z2 = $a_u;
					}
				}
			}
			//print_r($a);
			if ($a && $tmnt['current_round'] > 1)
			{
			require_once("includes/class_tll_sort.php"); 
			$srt = new arr_multisort(); 
				$srt->setArray($a); 
				$srt->sort(); 
				$srt->addColumn("score",SRT_DESC); 
				$srt->addColumn("pd",SRT_DESC); 
			$a = $srt->sort();
			//print_r($a);
			//print_r($rounduserinfo['11']);
			$results .= '<h2 class="blockhead" style="height: 2px; overflow: hidden; margin: 0px; padding: 0px; margin-top: 15px; clear: both;">&nbsp;</h2><div><div class="blockbody formcontrols" style="border-bottom: none;"><div class="blocksubhead" style="clear: both;">Rankings</div></div>';
			$results .= '<table style="width: 100%;" class="formcontrols blockbody" style="display: table;">';
			$results .= '<tr>';
			$results .= '<td class="blocksubhead" style="display: table-cell;">Participant</td>';
			$results .= '<td class="blocksubhead" style="display: table-cell;">Score</td>';
			$results .= '<td class="blocksubhead" style="display: table-cell;">PD</td>';
			$results .= '</tr>';
			$ko_userids = array();//top X players
			foreach ($a AS $arn => $ar)
			{
				$results .= '<tr>';
				$results .= '<td class="blockrow" style="display: table-cell;">'.$pinfo["$ar[userid]"]['username'].'</td>';
				$results .= '<td class="blockrow" style="display: table-cell;">'.$ar['score'].'</td>';
				$results .= '<td class="blockrow" style="display: table-cell;">'.$ar['pd'].'</td>';
				$results .= '</tr>';
				if ($arn < $tmnt['knockout_places'])
				{
					$ko_userids[] = $ar[userid];
				}
			}
			$results .= '</table></div>';
			if (count($rounduserinfo['11']) < $tmnt['knockout_places'] && $tmnt['knockout_started'])
			{
				//print_r("empty");
				$ko1 = 1;
				foreach ($ko_userids AS $kop)
				{
					//$rounduserinfo['11']['slot']["$kop"];
					if ($ko1 > $tmnt['knockout_places'])
					{
						$ko1 = 2;
					}
					$rounduserinfo['11']["$ko1"] = $pinfo["$kop"];
					//print_r($ko1);
					$ko1 += 2;
				}
				$tmnt['type2'] = $vbphrase['tmnt_1v1'];
				$results .= '<p style="padding: 10px 4px; font-weight: bold;">Top '.$tmnt['knockout_places'].' Players Knockout</p>';
			}
			}
		}
		//print_r("round=".$tmnt['current_round']);
		//print_r($tmnt);
		///print_r($ko_userids);
		//dominic
	}
	if (in_array($vbphrase['tmnt_1v1'], array($type, $tmnt['type2'])))
	{
		if ($tmnt['type2'])
		{
			$rounds = ceil(log($tmnt['knockout_places'], 2))+1;
			$tmnt['noplayers'] = $tmnt['knockout_places'];
			$rounduserinfo['1'] = $rounduserinfo['11'];
			$rounduserinfo['2'] = $rounduserinfo['12'];
			$rounduserinfo['3'] = $rounduserinfo['13'];
			$rounduserinfo['4'] = $rounduserinfo['14'];
			$scores_db['1'] = $scores_db['11'];
			$scores_db['2'] = $scores_db['12'];
			$scores_db['3'] = $scores_db['13'];
			$scores_db['4'] = $scores_db['14'];
		}
		else
		{
			$rounds = ceil(log($tmnt['noplayers'], 2))+1;
		}
		foreach ($rounduserinfo AS $round => $slot)
		{
			if (is_array($rounduserinfo["$round"]))
			{
			foreach ($rounduserinfo["$round"] AS $slot => $userinfo)
			{
				if ($userinfo['username'])
				{
					if ($userinfo['username'] == 'Bye' && $userinfo['userid'] == 0)
					{
						$rounduserinfo["$round"]["$slot"]['userurl'] .= $vbphrase['tmnt_bye_player'];
					}
					else
					{
						$rounduserinfo["$round"]["$slot"]['userurl'] .= tll_userhtml($userinfo, $team);
					}
					$plusround = $round + 1;
					$minusround = $round - 1;
					if ($slot&1)
					{
						$ss = $slot + 1;
						$xx = $slot + 1;
					}
					else
					{
						$ss = $slot - 1;
						$xx = $slot;
					}
					$p = $xx / 2;
						$plus_username = $rounduserinfo["$plusround"]["$p"]['username'];
						$plus_userinfo = $rounduserinfo["$plusround"]["$p"];
					if ($tmntp['canedittmnt'] AND $tmnt['status'] != $vbphrase['tmnt_finished'] AND $userinfo['userid'] > 0)
					{
						$show['progresslink'] = true;
						if ($minusround && !$plus_username)
						{
							$rounduserinfo["$round"]["$slot"]['userurl'] .= tll_frame_y_startdiv('L', "<a href=\"javascript:regress('$tmnt[id]', '$userinfo[userid]', '$userinfo[username]', 'round$round');\" style=\"color: #FFFFFF;\" title=\"$vbphrase[tmnt_regress_prev_round]\" class=\"tooltip\">X</a></div>", "15");
							//<img src=\"" . vB_Template_Runtime::fetchStyleVar('imgdir_misc') . "/colorpicker_close.gif\" alt=\"$vbphrase[tmnt_regress]\" class=\"inlineimg\" border=\"0\" />
							//position: absolute; top: 0px; right: 15px; padding-top: 6px; padding-right: 2px;
						}
						if (!$plus_username)
						{
							$rounduserinfo["$round"]["$slot"]['progressfinish'] .= tll_frame_y_startdiv('W', "<a href=\"javascript:progressfinish('$tmnt[id]', '$userinfo[userid]', '$userinfo[username]', 'round$plusround', '$p');\" style=\"color: #FFFFFF;\" title=\"$vbphrase[tmnt_progress_next_round]\" class=\"tooltipleft\">&gt;</a></div>");
							//<img src=\"" . vB_Template_Runtime::fetchStyleVar('imgdir_button') . "/viewpost.gif\" alt=\"$vbphrase[tmnt_progress_next_round]\" title=\"$vbphrase[tmnt_progress_next_round]\" class=\"inlineimg\" border=\"0\" />
							$rounduserinfo["$round"]["$slot"]['progress'] .= tll_frame_y_startdiv('W', " <a href=\"javascript:progress('$tmnt[id]', '$userinfo[userid]', '$userinfo[username]', 'round$plusround', '$p'");
							if ($show['loserplacement'])
							{
								$rounduserinfo["$round"]["$slot"]['progress'] .= ", '$loseruserid', '$loserslot'" . ($loserround ? ", '$loserround'" : "");
							}
							$rounduserinfo["$round"]["$slot"]['progress'] .= ");\" style=\"color: #FFFFFF;\" title=\"$vbphrase[tmnt_progress_next_round]\" class=\"tooltipleft\">&gt;</a></div>";
							//style=\"position: absolute; top: 0px; right: 0px; padding-top: 5px; padding-right: 2px;\"
							//style=\"position: absolute; top: 0px; right: 0px; padding-top: 5px; padding-right: 2px;\"
							//<img src=\"" . vB_Template_Runtime::fetchStyleVar('imgdir_button') . "/viewpost.gif\" alt=\"$vbphrase[tmnt_progress_next_round]\" class=\"inlineimg\" border=\"0\" />
						}
						if ($round == $rounds - 1)
						{
							$rounduserinfo["$round"]["$slot"]['userurl'] = $rounduserinfo["$round"]["$slot"]['progressfinish'] . $rounduserinfo["$round"]["$slot"]['userurl'];
						}
						else
						{
							$rounduserinfo["$round"]["$slot"]['userurl'] = $rounduserinfo["$round"]["$slot"]['progress'] . $rounduserinfo["$round"]["$slot"]['userurl'];
						}
					}
					$tll_framestart3 = '<div style="font-weight: bold; position: absolute; right: 0px; top: 0px; width: 15px; text-align: center;">';
					if ($plus_username && $plus_username == $userinfo['username'])
					{
						$rounduserinfo["$round"]["$slot"]['userurl'] .= tll_frame_y('W', $scores_db["$round"]["$userinfo[userid]"]);
						/*if ()
						{
							$rounduserinfo["$round"]["$slot"]['userurl'] .= $tll_framestart3.' '.$scores_db["$round"]["$userinfo[userid]"].' </div>';
						}
						else
						{
							$rounduserinfo["$round"]["$slot"]['userurl'] .= $tll_framestart3.' W </div>';
						}*/
					}
					elseif ($plus_username)
					{
						$loseruserid = $rounduserinfo["$round"]["$ss"]['userid'];
						$rounduserinfo["$round"]["$slot"]['userurl'] .= tll_frame_y('L', $scores_db["$round"]["$userinfo[userid]"], $scores_db["$round"]["$loseruserid"]);
						/*if ($scores_db["$round"]["$userinfo[userid]"] || $scores_db["$round"]["$loseruserid"])
						{
							$rounduserinfo["$round"]["$slot"]['userurl'] .= $tll_framestart3.' '.$scores_db["$round"]["$userinfo[userid]"].' </div>';
						}
						else
						{
							$rounduserinfo["$round"]["$slot"]['userurl'] .= $tll_framestart3.' L </div>';
						}*/
					}
				}
				else
				{
					$rounduserinfo["$round"]["$slot"]['userurl'] .= " &nbsp; &nbsp; &nbsp; &nbsp; ";
				}
				$rounduserinfo["$round"]["$slot"]['userurl'] = '<div id="bracket_round' . $round . "_slot" . $slot . '" style="position: relative;">' . $rounduserinfo["$round"]["$slot"]['userurl'] . "</div>";
			}
			}
		}
		if (!$team && $pinfo["$thisuserid"] && $tmnt['status'] == $vbphrase['tmnt_inprogress'])
		{
			for ($i = $rounds; $i >= 1; $i--)
			{
				if (!$pinfo["$thisuserid"]['round'.$i])
				{
					continue;
				}
				else
				{
					$th_slot = $pinfo["$thisuserid"]['round'.$i];
					if ($th_slot % 2)
					{
						$op_slot = $th_slot + 1;
					}
					else
					{
						$op_slot = $th_slot - 1;
					}
					$op_userinfo = $rounduserinfo["$i"]["$op_slot"];
					$pp_slot = ceil($th_slot / 2);
					$ip = $i + 1;
					$pp = $rounduserinfo["$ip"]["$pp_slot"];
					if ($pp['userid'])
					{
						break;
					}
					$tmnt['nextinfo'] = array(
						'round' => $i,
						'userid' => $op_userinfo['userid'],
						'username' => $op_userinfo['username'],
					);
					break;
				}
			}
		}
		$headinclude .= '<script type="text/javascript" src="clientscript/jquery/jquery-1.8.3.min.js"></script>'."\n";
		$headinclude .= '<script type="text/javascript" src="clientscript/javascript_tll_brackets.js"></script>'."\n";
		//print_r($rounduserinfo);
		if ($_REQUEST['alt'] || IS_MOBILE_STYLE)
		{
			$brackets = tll_tmnt_brackets_alt($tmnt['noplayers'], $rounduserinfo, '1v1');
		}
		else
		{
			$brackets = tll_create_tmnt_brackets($tmnt['noplayers'], $rounduserinfo);
		}		
		$results .= $brackets;
	}
	if ($type == $vbphrase['tmnt_de'] && $players == 16)
	{
		//$rounds = ceil(log($tmnt['noplayers'], 2))+1;
		$rounds = 7;
		//print_r($rounds);
		//print_r($rounduserinfo);
		//print_r("Go!");
		$show['loserplacement'] = true;
		foreach ($rounduserinfo AS $round => $slot)
		{
			foreach ($rounduserinfo["$round"] AS $slot => $userinfo)
			{
				$loserround = $round;
				if ($slot % 2)
				{
					$loserslot = $slot + 1;
					$loseruserid = $rounduserinfo["$round"]["$loserslot"]['userid'];
					
				}
				else
				{
					$loserslot = $slot - 1;
					$loseruserid = $rounduserinfo["$round"]["$loserslot"]['userid'];
				}
				//print_r(" $loseruserid ");
				$plusround = $round + 1;
				$p = ceil($slot/2);
				$plus_username = $rounduserinfo["$plusround"]["$p"]['username'];
				//print_r($plus_username);
				$plus_userinfo = $rounduserinfo["$plusround"]["$p"];
				if ($round == 1)
				{
					switch ($slot)
					{
						case 1: 
						case 2: 
							$l = 15;
							break;
						case 3: 
						case 4: 
							$l = 16;
							break;
						case 5: 
						case 6: 
							$l = 31;
							break;
						case 7: 
						case 8: 
							$l = 32;
							break;
						case 9: 
						case 10: 
							$l = 47;
							break;
						case 11: 
						case 12: 
							$l = 48;
							break;
						case 13: 
						case 14: 
							$l = 63;
							break;
						case 15: 
						case 16: 
							$l = 64;
							break;
					}
				}
				elseif ($round == 2)
				{
					$loserround = 2;//1
					switch ($slot)
					{
						case 1: 
						case 2: 
							$l = 7;//13
							break;
							//$l = 14;
							//break;
						case 3: 
						case 4: 
							$l = 15;//29
							break;
							//$l = 30;
							//break;
						case 5: 
						case 6: 
							$l = 23;//45
							break;
							//$l = 46;
							//break;
						case 7: 
						case 8: 
							$l = 31;//61
							break;
							//$l = 62;
							//break;
					}
				}
				elseif ($round == 3)
				{
					$loserround = 3;//1
					switch ($slot)
					{
						case 1: 
							//$l = 14;
							//break;
						case 2: 
							$l = 3;//30
							break;
						case 3: 
							//$l = 46;
							//break;
						case 4: 
							$l = 15;//62
							break;
					}
				}
				elseif ($round == 4)
				{
					$loserround = 4;//1
					switch ($slot)
					{
						case 1:
						case 2: 
							$l = 7;
							break;
					}
				}
				if ($userinfo['username'])
				{
					if ($userinfo['username'] == 'Bye' && !$userinfo['userid'])
					{
						$rounduserinfo["$round"]["$slot"]['userurl'] .= $vbphrase['tmnt_bye_player'];
					}
					else
					{
						$rounduserinfo["$round"]["$slot"]['userurl'] .= tll_userhtml($userinfo, $team);
					}
				}
				
				if (!$plus_username && $userinfo['username'] && $round < 5)
				{
					//$rounduserinfo["$round"]["$slot"]['progressfinish'] .= tll_frame_y_startdiv('W', "<a href=\"javascript:progressfinish('$tmnt[id]', '$userinfo[userid]', '$userinfo[username]', 'round$plusround', '$p');\" style=\"color: #FFFFFF;\" title=\"$vbphrase[tmnt_progress_next_round]\" class=\"tooltipleft\">&gt;</a></div>");
					$rounduserinfo["$round"]["$slot"]['progress'] .= tll_frame_y_startdiv('W', " <a href=\"javascript:progress('$tmnt[id]', '$userinfo[userid]', '$userinfo[username]', 'round$plusround', '$p'");
					if ($show['loserplacement'])
					{
						$rounduserinfo["$round"]["$slot"]['progress'] .= ", '$loseruserid', '$l'" . ($loserround ? ", '$loserround'" : "");
					}
					$rounduserinfo["$round"]["$slot"]['progress'] .= ");\" style=\"color: #FFFFFF;\" title=\"$vbphrase[tmnt_progress_next_round]\" class=\"tooltipleft\">&gt;</a></div>";
					//dominic
				}
				elseif (!$plus_username && $round == 5 && $rounduserinfo["$round"]["$slot"])
				{
					$rounduserinfo["$round"]["$slot"]['progress'] .= tll_frame_y_startdiv('W', " <a href=\"javascript:progressfinish('$tmnt[id]', '$userinfo[userid]', '$userinfo[username]', 'round$plusround', '$p'");
					$rounduserinfo["$round"]["$slot"]['progress'] .= ");\" style=\"color: #FFFFFF;\" title=\"$vbphrase[tmnt_progress_next_round]\" class=\"tooltipleft\">&gt;</a></div>";
				}
				if ($rounduserinfo["$round"]["$slot"]['loser_rounds'] && !is_array($rounduserinfo["$round"]["$slot"]['loser_rounds']))
				{
					$rounduserinfo["$round"]["$slot"]['loser_rounds'] = unserialize($rounduserinfo["$round"]["$slot"]['loser_rounds']);
					foreach ($rounduserinfo["$round"]["$slot"]['loser_rounds'] AS $lr => $lv)
					{
						$lr = substr($lr,10);
						//print_r("..".$lv);
						$loserrounduserinfo["$lr"]["$lv"] = $rounduserinfo["$round"]["$slot"];
					}
					
					//print_r($rounduserinfo["$round"]["$slot"]['loser_rounds']);
					
				}
				$rounduserinfo["$round"]["$slot"]['userurl'] = '<div id="bracket_round' . $round . "_slot" . $slot . '" style="position: relative;">' . $rounduserinfo["$round"]["$slot"]['progress'] . $rounduserinfo["$round"]["$slot"]['userurl'] . "</div>";
				//print_r();
			}
		}
		$show['loserplacement'] = false;
		if ($loserrounduserinfo)
		{
		foreach ($loserrounduserinfo AS $round => $slot)
		{
			foreach ($loserrounduserinfo["$round"] AS $slot => $userinfo)
			{
				$loserround = $round;
				if ($slot % 2)
				{
					$loserslot = $slot + 1;
					$loseruserid = $loserrounduserinfo["$round"]["$loserslot"]['userid'];
					
				}
				else
				{
					$loserslot = $slot - 1;
					$loseruserid = $loserrounduserinfo["$round"]["$loserslot"]['userid'];
				}
				$plusround = $round + 1;
				$p = ceil($slot/2);
				$plus_username = $loserrounduserinfo["$plusround"]["$p"]['username'];
				$plus_userinfo = $loserrounduserinfo["$plusround"]["$p"];
				if (!$plus_username && $userinfo['username'] && $round != 7)
				{
					$loserrounduserinfo["$round"]["$slot"]['progress'] .= tll_frame_y_startdiv('W', " <a href=\"javascript:loserprogress('$tmnt[id]', '$userinfo[userid]', '$userinfo[username]', 'loserround$plusround', '$p'");
					$loserrounduserinfo["$round"]["$slot"]['progress'] .= ");\" style=\"color: #FFFFFF;\" title=\"$vbphrase[tmnt_progress_next_round]\" class=\"tooltipleft\">&gt;</a></div>";
				}
				$loserrounduserinfo["$round"]["$slot"]['userurl'] = '<div id="loser_bracket_round' . $round . "_slot" . $slot . '" style="position: relative;">' . $loserrounduserinfo["$round"]["$slot"]['progress'] . $loserrounduserinfo["$round"]["$slot"]['userurl'] . "</div>";
				
			}
		}
		}
		$brackets = tll_create_tmnt_brackets(16, $rounduserinfo, 0, 1);//
		$skiparray = array(
			'r1_s1' => 1, 'r1_s2' => 1, 'r1_s3' => 1, 'r1_s4' => 1, 'r1_s5' => 1, 'r1_s6' => 1, 'r1_s7' => 1, 'r1_s8' => 1, 'r1_s9' => 1, 'r1_s10' => 1, 'r1_s11' => 1, 'r1_s12' => 1, 'r1_s13' => 1, 'r1_s14' => 1,
			'r2_s1' => 1, 'r2_s2' => 1, 'r2_s3' => 1, 'r2_s4' => 1, 'r2_s5' => 1, 'r2_s6' => 1,
			'r3_s1' => 1, 'r3_s2' => 1,
			'r1_s17' => 1, 'r1_s18' => 1, 'r1_s19' => 1, 'r1_s20' => 1, 'r1_s21' => 1, 'r1_s22' => 1, 'r1_s23' => 1, 'r1_s24' => 1, 'r1_s25' => 1, 'r1_s26' => 1, 'r1_s27' => 1, 'r1_s28' => 1, 'r1_s29' => 1, 'r1_s30' => 1,
			'r2_s9' => 1, 'r2_s10' => 1, 'r2_s11' => 1, 'r2_s12' => 1, 'r2_s13' => 1, 'r2_s14' => 1,
			'r3_s5' => 1, 'r3_s6' => 1,
			'r1_s33' => 1, 'r1_s34' => 1, 'r1_s35' => 1, 'r1_s36' => 1, 'r1_s37' => 1, 'r1_s38' => 1, 'r1_s39' => 1, 'r1_s40' => 1, 'r1_s41' => 1, 'r1_s42' => 1, 'r1_s43' => 1, 'r1_s44' => 1, 'r1_s45' => 1, 'r1_s46' => 1,
			'r2_s17' => 1, 'r2_s18' => 1, 'r2_s19' => 1, 'r2_s20' => 1, 'r2_s21' => 1, 'r2_s22' => 1, 
			'r2_s25' => 1, 'r2_s26' => 1, 'r2_s27' => 1, 'r2_s28' => 1, 'r2_s29' => 1, 'r2_s30' => 1, 
			'r1_s49' => 1, 'r1_s50' => 1, 'r1_s51' => 1, 'r1_s52' => 1, 'r1_s53' => 1, 'r1_s54' => 1, 'r1_s55' => 1, 'r1_s56' => 1, 'r1_s57' => 1, 'r1_s58' => 1, 'r1_s59' => 1, 'r1_s60' => 1, 'r1_s61' => 1, 'r1_s62' => 1,
			'r3_s9' => 1, 'r3_s10' => 1,
			'r3_s13' => 1, 'r3_s14' => 1,
		);
		$loserrounduserinfo["4"]["1"]['userurl'] .= $vbphrase['tmnt_bye_player'];
		$loserrounduserinfo["4"]["3"]['userurl'] .= $vbphrase['tmnt_bye_player'];
		$loserrounduserinfo["4"]["5"]['userurl'] .= $vbphrase['tmnt_bye_player'];
		$loserrounduserinfo["3"]["7"]['userurl'] .= $vbphrase['tmnt_bye_player'];
		$loserrounduserinfo["3"]["11"]['userurl'] .= $vbphrase['tmnt_bye_player'];
		$loserbrackets = tll_create_tmnt_brackets(64, $loserrounduserinfo, 0, 0, $skiparray, 1);
		$results = $brackets.$loserbrackets;
	}
	if ($type == $vbphrase['tmnt_de'] && $players == 8)
	{
		$rounds = ceil(log($tmnt['noplayers'], 2))+1;
		foreach ($rounduserinfo AS $round => $slot)
		{
			foreach ($rounduserinfo["$round"] AS $slot => $userinfo)
			{
				$loserround = 0;
				if ($userinfo['username'])
				{
					if ($userinfo['username'] == 'Bye' && $userinfo['userid'] == 0)
					{
						$rounduserinfo["$round"]["$slot"]['userurl'] .= $vbphrase['tmnt_bye_player'];
					}
					else
					{
						$rounduserinfo["$round"]["$slot"]['userurl'] .= tll_userhtml($userinfo, $team);
					}		
					$plusround = $round + 1;
					$minusround = $round - 1;
					if ($slot&1)
					{
						$ss = $slot + 1;
						$xx = $slot + 1;
					}
					else
					{
						$ss = $slot - 1;
						$xx = $slot;
					}
					$p = $xx / 2;
					$loserslot = (($p*2) + $players)/2;
					$loseruserid = $rounduserinfo["$round"]["$ss"]['userid'];
					
						$show['loserplacement'] = true;
						$loserround = 0;
						if ($round == 1)
						{
							switch ($slot)
							{
								case 1:
								case 2:
									$loserslot = 9;
								break;
								case 3:
								case 4:
									$loserslot = 10;
								break;
								case 5:
								case 6:
									$loserslot = 11;
								break;
								case 7:
								case 8:
									$loserslot = 12;
								break;
							}
						}
						else if ($round == 2)
						{
							switch ($slot)
							{
								case 1:
								case 2:
									$p = 1;
									$loserslot = 5;
								break;
								case 3:
								case 4:
									$p = 2;
									$loserslot = 7;
								break;
								case 9:
								case 10:
									$p = 6;
									$loserslot = 0;
									$show['loserplacement'] = false;
								break;
								case 11:
								case 12:
									$p = 8;
									$loserslot = 0;
									$show['loserplacement'] = false;
								break;
							}
						}
						elseif ($round == 3)
						{
							switch ($slot)
							{
								case 1:
								case 2:
									$p = 1;
									$loserslot = 2;
									$loserround = "round5";//dom
								break;
								case 5:
								case 6:
									$p = 3;
									$loserslot = 0;
									$show['loserplacement'] = false;
								break;
								case 7:
								case 8:
									$p = 4;
									$loserslot = 0;
									$show['loserplacement'] = false;
								break;
							}
						}
						elseif ($round == 4)
						{
							switch ($slot)
							{
								case 1:
									$p = 1;
									$loserslot = 0;
									$plusround = 7;
									$show['loserplacement'] = false;
								break;
								case 3:
								case 4:
									$p = 3;
									$loserslot = 0;
									$show['loserplacement'] = false;
								break;
							}
						}
						elseif ($round == 5)
						{
							switch ($slot)
							{
								case 2:
								case 3:
									$p = 1;
									$loserslot = 0;
									$show['loserplacement'] = false;
								break;
							}
						}
						elseif ($round == 6)
						{
							switch ($slot)
							{
								case 1:
									$p = 1;
									$loserslot = 2;
									$loseruserid = $rounduserinfo["4"]["1"]['userid'];
								break;
							}
						}
						$plus_username = $rounduserinfo["$plusround"]["$p"]['username'];
						$plus_userinfo = $rounduserinfo["$plusround"]["$p"];
					if ($tmntp['canedittmnt'] AND $tmnt['status'] != $vbphrase['tmnt_finished'] AND $userinfo['userid'] != 0)
					{
						$show['progresslink'] = true;
						if ($minusround && !$plus_username)
						{
							//dominic
							//$rounduserinfo["$round"]["$slot"]['userurl'] .= " <a href=\"javascript:regress('$tmnt[id]', '$userinfo[userid]', '$userinfo[username]', '$vbphrase[minusround]');\"><img src=\"" . vB_Template_Runtime::fetchStyleVar('imgdir_misc') . "/colorpicker_close.gif\" alt=\"\" title=\"$vbphrase[tmnt_regress_prev_round]\" class=\"inlineimg tooltip\" border=\"0\" /></a>";
							$rounduserinfo["$round"]["$slot"]['userurl'] .= tll_frame_y_startdiv('L', "<a href=\"javascript:regress('$tmnt[id]', '$userinfo[userid]', '$userinfo[username]', 'round$round');\" title=\"$vbphrase[tmnt_regress_prev_round]\" style=\"color:#FFF;\" class=\"tooltip\">X</a></div>", "15");
						}
						if (!$plus_username)
						{
							$rounduserinfo["$round"]["$slot"]['progressfinish'] .= tll_frame_y_startdiv('W', " <a href=\"javascript:progressfinish('$tmnt[id]', '$userinfo[userid]', '$userinfo[username]', 'round$plusround', '$p');\" style=\"color: #FFF;\" title=\"$vbphrase[tmnt_progress_next_round]\" class=\"tooltipleft\">&gt;</div>");
							//float:right; padding-top: 5px; padding-right: 2px;
							//<img src=\"" . vB_Template_Runtime::fetchStyleVar('imgdir_button') . "/viewpost.gif\" alt=\"$vbphrase[tmnt_progress_next_round]\" class=\"inlineimg\" border=\"0\" /></a>
							$rounduserinfo["$round"]["$slot"]['progress'] .= tll_frame_y_startdiv('W', "<a href=\"javascript:progress('$tmnt[id]', '$userinfo[userid]', '$userinfo[username]', 'round$plusround', '$p'");
							if ($show['loserplacement'])
							{
								$rounduserinfo["$round"]["$slot"]['progress'] .= ", '$loseruserid', '$loserslot'" . ($loserround ? ", '$loserround'" : "");
							}
							$rounduserinfo["$round"]["$slot"]['progress'] .= ");\" style=\"color: #FFF;\" title=\"$vbphrase[tmnt_progress_next_round]\" class=\"tooltipleft\">&gt;</a></div>";
							//float:right; padding-top: 5px; padding-right: 2px;
							//<img src=\"" . vB_Template_Runtime::fetchStyleVar('imgdir_button') . "/viewpost.gif\" alt=\"$vbphrase[tmnt_progress_next_round]\" class=\"inlineimg\" border=\"0\" />							
						}
						
					}
					if ($plus_username && $plus_username == $userinfo['username'])
					{
						$rounduserinfo["$round"]["$slot"]['userurl'] .= tll_frame_y('W', $scores_db["$round"]["$userinfo[userid]"]);
					}
					elseif ($plus_username)
					{
						$loseruserid = $rounduserinfo["$round"]["$ss"]['userid'];
						$rounduserinfo["$round"]["$slot"]['userurl'] .= tll_frame_y('L', $scores_db["$round"]["$userinfo[userid]"], $scores_db["$round"]["$loseruserid"]);
					}
					if (($slot == 1 && $round == 4) OR ($round == 7))
					{
						$rounduserinfo["$round"]["$slot"]['userurl'] = $rounduserinfo["$round"]["$slot"]['progressfinish'].$rounduserinfo["$round"]["$slot"]['userurl'];
					}
					else
					{
						$rounduserinfo["$round"]["$slot"]['userurl'] = $rounduserinfo["$round"]["$slot"]['progress'].$rounduserinfo["$round"]["$slot"]['userurl'];
					}
				}
				else
				{
					$rounduserinfo["$round"]["$slot"]['userurl'] .= " &nbsp; &nbsp; &nbsp; &nbsp; ";
				}
				$rounduserinfo["$round"]["$slot"]['userurl'] = '<span id="bracket_round' . $round . "_slot" . $slot . '">' . $rounduserinfo["$round"]["$slot"]['userurl'] . "</span>";			
			}
		}
		require_once(DIR . '/includes/functions_tll_brackets.php');
		$headinclude .= '<script type="text/javascript" src="clientscript/jquery/jquery-1.8.3.min.js"></script>'."\n";
		$headinclude .= '<script type="text/javascript" src="clientscript/javascript_tll_brackets.js"></script>'."\n";
		if ($_REQUEST['alt'] || IS_MOBILE_STYLE)
		{
			$brackets = tll_tmnt_brackets_alt($tmnt['noplayers'], $rounduserinfo, 'de', $tmnt['show_round8']);
		}
		else
		{
			$brackets = tll_create_tmnt_brackets($tmnt['noplayers'], $rounduserinfo, 1, $tmnt['show_round8']);
		}
		$results = $brackets;
		if ($tmnt['status'] == $vbphrase['tmnt_finished'])
		{
			$dom = $rounds + 2;
			$tmnt['winners'] = array();
			$domi = 1;
			if ($rounduserinfo["$rounds"]['1']['username'])
			{
				$tmnt['winners']['1'] = $rounduserinfo["$rounds"]['1']['username'];
				$domi = 2;
			}
			while ($dom > 1)
			{
				foreach ($rounduserinfo["$dom"] AS $a => $b)
				{
					if ($b['username'] && !in_array($b['username'], $tmnt['winners']) && $a > 0)
					{
						$tmnt['winners'][$domi] = $b['username'];
						$domi++;
					}
				}
				if (count($tmnt['winners'])==3)
				{
					break;
				}
				$dom--;
			}
		}
	}
	elseif ($players == 4 && $type == $vbphrase['tmnt_de'])
	{
		$rounds = ceil(log($tmnt['noplayers'], 2))+1;
		foreach ($rounduserinfo AS $round => $slot)
		{
			foreach ($rounduserinfo["$round"] AS $slot => $userinfo)
			{
				$loserround = 0;
				if ($userinfo['username'])
				{
					if ($userinfo['username'] == 'Bye' && $userinfo['userid'] == 0)
					{
						$rounduserinfo["$round"]["$slot"]['userurl'] .= $vbphrase['tmnt_bye_player'];
					}
					else
					{
						$rounduserinfo["$round"]["$slot"]['userurl'] .= tll_userhtml($userinfo, $team);
					}		
					$plusround = $round + 1;
					$minusround = $round - 1;
					if ($slot&1)
					{
						$ss = $slot + 1;
						$xx = $slot + 1;
					}
					else
					{
						$ss = $slot - 1;
						$xx = $slot;
					}
					$p = $xx / 2;
					$loserslot = (($p*2) + $players)/2;
					$loseruserid = $rounduserinfo["$round"]["$ss"]['userid'];
						
						$show['loserplacement'] = true;
						$loserround = 0;
						if ($round == 1)
						{
							switch ($slot)
							{
								case 1:
								case 2:
									$loserslot = 5;
								break;
								case 3:
								case 4:
									$loserslot = 6;
								break;
							}
						}
						else if ($round == 2)
						{
							switch ($slot)
							{
								case 1:
								case 2:
									$p = 1;
									$loserslot = 3;
								break;
								case 5:
								case 6:
									$p = 4;
									$loserslot = 0;
									$show['loserplacement'] = false;
								break;
							}
						}
						elseif ($round == 3)
						{
							switch ($slot)
							{
								case 1:
								case 2:
									$p = 1;
									$loserslot = 2;
									$plusround = 5;
								break;
								case 3:
								case 4:
									$p = 2;
									$loserslot = 0;
									$show['loserplacement'] = false;
								break;
							}
						}
						elseif ($round == 4)
						{
							switch ($slot)
							{
								case 2:
									$p = 1;
									$loserslot = 2;
									$loseruserid = $rounduserinfo["3"]["1"]['userid'];
								break;
							}
						}
						elseif ($round == 5)
						{
							switch ($slot)
							{
								case 1:
									$p = 1;
									$loserslot = 0;
									$show['loserplacement'] = false;
								break;
							}
						}
						$plus_username = $rounduserinfo["$plusround"]["$p"]['username'];
						$plus_userinfo = $rounduserinfo["$plusround"]["$p"];
					if ($tmntp['canedittmnt'] AND $tmnt['status'] != $vbphrase['tmnt_finished'] AND $userinfo['userid'] != 0)
					{
						$show['progresslink'] = true;
						if ($minusround && !$plus_username)
						{
							$rounduserinfo["$round"]["$slot"]['userurl'] .= tll_frame_y_startdiv('L', "<a href=\"javascript:regress('$tmnt[id]', '$userinfo[userid]', '$userinfo[username]', 'round$round');\" title=\"$vbphrase[tmnt_regress_prev_round]\" style=\"color:#FFF;\" class=\"tooltip\">X</a></div>", "15");
							//<img src=\"" . vB_Template_Runtime::fetchStyleVar('imgdir_misc') . "/colorpicker_close.gif\" alt=\"$vbphrase[tmnt_regress]\"  class=\"inlineimg\" border=\"0\" />
						}
						//dominic
						if (!$plus_username)
						{
							$rounduserinfo["$round"]["$slot"]['progressfinish'] .= tll_frame_y_startdiv('W', "<a href=\"javascript:progressfinish('$tmnt[id]', '$userinfo[userid]', '$userinfo[username]', 'round$plusround', '$p');\"  title=\"$vbphrase[tmnt_progress_next_round]\" style=\"color:#FFF;\">&gt;</a></div>");
							//style=\"float:right; padding-top: 5px; padding-right: 2px;\"
							//<img src=\"" . vB_Template_Runtime::fetchStyleVar('imgdir_button') . "/viewpost.gif\" alt=\"$vbphrase[tmnt_progress_next_round]\" class=\"inlineimg\" border=\"0\" />
							$rounduserinfo["$round"]["$slot"]['progress'] .= tll_frame_y_startdiv('W', "<a href=\"javascript:progress('$tmnt[id]', '$userinfo[userid]', '$userinfo[username]', 'round$plusround', '$p'");
							if ($show['loserplacement'])
							{
								$rounduserinfo["$round"]["$slot"]['progress'] .= ", '$loseruserid', '$loserslot'" . ($loserround ? ", '$loserround'" : "");
							}
							$rounduserinfo["$round"]["$slot"]['progress'] .= ");\" title=\"$vbphrase[tmnt_progress_next_round]\" style=\"color:#FFF;\">&gt;</a></div>";
							//<img src=\"" . vB_Template_Runtime::fetchStyleVar('imgdir_button') . "/viewpost.gif\" alt=\"$vbphrase[tmnt_progress_next_round]\"  class=\"inlineimg\" border=\"0\" />
							//style=\"float:right; padding-top: 5px; padding-right: 2px;\"
						}
					}
					if ($plus_username && $plus_username == $userinfo['username'])
					{
						$rounduserinfo["$round"]["$slot"]['userurl'] .= tll_frame_y('W', $scores_db["$round"]["$userinfo[userid]"]);
					}
					elseif ($plus_username)
					{
						$loseruserid = $rounduserinfo["$round"]["$ss"]['userid'];
						$rounduserinfo["$round"]["$slot"]['userurl'] .= tll_frame_y('L', $scores_db["$round"]["$userinfo[userid]"], $scores_db["$round"]["$loseruserid"]);
					}
					if (($slot == 1 && $round == 3) OR ($round == 5))
					{
						$rounduserinfo["$round"]["$slot"]['userurl'] = $rounduserinfo["$round"]["$slot"]['progressfinish'].$rounduserinfo["$round"]["$slot"]['userurl'];
					}
					else
					{
						$rounduserinfo["$round"]["$slot"]['userurl'] = $rounduserinfo["$round"]["$slot"]['progress'].$rounduserinfo["$round"]["$slot"]['userurl'];
					}
				}
				else
				{
					$rounduserinfo["$round"]["$slot"]['userurl'] .= " &nbsp; &nbsp; &nbsp; &nbsp; ";
				}
				$rounduserinfo["$round"]["$slot"]['userurl'] = '<div id="bracket_round' . $round . "_slot" . $slot . '">' . $rounduserinfo["$round"]["$slot"]['userurl'] . "</div>";
			}
		}
		require_once(DIR . '/includes/functions_tll_brackets.php');
		$headinclude .= '<script type="text/javascript" src="clientscript/jquery/jquery-1.8.3.min.js"></script>'."\n";
		$headinclude .= '<script type="text/javascript" src="clientscript/javascript_tll_brackets.js"></script>'."\n";
		if ($_REQUEST['alt'] || IS_MOBILE_STYLE)
		{
			$brackets = tll_tmnt_brackets_alt($tmnt['noplayers'], $rounduserinfo, 'de', $tmnt['show_round8']);
		}
		else
		{
			$brackets = tll_create_tmnt_brackets($tmnt['noplayers'], $rounduserinfo, 1, $tmnt['show_round8']);
		}
		$results = $brackets;
		if ($tmnt['status'] == $vbphrase['tmnt_finished'])
		{
			$dom = $rounds + 2;
			$tmnt['winners'] = array();
			$domi = 1;
			if ($rounduserinfo["$rounds"]['1']['username'])
			{
				$tmnt['winners']['1'] = $rounduserinfo["$rounds"]['1']['username'];
				$domi = 2;
			}
			while ($dom > 1)
			{
				foreach ($rounduserinfo["$dom"] AS $a => $b)
				{
					if ($b['username'] && !in_array($b['username'], $tmnt['winners']) && $a > 0)
					{
						$tmnt['winners'][$domi] = $b['username'];
						$domi++;
					}
				}
				if (count($tmnt['winners'])==3)
				{
					break;
				}
				$dom--;
			}
		}
	}
	if ($tmnt['type'] == $vbphrase['tmnt_groupplay'])
	{
		//$tmnt['noplayers'] = 64;
		$tmnt['pergroup'] = ceil(sqrt($tmnt['noplayers']));
		$tmnt['startinggroups'] = ceil($tmnt['noplayers'] / $tmnt['pergroup']);
		$tmnt['progressionrate'] = 0.5;//50%
		$s = $tmnt['noplayers'];
		$tmnt['rounds'] = 0;
		while ($s >= $tmnt['pergroup'])
		{
			$tmnt['rounds']++;
			//print_r($s);
			$s = $s * $tmnt['progressionrate'];
			//print_r($s);
		}
		/*if ($tmnt['noplayers']==36)
		{
			$tmnt['pergroup'] = 6;
			$tmnt['rounds']=3;
		}*/
		if ($tmnt['noplayers']==128)
		{
			$tmnt['pergroup'] = 8;
			$tmnt['rounds']=4;
		}
		require_once(DIR . '/includes/functions_tll_brackets.php');
		require_once(DIR . '/includes/functions_tll_groupplay.php');
		$brackets = tll_create_groupplay_brackets($tmnt, $rounduserinfo);
		//print_r($tmnt);
		//print_r($rounduserinfo);
		$results = $brackets;
	}
	if (in_array($tmnt['type'], array($vbphrase['tmnt_rr'], $vbphrase['tmnt_drr']))) //round robin rr or drr
	{
		//print_r($tmnt['groups']);
		$ca_pla = array();
		$tmnt = rr_get_rounds($tmnt);
		$blockrow = 'class="blockrow" style="display: table-cell; text-align: center;" nowrap="nowrap"';
		$blocksubhead = 'class="blocksubhead" style="text-align: center;"';
		if (in_array($tmnt['status'], array($vbphrase['tmnt_inprogress'],$vbphrase['tmnt_finished'])))
		{//build round robin table
			if ($tmnt['type'] == $vbphrase['tmnt_rr'])
			{
				$database = fetch_rr_database($tmnt['noplayers']/max(1,$tmnt['groups']));
			}
			else
			{
				$database = fetch_drr_database($tmnt['noplayers']);
			}
			$tmnt['rows'] = ceil($tmnt['noplayers']/2);
			$rows = array();
			$ri = 0;
			while ($ri <= $tmnt['rows'])
			{
				$rows["$ri"] = "<tr>";
				$ca_row["$ri"] = array();
				$ri++;
			}
			$ci = 1;
			while ($ci <= $tmnt['rounds'])
			{
				$rst = 0;
				if ($ci > 4)
				{
					$rst = floor(($ci-1)/4)*10;
				}
				/*if ($ci > 8)
				{
					$rst = 20;
				}
				if ($ci > 12)
				{
					$rst = 30;
				}
				if ($ci > 16)
				{
					$rst = 40;
				}*/
				if (in_array($ci, array(5,9,13,17,21,25,29,33,37,41)))
				{
					$rows["$rst"] = "<tr>";
				}
				$templater = vB_Template::create('tmnt_rr_headcell');
					$templater->register('tmntp', $tmntp);
					$templater->register('tmnt', $tmnt);
					$templater->register('blocksubhead', $blocksubhead);
					$templater->register('ci', $ci);
					$templater->register('rci', "round$ci");
					$templater->register('template_hook', $template_hook);
				$rows["$rst"] .= $templater->render();
				$ri = 1;
				while ($ri <= $tmnt['rows'])
				{
					$xdata = $database['r'.$ci][''.($ri-1).''];
					list($xx, $yy) = explode('v',$xdata);
					$xx = (int)$xx;
					$xx = $p_array["$xx"];
					$yy = (int)$yy;
					$yy = $p_array["$yy"];
					$plx = 'round'.$ci;
					if ($ci == 1)
					{
						$plx = 'round';
					}
					$rst = $ri;
					if ($ci > 4)
					{
						$rst += floor(($ci-1)/4)*10;
						//$rst += 10;
					}
					/*if ($ci > 8)
					{
						$rst += 10;
					}
					if ($ci > 12)
					{
						$rst += 10;
					}
					if ($ci > 16)
					{
						$rst += 10;//40
					}*/
					if (!$rows["$rst"])
					{
						$rows["$rst"] = "<tr>";
					}
					$templater = vB_Template::create('tmnt_rr_cell');
						$templater->register('tmntp', $tmntp);
						$templater->register('tmnt', $tmnt);
						$templater->register('blockrow', $blockrow);
						$templater->register('ci', $ci);
						$templater->register('ri', $ri);
						$templater->register('xx', $xx);
						$templater->register('yy', $yy);
						$templater->register('plx', $plx);
					$rows["$rst"] .= $templater->render();
					
					$ri++;
				}
				$ci++;
			}
			$ri = 0;
			while ($ri <= 35)
			{
				if ($rows["$ri"])
				{
					$rcount = substr_count($rows["$ri"], '</td>') - 4;
					while ($rcount < 0)
					{
						if ($ri == 10 || $ri == 20 || $ri == 30 || $ri == 40 || $ri == 50)
						{
							$rows["$ri"] .= "<td $blocksubhead>&nbsp;</td>";
						}
						else
						{
							$rows["$ri"] .= "<td $blockrow>&nbsp;</td>";
						}
						$rcount++;
					}
					$rows["$ri"] .= "</tr>";
				}
				$ri++;
			}
			foreach ($rows AS $rindex => $rvalue)
			{
				$bhtml .= $rvalue;
			}
			//foreach rows into table
			$tmnt['rr'] .= $bhtml;
			//fixtures for each team
			$test .= '<table class="blockbody formcontrols" style="width: 100%;"><tr><td class="blocksubhead">Name</td><td class="blocksubhead">Wins</td><td class="blocksubhead">Place</td>';
			for ($tc = 1; $tc <= $tmnt['rounds']; $tc++)
			{
				$test .= '<td class="blocksubhead">Round '.$tc.$template_hook["round$tc"].'</td>';
			}
			$test .= '</tr>';
			foreach ($p_array AS $playerid => $userinfo)
			{
				$bhtml = '';
				$bray = array();
				foreach ($database AS $r => $rvalue)
				{
					$r = substr($r, 1);
					$s = '';
					//array('02v01','03v08','04v07','05v06')
					foreach ($rvalue AS $nh => $ndata)
					{
						list($pla, $plb) = explode('v', $ndata);
						$pla = (int)$pla;
						$plb = (int)$plb;
						if ($pla == $playerid || $plb == $playerid)
						{
							$s = $plb;
							$plx = 'round'.$r;
							if ($r == 1)
							{
								$plx = 'round';
							}
							$p_array["$pla"]['pd'] += $p_array["$pla"]["$plx"]-$p_array["$plb"]["$plx"];
							$p_array["$plb"]['pd'] += $p_array["$plb"]["$plx"]-$p_array["$pla"]["$plx"];
							if ($p_array["$pla"]["$plx"] && $p_array["$pla"]["$plx"] > $p_array["$plb"]["$plx"])
							{
								$p_array["$pla"]['roundwins']++;
								$p_array["$plb"]['roundloses']++;
							}
							if ($p_array["$plb"]["$plx"] && $p_array["$plb"]["$plx"] > $p_array["$pla"]["$plx"])
							{
								$p_array["$plb"]['roundwins']++;
								$p_array["$pla"]['roundloses']++;
							}
							if ($p_array["$pla"]["$plx"] == $p_array["$plb"]["$plx"])
							{
								$p_array["$pla"]['rounddraws']++;
								$p_array["$plb"]['rounddraws']++;
							}
							if ($p_array["$pla"]['userid']==$userinfo['userid'])
							{
								$t1 = $p_array["$pla"];
								$t2 = $p_array["$plb"];
							}
							if ($p_array["$plb"]['userid']==$userinfo['userid'])
							{
								$t2 = $p_array["$pla"];
								$t1 = $p_array["$plb"];
							}
							
							$bray["$r"] = array(
								'r' => $r,
								'userinfo' => $userinfo,
								'pla' => $t1,
								'opp' => $t2,
								'result' => rr_scores_to_result($t1["$plx"],$t2["$plx"])
							);
							$templater = vB_Template::create('tmnt_ind_sched_bit');
								$templater->register('tmntp', $tmntp);
								$templater->register('tmnt', $tmnt);
								$templater->register('blockrow', $blockrow);
								$templater->register('r', $r);
								$templater->register('plx', $plx);
								$templater->register('usera', $p_array["$pla"]);
								$templater->register('userb', $p_array["$plb"]);
							$bhtml .= $templater->render();
							break;
						}
					}
				}
				if ($p_array["$playerid"]['userid']==0)
				{
					continue;
				}				
				$test .= '<tr><td class="blockrow" style="display: table-cell;">'.$userinfo[userhtml].'</td><td class="blockrow" style="display: table-cell;">'.number_format($p_array["$playerid"]['roundwins']/2).'</td><td class="blockrow" style="display: table-cell;">{place_'.$playerid.'}</td>';
				foreach ($bray AS $bi => $brow)
				{
					if ($brow['opp']['userid']==0)
					{
						$test .= '<td class="blockrow" style="display: table-cell;">-</td>';
						continue;
					}
					$test .= '<td class="blockrow" style="display: table-cell;"><div style="padding-bottom: 10px;">'.$brow['opp']['userhtml'].'</div>'.$brow['result'].'</td>';
				}
				$test .= '</tr>';
				
				
				$templater = vB_Template::create('tmnt_ind_sched');
					$templater->register('tmntp', $tmntp);
					$templater->register('tmnt', $tmnt);
					$templater->register('bhtml', $bhtml);
					$templater->register('blocksubhead', $blocksubhead);
					$templater->register('userinfo', $userinfo);
				//$tmnt['rr2'] .= $templater->render();
			}
			$test .= '</table>';
			$tmnt['rr2_alt'] = $test;
			//print_r($test);
			//exit;
			foreach ($p_array AS $playerid => $userinfo)
			{
				if ($userinfo[roundwins])
				{
					$userinfo[roundwins] = $userinfo[roundwins] / 2;
				}
				else
				{
					$userinfo[roundwins] = 0;
				}
				if ($userinfo[roundloses])
				{
					$userinfo[roundloses] = $userinfo[roundloses] / 2;
				}
				else
				{
					$userinfo[roundloses] = 0;
				}
				$index = $userinfo[roundwins] - $userinfo[roundloses];
				$scarray[] = array(
					'index' => $index + 1000000,
					'pd' => $userinfo['pd'] + 1000000,
					'playerid' => $playerid,
					'userinfo' => $userinfo,
				);
				/*$templater = vB_Template::create('tmnt_rr_comp_alt');
					$templater->register('tmnt', $tmnt);
					$templater->register('tmntp', $tmntp);
					$templater->register('blockrow', $blockrow);
					$templater->register('blocksubhead', $blocksubhead);
					$templater->register('userinfo', $userinfo);
				$tmnt['rr4'][$index] .= $templater->render();*/
			}
			require("includes/class_tll_sort.php"); 
			$srt = new arr_multisort(); 
				$srt->setArray($scarray); 
				$srt->sort(); 
				$srt->addColumn("index",SRT_DESC); 
				$srt->addColumn("pd",SRT_DESC); 
			$scarray = $srt->sort(); 
			$tmnt['rr3'] .= '	<table class="blockbody formcontrols" style="min-width: 350px;"><tr> <td '.$blocksubhead.'></td>			<td '.$blocksubhead.'>'.$vbphrase['tmnt_wins_short'].'</td>			<td '.$blocksubhead.'>'.$vbphrase['tmnt_loses_short'].'</td>		<td '.$blocksubhead.' title="'.$vbphrase['ladder_pointsdifference'].'">'.$vbphrase['ladder_pointsdifference_short'].'</td>		</tr>';
			$s12 = 0;
			foreach ($scarray AS $scplayerid => $scbl)
			{
				$s12++;
				$tmnt['rr2_alt'] = str_replace('{place_'.$scbl['playerid'].'}', process_position($s12), $tmnt['rr2_alt']);
				if ($scbl['userinfo']['userid']==0)
				{
					continue;
				}
				$templater = vB_Template::create('tmnt_rr_comp_alt');
					$templater->register('tmnt', $tmnt);
					$templater->register('tmntp', $tmntp);
					$templater->register('blockrow', $blockrow);
					$templater->register('blocksubhead', $blocksubhead);
					$templater->register('userinfo', $scbl['userinfo']);
				$tmnt['rr4'] .= $templater->render();//[$index]
			}
			$tmnt['rr3'] .= $tmnt['rr4'].'</table>';
			//<h2 class="blockhead">'.$vbphrase['tmnt_results'].'</h2>
			/*$jxr = 35;
			while ($jxr > -35)
			{
				$tmnt['rr3'] .= $tmnt['rr4'][$jxr];
				$jxr--;
			}*/
		}
	}
	if (in_array($type, array($vbphrase['tmnt_lms'], $vbphrase['tmnt_race'])))
	{
		$sql_order_by = 'score ';
		if ($vbphrase['tmnt_lms'] == $type && $tmnt['lms_rounds']>1)
		{
			for ($li = 1; $li <= $tmnt['lms_rounds']; $li++)
			{
				$tmnt['rounds_hdr_raw'] .= '<td class="blocksubhead" style="display: table-cell;">'.construct_phrase($vbphrase['tmnt_round_x'], $li).($tmnt['roundtext']?"<br /><span style=\"font-weight: normal;\">".$tmnt['roundtext']["$li"]."</span>":"").'</td>';
			}
			$tmnt['rounds_hdr_raw'] .= '<td class="blocksubhead" style="display: table-cell;">'.construct_phrase($vbphrase['tmnt_total']).'</td>';
			
			$cmpts_mysql_select .= ', (players.score + players.round2 + players.round3 + players.round4 + players.round5 + players.round6 + players.round7 + players.round8 + players.round9) AS total ';
			$cmpts_group_by .= 'GROUP BY players.id';
			$sql_order_by = 'total ';
		}
		$templater = vB_Template::create('tmnt_cmptlms_top');
			$templater->register('tmnt', $tmnt);
			$templater->register('tmntp', $tmntp);
			$templater->register('type', $type);
		$competitors .= $templater->render();
		$rowno = 0;
		switch ($type)
		{
			case $vbphrase['tmnt_lms']:
				$sql_order_by .= $tmnt['lms_order'];
				break;
			case $vbphrase['tmnt_race']:
				$sql_order_by = 'position ASC';
				break;
		}
		$cmpts = $vbulletin->db->query_read("
			SELECT players.*, players.username AS sname,
			" . ($team ? "user.teamname AS username, user.teamid" : "user.username AS username, user.userid") . "
			" . (!$team ? ", user.avatarrevision AS avatarrevision, avatar.avatarpath AS avatarpath, NOT ISNULL(customavatar.userid) AS hascustom, customavatar.dateline AS avatardateline, customavatar.width AS avwidth, customavatar.height AS avheight, user.username AS username" : ", user.teamlogo AS avatarurl") . "
			$cmpts_mysql_select
			FROM " . TABLE_PREFIX . "tmnt_players AS players
			" . ($team ? "LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS user ON (players.userid = user.teamid)" : "LEFT JOIN " . TABLE_PREFIX . "user AS user ON (players.userid = user.userid)") . "
			" . (!$team ? "LEFT JOIN " . TABLE_PREFIX . "avatar AS avatar ON(avatar.avatarid = user.avatarid) LEFT JOIN " . TABLE_PREFIX . "customavatar AS customavatar ON(customavatar.userid = user.userid) " : "") . "
			
			WHERE tid = '$id'
			$cmpts_group_by
			ORDER BY $sql_order_by
			
		");
		while ($cmpt = $vbulletin->db->fetch_array($cmpts))
		{
			$cmpt = process_tl_avatar($cmpt);
			$avatarlp = $cmpt['avatarlp'];
			$cmpt['time2'] = "<span class=\"smallfont\">".vbdate($vbulletin->options['dateformat'],$cmpt['time'], 0)." <span class=\"time\"> ".vbdate($vbulletin->options['timeformat'],$cmpt['time'])."</span></span>";
			$cmpt['time'] = " ".vbdate($vbulletin->options['dateformat'],$cmpt['time'], 1)." ".vbdate($vbulletin->options['timeformat'],$cmpt['time'])." ";
			$var = $cmpt['userid'];
			$array = array_merge((array)$var, $array);
			if ($vbphrase['tmnt_lms'] == $type && $tmnt['lms_rounds']>1)
			{
				for ($li = 1; $li <= $tmnt['lms_rounds']; $li++)
				{
					if ($li==1)
					{
						$aa = "score";
					}
					else
					{
						$aa = "round$li";
					}
					$cmpt['rounds_row_raw'] .= '<td class="blockrow" style="display: table-cell;">'.$cmpt["$aa"].'</td>';
					//$cmpt['total'] += $cmpt["$aa"];
				}
				$cmpt['rounds_row_raw'] .= '<td class="blockrow" style="display: table-cell;">'.$cmpt["total"].'</td>';
				$score = $cmpt['total'];
			}
			else
			{
				$score = $cmpt['score'];
			}
			if ($cmpt['username'] == '')
			{
				$cmpt['username'] = $cmpt['sname'];
			}
			if ($rowno == 0) {
				$topscore = $score;
				$lastscore_score = $topscore;
				$lastscore_row = 1;
			}
			if ($cmpt['winner'] == 1 OR ($topscore == $score && $tmnt['type'] == $vbphrase['tmnt_lms'])) {
				$var2 = $cmpt['userid'];
				$winnerlist = array_merge((array)$var2, $winnerlist);
				$winnernames = array_merge((array)$cmpt['username'], $winnernames);
			}
			$rowno ++;
			if ($score == $lastscore_score AND $rowno != 1) {
				$cmpt['row'] = $lastscore_row ."=";
			} else {
				$lastscore_row = $rowno;
				$lastscore_score = $score;
				$cmpt['row'] = $rowno;
			}
			$cmpt['userhtml'] = tll_userhtml($cmpt, $team);
			if (!$team && $cmpt['userid'] == $vbulletin->userinfo['userid'] && $cmpt['checkedin'] > 0)
			{
				$vbulletin->userinfo['checkedin'] = $cmpt['checkedin'];
			}
			if (TIMENOW > $tmnt['date'] && !$cmpt['checkedin'] && $tmnt['checkin'])
			{
				process_full_tmnt($id, 1);
				$vbulletin->url = "tournaments.php?do=view&id=".$id;	
				eval(print_standard_redirect('redirect_updatetmnt'));
			}
			$cmpt['position_text'] = process_position($cmpt['position']);
			$templater = vB_Template::create('tmnt_cmptlms');
				$templater->register('tmnt', $tmnt);
				$templater->register('tmntp', $tmntp);
				$templater->register('type', $type);
				$templater->register('tid', $tid);
				$templater->register('cmpt', $cmpt);
				$templater->register('score', $score);
				$templater->register('topscore', $topscore);
				$templater->register('rowno', $rowno);
			$competitors .= $templater->render();
		}
		if ($rowno == 0)
		{
			$competitors = $vbphrase['tmnt_nocmpts'];
		}
		else
		{
			$templater = vB_Template::create('tmnt_cmptlms_bot');
			$templater->register('tmnt', $tmnt);
			$templater->register('rowno', $rowno);
			$competitors .= $templater->render();
		}
	}
	$canjoin = true;
	if (in_array($thisuserid, $array))
	{ 
		$canjoin = false;
		$is_competitor = true;
	}
		if ($tmntp['cancomment'] AND $archive != 1)
		{
			require_once(DIR . '/includes/functions_editor.php');
			$show['wysiwyg'] = is_wysiwyg_compatible();
			if ($vbulletin->options['simpleversion'] < 414)
			{
				$editorid = construct_edit_toolbar('', 0, 'nonforum', ($foruminfo['allowsmilies'] ? 1 : 0), 1, false, 'qr', '', array());
			}
			else
			{
				$editorid = construct_edit_toolbar('', 0, 0, 1, 1,0,'qr');
			}
			$templater = vB_Template::create('tmnt_addcomment');
				$templater->register('tmnt', $tmnt);
				$templater->register('show', $show);
				$templater->register('tid', $tid);
				$templater->register('editorid', $editorid);
				$templater->register('messagearea', $messagearea);
			$addcomment .= $templater->render();
		}
		if ($vbulletin->options[simpleversion] >= 370)
		{
			$thumb = true;
		}
		else
		{
			$thumb = false;
		}
		if ($noofcomments > 0)
		{
		$comments = $vbulletin->db->query_read("
			SELECT comments.*, comments.comment AS comment, comments.userid AS userid, comments.username AS username, comments.time AS time, comments.ed_userid AS ed_userid, comments.ed_username AS ed_username, comments.ed_time AS ed_time, comments.ed_ip AS ed_ip, user.avatarrevision AS avatarrevision, avatar.avatarpath AS avatarpath, NOT ISNULL(customavatar.userid) AS hascustom, customavatar.dateline AS avatardateline, customavatar.width AS avwidth, customavatar.height AS avheight " . ($thumb ? ", customavatar.width_thumb AS width_thumb, customavatar.height_thumb AS height_thumb" : "") . "
			FROM " . TABLE_PREFIX . "tmnt_comments AS comments
			LEFT JOIN " . TABLE_PREFIX . "user AS user
				ON (comments.userid = user.userid)
			LEFT JOIN " . TABLE_PREFIX . "avatar AS avatar
				ON (avatar.avatarid = user.avatarid)
			LEFT JOIN " . TABLE_PREFIX . "customavatar AS customavatar
				ON (customavatar.userid = user.userid)
			WHERE comments.tid=$id 
			ORDER BY comments.id ASC
			LIMIT $offset, $cpp
		");
		while($comment = $vbulletin->db->fetch_array($comments))
		{
			if (!empty($comment['avatarpath']))
			{
				$comment['avatarurl'] = $comment['avatarpath'];
				$comment['avwidth'] = getimagesize($comment['avatarurl']);
				$comment['avheight'] = $comment['avwidth']['1'];
				$comment['avwidth'] = $comment['avwidth']['0'];
				if ($comment['avwidth'] > 60)
				{
					$comment['avratio'] = $comment['avwidth']/60;
					$comment['avatarwidth'] = $comment['avwidth']/$comment['avratio'];
					$comment['avatarheight'] = $comment['avheight']/$comment['avratio'];
				}
			} else if ($comment['hascustom']) {
				$avatarurl = array('hascustom' => 1);
				if ($vbulletin->options['usefileavatar']) {
					$comment['avatarurl'] = $vbulletin->options['avatarurl'] . ($thumb ? '/thumbs' : '') . "/avatar{$comment['userid']}_{$comment['avatarrevision']}.gif";
				} else {
					$comment['avatarurl'] = "image.php?u=$comment[userid]&amp;dateline=$comment[avatardateline]" . ($thumb ? '&amp;type=thumb' : '') ;
				}
			}
			if ($comment['round'] && $comment['players'])
			{
				list($comment['u1'], $comment['u2']) = explode('_',$comment['players']);
				if (!$tmnt['pot'])
				{
					$comment['u1info'] = fetch_userinfo($comment['u1']);
					$comment['u2info'] = fetch_userinfo($comment['u2']);
				}
				else
				{
					$comment['u1info'] = fetch_teaminfo($comment['u1']);
					$comment['u1info']['username'] = $comment['u1info']['teamname'];
					$comment['u2info'] = fetch_teaminfo($comment['u2']);
					$comment['u2info']['username'] = $comment['u2info']['teamname'];
				}
			}
			if ($thumb)
			{
				if ($comment['width_thumb'] AND $comment['height_thumb']) {
					$avatarwidth = $comment['width_thumb'];
					$avatarheight = $comment['height_thumb'];
				}
			}
			else
			{
				$avatarwidth = $comment['avwidth'];
				$avatarheight = $comment['avheight'];
			}
			if (empty($comment['avatarurl'])) {
				$comment['avatarurl'] = vB_Template_Runtime::fetchStyleVar('imgdir_misc') . '/unknown.gif';
			}
			$id = $comment['id'];
			$comment_userid = $comment['userid'];
			if (in_array($comment_userid, $array)) {
				$comper = true;
			} else {
				$comper = false;
			}
			if (in_array($comment_userid, $winnerlist)) {
				$winner = true;
			} else {
				$winner = false;
			}
			$comment['date'] = vbdate($vbulletin->options['dateformat'],$comment['time'], 1);
			$comment['time'] = vbdate($vbulletin->options['timeformat'],$comment['time']);
			//$show['detailedtime'] = true;
			$comment['ed_time'] = vbdate($vbulletin->options['timeformat'],$comment['ed_time']).$vbphrase['ladder_on'].vbdate($vbulletin->options['dateformat'],$comment['ed_time'], 1);
			$comment['comment'] = $bbcode_parser->do_parse($comment['comment'],false,true,true,true,true,false);
			if ($tmntp['candelcomment'] OR ($tmntp['candelowncomment'] AND ($comment_userid == $thisuserid))) {
				$comment_delete = true;
			} else {
				$comment_delete = false;
			}
			$templater = vB_Template::create('tmnt_comment');
				$templater->register('tmnt', $tmnt);
				$templater->register('tmntp', $tmntp);
				$templater->register('comment_delete', $comment_delete);
				$templater->register('comment_userid', $comment_userid);
				$templater->register('comment', $comment);
				$templater->register('comper', $comper);
				$templater->register('winner', $winner);
				$templater->register('team', $team);
				$templater->register('comper', $comper);
				$templater->register('id', $id);
				$templater->register('tid', $tid);
				$templater->register('show', $show);
			$commentlists .= $templater->render();
		} }
	$perpage = $vbulletin->options['tmnt_cpp'];
	$pagenav = construct_page_nav($page, $perpage, $noofcomments, "tournaments.php" . $tmnt['url'] . "&amp;sh=4", "", "comments");
	$pagenav = str_replace($tmnt['url']."&amp;sh=4#", $tmnt['url']."&amp;sh=4&amp;page=1#", $pagenav);
	if ($noofcomments == 0)
	{
		$templater = vB_Template::create('tmnt_nocomments');
		$commentlists .= $templater->render();
	}
	elseif (!IS_MOBILE_STYLE)
	{
		$commentlists = '<ol id="message_list" style="padding-top: 10px; padding-right: 10px; padding-left: 10px;">'.$commentlists.'</ol>';
	}
	if ($tmnt['threadid'])
	{
		$posts = $vbulletin->db->query_read("
		SELECT
			post.*, post.username AS postusername, post.ipaddress AS ip, IF(post.visible = 2, 1, 0) AS isdeleted,
			user.*, 
			postparsed.pagetext_html, postparsed.hasimages,
			IF(displaygroupid=0, user.usergroupid, displaygroupid) AS displaygroupid, infractiongroupid,
			user.avatarrevision AS avatarrevision, avatar.avatarpath AS avatarpath, NOT ISNULL(customavatar.userid) AS hascustom, customavatar.dateline AS avatardateline, customavatar.width AS avwidth, customavatar.height AS avheight " . ($thumb ? ", customavatar.width_thumb AS width_thumb, customavatar.height_thumb AS height_thumb" : "") . "
		FROM " . TABLE_PREFIX . "post AS post
		LEFT JOIN " . TABLE_PREFIX . "user AS user
			ON(user.userid = post.userid)
		LEFT JOIN " . TABLE_PREFIX . "avatar AS avatar
			ON(avatar.avatarid = user.avatarid)
		LEFT JOIN " . TABLE_PREFIX . "customavatar AS customavatar 
			ON(customavatar.userid = user.userid)
		LEFT JOIN " . TABLE_PREFIX . "postparsed AS postparsed 
			ON(postparsed.postid = post.postid AND postparsed.styleid = 1 AND postparsed.languageid = 1)
		WHERE post.threadid = '$tmnt[threadid]'
			AND post.visible != 2
		ORDER BY post.dateline
		LIMIT 1, 12
		");
		$post_array = array();
		$post_i = 0;
		while($post = $vbulletin->db->fetch_array($posts))
		{
			if ($post_i < 10)
			{
				if(!$post['pagetext_html'])
				{
					$bbcode_parser = new vB_BbCodeParser($vbulletin, fetch_tag_list(), true); 
					$post['pagetext_html'] = $bbcode_parser->do_parse($post['pagetext']);
				}
				if (!empty($post['avatarpath']))
				{
					$post['avatarurl'] = $post['avatarpath'];
					$post['avwidth'] = getimagesize($post['avatarurl']);
					$post['avheight'] = $post['avwidth']['1'];
					$post['avwidth'] = $post['avwidth']['0'];
					if ($post['avwidth'] > 60)
					{
						$post['avratio'] = $post['avwidth']/60;
						$post['avatarwidth'] = $post['avwidth']/$post['avratio'];
						$post['avatarheight'] = $post['avheight']/$post['avratio'];
					}
				} else if ($post['hascustom']) {
					$avatarurl = array('hascustom' => 1);
					if ($vbulletin->options['usefileavatar']) {
						$post['avatarurl'] = $vbulletin->options['avatarurl'] . ($thumb ? '/thumbs' : '') . "/avatar{$post['userid']}_{$post['avatarrevision']}.gif";
					} else {
						$post['avatarurl'] = "image.php?u=$post[userid]&amp;dateline=$post[avatardateline]" . ($thumb ? '&amp;type=thumb' : '') ;
					}
				}
				if ($thumb)
				{
					if ($post['width_thumb'] AND $post['height_thumb']) {
						$avatarwidth = $post['width_thumb'];
						$avatarheight = $post['height_thumb'];
					}
				}
				else
				{
					$avatarwidth = $post['avwidth'];
					$avatarheight = $post['avheight'];
				}
				if (empty($post['avatarurl'])) {
					$post['avatarurl'] = vB_Template_Runtime::fetchStyleVar('imgdir_misc') . '/unknown.gif';
				}
				$post['date'] = vbdate($vbulletin->options['dateformat'], $post['dateline'], 1);
				$post['time'] = vbdate($vbulletin->options['timeformat'], $post['dateline']);
				$show['detailedtime'] = true;
				$post_array[] = $post;
			}
			else
			{
				$show['more_posts'] = true;
			}
			$post_i++;
		}
	}
	if ($vbulletin->options['tmnt_showrules'])
	{
		$query_rules = $vbulletin->db->query_first("
			SELECT rules
			FROM " . TABLE_PREFIX . "tmnt_rules
		");
		$bbcode_parser = new vB_BbCodeParser($vbulletin, fetch_tag_list()); 
		$tmnt['genrules'] = $bbcode_parser->do_parse($query_rules['rules']);
	}
	if (!in_array($_REQUEST['sh'], array(1,2,3,4,5,6,7,10,11,12,13,14,15)))
	{
		/*if ($tmnt['status'] == $vbphrase['tmnt_finished'] AND $tmnt['type'] == $vbphrase['tmnt_de'] && $tmnt['noplayers'] == 4)
		{
			$sh = 1;
		}
		else*/ if ($tmnt['status'] == $vbphrase['tmnt_waiting'] OR $showcomps OR in_array($tmnt['type'], array($vbphrase['tmnt_lms'], $vbphrase['tmnt_race'])) OR $tmnt['hide_brackets'])
		{
			$sh = 2;
		}
		elseif ($tmnt['status'] != $vbphrase['tmnt_waiting'] AND in_array($tmnt['type'], array($vbphrase['tmnt_1v1'], $vbphrase['tmnt_de'], $vbphrase['tmnt_groupplay'], $vbphrase['tmnt_swiss'])))
		{
			$sh = 3;
		}
		elseif (in_array($tmnt['type'], array($vbphrase['tmnt_rr'], $vbphrase['tmnt_drr'])) && $tmnt['status'] != $vbphrase['tmnt_waiting'])
		{
			$sh = 1;
		}
		elseif (in_array($tmnt['type'], array($vbphrase['tmnt_rr'], $vbphrase['tmnt_drr'])) && $tmnt['status'] == $vbphrase['tmnt_waiting'])
		{
			$sh = 2;
		}
		else
		{
			$sh = 4;
		}
	}
	else
	{
		$sh = $vbulletin->input->clean_gpc('g', 'sh', TYPE_UINT);
	}
	if ($tmntp['admintickets'])
	{
		$ticket_count = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_tickets WHERE tmntid = '$tid' AND closed = 0 ");
		if ($ticket_count['countrows'])
		{
			$tmnt['open_support_tickets_link'] = '<a href="tll_tickets.php?tmntid=' . $tid . '" class="button" style="color: #FF0000; padding: 4px; border-color: #FF0000;">' . $ticket_count['countrows'] . ' Open Support Tickets</a>';
		}
	}
	$headinclude = activate_tooltips($headinclude);
	if ($vbulletin->options['tmnt_navleft'])
	{
		require_once(DIR . '/includes/functions_tll_sidebar.php');
		if ($tmnt['status'] == $vbphrase['tmnt_waiting'] && ($team OR $canjoin))
		{
			$nlcontent .= '<p><a href="tournaments.php?do=join&amp;id='.$tmnt['id'].'">'.$vbphrase['tmnt_join'].'</a></p>';
		}
		if ($tmnt['nextinfo'])
		{
			$nlcontent .= '<p><a href="tournaments.php?do=submitresult&amp;tid='.$tmnt['id'].'" class="tllpopup">'.$vbphrase['tmnt_submitresult'].'</a></p>';
		}
		if ($tmnt['type'] == $vbphrase['tmnt_rr'])
		{
			$nlcontent .= '<p><a href="tournaments.php'.$tmnt['url'].'&amp;sh=2" onclick="return switch_sh(\'sh_2\')">'.$vbphrase['tmnt_schedule'].'</a></p>';
		}
		if ($tmntp['canedittmnt'])
		{
			$nlcontent .= '<p><a href="tournaments.php?do=admin&amp;tid='.$tmnt['id'].'" class="tllpopup">'.$vbphrase['tmnt_edit'].'</a></p>';
		}
		$template_hook['tmnt_navleft_top'] .= tll_sidebar_block($tmnt['title'], $nlcontent, $tmnt['url'], 'tmnt_'.$tid);
	}
	($hook = vBulletinHook::fetch_hook('tll_tmnt_display_pretemplate')) ? eval($hook) : false;
	$templater = vB_Template::create('tmnt_display');
		$templater->register('commentlists', $commentlists);
		$templater->register('competitors', $competitors);
		$templater->register('results', $results);
		$templater->register('brackets', $brackets);
		$templater->register('showcomps', $showcomps);
		$templater->register('tmnt', $tmnt);
		$templater->register('tmntp', $tmntp);
		$templater->register('id', $id);
		$templater->register('sh', $sh);
		$templater->register('tid', $tid);
		$templater->register('title', $title);
		$templater->register('post_array', $post_array);
		$templater->register('topscore', $topscore);
		$templater->register('title2', $title2);
		$templater->register('pagenav', $pagenav);
		$templater->register('addcomment', $addcomment);
		$templater->register('canjoin', $canjoin);
		$templater->register('edited', $edited);
		$templater->register('team', $team);
		$templater->register('is_competitor', $is_competitor);
		$templater->register('winnernames', $winnernames);
		$templater->register('template_hook', $template_hook);
	$tlhtml .= $templater->render();
	$navbits = array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'tournaments.php?' . $vbulletin->session->vars['sessionurl_q'] => construct_phrase($vbphrase[tmnts]),
		
	);
	if ($tmnt['parenttitle'])
	{
		$navbits['tournaments.php' . $tmnt['parenturl']] = $tmnt['parenttitle'];
	}
	$navbits['tournaments.php' . $tmnt['categoryurl']] = $tmnt['categorytitle'];
	$navbits[] = construct_phrase($title);
	$navbar = render_navbar_template(construct_navbits($navbits));
	/*$templater = vB_Template::create('memberinfo_css');
	$memberinfo_css = $templater->render();*/
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_tmnts SET views = views + 1 WHERE id=$id");
	if ($team) {
		$tlhtml = str_replace("playerstats", "viewteam", $tlhtml);
	}
	if ($_REQUEST['bracketsonly'] || $_REQUEST['embed'])
	{
		$tlhtml = $brackets.$loserbrackets;
		$navbar = $footer = $header = '';
		$vbulletin->options['tmnt_navtop'] = $vboptions['tmnt_navtop'] = $vboptions['tmnt_navleft'] = $show['scrolling_announcements'] = $vboptions['tmnt_active'] = 0;
		$vbulletin->options['tmnt_disablecopyright'] = 1;
		$vboptions['tmnt_navleftbanner']='';
		$tmntp = 0;
		$vbulletin->options['tmnt_navleft'] = 0; 
		$vboptions['tmnt_navleft'] = 0;
	}
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	$templater->register('template_hook', $template_hook);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'])
{
	$_REQUEST['do'] = '';
}

// #############################################################################

if (empty($_REQUEST['do']))
{
	if (!$tmntp['canviewtmnt'])
	{
		print_no_permission();
	}
	$rawfilter = $filter = $vbulletin->input->clean_gpc('g', 'filter', TYPE_UINT);
	$filterss = " AND status=". $filter;
	switch ($filter)
	{
		case 1:
			$filter = $vbphrase['tmnts'] . " " . $vbphrase['tmnt_waiting'];
			break;
		case 2:
			$filter = $vbphrase['tmnts'] . " " . $vbphrase['tmnt_inprogress'];
			break;
		case 3: 
			$filter = $vbphrase['tmnt_finished'] . " " . $vbphrase['tmnts'];
			break;
		default:
			$filterss = $rawfilter = $filter = "";
	}
	$sort = $vbulletin->input->clean_gpc('g', 'sort', TYPE_NOHTML);
	$allsorts = array('title', 'date', 'type', 'pot', 'noplayers', 'views', 'status', 'spaces', 'username');
	if (!in_array($sort, $allsorts))
	{
		$sort = 'id';
	}
	$type = $vbulletin->input->clean_gpc('g', 'type', TYPE_NOHTML);
	$alltypes = array('de', '1v1', 'LMS', 'rr', 'drr', 'race', 'groupplay', 'swiss');
	if (!in_array($type, $alltypes))
	{
		$type = '';
	}
	$c = $vbulletin->input->clean_gpc('g', 'c', TYPE_UINT);
	if (!$c && $vbulletin->options['tmnt_seo'] && $vbulletin->options['tmnt_premium'] && isset($_SERVER['REQUEST_URI']))
	{
		$thisurl = end(explode('/',$vbulletin->input->clean($_SERVER['REQUEST_URI'], TYPE_NOHTML)));
		if (substr($thisurl, 0, 16)=='tournaments.php?' && strlen($thisurl)>16)
		{
			$c = $vbulletin->input->clean(substr($thisurl,16), TYPE_UINT);
		}
	}
	$f2 = $vbulletin->input->clean_gpc('g', 'f2', TYPE_NOHTML);
	if ($f2==='0' OR $f2 === '1')
	{
		$filterss .= " AND pot = ". $f2;
	}
	$filename = 'tournaments';
	if ($vbulletin->tll_catcache)
	{
		foreach ($vbulletin->tll_catcache AS $cindex => $cat)
		{
			if ((!in_array('tmnts',$cat['tol']) OR ($c && $cat['parentid'] != $c)) && !$carray["$cat[catid]"])
			{
				continue;
			}
			$templater = vB_Template::create('tmnt_cat');
				$templater->register('cat', $cat);
				$templater->register('tmntp', $tmntp);
				$templater->register('type', $type);
				$templater->register('rawfilter', $rawfilter);
				$templater->register('c', $c);
				$templater->register('filename', $filename);
			if (!$c && $cat['parentid'])
			{
				$carray["$cat[parentid]"] .= $templater->render();
			}
			else
			{
				$templater->register('subcs', $carray["$cat[catid]"]);
				$categories .= $templater->render();
			}
		}
	}
	$order = $vbulletin->input->clean_gpc('g', 'order', TYPE_NOHTML);
	$allorders = array('ASC', 'DESC');
	if (!in_array($order, $allorders))
	{
		$order = 'ASC';
	}
	$selected = array();
	$selected['sort']["$sort"] = 'selected="selected"';
	$selected['filter']["$rawfilter"] = 'selected="selected"';
	$selected['order']["$order"] = 'selected="selected"';
	$selected['type']["$type"] = 'selected="selected"';
	$reverse = tmntrevurl($c, $order, $sort, $rawfilter, $type);
	$sortbaseurl = "tournaments.php?" . ($c ? "c=$c&amp;" : "") . ($type ? "type=$type&amp;" : "") . ($rawfilter ? "filter=$rawfilter&amp;" : "") . "order=ASC&amp;sort=";
	$tmnts = $vbulletin->db->query_first("
		SELECT COUNT(*) AS countrows
		FROM " . TABLE_PREFIX . "tmnt_tmnts AS tmnts
		WHERE tmnts.catid = '$c' $filterss
			" . ($type ? "AND tmnts.type = '$type' " : "") . "
	");
	$cinfo = $vbulletin->tll_catcache["$c"];
	if ($cinfo['parsed_banner'])
	{
		$cinfo['banner'] = $cinfo['parsed_banner'];
	}
	elseif ($cinfo['banner'])
	{
		require_once(DIR . '/includes/class_bbcode.php');
		$bbcode_parser = new vB_BbCodeParser($vbulletin, fetch_tag_list(), true); 
		$cinfo['banner'] = $bbcode_parser->do_parse($cinfo['banner']);
	}
	$tmnts = $tmnts['countrows'];
	$perpage = 10;
	$lastpage = ceil($tmnts/$perpage);
	$page = $vbulletin->input->clean_gpc('g', 'page', TYPE_UINT);
	if ($page > $lastpage)
	{
		$page = $lastpage;
	}
	if (!$page OR $page == 0)
	{
		$page = 1;
	}
	$offset = ($page - 1) * $perpage;
	$from = $offset + 1;
	if ($lastpage == $page)
	{
		$to = $noofteams;
	}
	else 
	{
		$to = $page * $perpage;
	}
	if ($noofteams == 0)
	{
		$from = 0;
		$to = 0;
	}
	//right block
	//tournament comments
	$cinfo['tol'] = array('tmnts');
	$csh = 'tc';
	$tcarray = array();
	$comments = $vbulletin->db->query_read("
		SELECT c.*, t.title AS tmnttitle
		FROM " . TABLE_PREFIX . "tmnt_comments AS c
		LEFT JOIN " . TABLE_PREFIX . "tmnt_tmnts AS t
			ON (t.id = c.tid)
		WHERE t.catid = '$c'
		ORDER BY c.time DESC
		LIMIT 0, 15
	");
	$maxl = $vbulletin->options['tmnt_fp_com_cml'];
	while($comment = $vbulletin->db->fetch_array($comments))
	{
		$comment['tmnturl'] = tll_seo('tmnt', $comment['tid'], $comment['tmnttitle']);
		$comment['comment'] = remove_bbcode($comment['comment']);
		if (strlen($comment['comment']) > $maxl)
		{
			$comment['comment'] = substr($comment['comment'], 0, $maxl)."<a href=\"tournaments.php?do=view&amp;id=".$comment['tid']."&amp;sh=4#vmessage".$comment['id']."\">...</a>";
		}
		$tcarray["$comment[id]"] = $comment;
		$show['comments'] = true;
		$show['comments_tc']++;
	}
	$templater = vB_Template::create('tmnt_fpblock_comments');
		$templater->register('tmntp', $tmntp);
		$templater->register('mcarray', $mcarray);
		$templater->register('tcarray', $tcarray);
		$templater->register('show', $show);
		$templater->register('cinfo', $cinfo);
		$templater->register('csh', $csh);
	$template_hook['tmntlist_right'] .= $templater->render();
	//tmnt winners
	$parray = array();
	$players = $vbulletin->db->query_read("
		SELECT p.*, t.title AS ttitle
		FROM " . TABLE_PREFIX . "tmnt_players AS p
		LEFT JOIN " . TABLE_PREFIX . "tmnt_tmnts AS t
			ON (t.id = p.tid)
		WHERE p.winner = 1
		ORDER BY p.id DESC
		LIMIT 0, 5
	");
	while($player = $vbulletin->db->fetch_array($players))
	{
		$player['tmnturl'] = tll_seo('tmnt', $player['tid'], $player['ttitle']);
		if ($player['pot'])
		{
			$player['teamurl'] = tll_seo('team', $player['userid'], $player['username']);
		}
		$parray[] = $player;
	}
	$templater = vB_Template::create('tmnt_fpblock_twins');
		$templater->register('tmntp', $tmntp);
		$templater->register('parray', $parray);
	$template_hook['tmntlist_right'] .= $templater->render();
	//end right block
	$pagenav = construct_page_nav($page, $perpage, $tmnts, "tournaments.php?" . $vbulletin->session->vars['sessionurl'] . "c=$c&amp;type=$type", "&amp;filter=$rawfilter&amp;sort=$sort&amp;order=$order", "");
	$rowcount = 0;
	$tmnts = $vbulletin->db->query_read("
		SELECT tmnts.*, cats.title AS categorytitle, cats2.title AS categorytitle2, cats2.title AS parenttitle, cats.parentid AS parentid, cats.icon AS caticon
		FROM " . TABLE_PREFIX . "tmnt_tmnts AS tmnts
		LEFT JOIN " . TABLE_PREFIX . "tmnt_categories AS cats
			ON tmnts.catid = cats.catid
		LEFT JOIN " . TABLE_PREFIX . "tmnt_categories AS cats2
			ON cats.parentid = cats2.catid
		WHERE tmnts.catid = '$c' $filterss
			" . ($type ? "AND tmnts.type = '$type'" : "") . "
		ORDER BY tmnts.sticky DESC, tmnts.$sort $order
		LIMIT $offset, 10
	");
	while($tmnt = $vbulletin->db->fetch_array($tmnts))
	{
		if ($rowcount == 0)
		{
			$categorytitle = $tmnt['categorytitle'];
			$parentcategorytitle = $tmnt['parenttitle'];
			$parentcategoryid = $tmnt['parentid'];
			if (!$categorytitle && $categories)
			{
				$categorytitle = $vbphrase[tmnt_uncat_tmnts];
			}
			elseif (!$categorytitle)
			{
				$categorytitle = $vbphrase[tmnts];
			}
			$templater = vB_Template::create('tmnt_list_top');
				$templater->register('tmnt', $tmnt);
				$templater->register('tmntp', $tmntp);
				$templater->register('sort', $sort);
				$templater->register('selected', $selected);
				$templater->register('sortbaseurl', $sortbaseurl);
				$templater->register('reverse', $reverse);
				$templater->register('c', $c);
				$templater->register('cinfo', $cinfo);
				$templater->register('filter', $filter);
				$templater->register('categorytitle', $categorytitle);
				$templater->register('categories', $categories);
				$templater->register('rowcount', $rowcount);
				$templater->register('template_hook', $template_hook);
			$tlhtml .= $templater->render();
		}
		$sticky = $tmnt['sticky'];
		$tmnt['players'] = $tmnt['noplayers'] - $tmnt['freeslots'];
        $description = preg_replace('/\[(.*?)\]/is', '', $tmnt['description']);
		$descriptionlength = strlen($description);
		if ($descriptionlength > $vbulletin->options['tmnt_desclength'])
		{
			$description = substr($description, 0, $vbulletin->options['tmnt_desclength']);
			$description = $description . '...';
		}
		$tmnt['dateline'] = "<span>".vbdate($vbulletin->options['dateformat'], $tmnt['date'])/*." <br /> <span class=\"time\">".vbdate($vbulletin->options['timeformat'], $tmnt['date'])."</span>"*/."</span>";
		$tmnt = switch_tmnt_status($tmnt);
		
		if ($tmnt['pot'])
		{
			$tmnt['pot'] = $vbphrase['tmnt_team'];
		}
		else
		{
			$tmnt['pot'] = "";
		}
		$tmnt = switch_tmnt_type($tmnt);
		$tmnt['url'] = tll_seo('tmnt', $tmnt['id'], $tmnt['title']);
		$templater = vB_Template::create('tmnt_list'.($vbulletin->options['tmnt_premium']?'_dynamic':''));
			$templater->register('sort', $sort);
			$templater->register('filter', $filter);
			$templater->register('tmnt', $tmnt);
			$templater->register('tmntp', $tmntp);
			$templater->register('description', $description);
			$templater->register('rowcount', $rowcount);
			$templater->register('sticky', $sticky);
		$tlhtml .= $templater->render();
		$rowcount ++;
	}
	$headinclude .= "\r\n<link rel=\"stylesheet\" type=\"text/css\" href=\"clientscript/tll_dynamic.css\" />";
	if ($rowcount == 0)
	{
		if ($c)
		{
			$categorytitle = $cinfo['title'];
			$parentcategorytitle = $cinfo['parenttitle'];
			$parentcategoryid = $cinfo['parentid'];
			if (!$categorytitle)
			{
				$errormessage = $vbphrase[error_invalid_category];
				eval(standard_error($errormessage));
			}
		}
		else
		{
			$categorytitle = $vbphrase[tmnt_uncat_tmnts];
		}
		$templater = vB_Template::create('tmnt_list_top');
			$templater->register('tmnt', $tmnt);
			$templater->register('reverse', $reverse);
			$templater->register('tmntp', $tmntp);
			$templater->register('sort', $sort);
			$templater->register('c', $c);
			$templater->register('selected', $selected);
			$templater->register('filter', $filter);
			$templater->register('sortbaseurl', $sortbaseurl);
			$templater->register('categorytitle', $categorytitle);
			$templater->register('categories', $categories);
			$templater->register('rowcount', $rowcount);
			$templater->register('template_hook', $template_hook);
		$tlhtml .= $templater->render();
		if (!$categories)
		{
			$templater = vB_Template::create('tmnt_notmnts');
				$templater->register('tmnt', $tmnt);
				$templater->register('filter', $filter);
				$templater->register('tmntp', $tmntp);
				$templater->register('categorytitle', $categorytitle);
				$templater->register('rowcount', $rowcount);
			$tlhtml .= $templater->render();
		}
	}
	$templater = vB_Template::create('tmnt_list_bot');
		$templater->register('rowcount', $rowcount);
		$templater->register('tmntp', $tmntp);
		$templater->register('categories', $categories);
		$templater->register('c', $c);
		$templater->register('pagenav', $pagenav);
	$tlhtml .= $templater->render();
	$navbits = array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'tournaments.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase[tmnts]
	);
	if ($parentcategoryid)
	{
		$x = 'tournaments.php' . $vbulletin->session->vars['sessionurl_q'] . "?c=$parentcategoryid";
		$navbits["$x"] = $parentcategorytitle;
	}
	$navbits[''] = $categorytitle;
	$navbits = construct_navbits($navbits);
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

?>