<?php
/*======================================================================*\
|| #################################################################### ||
|| # vBGamEz 4.0.4 LITE
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2008-2009 GiveMeABreak. All Rights Reserved.            ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBGAMEZ IS NOT FREE SOFTWARE ------------------ # ||
|| # http://vbgamez.cyber-worlds.cn | http://cyber-worlds.cn          # ||
|| #################################################################### ||
\*======================================================================*/

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'vbgamez');
define('CSRF_PROTECTION', true);

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array('posting',
                      'search',
                      'user',
                      'vbgamez',
                      'inlinemod',
                      'threadmanage',
                      'forumdisplay');

// get special data templates from the datastore
$specialtemplates = array();

// pre-cache templates used by specific actions
$globaltemplates = array(
	   'vbgamez_detalis_tabbed',
	   'vbgamez_link_navbar',
	   'vbgamez_listbits',
	   'vbgamez_listservers',
	   'vbgamez_sortarrow',
           'vbgamez_emptyservers');


// ######################### REQUIRE BACK-END ############################

require_once('./global.php');
require_once(DIR . '/includes/functions_user.php');
require_once(DIR . '/includes/adminfunctions.php');
require_once(DIR . '/includes/functions_editor.php');

require_once(DIR . '/vb/vb.php');
require_once(DIR . '/vb/phrase.php');
vB::init(false);

require_once(DIR . '/packages/vbgamez/datastore.php');
require_once(DIR . '/packages/vbgamez/core.php');
require_once(DIR . '/packages/vbgamez/functions.php');

// ############################# vBGamEz START ENGINE #####################

 $vbulletin->options['vbgamez_fullpath'] = $vbulletin->options['bburl']."/".$vbulletin->options['vbgamez_scriptname'];

 if (empty($_REQUEST['do']))  
 { 
     $_REQUEST['do'] = 'allservers';
 }

 if (!$vbulletin->options['vbgamez_enable'] AND $vbulletin->userinfo['usergroupid'] != '6') 
 { 
   standard_error(fetch_error('vbgamez_closed'));
 }

if($_REQUEST['do'] == 'view')
{

	$vbulletin->input->clean_array_gpc('r', array(
		'id' 	=> TYPE_INT));

  $vbulletin->GPC['id'] = intval($vbulletin->GPC['id']);

  $lookup = vB_vBGamez::vbgamez_verify_id($vbulletin->GPC['id']);

  if (!$lookup)
  {
    exec_header_redirect('' . $vbulletin->options['vbgamez_fullpath'] . '?' . $vbulletin->session->vars['sessionurl'] . "");
  }

  $server = vB_vBGamez::vBG_Datastore_Cache($lookup['ip'], $lookup['q_port'], $lookup['c_port'], $lookup['s_port'], $lookup['type'], "sep", $lookup);

  $misc   = vB_vBGamez::vbgamez_server_misc($server);
  $server = vB_vBGamez::vbgamez_server_html($server);
  $connectlink = vbgamez_software_link($lookup['type'], $lookup['ip'], $lookup['c_port'], $lookup['q_port'], $lookup['s_port']);

  $server['o']['id'] = $lookup['id'];
  $server['i']['views'] = intval($lookup['views']);
  $server['i']['userid'] = intval($lookup['userid']);
  $server['i']['id'] = intval($lookup['id']);

  $vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "vbgamez SET views = views +1 WHERE id = " . $vbulletin->GPC['id'] . "");

  if (!$server['p'])
  {
    $show['players'] = false;

  }else{

    $bgclasses = array('vbgamez_table_lrSubHeader vbgamez_table_gridliner_tr', 'vbgamez_table_gridliner_tr');
    $bgcolornum = 0; 

    $bgclasses_bits = array('vbgamez_table_lrSRow vbgamez_table_gridliner_td', 'vbgamez_table_lrSRow vbgamez_table_gridliner_td');
    $bgcolornum_bits = 0; 

      foreach ($server['p'] as $player_key => $player)
      {
        $bgclassnum = 1 - $bgclassnum;
        $bgclass = $bgclasses[$bgclassnum]; 

        $bgclassnum_bits = 1 - $bgclassnum_bits;
        $bgclass_bits = $bgclasses_bits[$bgclassnum_bits]; 

        $playerfields = '';

        foreach (vB_vBGamez::fetch_player_fields($server) as $field_key => $field)
        {
           $playerfields[] = $player[$field];
        }

        $templater = vB_Template::create('vbgamez_playersbits');
        $templater->register('player', $player);
        $templater->register('playerfields', $playerfields);
        $templater->register('bgclass', $bgclass);
        $templater->register('bgclass_bits', $bgclass_bits);
        $players .= $templater->render();

      }    

    $show['players'] = true;
  }

  foreach (vB_vBGamez::fetch_player_fields($server) as $field_key => $field)
  {
         $headfields[] = vB_vBGamez::fetch_player_fields_names($field);
  }

  $navbits['' . $vbulletin->options['vbgamez_fullpath'] . '?' . $vbulletin->session->vars['sessionurl'] . ''] = $vbphrase['vbgamez'];
  $navbits['' . $vbulletin->options['vbgamez_fullpath'] . '?' . $vbulletin->session->vars['sessionurl'] . 'do=view&id=' . $vbulletin->GPC['id'] . ''] = $vbphrase['vbgamez_view_server']." ".$server['s']['name'];

  $templater = vB_Template::create('vbgamez_detalis_tabbed');

  $navbits = construct_navbits($navbits);
  $navbar = render_navbar_template($navbits);
  $templater->register_page_templates();
  $templater->register('navbar', $navbar);
  $templater->register('listbits', $listbits);
  $templater->register('page', $vbulletin->GPC['page']);
  $templater->register('total', $total);
  $templater->register('oppositesort', $oppositesort);
  $templater->register('pagenumber', $pagenumber);
  $templater->register('perpage', $perpage);
  $templater->register('sortfield', $sortfield);
  $templater->register('sorturl', $sorturl);
  $templater->register('reloadurl', $reloadurl);
  $templater->register('sortarrow', $sortarrow);
  $templater->register('pagenav', $pagenav);
  $templater->register('server', $server);
  $templater->register('misc', $misc);
  $templater->register('headfields', $headfields);
  $templater->register('players', $players);
  $templater->register('connectlink', $connectlink);
  $templater->register('lookup', $lookup);
  $templater->register('info', $info);
  print_output($templater->render());

}

// ############################# LIST GAME SERVERS #####################
if ($_REQUEST['do'] == 'allservers')
{

  $perpage = $vbulletin->input->clean_gpc('r', 'perpage', TYPE_UINT);
  $pagenumber = $vbulletin->input->clean_gpc('r', 'pagenumber', TYPE_UINT);
  $sortfield = $vbulletin->input->clean_gpc('r', 'sortfield', TYPE_NOHTML);
  $sortorder = $vbulletin->input->clean_gpc('r', 'sortorder', TYPE_NOHTML);

  $perpage = vB_vBGamez::sanitize_perpage($perpage, 20, $vbulletin->options['vbgamez_allservers_count']);

  if (!$pagenumber)
  {
	$pagenumber = 1;
  }

  $limitlower = ($pagenumber - 1) * $perpage + 1;
  $limitupper = $pagenumber * $perpage;

  $pos = ($pagenumber - 1) * $perpage;

  if ($sortorder == 'desc')
  {
	$sortorder = 'asc';
        $oppositeorder = 'desc';
  }
  else
  { 
	$sortorder = 'desc';
        $oppositeorder = 'asc';
  }

  if(empty($sortfield))
  {
          $sortfield = $vbulletin->options['vbgamez_sort_server'];
  }

  switch ($sortfield)
  {
	case 'id':
		$sqlsort = 'vbgamez.id';
		break;
	case 'name':
		$sqlsort = 'vbgamez.cache_name';
		break;
	case 'game':
		$sqlsort = 'vbgamez.cache_game';
		break;
	case 'comments':
		$sqlsort = 'vbgamez.comments';
		break;
	case 'map':
		$sqlsort = 'vbgamez.cache_map';
		break;
	case 'players':
		$sqlsort = 'vbgamez.cache_players';
		break;
	case 'views':
		$sqlsort = 'vbgamez.views';
		break;
	case 'rating':
		$sqlsort = 'vbgamez.rating';
		break;
	default:
		$sqlsort = 'rating';
                $sortfield = 'rating';
  }

  $reloadurl = ($perpage != 20 ? "pp=$perpage&amp;" : '') .
	($pagenumber != 1 ? "page=$pagenumber&amp;" : '') .
	($sortfield != 'username' ? "sort=$sortfield&amp;" : '')."order=".$oppositeorder;

  $reloadurl = preg_replace('#&amp;$#s', '', $reloadurl);

  if (!empty($reloadurl))
  {
	$reloadurl = '' . $vbulletin->options['vbgamez_fullpath'] . '?' . $vbulletin->session->vars['sessionurl'] . $reloadurl;
  }
  else
  {
	$reloadurl = '' . $vbulletin->options['vbgamez_fullpath'] . '' . $vbulletin->session->vars['sessionurl_q'];
  }

  $sorturl = '' . $vbulletin->options['vbgamez_fullpath'] . '?' . $vbulletin->session->vars['sessionurl'] . '';
  
  $sorturl = preg_replace('#&amp;$#s', '', $sorturl);
  $reloadurl = str_replace('&amp;', '&', $reloadurl);

  $templater = vB_Template::create('vbgamez_sortarrow');
	$templater->register('sortorder', $sortorder);
	$templater->register('pagenumber', $pagenumber);
	$templater->register('perpage', $perpage);
	$templater->register('sortfield', $sortfield);
	$templater->register('sorturl', $sorturl);
  $sortarrow[$sortfield] = $templater->render();

  $sort = array($sortfield => 'selected="selected"');
  $order = array($oppositeorder => 'selected="selected"');

  $server_list = vB_vBGamez::vBG_Datastore_Cache_all("s");
  $total = vB_vBGamez::vbgamez_cached_totals();

  $server = array();

  foreach ($server_list as $server)
    {

          $misc   = vB_vBGamez::vbgamez_server_misc($server);
          $server = vB_vBGamez::vbgamez_server_html($server);

          $connectlink = vbgamez_software_link($server['b']['type'], $server['b']['ip'], $server['b']['c_port'], $server['b']['q_port'], $server['b']['s_port']);

          $templater = vB_Template::create('vbgamez_listbits');
          $templater->register('server', $server);
          $templater->register('connectlink', $connectlink);
          $templater->register('misc', $misc);
       $listbits .= $templater->render(); 
    }

  if(empty($listbits))
  {
         $show['listbits'] = false;

         $emptybits = vB_Template::create('vbgamez_emptyservers')->render();
  }else{
         $show['listbits'] = true;
         $emptybits = '';
  }

  $pagenav = construct_page_nav($pagenumber, $perpage, $total['servers'], '' . $vbulletin->options['vbgamez_fullpath'] . '?' . $vbulletin->session->vars['sessionurl'] . 'sort=' . $sortfield . '&amp;order=' . $oppositeorder . '&amp;pp=' . $perpage . '');

  $navbits = array('' . $vbulletin->options['vbgamez_fullpath'] . '' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['vbgamez']);

  $templater = vB_Template::create('vbgamez_listservers');

  $navbits = construct_navbits($navbits);
  $navbar = render_navbar_template($navbits);
  $templater->register_page_templates();
  $templater->register('navbar', $navbar);
  $templater->register('listbits', $listbits);
  $templater->register('total', $total);
  $templater->register('sortorder', $sortorder);
  $templater->register('pagenumber', $pagenumber);
  $templater->register('perpage', $perpage);
  $templater->register('sortfield', $sortfield);
  $templater->register('sorturl', $sorturl);
  $templater->register('reloadurl', $reloadurl);
  $templater->register('sortarrow', $sortarrow);
  $templater->register('pagenav', $pagenav);
  $templater->register('sort', $sort);
  $templater->register('order', $order);
  $templater->register('emptybits', $emptybits);
  print_output($templater->render());

}


?>